#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example()
If @error = 2 Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; 3D COLUMN: Without legend, with data table
; Requires arrays for $DataName and $DataRange
; *****************************************************************************
Global $Graph_position = "=_XLChart_Example!A8:F26"
Global $XValueRange = "=_XLChart_Example!R2C1:R6C1"
Global $DataRange[3] = [2, "=_XLChart_Example!R2C2:R6C2", "=_XLChart_Example!R2C3:R6C3"]
Global $DataName[3] = [2, "=_XLChart_Example!B1", "=_XLChart_Example!C1"]
Global $oChart = _XLChart_ChartCreate($aExcel[0], "_XLChart_Example", $xl3DColumn, $Graph_position, "", $XValueRange, $DataRange, $DataName, False, "Sales", "Date", "Location", "Quantity")
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartCreate' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; 3D PYRAMID COLUMN: With legend
; Requires arrays for $DataName and $DataRange
; *****************************************************************************
$Graph_position = "H8:M26"
$oChart = _XLChart_ChartCreate($aExcel[0], 1, $xlPyramidCol, $Graph_position, "", $XValueRange, $DataRange, $DataName, False, "Sales", "Date", "", "Quantity")
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartCreate' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; 3D STACKED AREA: Without legend
; *****************************************************************************
$Graph_position = "A28:F46"
$oChart = _XLChart_ChartCreate($aExcel[0], "_XLChart_Example", $xl3DAreaStacked, $Graph_position, "", $XValueRange, $DataRange, $DataName, True, "Sales", "Date")
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartCreate'! on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 4
; OPEN-HIGH-LOW-CLOSE Chart
; *****************************************************************************
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "Date", "N28")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "02/24/2012", "N29")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "02/23/2012", "N30")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "02/22/2012", "N31")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "02/21/2012", "N32")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "02/17/2012", "N33")
$aExcel[0].ActiveSheet.Columns(14).AutoFit
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "Open", "O28")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "68.682", "O29")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.342", "O30")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.203", "O31")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.204", "O32")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.485", "O33")
$aExcel[0].ActiveSheet.Columns(15).AutoFit
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "High", "P28")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "68.826", "P29")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.375", "P30")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.463", "P31")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.364", "P32")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.598", "P33")
$aExcel[0].ActiveSheet.Columns(16).AutoFit
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "Low", "Q28")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "68.263", "Q29")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "68.654", "Q30")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.085", "Q31")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "68.891", "Q32")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.251", "Q33")
$aExcel[0].ActiveSheet.Columns(17).AutoFit
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "Close", "R28")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "68.403", "R29")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "68.882", "R30")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.307", "R31")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "68.135", "R32")
_Excel_RangeWrite($aExcel[0].Activeworkbook, Default, "69.450", "R33")
$aExcel[0].ActiveSheet.Columns(18).AutoFit
$Graph_position = "H28:M46"
$XValueRange = "=_XLChart_Example!29R2C14:R33C14"
Global $DataRange[5] = [4, "=_XLChart_Example!R29C15:R33C15", "=_XLChart_Example!R29C16:R33C16", "=_XLChart_Example!R29C17:R33C17", "=_XLChart_Example!R29C18:R33C18"]
Global $DataName[5] = [4, "=_XLChart_Example!O1", "=_XLChart_Example!P1", "=_XLChart_Example!Q1", "=_XLChart_Example!R1"]
Global $oChart1 = _XLChart_ChartCreate($aExcel[0], 1, $xlStockOHLC, $Graph_position, "", $XValueRange, $DataRange, $DataName, Default, "Open-High-Low-Close Chart")
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartCreate'! on line " & @ScriptLineNumber)
; Format chart
_XLChart_FillSet($oChart1.Chartgroups(1).UpBars, -4)	; Set the UpBars to green
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartCreate' on line " & @ScriptLineNumber)
_XLChart_FillSet($oChart1.Chartgroups(1).DownBars, -3)	; Set the DownBars to red
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartCreate' on line " & @ScriptLineNumber)
_XLChart_ColumnGroupSet($oChart1.ChartGroups(1), 250)	; Make the bars smaller (by making the gap between the bars bigger)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartCreate' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 5
; 3D EXPLODED PIE: With legend. Create the chart on a separate chart sheet
; *****************************************************************************
MsgBox(16, "Excel Chart Example Script", "Now creating a pie chart on a separate chart sheet!" & @CRLF & "Please press enter!")
$XValueRange = "=_XLChart_Example!R2C1:R6C1"
$DataRange = "=_XLChart_Example!R2C2:R6C2"
$DataName = "=_XLChart_Example!B1"
Global $Title = _Excel_RangeRead($aExcel[0].Activeworkbook, Default, "B1")
$oChart = _XLChart_ChartCreate($aExcel[0], 1, $xl3DPieExploded, 0, "Example Chart", $XValueRange, $DataRange, $DataName, True, $Title)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartCreate' on line " & @ScriptLineNumber)