#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 0, 0, 6)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Delete a chartsheet
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now deleting ..." & @CRLF & "ChartSheet")
_XLChart_ChartDelete($aExcel[0], $aExcel[4])
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartDelete' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Delete an embedded chart
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now deleting ..." & @CRLF & "Chart 2 on sheet '_XLChart_Example'")
_XLChart_ChartDelete($aExcel[0], $aExcel[2])
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartDelete' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Delete an embedded chart by name
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now deleting ..." & @CRLF & "Chart 3 on sheet '_XLChart_Example' by name")
_XLChart_ChartDelete($aExcel[0], $aExcel[3].Name)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartDelete' on line " & @ScriptLineNumber)