#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 6, -1, -1, -1)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Export chart 1 as GIF type to @TempDir\Export1.gif
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Chart 1: Now exporting the chart as GIF to @TempDir\Export1.gif ...")
Global $aResult = _XLChart_ChartExport($aExcel[1], @TempDir & "\Export1.gif", "GIF", False, True)
If @error <> 0 Then MsgBox(16, "Excel Chart Example Script", "@TempDir\Export1.gif could not be created! @Error: " & @error & " on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Export chart sheet as JPG type to @TempDir\Export2.jpg
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Chart Sheet: Now exporting the chart sheet as JPG to @TempDir\Export2.jpg ...")
$aResult = _XLChart_ChartExport($aExcel[2], @TempDir & "\Export2.jpg", "JPEG", False, True)
If @error <> 0 Then MsgBox(16, "Excel Chart Example Script", "@TempDir\Export2.jpg could not be created! @Error: " & @error & " on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Export chart 1 as PDF to @TempDir\Export1.pdf
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Chart 1: Now exporting the chart as PDF to @TempDir\Export1.pdf ...")
$aResult = _XLChart_ChartExport($aExcel[1], @TempDir & "\Export1.pdf", "PDF", False, True)
If @error <> 0 Then MsgBox(16, "Excel Chart Example Script", "@TempDir\Export1.pdf could not be created! @Error: " & @error & " on line " & @ScriptLineNumber)