#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 0, -1, -1)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Move chart 2 one column to the right and one row to the bottom
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Move chart 2 one column to the right and one row to the bottom")
Global $aResult = _XLChart_ChartPositionSet($aExcel[0], $aExcel[2], "I9:M27")
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartPositionSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Move chart 1 20 points to the right and 20 points to the bottom
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Move chart 1 20 points to the right and to the bottom")
$aResult = _XLChart_ChartPositionSet($aExcel[0], $aExcel[1], "", 20, 20, Default, Default, 1)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartPositionSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Move chart 2 to an absolute position and change width/height
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Move chart 2 to an absolute position and change width/height")
$aResult = _XLChart_ChartPositionSet($aExcel[0], $aExcel[2], "", 450, 100, 300, 250)
If @error Then
	MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartPositionSet' on line " & @ScriptLineNumber)
Else
	MsgBox(64, "Excel Chart Example Script", "Done")
EndIf

; *****************************************************************************
; Example 4
; Move chart 2 to an absolute position on another worksheet
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Move chart 2 to a worksheet 'Test'")
_Excel_SheetAdd($aExcel[0].ActiveWorkbook, -1, False, 1, "Test")
$aResult = _XLChart_ChartPositionSet($aExcel[0], $aExcel[2], "A1:E17", Default, Default, Default, Default, 0, "Test")
If @error Then
	MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartPositionSet' on line " & @ScriptLineNumber)
Else
	MsgBox(64, "Excel Chart Example Script", "Done")
EndIf

; *****************************************************************************
; Example 5
; Move chart 1 to a new chart sheet
; *****************************************************************************
$aExcel[0].Sheets(2).activate
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Move chart 1 to a chart sheet")
$aResult = _XLChart_ChartPositionSet($aExcel[0], $aExcel[1], "", Default, Default, Default, Default, 0, -1)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartPositionSet' on line " & @ScriptLineNumber)