#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>
#include <Misc.au3>
#include <Math.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 0, -1, -1)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Chart 1: Handle blank cells. Values are interpolated into the chart
; *****************************************************************************
$aExcel[0].Activesheet.Cells(4, 2).Value = "" ; Remove a datapoint from data series 1
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Values are interpolated into the chart")
_XLChart_ChartSet($aExcel[1], Default, 3)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Chart 1: Handle blank cells. Blanks are plotted as zero
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Blanks are plotted as zero")
_XLChart_ChartSet($aExcel[1], Default, 2)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Chart 1: Handle blank cells. Blank cells are not plotted
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Blank cells are not plotted")
_XLChart_ChartSet($aExcel[1], Default, 1)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 4
; Chart 1: Set rounded corners
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Set rounded corners")
_XLChart_ChartSet($aExcel[1], Default, Default, 1)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 5
; Apply all available chart types to chart 2
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Applying chart types")

; *****************************************************************************
; Array of all chart types
;	Chart Types $xlStockHLC, $xlStockOHLC, $xlStockVHLC and $xlStockVOHLC are not displayed in the example because they require specific arranged data.
; 	see http://office.microsoft.com/en-us/excel-help/creating-a-stock-chart-HA001117942.aspx for more details
; *****************************************************************************
Global $ChartType[70][2] = [[69, 2],[$xl3DArea, "$xl3DArea"], _
		[$xl3DAreaStacked, "$xl3DAreaStacked"], _
		[$xl3DAreaStacked100, "$xl3DAreaStacked100"], _
		[$xl3DBarClustered, "$xl3DBarClustered"], _
		[$xl3DBarStacked, "$xl3DBarStacked"], _
		[$xl3DBarStacked100, "$xl3DBarStacked100"], _
		[$xl3DColumn, "$xl3DColumn"], _
		[$xl3DColumnClustered, "$xl3DColumnClustered"], _
		[$xl3DColumnStacked, "$xl3DColumnStacked"], _
		[$xl3DColumnStacked100, "$xl3DColumnStacked100"], _
		[$xl3DLine, "$xl3DLine"], _
		[$xl3DPie, "$xl3DPie"], _
		[$xl3DPieExploded, "$xl3DPieExploded"], _
		[$xlArea, "$xlArea"], _
		[$xlAreaStacked, "$xlAreaStacked"], _
		[$xlAreaStacked100, "$xlAreaStacked100"], _
		[$xlBarClustered, "$xlBarClustered"], _
		[$xlBarOfPie, "$xlBarOfPie"], _
		[$xlBarStacked, "$xlBarStacked"], _
		[$xlBarStacked100, "$xlBarStacked100"], _
		[$xlBubble, "$xlBubble"], _
		[$xlBubble3DEffect, "$xlBubble3DEffect"], _
		[$xlColumnClustered, "$xlColumnClustered"], _
		[$xlColumnStacked, "$xlColumnStacked"], _
		[$xlColumnStacked100, "$xlColumnStacked100"], _
		[$xlConeBarClustered, "$xlConeBarClustered"], _
		[$xlConeBarStacked, "$xlConeBarStacked"], _
		[$xlConeBarStacked100, "$xlConeBarStacked100"], _
		[$xlConeCol, "$xlConeCol"], _
		[$xlConeColClustered, "$xlConeColClustered"], _
		[$xlConeColStacked, "$xlConeColStacked"], _
		[$xlConeColStacked100, "$xlConeColStacked100"], _
		[$xlCylinderBarClustered, "$xlCylinderBarClustered"], _
		[$xlCylinderBarStacked, "$xlCylinderBarStacked"], _
		[$xlCylinderBarStacked100, "$xlCylinderBarStacked100"], _
		[$xlCylinderCol, "$xlCylinderCol"], _
		[$xlCylinderColClustered, "$xlCylinderColClustered"], _
		[$xlCylinderColStacked, "$xlCylinderColStacked"], _
		[$xlCylinderColStacked100, "$xlCylinderColStacked100"], _
		[$xlDoughnut, "$xlDoughnut"], _
		[$xlDoughnutExploded, "$xlDoughnutExploded"], _
		[$xlLine, "$xlLine"], _
		[$xlLineMarkers, "$xlLineMarkers"], _
		[$xlLineMarkersStacked, "$xlLineMarkersStacked"], _
		[$xlLineMarkersStacked100, "$xlLineMarkersStacked100"], _
		[$xlLineStacked, "$xlLineStacked"], _
		[$xlLineStacked100, "$xlLineStacked100"], _
		[$xlPie, "$xlPie"], _
		[$xlPieExploded, "$xlPieExploded"], _
		[$xlPieOfPie, "$xlPieOfPie"], _
		[$xlPyramidBarClustered, "$xlPyramidBarClustered"], _
		[$xlPyramidBarStacked, "$xlPyramidBarStacked"], _
		[$xlPyramidBarStacked100, "$xlPyramidBarStacked100"], _
		[$xlPyramidCol, "$xlPyramidCol"], _
		[$xlPyramidColClustered, "$xlPyramidColClustered"], _
		[$xlPyramidColStacked, "$xlPyramidColStacked"], _
		[$xlPyramidColStacked100, "$xlPyramidColStacked100"], _
		[$xlRadar, "$xlRadar"], _
		[$xlRadarFilled, "$xlRadarFilled"], _
		[$xlRadarMarkers, "$xlRadarMarkers"], _
		[$xlSurface, "$xlSurface"], _
		[$xlSurfaceTopView, "$xlSurfaceTopView"], _
		[$xlSurfaceTopViewWireframe, "$xlSurfaceTopViewWireframe"], _
		[$xlSurfaceWireframe, "$xlSurfaceWireframe"], _
		[$xlXYScatter, "$xlXYScatter"], _
		[$xlXYScatterLines, "$xlXYScatterLines"], _
		[$xlXYScatterLinesNoMarkers, "$xlXYScatterLinesNoMarkers"], _
		[$xlXYScatterSmooth, "$xlXYScatterSmooth"], _
		[$xlXYScatterSmoothNoMarkers, "$xlXYScatterSmoothNoMarkers"]]

Global $iTT_Left = $aExcel[2].Parent.Left + 150
Global $iTT_Top = $aExcel[2].Parent.Top + 90
Global $bRunning = True
Global $iRounds = 40
For $iIndex1 = 1 To $ChartType[0][0]
	_XLChart_ChartSet($aExcel[2], $ChartType[$iIndex1][0])
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartSet' on line " & @ScriptLineNumber & @CR & "while aplying Chart Type " & $ChartType[$iIndex1][1] & " (#" & $ChartType[$iIndex1][0] & ")")
	_XLChart_TitleSet($aExcel[2].ChartTitle, "Chart Type " & $ChartType[$iIndex1][1] & " (#" & $ChartType[$iIndex1][0] & ")")
	ToolTip("Excel Chart Example Script " & $iIndex1 & " of " & $ChartType[0][0] & " (Wait = " & $iRounds / 20 & " seconds)" & @CRLF _
		& "Chart Type " & $ChartType[$iIndex1][1] & " (#" & $ChartType[$iIndex1][0] & ") has been applied." & @CRLF & @CRLF & _
		"ESC: End example script!" & @CRLF & "ARROW DOWN: Make it run faster" & @CRLF & _
		"ARROW UP: Make it run slower" & @CRLF & "ARROW LEFT: Go to previous chart type" & @CRLF & "ARROW RIGHT: Go to next chart type" & @CRLF & _
		"END: Stop the script", $iTT_Left, $iTT_Top)
	For $iIndex2 = 1 To $iRounds
		Sleep(50)
		If _IsPressed("1B") = 1 Then
			MsgBox(16, "Excel Chart Example Script", "Interrupted!")
			ExitLoop 2
		EndIf
		If _IsPressed("26") = 1 Then ; arrow up
			$iRounds += 10
			$iIndex1 = _Max(0, $iIndex1 - 1)
			ExitLoop
		EndIf
		If _IsPressed("28") = 1 Then ; arrow down
			$iRounds = _Max(10, $iRounds - 10)
			$iIndex1 = _Max(0, $iIndex1 - 1)
			ExitLoop
		EndIf
		If _IsPressed("25") = 1 Then ; arrow left
			$iIndex1 = _Max(0, $iIndex1 - 2)
			ExitLoop
		EndIf
		If _IsPressed("27") = 1 Then ExitLoop ; arrow right
		If _IsPressed("23") = 1 Then MsgBox(16, "Excel Chart Example Script", "Script has been stopped!" & @CRLF & "Press 'OK' to go on!") ; End
	Next
	$aExcel[0].Activesheet.Cells(1, 1).Select
Next
ToolTip("")