#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>
#include <Array.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 0, 0, 6)
If @error = 2 Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1: Get chart objects on active worksheet
; *****************************************************************************
$aExcel[0].ActiveWorkbook.Sheets(2).Activate ; Activate sheet 2
Global $aResult = _XLChart_ChartsGet($aExcel[0], 1, 0)
If $aResult[0][0] = 0 Then MsgBox(16, "Excel Chart Example Script", "There are no charts on the active worksheet")
If @error Then Exit MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartsGet' on line " & @ScriptLineNumber)
MsgBox(64, "Excel Chart Example Script", "There are " & $aResult[0][0] & " charts on the active worksheet")
_ArrayDisplay($aResult, "Excel Chart Example Script", "", 0, Default, "Object|Type|Name|ExcelSheet#|ExcelSheet name")

; *****************************************************************************
; Example 2: Enumerate all objects on all worksheets
; *****************************************************************************
$aResult = _XLChart_ChartsGet($aExcel[0])
If $aResult[0][0] = 0 Then MsgBox(16, "Excel Chart Example Script", "There are no charts or chart sheets on any worksheet")
If @error Then Exit MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartsGet' on line " & @ScriptLineNumber)
MsgBox(64, "Excel Chart Example Script", "There are " & $aResult[0][0] & " charts and chart sheets in the workbook")
_ArrayDisplay($aResult, "Excel Chart Example Script", "", 0, Default, "Object|Type|Name|ExcelSheet#|ExcelSheet name")

; *****************************************************************************
; Example 3
; ChartSheet 1: Set Weight and color of SeriesCollection(1)
; *****************************************************************************
$aExcel[0].ActiveWorkbook.Sheets(1).Activate ; Activate sheet 1
MsgBox(64, "Excel Chart Example Script", "Now changing chartsheet 1 ..." & @CRLF & "Change the color of the border for data series 1")
_XLChart_LineSet($aResult[1][0].SeriesCollection(1), 1, 0xFF0000)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
MsgBox(64, "Excel Chart Example Script", "Done.")

; *****************************************************************************
; Example 4
; Chart 2: Set Weight and color of SeriesCollection(1)
; *****************************************************************************
$aExcel[0].ActiveWorkbook.Sheets(2).Activate ; Activate sheet 2
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 on worksheet 2 ..." & @CRLF & "Change the color of the border for data series 1")
_XLChart_LineSet($aResult[3][0].SeriesCollection(1), 1, 0xFF0000)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
MsgBox(64, "Excel Chart Example Script", "Done.")