#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 0, 0, -1)
If @error = 2 Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)
; Change chart 1 to a column chart
_XLChart_ChartSet($aExcel[1], $xlColumnClustered)
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)
; Change chart 2 to a column chart
_XLChart_ChartSet($aExcel[2], $xlColumnClustered)
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)
; Change chart 3 to a column chart
_XLChart_ChartSet($aExcel[3], $xlColumnStacked)
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Set the gap width
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Set the gap width")
_XLChart_ColumnGroupSet($aExcel[1].ColumnGroups(1), 45, Default, True)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ColumnGroupSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Set the overlap
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Set the overlap")
_XLChart_ColumnGroupSet($aExcel[2].ChartGroups(1), Default, 50)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ColumnGroupSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Set the overlap to a negative value
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Set the overlap to a negative value")
_XLChart_ColumnGroupSet($aExcel[2].ChartGroups(1), Default, -50)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ColumnGroupSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 4
; Set series lines
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 3 ..." & @CRLF & "Set series lines")
_XLChart_ColumnGroupSet($aExcel[3].ChartGroups(1), Default, Default, True)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ColumnGroupSet' on line " & @ScriptLineNumber)
