#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, -1, -1, -1)
If @error = 2 Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Set error bars for chart 1
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Remove data series 2 and add error bars to remaining series")
; Clear some cells
_Excel_RangeWrite($aExcel[0], "", "B4:B5")
; set the error bars
_XLChart_ErrorBarSet($aExcel[1].SeriesCollection(1), $xlY, $xlMinusValues, $xlPercent, $xlNoCap, 100)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ErrorBarSet' on line " & @ScriptLineNumber)
; Set the position of the data labels
_XLChart_DatalabelSet($aExcel[1].SeriesCollection(1), Default, Default, Default, Default, Default, Default, $xlLabelPositionCenter)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_DatalabelSet' on line " & @ScriptLineNumber)
; Set series 1 to invisible
_XLChart_LineSet($aExcel[1].SeriesCollection(1), Default, Default, False, Default, Default, $xlSheetHidden)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
; Set line color for the error bar
_XLChart_LineSet($aExcel[1].SeriesCollection(1).ErrorBars, 1, 0x4A7EBB)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
; Set line color of the data label
_XLChart_LineSet($aExcel[1].SeriesCollection(1).DataLabels, 1, 0)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
; Fill the datalabel
_XLChart_FillSet($aExcel[1].SeriesCollection(1).DataLabels, 0x4A7EBB)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
; Remove the legend entry for dataseries 1
$aExcel[1].Legend.LegendEntries.Item(1).Delete()
; Set text of a point of the data label
$aExcel[1].SeriesCollection(1).Points(5).DataLabel.Text = "Test3"
$aExcel[1].SeriesCollection(1).Points(2).DataLabel.Text = "Test2"
$aExcel[1].SeriesCollection(1).Points(1).DataLabel.Text = "Test1" & @LF & "Next line"
; Move the data series for the error bars to the secondary axisgroup so the error bar can overwrite the markers
_XLChart_SeriesSet($aExcel[1].SeriesCollection(1), Default, Default, 2)
; Delete the secondary value axis
_XLChart_ObjectDelete($aExcel[1].Axes($xlValue, 2))

