#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 0, 0, 0)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Chart 1: Chart area one color gradient (dark)
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Chart area one color gradient (dark)")
_XLChart_FillSet($aExcel[1].ChartArea, -35, -17, False, $msoGradientVertical, 2, 0.1)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Chart 2: Chart area two color gradient
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Chart area two color gradient")
_XLChart_FillSet($aExcel[2].ChartArea, -35, -17, False, $msoGradientFromCorner, 2)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Chart 2: Plot area two color gradient
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Plot area two color gradient")
_XLChart_FillSet($aExcel[2].PlotArea, 0xFF00FF, 0x0000FF, False, $msoGradientDiagonalUp, 1)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 4
; Chart 1: Legend one color fill
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "legend one color fill")
_XLChart_FillSet($aExcel[1].legend, 0xFF00FF)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 5
; Chart 2: Data series 1 two color gradient
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Data series 1 two color gradient")
_XLChart_FillSet($aExcel[2].SeriesCollection(1), -3, -7, False, $msoGradientDiagonalUp, 3)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 6
; Chart 3: Data series 1 two color gradient with 50% transparency
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 3 ..." & @CRLF & "Data series 1 two color gradient with 50% transparency")
_XLChart_FillSet($aExcel[3].SeriesCollection(1), -3, -7, False, $msoGradientDiagonalUp, 1, Default, 0.5)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 7
; Chart 4: Chart walls and floor one color gradient
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 4 ..." & @CRLF & "Chart walls and floor one color gradient")
_XLChart_FillSet($aExcel[4].Walls, -17, -32, False, $msoGradientDiagonalUp, 1, .5)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
_XLChart_FillSet($aExcel[4].Floor, -17, -7, False, $msoGradientDiagonalUp, 1)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 8
; Chart 1: Chart and axis title one color gradient, 75% transparency
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Chart and axis title one color gradient, 75% transparency")
_XLChart_FillSet($aExcel[1].Charttitle, -17, -32, False, Default, Default, Default, 0.75)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
_XLChart_FillSet($aExcel[1].Axes($xlValue).AxisTitle, -17, -32, False, Default, Default, Default, 0.75)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
_XLChart_FillSet($aExcel[1].Axes($xlCategory).AxisTitle, -17, -32, False, Default, Default, Default, 0.75)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 9
; Chart 3: Back and Sidewall, solid color
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 3 ..." & @CRLF & "Back and Sidewall, solid color")
_XLChart_FillSet($aExcel[3].Backwall, 0x9999FF)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
_XLChart_FillSet($aExcel[3].Sidewall, 0x9999FF)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 10
; Chart 1: Set theme (style) 42 for the chart,
; themecolor $msoThemeColorAccent2 for the chartarea
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Set style/theme 42 and chartarea to msoThemeColorAccent2")
_XLChart_LayoutSet($aExcel[1], Default, 42)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LayoutSet' on line " & @ScriptLineNumber)
_XLChart_FillSet($aExcel[1].ChartArea, $msoThemeColorAccent2, Default, True)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)


; *****************************************************************************
; Download a bitmap for the example hereunder
; *****************************************************************************
InetGet("https://www.autoitscript.com/forum/uploads/monthly_2017_03/Michael_Melgar_LiquidArt_resize_droplet_128.thumb.jpg.4fecc7a79aca6365f780cb3fb496dda6.jpg", @TempDir & "\logo_autoit.png")
Global $sBitmap = @TempDir & "\logo_autoit.png"

; *****************************************************************************
; Example 11
; Chart 3: Set background to image
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 3 background to image..." )
_XLChart_FillSet($aExcel[3].ChartArea, Default, Default, False, Default, Default, Default, 0.36, $sBitmap)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 12
; Chart 4: Set background to tiled image
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 4 background to tiled image..." )
_XLChart_FillSet($aExcel[4].ChartArea, 0xFFFFFF, 0xFFFFFF, False, Default, Default, Default, 0.36, $sBitmap, True)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 13
; Chart 1: Set PlotArea to image
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 PlotArea background  ..." )
_XLChart_FillSet($aExcel[1].PlotArea, Default, Default, False, Default, Default, Default, Default, $sBitmap)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 14
; Chart 1: Set PlotArea background to $msoTextureFishFossil texture
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 3 PlotArea background to $msoTextureFishFossil texture function  ..." )
_XLChart_FillSet($aExcel[3].PlotArea, Default, Default, False, Default, Default, Default, Default, $msoTextureFishFossil)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)