#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>
#include <Math.au3>
#include <Misc.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 0, -1, -1)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Test all available layouts with chart 1
; *****************************************************************************
Global $iIndex = 1, $iReturn
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Applying all available layouts")
Global $iTT_Left = $aExcel[1].Parent.Left + 150
Global $iTT_Top = $aExcel[1].Parent.Top + 90
Global $bRunning = True
Global $iRounds = 40
For $iIndex1 = 1 To 11
	_XLChart_LayoutSet($aExcel[1], $iIndex1)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LayoutSet' on line " & @ScriptLineNumber & @CR & "while applying layout " & $iIndex1)
	_XLChart_TitleSet($aExcel[1].ChartTitle, "Layout " & $iIndex1)
	ToolTip("Excel Chart Example Script " & $iIndex1 & " of 11 (Wait = " & $iRounds / 20 & " seconds)" & @CRLF _
		& "Chart layout " & $iIndex1 & " has been applied." & @CRLF & @CRLF & _
		"ESC: End example script!" & @CRLF & "ARROW DOWN: Make it run faster" & @CRLF & _
		"ARROW UP: Make it run slower" & @CRLF & "ARROW LEFT: Go to previous chart type" & @CRLF & "ARROW RIGHT: Go to next chart type" & @CRLF & _
		"END: Stop the script", $iTT_Left, $iTT_Top)
	For $iIndex2 = 1 To $iRounds
		Sleep(50)
		If _IsPressed("1B") = 1 Then
			MsgBox(16, "Excel Chart Example Script", "Interrupted!")
			ExitLoop 2
		EndIf
		If _IsPressed("26") = 1 Then ; arrow up
			$iRounds += 10
			$iIndex1 = _Max(0, $iIndex1 - 1)
			ExitLoop
		EndIf
		If _IsPressed("28") = 1 Then ; arrow down
			$iRounds = _Max(10, $iRounds - 10)
			$iIndex1 = _Max(0, $iIndex1 - 1)
			ExitLoop
		EndIf
		If _IsPressed("25") = 1 Then ; arrow left
			$iIndex1 = _Max(0, $iIndex1 - 2)
			ExitLoop
		EndIf
		If _IsPressed("27") = 1 Then ExitLoop ; arrow right
		If _IsPressed("23") = 1 Then MsgBox(16, "Excel Chart Example Script", "Script has been stopped!" & @CRLF & "Press 'OK' to go on!") ; End
	Next
	$aExcel[0].Activesheet.Cells(1, 1).Select
Next
ToolTip("")

; *****************************************************************************
; Example 2
; Apply all available styles to chart 2
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Applying style")
$iTT_Left = $aExcel[2].Parent.Left + 150
$iTT_Top = $aExcel[2].Parent.Top + 90
$bRunning = True
$iRounds = 40
For $iIndex1 = 1 To 48
	_XLChart_LayoutSet($aExcel[2], Default, $iIndex1)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LayoutSet' on line " & @ScriptLineNumber & @CR & "while applying style " & $iIndex1)
	_XLChart_TitleSet($aExcel[2].ChartTitle, "Style " & $iIndex1)
	ToolTip("Excel Chart Example Script " & $iIndex1 & " of 48 (Wait = " & $iRounds / 20 & " seconds)" & @CRLF _
		& "Chart style " & $iIndex1 & " has been applied." & @CRLF & @CRLF & _
		"ESC: End example script!" & @CRLF & "ARROW DOWN: Make it run faster" & @CRLF & _
		"ARROW UP: Make it run slower" & @CRLF & "ARROW LEFT: Go to previous chart type" & @CRLF & "ARROW RIGHT: Go to next chart type" & @CRLF & _
		"END: Stop the script", $iTT_Left, $iTT_Top)
	For $iIndex2 = 1 To $iRounds
		Sleep(50)
		If _IsPressed("1B") = 1 Then
			MsgBox(16, "Excel Chart Example Script", "Interrupted!")
			ExitLoop 2
		EndIf
		If _IsPressed("26") = 1 Then ; arrow up
			$iRounds += 10
			$iIndex1 = _Max(0, $iIndex1 - 1)
			ExitLoop
		EndIf
		If _IsPressed("28") = 1 Then ; arrow down
			$iRounds = _Max(10, $iRounds - 10)
			$iIndex1 = _Max(0, $iIndex1 - 1)
			ExitLoop
		EndIf
		If _IsPressed("25") = 1 Then ; arrow left
			$iIndex1 = _Max(0, $iIndex1 - 2)
			ExitLoop
		EndIf
		If _IsPressed("27") = 1 Then ExitLoop ; arrow right
		If _IsPressed("23") = 1 Then MsgBox(16, "Excel Chart Example Script", "Script has been stopped!" & @CRLF & "Press 'OK' to go on!") ; End
	Next
	$aExcel[0].Activesheet.Cells(1, 1).Select
Next
ToolTip("")