#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 3, -1, -1)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Set chart 1: Y-axis: Weight and color, Legend: Weight, color and style
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Y-axis: Weight and color, Legend: style and color")
Global $aResult = _XLChart_LineSet($aExcel[1].Axes($xlValue), 2, -7)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
$aResult = _XLChart_LineSet($aExcel[1].Legend, 5, -27, False, $msoLineThinThin)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Set chart 1: Y-axis: Major Gridlines: Weight and dash style
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Y-Axis: Major Gridlines: Weight and dash style")
$aResult = _XLChart_LineSet($aExcel[1].Axes($xlValue).MajorGridlines, 2, Default, False, Default, $msoLineRoundDot)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Set chart 1: Chart area: Weight and color
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Chart area: Weight and color")
$aResult = _XLChart_LineSet($aExcel[1].ChartArea, 2, -7)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 4
; Set chart 2: Data serie 1: Weight and color
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Data serie 1: Weight and color")
$aResult = _XLChart_LineSet($aExcel[2].SeriesCollection(1), 5, -46, False, $msoLineThickThin)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 5
; Set chart 2: Floor and Walls: Weight and color
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Floor and Walls: Weight and color")
$aResult = _XLChart_LineSet($aExcel[2].Floor, 3, 0xCC99FF)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
$aResult = _XLChart_LineSet($aExcel[2].Walls, 3, 0xCC99FF)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 6
; Set chart 2: Sidewall and backwall: Weight and color
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Sidewall and backwall: color")
$aResult = _XLChart_LineSet($aExcel[2].sidewall, 2, 0x0000FF)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
$aResult = _XLChart_LineSet($aExcel[2].backWall, 2, 0x0000FF)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)