#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, -1, -1, -1)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Chart 1: Delete category axis title
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Deleting title from category axis")
_XLChart_ObjectDelete($aExcel[1].Axes($xlCategory).AxisTitle)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ObjectDelete' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Chart 1: Delete category axis
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Deleting category axis")
_XLChart_ObjectDelete($aExcel[1].Axes($xlCategory))
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ObjectDelete' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Chart 1: Delete chart title
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Deleting chart title")
_XLChart_ObjectDelete($aExcel[1].ChartTitle)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ObjectDelete' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 4
; Chart 1: Delete legend
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Deleting legend")
_XLChart_ObjectDelete($aExcel[1].Legend)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ObjectDelete' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 5
; Chart 1: Delete value axis major gridlines
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Delete value axis major gridlines")
_XLChart_ObjectDelete($aExcel[1].Axes($xlValue).MajorGridlines)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ObjectDelete' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 6
; Chart 1: Delete data series 1 - by number
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Delete data series 1 - by number")
_XLChart_ObjectDelete($aExcel[1].SeriesCollection.Item(1))
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ObjectDelete' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 7
; Chart 1: Delete data series 2 - by name
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Delete data series 2 - by name")
_XLChart_ObjectDelete($aExcel[1].SeriesCollection.Item("Sales Store 2"))
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ObjectDelete' on line " & @ScriptLineNumber)