#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 0, 6, -1)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Chart 2: Change width/height of plot area to absolute values
; *****************************************************************************
$aExcel[0].ActiveWorkbook.Sheets(2).Activate ; Activate sheet 2
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Change width/height of plot area only")
Global $aResult = _XLChart_ObjectPositionSet($aExcel[2].Plotarea, Default, Default, 200, 150)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartPositionSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Chart 2: Move legend 50 points from current position to the top
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Move legend")
$aResult = _XLChart_ObjectPositionSet($aExcel[2].Legend, Default, -50, Default, Default, 1)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ChartPositionSet' on line " & @ScriptLineNumber)