#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 7, 0, -1, -1)
If @error = 2 Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)
; Change chart 1 to a 2D-pie of pie chart
_XLChart_ChartSet($aExcel[1], $xlPieOfPie)
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)
; Change chart 2 to a bar of pie chart
_XLChart_ChartSet($aExcel[2], $xlBarOfPie)
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1A
; Set serieslines, gap with, secondary plot size. Display all values < 16 on the secondary plot
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Set serieslines, gap with, secondary plot size. Display all values < 16 on the secondary plot")
_XLChart_OfPieGroupSet($aExcel[1].ChartGroups(1), True, 50, 150, $xlSplitByValue, 16)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_OfPieGroupSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1B
; Set color, style and weight
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Set color, style and weight")
_XLChart_LineSet($aExcel[1].ChartGroups(1).SeriesLines, $xlMedium, 0xFF0000, False, $xlThin)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Set serieslines, gap with, secondary plot size
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Set serieslines, gap with, secondary plot size")
_XLChart_OfPieGroupSet($aExcel[2].ChartGroups(1), False, 50, 50)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_OfPieGroupSet' on line " & @ScriptLineNumber)