#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel= _XLChart_Example(True, 0, 0, 0, 0)
If @error = 2 Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1 - Doing all updates with ScreenUpdate = True
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Doing all updates with ScreenUpdate = True")
Global $iTimer = TimerInit()
_Example()
MsgBox(64, "Excel Chart Example Script", "Finished ... duration: " & Int(TimerDiff($iTimer)) & "ms")

; *****************************************************************************
; Example 2 - Doing all updates with ScreenUpdate = False
; *****************************************************************************
; Recreate the charts
$aExcel= _XLChart_Example(True, 0, 0, 0, 0)
If @error = 2 Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)
; Disable Screen updating
MsgBox(64, "Excel Chart Example Script", "Doing all updates with ScreenUpdate = False")
_XLChart_ScreenUpdateSet($aExcel[0], 0) ; Disable screen updating
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ScreenUpdateSet' on line " & @ScriptLineNumber)
$iTimer = TimerInit()
_Example()
_XLChart_ScreenUpdateSet($aExcel[0], 1) ; Re-enable screen updating
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ScreenUpdateSet' on line " & @ScriptLineNumber)
MsgBox(64, "Excel Chart Example Script", "Finished ... duration: " & Int(TimerDiff($iTimer)) & "ms")
Exit

; *****************************************************************************
; Do some updates
; *****************************************************************************
Func _Example()

	_XLChart_FillSet($aExcel[1].ChartArea, -35, -17, Default, $msoGradientVertical, 2, 0.1)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[2].ChartArea, -35, -17, Default, $msoGradientFromCorner, 2)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[2].PlotArea, 0xFF00FF, 0x0000FF, Default, $msoGradientDiagonalUp, 1)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[1].legend, 0xFF00FF)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[2].SeriesCollection(1), -3, -7, Default, $msoGradientDiagonalUp, 3)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[3].SeriesCollection(1), -3, -7, Default, $msoGradientDiagonalUp, 1, Default, 0.5)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[4].Walls, -17, -32, Default, Default, $msoGradientDiagonalUp, 1, .5)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[4].Floor, -17, -7, Default, $msoGradientDiagonalUp, 1)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[1].Charttitle, -17, -32, Default, Default, Default, 0.75)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[1].Axes($xlValue).AxisTitle, -17, -32, Default, Default, Default, 0.75)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[1].Axes($xlCategory).AxisTitle, -17, -32, Default, Default, Default, 0.75)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[3].Backwall, 0x9999FF)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)
	_XLChart_FillSet($aExcel[3].Sidewall, 0x9999FF)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FillSet' on line " & @ScriptLineNumber)

EndFunc   ;==>_Example
