#include-once
#include <ExcelChart.au3>
#include <Array.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 5, -1, -1, -1)
If @error = 2 Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

_Example1()

Exit

; *****************************************************************************
; Example 1: Add 2 dataseries to the chart
; *****************************************************************************
Func _Example1()

	; *****************************************************************************
	; Set the legend at the top
	; *****************************************************************************
	_XLChart_LegendSet($aExcel[1], $xlLegendPositionTop, Default, Default, Default, Default, True, True)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LegendSet' on line " & @ScriptLineNumber)

	; *****************************************************************************
	; add extra two extra columns of data to the sheet
	; *****************************************************************************
	MsgBox(64, "Excel Chart Example Script", "Now Adding two columns of data to the sheet")
	$aExcel[0].Activesheet.Cells(1, 4).Value = "Sales Store 3"
	$aExcel[0].Activesheet.Cells(2, 4).Value = "18"
	$aExcel[0].Activesheet.Cells(3, 4).Value = "15"
	$aExcel[0].Activesheet.Cells(4, 4).Value = "22"
	$aExcel[0].Activesheet.Cells(5, 4).Value = "23"
	$aExcel[0].Activesheet.Cells(6, 4).Value = "37"
	$aExcel[0].ActiveSheet.Columns(4).AutoFit
	$aExcel[0].Activesheet.Cells(1, 5).Value = "Sales Store 4"
	$aExcel[0].Activesheet.Cells(2, 5).Value = "26"
	$aExcel[0].Activesheet.Cells(3, 5).Value = "38"
	$aExcel[0].Activesheet.Cells(4, 5).Value = "17"
	$aExcel[0].Activesheet.Cells(5, 5).Value = "23"
	$aExcel[0].Activesheet.Cells(6, 5).Value = "48"
	$aExcel[0].ActiveSheet.Columns(5).AutoFit
	$aExcel[0].ActiveSheet.Columns(7).ColumnWidth = 4

	; *****************************************************************************
	; Add a Series 3
	; *****************************************************************************
	MsgBox(64, "Excel Chart Example Script", "Now Adding series 3 to the chart")
	Local $XValueRange = "=_XLChart_Example!A2:A6"
	Local $DataRange = "=_XLChart_Example!D2:D6"
	Local $DataName = "=_XLChart_Example!D1"
	_XLChart_SeriesAdd($aExcel[1], $XValueRange, $DataRange, $DataName)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_SeriesAdd' on line " & @ScriptLineNumber)

	; *****************************************************************************
	; Add a Series 4
	; *****************************************************************************
	MsgBox(64, "Excel Chart Example Script", "Now Adding series 4 to the chart" & @CR & " Set the Data Name to 'My Shop'")
	Local $XValueRange = "=_XLChart_Example!A2:A6"
	Local $DataRange = "=_XLChart_Example!E2:E6"
	Local $DataName = "My Shop"
	_XLChart_SeriesAdd($aExcel[1], $XValueRange, $DataRange, $DataName)
	If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_SeriesAdd' on line " & @ScriptLineNumber)
	Return 1

EndFunc   ;==>_Example1
