#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, -1, -1, -1)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Chart 1: Set data series 1 to column chart
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Set data series 1 to column chart")
_XLChart_SeriesSet($aExcel[1].SeriesCollection(1), $xlColumnClustered)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_SeriesSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Chart 1: Set data series 2 curve smoothing to true
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Set curve smoothing for data series 2")
_XLChart_SeriesSet($aExcel[1].SeriesCollection(2), Default, True)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_SeriesSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Chart 1: Set data series 2 on a secondary axis group
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Set data series 2 on a secondary axis group")
; Changes values of data series 2
$aExcel[0].Activesheet.Cells(2, 3).Value = "180"
$aExcel[0].Activesheet.Cells(3, 3).Value = "230"
$aExcel[0].Activesheet.Cells(4, 3).Value = "400"
$aExcel[0].Activesheet.Cells(5, 3).Value = "320"
$aExcel[0].Activesheet.Cells(6, 3).Value = "280"
; Set data series 2 on the secondary axis group
_XLChart_SeriesSet($aExcel[1].SeriesCollection(2), Default, Default, 2)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_SeriesSet' on line " & @ScriptLineNumber)
; Set thickness and color of the y-axes
_XLChart_LineSet($aExcel[1].Axes($xlValue), 2, -11)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
_XLChart_LineSet($aExcel[1].Axes($xlValue, 2), 2, -9)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
; Set color of the data series
_XLChart_LineSet($aExcel[1].SeriesCollection(1), Default, -11)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
_XLChart_LineSet($aExcel[1].SeriesCollection(2), Default, -9)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_LineSet' on line " & @ScriptLineNumber)
; Set color of the ticklabels
_XLChart_FontSet($aExcel[1].Axes($xlValue).Ticklabels, Default, Default, True, Default, Default, -11)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FontSet' on line " & @ScriptLineNumber)
_XLChart_FontSet($aExcel[1].Axes($xlValue, 2).Ticklabels, Default, Default, True, Default, Default, -9)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_FontSet' on line " & @ScriptLineNumber)
; Set minimum and maximul value on the secondary y-axis
_XLChart_AxisSet($aExcel[1].Axes($xlValue, 2), 150, 450)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_AxisSet' on line " & @ScriptLineNumber)