#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; Different behaviour of Excel 2007 vs Excel 2010 !!!
; Shadow of text components (like ChartTitle, Legend, etc) don't exist in 2007

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 0, -1, -1)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

Global $ixlVersion = _XLChart_Version($aExcel[0])

; *****************************************************************************
; Example 1
; Change shadow of the chart area
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Shadow of the chart area")
_XLChart_ShadowSet($aExcel[2].ChartArea, 0xFF0000, False, $msoShadowStyleOuterShadow, 10, 5, 5)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ShadowSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Change shadow of the chart title
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Shadow of the chart title")
If $ixlVersion = 12 Then $aExcel[1].ChartTitle.Format.Line.Visible = 1 ; In Excel 2007 we have to make the shadow visible by first setting the border
_XLChart_ShadowSet($aExcel[1].ChartTitle, $msoThemeColorAccent6, True, $msoShadowStyleOuterShadow, 5, 5, 5)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ShadowSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3A
; Change shadow of the Legend
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Shadow of the legend")
If $ixlVersion = 12 Then $aExcel[2].Legend.Format.Line.Visible = 1 ; In Excel 2007 we have to make the shadow visible by first setting the border
_XLChart_ShadowSet($aExcel[2].Legend, 0xFF0000, False, Default, Default, 5, 5)

; *****************************************************************************
; Example 3B
; Change shadow of the Legend
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Shadow of the legend - now with style and blur")
_XLChart_ShadowSet($aExcel[2].Legend, 0xFF0000, False, $msoShadowStyleOuterShadow, 5, 5, 5)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ShadowSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 4
; Set Green inner shadow on the plot area
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Inner shadow of the plot area")
_XLChart_ShadowSet($aExcel[1].Plotarea, 0x00FF00, False, $msoShadowStyleInnerShadow, 10, -5, 5, 0.5)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_ShadowSet' on line " & @ScriptLineNumber)