#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, -1, -1, -1)
If @error = 2 Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)
_XLChart_GridSet($aExcel[1] .Axes($xlValue), True, True) ; Set major and minor grid lines of the y-axis
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_GridSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Change tick marks on x-axis of Chart 1:
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Tickmarks for x-axis")
_XLChart_TicksSet($aExcel[1] .Axes($xlCategory), $xlTickMarkCross)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_TicksSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Change major- and minor-unit on Y-axis of Chart 1:
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Major and minor unit for y-axis")
_XLChart_TicksSet($aExcel[1] .Axes($xlValue), Default, Default, 10, 2.5)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_TicksSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Change tick label position on y-axis of Chart 1:
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Tick label position for y-axis")
_XLChart_TicksSet($aExcel[1] .Axes($xlValue), Default, Default, Default, Default, $xlTickLabelPositionHigh)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_TicksSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Change tick label spacing on x-axis of Chart 1:
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Tick label spacing for x-axis")
_XLChart_TicksSet($aExcel[1] .Axes($xlCategory), Default, Default, Default, Default, Default, 2)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_TicksSet' on line " & @ScriptLineNumber)