#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#include-once
#include <ExcelChart.au3>

; *****************************************************************************
; Create example environment
; *****************************************************************************
Global $aExcel = _XLChart_Example(True, 0, 0, -1, -1)
If @error = 2  Then Exit MsgBox(16, "Excel Chart Example Script", "The installed Excel version is not supported by this UDF!" & @CRLF & "Version must be >= 12 (Excel 2007).")
If @error <> 0 Then Exit MsgBox(16, "Excel Chart Example Script", "Error " & @error & " returned by _XLChart_Example on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 1
; Set chart title chart 1: Change text, shadow, horizontal alignment, orientation
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Set chart title, shadow, horizontal alignment, orientation to 45 degree")
Global $aResult = _XLChart_TitleSet($aExcel[1].ChartTitle, "Test Chart Title", True, Default, Default, $xlDistributed, Default, 45)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_TitleSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 2
; Change x-Axis title of chart 2: Change text, move it to position 45 in the chart area
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "X-Axis title change text, move it to position 45 in the chart area")
$aResult = _XLChart_TitleSet($aExcel[2].Axes($xlCategory).AxisTitle, "Test X-Axis Title", Default, 45)
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_TitleSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 3
; Remove chart title chart 2
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 2 ..." & @CRLF & "Removing chart title")
$aResult = _XLChart_TitleSet($aExcel[2].ChartTitle, "")
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_TitleSet' on line " & @ScriptLineNumber)

; *****************************************************************************
; Example 4
; Remove y-axis title of chart 1
; *****************************************************************************
MsgBox(64, "Excel Chart Example Script", "Now changing chart 1 ..." & @CRLF & "Removing y-axis title")
$aResult = _XLChart_TitleSet($aExcel[1].Axes($xlValue).Axistitle, "")
If @error Then MsgBox(64, "Excel Chart Example Script", "Error " & @error & " returned by function '_XLChart_TitleSet' on line " & @ScriptLineNumber)