#NoTrayIcon
#AutoIt3Wrapper_icon=ADAudit.ICO
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Description=ADAudit - Report Active Directory
#AutoIt3Wrapper_Res_Fileversion=2.0.0.0
#AutoIt3Wrapper_Res_Field=AutoIt Version|%AutoItVer%
#AutoIt3Wrapper_AU3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#Tidy_Parameters=/gd 1 /gds 1 /nsdp
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/SO
#AutoIt3Wrapper_Run_Debug_Mode=N
; ===============================================================================================================================
; Title .........: Active Directory Auditing Report
; AutoIt Version : 3.3.15.0
; Script Version : 2.0
; Language ......: English
; Description ...: Filtered report showing users and groups. If a group has no users it is not included in this report!
; Author ........: water
; Modified.......: 2015/11/14
; ===============================================================================================================================
#include <AD.au3>
#include <Array.au3>
#include <Excel.au3>
#include <Math.au3>
#include <GUIConstantsEx.au3>

Global $sAccountName, $sFQDN, $iPos, $_sOU
Global Const $msoLanguageIDUI = 0x2 ; See http://msdn.microsoft.com/en-us/library/aa170976.aspx
Global $sTitle = "ADAudit - Active Directory Report 2.0"
Global $aOverView[2][2]
Global $aGroups[1][2]
Global $aUsers[1][3]
Global $nMsg, $sSelection, $sQuery, $iError, $oExcel, $oWorkbook, $oTargetRange, $iCurrentUser, $aMemberOf, $Zf, $bFound, $aDescription, $iDim1, $iDim2
Global $aOverViewTransposed, $x, $sEXCElFunction, $aMembers, $iCurrCol, $iMaxCols
;------------------------------------------
; Excel constants
;------------------------------------------
Global Const $xlContinuous = 1, $xlVAlignTop = -4160, $xlAutomatic = -4105
; XlPaperSize Enumeration. https://msdn.microsoft.com/en-us/library/ff839964%28v=office.14%29.aspx
Global Const $xlPaperA3 = 8
; XlHAlign Enumeration. https://msdn.microsoft.com/en-us/library/ff840772%28v=office.14%29.aspx
Global Const $xlHAlignCenter = -4108 ; Center
Global Const $xlHAlignLeft = -4131 ; Left
Global Const $xlHAlignRight = -4152 ; Right
;------------------------------------------
Global $sTemp = StringSplit(@ScriptName, ".")
Global $sIniFile = $sTemp[1] & ".ini"
Global $sOU = IniRead($sIniFile, "Configuration", "OU", "")
Global $sSamAccountName = IniRead($sIniFile, "Configuration", "SamAccountName", "")
Global $sDepartment = IniRead($sIniFile, "Configuration", "Department", "")
Global $sGroup = IniRead($sIniFile, "Configuration", "Group", "")
Global $sLDAP = IniRead($sIniFile, "Configuration", "LDAP", "")
Global $sFilter = IniRead($sIniFile, "Configuration", "Filter", "")
Global $sKeepSetting = $sSamAccountName & $sDepartment & $sGroup & $sLDAP & $sFilter

#Region ### START Koda GUI section ### Form=
GUICreate($sTitle, 716, 302, 251, 112)
GUICtrlCreateLabel("Organizational Unit - OU (FQDN)", 12, 16, 155, 21)
GUICtrlSetTip(-1, "Only search the specified Organizational Unit. If not specified all OUs will be searched.")
Global $BAccountName = GUICtrlCreateButton("Find FQDN", 170, 12, 65, 21)
GUICtrlSetTip(-1, "Find Organizational Unit with a user ID, keep blank to get your own OU." & @CRLF & "You may have to tweak the resulted OU to get the most effective output list.")
Global $IOU = GUICtrlCreateInput($sOU, 241, 12, 459, 21)
GUICtrlCreateLabel("SamAccountName(s) (separator: ,)", 12, 44, 191, 21)
GUICtrlSetTip(-1, "One or multiple SamAccountNames (separated by a comma) to be searched for.")
Global $IRadio1 = GUICtrlCreateRadio("", 216, 40, 17, 21)
Global $ISamAccountName = GUICtrlCreateInput($sSamAccountName, 241, 40, 459, 21)
GUICtrlCreateLabel("Department (wildcard: *)", 12, 72, 191, 21)
GUICtrlSetTip(-1, "Lists all users with property 'Department' set to the specified string.")
Global $IRadio2 = GUICtrlCreateRadio("", 216, 68, 17, 21)
Global $IDepartment = GUICtrlCreateInput($sDepartment, 241, 68, 459, 21)
GUICtrlCreateLabel("Groupname (wildcard: *)", 12, 100, 191, 21)
GUICtrlSetTip(-1, "Processes all groups with the specified SamAccountName.")
Global $IRadio3 = GUICtrlCreateRadio("", 216, 96, 17, 21)
Global $IGroup = GUICtrlCreateInput($sGroup, 241, 96, 459, 21)
GUICtrlCreateLabel("LDAP query", 12, 128, 191, 21)
GUICtrlSetTip(-1, "Enter more complex LDAP queries here. Specify if you search for users or groups so the report will be formatted correctly.")
Global $IRadio4 = GUICtrlCreateRadio("", 216, 124, 17, 21)
Global $ILDAP = GUICtrlCreateInput($sLDAP, 241, 124, 459, 21)
GUICtrlCreateGroup("LDAP Option", 241, 148, 459, 36)
Global $ILDAPRadio1 = GUICtrlCreateRadio("query user", 248, 165, 110, 15)
GUICtrlSetState($ILDAPRadio1, $GUI_CHECKED)
Global $ILDAPRadio2 = GUICtrlCreateRadio("query groups", 375, 165, 110, 15)
GUICtrlCreateGroup("", -99, -99, 1, 1)
GUICtrlCreateLabel("Filter groups (RegExp)", 12, 194, 200, 21)
GUICtrlSetTip(-1, "Specify a regular expression to limit the groups (SamAccountNames) listed for a user.")
Global $IFilter = GUICtrlCreateInput($sFilter, 241, 190, 459, 21)
Global $IStatus = GUICtrlCreateLabel("", 241, 230, 459, 21)
Global $BOK = GUICtrlCreateButton("Process", 241, 260, 130, 33)
Global $BExit = GUICtrlCreateButton("Exit", 628, 260, 73, 33)
GUISetState(@SW_SHOW)
#EndRegion ### END Koda GUI section ###

While 1
	$nMsg = GUIGetMsg()
	Switch $nMsg
		Case $GUI_EVENT_CLOSE, $BExit
			If $sKeepSetting <> GUICtrlRead($IOU) & GUICtrlRead($ISamAccountName) & GUICtrlRead($IDepartment) & GUICtrlRead($IGroup) & GUICtrlRead($ILDAP) & GUICtrlRead($IFilter) Then
				If MsgBox($MB_YESNO, "Save settings", "Settings have been changed." & @CRLF & "Save new settings?") = $IDYES Then
					IniWrite($sIniFile, "Configuration", "OU", GUICtrlRead($IOU))
					IniWrite($sIniFile, "Configuration", "SamAccountName", GUICtrlRead($ISamAccountName))
					IniWrite($sIniFile, "Configuration", "Department", GUICtrlRead($IDepartment))
					IniWrite($sIniFile, "Configuration", "Group", GUICtrlRead($IGroup))
					IniWrite($sIniFile, "Configuration", "LDAP", GUICtrlRead($ILDAP))
					IniWrite($sIniFile, "Configuration", "Filter", GUICtrlRead($IFilter))
				EndIf
			EndIf
			Exit
		Case $BAccountName
			$sAccountName = InputBox("User Account to retrieve the OU from", "Enter the SamAccountName of a user to retrieve the OU from ("" = Current user).", @UserName, "", -1, 150)
			If Not @error Then
				_AD_Open()
				If @error Then Exit MsgBox(48, "Error", "System not in AD domain")
				If $sFQDN = "" Then
					$sFQDN = _AD_SamAccountNameToFQDN()
				Else
					$sFQDN = _AD_SamAccountNameToFQDN($sAccountName)
				EndIf
				If @error Then
					MsgBox(48, "Error", "No record returned from Active Directory. SamAccountName not found!")
				Else
					; Strip off the CN
					$iPos = StringInStr($sFQDN, ",")
					$_sOU = StringMid($sFQDN, $iPos + 1)
					GUICtrlSetData($IOU, $_sOU)
				EndIf
				_AD_Close()
			EndIf
		Case $BOK
			$sOU = GUICtrlRead($IOU)
			$sSelection = ""
			If $sOU <> "" Then $sSelection = "OU: " & $sOU & @LF
			$sSamAccountName = GUICtrlRead($ISamAccountName)
			$sDepartment = GUICtrlRead($IDepartment)
			$sGroup = GUICtrlRead($IGroup)
			$sLDAP = GUICtrlRead($ILDAP)
			$sFilter = GUICtrlRead($IFilter)
			Select
				Case GUICtrlRead($IRadio1) = $GUI_CHECKED
					If $sSamAccountName = "" Then
						MsgBox(16, $sTitle, "Input data is missing")
						GUICtrlSetState($ISamAccountName, $GUI_FOCUS)
					Else
						$sSelection = $sSelection & "SamAccountName(s): " & $sSamAccountName & @LF
						If $sFilter <> "" Then $sSelection &= "Filter: " & $sFilter
						$sTemp = StringSplit($sSamAccountName, ",")
						$sQuery = ""
						For $iCount = 1 To $sTemp[0]
							$sTemp[$iCount] = StringStripWS($sTemp[$iCount], 8)
							$sQuery = $sQuery & "(samaccountname=" & $sTemp[$iCount] & ")"
						Next
						$sQuery = "(&(objectclass=user)(|" & $sQuery & "))"
						_ProcessAD($sOU, $sQuery, $sFilter, 0)
					EndIf
				Case GUICtrlRead($IRadio2) = $GUI_CHECKED
					If $sDepartment = "" Then
						MsgBox(16, $sTitle, "Input data is missing")
						GUICtrlSetState($IDepartment, $GUI_FOCUS)
					Else
						$sSelection = $sSelection & "Department: " & $sDepartment & @LF
						If $sFilter <> "" Then $sSelection &= "Filter: " & $sFilter
						$sQuery = "(&(objectclass=user)(department=" & $sDepartment & "))"
						_ProcessAD($sOU, $sQuery, $sFilter, 0)
					EndIf
				Case GUICtrlRead($IRadio3) = $GUI_CHECKED
					If $sGroup = "" Then
						MsgBox(16, $sTitle, "Input data is missing")
						GUICtrlSetState($IGroup, $GUI_FOCUS)
					Else
						$sSelection = $sSelection & "Group: " & $sGroup & @LF
						If $sFilter <> "" Then $sSelection &= "Filter: " & $sFilter
						$sQuery = "(&(objectclass=group)(samaccountname=" & $sGroup & "))"
						_ProcessAD($sOU, $sQuery, $sFilter, 1)
					EndIf
				Case GUICtrlRead($IRadio4) = $GUI_CHECKED
					If $sLDAP = "" Then
						MsgBox(16, $sTitle, "Input data is missing")
						GUICtrlSetState($ILDAP, $GUI_FOCUS)
					Else
						$sSelection = $sSelection & "LDAP: " & $sLDAP & @LF
						If $sFilter <> "" Then $sSelection &= "Filter: " & $sFilter
						$sQuery = $sLDAP
						If GUICtrlRead($ILDAPRadio1) = $GUI_CHECKED Then
							_ProcessAD($sOU, $sQuery, $sFilter, 0) ; The LDAP statement queries users
						Else
							_ProcessAD($sOU, $sQuery, $sFilter, 1) ; The LDAP statement queries groups
						EndIf
					EndIf
				Case Else
					MsgBox(16, $sTitle, "No Radio Button selected")
			EndSelect
	EndSwitch
WEnd

Func _ProcessAD($sOU, $sQuery, $sFilter, $fTranspose)
	ReDim $aOverView[2][2]
	Local $iOverViewRow = 2, $iOverViewCol = 2
	ReDim $aGroups[1][2]
	ReDim $aUsers[1][3]
	GUICtrlSetData($IStatus, "Processing ...")
	_AD_Open()
	GUICtrlSetData($IStatus, "Processing ... Get records from AD")
	If Not $fTranspose Then
		$aUsers = _AD_GetObjectsInOU($sOU, $sQuery, 2, "sAMAccountName,displayname,memberof")
	Else
		$aGroups = _AD_GetObjectsInOU("", $sQuery, 2, "member,distinguishedname")
	EndIf
	If @error <> 0 Then
		$iError = @error
		_AD_Close()
		GUICtrlSetData($IStatus, "")
		MsgBox(16, $sTitle, "Error " & $iError & " in _AD_GetObjectsInOU processing your query: " & $sQuery)
		Return
	EndIf
	If $fTranspose Then _Transpose()
	GUICtrlSetData($IStatus, "Processing ... AD records")
	$oExcel = _Excel_Open(False)
	$oWorkbook = _Excel_BookNew($oExcel, 1) ; Create a new workbook with a single sheet
	$iMaxCols = 16384 ; Max # of columns in Excel 2007 and later
	If $oExcel.Application.Version < 12.0 Then
		If $aUsers[0][0] >= 254 Then
			GUICtrlSetData($IStatus, "")
			MsgBox(0, "Active Directory Report", "Excel before 2007 only supports 256 columns." & @CRLF & " Too many User selected! Can't display report!")
			_AD_Close()
			_Excel_Close($oExcel, False)
			Return
		Else
			$iMaxCols = 256 ; Max # of columns before Excel 2007
		EndIf
	EndIf
	$oWorkbook.ActiveSheet.Name = "Active Directory"
	For $iUser = 1 To $aUsers[0][0]
		If Mod($iUser, 10) = 0 Then GUICtrlSetData($IStatus, "Processing ... AD records (" & $iUser & " of " & $aUsers[0][0] & ")")
		If Mod($iOverViewCol, 500) = 2 Then ReDim $aOverView[UBound($aOverView, 1)][UBound($aOverView, 2) + 500] ; add 500 columns. Mod=2 includes the two fixed columns with group name and count
		$iOverViewCol = $iOverViewCol + 1
		$iCurrentUser = $iOverViewCol - 1
		$aOverView[0][$iCurrentUser] = $aUsers[$iUser][0] ; SamAccountName
		$aOverView[1][$iCurrentUser] = $aUsers[$iUser][1] ; Displayname
		$aMemberOf = StringSplit($aUsers[$iUser][2], "|") ; MemberOf
		For $iMember = 1 To $aMemberOf[0]
			; Convert FQDN to SamAccountName
			$Zf = StringSplit($aMemberOf[$iMember], ",")
			$aMemberOf[$iMember] = StringTrimLeft($Zf[1], 3)
			If $sFilter <> "" And StringRegExp($aMemberOf[$iMember], $sFilter) = 0 Then ContinueLoop ; group doesn't fit filter
			; If the group already exists in the output array then add an "X" for the current user to the groups row
			$bFound = False
			For $iCurrentMember = 2 To UBound($aOverView, 1) - 1
				If $aOverView[$iCurrentMember][0] == $aMemberOf[$iMember] Then
					$aOverView[$iCurrentMember][$iCurrentUser] = "X"
					$bFound = True
					ExitLoop
				EndIf
			Next
			If $bFound = False Then
				If Mod($iOverViewRow, 500) = 2 Then ReDim $aOverView[UBound($aOverView, 1) + 500][UBound($aOverView, 2)] ; add 500 rows. Mod=2 includes the two fixed rows with SamAccount and Displayname
				$aOverView[$iOverviewRow][0] = $aMemberOf[$iMember] ; name of group in header
				$aOverView[$iOverviewRow][$iCurrentUser] = "X"
				$iOverViewRow = $iOverViewRow + 1
			EndIf
		Next
	Next
	ReDim $aOverView[$iOverViewRow][$iOverViewCol]
	; Get all AD groups and their description
	$aDescription = _AD_GetObjectsInOU("", "(&(objectclass=group)(description=*))", 2, "sAMAccountName,description")
	$iDim1 = UBound($aOverView, 1)
	$iDim2 = _Min(UBound($aOverView, 2), $iMaxCols)
	; Copy to Excel
	GUICtrlSetData($IStatus, "Processing ... Copy to Excel")
	;	$oExcel.Calculation = $xlCalculationManual
;	$aOverViewTransposed = $oExcel.Transpose($aOverView)
	; Copy data to Excel. Taken from http://www.avdf.com/apr98/art_ot003.html
	_Excel_RangeWrite($oWorkbook, $oExcel.ActiveSheet, $aOverView)
	GUICtrlSetData($IStatus, "Processing ... Format Excel Sheet")
	; Page format = Landscape
	If $iDim2 > 33 Then $oExcel.Activesheet.PageSetup.Orientation = 2
	; Set margins to 2 Pt
	With $oExcel.ActiveSheet.PageSetup
		.LeftMargin = 2
		.RightMargin = 2
		.TopMargin = 2
		.BottomMargin = 2
		.HeaderMargin = 2
		.FooterMargin = 2
		.PrintGridLines = 1
		.Papersize = $xlPaperA3
	EndWith
	; Turn 90 degreeds
	$oExcel.Activesheet.Rows("1:2").Orientation = 90
	$oExcel.Activesheet.Range("A1:B2").Orientation = 0
	; Insert sum into column. Set language dependant Excel function (1031 = german)
	$sEXCElFunction = "=COUNTIF"
	If $oExcel.LanguageSettings.LanguageID($msoLanguageIDUI) = 1031 Then $sEXCElFunction = "=ZHLENWENN"
	; Write to column 2 the formula to calculate the number of members for the group
	$oExcel.Activesheet.Range("B3").Formula = $sEXCElFunction & '(C3:' & _Excel_ColumnToLetter($iDim2) & '3' & ';"X")'
	; Copy formula if more than one data line
	If $iDim1 > 3 Then
		$oTargetRange = $oExcel.Activesheet.Range("B4:B" & $iDim1)
		_Excel_RangeCopyPaste($oExcel.Activesheet, "B3", $oTargetRange, Default, $xlPasteFormulas)
	EndIf
	; Write to the last row the formula to calculate in how many groups the user is a member
	$oExcel.Activesheet.Range("C" & ($iDim1 + 1)).Formula = $sEXCElFunction & '(C3:C' & $iDim1 & ';"X")'
	; Copy formula if more than one data column
	If $iDim2 > 3 Then
		$oTargetRange = $oExcel.Activesheet.Range("D" & ($iDim1 + 1) & ":" & _Excel_ColumnToLetter($iDim2) & ($iDim1 + 1))
		_Excel_RangeCopyPaste($oExcel.Activesheet, "C" & ($iDim1 + 1), $oTargetRange, Default, $xlPasteFormulas)
	EndIf
	; Align cell content
	$oExcel.Activesheet.Cells.HorizontalAlignment = $xlHAlignCenter
	$oExcel.Activesheet.Columns("A").HorizontalAlignment = $xlHAlignLeft
	$oExcel.Activesheet.Columns("B").HorizontalAlignment = $xlHAlignRight
	; Set font size
	$oExcel.ActiveSheet.Cells.Font.Size = 8
	GUICtrlSetData($IStatus, "Processing ... Add description as comments")
	; Add description as comments
	If IsArray($aDescription) Then
		For $i = 2 To UBound($aOverView, 1) - 1
			For $j = 1 To $aDescription[0][0]
				If $aOverView[$i][0] == $aDescription[$j][0] Then
					$oExcel.Activesheet.Range("A" & $i + 1).AddComment.Text($aDescription[$j][1])
					ExitLoop
				EndIf
			Next
		Next
	EndIf
	; Write date/time and User to A1, selection to cell A2, vertical align top
	_Excel_RangeWrite($oWorkbook, Default, $sTitle & @LF & "created by: " & @UserName & @LF & @YEAR & "/" & @MON & "/" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC)
	_Excel_RangeWrite($oWorkbook, Default, $sSelection, "A2")
	$oExcel.Activesheet.Range("A1:B2").VerticalAlignment = $xlVAlignTop
	GUICtrlSetData($IStatus, "Processing ... Sort worksheet")
	; Sort rows. The user who is member in most groups comes first
	_Excel_RangeSort($oWorkbook, Default, $oExcel.Activesheet.Range("3:" & $iDim1).Entirerow, "B3:B" & $iDim1, $xlDescending, $xlSortNormal, $xlGuess, Default, $xlSortColumns)
	; Sort columns. The group with the most members comes first
	_Excel_RangeSort($oWorkbook, Default, $oExcel.Activesheet.Range("C1:" & _Excel_ColumnToLetter($iDim2) & $iDim1 + 1), "C" & $iDim1 + 1, $xlDescending, $xlSortNormal, $xlGuess, Default, $xlSortRows)
	; Set the pattern for every 2nd line for readability
	With $oExcel.Activesheet
		For $i = 2 To UBound($aOverView, 1) - 1
			If Mod($i, 2) = 0 Then .Range($i + 1 & ":" & $i + 1).EntireRow.Interior.ColorIndex = 15
		Next
	EndWith
	; Set the rows and colums to print on every page
	$oExcel.Activesheet.PageSetup.PrintTitleRows = "1:2"
	$oExcel.Activesheet.PageSetup.PrintTitleColumns = "A:A"
	; Draw frame for every cell
	With $oExcel.Activesheet.Cells.Borders
		.LineStyle = $xlContinuous
		.ColorIndex = $xlAutomatic
		.Weight = 1
	EndWith
	; Set all columns to "autofit"
	$oExcel.Activesheet.Columns.Autofit
	; Lock rows and colums for display
	$oExcel.Activesheet.Range("B3").Select
	$oExcel.ActiveWindow.FreezePanes = True
	$oExcel.Visible = True
	;	$oExcel.Calculation = $xlCalculationAutomatic
	_AD_Close()
	GUICtrlSetData($IStatus, "")

EndFunc   ;==>_ProcessAD

; #FUNCTION# ====================================================================================================================
; Name...........: _Transpose
; Description ...: Transposes the result of a group query so it can be displayed like a user query
; Syntax.........: _Transpose()
; Parameters ....: None
;                  The function processes the global array $aGroups (a 1 based 2D array). Format of the columns is:
;                  |0 - FQDN of all members of a group concatenated by the pipe symbol ("|")
;                  |1 - FQDN of the group
; Return values .: Global array $aUsers (a 1 based 2D array) contains the transposed $aGroups array. Format of the columns is:
;                  |0 - SamAccountName of the user
;                  |1 - DisplayName of the user
;                  |2 - FQDN of all groups the user is a member of concatenated by the pipe symbol ("|")
; Remarks .......: Even if closing the connection wasn't successfull and @error is set all used variables have been reset.
; ===============================================================================================================================
Func _Transpose()
	Local $sStatus, $sProcessing = "Processing ... Transpose array."
	Local $mUsers[] ; Map of users
	Local $mGroups[] ; Map of groups to be ignored
	; Transpose the array
	For $i = 1 To $aGroups[0][0]
		If Mod($i, 10) = 0 Then $sStatus = $sProcessing & " Group (" & $i & " of " & $aGroups[0][0] & ")"
		If StringStripWS($aGroups[$i][0], $STR_STRIPALL) = "" Then ContinueLoop ; Ignore groups with no members
		$aMembers = StringSplit($aGroups[$i][0], "|")
		For $j = 1 To $aMembers[0]
			If Mod($j, 5) = 0 Then GUICtrlSetData($IStatus, $sStatus & " Member (" & $j & " of " & $aMembers[0] & ")")
			If MapExists($mUsers, $aMembers[$j]) = False Then ; New member
				If MapExists($mGroups, $aMembers[$j]) = False Then ; Not a group to be ignored
					If _AD_GetObjectClass($aMembers[$j]) <> "user" Then
						$mGroups[$aMembers[$j]] = "Exists" ; The member is a group so add it to the list of groups to be ignored
					Else
						$mUsers[$aMembers[$j]] = $aGroups[$i][1] ; New user in the user map. Assign the group name
					EndIf
				EndIf
			Else
				$mUsers[$aMembers[$j]] = $mUsers[$aMembers[$j]] & "|" & $aGroups[$i][1] ; Add the group name to an already existing user
			EndIf
		Next
	Next
	; Create an array out of the map
	$sStatus = $sProcessing & " Create Array from Map."
	GUICtrlSetData($IStatus, $sStatus)
	Local $aUserKeys = MapKeys($mUsers)
	Local $iRows = UBound($aUserKeys, 1)
	ReDim $aUsers[$iRows + 1][UBound($aUsers, 2)]
	$aUsers[0][0] = $iRows
	$aUsers[0][1] = UBound($aUsers, 2)
	For $i = 0 To $iRows - 1
		If Mod($i, 10) = 0 Then GUICtrlSetData($IStatus, $sStatus & " User (" & $i & " of " & $iRows & ")")
		$aUsers[$i + 1][0] = _AD_FQDNToSamAccountName($aUserKeys[$i]) ; SamAccountName
		$aUsers[$i + 1][1] = _AD_FQDNToDisplayName($aUserKeys[$i]) ; SamAccountName ; StringMid($aUserKeys[$i], 4, StringInStr($aUserKeys[$i], ",") - 4) ; Displayname
		$aUsers[$i + 1][2] = $mUsers[$aUserKeys[$i]] ; Groups
	Next
	Return
EndFunc   ;==>_Transpose