#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=..\icons\qp.ico
#AutoIt3Wrapper_Outfile=..\program\quickphrase.exe
#AutoIt3Wrapper_UseUpx=y
#AutoIt3Wrapper_Run_Tidy=y
#Tidy_Parameters=/tc 4 /reel
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

;+----------------------------------------------------------+
;¦            ________        .__        __                 ¦
;¦            \_____  \  __ __|__| ____ |  | __             ¦
;¦             /  / \  \|  |  \  |/ ___\|  |/ /             ¦
;¦            /   \_/.  \  |  /  \  \___|    <              ¦
;¦            \_____\ \_/____/|__|\___  >__|_ \             ¦
;¦                   \__>  Phrase     \/     \/             ¦
;¦----------------------------------------------------------¦
;¦ Program by: Zone97                                       ¦
;¦ Written on: 10/26/2017                                   ¦
;¦ Function:   Convert short text to long phrases.          ¦
;+----------------------------------------------------------+

;+----------------------------------------------------------+
;¦ Includes                                                 ¦
;+----------------------------------------------------------+

#include <Misc.au3>
#include <Array.au3>
#include <Constants.au3>
#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstants.au3>
#include <GUIConstantsEx.au3>
#include <GUIListBox.au3>
#include <WindowsConstants.au3>
#include <GuiListView.au3>

; - Custom UDFs
#include "..\Includes\hotstring.au3"

;+----------------------------------------------------------+
;¦ GUI Options                                              ¦
;+----------------------------------------------------------+

Opt("SendKeyDelay", 0)
Opt("TrayMenuMode", 3)

OnAutoItExitRegister("_OnAutoItExit")

Dim $phrases[0], $nkeys

; - System Globals
Global $INIfile = "quickphrase.ini"
Global $GUITitle = "QuickPhrase 1.1d"
Global $sState = @SW_SHOW
Global $sShortcut = _RunFromShortcut()

;╔══════════════════════════════════════════════════════════╗
;║ Pre-startup checks                                       ║
;╚══════════════════════════════════════════════════════════╝

If IsArray($sShortcut) Then
    If $sShortcut[6] = 3 Then $sState = @SW_SHOW
    If $sShortcut[6] = 7 Then $sState = @SW_HIDE
EndIf

$xpos = IniRead(@ScriptDir & "\" & $INIfile, "WINPOS", "X-Pos", -1)
$ypos = IniRead(@ScriptDir & "\" & $INIfile, "WINPOS", "Y-Pos", -1)

If _Singleton($GUITitle, 1) = 0 Then ; -- Check that it only is ran once!
    WinActivate($GUITitle)
    Exit
EndIf

TraySetToolTip($GUITitle)

;+----------------------------------------------------------+
;¦ Start of main loop                                       ¦
;+----------------------------------------------------------+

#Region ### START Koda GUI section ### Form=
$Form1 = GUICreate($GUITitle, 600, 245, $xpos, $ypos)
$List1 = GUICtrlCreateListView("Triggers|Phrases", 10, 10, 580, 122, $LVS_SORTASCENDING + $LVS_SINGLESEL + $LVS_EX_ONECLICKACTIVATE)
$Input1 = GUICtrlCreateInput("", 10, 150, 125, 21)
$Edit1 = GUICtrlCreateEdit("", 150, 150, 440, 85, BitOR($ES_AUTOVSCROLL, $ES_WANTRETURN, $WS_VSCROLL))
GUICtrlSetData(-1, "")
$Button1 = GUICtrlCreateButton("Submit", 40, 190, 75, 25)
$Label1 = GUICtrlCreateLabel("Trigger:", 10, 134, 45, 17)
$Label2 = GUICtrlCreateLabel("Phrase:", 150, 134, 45, 17)
GUISetBkColor(0xC0C0C0, $Form1)
GUICtrlSendMsg($List1, $LVM_SETCOLUMNWIDTH, 0, 75)
GUICtrlSendMsg($List1, $LVM_SETCOLUMNWIDTH, 1, 480)
GUISetState($sState)
#EndRegion ### END Koda GUI section ###

$g_hListView = $List1

GUIRegisterMsg($WM_NOTIFY, "_WM_NOTIFY")

; - Tray menu items
$TrayMenu = TrayCreateItem("Open")
TrayCreateItem("")
$TrayExit = TrayCreateItem("Exit")
TrayItemSetState($TrayMenu, $TRAY_DEFAULT)

_SetKeys()

While 1
    $nMsg = GUIGetMsg()
    Switch $nMsg
        Case $GUI_EVENT_CLOSE
            Exit
        Case $GUI_EVENT_MINIMIZE
            WinSetState($Form1, "", @SW_HIDE)
        Case $Button1
            $newkey = GUICtrlRead($Input1)
            $newphrase = GUICtrlRead($Edit1)
            $newphrase = StringReplace($newphrase, @CRLF, "{ENTER}")
            If $newkey <> "" Then
                IniWrite(@ScriptDir & "\" & $INIfile, "PHRASES", $newkey, '"' & $newphrase & '"')
                _GUICtrlListView_DeleteAllItems($List1)
                If $newphrase = "" Then
                    IniDelete(@ScriptDir & "\" & $INIfile, "PHRASES", $newkey)
                    HotStringSet($newkey & "{SPACE}", "")
                EndIf
                _SetKeys()
            EndIf
            GUICtrlSetData($Input1, "")
            GUICtrlSetData($Edit1, "")
    EndSwitch
    Switch TrayGetMsg()
        Case $TrayMenu
            WinSetState($Form1, "", @SW_SHOWNORMAL)
            WinActivate($Form1)
        Case $TrayExit
            Exit
    EndSwitch
    Sleep(10)
WEnd

Func _Phrases($key)
    $key = StringTrimRight($key, 7)
    For $i = 1 To $nkeys
        If $key = $phrases[$i][0] Then
            $phrase = $phrases[$i][1]
            $phrase = StringTrimLeft($phrase, 1)
            $phrase = StringTrimRight($phrase, 1)
        EndIf
    Next

    $klen = StringLen($key)

    For $i = 1 To $klen + 1
        Send("{BS}")
    Next

    If StringInStr($phrase, "{tab}") Then
        $phrase = StringReplace($phrase, "!", "{!}")
        $phrase = StringReplace($phrase, "^", "{^}")
        $phrase = StringReplace($phrase, "+", "{+}")
        $phrase = StringReplace($phrase, "#", "{#}")
        Send($phrase)
    Else
        $phrase = StringReplace($phrase, "{enter}", @CRLF)
        $clip = ClipGet()
        ClipPut($phrase)
        Send("^v")
        ClipPut($clip)
    EndIf
EndFunc   ;==>_Phrases

Func _SetKeys() ;~ ;Manadar, GaryFrost, WideBoyDixon, KaFu, Malkey
    If Not FileExists(@ScriptDir & "\" & $INIfile) Then
        IniWriteSection(@ScriptDir & "\" & $INIfile, "WINPOS", "")
        IniWriteSection(@ScriptDir & "\" & $INIfile, "PHRASES", "")
    EndIf

    $phrases = IniReadSection(@ScriptDir & "\" & $INIfile, "PHRASES")
    If IsArray($phrases) Then
        $nkeys = $phrases[0][0]
        For $i = 1 To $nkeys
            HotStringSet($phrases[$i][0] & "{SPACE}", "")
            HotStringSet($phrases[$i][0] & "{SPACE}", "_Phrases")
            $ListItem = GUICtrlCreateListViewItem($i&$phrases[$i][0] & "|" & $phrases[$i][1], $List1)

            If Mod($i, 2) Then

                GUICtrlSetBkColor($ListItem, 0xCCCCCC)
            Else
                GUICtrlSetBkColor($ListItem, 0xFFFFFF)
                ConsoleWrite('@@ Debug(' & @ScriptLineNumber & ') : $i = ' & $i & @CRLF & '>Error code: ' & @error & @CRLF) ;### Debug Console
            EndIf
        Next
    EndIf
EndFunc   ;==>_SetKeys

Func _WM_NOTIFY($hWnd, $iMsg, $wParam, $lParam)
    #forceref $hWnd, $iMsg, $wParam
    Local $hWndFrom, $iIDFrom, $iCode, $tNMHDR, $hWndListView, $tInfo
    ; Local $tBuffer
    $hWndListView = $List1
    If Not IsHWnd($hWndListView) Then $hWndListView = GUICtrlGetHandle($hWndListView)

    $tNMHDR = DllStructCreate($tagNMHDR, $lParam)
    $hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
    $iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
    $iCode = DllStructGetData($tNMHDR, "Code")
    Switch $hWndFrom
        Case $hWndListView
            Switch $iCode
                Case $NM_CLICK ; Sent by a list-view control when the user clicks an item with the left mouse button
                    $tInfo = DllStructCreate($tagNMITEMACTIVATE, $lParam)
                    $sItem1 = GUICtrlRead(GUICtrlRead($List1))
                    If $sItem1 <> "" Then
                        $index = _GUICtrlListView_GetSelectedIndices($List1) + 1
                        $sItem1 = StringTrimRight($sItem1, 1) ; Will remove the pipe "|" from the end of the string
                        $sItems = StringSplit($sItem1, "|")
                        $EditKey = $sItems[1]
                        $EditPhrase = $sItems[2]
                        $EditPhrase = StringTrimLeft($EditPhrase, 1)
                        $EditPhrase = StringTrimRight($EditPhrase, 1)
                        GUICtrlSetData($Input1, $EditKey)
                        GUICtrlSetData($Edit1, $EditPhrase)
                    EndIf
            EndSwitch
    EndSwitch
    Return $GUI_RUNDEFMSG
EndFunc   ;==>_WM_NOTIFY

Func _RunFromShortcut() ;~ ;johnmcloud - 2014
    Local $tSI = DllStructCreate($tagSTARTUPINFO)
    DllCall('kernel32.dll', 'none', 'GetStartupInfoW', 'struct*', $tSI)
    If @error Then Return SetError(@error, @extended, 0)
    Local $vFlag = DllStructGetData($tSI, 'Flags')
    If BitAND($vFlag, 0x800) Then
        Local $sTitle = DllStructCreate('wchar ShortcutPath[261]', DllStructGetData($tSI, 'Title'))
        Local $sShortcutPath = DllStructGetData($sTitle, 'ShortcutPath')
        If $sShortcutPath Then
            Return FileGetShortcut($sShortcutPath)
        Else
            Return SetError(1, 0, 0)
        EndIf
    Else
        Return SetError(2, 0, 0)
    EndIf
EndFunc   ;==>_RunFromShortcut

Func _IsEven($number)
    Return Mod($number, 2) = 0
EndFunc   ;==>_IsEven

Func _OnAutoItExit()
    $a = WinGetPos("")
    IniWrite(@ScriptDir & "\" & $INIfile, "WINPOS", "X-Pos", $a[0])
    IniWrite(@ScriptDir & "\" & $INIfile, "WINPOS", "Y-Pos", $a[1])
EndFunc   ;==>_OnAutoItExit
