#include <WindowsConstants.au3>
#include <GUIConstantsEx.au3>
#include <Memory.au3>
#include <GDIPlus.au3>
#include <StaticConstants.au3>
#include <TrayConstants.au3>

Global Const $sExcelColor = "217346", $sWordColor = "2b579a", $sOutlookColor = "B7472A"
Global Const $sThemeColor = $sOutlookColor
Local Const $PI = 3.141592653589793

Global Const $hDwmApiDll = DllOpen("dwmapi.dll")
Global $sChkAero = DllStructCreate("int;")
DllCall($hDwmApiDll, "int", "DwmIsCompositionEnabled", "ptr", DllStructGetPtr($sChkAero))
Global $bAero = DllStructGetData($sChkAero, 1)
Global $fStep = 0.02
If Not $bAero Then $fStep = 1.25

_GDIPlus_Startup()
Global $iW = 442, $iH = 30
$hGUI = GUICreate("Office", $iW, 252, @DesktopWidth / 2.95, @DesktopHeight / 3.2, $WS_POPUP)
GUISetBkColor("0x" & $sThemeColor)
$Label1 = GUICtrlCreateLabel("SciTE4AutoIt3", 8, 8, 102, 21)
GUICtrlSetFont(-1, 10, 400, 0, "Segoe UI Light")
GUICtrlSetColor(-1, 0xFFFFFF)
$Label2 = GUICtrlCreateLabel("AutoIt 247", 64, 72, 314, 75, BitOR($SS_CENTER, $SS_CENTERIMAGE))
GUICtrlSetFont(-1, 40, 400, 0, "Segoe UI Light")
GUICtrlSetColor(-1, 0xFFFFFF)
$Label3 = GUICtrlCreateLabel("Starting...", 10, 205, 54, 21)
GUICtrlSetFont(-1, 10, 400, 0, "Segoe UI Light")
GUICtrlSetColor(-1, 0xFFFFFF)
$Label4 = GUICtrlCreateLabel("r", 410, 4, 20, 21)
GUICtrlSetFont(-1, 12, 400, 0, "Webdings")
GUICtrlSetColor(-1, 0xFFFFFF)
GUICtrlSetTip(-1, "Closes the splash screen.")
$Label5 = GUICtrlCreateLabel("0", 385, 0, 20, 21)
GUICtrlSetFont(-1, 12, 400, 0, "Webdings")
GUICtrlSetColor(-1, 0xFFFFFF)
GUICtrlSetTip(-1, "Minimises the splash screen.")
GUISetState(@SW_SHOW)
Global Const $iPic = GUICtrlCreatePic("", 0, 150, $iW, $iH)
GUICtrlSetState(-1, $GUI_DISABLE)
WinSetTrans($hGUI, "", 0)
GUISetState()

Global $hHBmp_BG, $hB, $iSleep = 20
GUIRegisterMsg($WM_TIMER, "PlayAnim")
DllCall("user32.dll", "int", "SetTimer", "hwnd", $hGUI, "int", 0, "int", $iSleep, "int", 0)
Global $iballs = 5
Global $aPos[$iballs][3]

For $i = 0 To $iballs - 1
	$aPos[($iballs - 1) - $i][0] = -10
	$aPos[($iballs - 1) - $i][1] = $iH / 2
Next
$aPos[0][2] = 1

Global $z, $iPerc
For $z = 1 To 255 Step $fStep
	WinSetTrans($hGUI, "", $z)
Next

Do
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE, $Label4
			ConsoleWrite("Exit")
			GUIRegisterMsg($WM_TIMER, "")
			_WinAPI_DeleteObject($hHBmp_BG)
			_GDIPlus_Shutdown()
			For $z = 255 To 1 Step -$fStep
				WinSetTrans($hGUI, "", $z)
			Next
			GUIDelete($hGUI)
			Exit
	EndSwitch
Until False

Func PlayAnim()
	$hHBmp_BG = _GDIPlus_LinearBalls($iW, $iH, $iPerc, 3, $iballs)
	$hB = GUICtrlSendMsg($iPic, $STM_SETIMAGE, $IMAGE_BITMAP, $hHBmp_BG)
	If $hB Then _WinAPI_DeleteObject($hB)
	_WinAPI_DeleteObject($hHBmp_BG)
	If $aPos[$iballs - 1][2] = 2 Then
		For $i = 0 To $iballs - 1
			$aPos[$i][0] = -10
			$aPos[$i][2] = 0
		Next
		$aPos[0][2] = 1
	EndIf
EndFunc   ;==>PlayAnim

Func _GDIPlus_LinearBalls($iW, $iH, $iPerc, $iRadius = 5, $iballs = 3, $bHBitmap = True)
	Local Const $iDiameter = $iRadius * 2
	Local $tPointF1 = DllStructCreate("float;float")
	Local $pPointF1 = DllStructGetPtr($tPointF1)
	Local $tPointF2 = DllStructCreate("float;float")
	Local $pPointF2 = DllStructGetPtr($tPointF2)
	DllStructSetData($tPointF1, 1, $iDiameter)
	DllStructSetData($tPointF1, 2, 0)
	DllStructSetData($tPointF2, 1, $iDiameter)
	DllStructSetData($tPointF2, 2, $iDiameter)
	Local $hBrushBall2 = DllCall($__g_hGDIPDll, "uint", "GdipCreateLineBrush", "ptr", $pPointF1, "ptr", $pPointF2, "uint", 0xFFcecbca, "uint", 0xFFf2eeed, "int", 1, "int*", 0)
	$hBrushBall2 = $hBrushBall2[6]
	Local $hBitmap = _GDIPlus_BitmapCreateFromScan0($iW, $iH)
	Local Const $hCtxt = _GDIPlus_ImageGetGraphicsContext($hBitmap)
	_GDIPlus_GraphicsSetSmoothingMode($hCtxt, 2)
	_GDIPlus_GraphicsSetPixelOffsetMode($hCtxt, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)
	Local Const $hBrushBall1 = _GDIPlus_BrushCreateSolid("0xFF" & $sThemeColor)
	_GDIPlus_GraphicsFillRect($hCtxt, 0, 0, $iW, $iH, $hBrushBall1)
	Local $i, $fDH, $height
	Local $ixPartScreen = $iW / 16
	For $i = 0 To $iballs - 1

		Local $iSpeed, $x
		If $aPos[$i][2] = 1 Then
			If $aPos[$i][0] < $ixPartScreen * 7 Then
				$x = $aPos[$i][0]
				If $x < 0 Then $x = 0
				$iSpeed = 5 + (20 * ((($ixPartScreen * 7) - $x) * 100) / ($ixPartScreen * 7)) / 100
			ElseIf $aPos[$i][0] > ($ixPartScreen * 9 - ($i * $iRadius * 1.5)) Then
				$iSpeed = 20 + (60 * ((($aPos[$i][0] - $ixPartScreen * 9)) * 100) / ($ixPartScreen * 9)) / 100
			Else
				$iSpeed = 2
			EndIf
			If $i > 0 And $aPos[$i - 1][0] - ($aPos[$i][0] + $iSpeed) < 13 And $aPos[$i][0] < $ixPartScreen * 9 Then
				$aPos[$i][0] = $aPos[$i - 1][0] - 13
			Else
				$aPos[$i][0] = $aPos[$i][0] + $iSpeed
			EndIf
		EndIf

		If $i < $iballs - 1 Then
			If $aPos[$i][0] > $ixPartScreen * 3 Then $aPos[$i + 1][2] = 1
		EndIf

		If $aPos[$i][0] > $iW + $iRadius Then
			$aPos[$i][2] = 0
			If $i = $iballs - 1 Then $aPos[$i][2] = 2
		EndIf
		_GDIPlus_GraphicsFillCircle($hCtxt, $aPos[$i][0], $aPos[$i][1], $iRadius, $hBrushBall2)
	Next

	_GDIPlus_GraphicsDispose($hCtxt)
	_GDIPlus_BrushDispose($hBrushBall1)
	_GDIPlus_BrushDispose($hBrushBall2)

	If $bHBitmap Then
		Local $hHBITMAP = _GDIPlus_BitmapCreateHBITMAPFromBitmap($hBitmap)
		_GDIPlus_BitmapDispose($hBitmap)
		Return $hHBITMAP
	EndIf
	Return $hBitmap
EndFunc   ;==>_GDIPlus_LinearBalls

Func _GDIPlus_GraphicsFillCircle($hCtxt, $iXCenterPos, $iCenterYPos, $iRadius, $hBrush)
	_GDIPlus_GraphicsFillEllipse($hCtxt, $iXCenterPos - $iRadius, $iCenterYPos - $iRadius, $iRadius * 2, $iRadius * 2, $hBrush)
EndFunc   ;==>_GDIPlus_GraphicsFillCircle
