#NoTrayIcon
#pragma compile(Out, CompileIt.exe)
#pragma compile(Icon, icon.ico)
#pragma compile(UPX, false)
#pragma compile(Compatibility, win7)
#pragma compile(CompanyName, scintilla4evr)
#pragma compile(FileDescription, "CompileIt")
#pragma compile(FileVersion, 0.0.1.0)
#pragma compile(FileDescription, "CompileIt")
#pragma compile(FileVersion, 0.0.1.0)
#pragma compile(x64, false)

#include <AutoItConstants.au3>
#include <MsgBoxConstants.au3>
#include <GUIConstants.au3>
#include <WinAPIEx.au3>
#include <Array.au3>
#include <Date.au3>

#include "ChakraCore.au3"

Opt("GUIOnEventMode", 1)

Global $__g_GCCOptions = @ScriptDir&"\gcc_options.ini"
Global $__g_JSTranslator = @ScriptDir&"\transpiler\main.c.js"

Global $__g_CompileItFiles = [@ScriptDir&"\include\CompileIt.c", @ScriptDir&"\include\AutoItFuncs.c"]
Global $__g_CompileItHeader = @ScriptDir&"\include\CompileIt.h"

Global $__g_GCCPath = IniRead($__g_GCCOptions, "_GCC", "Path", "")

Global $hMainUI, $hLogWnd
Global $cidSourceFile, $cidStatusBg, $cidStatusText, $cidGCC_Path, $cidCompileButton

Global $__g_bIsGUI = False
Global $__g_hRuntime, $__g_hContext

Global $__g_hParseFunc = 0
Global $__g_hCallback = 0

Global $__g_OutputFolder
Global $__g_IsDll = False
Global $__g_SourceFiles = []

Global $__g_StopBuild = False

_PrepChakra()

If $CmdLine[0] = 1 Then
	$sInputFile = $CmdLine[1]

	_Build($sInputFile)
	_ExitChakra()
	Exit
EndIf

_GUI()

Func _PrepChakra()
	_ChakraCore_Startup()

	$__g_hRuntime = _ChakraCore_CreateRuntime(0)
	$__g_hContext = _ChakraCore_CreateContext($__g_hRuntime)
	_ChakraCore_SetCurrentContext($__g_hContext)

	$hGlobalObj = _ChakraCore_GetGlobalObject()

	$hConsoleLog = _ChakraCore_CreateFunction("_ConsoleLog")
	$hConsoleObj = _ChakraCore_CreateObject()
	_ChakraCore_SetProperty($hConsoleObj, _ChakraCore_GetPropertyIdFromName("log"), $hConsoleLog)
	_ChakraCore_SetProperty($hGlobalObj, _ChakraCore_GetPropertyIdFromName("console"), $hConsoleObj)

	$__g_hParseFunc = _ChakraCore_RunScript(FileRead($__g_JSTranslator), 0)
	$__g_hCallback = _ChakraCore_CreateFunction("_IncludeCallback")
EndFunc

Func _ExitChakra()
	_ChakraCore_DisposeRuntime($__g_hRuntime)
	_ChakraCore_Shutdown()
EndFunc

Func _GUI()
	$__g_bIsGUI = True
	$hMainUI = GUICreate("CompileIt", 600, 270)
	GUISetOnEvent(-3, "_Exit")
	GUISetFont(9, 400, -1, "Segoe UI")

	$aClientSize = WinGetClientSize($hMainUI)

	$cidVersionLabel = GUICtrlCreateLabel("v0.0.1", 20, $aClientSize[1]-55, $aClientSize[0]-250, 20)
	GUICtrlSetColor(-1, 0xAAAAAA)

	If $__g_GCCPath = "" Then
	EndIf

	; Input file
	GUICtrlCreateLabel("Source file:", 20, 20, 100, 20)
	$cidSourceFile = GUICtrlCreateInput("", 120, 15, 350, 24, $ES_READONLY)
	GUICtrlSetFont(-1, 10)
	$cidSourceBrowse = GUICtrlCreateButton("Browse...", 480, 15, 100, 24)
	GUICtrlSetOnEvent(-1, "_BrowseSrcFile")

	; Compile!
	$cidCompileButton = GUICtrlCreateButton("Compile", $aClientSize[0]-120, $aClientSize[1]-70, 100, 30)
	GUICtrlSetOnEvent(-1, "_CompileBtn")

	; Status bar
	$cidStatusBg = GUICtrlCreateLabel("", 0, $aClientSize[1]-25, $aClientSize[0], 25)
	GUICtrlSetBkColor(-1, 0x5575AA)
	$cidStatusText = GUICtrlCreateLabel("Ready.", 10, $aClientSize[1]-20, $aClientSize[0]-20, 20)
	GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
	GUICtrlSetColor(-1, 0xFFFFFF)

	If $__g_GCCPath = "" Then
		GUICtrlSetState($cidCompileButton, $GUI_DISABLE)
		_LogErr("GCC path has not been set in ""GCC options"" tab.")
	EndIf

	; Settings tabs
	$cidTabs = GUICtrlCreateTab(20, 60, $aClientSize[0]-40, $aClientSize[1]-150)

	;
	GUICtrlCreateTabItem("GCC options")

	GUICtrlCreateLabel("Path to GCC:", 40, 105, 100, 20)
	$cidGCC_Path = GUICtrlCreateInput($__g_GCCPath, 140, 100, 330, 24, $ES_READONLY)
	GUICtrlSetFont(-1, 10)
	$cidGCC_Browse = GUICtrlCreateButton("Browse...", 480, 100, 80, 24)
	GUICtrlSetOnEvent(-1, "_BrowseGCC")

	GUISetState()

	While 1
	WEnd
EndFunc

Func _Exit()
	_ExitChakra()
	Exit
EndFunc

Func _BrowseSrcFile()
	Local $sFile = FileOpenDialog("", "", "AutoIt scripts (*.au3)")
	If Not @error Then GUICtrlSetData($cidSourceFile, $sFile)
EndFunc

Func _BrowseGCC()
	Local $sFile = FileOpenDialog("", "", "Executables (*.exe)")
	If @error Then Return
	If $__g_GCCPath = "" Then
		_Log("Ready.")
		GUICtrlSetState($cidCompileButton, $GUI_ENABLE)
	EndIf
	$__g_GCCPath = $sFile
	IniWrite($__g_GCCOptions, "_GCC", "Path", $sFile)
	GUICtrlSetData($cidGCC_Path, $sFile)
EndFunc

Func _CompileBtn()
	$sInputFile = GUICtrlRead($cidSourceFile)
	If $sInputFile Then _Build($sInputFile)
EndFunc

Func _Build($sInputFile)
	_Log("Preparing to build "&$sInputFile&"...")
	$__g_StopBuild = False

	Local $a[0]
	$__g_SourceFiles = $a

	$__g_OutputFolder = _WinAPI_PathAppend(_WinAPI_PathRemoveFileSpec($sInputFile), "__build")
	If Not FileExists($__g_OutputFolder) Then DirCreate($__g_OutputFolder)

	_FileOverwrite(_WinAPI_PathAppend($__g_OutputFolder, "build.log"), "")

	_ParseFile($sInputFile, $__g_OutputFolder)

	If Not $__g_StopBuild Then
		_Log("Compiling...")
		_Compile($sInputFile, $__g_OutputFolder)
	EndIf

	If Not $__g_StopBuild Then
		$sOutputFile = _WinAPI_PathRenameExtension($sInputFile, $__g_IsDll ? ".dll" : ".exe")
		_Log("Successfully compiled to """&$sOutputFile&""".")
		_BuildLog("Build successful.")
		If $__g_bIsGUI Then MsgBox($MB_ICONINFORMATION, "CompileIt", "Successfully compiled to """&$sOutputFile&""".", 0, $hMainUI)
	Else
		_Log("Build failed. See """&_WinAPI_PathAppend($__g_OutputFolder, "build.log")&""" for details.")
		_BuildLog("Build failed.")
		If $__g_bIsGUI Then MsgBox($MB_ICONERROR, "CompileIt", "Build failed. See """&_WinAPI_PathAppend($__g_OutputFolder, "build.log")&""" for details.", 0, $hMainUI)
	EndIf
EndFunc

Func _Compile($sInputFile, $__g_OutputFolder)
	Local $sOutputFile = _WinAPI_PathRenameExtension($sInputFile, $__g_IsDll ? ".dll" : ".exe")
	Local $aExecStr = [$__g_GCCPath, '-o', $sOutputFile]

	_ArrayAdd($aExecStr, $__g_CompileItFiles)
	_ArrayAdd($aExecStr, $__g_SourceFiles)

	Local $aDllStr = ["-DBUILD_DLL", "-shared", "-luser32"]
	If $__g_IsDll Then _ArrayAdd($aExecStr, $aDllStr)

	For $i = 0 To UBound($aExecStr)-1
		$aExecStr[$i] = '"'&$aExecStr[$i]&'"'
	Next

	Local $sRunStr = _ArrayToString($aExecStr, " ")

	_BuildLog("GCC started @ "&_Now())
	_BuildLog("Run arguments: "&$sRunStr)
	Local $iGCCPid = Run($sRunStr, _WinAPI_PathRemoveFileSpec($sInputFile), @SW_HIDE, $STDERR_CHILD)

	Local $sGCCLog = ""
	While ProcessExists($iGCCPid)
		$sRead = StderrRead($iGCCPid)
		If @extended > 0 Then
			$sGCCLog &= $sRead
		EndIf
	WEnd
	_BuildLog($sGCCLog)

	If Not FileExists($sOutputFile) Then
		$__g_StopBuild = True
	EndIf
EndFunc

Func _ParseFile($sInputFile, $sBuildPath)
	If $__g_StopBuild Then Return
	_Log("Parsing """&$sInputFile&"""...")
	_BuildLog("Parsing """&$sInputFile&""" started @ "&_Now())

	Local $sName = _WinAPI_PathRemoveExtension(_WinAPI_PathFindFileName($sInputFile))
	Local $aArgs = [_ChakraCore_CreateString(FileRead($sInputFile)), _ChakraCore_CreateString($sName), _ChakraCore_CreateString($__g_CompileItHeader), $__g_hCallback]
	Local $hCodeObj = _ChakraCore_CallFunction($__g_hParseFunc, $aArgs)

	If _HasException() Then
		$hExc = _GetException()

		_BuildLog("JavaScript exception occured.")
		_BuildLog("Exception message: "&_ChakraCore_GetString(_ChakraCore_GetProperty($hExc, _ChakraCore_GetPropertyIdFromName("message"))))

		$__g_StopBuild = True
		Return
	EndIf

	Local $hCode_isDll = _ChakraCore_GetNumber(_ChakraCore_GetProperty($hCodeObj, _ChakraCore_GetPropertyIdFromName("is_dll")))
	$__g_IsDll = ($hCode_isDll = 1)

	Local $hCode_cCode = _ChakraCore_GetString(_ChakraCore_GetProperty($hCodeObj, _ChakraCore_GetPropertyIdFromName("code")))
	Local $sCodePath = _WinAPI_PathAppend($sBuildPath, $sName&".c")
	_FileOverwrite($sCodePath, $hCode_cCode)
	_AddSourceFile($sCodePath)

	Local $hCode_hCode = _ChakraCore_GetString(_ChakraCore_GetProperty($hCodeObj, _ChakraCore_GetPropertyIdFromName("headers")))
	Local $sCodePath = _WinAPI_PathAppend($sBuildPath, $sName&".h")
	_FileOverwrite($sCodePath, $hCode_hCode)

	If $__g_IsDll Then
		Local $hCode_cdllCode = _ChakraCore_GetString(_ChakraCore_GetProperty($hCodeObj, _ChakraCore_GetPropertyIdFromName("dll_code")))
		Local $sCodePath = _WinAPI_PathAppend($sBuildPath, $sName&"_dll.c")
		_FileOverwrite($sCodePath, $hCode_cdllCode)
		_AddSourceFile($sCodePath)

		Local $hCode_hdllCode = _ChakraCore_GetString(_ChakraCore_GetProperty($hCodeObj, _ChakraCore_GetPropertyIdFromName("dll_header")))
		Local $sCodePath = _WinAPI_PathAppend($sBuildPath, $sName&"_dll.h")
		_FileOverwrite($sCodePath, $hCode_hdllCode)
	EndIf

	If _HasException() Then
		$hExc = _GetException()

		_BuildLog("JavaScript exception occured.")
		_BuildLog("Exception message: "&_ChakraCore_GetString(_ChakraCore_GetProperty($hExc, _ChakraCore_GetPropertyIdFromName("message"))))

		$__g_StopBuild = True
		Return
	EndIf
EndFunc

Func _AddSourceFile($sSrcFile)
	_ArrayAdd($__g_SourceFiles, $sSrcFile)
EndFunc

Func _BuildLog($sData)
	FileWrite(_WinAPI_PathAppend($__g_OutputFolder, "build.log"), $sData&@CRLF)
EndFunc

Func _HasException()
	$aCall = DllCall($__g_hChakraCoreDll, "dword", "JsHasException", "bool*", 0)
	Return $aCall[1]
EndFunc

Func _GetException()
	$aCall = DllCall($__g_hChakraCoreDll, "dword", "JsGetAndClearException", "handle*", 0)
	Return $aCall[1]
EndFunc

Func _FileOverwrite($sFilePath, $sFileData)
	Local $hFile = FileOpen($sFilePath, 2)
	FileWrite($hFile, $sFileData)
	FileClose($hFile)
EndFunc

Func _IncludeCallback($hCallee, $bIsConstructCall, $pArguments, $iArgCount, $pCallbackState)
	Local $tArgs = DllStructCreate("ptr args["&$iArgCount&"]", $pArguments)
	Local $sIncludeFile = _ChakraCore_GetString($tArgs.args(2))
	Local $iIncludeMode = _ChakraCore_GetNumber($tArgs.args(3))
	Local $bIncludeIsC = _ChakraCore_GetNumber($tArgs.args(4))

	If $bIncludeIsC Then
		_BuildLog("C include found: "&$sIncludeFile)
	Else
		_BuildLog("AutoIt include found: "&$sIncludeFile)
	EndIf
EndFunc

Func _ConsoleLog($hCallee, $bIsConstructCall, $pArguments, $iArgCount, $pCallbackState)
	Local $tArgs = DllStructCreate("ptr args["&$iArgCount&"]", $pArguments)
	Local $sString = _ChakraCore_GetString($tArgs.args(2))

	ConsoleWrite("+> JS: "&$sString&@CRLF)
EndFunc

Func _Log($sMsg)
	If $__g_bIsGUI Then
		GUICtrlSetData($cidStatusText, $sMsg)
		GUICtrlSetBkColor($cidStatusBg, 0x5575AA)
	Else
		ConsoleWrite($sMsg&@CRLF)
	EndIf
EndFunc

Func _LogErr($sMsg)
	If $__g_bIsGUI Then
		GUICtrlSetData($cidStatusText, $sMsg)
		GUICtrlSetBkColor($cidStatusBg, 0xFF0000)
	Else
		ConsoleWrite("! " & $sMsg&@CRLF)
	EndIf
EndFunc
