#include-once

; #INDEX# =======================================================================================================================
; Title .........: ChakraCore UDF
; UDF Version ...: 1.0.0
; AutoIt Version : 3.3.14.0
; Language ......: English
; Description ...: Using ChakraCore JavaScript engine in AutoIt scripts.
; Author(s) .....: scintilla4evr
; Dll ...........: ChakraCore.dll
; ===============================================================================================================================

; #VARIABLES# ===================================================================================================================
Global $__g_hChakraCoreDll = 0
; ===============================================================================================================================

Global Enum $JS_UNDEFINED = 0, $JS_NULL, $JS_NUMBER, $JS_STRING, $JS_BOOLEAN, $JS_OBJECT, $JS_FUNCTION, $JS_ERROR, _
			$JS_ARRAY, $JS_SYMBOL, $JS_ARRAYBUFFER, $JS_TYPEDARRAY, $JS_DATAVIEW

Global Enum $JS_ARRAYTYPE_INT8, $JS_ARRAYTYPE_UINT8, $JS_ARRAYTYPE_UINT8CLAMPED, $JS_ARRAYTYPE_INT16, $JS_ARRAYTYPE_UINT16, _
			$JS_ARRAYTYPE_INT32, $JS_ARRAYTYPE_UINT32, $JS_ARRAYTYPE_FLOAT32, $JS_ARRAYTYPE_FLOAT64

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_Startup
; Description ...: Initializes ChakraCore
; Syntax ........: _ChakraCore_Startup([$sDllFile = "ChakraCore.dll"])
; Parameters ....: $sDllFile            - [optional] path to the ChakraCore DLL. Default is "ChakraCore.dll".
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
; ===============================================================================================================================
Func _ChakraCore_Startup($sDllFile = "ChakraCore.dll")
	$__g_hChakraCoreDll = DllOpen($sDllFile)
	If @error Then Return False
	Return True
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_Shutdown
; Description ...: Frees ChakraCore
; Syntax ........: _ChakraCore_Shutdown()
; Parameters ....:
; Return values .: Success      - True
;                  Failure      - False
; Author ........: Your Name
; Modified ......:
; Remarks .......: Your computer will not explode if you forget to call this function.
; Related .......:
; Link ..........:
; Example .......:
; ===============================================================================================================================
Func _ChakraCore_Shutdown()
	DllClose($__g_hChakraCoreDll)
	If @error Then Return False
	Return True
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_CreateRuntime
; Description ...: Creates a ChakraCore runtime.
; Syntax ........: _ChakraCore_CreateRuntime($iRuntimeAttribute)
; Parameters ....: $iRuntimeAttribute   - runtime attribute value ($JS_ATTR_*)
; Return values .: Success      - runtime handle
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
; ===============================================================================================================================
Func _ChakraCore_CreateRuntime($iRuntimeAttribute)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsCreateRuntime", "dword", $iRuntimeAttribute, "ptr", 0, "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[3]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_DisposeRuntime
; Description ...: Frees a ChakraCore runtime
; Syntax ........: _ChakraCore_DisposeRuntime($hRuntime)
; Parameters ....: $hRuntime            - runtime handle
; Return values .: Success      - 0
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
; ===============================================================================================================================
Func _ChakraCore_DisposeRuntime($hRuntime)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsDisposeRuntime", "ptr", $hRuntime)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[0]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_CreateContext
; Description ...: Creates a ChakraCore context
; Syntax ........: _ChakraCore_CreateContext($hRuntime)
; Parameters ....: $hRuntime            - runtime handle
; Return values .: Success      - context handle
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
; ===============================================================================================================================
Func _ChakraCore_CreateContext($hRuntime)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsCreateContext", "ptr", $hRuntime, "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[2]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_SetCurrentContext
; Description ...: Set the current ChakraCore context
; Syntax ........: _ChakraCore_SetCurrentContext($hContext)
; Parameters ....: $hContext            - context handle
; Return values .: Success      - 0
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
; ===============================================================================================================================
Func _ChakraCore_SetCurrentContext($hContext)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsSetCurrentContext", "ptr", $hContext)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[0]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_RunScript
; Description ...: Executes JavaScript code
; Syntax ........: _ChakraCore_RunScript($sScript, $iCurrentSourceContext)
; Parameters ....: $sScript             - JavaScript code to execute
;                  $iCurrentSourceContext- current source context index
; Return values .: Success      - 0
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
; ===============================================================================================================================
Func _ChakraCore_RunScript($sScript, $iCurrentSourceContext)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsRunScript", "wstr", $sScript, "int", $iCurrentSourceContext, "wstr", "", "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[4]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_GetString
; Description ...: Gets the string from a ChakraCore value pointer
; Syntax ........: _ChakraCore_GetString($hResult)
; Parameters ....: $hResult             - ChakraCore value pointer
; Return values .: Success      - string value
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
; ===============================================================================================================================
Func _ChakraCore_GetString($hResult)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsConvertValueToString", "ptr", $hResult, "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])

	Local $tResult = $aCall[2]

	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsStringToPointer", "ptr", $tResult, "ptr*", 0, "int*", 0)
	If @error Then Return SetError(3, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(4, 0, $aCall[0])

	If $aCall[3] = 0 Then Return ""

	Local $tString = DllStructCreate("wchar string["&$aCall[3]&"]", $aCall[2])
	Return $tString.string
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_GetNumber
; Description ...: Gets the number from a ChakraCore value pointer
; Syntax ........: _ChakraCore_GetNumber($hResult)
; Parameters ....: $hResult             - ChakraCore value pointer
; Return values .: Success      - number
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
; ===============================================================================================================================
Func _ChakraCore_GetNumber($hResult)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsConvertValueToNumber", "ptr", $hResult, "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])

	Local $tResult = $aCall[2]

	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsNumberToDouble", "ptr", $tResult, "double*", 0)
	If @error Then Return SetError(3, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(4, 0, $aCall[0])
	Return $aCall[2]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_CreateString
; Description ...: Creates a ChakraCore value pointer from a string
; Syntax ........: _ChakraCore_CreateString($sString)
; Parameters ....: $sString             - a string value.
; Return values .: Success      - ChakraCore value pointer
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
; ===============================================================================================================================
Func _ChakraCore_CreateString($sString)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsPointerToString", "wstr", $sString, "int", StringLen($sString), "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[3]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_CreateNumber
; Description ...: Creates a ChakraCore value pointer from a number
; Syntax ........: _ChakraCore_CreateNumber($fNumber)
; Parameters ....: $fNumber             - a floating point value.
; Return values .: Success      - ChakraCore value pointer
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ChakraCore_CreateNumber($fNumber)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsDoubleToNumber", "double", $fNumber, "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[2]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_CreateObject
; Description ...: Creates a ChakraCore object
; Syntax ........: _ChakraCore_CreateObject()
; Parameters ....:
; Return values .: Success      - object pointer
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ChakraCore_CreateObject()
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsCreateObject", "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[1]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_CreateFunction
; Description ...: Creates a ChakraCore function from AutoIt function name.
; Syntax ........: _ChakraCore_CreateFunction($sAu3FuncName[, $pCallbackState = 0])
; Parameters ....: $sAu3FuncName        - AutoIt function name
;                  $pCallbackState      - [optional] a pointer value. Default is 0.
; Return values .: Success      - function pointer
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ChakraCore_CreateFunction($sAu3FuncName, $pCallbackState = 0)
	Local $hCallback = DllCallbackRegister($sAu3FuncName, "ptr", "ptr;bool;ptr;ushort;ptr")

	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsCreateFunction", "ptr", DllCallbackGetPtr($hCallback), "ptr", $pCallbackState, "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[3]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_GetGlobalObject
; Description ...: Gets the JavaScript global object pointer.
; Syntax ........: _ChakraCore_GetGlobalObject()
; Parameters ....:
; Return values .: Success      - object pointer
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ChakraCore_GetGlobalObject()
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsGetGlobalObject", "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[1]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_GetPropertyIdFromName
; Description ...: Converts a property name to ChakraCore property ID (for use with _ChakraCore_(Get/Set/Has)Property)
; Syntax ........: _ChakraCore_GetPropertyIdFromName($sName)
; Parameters ....: $sName               - property name
; Return values .: Success      - property ID
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ChakraCore_GetPropertyIdFromName($sName)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsGetPropertyIdFromName", "wstr", $sName, "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[2]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_SetProperty
; Description ...: Sets an object property.
; Syntax ........: _ChakraCore_SetProperty($hObject, $hPropId, $hValue[, $bUseStrictRules = True])
; Parameters ....: $hObject             - ChakraCore object pointer
;                  $hPropId             - ChakraCore property ID (obtained using _ChakraCore_GetPropertyIdFromName)
;                  $hValue              - desired value
;                  $bUseStrictRules     - [optional] a boolean value. Default is True.
; Return values .: Success      - 0
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ChakraCore_SetProperty($hObject, $hPropId, $hValue, $bUseStrictRules = True)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsSetProperty", "ptr", $hObject, "ptr", $hPropId, "ptr", $hValue, "bool", $bUseStrictRules)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[0]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_GetProperty
; Description ...: Gets the value of an object property.
; Syntax ........: _ChakraCore_GetProperty($hObject, $hPropId)
; Parameters ....: $hObject             - ChakraCore object pointer
;                  $hPropId             - ChakraCore property ID (obtained using _ChakraCore_GetPropertyIdFromName)
; Return values .: Success      - value pointer
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ChakraCore_GetProperty($hObject, $hPropId)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsGetProperty", "ptr", $hObject, "ptr", $hPropId, "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[3]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_HasProperty
; Description ...: Checks whether an object contains a specific property (or method).
; Syntax ........: _ChakraCore_HasProperty($hObject, $hPropId)
; Parameters ....: $hObject             - ChakraCore object pointer
;                  $hPropId             - ChakraCore property ID (obtained using _ChakraCore_GetPropertyIdFromName)
; Return values .: Success      - boolean value
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ChakraCore_HasProperty($hObject, $hPropId)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsHasProperty", "ptr", $hObject, "ptr", $hPropId, "bool*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[3]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_CallFunction
; Description ...: Calls a ChakraCore function.
; Syntax ........: _ChakraCore_CallFunction($hFunc[, $aArgs = 0])
; Parameters ....: $hFunc               - ChakraCore function pointer
;                  $aArgs               - [optional] an array of arguments. Set to 0 if no arguments passed.
; Return values .: Success      - function pointer
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ChakraCore_CallFunction($hFunc, $aArgs = 0)
	Local $nArgs = 1 + (IsArray($aArgs) ? UBound($aArgs) : 0)
	Local $tArgs = DllStructCreate("ptr args["&$nArgs&"]")
	Local $i
	$tArgs.args(1) = $hFunc

	If IsArray($aArgs) Then
		For $i = 1 To UBound($aArgs)
			$tArgs.args($i+1) = $aArgs[$i-1]
		Next
	EndIf

	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsCallFunction", "ptr", $hFunc, "ptr", DllStructGetPtr($tArgs), "ushort", UBound($aArgs)+1, "ptr*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[4]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _ChakraCore_GetValueType
; Description ...: Gets the type of a ChakraCore value.
; Syntax ........: _ChakraCore_GetValueType($hValue)
; Parameters ....: $hValue              - value pointer
; Return values .: Success      - value type ($JS_*)
;                  Failure      - see the help file
; Author ........: Your Name
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ChakraCore_GetValueType($hValue)
	Local $aCall = DllCall($__g_hChakraCoreDll, "dword", "JsGetValueType", "ptr", $hValue, "dword*", 0)
	If @error Then Return SetError(1, 0, @error)
	If $aCall[0] <> 0 Then Return SetError(2, 0, $aCall[0])
	Return $aCall[2]
EndFunc
