#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=CertSigner.Redish.ico
#AutoIt3Wrapper_Outfile=CertSigner.exe
#AutoIt3Wrapper_Res_Comment=sign my EXEs
#AutoIt3Wrapper_Res_Description=sign my EXEs
#AutoIt3Wrapper_Res_Fileversion=0.2021.12.23
#AutoIt3Wrapper_Res_LegalCopyright=meh, not really.
#AutoIt3Wrapper_Res_Language=0000
#AutoIt3Wrapper_Res_Field=ProductName|CertSigner.exe
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/rm
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#AutoIt3Wrapper_Res_ProductName=CertSigner.exe
#AutoIt3Wrapper_Compression=4                    ;Compression parameter
;~ #AutoIt3Wrapper_UseUpx=Y                         ;(Y/N) Compress output
;~ #AutoIt3Wrapper_Run_After=del CertSigner_stripped.au3                     ;process to run after
#AutoIt3Wrapper_Run_After=""%scitedir%\..\..\SciTE tools\tools\SignThisFile\CertSigner.exe" "%out%" /Silent /ConsoleWrite"     ; to sign the EXE you just compiled. (Adjust as needed)

#include "_RunWaitEx.au3"

Global $g_iLoopCountInCaseOfError = 0, $g_nLoopCountInCaseOfError = 0, $g_hLoopCountInCaseOfError = TimerInit()
Global $g_sCnDefault = "Change this to something meaningful", $g_iNoLogfile = Default, $g_iNoPopup = Default, $g_iSilent = Default, $g_iConsoleWrite = Default
Global $g_sCertFullPathNoExt, $g_sDirKeys = @ScriptDir & "\CERTs", $g_DirDefaultCert = "Default"
Global $g_sCertPassword, $g_sFileToSignFullPath, $g_sDirBin = FileGetShortName(@ScriptDir) & "\BIN"
If Not FileExists($g_sDirKeys) Then DirCreate($g_sDirKeys)
$g_DirDefaultCert = IniRead($g_sDirKeys & '\' & $g_DirDefaultCert & "\Default.ini", "Default", "Default", "Default")

ParseCmdLine()

If Not FileExists($g_sCertFullPathNoExt & '.dat') Then Exit BuildDefaultStructure()

ParseCertDat()

Func ParseCmdLine()
	Local $sStr = ""
	If $CmdLine[0] Then $g_sFileToSignFullPath = $CmdLine[1]
	For $n = 1 To $CmdLine[0]
		Switch $CmdLine[$n]
			Case "/ConsoleWrite"
				$g_iConsoleWrite = 1
			Case "/NoPopup"
				$g_iNoPopup = 1
			Case "/NoLogfile"
				$g_iNoLogfile = 1
			Case "/Silent"
				$g_iSilent = 1
				$g_iNoPopup = 1
		EndSwitch
		If StringInStr($CmdLine[$n], "/CertFolder=") Then
			$sStr = StringTrimLeft($CmdLine[$n], StringLen("/CertFolder="))
			If StringInStr($sStr, "\") Then Exit MsgBoxNoGo("CertFolder should be the subfolder name only !." & @CR & 'It''s root will be "' & $g_sDirKeys & '", bye.')
			$g_DirDefaultCert = $sStr
		EndIf
	Next
	If StringInStr($g_sFileToSignFullPath, "/") Then $g_sFileToSignFullPath = ""
	$g_sCertFullPathNoExt = $g_sDirKeys & '\' & $g_DirDefaultCert & '\cert'
EndFunc   ;==>ParseCmdLine

Func ParseCertDat()
	Local $aObfuscate, $iObfuscate = 0, $sCertC = "", $sCertS = "", $n, $aFile = StringSplit(FileRead($g_sCertFullPathNoExt & '.dat'), @CRLF, 1)
	$aObfuscate = $aFile
	For $n = 1 To $aFile[0]
		$aFile[$n] = StringStripWS($aFile[$n], 3)
		If StringInStr($aFile[$n], "@CertPassword=") = 1 And $g_sCertPassword = "" Then
			$g_sCertPassword = StringTrimLeft($aFile[$n], StringLen("@CertPassword="))
			If StringInStr($g_sCertPassword, "@RandomString") Then $g_sCertPassword = StringReplace($g_sCertPassword, "@RandomString", RandomString())
			If StringLeft($g_sCertPassword, 2) = "0x" Then
				$g_sCertPassword = BinaryToString($g_sCertPassword)
			Else
				$iObfuscate = 1
				$aObfuscate[$n] = "@CertPassword=" & StringToBinary($g_sCertPassword)
			EndIf
		EndIf
		If StringInStr($aFile[$n], "@ConsoleWrite=") = 1 And $g_iConsoleWrite = Default Then $g_iConsoleWrite = Int(StringTrimLeft($aFile[$n], StringLen("@ConsoleWrite=")))
		If StringInStr($aFile[$n], "@NoPopup=") = 1 And $g_iNoPopup = Default Then $g_iNoPopup = Int(StringTrimLeft($aFile[$n], StringLen("@NoPopup=")))
		If StringInStr($aFile[$n], "@NoLogfile=") = 1 And $g_iNoLogfile = Default Then $g_iNoLogfile = Int(StringTrimLeft($aFile[$n], StringLen("@NoLogfile=")))
		If StringInStr($aFile[$n], "@Silent=") = 1 And $g_iSilent = Default Then
			$g_iSilent = Int(StringTrimLeft($aFile[$n], StringLen("@Silent=")))
			If $g_iSilent Then $g_iNoPopup = 1
		EndIf
		If StringInStr($aFile[$n], "@BinFolder=") = 1 Then $g_sDirBin = FileGetShortName(StringTrimLeft($aFile[$n], StringLen("@BinFolder=")))
		If StringInStr($aFile[$n], "@FileToSignFullPath") Then $aFile[$n] = StringReplace($aFile[$n], "@FileToSignFullPath", $g_sFileToSignFullPath)
		If StringInStr($aFile[$n], ":c:") = 1 Then $sCertC &= @CRLF & StringTrimLeft($aFile[$n], 3)
		If StringInStr($aFile[$n], ":s:") = 1 Then $sCertS &= @CRLF & StringTrimLeft($aFile[$n], 3)
	Next
	If StringInStr($sCertC, '-n "CN=' & $g_sCnDefault & '"') Then
		ShellExecute("notepad", $g_sCertFullPathNoExt & '.dat')
		Exit MsgBoxNoGo('Please edit the file before use.')
	EndIf
	If $iObfuscate Then
		Local $h, $sFileInfo = ""
		For $n = 1 To $aFile[0]
			$sFileInfo &= $aObfuscate[$n] & @CRLF
		Next
		$h = FileOpen($g_sCertFullPathNoExt & '.dat', 2)
		If $h = -1 Then
			Exit MsgBoxNoGo('Could not write "cert.dat", bye.')
		Else
			FileWrite($h, $sFileInfo)
			FileClose($h)
		EndIf
	EndIf
	If $g_iConsoleWrite = Default Then $g_iConsoleWrite = 0
	If $g_iNoPopup = Default And $g_iSilent = Default Then $g_iNoPopup = 0
	If $g_iNoLogfile = Default Then $g_iNoLogfile = 0
	If $g_iSilent = Default Then $g_iSilent = 0
	If Not FileGetSize($g_sCertFullPathNoExt & '.pfx') Then
		RunEm($sCertC, "Create")
	Else
		RunEm($sCertS, "Sign")
	EndIf
EndFunc   ;==>ParseCertDat

Func RunEm($sCertC, $sWhat)
	Local $sSplashText = "making a new certificate"
	Local $sRunOutput, $sLog = @YEAR & "/" & @MON & "/" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC & " : making a new certificate for """ & $g_DirDefaultCert & """ " & @CRLF
	If $sWhat = "Sign" Then
		$sSplashText = "Signing: " & $g_sFileToSignFullPath
		$sLog = @YEAR & "/" & @MON & "/" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC & " : Signing: """ & $g_sFileToSignFullPath & """ " & @CRLF
		If Not FileGetSize($g_sFileToSignFullPath) Then Exit MsgBoxNoGo('Could not find "' & $g_sFileToSignFullPath & '", bye.')
	EndIf
	Local $iMakecert = 0
	Local $sRun, $aRuns = StringSplit($sCertC, @CRLF, 1)
	For $n = 2 To UBound($aRuns) - 1
		$sRun = StringLeft($aRuns[$n], StringInStr($aRuns[$n], " ") - 1)
		If Not FileGetSize($g_sDirBin & '\' & $sRun) Then Exit MsgBoxNoGo('Could not find "' & $sRun & '", bye.')
	Next
	_RunWaitEx_Timeout(30000)
	If $g_iSilent = 0 Then SplashTextOn(@ScriptName, $sSplashText, (@DesktopWidth / 2), 60, (@DesktopWidth / 2) - (@DesktopWidth / 4), 50, 16, "Courier New", 10, 400)
	For $n = 2 To UBound($aRuns) - 1
		$sRun = $g_sDirBin & '\' & $aRuns[$n]
		$sRun = StringReplace($sRun, "@CertFullPathNoExt", $g_sCertFullPathNoExt)
		$sRun = StringReplace($sRun, "@CertPassword", $g_sCertPassword)
		If StringInStr($sRun, "\makecert.exe ") Then $iMakecert = 1
;~ 		If $iMakecert Then AdlibEnable("ControlSendMakecert", 250)
		If $iMakecert Then AdlibRegister("ControlSendMakecert", 250)
		$sLog &= "====================================================" & @CRLF & $sRun & @CRLF & @CRLF
		$sRunOutput = _RunWaitEx($sRun)
		$sLog &= $sRunOutput
		$sLog &= @CRLF & "ExitCode: " & @extended & @CRLF
		If $g_iConsoleWrite Then ConsoleWrite($sRunOutput)
;~ 		If $iMakecert Then AdlibDisable()
		If $iMakecert Then AdlibUnRegister("ControlSendMakecert")
	Next
	$sLog &= "====================================================" & @CRLF
	$sLog = StringReplace($sLog, $g_sCertPassword, "TheRealCertPassword")
	SplashOff()
	If $sWhat = "Sign" Then
		If Not $g_iNoLogfile Then FileWriteLine($g_sFileToSignFullPath & '.sign.log', $sLog)
	Else
		If Not $g_iNoLogfile Then FileWriteLine($g_sCertFullPathNoExt & '.makecert.log', $sLog)
	EndIf
	If Not $g_iNoPopup Then ShowLog($sLog)
EndFunc   ;==>RunEm

Func ControlSendMakecert()
;~ 	AdlibDisable()
	AdlibUnRegister("ControlSendMakecert")

	Do
		If WinExists("[CLASS:#32770]", "Subject Key") And ControlGetText("[CLASS:#32770]", "Subject Key", "Static4") <> "" Then
			If $g_nLoopCountInCaseOfError = 1 Then ContinueLoop
			BlockInput(1)
			WinActivate("[CLASS:#32770]", "Subject Key")
			Sleep(150)
			Sleep(150)
			ControlSend("[CLASS:#32770]", "Subject Key", "Edit1", $g_sCertPassword)
			Sleep(150)
			ControlSend("[CLASS:#32770]", "Subject Key", "Edit2", $g_sCertPassword)
			Sleep(150)
			ControlClick("[CLASS:#32770]", "Subject Key", "Button1")
			Sleep(500)
			BlockInput(0)
			$g_nLoopCountInCaseOfError = 1
			$g_iLoopCountInCaseOfError += 1
		ElseIf WinExists("[CLASS:#32770]", "Subject Key") Then
			If $g_nLoopCountInCaseOfError = 2 Then ContinueLoop
			BlockInput(1)
			WinActivate("[CLASS:#32770]", "Subject Key")
			Sleep(150)
			ControlSend("[CLASS:#32770]", "Subject Key", "Edit1", $g_sCertPassword)
			Sleep(150)
			ControlClick("[CLASS:#32770]", "Subject Key", "Button1")
			Sleep(500)
			BlockInput(0)
			$g_nLoopCountInCaseOfError = 2
			$g_iLoopCountInCaseOfError += 1
		EndIf
		If $g_iLoopCountInCaseOfError > 4 Then
;~ 			$sLoopCountInCaseOfError = "Too many retries." & @CR & "Something must be wrong, aborting."
			ExitLoop
		EndIf
		If TimerDiff($g_hLoopCountInCaseOfError) > 30000 Then
;~ 			$sLoopCountInCaseOfError = "Is taking too long." & @CR & "Something must be wrong, aborting."
			ExitLoop ; 30 seconds is an eternity
		EndIf
	Until 1 = 1
	AdlibRegister("ControlSendMakecert", 250)
;~ 	AdlibEnable("ControlSendMakecert", 250)
EndFunc   ;==>ControlSendMakecert

Func BuildDefaultStructure()
	DirCreate($g_sDirKeys & "\" & $g_DirDefaultCert)
	Local $sFileInfo = ""
	$sFileInfo &= 'There is the certificate creation and the signing of a file with the certificate.' & @CRLF
	$sFileInfo &= 'Cert creation on this file starts with ":c:" and signing starts with ":s:".' & @CRLF
	$sFileInfo &= 'After the cert creation, those lines can be safely removed. All the lines needed are the "@CertPassword=" line and ":s:" lines.' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= 'Each line will execute the given file on the BIN folder replacing the macro words with it''s value.' & @CRLF
	$sFileInfo &= 'Macro words start with "@" say, @CertPassword=MySecretPassword.' & @CRLF
	$sFileInfo &= 'Each line runs in order as if in a batch file in this file.' & @CRLF
	$sFileInfo &= 'The @CertPassword macro will be replaced with StringToBinary() for obfuscation, so don''t start the password with "0x".' & @CRLF
	$sFileInfo &= 'If @CertPassword=@RandomString, then it''ll create a 50 to 60 character random string, replacing the Macro word with it''s value' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= 'The macro words  available are:' & @CRLF
	$sFileInfo &= '@ConsoleWrite: Default to 0. Set to 1 to ConsoleWrite console output.' & @CRLF
	$sFileInfo &= '@CertPassword: all this uses a password. This is the password value holder.' & @CRLF
	$sFileInfo &= '@FileToSignFullPath: that is the file dropped in or as first parameter.' & @CRLF
	$sFileInfo &= '@RandomString: generates a random A..Z,a..z,0..9 random string 50~60 char. long.' & @CRLF
	$sFileInfo &= '@NoPopup: Set to 1 to default to skip the popup.' & @CRLF
	$sFileInfo &= '@NoLogfile: Set to 1 to default to skip the log file.' & @CRLF
	$sFileInfo &= '@BinFolder: by default is "\BIN" but you can declare another path. ( @BinFolder=c:\my path )' & @CRLF
	$sFileInfo &= '@CertFullPathNoExt: is used internally to have the certs full path minus the extension' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= 'The switch words override the defaults and are:' & @CRLF
	$sFileInfo &=  '/ConsoleWrite: By default it will output to SciTE. This switch is show in console.' & @CRLF
	$sFileInfo &=  '/Silent: By default it will show the log to screen. This switch is to not show any screen popup.' & @CRLF
	$sFileInfo &= '/NoPopup: By default it will show the log to screen. This switch is to not show the popup screen.' & @CRLF
	$sFileInfo &= '/NoLogfile: By default it will write the log to a file. This switch is to not write to file.' & @CRLF
	$sFileInfo &= '/CertFolder: By default it uses the "Default" folder but you can start this with "/CertFolder=AnotherFolder",' & @CRLF
	$sFileInfo &= '		if that folder or this file does not exist, this file will be created there as a template in that folder.' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= 'I''ve chosen to code it this way to make you familiar with the concepts and make it as future proof as possible.' & @CRLF
	$sFileInfo &= 'https://docs.microsoft.com/en-us/windows/win32/seccrypto/makecert' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= 'Do change "CN=' & $g_sCnDefault & '" or this will popup for edit again !.' & @CRLF
	$sFileInfo &= '..and actually, is likely to be the only entry requiring change.' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= 'Now, without further ado:' & @CRLF
	$sFileInfo &= '=========================' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= '@Silent=0' & @CRLF
	$sFileInfo &= '@NoPopup=0' & @CRLF
	$sFileInfo &= '@NoLogfile=0' & @CRLF
	$sFileInfo &= '@CertPassword=@RandomString' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= ':c:makecert.exe -r -a SHA256 -len 2048 -n "CN=' & $g_sCnDefault & '" -b 01/01/1999 -e 01/01/2037 -eku 1.3.6.1.5.5.7.3.3 -sv "@CertFullPathNoExt.pvk" "@CertFullPathNoExt.cer"' & @CRLF
	$sFileInfo &= ':c:cert2spc.exe "@CertFullPathNoExt.cer" "@CertFullPathNoExt.spc"' & @CRLF
	$sFileInfo &= ':c:pvk2pfx.exe -pvk "@CertFullPathNoExt.pvk" -pi "@CertPassword" -spc "@CertFullPathNoExt.spc" -pfx "@CertFullPathNoExt.pfx" -po "@CertPassword"' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= ':s:signtool.exe sign /tr http://timestamp.digicert.com/scripts/timestamp.dll /td SHA256 /fd SHA256 /f "@CertFullPathNoExt.pfx" /p "@CertPassword" "@FileToSignFullPath"' & @CRLF
	$sFileInfo &= '' & @CRLF
	$sFileInfo &= 'example :s:signtool.exe timestamp /t http://timestamp.digicert.com/scripts/timestamp.dll "@FileToSignFullPath"' & @CRLF
	$sFileInfo &= 'example :s:signtool.exe verify /pa "@FileToSignFullPath"' & @CRLF
	Local $hDat = FileOpen($g_sCertFullPathNoExt & '.dat', 2)
	If $hDat = -1 Then
		Exit MsgBoxNoGo('Could not write "cert.dat", bye.')
	Else
		FileWrite($hDat, $sFileInfo)
		FileClose($hDat)
	EndIf
	ShellExecute("notepad", $g_sCertFullPathNoExt & '.dat')
	Return 3
EndFunc   ;==>BuildDefaultStructure

Func MsgBoxNoGo($sText, $iFlag = 0x40040, $iExit = 30, $sTitle = @ScriptName, $iTimeout = 59, $iLine = @ScriptLineNumber)
	If Not @Compiled Then ConsoleWrite('! Line#: ' & $iLine & @TAB & $sText & @CRLF)
	MsgBox($iFlag, $sTitle, $sText, $iTimeout)
	Return $iExit
EndFunc   ;==>MsgBoxNoGo

Func RandomString()
	Local $n, $t, $l = Random(50, 60, 1)
	For $n = 48 To 57 ; 0..9
		$t &= Chr($n)
	Next
	For $n = 65 To 90 ; A..Z
		$t &= Chr($n)
	Next
	For $n = 97 To 122 ; a..z
		$t &= Chr($n)
	Next
	Local $a = StringSplit($t, "")
	$t = ""
	For $n = 1 To $l
		$t &= $a[Random(1, $a[0], 1)]
	Next
	If StringLeft($t, 2) = "0x" Then
		$t = RandomString()
		Return SetError(0, @extended, $t)
	EndIf
	Return SetError(0, $l, $t)
EndFunc   ;==>RandomString

Func ShowLog($sLog = 'the log =)')

	Local Const $GUI_SS_DEFAULT_EDIT = 3150016
	Local Const $GUI_SS_DEFAULT_GUI = -2134245376
	Local Const $GUI_DOCKLEFT = 2
	Local Const $GUI_DOCKRIGHT = 4
	Local Const $GUI_DOCKTOP = 32
	Local Const $GUI_DOCKBOTTOM = 64
	Local Const $GUI_EVENT_CLOSE = -3
	Local Const $GUI_FOCUS = 256
	Local Const $WS_MAXIMIZEBOX = 65536
	Local Const $WS_SIZEBOX = 262144
	Local Const $WS_THICKFRAME = 262144
	Local Const $WS_TABSTOP = 65536
	Local Const $WS_EX_TOPMOST = 8
	Local Const $WS_EX_WINDOWEDGE = 256
	Local Const $ES_READONLY = 2048
	Local Const $COLOR_BTNTEXT = 18

	Local $iX = @DesktopWidth / 2, $iY = @DesktopHeight / 2
	Local $Form = GUICreate(StringTrimRight(@ScriptName, 4) & ' - log', $iX, $iY, -1, 10, BitOR($GUI_SS_DEFAULT_GUI, $WS_MAXIMIZEBOX, $WS_SIZEBOX, $WS_THICKFRAME, $WS_TABSTOP), BitOR($WS_EX_TOPMOST, $WS_EX_WINDOWEDGE))
	Local $Label = GUICtrlCreateLabel("", 32, 32, 32, 32)
	Local $Edit = GUICtrlCreateEdit("", 0, 0, $iX, $iY, BitOR($GUI_SS_DEFAULT_EDIT, $ES_READONLY))
	GUICtrlSetFont(-1, 10, 400, 0, "Courier New") ; looks uniform in every language tested on ( english, spanish, french, korean )
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)
	GUICtrlSetColor(-1, __WinAPI_SwitchColor(__WinAPI_GetSysColor($COLOR_BTNTEXT)))
	GUISetState(@SW_SHOW)
	GUICtrlSetData($Edit, $sLog)
	GUICtrlSetState($Label, $GUI_FOCUS)
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				GUIDelete($Form)
				ExitLoop
		EndSwitch
	WEnd
EndFunc   ;==>ShowLog

Func __WinAPI_SwitchColor($iColor)
	If $iColor = -1 Then Return $iColor
	Return BitOR(BitAND($iColor, 0x00FF00), BitShift(BitAND($iColor, 0x0000FF), -16), BitShift(BitAND($iColor, 0xFF0000), 16))
EndFunc   ;==>__WinAPI_SwitchColor

Func __WinAPI_GetSysColor($iIndex, $aResult = "")
	$aResult = DllCall("User32.dll", "int", "GetSysColor", "int", $iIndex)
	Return $aResult[0]
EndFunc   ;==>__WinAPI_GetSysColor
