#include-once ; https://www.autoitscript.com/forum/topic/139260-autoit-snippets/?do=findComment&comment=1478119
;~ #include <AutoItConstants.au3> ; needed For $STDERR_CHILD & $STDOUT_CHILD

Global $__g_RunWaitEx_sWorkingDir = @TempDir
Global $__g_RunWaitEx_iShowFlag = @SW_HIDE
Global $__g_RunWaitEx_iOptFlag = 6 ;  ; "BitOR($STDERR_CHILD, $STDOUT_CHILD) = 6"
Global $__g_RunWaitEx_msTimeout = 0

; these helper functions return the set values, or sets the values if provided with one.
Func _RunWaitEx_WorkingDir($val = Default)
    If $val <> Default Then $__g_RunWaitEx_sWorkingDir = String($val)
    Return $__g_RunWaitEx_sWorkingDir
EndFunc   ;==>_RunWaitEx_WorkingDir
Func _RunWaitEx_ShowFlag($val = Default)
    If $val <> Default Then $__g_RunWaitEx_iShowFlag = Int($val)
    Return $__g_RunWaitEx_iShowFlag
EndFunc   ;==>_RunWaitEx_ShowFlag
Func _RunWaitEx_OptFlag($val = Default)
    If $val <> Default Then $__g_RunWaitEx_iOptFlag = Int($val)
    Return $__g_RunWaitEx_iOptFlag
EndFunc   ;==>_RunWaitEx_ShowFlag
Func _RunWaitEx_Timeout($val = Default)
    If $val <> Default Then $__g_RunWaitEx_msTimeout = Int($val)
    Return $__g_RunWaitEx_msTimeout
EndFunc   ;==>_RunWaitEx_Timeout

; ..say you'd like to change a default due to circumstance
;~ If Not @Compiled Then _RunWaitEx_ShowFlag(@SW_SHOW)

; this example is to showcase the errorlevel/exitcode as the @extended value.
;~ Exit ConsoleWrite('--- Text     >' & _RunWaitEx("dir /.ThisWillFail") & _
;~                   '--- @error   >' & @error & @CRLF & _ ; timeout ?
;~                   '--- exitcode >' & @extended & @CRLF)

;RunWait: Runs an external program and pauses the script execution until the program finishes, returning the exit code of the program that was run.
;_RunWaitEx: Same as RunWait() but also returns the output text and has an optional timeout.
Func _RunWaitEx($sCommand, $sWorkingDir = Default, $iShowFlag = Default, $iOptFlag = Default, $msTimeout = Default)
    ;   https://www.autoitscript.com/forum/index.php?showtopic=139260&view=findpost&p=1478119
    ; ------------------- GetExitCodeProcess portion
    Switch $sWorkingDir
        Case "/OpenProcess"
            Local $hPID_HANDLE = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'int', 0x400, 'int', 0, 'int', $sCommand)
            If Not @error Then Return $hPID_HANDLE
            Return SetError(1, 0, 0)
        Case "/GetExitCodeProcess"
            Local $v_Placeholder, $aRet = DllCall('kernel32.dll', 'ptr', 'GetExitCodeProcess', 'ptr', $sCommand[0], 'int*', $v_Placeholder)
            If Not @error And UBound($aRet) > 2 Then Return $aRet[2]
            Return SetError(1, 0, 0)
        Case "/CloseHandle"
            DllCall('kernel32.dll', 'ptr', 'CloseHandle', 'ptr', $sCommand)
            If Not @error Then Return 1
            Return 0
    EndSwitch

    ; ------------------- set defaults
    If $sWorkingDir = Default Then $sWorkingDir = _RunWaitEx_WorkingDir() ; @TempDir
    If $iShowFlag = Default Then $iShowFlag = _RunWaitEx_ShowFlag() ; @SW_HIDE
    If $iOptFlag = Default Then $iOptFlag = _RunWaitEx_OptFlag() ; "BitOR($STDERR_CHILD, $STDOUT_CHILD) = 6"
    If $msTimeout = Default Then $msTimeout = _RunWaitEx_Timeout() ; ( 0 ms. = OFF ) in case the process takes longer than expected

    ; ------------------- Run()
    Local $iPID = Run(@ComSpec & " /c " & $sCommand, $sWorkingDir, $iShowFlag, $iOptFlag)
    If @error Or $iPID = 0 Then Return SetError(@error + 100, 0, "")
    Local $iExitCode = 0, $hPID_HANDLE = _RunWaitEx($iPID, "/OpenProcess")
    Local $hTimer = TimerInit(), $sOutput = ""
    While 1
        $sOutput &= StdoutRead($iPID)
        If @error Then ExitLoop
        If $msTimeout And TimerDiff($hTimer) > $msTimeout Then ExitLoop
        Sleep(1)
    WEnd
    While 1
        $sOutput &= StderrRead($iPID)
        If @error Then ExitLoop
        If $msTimeout And TimerDiff($hTimer) > $msTimeout Then ExitLoop
        Sleep(1)
    WEnd
    If $hPID_HANDLE <> 0 Then
        $iExitCode = _RunWaitEx($hPID_HANDLE, "/GetExitCodeProcess")
        If $iExitCode = 259 Then
            $iExitCode = 100000 + $iPID ; ...process not done, should not close handle.
        Else ;                            ...the PID will be the @extended - 100000
            _RunWaitEx($hPID_HANDLE, "/CloseHandle")
        EndIf
    EndIf
    Return SetError($msTimeout And __Iif(TimerDiff($hTimer) > $msTimeout, 200, 0), $iExitCode, $sOutput)
EndFunc   ;==>_RunWaitEx

Func __Iif($fTest, $vTrueVal, $vFalseVal)
	If $fTest Then Return $vTrueVal
	Return $vFalseVal
EndFunc   ;==>_Iif