#include <OutlookTools.au3>
#include <Debug.au3>

Global $oOutlook = _OL_Open()
Global $aFolder = _OL_FolderAccess($oOutlook, "", $olFolderContacts)
; Export all contacts with FirstName "Christian" into Excel workbook
Global $sProperties = "LastName,FirstName"
Global $aContacts = _OL_ItemFind($oOutlook, $aFolder[1], $olContact, '[FirstName] = "Christian"', "", "", "EntryID", "", 1)
If @error Then MsgBox(48, "", "Error finding a contact. @error = " & @error & ", @extended: " & @extended)
; Export contacts as Excel
Global $iTimer = TimerInit()
Global $iItemCount = _OLT_Export($oOutlook, $aContacts, $iOLT_ExportTypeExcel, @ScriptDir & "\Export\_OLT_Export_Excel.XLSX", $sProperties, False, "", $iOLT_DebugConsole)
If @error Then
	MsgBox(48, "", "Error exporting items. @error = " & @error & ", @extended: " & @extended)
Else
	MsgBox(0, "_OLT_Export", $iItemCount & " contacts exported as Excel." & @CRLF & "Time: " & StringFormat("%.2f seconds", TimerDiff($iTimer) / 1000))
EndIf
Exit