#include <OutlookTools.au3>

Global $oOutlook = _OL_Open()
Global $aFolder = _OL_FolderAccess($oOutlook, "", $olFolderContacts)
; Export all contacts with FirstName "Martin" as VCF files
Global $aContacts = _OL_ItemFind($oOutlook, $aFolder[1], $olContact, '[FirstName] = "Martin"', "", "", "EntryID,FullName", "", 1)
If @error Then MsgBox(48, "", "Error finding a contact. @error = " & @error & ", @extended: " & @extended)
Global $iTimer = TimerInit()
Global $iItemCount = _OLT_Export($oOutlook, $aContacts, $iOLT_ExportTypeVCF, @ScriptDir & "\Export\", "", False, "", $iOLT_DebugConsole)
If @error Then MsgBox(48, "", "Error exporting items. @error = " & @error & ", @extended: " & @extended)
MsgBox(0, "_OLT_Export", $iItemCount & " contacts exported as VCF." & @CRLF & "Time: " & StringFormat("%.2f seconds", TimerDiff($iTimer) / 1000))
Exit
