AutoItSetOption("MustDeclareVars", 0)

#include <OutlookTools.au3>

; Create test.ics in current directory
If MsgBox(BitOR($MB_OKCANCEL, $MB_ICONINFORMATION), "Create ICS-file", "Test.ics will be created in the current directory." & @CRLF & "It contains two events for today which will be added to your primary calendar.") <> $IDOK Then Exit
Global $siCalPath = @ScriptDir & "\test.ics"
FileDelete($siCalPath)
FileWrite($siCalPath, _
		"BEGIN:VCALENDAR" & @CRLF & _
		"VERSION:2.0" & @CRLF & _
		"METHOD:PUBLISH" & @CRLF & _
		"PRODID:-//OutlookTools UDF//iCal Generator//DE" & @CRLF & _
		"BEGIN:VEVENT" & @CRLF & _ ; Event 1
		"CLASS:PRIVATE" & @CRLF & _
		"PRIORITY:3" & @CRLF & _
		"CATEGORIES:TEST" & @CRLF & _
		"CREATED:20190110T032002Z" & @CRLF & _
		"LAST-MODIFIED:20190110T032002Z" & @CRLF & _
		"DTSTAMP:20190110T032002Z" & @CRLF & _
		"SUMMARY:HOLIDAY" & @CRLF & _
		"DTSTART;VALUE=DATE:" & StringReplace(_NowCalcDate(), "/", "") & @CRLF & _
		"DURATION:P2D" & @CRLF & _
		"URL:http://www.google.com" & @CRLF & _
		"DESCRIPTION:All Holidays" & @CRLF & _
		"TRANSP:OPAQUE" & @CRLF & _
		"LOCATION:Room 123" & @CRLF & _
		"UID:TEST_2019_5c36abd73c75e" & @CRLF & _
		"BEGIN:VALARM" & @CRLF & _
		"TRIGGER:PT30M" & @CRLF & _
		"ACTION:DISPLAY" & @CRLF & _
		"DESCRIPTION:Reminder" & @CRLF & _
		"END:VALARM" & @CRLF & _
		"END:VEVENT" & @CRLF & _
		"BEGIN:VEVENT" & @CRLF & _ ; Event 2
		"CLASS:PRIVATE" & @CRLF & _
		"PRIORITY:3" & @CRLF & _
		"CATEGORIES:PRIVATE" & @CRLF & _
		"CREATED:20190110T032002Z" & @CRLF & _
		"LAST-MODIFIED:20190110T032002Z" & @CRLF & _
		"DTSTAMP:20190110T032002Z" & @CRLF & _
		"SUMMARY:Party" & @CRLF & _
		"DTSTART;VALUE=DATE-TIME:" & StringReplace(_NowCalcDate(), "/", "") & "T200000Z" & @CRLF & _
		"DTEND;VALUE=DATE-TIME:" & StringReplace(_NowCalcDate(), "/", "") & "T230000Z" & @CRLF & _
		"DESCRIPTION:All Parties" & @CRLF & _
		"TRANSP:OPAQUE" & @CRLF & _
		"LOCATION:Grand Hotel" & @CRLF & _
		"UID:TEST_2019_5c36abd73c75f" & @CRLF & _
		"END:VEVENT" & @CRLF & _
		"END:VCALENDAR")

Global $oOL = _OL_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "Error", "_OL_Open returned @error = " & @error & ", @extended = " & @extended)
Global $aFolder = _OL_FolderAccess($oOL, "", $olFolderCalendar)
If @error Then Exit MsgBox($MB_ICONERROR, "Error", "_OL_FolderAccess returned @error = " & @error & ", @extended = " & @extended)
Global $aResult = _OLT_iCal_VEvent_Import($oOL, $aFolder[1], $siCalPath, "_iCal_Callback", BitOR($iOLT_DebugConsole, $iOLT_DebugProperties))
Global $iError = @error
Global $iExtended = @extended
If @error Then Exit MsgBox($MB_ICONERROR, "Error", "_iCal_VEvent_Import returned @error = " & $iError & " (0x" & Hex($iError) & "), @extended = " & $iExtended & " (0x" & Hex($iExtended) & ").")
_ArrayDisplay($aResult, "Created Calendar Items")
Exit

; Callback function - Do not import events with Categories=PRIVATE
Func _iCal_Callback($aOutlook)
	For $i = 0 To UBound($aOutlook) - 1
		If $aOutlook[$i] = "SUBJECT=Party" Then Return SetError(0, $iOLT_FlagCancelRecord)
	Next
	Return SetError(0, $iOLT_FlagProcessRecord)
EndFunc   ;==>_iCal_Callback