AutoItSetOption("MustDeclareVars", 1)

#include <OutlookTools.au3>

; Create test.vcf in current directory
If MsgBox(BitOR($MB_OKCANCEL, $MB_ICONINFORMATION), "Create VCF-file", "Test.vcf will be created in the current directory." & @CRLF & "It contains a single contact for 'Jon Doe' which will be added to your primary addressbook.") <> $IDOK Then Exit
Global $sVCardPath = @ScriptDir & "\test.vcf"
FileDelete($sVCardPath)
FileWrite($sVCardPath, _
		"BEGIN:VCARD" & @CRLF & _
		"VERSION:2.1" & @CRLF & _
		"N;LANGUAGE=de:Doe;Jon" & @CRLF & _
		"FN:Doe, Jon" & @CRLF & _
		"ORG;CHARSET=Windows-1252:ACME - A Company Making Everything" & @CRLF & _
		"TITLE;CHARSET=Windows-1252:head of everything" & @CRLF & _
		"TEL;WORK;VOICE:555-12345-01" & @CRLF & _
		"TEL;CELL;VOICE:555-90-12345" & @CRLF & _
		"TEL;WORK;FAX:555-12345-55" & @CRLF & _
		"ADR;WORK;PREF;CHARSET=Windows-1252:;;MyWay 12;Springfield;Neverland;55555;Austria" & @CRLF & _
		"LABEL;WORK;PREF;CHARSET=Windows-1252;ENCODING=QUOTED-PRINTABLE:MyWay 12=0D=0A=" & @CRLF & _
		"55555  Springfield  Neverland=0D=0A=" & @CRLF & _
		"Austria" & @CRLF & _
		"X-MS-OL-DEFAULT-POSTAL-ADDRESS:2" & @CRLF & _
		"URL;WORK:http://www.acme.com" & @CRLF & _
		"EMAIL;PREF;INTERNET:john.doe@gmx.com" & @CRLF & _
		'X-MS-OL-DESIGN;CHARSET=utf-8:<card xmlns="http://schemas.microsoft.com/office/outlook/12/electronicbusinesscards" ver="1.0" layout="left" bgcolor="ffffff"><img xmlns="" align="fit" area="16" use="cardpicture"/><fld xmlns="" prop="name" align="left" dir="ltr" style="b" color="000000" size="10"/><fld xmlns="" prop="org" align="left" dir="ltr" color="000000" size="8"/><fld xmlns="" prop="title" align="left" dir="ltr" color="000000" size="8"/><fld xmlns="" prop="telwork" align="left" dir="ltr" color="d48d2a" size="8"><label align="right" color="626262">GeschÃ¤ftlich</label></fld><fld xmlns="" prop="telcell" align="left" dir="ltr" color="d48d2a" size="8"><label align="right" color="626262">Mobiltelefon</label></fld><fld xmlns="" prop="email" align="left" dir="ltr" color="d48d2a" size="8"/><fld xmlns="" prop="addrwork" align="left" dir="ltr" color="000000" size="8"/><fld xmlns="" prop="webwork" align="left" dir="ltr" color="000000" size="8"/><fld xmlns="" prop="blank" size="8"/><fld xmlns="" prop="blank" size="8"/><fld xmlns="" prop="blank" size="8"/><fld xmlns="" prop="blank" size="8"/><fld xmlns="" prop="blank" size="8"/><fld xmlns="" prop="blank" size="8"/><fld xmlns="" prop="blank" size="8"/><fld xmlns="" prop="blank" size="8"/></card>' & @CRLF & _
		"REV:20190205T160127Z" & @CRLF & _
		"END:VCARD")

Global $oOL = _OL_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "Error", "_OL_Open returned @error = " & @error & ", @extended = " & @extended)
Global $aFolder = _OL_FolderAccess($oOL, "", $olFolderContacts)
If @error Then Exit MsgBox($MB_ICONERROR, "Error", "_OL_FolderAccess returned @error = " & @error & ", @extended = " & @extended)
Global $aResult = _OLT_vCard_Import($oOL, $aFolder[1], $sVCardPath, "_vCard_Callback", BitOR($iOLT_DebugConsole, $iOLT_DebugProperties))
Global $iError = @error
Global $iExtended = @extended
If @error Then Exit MsgBox($MB_ICONERROR, "Error", "_vCard_Import returned @error = " & $iError & " (0x" & Hex($iError) & "), @extended = " & $iExtended & " (0x" & Hex($iExtended) & ").")
_ArrayDisplay($aResult, "Created Contact Items")
Exit

; Callback function
; Example function: Do not import contacts that already exist
; Return 0 - create the contact
; Return 1 - Do not create the contact, proceed with the next contact
; Return 2 - Do not create the contact, cancel processing further contacts
Func _vCard_Callback($aOutlook)

	Local $sFullName
	For $i = 0 To UBound($aOutlook) - 1
		If StringLeft($aOutlook[$i], 9) = "Fullname=" Then
			$sFullName = StringMid($aOutlook[$i], 10)
			ExitLoop
		EndIf
	Next
	Local $aContacts = _OL_ItemFind($oOL, $aFolder[1], $olContact, '[FullName] = "' & $sFullName & '"', "", "", "", "", 1)
	If UBound($aContacts) > 1 Then ; There is always the row holding the row/column indexes
		MsgBox($MB_ICONERROR, "Error", "A contact for '" & $sFullName & "' already exists. The contact to import will be ignored!")
		Return SetError(0, $iOLT_FlagCancelRecord)
	EndIf
	Return SetError(0, $iOLT_FlagProcessRecord)

EndFunc   ;==>_vCard_Callback