#NoTrayIcon
#include <Date.au3>
#include <Debug.au3>
#include <Array.au3>
#include <GuiMenu.au3>
#include <WinAPIShellEx.au3>
#include <GUIToolTip.au3>
#include <GuiListView.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <ListViewConstants.au3>
#include <StaticConstants.au3>
#include <TabConstants.au3>
#include <WindowsConstants.au3>
#include <ButtonConstants.au3>


Global $WCM_nItem1, $_Pinging_GUI_Form = 1
Global $__RClickContextMenu[6]
Global $_a__WM_NOTIFY[7] = [0]
Global $_Pinging_Range_iIndex = -1, $ListView_IPs = 0
Global $ScriptFullPathNoExt = StringTrimRight(@ScriptFullPath, 4)
Global $__Pinging_LastNote = "", $localMacs_file = $ScriptFullPathNoExt & ".local-MACs.ini"
Global $Form_ico = $ScriptFullPathNoExt & ".ico"
Global $Form_Title = Chr(160) & "EZ pinging'n'stuff"
#cs

_Pinging_MacManuf_to_INI(FileRead($ScriptFullPathNoExt & ".mac-manuf.txt")) ; https://code.wireshark.org/review/gitweb?p=wireshark.git;a=blob_plain;f=manuf;hb=HEAD
Exit

Func _Pinging_MacManuf_to_INI($sText) ; this function is to make the INI from the manuf.TXT file, otherwise is not used in the script.
	Local $LastModified = "", $c, $b, $s = "[manuf]" & @CRLF, $i = 0, $a = StringSplit($sText, @CRLF)
	For $n = 1 To $a[0]
		If $a[$n] = "" Then ContinueLoop
		If $LastModified = "" Then
			If StringInStr($a[$n], "Last-Modified:") Then
				$b = StringSplit($a[$n], "Last-Modified:", 1)
				$LastModified = StringStripWS($b[2], 7)
				$s &= 'LastModified=' & $LastModified & @CRLF
			EndIf
		EndIf
		If StringLeft($a[$n], 1) = "#" Then ContinueLoop
		$i += 1
		$b = StringSplit($a[$n], @TAB)
		If UBound($b) < 4 Then ContinueLoop
		$c = StringSplit($b[1], ":/")
		Switch $c[0]
			Case 3
				$s &= $c[1] & $c[2] & $c[3] & "=" & $b[2] & @TAB & $b[3] & @CRLF
			Case 7
				Switch $c[$c[0]]
					Case 28
						$s &= $c[1] & $c[2] & $c[3] & $c[4] & "=" & $b[2] & @TAB & $b[3] & @CRLF
					Case 36
						$s &= $c[1] & $c[2] & $c[3] & $c[4] & $c[5] & "=" & $b[2] & @TAB & $b[3] & @CRLF
					Case Else
						ConsoleWrite('!' & @TAB & $b[0] & "/" &$c[0] & "/" & $a[$n]& @CRLF)
				EndSwitch
			Case Else
				ConsoleWrite('!' & @TAB & $b[0] & "/" &$c[0] & "/" & $a[$n]& @CRLF)
		EndSwitch
	Next
	Local $h = FileOpen($ScriptFullPathNoExt & ".mac-manuf.ini", 2)
	FileWrite($h, $s)
	FileClose($h)
EndFunc

#ce



#Region ContextMenu
;
;
; The title "EZ pinging'n'stuff", is because I believe is easy to add stuff to the context menu
;
;

Func _RClickContextMenu($lvCtrl, $iIndex)
	Local Static $hCtrlMenuPopup = 0
	Local $aMousePos = MouseGetPos()
	Local $ip = IpRemoveLeadingZeros(_GUICtrlListView_GetItemText($lvCtrl, $iIndex, 0))
	Local $hn = _GUICtrlListView_GetItemText($lvCtrl, $iIndex, 1)
	Local $mac = _GUICtrlListView_GetItemText($lvCtrl, $iIndex, 3)
	$__RClickContextMenu[0] = $ip
	$__RClickContextMenu[1] = $hn
	$__RClickContextMenu[2] = $mac
	$__RClickContextMenu[3] = _GUICtrlListView_GetItemText($ListView_IPs, $_Pinging_Range_iIndex, 3) ; subnet
	$__RClickContextMenu[4] = $aMousePos[0]
	$__RClickContextMenu[5] = $aMousePos[1]
	ConsoleWrite('+ Func _RClickContextMenu(' & $lvCtrl & ') : IP="' & $ip & '", HostName="' & $hn & '", MAC="' & $mac & '", " SubNet="' & $__RClickContextMenu[3] & '"' & @CRLF)
	If $hCtrlMenuPopup Then _GUICtrlMenu_DestroyMenu($hCtrlMenuPopup)
	$hCtrlMenuPopup = _GUICtrlMenu_CreatePopup($MNS_MODELESS)
	_GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, "Cancel", 0)
	If StringInStr($mac, "<") <> 1 Then
		_GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, "", 0)
		_GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, "WakeOnLan: " & $hn, 1008)
	EndIf
	_GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, "", 0)
	_GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, "Browse as \\" & $ip, 1001)
	If StringInStr($hn, "<") <> 1 Then _GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, "Browse as \\" & $hn, 1002)
	_GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, "", 0)
	_GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, "HTTP://" & $ip, 1003)
	_GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, "HTTPS://" & $ip, 1004)
	_GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, "", 0)
	_GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, 'ClipPut("' & $ip & '")', 1005)
	If StringInStr($hn, "<") <> 1 Then _GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, 'ClipPut("' & $hn & '")', 1006)
	_GUICtrlMenu_AddMenuItem($hCtrlMenuPopup, 'ClipPut("' & $mac & '")', 1007)
	_GUICtrlMenu_TrackPopupMenu($hCtrlMenuPopup, $_Pinging_GUI_Form, $aMousePos[0] - 8, $aMousePos[1] - 8)
EndFunc   ;==>_RClickContextMenu

Func __WM_COMMAND($hWnd, $iMsg, $wParam, $lParam)
	#forceref $hWnd, $iMsg, $lParam
	Switch $wParam
		Case 1001
			ShellExecute("explorer.exe", '\\' & $__RClickContextMenu[0])
		Case 1002
			ShellExecute("explorer.exe", '\\' & $__RClickContextMenu[1])
		Case 1003
			ShellExecute('http://' & $__RClickContextMenu[0])
		Case 1004
			ShellExecute('https://' & $__RClickContextMenu[0])
		Case 1005
			ClipPut($__RClickContextMenu[0])
		Case 1006
			ClipPut($__RClickContextMenu[1])
		Case 1007
			ClipPut($__RClickContextMenu[2])
		Case 1008 ; WOL
			ToolTip("Wake on LAN: " & $__RClickContextMenu[1], $__RClickContextMenu[4], $__RClickContextMenu[5], "", 0, 1)
			WakeOnlan($__RClickContextMenu[0], $__RClickContextMenu[3], $__RClickContextMenu[2])
			AdlibRegister("ToolTipOff", 1000)  ; ..so the user can see something going on
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>__WM_COMMAND

#EndRegion ContextMenu

Func ToolTipOff()
	AdlibUnRegister("ToolTipOff") ; oops, forgot to do this in v. 0.2020.5.16
	ToolTip("")
EndFunc   ;==>ToolTipOff

Func SleepUpto($hTimer, $ms = 200)
	While TimerDiff($hTimer) < $ms
		Sleep(10)  ; ..so the user can see something going on
	WEnd
EndFunc   ;==>SleepUpto

About_IfCmdLine()

_Pinging_GUI()
Func _Pinging_GUI()

	If WinExists($Form_Title) Then
		WinActivate($Form_Title)
		Exit 0
	EndIf

	Local $sNotes, $nNotes, $mNotes, $fNotes = $ScriptFullPathNoExt & ".notes.ini"

	Local $nMsg, $e, $n

	Local $Form, $Form_W = 600, $Form_H = 600
	$_Pinging_GUI_Form = GUICreate($Form_Title, $Form_W, $Form_H, -1, -1, BitOR($GUI_SS_DEFAULT_GUI, $WS_MAXIMIZEBOX, $WS_SIZEBOX, $WS_THICKFRAME, $WS_TABSTOP))
	GUISetFont(10, 400, 0)
	If FileGetSize($Form_ico) Then GUISetIcon($Form_ico)
	_WinAPI_SetCurrentProcessExplicitAppUserModelID("AutoIt v3 GUI." & StringTrimRight(@ScriptName, 4) & ".Unique") ; & @AutoItPID & "string") ; ..this is not needed, ..but so cool  :-)

	$ListView_IPs = GUICtrlCreateListView("", 5, 5, $Form_W - 10, 95)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKHEIGHT)
	Local $ListView_IPsHw = GUICtrlGetHandle($ListView_IPs)

	Local $aNics = _Pinging_GetRegistryIPs()
	For $n = 0 To UBound($aNics, 2) - 1
		If $aNics[0][$n] = "" Then ExitLoop
		_GUICtrlListView_AddColumn($ListView_IPs, $aNics[0][$n] & (@Compiled ? "" : " (" & $n & ")"), 50, 2)
	Next
	_ArrayDelete($aNics, 0)
	ReDim $aNics[UBound($aNics)][40]
	_GUICtrlListView_AddArray($ListView_IPs, $aNics)
	_GUICtrlListView_SetColumnWidth($ListView_IPs, 0, 0)
	For $n = 1 To _GUICtrlListView_GetColumnCount($ListView_IPs) - 1
		_GUICtrlListView_SetColumnWidth($ListView_IPs, $n, $LVSCW_AUTOSIZE_USEHEADER)
	Next

	$aNics[0][23] = 1 ; tries
	$aNics[0][24] = 300 ; ms wait
	$aNics[0][22] = GUICtrlCreateTab(5, 105, $Form_W - 10, $Form_H - 110)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)

	Local $TabItem_Settings = GUICtrlCreateTabItem("   ≡   ")

	Local $set_Ctrls[3][5]
	$n = 150

	$set_Ctrls[2][0] = GUICtrlCreateLabel("Ping IPv4 range:", 10, $n, 100, 21, $SS_RIGHT) ;, $WS_EX_STATICEDGE) ;
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	$set_Ctrls[2][1] = GUICtrlCreateInput("0.0.0.*", 112, $n - 2, 122, 21, BitOR($GUI_SS_DEFAULT_INPUT, $ES_CENTER))
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, "IP v4 format")
	$set_Ctrls[2][2] = GUICtrlCreateButton("Ping", 235, $n - 4, 45, 25)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, """0.0.0.*"" in this default IP will fail ( as is expected )." & @LF & _
			" Do pay attention to what is a valid IP (v4) range.", "Attention")

	$n += 23
	$set_Ctrls[0][0] = GUICtrlCreateLabel("Ping count:", 10, $n, 100, 21, $SS_RIGHT) ;, $WS_EX_STATICEDGE) ;
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, "Number of echo requests to send")
	$set_Ctrls[0][1] = GUICtrlCreateInput($aNics[0][23], 112, $n - 2, 73, 21, BitOR($GUI_SS_DEFAULT_INPUT, $ES_CENTER))
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, "Number of echo requests to send")
	$set_Ctrls[0][2] = GUICtrlCreateButton("Set", 190, $n - 2, 45, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	$set_Ctrls[0][3] = 1 ; min.
	$set_Ctrls[0][4] = 5 ; max.
	GUICtrlSetTip(-1, "Number of echo requests to send", "SET  ( " & $set_Ctrls[0][3] & " to " & $set_Ctrls[0][4] & " count )")

	$n += 23
	$set_Ctrls[1][0] = GUICtrlCreateLabel("Ping timeout:", 10, $n, 100, 21, $SS_RIGHT) ;, $WS_EX_STATICEDGE) ; Number of echo requests to send
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, "Timeout in milliseconds to wait for each reply")
	$set_Ctrls[1][1] = GUICtrlCreateInput($aNics[0][24], 112, $n - 2, 73, 21, BitOR($GUI_SS_DEFAULT_INPUT, $ES_CENTER))
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, "Timeout in milliseconds to wait for each reply")
	$set_Ctrls[1][2] = GUICtrlCreateButton("Set", 190, $n - 2, 45, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	$set_Ctrls[1][3] = 100 ; min.
	$set_Ctrls[1][4] = 3000 ; max.
	GUICtrlSetTip(-1, "Timeout in milliseconds to wait for each reply", "SET  ( " & $set_Ctrls[1][3] & " to " & $set_Ctrls[1][4] & " ms. )")

	For $n = 0 To UBound($aNics) - 1
		_Pinging_AddTab($aNics, $n, $Form_W, $Form_H)
	Next
	GUICtrlSetState($TabItem_Settings, $GUI_SHOW)
	GUICtrlCreateTabItem("")

	GUISetState(@SW_SHOW, $Form)
	GUIRegisterMsg($WM_NOTIFY, "__WM_NOTIFY")
	GUIRegisterMsg($WM_COMMAND, "__WM_COMMAND")
	GUIRegisterMsg($WM_SYSCOMMAND, "WM_SYSCOMMAND")
	$WCM_nItem1 = CreateSystemMenuItem("Info about this...", -1, False, 0)
	CreateSystemMenuItem("", -1, False, 1)

	While 1
		If $_a__WM_NOTIFY[0] Then
			If $_a__WM_NOTIFY[1] = $ListView_IPsHw Then
				If $_a__WM_NOTIFY[3] >= 0 Then
					GUICtrlSetState($aNics[$_a__WM_NOTIFY[3]][20], $GUI_SHOW)
					If $_a__WM_NOTIFY[2] = $NM_DBLCLK Then _Pinging_Range($aNics, $_a__WM_NOTIFY[3])
				Else
					GUICtrlSetState($TabItem_Settings, $GUI_SHOW)
				EndIf
			Else
				For $n = 0 To $aNics[0][26]
					If $_a__WM_NOTIFY[1] = $aNics[$n][25] Then ; $NM_CLICK, $NM_DBLCLK, $NM_RCLICK

						Switch $_a__WM_NOTIFY[2]
							Case $LVN_COLUMNCLICK
								Switch $_a__WM_NOTIFY[4]
									Case 3
										_Pinging_Range($aNics, $n)
										ExitLoop
									Case Else
										_GUICtrlListView_SortItems($aNics[$n][21], $_a__WM_NOTIFY[4])
										ConsoleWrite('+++ ' & $_a__WM_NOTIFY[4] & @CRLF)
										ExitLoop
								EndSwitch

							Case $NM_CLICK, $NM_RCLICK ;  did -2 on: Index=13 on: SubIndex=5
								$nNotes = $_a__WM_NOTIFY[3]
								$mNotes = _GUICtrlListView_GetItemText($aNics[$n][21], $nNotes, 3)
								GUICtrlSetData($aNics[$n][27], StringReplace(_GUICtrlListView_GetItemText($aNics[$n][21], $nNotes, 5), Chr(1), @CRLF))
								ConsoleWrite(' did ' & $_a__WM_NOTIFY[2] & ' on: Index=' & $_a__WM_NOTIFY[3] & ' on: SubIndex=' & $_a__WM_NOTIFY[4] & @CRLF)
								If $_a__WM_NOTIFY[2] = $NM_RCLICK And $_a__WM_NOTIFY[3] > -1 Then
									_RClickContextMenu($aNics[$n][21], $_a__WM_NOTIFY[3])
								EndIf
								ExitLoop
							Case $NM_DBLCLK
								_Pinging_One_Run($aNics, $n, $_a__WM_NOTIFY[3])
								ExitLoop
						EndSwitch
					EndIf
				Next
			EndIf
			$_a__WM_NOTIFY[0] = 0
		EndIf
		$nMsg = GUIGetMsg()

		Switch $nMsg
			Case 0, -4, -5, -6, -7, -8, -9, -10, -11
				; save time on "Case Else", so, nothing to see, carry on

			Case $GUI_EVENT_CLOSE
				ExitLoop

			Case $set_Ctrls[0][2] ; count
				$aNics[0][23] = _Pinging_SetMinMax($set_Ctrls, 0)

			Case $set_Ctrls[1][2] ; timeout
				$aNics[0][24] = _Pinging_SetMinMax($set_Ctrls, 1)

			Case $aNics[0][22]
				$n = Int(GUICtrlRead($aNics[0][22])) - 1
				If $n >= 0 Then
					ConsoleWrite('+++ $Tab ' & $n & " - " & _GUICtrlListView_GetItemCount($aNics[$n][21]) & @CRLF)
					_GUICtrlListView_EnsureVisible($ListView_IPs, $n)
					_GUICtrlListView_SetItemSelected($ListView_IPs, $n)
					If Not _GUICtrlListView_GetItemCount($aNics[$n][21]) Then
						_Pinging_Range($aNics, $n)
						$_a__WM_NOTIFY[0] = 0
					EndIf
				EndIf
			Case $set_Ctrls[2][2]
				$n = _Pinging_TestCustomPing($set_Ctrls)
				$e = @error
				GUICtrlSetData($set_Ctrls[2][1], $n)
				If $e Then ContinueLoop
				$e = WinGetClientSize($Form)
				If @error Then ContinueLoop
				ReDim $aNics[UBound($aNics) + 1][UBound($aNics, 2)]
				$aNics[UBound($aNics) - 1][1] = "(custom)"
				$aNics[UBound($aNics) - 1][2] = $n
				$n = UBound($aNics) - 1
				_GUICtrlListView_InsertItem($ListView_IPs, "", $n)
				_GUICtrlListView_SetItemText($ListView_IPs, $n, $aNics[$n][2], 2)
				_GUICtrlListView_EnsureVisible($ListView_IPs, $n)
				_GUICtrlListView_SetItemSelected($ListView_IPs, $n)
				_Pinging_AddTab($aNics, $n, $e[0], $e[1])
				GUICtrlSetState($aNics[$n][20], $GUI_SHOW)
				_Pinging_Range($aNics, $n)
				$_a__WM_NOTIFY[0] = 0
			Case Else
				For $n = 0 To UBound($aNics) - 1
					If $nMsg = $aNics[$n][28] Then ; "Save Note"
						$sNotes = StringReplace(GUICtrlRead($aNics[$n][27]), @CRLF, Chr(1))
						IniWrite($fNotes, "NotesByMac", $mNotes, $sNotes)
						_GUICtrlListView_SetItemText($aNics[$n][21], $nNotes, $sNotes, 5)
						ExitLoop
					EndIf
					If $nMsg = $aNics[$n][29] Then ; "Save MACs"
						GUICtrlSetState_aNics($aNics, $GUI_DISABLE, $n)
						MacsIni_Save(lv2array($aNics[$n][21]))
						Sleep(200) ; ..so the user can see something going on
						GUICtrlSetState_aNics($aNics, $GUI_ENABLE, $n)
						ExitLoop
					EndIf
				Next
				$nMsg = GUIGetMsg()
		EndSwitch
	WEnd
	WinSetState($Form, "", @SW_HIDE)
	For $n = 0 To UBound($aNics) - 1
		_GUICtrlListView_UnRegisterSortCallBack($aNics[$n][21])
	Next
	GUIDelete()
EndFunc   ;==>_Pinging_GUI

Func MacsIni_Load($lvCtrl)
	Local $aMacs = lv2array($lvCtrl)
	If UBound($aMacs) < 1 Then Return
	Local $i = 0, $s = "", $section = StringTrimRight($aMacs[0][0], 4)
	Local $a = IniReadSection($localMacs_file, $section)
	If UBound($a) < 2 Then Return
	For $n = 1 To $a[0][0]
		$i = 1
		For $m = 0 To UBound($aMacs) - 1
			If $aMacs[$m][3] = $a[$n][0] Then $i = 0
		Next
		If $i Then
			$s &= $a[$n][1] & "|OFF|" & $a[$n][0] & @CRLF
		EndIf
	Next
	$a = _ArrayFromString(StringTrimRight($s, 2), "|", @CRLF, 1)
	If UBound($a, 2) > 2 Then _GUICtrlListView_AddArray($lvCtrl, $a)
EndFunc   ;==>MacsIni_Load

Func MacsIni_Save($aArray)
	If UBound($aArray) < 1 Then Return
	Local $section = StringTrimRight($aArray[0][0], 4)
	For $n = 0 To UBound($aArray) - 1
		IniWrite($localMacs_file, $section, $aArray[$n][3], $aArray[$n][0] & "|" & $aArray[$n][1])
	Next
EndFunc   ;==>MacsIni_Save

Func lv2array($lvCtrl)
	Local $xCol = _GUICtrlListView_GetColumnCount($lvCtrl) - 1
	Local $xRow = _GUICtrlListView_GetItemCount($lvCtrl) - 1
	Local $a, $aArray[$xRow + 1][$xCol + 1]
	For $n = 0 To $xRow
		$a = _GUICtrlListView_GetItemTextArray($lvCtrl, $n)
		For $m = 1 To $a[0]
			$aArray[$n][$m - 1] = $a[$m]
		Next
	Next
	Return $aArray
EndFunc   ;==>lv2array

Func IpRemoveLeadingZeros($ip)
	Local $a = StringSplit($ip, ".")
	If UBound($a) <> 5 Then Return $ip
	Return Int($a[1]) & "." & Int($a[2]) & "." & Int($a[3]) & "." & Int($a[4])
EndFunc   ;==>IpRemoveLeadingZeros

Func _Pinging_TestCustomPing(ByRef $set_Ctrls)
	Local $s = "Wrong IPv4"
	Local $a = StringSplit(StringStripWS(GUICtrlRead($set_Ctrls[2][1]), 8), ".")
	If UBound($a) < 4 Then Return SetError(1, 0, $s)
	If UBound($a) > 5 Then Return SetError(1, 0, $s)
	For $n = 1 To $a[0]
		$a[$n] = Int($a[$n])
		If $a[$n] < 0 Or $a[$n] > 254 Then Return SetError(2, 0, $s)
	Next
	$s = $a[1] & '.' & $a[2] & '.' & $a[3] & '.*'
	Return $s
EndFunc   ;==>_Pinging_TestCustomPing

Func _Pinging_AddTab(ByRef $aNics, ByRef $n, ByRef $Form_W, ByRef $Form_H)
	$aNics[$n][19] = StringLeft($aNics[$n][2], StringInStr($aNics[$n][2], '.', 0, -1)) & "*"
	For $x = 0 To $n - 1
		If $aNics[$n][19] = $aNics[$x][19] Then
			$aNics[$n][20] = $aNics[$x][20]
			$aNics[$n][21] = $aNics[$x][21]
			$aNics[$n][25] = $aNics[$x][25]
			$aNics[$n][27] = $aNics[$x][27]
			$aNics[$n][28] = $aNics[$x][28]
			$aNics[$n][29] = $aNics[$x][29]
			$aNics[0][26] = $n
			Return
		EndIf
	Next

	$aNics[$n][20] = GUICtrlCreateTabItem($aNics[$n][19])
	$aNics[$n][27] = GUICtrlCreateEdit("", 10, $Form_H - 160, $Form_W - 120, 150)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKRIGHT + $GUI_DOCKHEIGHT + $GUI_DOCKBOTTOM)
	$aNics[$n][28] = GUICtrlCreateButton("Save Note", $Form_W - 105, $Form_H - 160, 95, 25)
	GUICtrlSetResizing(-1, $GUI_DOCKWIDTH + $GUI_DOCKRIGHT + $GUI_DOCKHEIGHT + $GUI_DOCKBOTTOM)
	$aNics[$n][29] = GUICtrlCreateButton("Save MACs", $Form_W - 105, $Form_H - 130, 95, 25)
	GUICtrlSetResizing(-1, $GUI_DOCKWIDTH + $GUI_DOCKRIGHT + $GUI_DOCKHEIGHT + $GUI_DOCKBOTTOM)
	$aNics[$n][21] = GUICtrlCreateListView("", 10, 135, $Form_W - 20, $Form_H - 300)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)
;~ 	_GUICtrlListView_SetExtendedListViewStyle($aNics[$n][21], BitOR($LVS_EX_FULLROWSELECT, $LVS_EX_CHECKBOXES))
	$aNics[$n][25] = GUICtrlGetHandle($aNics[$n][21])
	$aNics[0][26] = $n
	_GUICtrlListView_AddColumn(-1, "IP Address", 110, 2)
	_GUICtrlListView_AddColumn(-1, "Host Name", 160, 2)
	_GUICtrlListView_AddColumn(-1, "Ping", 50, 2)
	_GUICtrlListView_AddColumn(-1, "MAC  [rescan]", 160, 2)
	_GUICtrlListView_AddColumn(-1, "Type", 70, 2)
	_GUICtrlListView_AddColumn(-1, "MAC Manuf. / Notes", 200)

	_GUICtrlListView_RegisterSortCallBack($aNics[$n][21])
	Return $aNics[$n][20]
EndFunc   ;==>_Pinging_AddTab

Func _Pinging_SetMinMax(ByRef $set_Ctrls, $i)
	Local $n = Int(GUICtrlRead($set_Ctrls[$i][1]))
	If $n < $set_Ctrls[$i][3] Then
		$n = $set_Ctrls[$i][3]
		GUICtrlSetData($set_Ctrls[$i][1], $set_Ctrls[$i][3])
	ElseIf $n > $set_Ctrls[$i][4] Then
		$n = $set_Ctrls[$i][4]
		GUICtrlSetData($set_Ctrls[$i][1], $set_Ctrls[$i][4])
	EndIf
	Return $n
EndFunc   ;==>_Pinging_SetMinMax

Func GUICtrlSetState_aNics(ByRef $aNics, $iState, $iIndex)
	GUICtrlSetState($aNics[$iIndex][21], $iState)
	GUICtrlSetState($aNics[$iIndex][27], $iState)
	GUICtrlSetState($aNics[$iIndex][28], $iState)
	GUICtrlSetState($aNics[$iIndex][29], $iState)
	GUICtrlSetState($aNics[0][22], $iState)
	GUICtrlSetState($ListView_IPs, $iState)
EndFunc   ;==>GUICtrlSetState_aNics

Func _Pinging_One_Run(ByRef $aNics, $n, $iIndex)
	GUICtrlSetState_aNics($aNics, $GUI_DISABLE, $n)
	_GUICtrlListView_SetItemText($aNics[$n][21], $iIndex, "...", 2)
	Local $i, $t = TimerInit()
	Local $ip = IpRemoveLeadingZeros(_GUICtrlListView_GetItemText($aNics[$n][21], $iIndex, 0))
	$i = Ping($ip, 300)
	Switch @error
		Case 1
			$i = "offline"
		Case 2
			$i = "OFF" ; "unreachable"
		Case 3
			$i = "Bad"
		Case 4
			$i = "Other"
	EndSwitch
	SleepUpto($t) ; ..so the user can see something going on
	_GUICtrlListView_SetItemText($aNics[$n][21], $iIndex, $i, 2)
	GUICtrlSetState_aNics($aNics, $GUI_ENABLE, $n)
EndFunc   ;==>_Pinging_One_Run

Func _Pinging_Range($aNics, $iIndex, $iMaxConcurrent = 30)
	$_Pinging_Range_iIndex = $iIndex
	GUICtrlSetState_aNics($aNics, $GUI_DISABLE, $iIndex)
	_GUICtrlListView_DeleteAllItems($aNics[$iIndex][21])
	Local Static $_ComputerName = @ComputerName
	Local $cSec, $iSec = 0, $t = TimerInit(), $sOctets3 = StringLeft($aNics[$iIndex][2], StringInStr($aNics[$iIndex][2], '.', 0, -1))
	Local $aIpAddr = _GUICtrlListView_GetColumn($aNics[$iIndex][21], 0)
	Local $aIpHoNa = _GUICtrlListView_GetColumn($aNics[$iIndex][21], 1)
	Local $sMac, $sType, $a, $aRange[255][16]
	Local Enum $e_IpCount, $e_4th_RunPingPID, $e_4th_RunPingData, $e_4th_RunPingMs, $e_4th_RunStep, $e_ThisIP, $e_This3IP, _
			$e_This4oct, $e_4th_RunPingHostname, $e_4th_RunPingMAC, $e_4th_RunPingType, $e_4th_RunPingManuf, $e_lvIndex
	$aRange[0][$e_IpCount] = 254
	$aRange[0][$e_4th_RunPingPID] = 0
	For $n = 1 To $aRange[0][$e_IpCount]
		$aRange[$n][$e_4th_RunStep] = 0
		$aRange[$n][$e_4th_RunPingPID] = 0
	Next
	_GUICtrlListView_SetColumn($aNics[$iIndex][21], $aIpHoNa[8], "[ " & $iSec & " sec. ]", $aIpHoNa[4], $aIpHoNa[0])
	While 1
		$cSec = Int(TimerDiff($t) / 1000)
		If $cSec > $iSec Then
			$iSec = $cSec
			_GUICtrlListView_SetColumn($aNics[$iIndex][21], $aIpHoNa[8], "[ " & $iSec & " sec. ]", $aIpHoNa[4], $aIpHoNa[0])
		EndIf

		If GUIGetMsg() = $GUI_EVENT_CLOSE Then
			_GUICtrlListView_SetColumn($aNics[$iIndex][21], $aIpHoNa[8], $aIpHoNa[5], $aIpHoNa[4], $aIpHoNa[0])
			_GUICtrlListView_SetColumn($aNics[$iIndex][21], $aIpAddr[8], $aIpAddr[5], $aIpAddr[4], $aIpAddr[0])
			GUICtrlSetState_aNics($aNics, $GUI_ENABLE, $iIndex)
			Return
		EndIf
		For $n = 1 To $aRange[0][$e_IpCount]
			Switch $aRange[$n][$e_4th_RunStep]
				Case 1
					$aRange[$n][$e_4th_RunPingData] &= StdoutRead($aRange[$n][$e_4th_RunPingPID])
					If @error Then
						$a = StringRegExp($aRange[$n][$e_4th_RunPingData], "([0-9]*)ms", 3)
						If @error Then
							$aRange[$n][$e_4th_RunPingMs] = -1
						Else
							$aRange[$n][$e_4th_RunPingMs] = $a[0]
						EndIf
						If $aRange[$n][$e_4th_RunPingMs] > -1 Then
							ConsoleWrite(' - ' & $aRange[$n][$e_ThisIP] & ' = "' & $aRange[$n][$e_4th_RunPingMs] & '"' & @CRLF)
							$aRange[$n][$e_4th_RunStep] = 2
							$aRange[$n][$e_lvIndex] = _GUICtrlListView_AddItem($aNics[$iIndex][21], $aRange[$n][$e_This3IP])
							_GUICtrlListView_EnsureVisible($aNics[$iIndex][21], $aRange[$n][$e_lvIndex])
							_GUICtrlListView_AddSubItem($aNics[$iIndex][21], $aRange[$n][$e_lvIndex], $aRange[$n][$e_4th_RunPingMs], 2)
						Else
							$aRange[$n][$e_4th_RunStep] = 10
						EndIf
						$aRange[0][$e_4th_RunPingPID] -= 1
						$aRange[$n][$e_4th_RunPingData] = ""
					EndIf

				Case 3
					$aRange[$n][$e_4th_RunPingData] &= StdoutRead($aRange[$n][$e_4th_RunPingPID])
					If @error Then
						$aRange[$n][$e_4th_RunPingHostname] = _HostNameFromPingText($aRange[$n][$e_4th_RunPingData])
						If $aRange[$n][$e_4th_RunPingHostname] = "unknown" Then
							If $aRange[$n][$e_ThisIP] = $aNics[$iIndex][4] Then $aRange[$n][$e_4th_RunPingHostname] = "<gateway>"
						EndIf
						ConsoleWrite(' - HOSTNAME ' & $aRange[$n][$e_ThisIP] & ' = "' & $aRange[$n][$e_4th_RunPingHostname] & '"' & @CRLF)
						_GUICtrlListView_AddSubItem($aNics[$iIndex][21], $aRange[$n][$e_lvIndex], $aRange[$n][$e_4th_RunPingHostname], 1)
						$aRange[$n][$e_4th_RunStep] = 4
						$aRange[0][$e_4th_RunPingPID] -= 1
						$aRange[$n][$e_4th_RunPingData] = ""
					EndIf

				Case 5
					$aRange[$n][$e_4th_RunPingData] &= StdoutRead($aRange[$n][$e_4th_RunPingPID])
					If @error Then
						_MacFromArpText($aRange[$n][$e_ThisIP], $aRange[$n][$e_4th_RunPingData], $sMac, $sType)
						$aRange[$n][$e_4th_RunPingMAC] = $sMac
						$aRange[$n][$e_4th_RunPingType] = $sType

						If $aRange[$n][$e_4th_RunPingMAC] = "unknown" Then
							If $aRange[$n][$e_ThisIP] = $aNics[$iIndex][2] Then $aRange[$n][$e_4th_RunPingMAC] = GET_MAC($aRange[$n][$e_ThisIP])
						EndIf
						If $aRange[$n][$e_4th_RunPingMAC] = "unknown" Then
							If $_ComputerName = $aRange[$n][$e_4th_RunPingHostname] Then $aRange[$n][$e_4th_RunPingMAC] = "<this PC>"
						EndIf
						$aRange[$n][$e_4th_RunPingManuf] = _MacFromManufIni($aRange[$n][$e_4th_RunPingMAC])
						ConsoleWrite(' - MAC ' & $aRange[$n][$e_ThisIP] & ' = "' & $aRange[$n][$e_4th_RunPingMAC] & '"' & @CRLF)
						_GUICtrlListView_AddSubItem($aNics[$iIndex][21], $aRange[$n][$e_lvIndex], $aRange[$n][$e_4th_RunPingMAC], 3)
						_GUICtrlListView_AddSubItem($aNics[$iIndex][21], $aRange[$n][$e_lvIndex], $aRange[$n][$e_4th_RunPingType], 4)
						_GUICtrlListView_AddSubItem($aNics[$iIndex][21], $aRange[$n][$e_lvIndex], $aRange[$n][$e_4th_RunPingManuf], 5)
						$aRange[$n][$e_4th_RunStep] = 10
						$aRange[0][$e_4th_RunPingPID] -= 1
						$aRange[$n][$e_4th_RunPingData] = ""
					EndIf

			EndSwitch
		Next
		For $n = 1 To $aRange[0][$e_IpCount]
			If $aRange[0][$e_4th_RunPingPID] >= $iMaxConcurrent Then ExitLoop
			Switch $aRange[$n][$e_4th_RunStep]
				Case 4
					$aRange[0][$e_4th_RunPingPID] += 1
					$aRange[$n][$e_4th_RunStep] = 5
					$aRange[$n][$e_4th_RunPingPID] = Run("arp -a " & $aRange[$n][$e_ThisIP], "", @SW_HIDE, $STDOUT_CHILD)
					If $aRange[0][$e_4th_RunPingPID] >= $iMaxConcurrent Then ExitLoop

				Case 2
					$aRange[0][$e_4th_RunPingPID] += 1
					$aRange[$n][$e_4th_RunStep] = 3
					$aRange[$n][$e_4th_RunPingPID] = Run("ping -a " & $aRange[$n][$e_ThisIP] & " -n " & $aNics[0][23] & " -w " & $aNics[0][24], "", @SW_HIDE, $STDOUT_CHILD)
					If $aRange[0][$e_4th_RunPingPID] >= $iMaxConcurrent Then ExitLoop

				Case 0
					$aRange[0][$e_4th_RunPingPID] += 1
					$aRange[$n][$e_ThisIP] = $sOctets3 & $n
					$aRange[$n][$e_This4oct] = StringRight('000' & $n, 3)
					$aRange[$n][$e_This3IP] = $sOctets3 & $aRange[$n][$e_This4oct]

					_GUICtrlListView_SetColumn($aNics[$iIndex][21], $aIpAddr[8], "[ " & $aRange[$n][$e_This4oct] & " of 254 ]", $aIpAddr[4], $aIpAddr[0])

					$aRange[$n][$e_4th_RunStep] = 1
					$aRange[$n][$e_4th_RunPingPID] = Run("ping " & $aRange[$n][$e_ThisIP] & " -n " & $aNics[0][23] & " -w " & $aNics[0][24], "", @SW_HIDE, $STDOUT_CHILD)
					If $aRange[0][$e_4th_RunPingPID] >= $iMaxConcurrent Then ExitLoop

			EndSwitch
		Next
		If $aRange[0][$e_4th_RunPingPID] = 0 Then ExitLoop
	WEnd

	MacsIni_Load($aNics[$iIndex][21])

	If Not _GUICtrlListView_GetItemCount($aNics[$iIndex][21]) Then
		$aRange[1][$e_lvIndex] = _GUICtrlListView_AddItem($aNics[$iIndex][21], "")
		_GUICtrlListView_AddSubItem($aNics[$iIndex][21], $aRange[1][$e_lvIndex], "<nothing pinged>", 1)
	EndIf
	_GUICtrlListView_SetColumn($aNics[$iIndex][21], $aIpHoNa[8], $aIpHoNa[5], $aIpHoNa[4], $aIpHoNa[0])
	_GUICtrlListView_SetColumn($aNics[$iIndex][21], $aIpAddr[8], $aIpAddr[5], $aIpAddr[4], $aIpAddr[0])
	GUICtrlSetState_aNics($aNics, $GUI_ENABLE, $iIndex)
EndFunc   ;==>_Pinging_Range

Func _MacFromManufIni($sMac)
	Local Static $fIni = $ScriptFullPathNoExt & ".mac-manuf.ini", $i = FileGetSize($fIni), $fNotes = $ScriptFullPathNoExt & ".notes.ini"
	Local $s = IniRead($fNotes, "NotesByMac", $sMac, "")
	If $s <> "" Then Return $s
	If $i = 0 Then Return """.mac-manuf.ini"" is missing"
	If $sMac = "unknown" Then Return $sMac
	Local $a = StringSplit($sMac, ':')
	If UBound($a) < 6 Then Return ""
	If $s = "" Then $s = IniRead($fIni, "manuf", $a[1] & $a[2] & $a[3] & $a[4] & $a[5], "")
	If $s = "" Then $s = IniRead($fIni, "manuf", $a[1] & $a[2] & $a[3] & $a[4], "")
	If $s = "" Then $s = IniRead($fIni, "manuf", $a[1] & $a[2] & $a[3], "")
	If $s = "" Then Return "entry not found"
	$a = StringSplit($s, @TAB)
	Return $a[$a[0]]
EndFunc   ;==>_MacFromManufIni

Func _MacFromArpText($sIP, $sDOStext, ByRef $sMac, ByRef $sType)
	$sMac = ""
	$sType = ""
	Local $n, $b, $a = StringSplit($sDOStext, @CRLF)
	For $n = 1 To $a[0]
		$a[$n] = StringStripWS($a[$n], 7)
		$b = StringSplit($a[$n], " ")
		If $b[0] < 3 Then ContinueLoop
		If $b[1] = $sIP Then
			$sMac = StringUpper(StringReplace($b[2], "-", ":"))
			$sType = $b[3]
			Return
		EndIf
	Next
	$sMac = "unknown"
EndFunc   ;==>_MacFromArpText

Func _HostNameFromPingText($sDOStext)
	ConsoleWrite('+ Func _HostNameFromPingText("' & $sDOStext & '")' & @CRLF)
	Local $n, $a = StringSplit(StringStripWS($sDOStext, 7), @CRLF & " ")
	For $n = 1 To $a[0]
		If StringLeft($a[$n], 1) = "[" Then Return $a[$n - 1]
	Next
	Return "unknown"
EndFunc   ;==>_HostNameFromPingText

;~ __NetworkCards()
Func _Pinging_GetRegistryIPs_NetworkCards($Subkey = Default)
	Local Static $aFound[101], $sKeyname = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\NetworkCards"
	Local $sSubKey
	If Not $aFound[0] Then
		$aFound[0] = 0
		For $i = 1 To 100
			$sSubKey = RegEnumKey($sKeyname, $i)
			If @error Then ExitLoop
			$aFound[$i] = $sSubKey
			ConsoleWrite('- NetworkCards : ' & $sSubKey & @CRLF)
			$aFound[0] = $i
		Next
	EndIf
	If $Subkey = Default Then Return ""
	For $i = 1 To $aFound[0]
		If RegRead($sKeyname & '\' & $aFound[$i], "ServiceName") = $Subkey Then
			Return RegRead($sKeyname & '\' & $aFound[$i], "Description")
		EndIf
	Next
	Return ""
EndFunc   ;==>_Pinging_GetRegistryIPs_NetworkCards

;~ _Pinging_GetRegistryIPs()
Func _Pinging_GetRegistryIPs()
	Local $sSubKey = "" ;, $sEnumKey = "under HKLM\SOFTWARE:" & @CRLF & @CRLF
	Local $aArray[100][20]
	$aArray[0][0] = 0
	; Loop from 1 to 10 times, displaying registry keys at the particular instance value.
	For $i = 1 To 100
		$sSubKey = RegEnumKey("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters\Interfaces", $i)
		If @error Then ExitLoop
		_Pinging_GetRegistryIPs_RegEnumVal($aArray, "HKEY_LOCAL_MACHINE\SYSTEM", "\CurrentControlSet\Services\Tcpip\Parameters\Interfaces\", $sSubKey) ; & @CRLF
	Next
	ReDim $aArray[$aArray[0][0] + 1][20]
	_Pinging_GetRegistryIPs_add_NeshInterfacemetric($aArray)
	Return $aArray
;~ 	_DebugArrayDisplay($aArray, "_Pinging_GetRegistryIPs()")
EndFunc   ;==>_Pinging_GetRegistryIPs

Func _Pinging_GetRegistryIPs_add_NeshInterfacemetric(ByRef $aArray)
	Local $aPid, $sPid = "", $iPid = Run("netsh interface ip show address", "", @SW_HIDE, $STDOUT_CHILD)
	Do
		If GUIGetMsg() = $GUI_EVENT_CLOSE Then Return
		$sPid &= StdoutRead($iPid)
	Until @error

	$sPid = StringStripWS($sPid, 7)
	ConsoleWrite($sPid & @CRLF)

	$aPid = StringSplit($sPid, '"' & @CRLF)
	If UBound($aPid) < 2 Then Return
	Local $b, $i = 0, $aData[UBound($aPid) + 1][10]
	For $n = 1 To $aPid[0]
		If $aPid[$n] = "" Then
			$i += 1
			$aData[0][1] = $aPid[$n - 2]
			$aData[$i][1] = $aPid[$n - 1]
			ContinueLoop
		EndIf
		$b = StringSplit($aPid[$n], ":()")
		If $b[0] < 2 Then ContinueLoop
		Switch $b[1]
			Case "IP Address" ; : 192.168.21.1
				$aData[0][2] = $b[1]
				$aData[$i][2] = StringStripWS($b[2], 3)
			Case "Subnet Prefix" ; : 192.168.21.0/24 (mask 255.255.255.0)
				$aData[0][3] = $b[1]
				$aData[$i][3] = StringStripWS($b[2], 3)
				If $b[0] > 2 Then $aData[$i][3] &= ' (' & StringStripWS($b[3], 3) & ')'
			Case "InterfaceMetric" ; : 35
				$aData[0][4] = $b[1]
				$aData[$i][4] = StringStripWS($b[2], 8)
			Case "Default Gateway" ; : 192.168.0.1
				$aData[0][5] = $b[1]
				$aData[$i][5] = StringStripWS($b[2], 3)
			Case "Gateway Metric" ; : 256
				$aData[0][6] = $b[1]
				$aData[$i][6] = StringStripWS($b[2], 3)
			Case "DHCP enabled" ; : No
				$aData[0][7] = $b[1]
				$aData[$i][7] = StringStripWS($b[2], 3)
		EndSwitch
	Next
	ReDim $aData[$i + 1][8]
	$aData[0][0] = $i

	For $n = $aData[0][0] To 1 Step -1
		Switch $aData[$n][2]
			Case "127.0.0.1", ""
				_ArrayDelete($aData, $n)
				$aData[0][0] -= 1
				ContinueLoop
		EndSwitch
	Next

	For $n = 1 To $aData[0][0]
		For $m = 1 To $aArray[0][0]
			If $aData[$n][1] = $aArray[$m][12] Then
				$aArray[0][14] = $aData[0][4]
				$aArray[$m][14] = $aData[$n][4]
				$aArray[0][15] = $aData[0][2] & " " & $aData[0][3]
				$aArray[$m][15] = $aData[$n][2] & " " & $aData[$n][3]
			EndIf
		Next
	Next
	For $m = 1 To $aArray[0][0]
		If $aArray[$m][14] = "" Then
			$aArray[$m][14] = 999
			$aArray[$m][2] &= ' [?]'
		EndIf
	Next

	_ArraySort($aArray, 0, 1, 0, 14)
	For $m = 1 To $aArray[0][0]
		If $aArray[$m][14] = 999 Then
			$aArray[$m][14] = ""
		EndIf
	Next
EndFunc   ;==>_Pinging_GetRegistryIPs_add_NeshInterfacemetric

Func _Pinging_GetRegistryIPs_RegEnumVal(ByRef $aArray, $knPre = "HKEY_LOCAL_MACHINE\SOFTWARE", $knSuff = "\AutoIt v3\", $sSubKey = "AutoIt")
	Local $sValue, $ext, $i, $sVar, $sWow64 = "", $sEnumVal = "Under """ & $sSubKey & """ key." & @CRLF & @CRLF
	Local $aRegValueType[12] = ["REG_NONE", "REG_SZ", "REG_EXPAND_SZ", "REG_BINARY", _
			"REG_DWORD_LITTLE_ENDIAN", "REG_DWORD_BIG_ENDIAN", "REG_LINK", _
			"REG_MULTI_SZ", "REG_RESOURCE_LIST", "REG_FULL_RESOURCE_DESCRIPTOR", _
			"REG_RESOURCE_REQUIREMENTS_LIST", "REG_QWORD_LITTLE_ENDIAN"]

	; X64 running support
	If @AutoItX64 Then $sWow64 = "" ; "\Wow6432Node"

	Local $n = 0
	For $i = 1 To 100
		$sVar = RegEnumVal($knPre & $sWow64 & $knSuff & $sSubKey, $i)
		If @error <> 0 Then ExitLoop
		If Not $n Then
			$aArray[0][0] += 1
			$n = $aArray[0][0]
			$aArray[$n][0] = $sSubKey
			$aArray[0][12] = "NetworkConnectionName"
;~ 			$aArray[0][13] = "Intranet"
			$aArray[0][13] = "Desc."
			$aArray[$n][12] = RegRead("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Network\{4D36E972-E325-11CE-BFC1-08002BE10318}\" & $sSubKey & "\Connection", "Name")
			$aArray[$n][13] = _Pinging_GetRegistryIPs_NetworkCards($sSubKey)
		EndIf
		$ext = @extended
		$sValue = RegRead($knPre & $sWow64 & $knSuff & $sSubKey, $sVar)
		$sEnumVal &= "# " & StringRight('00' & $i, 2) & ":" & StringLeft($aRegValueType[$ext] & "                         ", 31) & $sVar & @TAB & $sValue & @CRLF

		Switch $sVar
			Case "EnableDHCP"
				$aArray[0][1] = $sVar
				$aArray[$n][1] = ($sValue = 0 ? 'NO' : 'YES')
			Case "DhcpIPAddress", "IPAddress"
				$aArray[0][2] = $sVar
				$aArray[$n][2] = $sValue
			Case "DhcpSubnetMask", "SubnetMask"
				$aArray[0][3] = $sVar
				$aArray[$n][3] = $sValue
			Case "DhcpDefaultGateway", "DefaultGateway"
				$aArray[0][4] = $sVar
				$aArray[$n][4] = $sValue
			Case "DhcpServer", "Server"
				$aArray[0][5] = $sVar
				$aArray[$n][5] = $sValue
			Case "DhcpDomain", "Domain"
				$aArray[0][6] = $sVar
				$aArray[$n][6] = $sValue
			Case "DhcpNameServer", "NameServer"
				$aArray[0][7] = $sVar
				$aArray[$n][7] = $sValue
			Case "LeaseObtainedTime"
				$aArray[0][8] = $sVar
				$aArray[$n][8] = StringReplace(_DateAdd('s', $sValue, "1970/01/01 00:00:00"), '/', '.')
			Case "LeaseTerminatesTime"
				$aArray[0][9] = $sVar
				$aArray[$n][9] = StringReplace(_DateAdd('s', $sValue, "1970/01/01 00:00:00"), '/', '.')
			Case "Lease"
				$aArray[0][10] = $sVar
				$aArray[$n][10] = _StringFormatMs($sValue * 1000)
			Case "DefaultGatewayMetric"
				$aArray[0][11] = $sVar
				$aArray[$n][11] = $sValue
				$aArray[$n][1] &= ' [DGM:' & $sValue & ']'
		EndSwitch
	Next
	If ($aArray[$n][2] = "" And $aArray[$n][1] <> "") Or ($aArray[$n][2] = "0.0.0.0") Then
		For $m = 0 To 19
			$aArray[$n][$m] = ""
		Next
		$aArray[0][0] -= 1
	EndIf

	Return $sEnumVal
EndFunc   ;==>_Pinging_GetRegistryIPs_RegEnumVal

#todo

Func _StringFormatMs($ms, $bRetMs = False) ; based on https://www.autoitscript.com/forum/topic/163621-convert-ms-to-dayhourminsec/?do=findComment&comment=1192334
	Local $sRetMs = "", $day = "", $hour, $min, $sec
	_TicksToTime($ms, $hour, $min, $sec)
	If $hour >= 24 Then
		$day = Int($hour / 24)
		$hour = Mod($hour, 24)
	EndIf
	If $bRetMs Then $sRetMs = "." & StringRight($ms, 3)
	Switch StringLen($day)
		Case 0
			Return StringFormat("%02i:%02i:%02i", $hour, $min, $sec) & $sRetMs
		Case 1, 2, 3
			Return StringFormat("%03i %02i:%02i:%02i", $day, $hour, $min, $sec) & $sRetMs
		Case Else
			Return $day & " " & StringFormat("%02i:%02i:%02i", $hour, $min, $sec) & $sRetMs
	EndSwitch
EndFunc   ;==>_StringFormatMs

Func __WM_NOTIFY($hWnd, $iMsg, $wParam, $lParam)
	#forceref $hWnd, $iMsg, $wParam
	If $_a__WM_NOTIFY[0] Then Return $GUI_RUNDEFMSG
	Local $hWndFrom, $iCode, $tNMHDR, $tInfo
	$tNMHDR = DllStructCreate($tagNMHDR, $lParam)
	$hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
	$iCode = DllStructGetData($tNMHDR, "Code")
	Switch $iCode
		Case $NM_CLICK, $NM_DBLCLK, $NM_RCLICK, $LVN_COLUMNCLICK ;, $NM_RDBLCLK
			$tInfo = DllStructCreate($tagNMITEMACTIVATE, $lParam)
			$_a__WM_NOTIFY[1] = $hWndFrom
			$_a__WM_NOTIFY[2] = $iCode
			$_a__WM_NOTIFY[3] = DllStructGetData($tInfo, "Index")
			$_a__WM_NOTIFY[4] = DllStructGetData($tInfo, "SubItem")
			$_a__WM_NOTIFY[5] = DllStructGetData($tInfo, "ActionX")
			$_a__WM_NOTIFY[6] = DllStructGetData($tInfo, "ActionY")
			$_a__WM_NOTIFY[0] = 1
			;Return 1 ; not to allow the default processing
			;Return 0         ; allow the default processing
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>__WM_NOTIFY

#Region WOL
Func WakeOnlan($ip, $subNet, $mac)
	ConsoleWrite('Func WakeOnlan("' & $ip & '", "' & $subNet & '", "' & $mac & '")' & @CRLF)
	UDPStartup()
	Local $conn, $res, $aPorts[] = [7, 9, 2304, 65535] ; it should be just [7] but I'm not sure
	For $n = 0 To UBound($aPorts) - 1
		$conn = UDPOpen(_GetLocalBroadcast($ip, $subNet), $aPorts[$n])
		$res = UDPSend($conn, GenerateMagicPacket($mac))
		ConsoleWrite("The magic packet was fired on port " & $aPorts[$n] & ". " & $res & @CRLF)
		UDPCloseSocket($conn)
		Sleep(50)
	Next
	UDPShutdown()
EndFunc   ;==>WakeOnlan
Func _GetLocalBroadcast($ip, $sMask) ; This function retrieve the Broadcast address of this LAN
	Local $aIPAddress = StringSplit($ip, '.'), $aSubnetMask = StringSplit($sMask, '.'), $sIP = ''
	For $i = 1 To $aIPAddress[0] ; http://www.autoitscript.com/forum/topic/29772-copyright-free-wake-on-lan-script/page__hl__%20lan%20%20scanner
		$aIPAddress[$i] = BitOR($aIPAddress[$i], BitNOT($aSubnetMask[$i] - 256))
		$sIP &= $aIPAddress[$i] & '.'
	Next
	Return StringTrimRight($sIP, 1)
EndFunc   ;==>_GetLocalBroadcast
Func GenerateMagicPacket($strMACAddress) ; This function generate the "Magic Packet"
	$strMACAddress = StringStripWS(StringReplace(StringReplace(StringReplace(StringReplace($strMACAddress, "<", ""), ">", ""), ":", ""), "-", ""), 8)
	Local $MagicPacket = ""
	Local $MACData = ""
	For $p = 1 To 11 Step 2
		$MACData = $MACData & HexToChar(StringMid($strMACAddress, $p, 2))
	Next
	For $p = 1 To 6
		$MagicPacket = HexToChar("FF") & $MagicPacket
	Next
	For $p = 1 To 16
		$MagicPacket = $MagicPacket & $MACData
	Next
	Return $MagicPacket
EndFunc   ;==>GenerateMagicPacket
Func HexToChar($strHex) ; This function convert a MAC Address Byte (e.g. "1F") to a char
	Return Chr(Dec($strHex))
EndFunc   ;==>HexToChar
#EndRegion WOL

;MsgBox(0, "MAC Address:", GET_MAC(@IPAddress1))
Func GET_MAC($_MACsIP)
	Local $_MAC, $_MACSize
	Local $_MACi, $_MACs, $_MACr, $_MACiIP
	$_MAC = DllStructCreate("byte[6]")
	$_MACSize = DllStructCreate("int")
	DllStructSetData($_MACSize, 1, 6)
	$_MACr = DllCall("Ws2_32.dll", "int", "inet_addr", "str", $_MACsIP)
	$_MACiIP = $_MACr[0]
	$_MACr = DllCall("iphlpapi.dll", "int", "SendARP", "int", $_MACiIP, "int", 0, "ptr", DllStructGetPtr($_MAC), "ptr", DllStructGetPtr($_MACSize))
	$_MACs = ""
	For $_MACi = 0 To 5
		If $_MACi Then $_MACs = $_MACs & ":"
		$_MACs = $_MACs & Hex(DllStructGetData($_MAC, 1, $_MACi + 1), 2)
	Next
	DllClose($_MAC)
	DllClose($_MACSize)
	Return $_MACs
EndFunc   ;==>GET_MAC

Func _ArrayFromString($s, $sDelim_Col = "|", $sDelim_Row = @CRLF, $iForce2D = 0) ; https://www.autoitscript.com/forum/topic/197277-_arrayfromstring/
	Local $m, $n, $b, $c = StringSplit($s, $sDelim_Row, 3)
	$b = StringSplit($c[0], $sDelim_Col, 3)
	If UBound($c) = 1 And Not $iForce2D Then
		For $m = 0 To UBound($b) - 1
			If $b[$m] == Int($b[$m]) Then $b[$m] = Int($b[$m])
		Next
		Return $b
	EndIf
	Local $a[UBound($c)][UBound($b)]
	For $n = 0 To UBound($c) - 1
		$b = StringSplit($c[$n], $sDelim_Col, 3)
		If UBound($b) > UBound($a, 2) Then Return SetError(1)
		For $m = 0 To UBound($b) - 1
			If $b[$m] == Int($b[$m]) Then $b[$m] = Int($b[$m])
			$a[$n][$m] = $b[$m]
		Next
	Next
	Return $a
EndFunc   ;==>_ArrayFromString

#Region about this
Func About_IfCmdLine()
	If StringInStr($CmdLineRaw, "/About") Then
		About_Box()
		Exit 0
	EndIf
EndFunc   ;==>About_IfCmdLine
Func About_Box($1 = 0)
	; https://www.autoitscript.com/forum/topic/44889-create-an-about-window/?do=findComment&comment=334569
	Opt("GUICloseOnESC", 1)
	Opt("GUIOnEventMode", 1)

	Local $aGui[10]
	$aGui[0] = 250
	$aGui[1] = 150
	If $1 Then $aGui[1] += 100 ; "This, unfortunately, will not run in your system."
	$aGui[2] = -1
	$aGui[3] = -1
	$aGui[4] = "About:  " & StringTrimRight(@ScriptName, 4)
	If $1 Then $aGui[4] = "Error:  " & StringTrimRight(@ScriptName, 4)
	If WinExists("[TITLE:" & $aGui[4] & ";CLASS:AutoIt v3 GUI;]") Then Exit 0
	$aGui[5] = GUICreate($aGui[4], $aGui[0], $aGui[1], $aGui[2], $aGui[3], BitOR($WS_CAPTION, $WS_SYSMENU), $WS_EX_TOPMOST)
	If FileGetSize($Form_ico) Then GUISetIcon($Form_ico)
	_WinAPI_SetCurrentProcessExplicitAppUserModelID("AutoIt v3 GUI." & StringTrimRight(@ScriptName, 4) & ".Unique") ; & @AutoItPID & "string") ; ..this is not needed, ..but so cool  :-)
	$aGui[6] = StringTrimRight(@ScriptName, 4)
	GUISetOnEvent($GUI_EVENT_CLOSE, "About_OK")

	GUICtrlCreateIcon($aGui[6] & ".exe", -1, 11, 11)

	GUICtrlCreateLabel(" " & $Form_Title, 60, 15, $aGui[0], 20)
	GUICtrlSetFont(-1, 10, 800, 0, "Arial") ; bold
	GUICtrlCreateLabel("v. " & FileGetVersion(@ScriptDir & "\" & $aGui[6] & ".exe") & "" & @CR & "by argumentum", 60, 40, $aGui[0] - 65, 40)

	Local $www = GUICtrlCreateLabel("www.autoitscript.com/forum/", 59, 75, 140, 15)
	GUICtrlSetFont($www, 8.5, -1, 4) ; underlined
	GUICtrlSetColor($www, _WinAPI_SwitchColor(_WinAPI_GetSysColor($COLOR_HOTLIGHT)))
	GUICtrlSetCursor($www, 0)
	GUICtrlSetOnEvent(-1, "About_WWW")

	GUICtrlCreateButton("OK", ($aGui[0] / 2) - 50, $aGui[1] - 40, 100, 25, BitOR($GUI_SS_DEFAULT_BUTTON, $BS_DEFPUSHBUTTON))
	GUICtrlSetState(-1, $GUI_FOCUS)
	GUICtrlSetOnEvent(-1, "About_OK")

	GUISetState(@SW_SHOW)

	While 1
		Sleep(100)
	WEnd
EndFunc   ;==>About_Box
Func About_WWW()
	ShellExecute("https://www.autoitscript.com/forum/topic/201427-ping-discover-local-ips/")
;~ 	ShellExecute("https://www.autoitscript.com/forum/profile/4574-argumentum/content/?type=downloads_file")
	About_OK()
EndFunc   ;==>About_WWW
Func About_OK()
	GUIDelete()
	If Int(Eval("iErrorHandler")) Then Exit 8
	Exit 0
EndFunc   ;==>About_OK
Func GetSystemMenu($hWnd, $bRevert) ; https://www.autoitscript.com/forum/topic/113080-change-title-bar-context-menu/?do=findComment&comment=791773
	Local $hMenu = DllCall("user32.dll", "hwnd", "GetSystemMenu", _
			"hwnd", $hWnd, _
			"int", $bRevert)
	Return $hMenu[0]
EndFunc   ;==>GetSystemMenu
Func InsertMenu($hMenu, $nPosition, $nFlags, $nIDNewItem, $lpNewItem)
	Local $nResult = DllCall("user32.dll", "int", "InsertMenu", _
			"hwnd", $hMenu, _
			"int", $nPosition, _
			"int", $nFlags, _
			"int", $nIDNewItem, _
			"str", $lpNewItem)
	Return $nResult[0]
EndFunc   ;==>InsertMenu
Func CreatePopupMenu()
	Local $hMenu = DllCall("user32.dll", "hwnd", "CreatePopupMenu")
	Return $hMenu[0]
EndFunc   ;==>CreatePopupMenu
Func CheckMenuItem($hMenu, $nID, $nFlags)
	DllCall("user32.dll", "int", "CheckMenuItem", _
			"hwnd", $hMenu, _
			"int", $nID, _
			"int", $nFlags)
EndFunc   ;==>CheckMenuItem
Func CreateSystemMenuItem($sText, $hMenu = -1, $bIsPopup = False, $nPos = 0xFFFFFFFF) ; 0xFFFFFFFF means "insert at the end"
	If $hMenu = -1 Then $hMenu = GetSystemMenu($_Pinging_GUI_Form, 0)
	Local $nID = GUICtrlCreateDummy()
	Local $nFlags = 0
	If $sText = "" Then
		$nFlags = $MF_SEPARATOR
	ElseIf $bIsPopup Then
		$nID = CreatePopupMenu()
		$nFlags = $MF_POPUP
	EndIf
	$nFlags = BitOR($MF_BYPOSITION, $nFlags)
	InsertMenu($hMenu, $nPos, $nFlags, $nID, $sText)
	Return $nID
EndFunc   ;==>CreateSystemMenuItem
Func WM_SYSCOMMAND($hWnd, $Msg, $wParam, $lParam)
	#forceref $hWnd, $Msg, $lParam
	Switch BitAND($wParam, 0x0000FFFF)
		Case $WCM_nItem1
			ShellExecute(@ScriptFullPath, "/About")
	EndSwitch
EndFunc   ;==>WM_SYSCOMMAND
#EndRegion about this
