#include "jq.au3"

Const $JSON = _
			  '{' & @CRLF & _
			  '  "store":{' & @CRLF & _
			  '    "book":[' & @CRLF & _
			  '      {"category":"reference","author":"Nigel Rees"      ,"title":"Sayings of the Century"                       ,"price":8.95 ,"qty":36},' & @CRLF & _
			  '      {"category":"fiction"  ,"author":"Evelyn Waugh"    ,"title":"Sword of Honour"                              ,"price":12.99,"qty":48},' & @CRLF & _
			  '      {"category":"fiction"  ,"author":"Herman Melville" ,"title":"Moby Dick"             ,"isbn":"0-553-21311-3","price":8.99 ,"qty":22},' & @CRLF & _
			  '      {"category":"fiction"  ,"author":"J. R. R. Tolkien","title":"The Lord of the Rings" ,"isbn":"0-395-19395-8","price":22.99,"qty":12}' & @CRLF & _
			  '    ],' & @CRLF & _
			  '    "bicycle":{"color":"red","price":19.95,"qty":5}' & @CRLF & _
			  '  }' & @CRLF & _
			  '}'

Global $sExePath


;Init jq processing
$sExePath = _jqInit()
If @error Then
	ConsoleWrite(StringFormat("ERROR: Unable to initialize jq - @error = %s", @error) & @CRLF)
	Exit -1
EndIf


;=========================================================
; Examples - Uncomment the ones you would like to execute
;=========================================================

show_path_and_version()

;~ pretty_print_json_example()
;~ compact_print_json_example()

;~ json_example("Get title of second book in store"                , $JSON, '.store.book[1].title')
;~ json_example("Get title of second book in store using getpath()", $JSON, 'getpath(["store", "book", 1, "title"])')
;~ json_example("Get multiple values"                              , $JSON, '.store.book[0].title, .store.book[1].title')
;~ json_example("Get title of first 3 books (using array slicing)" , $JSON, '.store.book[0:3][].title')
;~ json_example("Get list all book titles"                         , $JSON, '.store.book[].title')
;~ json_example("Get list all reference book titles"               , $JSON, '.store.book[] | select(.category == "reference") | .title')
;~ json_example("Get list of books without an isbn"                , $JSON, '.store.book[] | select( has("isbn") == false )')
;~ json_example("Get total price of all books"                     , $JSON, '.store.book | map(.price) | add')
;~ json_example("Get total price * qty of all books"               , $JSON, '.store.book | map(.price * .qty) | add')
;~ json_example("Get count of all books"                           , $JSON, '.store.book | length')
;~ json_example("Get the average price of all books"               , $JSON, '.store.book | map(.price) | add / length')
;~ json_example("Get the price of a specific book"                 , $JSON, '.store.book[] | select(.title == "Moby Dick") | .price')
;~ json_example("Check if store key exists"                        , $JSON, '.store | has("bicycle")')
;~ json_example("Check if store key exists"                        , $JSON, '.store | has("candy")')
;~ json_example("List all store keys"                              , $JSON, '.store | keys[]')
;~ json_example("Check if 3rd store book has isbn key"             , $JSON, '.store.book[2] | has("isbn")')
;~ json_example("Check if 1st store book has isbn key using nth()" , $JSON, '.store.book | nth(0) | has("isbn")')
;~ json_example("Check if 3rd store book has isbn key using nth()" , $JSON, '.store.book | nth(2) | has("isbn")')

;~ json_dump_example()
;~ modify_json_value()
;~ write_json_example()


Func show_path_and_version()
	;Show jq version info
	ConsoleWrite(@CRLF)
	ConsoleWrite(StringFormat("jq Path        = %s", $sExePath)       & @CRLF)
	ConsoleWrite(StringFormat("jq UDF Version = %s", _jqUdfVersion()) & @CRLF)
	ConsoleWrite(StringFormat("jq Version     = %s", _jqVersion())    & @CRLF)
EndFunc

Func pretty_print_json_example()
	Local $sCmdOutput = _jqPrettyPrintJson($JSON)           ;From string example
;~ 	Local $sCmdOutput = _jqPrettyPrintJsonFile("test.json") ;From file   example

	ConsoleWrite(@CRLF)
	ConsoleWrite("Desc   : Pretty-print JSON" & @CRLF)
	ConsoleWrite("Input  : " & $JSON & @CRLF)
	ConsoleWrite("Output : " & @CRLF & $sCmdOutput & @CRLF)
EndFunc

Func compact_print_json_example()
	Local $sCmdOutput = _jqCompactPrintJson($JSON)

	ConsoleWrite(@CRLF)
	ConsoleWrite("Desc   : Compact-print JSON" & @CRLF)
	ConsoleWrite("Input  : " & $JSON & @CRLF)
	ConsoleWrite("Output : " & @CRLF & $sCmdOutput & @CRLF)
EndFunc

Func json_example($sDesc, $sJson, $sFilter, $sOptions = Default)
	Local $sCmdOutput = _jqExec($JSON, $sFilter, $sOptions)

	ConsoleWrite(@CRLF)
	ConsoleWrite("Desc   : " & $sDesc & @CRLF)
	ConsoleWrite("Filter : " & $sFilter & @CRLF)
	ConsoleWrite("Output : " & @CRLF & $sCmdOutput & @CRLF)
EndFunc

Func write_json_example()
	Local $sFilter    = '{fld1 : 1, "fld2" : [1,2,3], fld3 : "Apple", "01. Special" : "This rocks!"}'
	Local $sCmdOutput = _jqExec($JSON, $sFilter)

	ConsoleWrite(@CRLF)
	ConsoleWrite("Desc  : Write json object" & @CRLF)
	ConsoleWrite('Filter: ' & $sFilter & @CRLF)
	ConsoleWrite('Output: ' & @CRLF & $sCmdOutput & @CRLF)
EndFunc

Func modify_json_value()
	Local $sFilter    = 'setpath(["store", "book", 1, "price"]; 14.25)'
	Local $sCmdOutput = _jqExec($JSON, $sFilter)

	ConsoleWrite(@CRLF & "Modify 2nd book's price to 14.25" & @CRLF)
	ConsoleWrite('Filter: ' & $sFilter & @CRLF)
	ConsoleWrite('Before: ' & @CRLF & _jqPrettyPrintJson($JSON) & @CRLF)
	ConsoleWrite('After: ' & @CRLF & $sCmdOutput & @CRLF)

	$sFilter    = 'setpath(["store", "book", 0, "price"]; 9.99) | setpath(["store", "bicycle", "color"]; "green")'
	$sCmdOutput = _jqExec($JSON, $sFilter)

	ConsoleWrite(@CRLF & "Modify 1st book's price to 9.99 and bike color to green" & @CRLF)
	ConsoleWrite('Filter: ' & $sFilter & @CRLF)
	ConsoleWrite('Before: ' & @CRLF & _jqPrettyPrintJson($JSON) & @CRLF)
	ConsoleWrite('After: ' & @CRLF & $sCmdOutput & @CRLF)
EndFunc

Func json_dump_example()
	Local $sCmdOutput = _jqDump($JSON)

	ConsoleWrite(@CRLF)
	ConsoleWrite("Desc   : Dump all paths & values in JSON" & @CRLF)
	ConsoleWrite("Output : " & @CRLF & $sCmdOutput & @CRLF)
EndFunc
