Global $vernr="1.02 (24.06.2020)"
;by Dan_55 - Free to use.
;Version 1.02 - (24.06.2020) - Reloading the last used language on start.
;Version 1.01 - (23.06.2020) - Hotkey bugfix, Clipboard restoring.
;Version 1.00 - (23.06.2020) - Initial release

#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=Snipicon.ico
#AutoIt3Wrapper_Outfile=SimpleSnippetManager.exe
#AutoIt3Wrapper_Outfile_x64=SimpleSnippetManagerX64.exe
#AutoIt3Wrapper_Compile_Both=y
#AutoIt3Wrapper_UseX64=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#include <WindowsConstants.au3>
#include <ButtonConstants.au3>
#include <File.au3>
#include <FileConstants.au3>
#include <GUIConstantsEx.au3>
#include <GuiEdit.au3>
#include <GuiTreeView.au3>
#include <GuiComboBox.au3>
#include <GuiListView.au3>
#include <ListViewConstants.au3>
#include <ListBoxConstants.au3>
#include <Misc.au3>
#include <String.au3>
#include <TreeViewConstants.au3>
#include <WinAPIFiles.au3>


Global $closecounter = 0, $TimeHandle = TimerInit(), $TimeDiff = TimerDiff($TimeHandle)
Global $formTitle

AutoItSetOption("TrayAutoPause", 0)

Local $formTitleMain = "Simple Snippet Manager " & $vernr
$formTitle = $formTitleMain

Global $h_SnipForm = GUICreate($formTitle, 307, 664, -1, -1, BitOR($GUI_SS_DEFAULT_GUI, $WS_MAXIMIZEBOX, $WS_SIZEBOX, $WS_THICKFRAME, $WS_TABSTOP))
Global $h_BTNFont = GUICtrlCreateButton("Font", 3, 446, 40, 17)
GUICtrlSetTip(-1, "Change the font of the edit field.")
Global $h_BTNCopyAll = GUICtrlCreateButton("Copy All", 63, 446, 50, 17)
GUICtrlSetTip(-1, "Copy the whole Text to Clipboard.")
Global $h_BTNCopySel = GUICtrlCreateButton("Copy Sel", 120, 446, 50, 17)
GUICtrlSetTip(-1, "Copy selected Text to Clipboard.")
Global $h_CB_Lock = GUICtrlCreateCheckbox("", 289, 447, 15, 14)
GUICtrlSetTip(-1, "Lock/Unlock editing.")
Global $h_Tree = GUICtrlCreateTreeView(3, 26, 300, 420, BitOR($TVS_HASBUTTONS, $TVS_HASLINES, $TVS_LINESATROOT, $TVS_SHOWSELALWAYS), $WS_EX_CLIENTEDGE)
Global $h_SnipCombo = GUICtrlCreateCombo("", 80, 2, 153, 25, $CBS_DROPDOWNLIST)
GUICtrlSetTip(-1, "Language Selection.")
Global $h_BTNDir = GUICtrlCreateButton("Get Lang", 2, 2, 74, 21)
GUICtrlSetTip(-1, "Get/Refresh the selected Language.")
Global $h_BTNCFG = GUICtrlCreateButton("Config", 248, 2, 54, 21)
GUICtrlSetTip(-1, "Configuration options.")
Global $h_SnipEdit = GUICtrlCreateEdit("", 2, 463, 302, 176, BitOR($ES_WANTRETURN, $WS_VSCROLL, $WS_HSCROLL, $ES_AUTOVSCROLL, $ES_AUTOHSCROLL))
$h_StatusBar1 = _GUICtrlStatusBar_Create($h_SnipForm)
Global $h_StatusBar = $h_StatusBar1
Global $cfg_confirm, $cfg_UseExtedit
Global $cfg_exteditor, $cfg_exteditparam
Global $cfg_StartLoad=1 , $cfg_StartLoadNr=-1
Global $cfg_StartLoadName=""

_GUICtrlEdit_SetLimitText($h_SnipEdit, 9256000)

Global $h_TMenu = GUICtrlCreateContextMenu($h_Tree)
Global $m_newfolder = GUICtrlCreateMenuItem("New Folder", $h_TMenu)
GUICtrlCreateMenuItem("", $h_TMenu)
Global $m_move = GUICtrlCreateMenuItem("Move or Delete Files + Folders", $h_TMenu)
Global $m_edit = GUICtrlCreateMenuItem("New/Edit File", $h_TMenu)
Global $tmpmsg = ""
GUISetState(@SW_SHOW)

Global $aFont
Dim $aFont[8]    ;Font array definition
Global $f_Italic, $f_Strikethru, $f_Underline

Global $snip_inidir = @ScriptDir, $snip_inifile = ""
Local $tmp, $tmp0, $tmp1
Local $activelock, $activetimer

If FileExists($snip_inidir) Then
	If StringRight($snip_inidir, 1) <> "\" Then $snip_inidir = $snip_inidir & "\"
EndIf

$snip_inifile = $snip_inidir & "snippetcfg.ini"


;Divide Toolbar in parts:
Global $aTBpart[2] = [200, 200]
_GUICtrlStatusBar_SetParts($h_StatusBar, $aTBpart)

;Global $snipfolder="D:\BB3D\IDEal\Snippets\", $snipext="*.bb" , $snip_lng="Blitzbasic"
Global $snipfolder = "", $snipext = "", $snip_lng = "", $snipextpure = ""
Global $FilesMaxI = 4000, $FolderMaxI = 400, $toggle = -1, $Snip_procID, $Snip_ProcHWND

Global $FilesID[$FilesMaxI][2]                ;0=ID, 1=Path+fname
Global $FolderID[$FolderMaxI][2]            ;0=ID, 1=Path

Global $maxlang = 10, $snipLang = -1
Global $a_snipc[$maxlang]
Global $h_Tree1
Global $a_TreeCheck
Dim $a_TreeCheck[6]

Local $FP, $fn, $FX, $did
;********* Hotkey Gui *************
;If $HKSTRING is changed, make sure to adjust the $z number in the SetHotkeyKeys function.
Local $HKSTRING = "[;][#;Win][!;Alt][+;Shift][^;Ctrl][0;0][1;1][2;2][3;3][4;4][5;5][6;6][7;7][8;8][9;9][a;a][b;b][c;c][d;d][e;e][f;f][g;g][h;h][i;i][j;j][k;k][l;l][m;m][n;n][o;o][p;p][q;q][r;r][s;s][t;t][u;u][v;v][w;w][x;x][y;y][z;z][{PAUSE};Pause][{BREAK};Break][{HOME};Home/Pos1][{END};END][{PGUP};Page UP][{PGDN};Page Down][{F1};F1][{F2};F2][{F3};F3][{F4};F4][{F5};F5][{F6};F6][{F7};F7][{F8};F8][{F9};F9][{F10};F10][{F11};F11][{F12};F12][{SPACE};Space]"
Local $HKT = _StringBetween($HKSTRING, "[", "]")
Global $HK, $HKS
Global $h_HotkeyTestInput
Dim $HK[0][2]                            ;Hotkey keys+names
Dim $HKS[6]                              ;Hotkey (ini)settings 0-3 combo boxes, 4 = Redirect the hotkey test to the input box, 5=Current Hotkey Set.

For $x = 0 To UBound($HKT) - 1            ;Make an array including the text from HKSTRING
	_ArrayAdd($HK, $HKT[$x], 0, ";")
Next

$HKT = ""
$HKSTRING = ""
SetHotkeyKeys(0)                    ;Set the initial hotkey
;********* Hotkey Gui *************
GUIRegisterMsg($WM_SIZE, "WM_SIZE")
GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")

GetIniFont($h_SnipEdit)
GetIniLock()
IniGet()
IniCFGLoad()

If $cfg_StartLoad=1 Then			;Load last used language at start.
	_GUICtrlComboBox_GetLBText($h_SnipCombo, $cfg_StartLoadNr, $tmp)
	if $tmp=$cfg_StartLoadName Then
		_GUICtrlComboBox_SetCurSel($h_SnipCombo,$cfg_StartLoadNr)
		$tmp1=_GUICtrlComboBox_GetCurSel($h_SnipCombo)
		if $tmp1>-1 then $snipLang = $a_snipc[$tmp1]
		RefreshLang()
		$tmp=""
		$tmp1=""
	EndIf
EndIf

While 1
	If WinActive($h_SnipForm) Then                        ;Check if the window is active
		if $activelock>1 then WriteToolBar ("The hotkey is enabled")
		$activelock = 0
	Else
		If $activelock = 0 Then
			$activelock = 1
			$activetimer = TimerInit()
		EndIf
		If $activelock = 1 And TimerDiff($activetimer) > 60000 Then ;Limit the hotkey usage to 1 minute. - to prevent accidental pasting
			$activelock = 2
			WriteToolBar ("The hotkey was disabled.")
		EndIf
	EndIf

	If $closecounter = 1 And TimerDiff($TimeHandle) > 1000 Then
		$closecounter = 0
		WinSetTitle($h_SnipForm, "", $formTitle)
	EndIf

	$nMsg = GUIGetMsg()
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			If $closecounter = 1 Then
				If TimerDiff($TimeHandle) <= 1000 Then
					ExitLoop
				EndIf
			EndIf
			If $closecounter = 0 Then
				$closecounter = 1
				$TimeHandle = TimerInit()
				WinSetTitle($h_SnipForm, "", "Doubleclick to close")
			EndIf
		Case $h_BTNCopyAll
			ClipPut(GUICtrlRead($h_SnipEdit))
		Case $h_BTNCopySel
			ControlFocus($h_SnipForm, "", $h_SnipEdit)
			Send("^c")
		Case $h_CB_Lock
			SetIniLock()
		Case $h_BTNFont
			SetFont($h_SnipEdit, $h_SnipForm)
		Case $m_newfolder
			NewFolder()
		Case $m_move
			TreeMenuCheckItem()
			$h_XT = $a_TreeCheck[0]
			$did = $a_TreeCheck[1]
			$FP = $a_TreeCheck[2]
			$FX = $a_TreeCheck[3]
			$h_Bold = $a_TreeCheck[4]
			$fn = $a_TreeCheck[5]
			If $cfg_confirm = 1 Then
				$iMsgBoxAnswer = MsgBox(8257, "Please confirm", "By clicking the OK button, windows explorer will open." & @CRLF & "There, you can move, delete or rename the files/folders." & @CRLF & @CRLF & "If anything is changed, the Language needs to be reloaded.")
			Else
				$iMsgBoxAnswer = 1
			EndIf
			Select
				Case $iMsgBoxAnswer = 1 ;OK
					ShellExecute($FP)
					MsgBox(8256, "Confirm reload.", "The language has to be reloaded after" & @CRLF & "you have moved/deleted the files/folders" & @CRLF & @CRLF & "Click ok to do so, now")
					RefreshLang()
			EndSelect

		Case $m_edit
			TreeMenuCheckItem()
			$h_XT = $a_TreeCheck[0]
			$did = $a_TreeCheck[1]
			$FP = $a_TreeCheck[2]
			$FX = $a_TreeCheck[3]
			$h_Bold = $a_TreeCheck[4]
			$fn = $a_TreeCheck[5]

			If $h_Bold = True Then                                                                ;The treeview text is in bold - it is a folder !
				$fn = ""
				$tmp0 = ""
			Else                                                                                ;It is a file
				$fn = _StringSearchSplit($fn, ".", "R", "L")
				$tmp0 = $fn & "." & $snipextpure
			EndIf
			If $snipextpure <> "" Then
				WinSetState($h_SnipForm, "", @SW_DISABLE)
				If $cfg_UseExtedit = 0 Then
					Snip_Edit($FP, $fn)
				Else
					If $cfg_exteditor <> "" Then
						$tmp = ""
						If $cfg_exteditparam <> "" Then $tmp = " "
						ShellExecuteWait($cfg_exteditor, $cfg_exteditparam & $tmp & $FP & $tmp0)
					Else
						ShellExecuteWait($FP & $tmp0)
					EndIf
				EndIf
				WinSetState($h_SnipForm, "", @SW_ENABLE)
				WinActivate($h_SnipForm)
				$formTitle = $formTitleMain
				$closecounter = 0
				$h_StatusBar = $h_StatusBar1
				RefreshLang()
				GUIGetMsg()
			Else
				WriteToolBar("Err. Please load a language !")
			EndIf
		Case $h_BTNDir
			RefreshLang()
		Case $h_SnipCombo
			$tmp1=_GUICtrlComboBox_GetCurSel($h_SnipCombo)
			if $tmp1>-1 then $snipLang = $a_snipc[$tmp1]
			$tmp1=""
			;StatusWrite("Style, Selected item #" & $snipLang)
		Case $h_BTNCFG
			WinSetState($h_SnipForm, "", @SW_DISABLE)
			SConfig()
			WinSetState($h_SnipForm, "", @SW_ENABLE)
			WinSetState($h_SnipForm, "", @SW_RESTORE)
			IniGet($snipfolder, $snipext, $snip_lng)
			WinActivate($h_SnipForm)
			IniWrite($snip_inifile, "config", "LastUsedLanguageNr", "-1")
			IniWrite($snip_inifile, "config", "LastUsedLanguageName", "")
			WriteToolBar("Please reload a language !")
		Case Else
			For $tmpx = $FilesID[0][1] To $FilesID[0][0]
				If $nMsg = $FilesID[$tmpx][0] And $nMsg > 0 Then
					GUICtrlSetState($h_Tree, $gui_disable)
					ReadFileToEdit($FilesID[$tmpx][1])
					WriteToolBar($tmpmsg)
					GUICtrlSetState($h_Tree, $gui_enable)
				EndIf
			Next
	EndSwitch
WEnd

Func NewFolder()
	If $snipfolder <> "" Then
		TreeMenuCheckItem()
		$h_XT = $a_TreeCheck[0]
		$did = $a_TreeCheck[1]
		$FP = $a_TreeCheck[2]
		$FX = $a_TreeCheck[3]
		$h_Bold = $a_TreeCheck[4]

		If Not IsDeclared("sInputBoxAnswer") Then Local $sInputBoxAnswer
		If FileExists($FP) = 1 And IsDir($FP) = 1 Then
			WinSetState($h_SnipForm, "", @SW_DISABLE)
			$sInputBoxAnswer = FilenameInputGui("Please enter a Name for the Folder ", "A new folder will be created in:" & @CRLF & $FP & @CRLF & @CRLF & "Do not use \ | / ? : > < . chars", -1, -1, 300, 220)
			Select
				Case @error = 0 And $sInputBoxAnswer <> ""         ;OK - The string returned is valid
					If FileExists($FP) = 1 And IsDir($FP) = 1 Then
						StringReplace($FolderID[$FX][1], "\", " ", 0)                            ;calculate how many parent folders are there
						If @extended < 6 Then
							If DirCreate($FP & $sInputBoxAnswer) = 0 Then
								WriteToolBar("Folder was not created")
							Else
								$FolderID[0][0] = $FolderID[0][0] + 1
								$FolderID[$FolderID[0][0]][0] = GUICtrlCreateTreeViewItem($sInputBoxAnswer, $did)
								$FolderID[$FolderID[0][0]][1] = $FolderID[$FX][1] & $sInputBoxAnswer & "\"
								GUICtrlSetState(-1, $GUI_DEFBUTTON)
								_GUICtrlTreeView_SetIcon($h_Tree, $FolderID[$FolderID[0][0]][0], "shell32.dll", 4)
								WriteToolBar($FP & $sInputBoxAnswer)
							EndIf
						Else
							WriteToolBar("Err: Subfolder count exceeded 5")
						EndIf
					Else
						WriteToolBar("Error: Parent folder was deleted.")
						WriteToolBar("Refresh the Language", 1)
					EndIf

				Case @error = 1         ;The Cancel button was pushed
					WriteToolBar("Input Canceled")
				Case Else
					WriteToolBar("Cancelled - Empty String")
			EndSelect
		Else
			WriteToolBar("Error: Parent folder is missing.")
			WriteToolBar("Refresh the Language", 1)
		EndIf
	EndIf
	WinSetState($h_SnipForm, "", @SW_ENABLE)
	WinActivate($h_SnipForm)
EndFunc   ;==>NewFolder

Func RefreshLang()
	If GUICtrlRead($h_SnipCombo) <> "" Then
		WriteToolBar("Processing: " & GUICtrlRead($h_SnipCombo))
		GUICtrlSetState($h_BTNDir, $gui_disable)
		GUICtrlSetState($h_SnipCombo, $gui_disable)
		DirToTree()
		GUICtrlSetState($h_BTNDir, $gui_enable)
		GUICtrlSetState($h_SnipCombo, $gui_enable)
		If $FolderID[0][0] >= ($FolderMaxI - 1) Then                        ;Disable or Enable the new folder popup-menu
			GUICtrlSetState($m_newfolder, $gui_disable)
		Else
			GUICtrlSetState($m_newfolder, $gui_enable)
		EndIf
	Else
		WriteToolBar("Select a language to load")
		WriteToolBar("Error", 1)
	EndIf
EndFunc   ;==>RefreshLang

Func TreeMenuCheckItem()
	Local $FP, $fn, $FX, $did, $h_XT
	For $x = 0 To 5
		$a_TreeCheck[$x] = False
	Next

	$h_XT = GUICtrlRead($h_Tree)
	Local $h_Bold = _GUICtrlTreeView_GetBold($h_Tree, $h_XT)
	If $h_Bold = True Then                                 ;The treeview text is in bold - it is a folder !
		If $h_XT = $h_Tree1 Then
			$FP = $snipfolder
			$did = $h_Tree
		Else
			For $x = 1 To $FolderID[0][0]                          ;proccess folder ID's
				If $FolderID[$x][0] = $h_XT Then
					$FP = $snipfolder & $FolderID[$x][1]
					$FX = $x
					$did = $h_XT
					ExitLoop
				EndIf
			Next
		EndIf
	Else                                                                                        ;It is a file
		For $x = 1 To $FilesID[0][0]                  ;proccess folder ID's
			If $FilesID[$x][0] = $h_XT Then
				$FP = _StringSearchSplit($FilesID[$x][1], "\", "R", "L", 1)
				$fn = _StringSearchSplit($FilesID[$x][1], "\", "R", "R")
				$did = _GUICtrlTreeView_GetParentParam($h_Tree, $h_XT)
				If $did = 0 Then $did = $h_Tree
				ExitLoop
			EndIf
		Next
	EndIf

	$a_TreeCheck[0] = $h_XT
	$a_TreeCheck[1] = $did
	$a_TreeCheck[2] = $FP
	$a_TreeCheck[3] = $FX
	$a_TreeCheck[4] = $h_Bold
	$a_TreeCheck[5] = $fn
EndFunc   ;==>TreeMenuCheckItem

Func GetIniLock()
	Local $tmp
	$tmp = IniRead($snip_inifile, "config", "lock", "False")
	If $tmp = "True" Then
		GUICtrlSetStyle($h_SnipEdit, BitOR($ES_WANTRETURN, $WS_VSCROLL, $WS_HSCROLL, $ES_AUTOVSCROLL, $ES_AUTOHSCROLL, $ES_READONLY))
		GUICtrlSetState($h_CB_Lock, $GUI_CHECKED)
	Else
		GUICtrlSetStyle($h_SnipEdit, BitOR($ES_WANTRETURN, $WS_VSCROLL, $WS_HSCROLL, $ES_AUTOVSCROLL, $ES_AUTOHSCROLL))
		GUICtrlSetState($h_CB_Lock, $GUI_UNCHECKED)
	EndIf
EndFunc   ;==>GetIniLock

Func SetIniLock()
	Local $tmp = _IsChecked($h_CB_Lock)
	If $tmp = True Then
		GUICtrlSetStyle($h_SnipEdit, BitOR($ES_WANTRETURN, $WS_VSCROLL, $WS_HSCROLL, $ES_AUTOVSCROLL, $ES_AUTOHSCROLL, $ES_READONLY))
	Else
		GUICtrlSetStyle($h_SnipEdit, BitOR($ES_WANTRETURN, $WS_VSCROLL, $WS_HSCROLL, $ES_AUTOVSCROLL, $ES_AUTOHSCROLL))
	EndIf
	IniWrite($snip_inifile, "config", "lock", $tmp)
EndFunc   ;==>SetIniLock

Func SetFont($id, $formId, $nr = 0)
	$aFont = _ChooseFont($aFont[2], $aFont[3], $aFont[5], $aFont[4], $f_Italic, $f_Underline, $f_Strikethru, $formId)
	If $aFont <> -1 Then
		;  GUICtrlSetFont ( controlID, size [, weight [, attribute [, fontname [, quality]]]] )
		GUICtrlSetFont($id, $aFont[3], $aFont[4], $aFont[1], $aFont[2], 0)
		GUICtrlSetColor($id, $aFont[5])
		$f_Italic = BitAND($aFont[1], 2)
		$f_Underline = BitAND($aFont[1], 4)
		$f_Strikethru = BitAND($aFont[1], 8)
		SetIniFont($nr)
		;ConsoleWrite(@CRLF & $aFont[3] & @CRLF & $aFont[4] & @CRLF & $aFont[1] & @CRLF & $aFont[2] & @CRLF & $aFont[5])
	EndIf
EndFunc   ;==>SetFont

Func GetIniFont($id, $nr = 0)
	;Default font definition
	$aFont[1] = IniRead($snip_inifile, "font", $nr & "1", "0")
	$aFont[2] = IniRead($snip_inifile, "font", $nr & "2", "Arial")
	$aFont[3] = IniRead($snip_inifile, "font", $nr & "3", "8")
	$aFont[4] = IniRead($snip_inifile, "font", $nr & "4", "400")
	$aFont[7] = IniRead($snip_inifile, "font", $nr & "7", "0")

	$f_Italic = BitAND($aFont[1], 2)
	$f_Underline = BitAND($aFont[1], 4)
	$f_Strikethru = BitAND($aFont[1], 8)
	GUICtrlSetFont($id, $aFont[3], $aFont[4], $aFont[1], $aFont[2], 0)
	GUICtrlSetColor($id, $aFont[7])
EndFunc   ;==>GetIniFont

Func SetIniFont($nr = 0)
	IniWrite($snip_inifile, "font", $nr & "1", $aFont[1])
	IniWrite($snip_inifile, "font", $nr & "2", $aFont[2])
	IniWrite($snip_inifile, "font", $nr & "3", $aFont[3])
	IniWrite($snip_inifile, "font", $nr & "4", $aFont[4])
	IniWrite($snip_inifile, "font", $nr & "7", $aFont[7])
EndFunc   ;==>SetIniFont


Func IniCFGLoad()
	$cfg_confirm        = IniRead($snip_inifile, "config", "ConfirmMoveDeleteDialog", "1")
	$cfg_UseExtedit     = IniRead($snip_inifile, "config", "UseExtEditor", "0")
	$cfg_exteditor      = IniRead($snip_inifile, "config", "ExtEditAPP", "Notepad.exe")
	$cfg_exteditparam   = IniRead($snip_inifile, "config", "ExtEditParam", "")
	$cfg_StartLoad      = IniRead($snip_inifile, "config", "StartLoadLastUsedLanguage", "1")
	$cfg_StartLoadNr    = IniRead($snip_inifile, "config", "LastUsedLanguageNr", "-1")
	$cfg_StartLoadName  = IniRead($snip_inifile, "config", "LastUsedLanguageName", "")
EndFunc   ;==>IniCFGLoad

Func _SaveExtAppInfo($idleft, $idright)
	$cfg_exteditor = GUICtrlRead($idleft)
	$cfg_exteditparam = GUICtrlRead($idright)
	IniWrite($snip_inifile, "config", "ExtEditAPP", $cfg_exteditor)
	IniWrite($snip_inifile, "config", "ExtEditParam", $cfg_exteditparam)
EndFunc   ;==>_SaveExtAppInfo

Func IniGet($folder = "", $ext = "", $lang = "")
	;Get the language sections into the combobox
	Local $x, $y, $t, $txt, $z = 0, $cmbox, $inifile, $section
	$section = "language"
	$inifile = $snip_inifile
	$cmbox = $h_SnipCombo
	$y = $maxlang - 1
	For $x = 0 To $y
		$a_snipc[$x] = ""
	Next

	_GUICtrlComboBox_ResetContent($cmbox)
	For $x = 0 To $y

		$t = IniRead($inifile, $section, $x & "0", "")

		If $t <> "" Then                            ;Skip x0 entries, if they do not contain any text.
			If GetSnipLang($x) = True Then            ;Process further only if
				$txt = IniRead($inifile, $section, $x & "1", "")
				If $txt <> "" Then
					$a_snipc[$z] = $x
					_GUICtrlComboBox_AddString($cmbox, $t)
					$z = $z + 1
				EndIf
			EndIf
		EndIf
	Next
	$snipfolder = $folder        ;Reset these because the GetSnipLang should not set them if called from the IniGet() function !
	$snipext = $ext
	$snip_lng = $lang
EndFunc   ;==>IniGet

Func GetSnipLang($nr)
	;Helper function to set the correct values
	If $nr = -1 Then $nr = $snipLang
	$snip_lng = IniRead($snip_inifile, "language", $nr & "0", "")
	$snipfolder = IniRead($snip_inifile, "language", $nr & "1", "")
	$snipext = IniRead($snip_inifile, "language", $nr & "2", "")
	;ConsoleWrite (@crlf & " - " & $snipfolder)
	If StringInStr($snipext, ".") > 0 Then $snipext = StringReplace($snipext, ".", "")
	If StringInStr($snipext, "*") > 0 Then $snipext = StringReplace($snipext, "*", "")
	If StringLen($snipext) = 0 Then Return False
	If FileExists($snipfolder) = 0 Then Return 0
	If StringRight($snipfolder, 1) = ":" Then $snipfolder = $snipfolder & "\"
	If StringRight($snipfolder, 1) <> "\" Then $snipfolder = $snipfolder & "\"
	$snipextpure = $snipext
	$snipext = "*." & $snipext
	Return True
EndFunc   ;==>GetSnipLang

Func DisplayActiveProcess()
	Local $cliptmp
	If $HKS[4] = 0 Then                    ;Main function
		$Snip_procID = WinGetProcess('[ACTIVE]')
		$Snip_ProcHWND = _GetHwndFromPID($Snip_procID)
		If $activelock < 2 Then
			$cliptmp=ClipGet()
			Sleep (30)
			If ClipPut(_GUICtrlEdit_GetText($h_SnipEdit)) = 0 Then
				WriteToolBar("ClipPut Error")
			Else
				Sleep(70)
				If WinActive($Snip_ProcHWND) Then Send("^v")
			EndIf
			ClipPut ($cliptmp)
		EndIf
	Else                                ;Hotkey Gui Redirection
		GUICtrlSetData($h_HotkeyTestInput, "Hotkey ! " & @HOUR & ":" & @MIN & ":" & @SEC)
	EndIf
EndFunc   ;==>DisplayActiveProcess

Func ReadFileToEdit($ofile, $ed = $h_SnipEdit)
	If $ofile = "" Then Return False
	Local $hFileOpen = FileOpen($ofile, $FO_READ)
	Local $tmptxt, $li = 1, $array
	If $hFileOpen = -1 Then
		WriteToolBar("Error while opening the file.")
		Return False
	EndIf
	WriteEdit($ed, "", 1)
	_GUICtrlEdit_BeginUpdate($ed)
	$tmptxt = FileRead($hFileOpen)
	WriteToolBar(@extended & " bytes", 1)
	$array = StringSplit($ofile, "\")
	$tmpmsg = $array[(UBound($array) - 1)]
	GUICtrlSetData($ed, $tmptxt)
	GUIGetMsg()
	_GUICtrlEdit_EndUpdate($ed)
	FileClose($hFileOpen)
EndFunc   ;==>ReadFileToEdit

Func WriteEdit($ed, $sMessage = "", $clear = 1)
	If $clear = 1 Then GUICtrlSetData($ed, "")
	GUICtrlSetData($ed, $sMessage, $clear)
EndFunc   ;==>WriteEdit

Func WriteToolBar($txt, $part = 0)
	_GUICtrlStatusBar_SetText($h_StatusBar, $txt, $part)
EndFunc   ;==>WriteToolBar


Func DirToTree($lng = "")
	;$lng - call the GetSnipLang(nr) to set the $snipfolder, $snipext and $snip_lng
	;$x,$y= loop ; $z=Counter ; $c=Temp ID holder ; $a,$n temp text
	If GetSnipLang(-1) = 0 Then
		WriteToolBar("Invalid folder or extension !")
		Return False
	EndIf
	Local $x, $y = 0, $z = 0, $c, $a, $n, $path, $tmperr = 0, $dp = 0, $tmptxt
	Local $aFileList = _FileListToArrayRec($snipfolder, Default, 2, -5)

	If @error = 1 And FileExists($snipfolder) = 0 Then
		WriteToolBar("Nonexistant Folder ?!")
		Return False
	EndIf
	If @error = 4 Then
		WriteToolBar("No folder(s) were found.")
		Return False
	EndIf

	IniWrite($snip_inifile, "config", "LastUsedLanguageNr", $snipLang)
	IniWrite($snip_inifile, "config", "LastUsedLanguageName", $snip_lng)

	If IsArray($aFileList) = 0 Then
		Dim $aFileList[1]
		$aFileList[0] = 0
	EndIf

	_GUICtrlTreeView_DeleteAll($h_Tree)

	For $x = 1 To $FolderID[0][0]                  ;Clear the Filename Array
		$FolderID[$x][0] = ""
		$FolderID[$x][1] = ""
	Next

	For $x = 1 To $FilesID[0][0]                  ;Clear the Filename Array
		$FilesID[$x][0] = ""
		$FilesID[$x][1] = ""
		;$FilesID[$x][2] = ""
	Next

	$FolderID[0][0] = 0
	$FilesID[0][0] = 0

	_GUICtrlTreeView_BeginUpdate($h_Tree)
	$h_Tree1 = GUICtrlCreateTreeViewItem("Root folder of : " & $snip_lng, $h_Tree)
	GUICtrlSetState(-1, $GUI_DEFBUTTON)
	For $x = 1 To $aFileList[0]
		If $FolderMaxI - 1 > $z Then

			$path = $aFileList[$x]

			If SkipFoldername($aFileList[$x]) = 0 Then
				If StringRight($path, 1) = "\" Then $path = StringMid($path, 1, StringLen($path) - 1)
				$array = StringSplit($path, "\")
				If $array[0] = 1 Then
					$c = $h_Tree
					$n = $array[1] ;& "\"
				Else
					$a = ""
					For $y = 1 To $array[0] - 1
						$a = $a & $array[$y] & "\"
					Next

					For $y = 1 To $FolderID[0][0] + 1
						If $FolderID[$y][1] = $a Then
							$c = $FolderID[$y][0]
							$n = $array[$array[0]]
							;If StringRight($n, 1) <> "\" Then $n = $n & "\"
						EndIf
					Next
					;ConsoleWrite ($aFileList[$x] & " :: > " & $a & @CRLF)
				EndIf
				$z = $z + 1
				$FolderID[0][0] = $z
				$FolderID[$z][0] = GUICtrlCreateTreeViewItem($n, $c)
				$FolderID[$z][1] = $aFileList[$x]
				GUICtrlSetState(-1, $GUI_DEFBUTTON)
				_GUICtrlTreeView_SetIcon($h_Tree, $FolderID[$z][0], "shell32.dll", 4)
			EndIf
		Else
			$tmperr = 1
		EndIf
		WriteToolBar("Folder: " & $z, 1)
	Next

	If $tmperr = 1 Then WriteToolBar("Too many folders >" & ($z + 1))
	$z = 0
	For $x = 1 To $FolderID[0][0]                             ;Loop through folders in the array + include the root folder
		$z = RecursiveFolder($x, $z)
	Next
	RecursiveFolder($x, -1)
	;Local $hItem = _GUICtrlTreeView_GetFirstItem($h_Tree)
	;_SendMessage(GUICtrlGetHandle($h_Tree), $TVM_EXPAND, $TVE_EXPAND, $hItem, 0, "wparam", "handle")
	_GUICtrlTreeView_EndUpdate($h_Tree)

	;_ArrayDisplay($FilesID)
	;MsgBox (0,"Item count:",$FilesID[0][0] & @CRLF & $z)
EndFunc   ;==>DirToTree

Func SkipFoldername($foldername)
	;Returns 1 if the foldername is matching the skip list
	$foldername = StringLower($foldername)
	Switch $foldername
		Case "$recycle.bin\", "system volume information\"
			Return 1
	EndSwitch
	Return 0
EndFunc   ;==>SkipFoldername

Func RecursiveFolder($x, $z)
	Local $y = 0, $c, $a, $n, $path, $dp = 0, $tmptxt
	Local $tmptxt = ""
	If $z > -1 Then
		$tmptxt = $FolderID[$x][1]
	Else
		$tmptxt = ""                                        ;Include the root folder !
		;ConsoleWrite(@CRLF & $snipfolder & @CRLF & @CRLF)
	EndIf

	Local $aFileList = _FileListToArray($snipfolder & $tmptxt, $snipext, 1, -5)                     ;Get the files from the folder
	$a = 0
	If @error = 1 Then
		WriteToolBar("FilePath was invalid. ")
		$a = -1
	EndIf
	If @error = 4 Then $a = -1         ;ConsoleWrite ("No file(s) were found." & $snipfolder & $tmptxt & @CRLF)

	If $a = 0 Then                                                                                      ;Loop through the files in folder
		Local $sl = StringLen($snipext) - 1
		For $y = 1 To $aFileList[0]
			If $FilesMaxI - 1 > $FilesID[0][0] Then

				$FilesID[0][0] = $FilesID[0][0] + 1
				$z = $FilesID[0][0]
				WriteToolBar("Files: " & $FilesID[0][0], 1)
				$path = $aFileList[$y]
				$array = StringSplit($path, "\")                                    ;Split the array into folders and file
				$a = $array[$array[0]]
				If StringInStr($a, ".") > 0 And ($snipext <> "*.*" Or $snipext <> "." Or $snipext <> "*." Or $snipext <> ".*") = 0 Then
					For $tmpx = StringLen($a) To 1 Step -1
						If $dp = 0 And StringMid($a, $tmpx, 1) = "." Then $dp = $tmpx
					Next
				EndIf
				$n = StringMid($a, 1, StringLen($a) - $dp)                            ;Extract the filename from the array, without extension
				If $x <= $FolderID[0][0] Then
					$c = $FolderID[$x][0]
				Else
					$c = $h_Tree
				EndIf
				$FilesID[$z][0] = GUICtrlCreateTreeViewItem($n, $c)
				$FilesID[$z][1] = $aFileList[$y]
				_GUICtrlTreeView_SetIcon($h_Tree, $FilesID[$z][0], "shell32.dll", 1)
				;ConsoleWrite($FilesID[$z][1] & @CRLF)
			EndIf
		Next
	EndIf

EndFunc   ;==>RecursiveFolder


Func _GetHwndFromPID($PID)
	;Function for getting HWND from PID
	; The function is based on work by Smoke_N/Hubertus and Helge.
	$hWnd = 0
	$winlist = WinList()
	Do
		For $i = 1 To $winlist[0][0]
			If $winlist[$i][0] <> "" Then
				$iPID2 = WinGetProcess($winlist[$i][1])
				If $iPID2 = $PID Then
					$hWnd = $winlist[$i][1]
					ExitLoop
				EndIf
			EndIf
		Next
	Until $hWnd <> 0
	Return $hWnd
EndFunc   ;==>_GetHwndFromPID

Func SConfig()
	Local $a_cfg[$maxlang][4], $x, $y, $z = -1, $overwrite, $iMsgBoxAnswer, $tmp = "", $tmp0, $tmp1, $tmp2
	Local $h_ToolTipTimer, $ToolTipActive = 0, $ToolTMSG = ""
	#Region ### START Koda GUI section ### Form=
	Global $h_SnipOPT = GUICreate("Config", 371, 191, -1, -1, -1, $WS_EX_MDICHILD, $h_SnipForm)
	$h_BTNDone = GUICtrlCreateButton("Exit", 325, 2, 43, 20)
	GUICtrlSetTip(-1, "Exit the configuration." & @CRLF & "Please select and reload the language" & @CRLF & "to update the changes!")
	$h_Listview = GUICtrlCreateListView("Nr|Language Name   | Folder           | ext", 3, 25, 175, 162)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 0, 35)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 1, 120)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 2, 220)
	GUICtrlSendMsg(-1, $LVM_SETCOLUMNWIDTH, 3, 50)
	$h_LabelLang = GUICtrlCreateLabel("Ini Contents:", 8, 5, 63, 17)
	$h_EDname = GUICtrlCreateInput("", 182, 26, 185, 21)
	GUICtrlSetTip(-1, "Language Name.")
	$h_EDPath = GUICtrlCreateInput("", 182, 51, 185, 21)
	GUICtrlSetTip(-1, "Language starting folder.")
	$h_EdExt = GUICtrlCreateInput("", 182, 77, 54, 21)
	GUICtrlSetTip(-1, "File extension.")
	$h_BTNdel = GUICtrlCreateButton("Delete", 135, 2, 42, 19)
	GUICtrlSetTip(-1, "Delete the selected item.")
	$h_BTNSeek = GUICtrlCreateButton("Seek", 325, 73, 43, 20)
	GUICtrlSetTip(-1, "Search for a Language folder" & @CRLF & "or create a new folder.")
	$h_LabelInfo = GUICtrlCreateLabel("Extension only.", 238, 80, 80, 17)
	$h_BTNSave = GUICtrlCreateButton("Set", 182, 2, 43, 20)
	GUICtrlSetTip(-1, "Save the Name, Folder and Extension to the ini file." & @CRLF & @CRLF & "Folder has to be valid, if not then the " & @CRLF & "Folder of the App will be saved instead.")
	$h_BTNHotConfig = GUICtrlCreateButton("Hotkey", 255, 2, 43, 20)
	GUICtrlSetTip(-1, "Change the Hotkey Key !")
	$h_CB_confirm = GUICtrlCreateCheckbox("Confirm external Move/Delete", 182, 103, 175, 14)
	$h_CB_ExEdit = GUICtrlCreateCheckbox("Use external Editor", 182, 120, 114, 17)
	$h_EditApp = GUICtrlCreateInput("", 183, 166, 109, 21)
	GUICtrlSetTip(-1, "Leave blank to use the" & @CRLF & "file associated Program." & @CRLF & "make sure that the prog exists" & @CRLF & "because here are no checks for it at all.")
	$h_EditParam = GUICtrlCreateInput("", 295, 166, 69, 21)
	GUICtrlSetTip(-1, "Optional parameter" & @CRLF & "leave blank if you do not know hot to use it.")
	$h_BTNSelApp = GUICtrlCreateButton("Select Editor", 297, 120, 69, 19)
	$Label1 = GUICtrlCreateLabel("External Editor", 184, 148, 72, 17)
	$Label2 = GUICtrlCreateLabel("Parameter (opt)", 294, 148, 76, 17)
	GUISetState(@SW_SHOW)
	#EndRegion ### END Koda GUI section ###

	For $x = 0 To $maxlang - 1
		$a_cfg[$x][0] = IniRead($snip_inifile, "language", $x & "0", "")
		$a_cfg[$x][1] = IniRead($snip_inifile, "language", $x & "1", "")
		$a_cfg[$x][2] = IniRead($snip_inifile, "language", $x & "2", "")
		$a_cfg[$x][3] = GUICtrlCreateListViewItem($x & "|" & $a_cfg[$x][0] & "|" & $a_cfg[$x][1] & "|" & $a_cfg[$x][2], $h_Listview)
	Next

	IniCFGLoad()

	_CheckUncheck($h_CB_confirm, $cfg_confirm)
	_CheckUncheck($h_CB_ExEdit, $cfg_UseExtedit)

	If $cfg_UseExtedit = 0 Then
		GUICtrlSetState($h_EditApp, $GUI_DISABLE)
		GUICtrlSetState($h_EditParam, $GUI_DISABLE)
		GUICtrlSetState($h_BTNSelApp, $GUI_DISABLE)
	EndIf

	GUICtrlSetData($h_EditApp, $cfg_exteditor)
	GUICtrlSetData($h_EditParam, $cfg_exteditparam)

	While 1
		$WinPos = WinGetPos($h_SnipOPT)
		FilenameInputCheck($h_EdExt, $WinPos[0] + 30, $WinPos[1] + 126)
		If $ToolTipActive = 1 Then
			If TimerDiff($h_ToolTipTimer) > 4500 Then
				$ToolTipActive = 0
				$ToolTMSG = ""
			EndIf
			ToolTip($ToolTMSG)
			Sleep(80)
		EndIf

		$nMsg = GUIGetMsg()
		Switch $nMsg
			Case $GUI_EVENT_CLOSE, $h_BTNDone
				_SaveExtAppInfo($h_EditApp, $h_EditParam)
				ExitLoop
			Case $h_BTNSelApp
				$tmp = FileOpenDialog("Select an Text-Editin APP", "", "Executables (*.exe)")
				If @error = 0 Then
					GUICtrlSetData($h_EditApp, $tmp)
					_SaveExtAppInfo($h_EditApp, $h_EditParam)
				EndIf
			Case $h_CB_confirm
				$cfg_confirm = _TrueFalseToNumber(_IsChecked($h_CB_confirm))
				IniWrite($snip_inifile, "config", "ConfirmMoveDeleteDialog", $cfg_confirm)
			Case $h_CB_ExEdit
				$cfg_UseExtedit = _TrueFalseToNumber(_IsChecked($h_CB_ExEdit))
				IniWrite($snip_inifile, "config", "UseExtEditor", $cfg_UseExtedit)
				If $cfg_UseExtedit = 0 Then
					GUICtrlSetState($h_EditApp, $GUI_DISABLE)
					GUICtrlSetState($h_EditParam, $GUI_DISABLE)
					GUICtrlSetState($h_BTNSelApp, $GUI_DISABLE)
				Else
					GUICtrlSetState($h_EditApp, $GUI_ENABLE)
					GUICtrlSetState($h_EditParam, $GUI_ENABLE)
					GUICtrlSetState($h_BTNSelApp, $GUI_ENABLE)
					_SaveExtAppInfo($h_EditApp, $h_EditParam)
				EndIf
			Case $h_BTNHotConfig
				WinSetState($h_SnipOPT, "", @SW_DISABLE)
				SetHotkeyKeys(1)
				WinSetState($h_SnipOPT, "", @SW_ENABLE)
				WinActivate($h_SnipForm)
				WinActivate($h_SnipOPT)
			Case $h_BTNSeek
				$tmp = @ScriptDir
				$tmp1 = GUICtrlRead($h_EDPath)

				If FileExists($tmp1) Then $tmp = $tmp1
				Local $s_Folder = FileSelectFolder("Select a Folder or Create a Folder", $tmp, 1)
				If @error = 0 Then
					If StringRight($s_Folder, 1) <> "\" Then $s_Folder = $s_Folder & "\"
					If StringRight($s_Folder, 1) = ":" Then $s_Folder = $s_Folder & "\"
					GUICtrlSetData($h_EDPath, $s_Folder)
				EndIf
			Case $h_BTNdel
				$y = -1
				For $x = 0 To $maxlang - 1
					If _GUICtrlListView_GetItemSelected($h_Listview, $x) = True Then $y = $x
				Next
				If $y >= 0 Then
					$iMsgBoxAnswer = 0
					;MsgBox features: Title=Yes, Text=Yes, Buttons=Yes and No, Icon=Question, Modality=Task Modal, Miscellaneous=Top-most attribute
					If $a_cfg[$y][0] <> "" Then $iMsgBoxAnswer = MsgBox(270372, "Delete #" & $y & " " & $a_cfg[$y][0], "Do you want to delete the selected entry ?")
					If $iMsgBoxAnswer = 6 Then ;Yes
						$a_cfg[$y][0] = ""
						IniWrite($snip_inifile, "language", $y & "0", "")
						_GUICtrlListView_SetItemText($h_Listview, $y, $a_cfg[$y][0], 1)
						GUICtrlSetData($h_EDname, "")
					EndIf
				EndIf
			Case $h_BTNSave
				$tmp0 = GUICtrlRead($h_EDname)
				$tmp1 = GUICtrlRead($h_EDPath)
				$tmp2 = GUICtrlRead($h_EdExt)
				If $tmp0 <> "" And $tmp1 <> "" And $tmp2 <> "" Then
					$y = -1 ;if not selected
					For $x = 0 To $maxlang - 1                        ;Check if listview item is selected
						If _GUICtrlListView_GetItemSelected($h_Listview, $x) = True Then $y = $x
					Next
					$overwrite = 0                            ;Set default overwrite to No (seek a free slot)
					;MsgBox features: Title=No, Text=Yes, Buttons=Yes, No, and Cancel, Icon=Question, Modality=Task Modal, Miscellaneous=Top-most attribute
					If $y >= 0 Then                            ;Listview item is selected, ask what to do
						If $a_cfg[$y][0] <> "" Then
							$iMsgBoxAnswer = MsgBox(270371, "Overwrite #" & $y & " : " & $a_cfg[$y][0] & " ?", "Do you want to overwrite selected config ?" & @CRLF & @CRLF & "Yes - Overwrite" & @CRLF & "No - Seek a free slot (Stop if no free slot)" & @CRLF & "Cancel - to Stop")
							If $iMsgBoxAnswer = 6 Then $overwrite = 1 ;Yes
							If $iMsgBoxAnswer = 7 Then $overwrite = 0 ;No
							If $iMsgBoxAnswer = 2 Then $overwrite = 3 ;Cancel
						EndIf
					EndIf

					If $overwrite < 2 Then                                ;Yes or No from msg box
						$z = -1
						If $overwrite = 0 Then
							For $x = 0 To $maxlang - 1
								If $a_cfg[$x][0] = "" Then                ;Search for an empty string in the array
									$y = $x
									$z = 0
									ExitLoop
								EndIf
							Next
							If $z = -1 Then
								$h_ToolTipTimer = TimerInit()
								$ToolTipActive = 1
								$ToolTMSG = "Error: Not saved !" & @CRLF & "No Free slots."
							EndIf
						EndIf
						; Check if the correct data was entered into the input boxes (path and extension)
						If StringLen($tmp1) = 2 And StringRight($tmp1, 1) = ":" Then $tmp1 = $tmp1 & "\"
						If FileExists($tmp1) And IsDir($tmp1) Then
							If StringRight($tmp1, 1) <> "\" Then $tmp1 = $tmp1 & "\"
						Else

							$h_ToolTipTimer = TimerInit()
							$ToolTipActive = 1
							$ToolTMSG = $tmp1 & @CRLF & "Folder is invalid!" & @CRLF & "it is changed to the scriptdir."
							$tmp1 = $snip_inidir
						EndIf
						If $tmp1 <> GUICtrlRead($h_EDPath) Then GUICtrlSetData($h_EDPath, $tmp1)
						$tmp2 = StringReplace($tmp2, "*", "")                ; No *
						$tmp2 = StringReplace($tmp2, ".", "")                ; No .
						If $tmp2 <> GUICtrlRead($h_EdExt) Then GUICtrlSetData($h_EdExt, $tmp2)
						$a_cfg[$y][0] = $tmp0
						$a_cfg[$y][1] = $tmp1
						$a_cfg[$y][2] = $tmp2
						IniWrite($snip_inifile, "language", $y & "0", $a_cfg[$y][0])
						IniWrite($snip_inifile, "language", $y & "1", $a_cfg[$y][1])
						IniWrite($snip_inifile, "language", $y & "2", $a_cfg[$y][2])
						_GUICtrlListView_SetItemText($h_Listview, $y, $tmp0, 1)
						_GUICtrlListView_SetItemText($h_Listview, $y, $tmp1, 2)
						_GUICtrlListView_SetItemText($h_Listview, $y, $tmp2, 3)
						_GUICtrlListView_SetItemSelected($h_Listview, $y)
					EndIf
				EndIf
			Case Else
				For $x = 0 To $maxlang - 1
					If $nMsg = $a_cfg[$x][3] Then
						GUICtrlSetData($h_EDname, $a_cfg[$x][0])
						GUICtrlSetData($h_EDPath, $a_cfg[$x][1])
						GUICtrlSetData($h_EdExt, $a_cfg[$x][2])
					EndIf
				Next
		EndSwitch
	WEnd
	GUIDelete($h_SnipOPT)
EndFunc   ;==>SConfig

; Check if the filepath is a directory/folder. Does not validate if the directory/folder exists.
Func IsDir($sFilePath)
	Return StringInStr(FileGetAttrib($sFilePath), "D") > 0
EndFunc   ;==>IsDir

Func _TrueFalseToNumber($nr)
	If $nr = True Then Return 1
	Return 0
EndFunc   ;==>_TrueFalseToNumber

Func _CheckUncheck($id, $nr)
	If $nr = 0 Then
		GUICtrlSetState($id, $GUI_UNCHECKED)
	Else
		GUICtrlSetState($id, $GUI_CHECKED)
	EndIf
EndFunc   ;==>_CheckUncheck

Func _IsChecked($idControlID)
	Return BitAND(GUICtrlRead($idControlID), $GUI_CHECKED) = $GUI_CHECKED
EndFunc   ;==>_IsChecked

Func _StringSearchSplit($str, $delimiter, $dir = "L", $ret = "R", $incdel = -1)
	; #FUNCTION# ====================================================================================================================
	; Name ..........:  _StringSearchSplit
	; Description ...:  Search for the first delimiter in a string, with searching direction, Case Sensitive search
	; Syntax ........:  _StringSearchSplit( $String, $delimiter [, $dir ] [, $ret ] [, $incdel ])
	; Parameters ....:  $String             - String to be checked.
	;                   $delimiter          - 1 char delimiter, has to be defined
	;                   $dir                - Search from direction (Left/Right), use "L" or "R" - Left is default
	;                                           The first letter will be used for direction, if multiple letters are entered e.g "Lab" = "L"
	;                   $ret                - Return side, Left or Right - Right is default. see above for valid entries.
	;                   $incdel             - Include delimiter 0 = No, 1 = Yes
	;
	; Return values .:  Success             - String
	;
	;                       e.g. 1: _StringSearch("c:\bat\test.bb","\","L","L")   returns "c:"
	;                       e.g. 2: _StringSearch("c:\bat\test.bb","\","L","L",1) returns "c:\"
	;                       e.g. 3: _StringSearch("c:\bat\test.bb","\","L","R")   returns "bat\test.bb"
	;                       e.g. 4: _StringSearch("c:\bat\test.bb","\","L","R",1) returns "\bat\test.bb"
	;                       e.g. 5: _StringSearch("c:\bat\test.bb","\","R","R")   returns "test.bb"
	;                       e.g. 6: _StringSearch("c:\bat\test.bb","\","R","R",1) returns "\test.bb"
	;
	;                   Failure             - Empty string and @error flag as follows:
	;                   @error :            1 - Empty String
	;                                       2 - Delimiter should have a length of 1 char
	;                                       3 - Should not happen, but if it does, search the PANIC button !
	; Author ........:  Dan_555 (Autoitscript.com forum)
	; ===============================================================================================================================

	Local $y
	Local $tmptxt = ""

	$dir = StringLeft(StringUpper($dir), 1)
	$ret = StringLeft(StringUpper($ret), 1)

	SetError(0)

	If StringLen($str) = 0 Then
		SetError(1)             ;empty string
		Return ""
	EndIf

	If (StringInStr($str, $delimiter) = 0) Or (StringLen($delimiter) <> 1) Then
		SetError(2)                ;invalid delimiter
		Return ""
	EndIf

	If $dir <> "L" And $dir <> "R" Then $dir = "L"                  ;Set default values
	If $ret <> "L" And $ret <> "R" Then $ret = "R"

	If $dir = "L" Then $y = StringInStr($str, $delimiter, 1)        ;Search for the delimiter
	If $dir = "R" Then $y = StringInStr($str, $delimiter, 1, -1)

	If $incdel = 0 Then $incdel = -1                                ;Tricky calculations ;)
	If $incdel <> -1 Then $incdel = 0

	If $ret = "L" Then Return StringMid($str, 1, $y + $incdel)      ;DisAssemble the string
	If $ret = "R" Then Return StringMid($str, $y - $incdel)

	SetError(3)
	Return ""
EndFunc   ;==>_StringSearchSplit

Func FilenameInputGui($titletxt = "", $TextMSG = "", $x = -1, $y = -1, $w = 300, $h = 120, $Empty = 1)
	;Source from https://www.autoitscript.com/forum/topic/90035-check-for-valid-file-name-while-entering-text/	Mod by dan_555
	; ******* Needs FilenameInputCheck() funcion, *****
	;$empty - 0 = User has to enter something before clicking on OK button.
	;Cancel or X will always return an empty string and the @error will be set to 1
	; Invalid chars are: ['<', '>', '|', '"', '\', '/', ':', '*', '?']
	If $w < 85 Then $w = 85
	If $h < 85 Then $h = 85
	Global $FNI_TIMERstart

	Local $MyGui = GUICreate($titletxt, $w, $h, $x, $y, $WS_POPUP + $WS_CAPTION)
	Local $Edit = GUICtrlCreateEdit($TextMSG, 4, 4, $w - 8, $h - 55, BitOR($ES_AUTOVSCROLL, $ES_READONLY))
	Local $input = GUICtrlCreateInput("", 4, $h - 50, $w - 8, 20, $ES_WANTRETURN)
	Local $buttonOK = GUICtrlCreateButton("OK", 4, $h - 25, 35, 20)
	Local $buttonCA = GUICtrlCreateButton("Cancel", $w - 45, $h - 25, 40, 20)
	GUISetState(@SW_SHOW)

	Local $final, $Err = 0
	Local $WinPos
	$FNI_TIMERstart = TimerInit()

	While 1
		$WinPos = WinGetPos($MyGui)
		$msg = GUIGetMsg()
		Select
			Case $msg = $GUI_EVENT_CLOSE Or $msg = $buttonCA
				$Err = 1
				ExitLoop
			Case $msg = $buttonOK
				If GUICtrlRead($input) = "" And $Empty = 0 Then
					$FNI_TIMERstart = TimerInit()
					ToolTip("Empty file names are *NOT* allowed", $WinPos[0], $WinPos[1] + $h)
				Else
					ExitLoop
				EndIf
		EndSelect
		FilenameInputCheck($input, $WinPos[0], $WinPos[1] + $h)
	WEnd

	If $Err = 0 Then
		$final = GUICtrlRead($input)
		GUIDelete($MyGui)
		SetError(0)
		Return StringStripWS($final, 2)
	Else
		GUIDelete($MyGui)
		SetError(1)
		Return ""
	EndIf

EndFunc   ;==>FilenameInputGui

Func FilenameInputCheck($id, $xpos = -1, $ypos = -1)
	Local $itxt, $valid
	If Not IsDeclared("sFNI_TIMERstart") Then Global $FNI_TIMERstart

	$itxt = GUICtrlRead($id)

	$valid = StringRegExpReplace($itxt, "[\[\]/\|\:\?""\*\\<>.]", "")
	If Not ($valid = $itxt) Then
		$FNI_TIMERstart = TimerInit()
		ToolTip("Not allowed Characters: '<', '>', '|', '""', '\', '/', ':', '*', '?' , '.'", $xpos, $ypos)
		GUICtrlSetData($id, StringStripWS($valid, 1))
	EndIf

	If TimerDiff($FNI_TIMERstart) > 2000 Then ToolTip("")
	Sleep(10)
EndFunc   ;==>FilenameInputCheck

Func SetHotkeyKeys($showgui = 0)
	;$showgui 0 = Set the saved hotkeys, 1 = Show gui to change the settings
	Local $a, $b, $c, $z
	$z = 4                                              ;$z of the text from $HK will go in to c1-c3, the rest goes to c4
	$HKS[0] = IniRead($snip_inifile, "hotkey", "0", "4")
	$HKS[1] = IniRead($snip_inifile, "hotkey", "1", "0")
	$HKS[2] = IniRead($snip_inifile, "hotkey", "2", "0")
	$HKS[3] = IniRead($snip_inifile, "hotkey", "3", "11")
	$HKS[4] = 0
	$HKS[5] = $HK[$HKS[0]][0] & $HK[$HKS[1]][0] & $HK[$HKS[2]][0] & $HK[$HKS[3] + $z + 1][0]
	If $showgui = 1 Then
		$HKS[4] = 1
		#Region ### START Koda GUI section ### Form=
		$Form1 = GUICreate("Hotkey Config", 317, 79, -1, -1, $WS_POPUP + $WS_CAPTION, $WS_EX_MDICHILD, $h_SnipOPT)
		$C1 = GUICtrlCreateCombo("", 4, 50, 72, 25, BitOR($CBS_DROPDOWNLIST, $CBS_AUTOHSCROLL))
		$C2 = GUICtrlCreateCombo("", 82, 50, 72, 25, BitOR($CBS_DROPDOWNLIST, $CBS_AUTOHSCROLL))
		$C3 = GUICtrlCreateCombo("", 161, 50, 72, 25, BitOR($CBS_DROPDOWNLIST, $CBS_AUTOHSCROLL))
		$C4 = GUICtrlCreateCombo("", 239, 50, 72, 25, BitOR($CBS_DROPDOWNLIST, $CBS_AUTOHSCROLL))
		$Label1 = GUICtrlCreateLabel("Please set a hotkey to use. Note: Not all combos may work.", 4, 30, 300, 17)
		$Button1 = GUICtrlCreateButton("Set + Save", 4, 4, 70, 23)
		$h_HotkeyTestInput = GUICtrlCreateInput("Test", 82, 5, 150, 21)
		$Button2 = GUICtrlCreateButton("Exit", 239, 5, 72, 23)
		_GUICtrlComboBox_SetMinVisible($C4, 60)
		GUISetState(@SW_SHOW)
		#EndRegion ### END Koda GUI section ###

		For $x = 0 To UBound($HK) - 1
			If $x <= $z Then
				_GUICtrlComboBox_AddString($C1, $HK[$x][1])
				_GUICtrlComboBox_AddString($C2, $HK[$x][1])
				_GUICtrlComboBox_AddString($C3, $HK[$x][1])
			Else
				_GUICtrlComboBox_AddString($C4, $HK[$x][1])
			EndIf
		Next
		_GUICtrlComboBox_SetCurSel($C1, $HKS[0])
		_GUICtrlComboBox_SetCurSel($C2, $HKS[1])
		_GUICtrlComboBox_SetCurSel($C3, $HKS[2])
		_GUICtrlComboBox_SetCurSel($C4, $HKS[3])

		While 1
			$nMsg = GUIGetMsg()
			Switch $nMsg
				Case $GUI_EVENT_CLOSE, $Button2
					GUIDelete($Form1)
					ExitLoop
				Case $Button1
					$HKS[0] = _GUICtrlComboBox_GetCurSel($C1)        ;Read the combo - boxes
					$HKS[1] = _GUICtrlComboBox_GetCurSel($C2)
					$HKS[2] = _GUICtrlComboBox_GetCurSel($C3)
					$HKS[3] = _GUICtrlComboBox_GetCurSel($C4)
					HotKeySet($HKS[5])                                ;Clear the Old Hotkey
					$HKS[5] = $HK[$HKS[0]][0] & $HK[$HKS[1]][0] & $HK[$HKS[2]][0] & $HK[$HKS[3] + $z + 1][0]       ;Assemble the hotkey string, use $z+1 !
					If HotKeySet($HKS[5], "DisplayActiveProcess") = 0 Then MsgBox(0, "Hotkey", "Err: Could not set." & $HKS[5])        ;Set the hotkey or display a message
					IniWrite($snip_inifile, "hotkey", "0", $HKS[0])                    ;Save the hotkey to the ini file
					IniWrite($snip_inifile, "hotkey", "1", $HKS[1])
					IniWrite($snip_inifile, "hotkey", "2", $HKS[2])
					IniWrite($snip_inifile, "hotkey", "3", $HKS[3])
			EndSwitch
		WEnd
	EndIf

	If $HKS[4] = 0 Then                        ;Function was called with 0
		$HKS[5] = $HK[$HKS[0]][0] & $HK[$HKS[1]][0] & $HK[$HKS[2]][0] & $HK[$HKS[3] + $z + 1][0]
		If HotKeySet($HKS[5], "DisplayActiveProcess") = 0 Then MsgBox(0, "Hotkey", "Err: Could not set. " & $HKS[5])
	Else
		$HKS[4] = 0
	EndIf
EndFunc   ;==>SetHotkeyKeys

Func Snip_Edit($f_path, $f_name)
	$formTitle = "Snippet Editor"
	Local $WinPos, $iMsgBoxAnswer, $snipeditclose = 0, $snipeditchanged = 0
	Local $loadedFname = ""
	#Region ### START Koda GUI section ### Form=
	Local $Form1 = GUICreate($formTitle, 617, 481, -1, -1, BitOR($WS_MAXIMIZEBOX, $WS_SIZEBOX, $WS_THICKFRAME, $WS_TABSTOP))
	$snipedit1 = GUICtrlCreateEdit("", 2, 23, 609, 410, BitOR($GUI_SS_DEFAULT_EDIT, $WS_BORDER))
	GUICtrlSetData(-1, "")
	GUICtrlSetResizing(-1, $GUI_DOCKTOP)
	Local $ButtonCLS = GUICtrlCreateButton("New", 2, 0, 33, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	Local $ButtonPaste = GUICtrlCreateButton("Paste", 35, 0, 54, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	Local $ButtonCopy = GUICtrlCreateButton("Copy", 89, 0, 49, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, "Copy the Selection to Clipboard.")
	Local $ButtonUndo = GUICtrlCreateButton("Undo", 139, 0, 40, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	Local $ButtonFont = GUICtrlCreateButton("Font", 182, 0, 40, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	Local $FCOMBO = GUICtrlCreateCombo("", 276, 1, 16, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, "Available snippets" & @CRLF & "Choose to set as name" & @CRLF)
	Local $Input1 = GUICtrlCreateInput("", 294, 1, 182, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	Local $Label1 = GUICtrlCreateLabel("." & $snipextpure, 478, 4, 60, 17)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	Local $BTN_SAVE = GUICtrlCreateButton("Save", 545, 0, 34, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	Local $BTN_Load = GUICtrlCreateButton("Load", 240, 0, 34, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	Local $BTN_EXIT = GUICtrlCreateButton("EXIT", 582, 0, 31, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	Local $h_StatusBar2 = _GUICtrlStatusBar_Create($Form1)
	$h_StatusBar = $h_StatusBar2
	#EndRegion ### END Koda GUI section ###

	WriteToolBar("Selected Folder: " & $f_path)

	GUISetState(@SW_SHOW)

	GetIniFont($snipedit1, 1)

	ReadFileToEdit($f_path & $f_name & "." & $snipextpure, $snipedit1)
	$loadedFname = $f_name
	_GUICtrlComboBox_SetDroppedWidth($FCOMBO, 300)
	GUICtrlSetData($Input1, $f_name)
	$snipeditchanged = 0

	FolderToComboNoExt($f_path, $snipextpure, $FCOMBO)

	While 1
		$snipeditchanged = _GUICtrlEdit_GetModify($snipedit1)
		If $closecounter = 1 And TimerDiff($TimeHandle) > 1000 Then
			$closecounter = 0
			WinSetTitle($Form1, "", $formTitle)
		EndIf
		$nMsg = GUIGetMsg()
		Switch $nMsg
			Case $GUI_EVENT_CLOSE, $BTN_EXIT
				If $closecounter = 1 Then
					If TimerDiff($TimeHandle) <= 1000 Then
						$snipeditclose = 0
						If $snipeditchanged = True Then
							$iMsgBoxAnswer = MsgBox(8244, "Exit without saving ?", "Do you want to close the editor without saving the changes ?")
							If $iMsgBoxAnswer = 7 Then $snipeditclose = 1       ;No
						EndIf
						If $snipeditclose = 0 Then
							GUIDelete($Form1)
							ExitLoop
						EndIf
						WriteToolBar("Please save your file.")
					EndIf
				EndIf
				If $closecounter = 0 Then
					$closecounter = 1
					$TimeHandle = TimerInit()
					WinSetTitle($Form1, "", "Doubleclick to close")
				EndIf
			Case $ButtonCLS
				$loadedFname = ""
				ControlSetText("", "", $snipedit1, "")
				WriteEdit($Input1, "", 1)
				WriteToolBar("")
			Case $ButtonPaste
				;Local $clp = ClipGet()
				ControlFocus($Form1, "", $snipedit1)
				Send("^v")
			Case $ButtonCopy
				ControlFocus($Form1, "", $snipedit1)
				Send("^c")
			Case $ButtonUndo
				;ControlFocus($Form1,"",$Edit1)
				;Send("^z")
				_GUICtrlEdit_Undo($snipedit1)
			Case $ButtonFont
				SetFont($snipedit1, $Form1, 1)
			Case $BTN_Load
				WriteToolBar("")
				$snipeditclose = 0
				$f_name = GUICtrlRead($Input1)
				Local $tmpfile = $f_path & $f_name & "." & $snipextpure
				If FileExists($tmpfile) Then
					If $snipeditchanged = True Then
						$iMsgBoxAnswer = MsgBox(8244, "Load without saving ?", "Do you want to load a new file, without saving the changes ?")
						If $iMsgBoxAnswer = 7 Then           ;No
							$snipeditclose = 1
							WriteToolBar("Please save the file.")
						EndIf
					EndIf
					If $snipeditclose = 0 Then
						ReadFileToEdit($tmpfile, $snipedit1)
						$loadedFname = $f_name
						_GUICtrlEdit_SetModify($snipedit1, False)
						WriteToolBar("Loaded: " & $tmpfile)
					EndIf
				Else
					WriteToolBar("Error: " & $f_name & "." & $snipextpure & " : file does not exist")
				EndIf
			Case $BTN_SAVE
				;note: Check if edit field is empty before saving !
				Local $read = GUICtrlRead($snipedit1)
				Local $f_namet = GUICtrlRead($Input1)
				$f_name = StringStripWS($f_namet, 1)
				If $f_name <> $f_namet Then GUICtrlSetData($Input1, $f_name)
				If $f_name <> "" And $read <> "" Then
					$snipeditclose = 0
					Local $tempfname = $f_path & $f_name & "." & $snipextpure
					$tmpnotice = ""

					If $loadedFname <> $f_name Then
						If $loadedFname <> "" Then $tmpnotice = @CRLF & @CRLF & "Attention Loaded file was:" & @CRLF & $loadedFname & "." & $snipextpure & @CRLF
						If FileExists($tempfname) = 1 Then
							$iMsgBoxAnswer = MsgBox(8244, "File exists", "Do you want to Overwrite " & @CRLF & $tempfname & $tmpnotice)

							If $iMsgBoxAnswer = 7 Then                           ;No
								$snipeditclose = 1
								WriteToolBar("Please enter a new name.")
							EndIf
							If $iMsgBoxAnswer = 6 Then                           ;yes
								$snipeditclose = 0
								$loadedFname = $f_name
							EndIf
						EndIf
					EndIf
					If $snipeditclose = 0 Then
						Local $hFile = FileOpen($tempfname, 2)
						If Not FileWrite($hFile, GUICtrlRead($snipedit1)) Then
							WriteToolBar("An error occurred whilst saving file.")
						Else
							WriteToolBar("Saved File: " & $tempfname)
							_GUICtrlEdit_SetModify($snipedit1, False)
							FolderToComboNoExt($f_path, $snipextpure, $FCOMBO)
						EndIf
						FileClose($hFile)
					EndIf
				Else
					If $f_name = "" Then WriteToolBar("Error: Missing a Filename")
					If $read = "" Then WriteToolBar("Error: No text to save.")
				EndIf
			Case $FCOMBO
				GUICtrlSetData($Input1, GUICtrlRead($FCOMBO))
		EndSwitch

		$WinPos = WinGetPos($Form1)
		FilenameInputCheck($Input1, $WinPos[0] + 220, $WinPos[1] + 48)
	WEnd
	GUIGetMsg()

EndFunc   ;==>Snip_Edit

Func FolderToComboNoExt($path, $ext, $ID_combo)
	Local $aFileList = _FileListToArray($path, "*" & $ext, 1)
	If @error = 0 Then
		_GUICtrlComboBox_BeginUpdate($ID_combo)
		_GUICtrlComboBox_ResetContent($ID_combo)
		For $x = 1 To UBound($aFileList) - 1
			_GUICtrlComboBox_AddString($ID_combo, _StringSearchSplit($aFileList[$x], ".", "R", "L"))
		Next
		_GUICtrlComboBox_EndUpdate($ID_combo)
	EndIf
EndFunc   ;==>FolderToComboNoExt


Func WM_NOTIFY($hWnd, $iMsg, $wParam, $lParam)
	#forceref $hWnd, $iMsg, $wParam
	$tNMHDR = DllStructCreate($tagNMHDR, $lParam)
	$hWndFrom = DllStructGetData($tNMHDR, "hWndFrom")
	$iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
	$iCode = DllStructGetData($tNMHDR, "Code")
	Switch $iIDFrom
		Case $h_Tree
			Switch $iCode
				Case $NM_RCLICK
					Local $tPoint = _WinAPI_GetMousePos(True, $hWndFrom), $tHitTest
					$tHitTest = _GUICtrlTreeView_HitTestEx($hWndFrom, DllStructGetData($tPoint, 1), DllStructGetData($tPoint, 2))
					If BitAND(DllStructGetData($tHitTest, "Flags"), $TVHT_ONITEM) Then
						_GUICtrlTreeView_SelectItem($hWndFrom, DllStructGetData($tHitTest, 'Item'))
					EndIf
			EndSwitch
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_NOTIFY

; Resize the status bar when GUI size changes
Func WM_SIZE($hWnd, $iMsg, $wParam, $lParam)
	#forceref $hWnd, $iMsg, $wParam, $lParam
	_GUICtrlStatusBar_Resize($h_StatusBar)
	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_SIZE
