#include-once

#include <GUIConstants.au3>
#include <Timers.au3>
#include <Array.au3>
#include <WinAPISysWin.au3>
#include <WinAPIGdi.au3>
#include <WinAPIProc.au3>
#include <WinAPISys.au3>
#include <WinAPIConv.au3>

;~ 	https://www.autoitscript.com/forum/files/file/506-guichildtabudf/
;~ 	https://www.autoitscript.com/forum/topic/203282-child-gui-example/
Global Const $GuiChildTabUDF_version = "1.2020.7.6" ; UDF version. Who knows, it may change in the future, again.

Global $__a_tabGUI, $__a_tabOPT, $__a_tabDbgCtrls, $__i_tabDbgDbgCreate = 0
Global Enum $eTimerID1 = 2001, $eTimerID2, $eTimerID3 ; "_Timer_*" starts with 1001, 2001 should be safe to start at.
Global Enum $eGui_HWindowParent = 1, $eGui_iWindowParent, $eGui_HWindowSelf, $eGui_ResizeLabel, $eGui_ResizeDocking, $eGui_aSizeLabel, $eGui_Title, _
		$eGui_Width, $eGui_Height, $eGui_Left, $eGui_Top, $eGui_Style, $eGui_ExStyle, $eGui_ChildZMost, $eGui_UBound

Func tabGUI_OPTs($sOpt = Default, $vOpt = Default)
	Local $n
	If UBound($__a_tabOPT) = 0 Then
		Dim $__a_tabOPT[10][2]

		$n = 1
		$__a_tabOPT[$n][0] = "RandomColor" ; 1
		$__a_tabOPT[1][1] = 0

		$n += 1
		$__a_tabOPT[$n][0] = "OnGuiEvent" ; 2 ; to use in "tabGUI_OnGuiEvent()"
		$__a_tabOPT[2][1] = 0

		$n += 1
		$__a_tabOPT[$n][0] = "_WM_LBUTTONDOWN event"
		$__a_tabOPT[3][1] = 0 ; BitOR(1, 2) ; WinDrag/Move, WinONTOP

		$n += 1
		$__a_tabOPT[$n][0] = "$__g_hSIZEBOX"
		$__a_tabOPT[4][1] = 0

		$n += 1
		$__a_tabOPT[$n][0] = "SetCtrlDbgCreateWidth"
		$__a_tabOPT[5][1] = 0

		$__a_tabOPT[0][0] = $n
		If $sOpt = Default Then Return $__a_tabOPT
	EndIf

	If $vOpt = Default Then
		For $n = 1 To $__a_tabOPT[0][0]
			If $__a_tabOPT[$n][0] = $sOpt Then Return $__a_tabOPT[$n][1]
		Next
		Return SetError(1, 0, "")
	Else
		For $n = 1 To $__a_tabOPT[0][0]
			If $__a_tabOPT[$n][0] = "SetCtrlDbgCreateWidth" And $sOpt = "SetCtrlDbgCreateWidth" Then
				If $vOpt = 1 Then $vOpt = ($__i_tabDbgDbgCreate = 0 ? 1 : $__i_tabDbgDbgCreate)
				$__a_tabOPT[$n][1] = $vOpt
				Return $vOpt
			ElseIf $__a_tabOPT[$n][0] = $sOpt Then
				$__a_tabOPT[$n][1] = $vOpt
				Return $vOpt
			EndIf
		Next
		$__a_tabOPT[0][0] += 1
		If UBound($__a_tabOPT) < $__a_tabOPT[0][0] + 1 Then ReDim $__a_tabOPT[UBound($__a_tabOPT) + 10][2]
		$__a_tabOPT[$__a_tabOPT[0][0]][0] = $sOpt
		$__a_tabOPT[$__a_tabOPT[0][0]][1] = $vOpt
		Return $vOpt
	EndIf
EndFunc   ;==>tabGUI_OPTs


Func tabGUI_CtrlDbgCreate($sDbgBttn)
	Local Static $Top = 50, $Width = 130
	If UBound($__a_tabDbgCtrls) = 0 Then
		Dim $__a_tabDbgCtrls[10][3]
		$__a_tabDbgCtrls[0][0] = 0
		$__i_tabDbgDbgCreate = $Width + 5
		If tabGUI_OPTs("SetCtrlDbgCreateWidth") Then
			tabGUI_OPTs("SetCtrlDbgCreateWidth", $__i_tabDbgDbgCreate)
		EndIf
	EndIf
	Local $n
	Switch $sDbgBttn
		Case "Show GUI array"
			$__a_tabDbgCtrls[0][0] += 1
			$n = $__a_tabDbgCtrls[0][0]
			$__a_tabDbgCtrls[$n][1] = "tabGUI_Dbg_ShowGuiArray"
			$__a_tabDbgCtrls[$n][2] = $sDbgBttn
			$__a_tabDbgCtrls[$n][0] = GUICtrlCreateButton($sDbgBttn, $__a_tabGUI[1][$eGui_Width] - $Width, $Top, $Width - 5, 25)
			GUICtrlSetOnEvent($__a_tabDbgCtrls[$n][0], "tabGUI_Dbg_ShowGuiArray")
			GUICtrlSetResizing($__a_tabDbgCtrls[$n][0], $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
			$Top += 27

		Case "Show OPT array"
			$__a_tabDbgCtrls[0][0] += 1
			$n = $__a_tabDbgCtrls[0][0]
			$__a_tabDbgCtrls[$n][1] = "tabGUI_Dbg_ShowOptArray"
			$__a_tabDbgCtrls[$n][2] = $sDbgBttn
			$__a_tabDbgCtrls[$n][0] = GUICtrlCreateButton($sDbgBttn, $__a_tabGUI[1][$eGui_Width] - $Width, $Top, $Width - 5, 25)
			GUICtrlSetOnEvent($__a_tabDbgCtrls[$n][0], "tabGUI_Dbg_ShowOptArray")
			GUICtrlSetResizing($__a_tabDbgCtrls[$n][0], $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
			$Top += 27

		Case "Swap GUIs/LABELs"
			$__a_tabDbgCtrls[0][0] += 1
			$n = $__a_tabDbgCtrls[0][0]
			$__a_tabDbgCtrls[$n][1] = "tabGUI_Dbg_GUIsLABELs"
			$__a_tabDbgCtrls[$n][2] = $sDbgBttn
			$__a_tabDbgCtrls[$n][0] = GUICtrlCreateButton($sDbgBttn, $__a_tabGUI[1][$eGui_Width] - $Width, $Top, $Width - 5, 25)
			GUICtrlSetOnEvent($__a_tabDbgCtrls[$n][0], "tabGUI_Dbg_GUIsLABELs")
			GUICtrlSetResizing($__a_tabDbgCtrls[$n][0], $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
			$Top += 27

		Case "Can Drag child"
			$__a_tabDbgCtrls[0][0] += 1
			$n = $__a_tabDbgCtrls[0][0]
			$__a_tabDbgCtrls[$n][1] = "tabGUI_Dbg_CanDragchild"
			$__a_tabDbgCtrls[$n][2] = $sDbgBttn
			$__a_tabDbgCtrls[$n][0] = GUICtrlCreateCheckbox($sDbgBttn, $__a_tabGUI[1][$eGui_Width] - $Width, $Top, $Width - 5, 25, -1, $WS_EX_STATICEDGE)
			GUICtrlSetOnEvent($__a_tabDbgCtrls[$n][0], "tabGUI_Dbg_CanDragchild")
			GUICtrlSetResizing($__a_tabDbgCtrls[$n][0], $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
			$Top += 27

		Case "Self CPU usage"
			$__a_tabDbgCtrls[0][0] += 1
			$n = $__a_tabDbgCtrls[0][0]
			$__a_tabDbgCtrls[$n][1] = "Self CPU usage"
			$__a_tabDbgCtrls[$n][2] = $sDbgBttn
			$__a_tabDbgCtrls[$n][0] = tabGUI_OPTs("CPU_label", GUICtrlCreateLabel($sDbgBttn, $__a_tabGUI[1][$eGui_Width] - $Width, $Top, $Width - 5, 25, BitOR($SS_CENTER, $SS_CENTERIMAGE), $WS_EX_STATICEDGE))
			GUICtrlSetResizing($__a_tabDbgCtrls[$n][0], $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
			_WinAPI_SetTimer($__a_tabGUI[1][$eGui_HWindowSelf], $eTimerID3, 1000, 0)
			$Top += 27


	EndSwitch

EndFunc   ;==>tabGUI_CtrlDbgCreate

Func tabGUI_Dbg_CanDragchild()
	Local Static $bSwap = False
	$bSwap = Not $bSwap
	GUICtrlSetState(@GUI_CtrlId, ($bSwap ? $GUI_CHECKED : $GUI_UNCHECKED))
	$__a_tabOPT[3][1] = ($bSwap ? 3 : 0)
EndFunc   ;==>tabGUI_Dbg_CanDragchild

Func tabGUI_Dbg_ShowGuiArray()
	_ArrayDisplay($__a_tabGUI, "$__a_tabGUI")
EndFunc   ;==>tabGUI_Dbg_ShowGuiArray

Func tabGUI_Dbg_ShowOptArray()
	_ArrayDisplay($__a_tabOPT, "$__a_tabOPT")
EndFunc   ;==>tabGUI_Dbg_ShowOptArray

Func tabGUI_Dbg_GUIsLABELs()
	Local Static $bSwap = False
	$bSwap = Not $bSwap
	For $n = 2 To $__a_tabGUI[0][0]
		GUISetState($bSwap ? @SW_HIDE : @SW_SHOW, $__a_tabGUI[$n][$eGui_HWindowSelf])
		GUICtrlSetState($__a_tabGUI[$n][$eGui_ResizeLabel], $bSwap ? $GUI_SHOW : $GUI_HIDE)
	Next
EndFunc   ;==>tabGUI_Dbg_GUIsLABELs

; just like GUICreate() with a few tweaks
Func tabGUI_Create($Title = "", $iWidth = Default, $iHeight = Default, $iLeft = Default, $iTop = Default, $iStyle = Default, $iExStyle = Default, $hParent = Default)
	If UBound($__a_tabGUI) = 0 Then
		Dim $__a_tabGUI[2][$eGui_UBound]
	ElseIf UBound($__a_tabGUI) < $__a_tabGUI[0][0] + 2 Then
		ReDim $__a_tabGUI[UBound($__a_tabGUI) + 1][$eGui_UBound]
	EndIf

	If $__a_tabGUI[0][0] == "" Then ; VarGetType($__a_tabGUI[0][0]) = String
		Opt("GUIOnEventMode", 1) ; this UDF is design with "GUIOnEventMode = 1" in mind.
		tabGUI_OPTs() ; load default options.
		$__a_tabGUI[0][0] = 0
		$__a_tabGUI[0][$eGui_HWindowParent] = "hWindowParent"
		$__a_tabGUI[0][$eGui_iWindowParent] = "iWindowParent"
		$__a_tabGUI[0][$eGui_HWindowSelf] = "hWindowSelf"
		$__a_tabGUI[0][$eGui_ResizeLabel] = "ResizeLabel"
		$__a_tabGUI[0][$eGui_ResizeDocking] = "ResizeDocking"
		$__a_tabGUI[0][$eGui_aSizeLabel] = "aSizeLabel"
		$__a_tabGUI[0][$eGui_Title] = "$Title"
		$__a_tabGUI[0][$eGui_Width] = "$iWidth"
		$__a_tabGUI[0][$eGui_Height] = "$iHeight"
		$__a_tabGUI[0][$eGui_Left] = "$iLeft"
		$__a_tabGUI[0][$eGui_Top] = "$iTop"
		$__a_tabGUI[0][$eGui_Style] = "$iStyle"
		$__a_tabGUI[0][$eGui_ExStyle] = "$iExStyle"
		$__a_tabGUI[0][$eGui_ChildZMost] = "ChildZMost"

	EndIf
	Local $iParent, $n = $__a_tabGUI[0][0] + 1
	Local $aSizeFour = [0, 0, 0, 0]
	$__a_tabGUI[0][0] = $n
	$__a_tabGUI[$n][$eGui_aSizeLabel] = $aSizeFour
	If $n = 1 Then
		If $iWidth = Default Then $iWidth = 810
		If $iHeight = Default Then $iHeight = 500
		If $hParent = Default Then $hParent = 0
		$__a_tabGUI[$n][$eGui_HWindowParent] = $hParent
		$__a_tabGUI[$n][$eGui_iWindowParent] = tabGUI_ParentH2I($hParent)
		If $iTop = Default Then $iTop = -1
		If $iLeft = Default Then $iLeft = -1
		If $iStyle = Default Or $iStyle = -1 Then $iStyle = BitOR($WS_MINIMIZEBOX, $WS_MAXIMIZEBOX, $WS_CAPTION, _
				$WS_SIZEBOX, $WS_POPUP, $WS_SYSMENU, $WS_OVERLAPPEDWINDOW, $WS_CLIPCHILDREN, $WS_CLIPSIBLINGS)
		If $iExStyle = Default Then $iExStyle = -1
	Else
		If $hParent = Default Then $hParent = $__a_tabGUI[1][$eGui_HWindowSelf]
		$__a_tabGUI[$n][$eGui_HWindowParent] = $hParent
		$__a_tabGUI[$n][$eGui_iWindowParent] = tabGUI_ParentH2I($hParent)
		$iParent = $__a_tabGUI[$n][$eGui_iWindowParent]
		If $iParent = 0 Then $iParent = 1

		If $iStyle = Default Or $iStyle = -1 Then $iStyle = BitOR($WS_CHILD, $WS_TABSTOP)
		If $iExStyle = Default Or $iExStyle = -1 Then $iExStyle = $WS_TABSTOP

		If $iTop = Default Then $iTop = 2
		If $iLeft = Default Then $iLeft = 2
		If $iWidth = Default Then $iWidth = $__a_tabGUI[$iParent][$eGui_Width] - $iLeft - ($iParent = 1 ? tabGUI_OPTs("SetCtrlDbgCreateWidth") : 0)
		If $iHeight = Default Then $iHeight = $__a_tabGUI[$iParent][$eGui_Height] - $iTop - ($iParent = 1 ? 20 : 0)

	EndIf

	$__a_tabGUI[$n][$eGui_ResizeDocking] = $GUI_DOCKLEFT + $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKBOTTOM
	If StringInStr($Title, "SetResizing:") Then ; SetResizing:LRTBWH;
		Local $temp1 = StringLeft($Title, StringInStr($Title, ";"))
		$Title = StringTrimLeft($Title, StringLen($temp1))
		$__a_tabGUI[$n][$eGui_ResizeDocking] = tabGUI_DockStr2Int($temp1)
	EndIf

	$__a_tabGUI[$n][$eGui_Title] = $Title
	$__a_tabGUI[$n][$eGui_Width] = $iWidth
	$__a_tabGUI[$n][$eGui_Height] = $iHeight
	$__a_tabGUI[$n][$eGui_Left] = $iLeft
	$__a_tabGUI[$n][$eGui_Top] = $iTop
	$__a_tabGUI[$n][$eGui_Style] = $iStyle
	$__a_tabGUI[$n][$eGui_ExStyle] = $iExStyle

	Local $iRandomColor = tabGUI_NextColor() ; "0x" & Hex(Random(150, 255, 1), 2) & Hex(Random(150, 255, 1), 2) & Hex(Random(150, 255, 1), 2)

	If $__a_tabGUI[$n][$eGui_HWindowParent] Then
		GUISwitch($__a_tabGUI[$n][$eGui_HWindowParent])
		$__a_tabGUI[$n][$eGui_ResizeLabel] = GUICtrlCreateLabel($n, $iLeft, $iTop, $iWidth, $iHeight, -1, $WS_EX_CLIENTEDGE)
		GUICtrlSetResizing($__a_tabGUI[$n][$eGui_ResizeLabel], $__a_tabGUI[$n][$eGui_ResizeDocking])
		If tabGUI_OPTs("RandomColor") Then GUICtrlSetBkColor($__a_tabGUI[$n][$eGui_ResizeLabel], $iRandomColor)
		GUICtrlSetState($__a_tabGUI[$n][$eGui_ResizeLabel], $GUI_ONTOP)
		GUICtrlSetState($__a_tabGUI[$n][$eGui_ResizeLabel], $GUI_HIDE)
	EndIf

	$__a_tabGUI[$n][$eGui_HWindowSelf] = GUICreate($Title, $iWidth, $iHeight, $iLeft, $iTop, $iStyle, $iExStyle, $hParent)
	If tabGUI_OPTs("RandomColor") And $n > 1 Then GUISetBkColor($iRandomColor, $__a_tabGUI[$n][$eGui_HWindowSelf])

	If $n = 1 Then

		GUISetOnEvent($GUI_EVENT_CLOSE, "tabGUI_OnGuiEvent", $__a_tabGUI[1][$eGui_HWindowSelf])
;~ 		GUISetOnEvent($GUI_EVENT_MINIMIZE, "tabGUI_OnGuiEvent") ; ..I have no use for these
;~ 		GUISetOnEvent($GUI_EVENT_RESTORE, "tabGUI_OnGuiEvent") ;    but you might.
;~ 		GUISetOnEvent($GUI_EVENT_MAXIMIZE, "tabGUI_OnGuiEvent")
;~ 		GUISetOnEvent($GUI_EVENT_PRIMARYUP, "tabGUI_OnGuiEvent")
;~ 		GUISetOnEvent($GUI_EVENT_PRIMARYDOWN, "tabGUI_OnGuiEvent")
;~ 		GUISetOnEvent($GUI_EVENT_SECONDARYUP, "tabGUI_OnGuiEvent")
;~ 		GUISetOnEvent($GUI_EVENT_SECONDARYDOWN, "tabGUI_OnGuiEvent")
;~ 		GUISetOnEvent($GUI_EVENT_RESIZED, "tabGUI_OnGuiEvent")
;~ 		GUISetOnEvent($GUI_EVENT_DROPPED, "tabGUI_OnGuiEvent")

		Local Const $SBS_SIZEBOX = 8 ;, $SBS_SIZEGRIP = 16
		$__a_tabOPT[4][1] = _WinAPI_CreateWindowEx(0, "Scrollbar", "", $WS_CHILD + $WS_VISIBLE + $SBS_SIZEBOX, $iWidth - 16, $iHeight - 16, 16, 16, $__a_tabGUI[$n][$eGui_HWindowSelf])
		__WM_SETMINMAXINFO_GUI("Register", $__a_tabGUI[$n][$eGui_HWindowSelf], 0, 0)

	EndIf


	If $__a_tabGUI[$n][$eGui_HWindowParent] Then GUISetState(@SW_SHOW, $__a_tabGUI[$n][$eGui_HWindowSelf]) ; ..if not the parent GUI then show.
	GUISwitch($__a_tabGUI[$n][$eGui_HWindowSelf]) ; switch to the newly created GUI for the user to add controls to it.

	$__a_tabGUI[$n][$eGui_ChildZMost] = 0
	If $n = 2 Then $__a_tabGUI[$n][$eGui_ChildZMost] = 1 ; the first child will show on top once the parent GUI is shown.

	Return SetError(0, $n, $__a_tabGUI[$n][$eGui_HWindowSelf])
EndFunc   ;==>tabGUI_Create

; get the $hParent and return the array index
Func tabGUI_ParentH2I($hParent)
	For $n = 1 To $__a_tabGUI[0][0]
		If $__a_tabGUI[$n][$eGui_HWindowSelf] = $hParent And $__a_tabGUI[$n][$eGui_HWindowParent] <> $hParent Then Return $n
	Next
	Return SetError(1, 0, 0)
EndFunc   ;==>tabGUI_ParentH2I

; for debug. return a new "pastel color"
Func tabGUI_NextColor()
	Local Static $color, $iIndx = 1, $hx = 0xD0
	$color = "0x" & Hex("0x" & Hex($hx - ($iIndx * Random(2, 10, 1)), 2) & Hex($hx - ($iIndx * Random(2, 10, 1)), 2) & Hex($hx + ($iIndx * Random(2, 10, 1)), 2), 6)
	$iIndx += 1
;~ 	ConsoleWrite('+ Func tabGUI_NextColor() : ' & $color & @CRLF)
	Return $color
EndFunc   ;==>tabGUI_NextColor

; to change the default ChildGUI dock, include in the title the string
Func tabGUI_DockStr2Int($sDockStr)
	Local $n, $aDock, $iDock = 0
	$sDockStr = StringReplace($sDockStr, "SetResizing:", "")
	$sDockStr = StringReplace($sDockStr, ";", "")
	$aDock = StringSplit($sDockStr, "", 0)
	For $n = 1 To $aDock[0] ; SetResizing:LRTBWH;
		Switch $aDock[$n]
			Case "L"
				$iDock += $GUI_DOCKLEFT
			Case "R"
				$iDock += $GUI_DOCKRIGHT
			Case "T"
				$iDock += $GUI_DOCKTOP
			Case "B"
				$iDock += $GUI_DOCKBOTTOM
			Case "W"
				$iDock += $GUI_DOCKWIDTH
			Case "H"
				$iDock += $GUI_DOCKHEIGHT
		EndSwitch
	Next
	Return $iDock
EndFunc   ;==>tabGUI_DockStr2Int

Func tabGUI_OnGuiEvent()
	ConsoleWrite('+ Func tabGUI_OnGuiEvent()' & @CRLF)
	Local $GuiCtrlId = Int(Execute("@GUI_CtrlId"))
	If tabGUI_OPTs("OnGuiEvent") Then
		$GuiCtrlId = tabGUI_OPTs("OnGuiEvent")
		tabGUI_OPTs("OnGuiEvent", 0)
	EndIf ; this way you can call this Func, by first setting the "@GUI_CtrlId" on tabGUI_OPTs("OnGuiEvent", GUI_CtrlId)

	If $GuiCtrlId = 0 Then Return SetError(1, 0, 1)

	Switch $GuiCtrlId
		Case $GUI_EVENT_CLOSE
			ConsoleWrite('- Case $GUI_EVENT_CLOSE' & @CRLF)

			Local $GuiWinHandle = Execute("@GUI_WinHandle")
			If $GuiWinHandle = 0 Or $GuiWinHandle = $__a_tabGUI[1][$eGui_HWindowSelf] Then
				GUIRegisterMsg($WM_TIMER, "")
				GUIRegisterMsg($WM_GETMINMAXINFO, "")
				GUIRegisterMsg($WM_WINDOWPOSCHANGING, "")
				GUIRegisterMsg($WM_SIZE, "")
				GUISetState(@SW_HIDE, $__a_tabGUI[1][$eGui_HWindowSelf])
				For $n = $__a_tabGUI[0][0] To 2 Step -1
					If $__a_tabGUI[$n][$eGui_HWindowSelf] Then GUIDelete($__a_tabGUI[$n][$eGui_HWindowSelf])
				Next
				GUIDelete($__a_tabGUI[1][$eGui_HWindowSelf])
				Exit
			EndIf

		Case $GUI_EVENT_PRIMARYUP
			ConsoleWrite('- Case $GUI_EVENT_PRIMARYUP' & @CRLF)

		Case $GUI_EVENT_PRIMARYDOWN
			ConsoleWrite('- Case $GUI_EVENT_PRIMARYDOWN' & @CRLF)

		Case $GUI_EVENT_SECONDARYUP
			ConsoleWrite('- Case $GUI_EVENT_SECONDARYUP' & @CRLF)

		Case $GUI_EVENT_SECONDARYDOWN
			ConsoleWrite('- Case $GUI_EVENT_SECONDARYDOWN' & @CRLF)

		Case $GUI_EVENT_RESIZED
			ConsoleWrite('- Case $GUI_EVENT_RESIZED' & @CRLF)

	EndSwitch
EndFunc   ;==>tabGUI_OnGuiEvent

; __WM_SETMINMAXINFO_GUI() is self managing.
; It registers itself and gets the default GUI parent size as the minimum size.
; after the first call, you can call it again to set or get values, as are in the "Switch $cmd"
Func __WM_SETMINMAXINFO_GUI($cmd, $hGui, $iMaxWidth, $iMaxHeight) ; ..will expect 4 valuse ( and I should not set defaults, should, so I don't )
	#forceref $cmd, $hGui, $iMaxWidth

	;;; "https://www.autoitscript.com/forum/topic/144385-restricting-the-minimum-and-maximum-sizes-of-a-gui/"
	Local Const $tagMINMAXINFO = "struct; long ReservedX;long ReservedY;long MaxSizeX;long MaxSizeY;long MaxPositionX;" & _
			"long MaxPositionY;long MinTrackSizeX;long MinTrackSizeY;long MaxTrackSizeX;long MaxTrackSizeY; endstruct"
	Local Static $tMINMAXINFO, $aMinMax[4] = [0, 0, 0, 0], $GuiPos[4], $GuiClient[2], $GuiHWND = 0

	If $GuiHWND And $GuiHWND = $cmd Then
		$tMINMAXINFO = DllStructCreate($tagMINMAXINFO, $iMaxHeight)
		If $aMinMax[0] Then $tMINMAXINFO.MinTrackSizeX = $aMinMax[0]
		If $aMinMax[1] Then $tMINMAXINFO.MinTrackSizeY = $aMinMax[1]
		If $aMinMax[2] Then $tMINMAXINFO.MaxTrackSizeX = $aMinMax[2]
		If $aMinMax[3] Then $tMINMAXINFO.MaxTrackSizeY = $aMinMax[3]
		Return $GUI_RUNDEFMSG
	Else
		Switch $cmd
			Case "GuiHWND" ; get the registered GUI
				Return $GuiHWND
			Case "GuiPos" ; get the original WinGetPos($hGui)
				Return $GuiPos
			Case "GuiClient" ; get the original WinGetClientSize($hGui)
				Return $GuiClient
			Case "MinWidth"
				$aMinMax[0] = $hGui
				Return
			Case "MinHeight"
				$aMinMax[1] = $hGui
				Return
			Case "MaxWidth"
				$aMinMax[2] = $hGui
				Return
			Case "MaxHeight"
				$aMinMax[3] = $hGui
				Return
			Case "MinMaxArray"
				If UBound($hGui) <> 4 Then Return SetError(1, 0, 1)
				$aMinMax = $hGui ; ..to set the "$aMinMax" array[4]
				Return
			Case "Register" ;, $hGui, [,$iMaxWidth, $iMaxHeight]
				If $GuiHWND Then Return SetError(4, 0, 4) ; error: already registered
				If Not IsHWnd($hGui) Then Return SetError(5, 0, 5) ; error: not a GUI
				$GuiPos = WinGetPos($hGui)
				If UBound($GuiPos) <> 4 Then Return SetError(2, 0, 2) ; error: internal fail
				$GuiClient = WinGetClientSize($hGui)
				If UBound($GuiClient) <> 2 Then Return SetError(3, 0, 3) ; error: internal fail
				$aMinMax[0] = $GuiPos[2]
				$aMinMax[1] = $GuiPos[3]
				$aMinMax[2] = $iMaxWidth
				$aMinMax[3] = $iMaxHeight
				$GuiHWND = $hGui

				_WM_SetWINDOWPOSCHANGING($cmd, $hGui, 0, 0) ; ..positioned here as it fit the need of this UDF(ish)

				Local $i = Int(Not GUIRegisterMsg($WM_GETMINMAXINFO, "__WM_SETMINMAXINFO_GUI"))
				If $i Then  ; error: internal fail
					$aMinMax[0] = 0
					$GuiHWND = 0
				EndIf
				Return SetError($i, 0, $i)
			Case Else
				Return SetError(9, 0, $GUI_RUNDEFMSG) ; error: unknown command
		EndSwitch
	EndIf
EndFunc   ;==>__WM_SETMINMAXINFO_GUI

Func tabGUI_ChildZMost($n = Default)
	Local Static $v = 2
	If $n = Default Then Return $v
	For $x = 2 To $__a_tabGUI[0][0]
		$__a_tabGUI[$x][$eGui_ChildZMost] = 0
	Next
	$v = $n
	$__a_tabGUI[$n][$eGui_ChildZMost] = 1
	Return $v
EndFunc   ;==>tabGUI_ChildZMost

Func tabGUI_ChildActivateFirstChild()
	Local $hWnd = 0
	For $x = 2 To $__a_tabGUI[0][0]
		If $__a_tabGUI[$x][$eGui_ChildZMost] = 1 Then
			If $__a_tabGUI[$x][$eGui_iWindowParent] < 2 Then
				Return
			ElseIf $__a_tabGUI[$__a_tabGUI[$x][$eGui_iWindowParent]][$eGui_iWindowParent] = 1 Then
				$hWnd = $__a_tabGUI[$__a_tabGUI[$x][$eGui_iWindowParent]][$eGui_HWindowSelf]
			ElseIf $__a_tabGUI[$__a_tabGUI[$__a_tabGUI[$x][$eGui_iWindowParent]][$eGui_iWindowParent]][$eGui_iWindowParent] = 1 Then
				$hWnd = $__a_tabGUI[$__a_tabGUI[$__a_tabGUI[$x][$eGui_iWindowParent]][$eGui_iWindowParent]][$eGui_HWindowSelf]
			ElseIf $__a_tabGUI[$__a_tabGUI[$__a_tabGUI[$__a_tabGUI[$x][$eGui_iWindowParent]][$eGui_iWindowParent]][$eGui_iWindowParent]][$eGui_iWindowParent] = 1 Then
				$hWnd = $__a_tabGUI[$__a_tabGUI[$__a_tabGUI[$__a_tabGUI[$x][$eGui_iWindowParent]][$eGui_iWindowParent]][$eGui_iWindowParent]][$eGui_HWindowSelf]
			Else
				Return SetError(0, 1, 0) ; ..going too deep, need to code for deeper.
			EndIf
			If $hWnd <> 0 Then _WinAPI_SetWindowPos($hWnd, $HWND_TOP, 0, 0, 0, 0, $SWP_NOMOVE + $SWP_NOSIZE + $SWP_NOCOPYBITS)
			Return $hWnd
		EndIf
	Next
EndFunc   ;==>tabGUI_ChildActivateFirstChild

Func tabGUI_hWnd2iCtrl($hWnd)
	For $n = 2 To $__a_tabGUI[0][0]
		If $hWnd = $__a_tabGUI[$n][$eGui_HWindowSelf] Then Return SetError(0, $n, $__a_tabGUI[$n][$eGui_ResizeLabel])
	Next
	Return SetError(1, $__a_tabGUI[0][0], 0)
EndFunc   ;==>tabGUI_hWnd2iCtrl

Func ___WM_TIMER($hWnd, $iMsg, $iTimerID, $lParam)
	#forceref $hWnd, $iMsg, $iTimerID, $lParam
	Switch $iTimerID
		Case $eTimerID1 ; "_Timer_*" starts with 1001, 2001 should be safe to start at.
			_WinAPI_KillTimer($hWnd, $iTimerID)
			__WM_SIZE_ResizeChildren()

		Case $eTimerID2
			_WinAPI_KillTimer($hWnd, $iTimerID)
			tabGUI_ChildActivateFirstChild()

		Case $eTimerID3
			__GetProcUsage()

	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>___WM_TIMER

Func ___WM_SIZE($hWnd, $iMsg, $wParam, $lParam)
	#forceref $hWnd, $iMsg, $wParam, $lParam
	If $hWnd = $__a_tabGUI[1][$eGui_HWindowSelf] Then
		__WM_SIZE_ResizeChildren() ; the timer below is needed to show updates while holding the mouse button down
		_WinAPI_SetTimer($__a_tabGUI[1][$eGui_HWindowSelf], $eTimerID1, 30, 0) ;    while resizing the parent GUI.
	EndIf
	Return $GUI_RUNDEFMSG
EndFunc   ;==>___WM_SIZE

Func __WM_SIZE_ResizeChildren()
	Local $iRedrawWindow = 0, $aSize = WinGetClientSize($__a_tabGUI[1][$eGui_HWindowSelf])
	If UBound($aSize) = 2 Then WinMove($__a_tabOPT[4][1], "", $aSize[0] - 16, $aSize[1] - 16) ; update/move the SIZEBOX to its corner.

	Local $aSizeParent, $aSizeFour, $aWinPos
	For $n = 2 To $__a_tabGUI[0][0]
		$aWinPos = ControlGetPos($__a_tabGUI[$n][$eGui_HWindowParent], "", $__a_tabGUI[$n][$eGui_ResizeLabel])
		If UBound($aWinPos) <> 4 Then ContinueLoop
		$aSizeFour = $__a_tabGUI[$n][$eGui_aSizeLabel]
		If UBound($aSizeFour) <> 4 Then ContinueLoop
		If $aSizeFour[0] = $aWinPos[0] And $aSizeFour[1] = $aWinPos[1] And $aSizeFour[2] = $aWinPos[2] And $aSizeFour[3] = $aWinPos[3] Then ContinueLoop
		$__a_tabGUI[$n][$eGui_aSizeLabel] = $aWinPos

		If $__a_tabGUI[$n][$eGui_iWindowParent] Then
			$aSizeParent = ControlGetPos($__a_tabGUI[$__a_tabGUI[$n][$eGui_iWindowParent]][$eGui_HWindowParent], "", $__a_tabGUI[$__a_tabGUI[$n][$eGui_iWindowParent]][$eGui_ResizeLabel])
			If IsArray($aSizeParent) Then
				$aWinPos[0] -= $aSizeParent[0]
				$aWinPos[1] -= $aSizeParent[1]
			EndIf
		EndIf
		WinMove($__a_tabGUI[$n][$eGui_HWindowSelf], "", $aWinPos[0], $aWinPos[1], $aWinPos[2], $aWinPos[3])
		$iRedrawWindow = 1
	Next
	If $iRedrawWindow Then _WinAPI_RedrawWindow($__a_tabGUI[1][$eGui_HWindowSelf], 0, 0, $RDW_INVALIDATE + $RDW_ALLCHILDREN + $RDW_INTERNALPAINT)
EndFunc   ;==>__WM_SIZE_ResizeChildren

; _WM_SetWINDOWPOSCHANGING() is self managing. The main use is to keep children GUIs in place.
; It registers itself and registers that it will need ( $WM_TIMER & $WM_SIZE )
; After the first call, you can call it again to set or get values, as are in the "Switch $hWnd"
; A "Gap" of zero will disable the "magnetic pull" to the monitor edge. ( see $nGap )
; An array for "EdgeBorderWidth" can be set different from default if not using Win10 or defaults. ( see $nEdgeBorderWidth[4] )
Func _WM_SetWINDOWPOSCHANGING($hWnd, $iMsg, $wParam, $lParam) ; ..will expect 4 valuse ( and I should not set defaults, should, so I don't )
	#forceref $hWnd, $iMsg, $wParam, $lParam

	Local Static $n, $iCtrl, $hParentGui = 0, $stWinPos, $tPos, $hMonitor, $aData, $nLeft, $nTop, $nRight, $nBottom, $hTimer = 0, $hParentGuiTimer = 0
	Local Static $nGap = 14, $nEdgeBorderWidth[4] = [-7, 0, 7, 7] ; Left, Top, Right, Bottom

	Switch $hWnd
		Case "Register"
			If $hParentGui Then Return SetError(1, 0, -1)
			If Not IsHWnd($iMsg) Then Return SetError(2, 0, -1)
			$hParentGui = $iMsg
			GUIRegisterMsg($WM_TIMER, "___WM_TIMER")
			GUIRegisterMsg($WM_SIZE, "___WM_SIZE")
			Return GUIRegisterMsg($WM_WINDOWPOSCHANGING, "_WM_SetWINDOWPOSCHANGING")

		Case "Gap"
			$nGap = $iMsg
			Return

		Case "EdgeBorderWidth"
			$nEdgeBorderWidth = $iMsg
			Return

	EndSwitch

	; https://docs.microsoft.com/en-us/windows/win32/api/winuser/ns-winuser-windowpos?redirectedfrom=MSDN
	$stWinPos = DllStructCreate("hwnd hwnd;hwnd hwndInsertAfter;int x;int y;int cx;int cy;uint flags", $lParam) ; $tagWINDOWPOS

	If $hParentGui <> $hWnd Then ; ..is a child gui
		If TimerDiff($hParentGuiTimer) < 100 Then Return $GUI_RUNDEFMSG
		$iCtrl = tabGUI_hWnd2iCtrl($hWnd)
		$n = @extended ; ..this is the array index.
		If @error Then Return $GUI_RUNDEFMSG

		If $stWinPos.cx = 0 Then ; .. $hWnd was clicked but not moved, just clicked.
			tabGUI_ChildZMost($n)
			_WinAPI_SetTimer($__a_tabGUI[1][$eGui_HWindowSelf], $eTimerID2, 10, 0) ; tabGUI_ChildActivateFirstChild()
			Return $GUI_RUNDEFMSG
		EndIf

		If BitAND($__a_tabOPT[3][1], 2) Then _WinAPI_SetWindowPos($hWnd, $HWND_TOP, 0, 0, 0, 0, $SWP_NOMOVE + $SWP_NOSIZE + $SWP_NOCOPYBITS)
		If BitAND($__a_tabOPT[3][1], 1) Then ; BitOR(1, 2) ; WinDrag/Move, WinONTOP
			GUICtrlSetPos($iCtrl, $stWinPos.x, $stWinPos.y)
			GUICtrlSetResizing($iCtrl, $__a_tabGUI[$n][$eGui_ResizeDocking])

			If $__a_tabGUI[$n][$eGui_ChildZMost] = 0 Then
				tabGUI_ChildZMost($n)
				_WinAPI_SetTimer($__a_tabGUI[1][$eGui_HWindowSelf], $eTimerID2, 10, 0) ; tabGUI_ChildActivateFirstChild()
			EndIf

		Else
			;				..these are the values one can find from "flags"
;~ 			If BitAND($stWinPos.flags, $SWP_NOSIZE) Then ConsoleWrite('- _WM_WINDOWPOSCHANGING: $SWP_NOSIZE ' & @CRLF)
;~ 			If BitAND($stWinPos.flags, $SWP_NOMOVE) Then ConsoleWrite('- _WM_WINDOWPOSCHANGING: $SWP_NOMOVE ' & @CRLF)
;~ 			If BitAND($stWinPos.flags, $SWP_NOZORDER) Then ConsoleWrite('- _WM_WINDOWPOSCHANGING: $SWP_NOZORDER ' & @CRLF)
;~ 			If BitAND($stWinPos.flags, $SWP_NOREDRAW) Then ConsoleWrite('- _WM_WINDOWPOSCHANGING: $SWP_NOREDRAW ' & @CRLF)
;~ 			If BitAND($stWinPos.flags, $SWP_NOACTIVATE) Then ConsoleWrite('- _WM_WINDOWPOSCHANGING: $SWP_NOACTIVATE ' & @CRLF)
;~ 			If BitAND($stWinPos.flags, $SWP_FRAMECHANGED) Then ConsoleWrite('- _WM_WINDOWPOSCHANGING: $SWP_FRAMECHANGED ' & @CRLF)
;~ 			If BitAND($stWinPos.flags, $SWP_SHOWWINDOW) Then ConsoleWrite('- _WM_WINDOWPOSCHANGING: $SWP_SHOWWINDOW ' & @CRLF)
;~ 			If BitAND($stWinPos.flags, $SWP_HIDEWINDOW) Then ConsoleWrite('- _WM_WINDOWPOSCHANGING: $SWP_HIDEWINDOW ' & @CRLF)
;~ 			If BitAND($stWinPos.flags, $SWP_NOCOPYBITS) Then ConsoleWrite('- _WM_WINDOWPOSCHANGING: $SWP_NOCOPYBITS ' & @CRLF)
;~ 			If BitAND($stWinPos.flags, $SWP_NOREPOSITION) Then ConsoleWrite('- _WM_WINDOWPOSCHANGING: $SWP_NOREPOSITION ' & @CRLF)
;~ 			If BitAND($stWinPos.flags, $SWP_NOSENDCHANGING) Then ConsoleWrite('- _WM_WINDOWPOSCHANGING: $SWP_NOSENDCHANGING ' & @CRLF)

			If BitAND($stWinPos.flags, $SWP_FRAMECHANGED) Then GUISetState(@SW_RESTORE, $hWnd) ; ..for when DClick the child
			$stWinPos.flags = BitOR($SWP_NOMOVE, $SWP_NOSIZE) ; https://www.autoitscript.com/forum/topic/84774-unmovable-gui/

			If $__a_tabGUI[$n][$eGui_ChildZMost] = 0 Then
				tabGUI_ChildZMost($n)
				_WinAPI_SetTimer($__a_tabGUI[1][$eGui_HWindowSelf], $eTimerID2, 10, 0) ; tabGUI_ChildActivateFirstChild()
			EndIf

		EndIf
		Return $GUI_RUNDEFMSG
	EndIf
	$hParentGuiTimer = TimerInit()

	; ..this is the "magnetic pull" section below
	If $nGap = 0 Then Return $GUI_RUNDEFMSG ; ..if not used, don't waste time calculating all that.

	If TimerDiff($hTimer) > 1000 Then
		$hTimer = TimerInit()
		$tPos = _WinAPI_GetMousePos()                                  ;  These func are very time consuming and
		If Not @error Then $hMonitor = _WinAPI_MonitorFromPoint($tPos) ;  the user is very unlikely to move the
		If Not @error Then $aData = _WinAPI_GetMonitorInfo($hMonitor)  ;  mouse into position on another monitor
		If @error Then Return $GUI_RUNDEFMSG                           ;  in less than a second.
	EndIf

	$nLeft = DllStructGetData($aData[1], 1)
	$nTop = DllStructGetData($aData[1], 2)
	$nRight = DllStructGetData($aData[1], 3) - $stWinPos.cx
	$nBottom = DllStructGetData($aData[1], 4) - $stWinPos.cy

	If Abs($nLeft - $stWinPos.x) <= $nGap Then $stWinPos.x = $nLeft + $nEdgeBorderWidth[0]
	If Abs($nRight - $stWinPos.x) <= $nGap Then $stWinPos.x = $nRight + $nEdgeBorderWidth[2]
	If Abs($nBottom - $stWinPos.y) <= $nGap Then $stWinPos.y = $nBottom + $nEdgeBorderWidth[3]
	If Abs($nTop - $stWinPos.y) <= $nGap Then $stWinPos.y = $nTop + $nEdgeBorderWidth[1]

	Return $GUI_RUNDEFMSG
EndFunc   ;==>_WM_SetWINDOWPOSCHANGING

Func __GetProcUsage()
	Local Static $Prev1, $Prev2, $CPU, $Time1, $Time2, $PID = @AutoItPID, $iLabel = tabGUI_OPTs("CPU_label")
	$Time1 = _WinAPI_GetProcessTimes($PID)
	$Time2 = _WinAPI_GetSystemTimes() ; https://www.autoitscript.com/forum/topic/187673-which-way-to-cpu-usage-specific-process/?do=findComment&comment=1347826
	If Not IsArray($Time1) Or Not IsArray($Time2) Then Return -1 ;   This may feel different from Task Manager but is not.
	$Time1 = $Time1[1] + $Time1[2] ;                                 Is just in a different resolution** and sample time.
	$Time2 = $Time2[1] + $Time2[2]
	$CPU = Round(($Time1 - $Prev1) / ($Time2 - $Prev2) * 100, 2) ;   **The resolution is in 0.13 steps instead of 0.01 for what I've seen on my PC but can be very different in yours.
	$Prev1 = $Time1 ;                                                  Nevertheless is acurate to the given resolution.
	$Prev2 = $Time2
	If $iLabel Then GUICtrlSetData($iLabel, "CPU: " & StringFormat("%2.2f", $CPU))
	Return $CPU
EndFunc   ;==>__GetProcUsage
