#AutoIt3Wrapper_AU3Check_Parameters=-q -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6 -w 7


#include "GuiChildTabUDF.au3"


Global $__iFlashWindowEx = 0 ; ..see _WM_SETCURSOR()

tabGUI_OPTs("RandomColor", 1) ; ..to add coloring to the GUIs, for debug. ( Default is 0 )
tabGUI_OPTs("SetCtrlDbgCreateWidth", 1) ; tells the UDF to leave some space for the debug buttons ( see tabGUI_CtrlDbgCreate() ). ( Default is 0 )

tabGUI_Example()
Func tabGUI_Example()


	; tabGUI_Create() has the same parameters as GUICreate()
	; ..just skip the styles, as those are handled by the function.
	tabGUI_Create("Parent/Children Example") ; the first GUI will have to be the parent

	tabGUI_CtrlDbgCreate("Show GUI array") ;    All these are
	tabGUI_CtrlDbgCreate("Show OPT array") ;    for debug and
	tabGUI_CtrlDbgCreate("Swap GUIs/LABELs") ;  are not needed
	tabGUI_CtrlDbgCreate("Can Drag child") ;    to use the UDF
	tabGUI_CtrlDbgCreate("Self CPU usage") ; These are called after a GUI is present.

	; search for "SetResizing:" to understand the TITLE modification ( used for tabGUI_DockStr2Int() )
	tabGUI_Create("SetResizing:LBWH;1", 400, 400, 20, 20) ; all other GUI will be child
	addSomeControls()

	tabGUI_Create("2", 400, 400, 60, 60)
	addSomeControls()

	; multiple child in child example
	; ..skip the width and heigth, to have the function calculate the values.
	tabGUI_Create("3", Default, Default, 200, 230)
	tabGUI_Create("4", Default, Default, 20, 20, Default, Default, $__a_tabGUI[@extended][$eGui_HWindowSelf])
	tabGUI_Create("5", Default, Default, 20, 20, Default, Default, $__a_tabGUI[@extended][$eGui_HWindowSelf])
	Local $hGUI = tabGUI_Create("6", Default, Default, 20, 20, Default, Default, $__a_tabGUI[@extended][$eGui_HWindowSelf])
	; ..the function returns the windows handle, just like GUICreate() would.
	ConsoleWrite('$hGUI = ' & $hGUI & ' - @extended: ' & @extended & ' ( @extended returns the GUI index in the array )' & @CRLF)
	addSomeControls()

	GUISetState(@SW_SHOW, $__a_tabGUI[1][$eGui_HWindowSelf]) ; Time to show the parent GUI
	GUISwitch($__a_tabGUI[1][$eGui_HWindowSelf]) ;             and get focus.

	GUIRegisterMsg($WM_SETCURSOR, "_WM_SETCURSOR") ; for _WinAPI_FlashWindowEx()

	While 1
		Sleep(1000000) ; ..no need to sleep() a minimum in this loop, as is just there to not close the script in this example.
	WEnd
EndFunc   ;==>tabGUI_Example

Func addSomeControls() ; ..some controls to add to the example
	GUICtrlCreateButton("bttn 1", 10, 10, 55, 25)
	GUICtrlSetOnEvent(-1, "addSomeEvents")
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	GUICtrlCreateButton("bttn 2", 10, 35, 55, 25)
	GUICtrlSetOnEvent(-1, "addSomeEvents")
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKWIDTH + $GUI_DOCKHEIGHT)
	GUICtrlCreateTab(10, 70, 380, 320)
	GUICtrlSetOnEvent(-1, "addSomeEvents")
	GUICtrlSetResizing(-1, $GUI_DOCKRIGHT + $GUI_DOCKTOP + $GUI_DOCKLEFT + $GUI_DOCKBOTTOM)
	GUICtrlCreateTabItem("TabSheet1")
	GUICtrlCreateTabItem("TabSheet2")
	GUICtrlCreateTabItem("")
EndFunc   ;==>addSomeControls

Func addSomeEvents()
;~ 	$__iFlashWindowEx = TimerInit()
	MsgBox(0, "your ""OnEvent""", "@GUI_CtrlId = " & @GUI_CtrlId, 1, $__a_tabGUI[1][$eGui_HWindowSelf])
;~ 	$__iFlashWindowEx = 0
EndFunc   ;==>addSomeEvents

Func _WM_SETCURSOR($hWnd, $iMsg, $wParam, $lParam)
	#forceref $hWnd, $iMsg, $wParam

	;		FYI: this is meant to flash the Parent GUI of a MsgBox(),
	;                   so the MsgBox() needs a Parent GUI declaration.

	;		If the 0xFFFE guess don't work, or just wanna save CPU cycles, then you'll need a trigger.
	;       Maybe something like this below.
;~ 	If $__iFlashWindowEx = 0 Then Return $GUI_RUNDEFMSG
;~ 	If TimerDiff($__iFlashWindowEx) < 100 Then Return $GUI_RUNDEFMSG

	Local Static $hTimerTooSoon = TimerInit(), $hTimerWaitAMoment = TimerInit()
	If _WinAPI_LoWord($lParam) <> 0xFFFE Then
		$hTimerWaitAMoment = TimerInit()
		Return $GUI_RUNDEFMSG
	EndIf
	If TimerDiff($hTimerWaitAMoment) < 200 Then Return $GUI_RUNDEFMSG


	If TimerDiff($hTimerTooSoon) < 500 Then Return $GUI_RUNDEFMSG
	Local $mouse = _WinAPI_HiWord($lParam) ; https://docs.microsoft.com/en-us/windows/win32/menurc/wm-setcursor

	; https://docs.microsoft.com/en-us/windows/win32/inputdev/wm-mousemove
	Local Const $MK_LBUTTON = 0x0001
	Local Const $MK_RBUTTON = 0x0002
	Local Const $MK_MBUTTON = 0x0010
	Local Const $MK_XBUTTON1 = 0x0020
	Local Const $MK_XBUTTON2 = 0x0040
;~ 	If BitAND($mouse, $MK_LBUTTON) Then ConsoleWrite('- clicked MK_LBUTTON' & @CRLF)
;~ 	If BitAND($mouse, $MK_RBUTTON) Then ConsoleWrite('- clicked MK_RBUTTON' & @CRLF)
;~ 	If BitAND($mouse, $MK_MBUTTON) Then ConsoleWrite('- clicked MK_MBUTTON' & @CRLF)
;~ 	If BitAND($mouse, $MK_XBUTTON1) Then ConsoleWrite('- clicked MK_XBUTTON1' & @CRLF)
;~ 	If BitAND($mouse, $MK_XBUTTON2) Then ConsoleWrite('- clicked MK_XBUTTON2' & @CRLF)

	If BitAND($mouse, $MK_LBUTTON) Or BitAND($mouse, $MK_RBUTTON) Or _
			BitAND($mouse, $MK_MBUTTON) Or BitAND($mouse, $MK_XBUTTON1) Or _
			BitAND($mouse, $MK_XBUTTON2) Then
		$hTimerTooSoon = TimerInit()
		_WinAPI_MessageBeep(4) ; mimic what windows does by default when
		_WinAPI_FlashWindowEx($hWnd, 3, 6, 50) ; clicking the title.

		_WinAPI_FlashWindowEx(WinGetHandle("[CLASS:#32770;]"), 3, 6, 50)
		; ..this works on the MsgBox() because is the "on top" in the Z order
		;							as the code just created it ( and it *is* on top ).

	EndIf

	Return $GUI_RUNDEFMSG
EndFunc   ;==>_WM_SETCURSOR

