#include-once
#AutoIt3Wrapper_Run_AU3Check=Y
#AutoIt3Wrapper_Au3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6 -w 7
#Tidy_Parameters=/sort_funcs /reel
; #AutoIt3Wrapper_Run_Debug_Mode=Y
#include <Crypt.au3>
#include <FileConstants.au3>

#Region GDPR.au3 - UDF Header
; #INDEX# =======================================================================================================================
; Title .........: GDPR.au3 UDF - a GDRP helper set of function
; AutoIt Version : 3.3.10.2++
; Language ......: English
; Description ...: this UDF was created for give any kind of support for GDPR solutions in AutoIt
; Author(s) .....: mLipok
; Modified ......:
; Remarks .......: !!! this UDF is only an example of how solve some sort of problems related to GDPR, you could not take/raise any law issues on the GDPR.au3 UDF developer
; URL ...........:
; ===============================================================================================================================

# !!! WARNING !!!
#CS
	BECAUSE THIS PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THIS PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.
	EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS'' WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
	THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
	IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
#CE

#cs UDF ChangeLog
   	2020/09/29		v1.0
	* First public release - mLipok



#ce UDF ChangeLog

#EndRegion GDPR.au3 - UDF Header

#Region GDPR.au3 - Declarations
Global Const $GDPR_CRYPT_GUID = '' ; @TODO make this as a USER FUNCTION as I do not want to Have possibility to know EndUser GUID >> _WinAPI_CreateGUID()
Global Const $GDPR_CRYPT_PREFIX = '[* ' & $GDPR_CRYPT_GUID & ' '
Global Const $GDPR_CRYPT_SUFIX = ' *]'
Global Const $GDPR_CRYPT_REGEXPTEST = '(.?)' & '[* ' & $GDPR_CRYPT_GUID & ' .*?' & $GDPR_CRYPT_SUFIX
Global Enum _
		$GDPR_ERR_SUCCESS, _
		$GDPR_ERR_CRYPTER_FUNCTION_IS_NOT_SET, _
		$GDPR_ERR_INVALID_DATA, _
		$GDPR_ERR_IS_NOT_BINARY, _
		$GDPR_ERR_IS_NOT_STRING, _
		$GDPR_ERR_FILE_EXIST, _
		$GDPR_ERR_FILE_NOT_EXIST, _
		$GDPR_ERR_FILE_READ, _
		$GDPR_ERR_FILE_WRITE, _
		$GDPR_ERR_NOT_ENCRYPTED_DATA, _
		$GDPR_ERR_COUNTER

Global Enum _
		$GDPR_EXT_DEFAULT, _
		$GDPR_EXT_PARAM1, _
		$GDPR_EXT_PARAM2, _
		$GDPR_EXT_COUNTER

Global Enum _
		$GDPR_RET_FAILURE, _
		$GDPR_RET_SUCCESS, _
		$GDPR_RET_COUNTER

#EndRegion GDPR.au3 - Declarations

#Region GDPR.au3 - Functions

Func __GDPR_Crypter(ByRef $dBinaryData, $bDataAlreadyEncrypted)
	#TODO support for checking if $dBinaryData are properly encrypted $GDPR_ERR_NOT_ENCRYPTED_DATA

	If Not IsBinary($dBinaryData) Then _
			Return SetError($GDPR_ERR_IS_NOT_BINARY, $GDPR_EXT_PARAM1, $GDPR_RET_FAILURE)
	If Not IsBool($bDataAlreadyEncrypted) Then _
			Return SetError($GDPR_ERR_INVALID_DATA, $GDPR_EXT_PARAM2, $GDPR_RET_FAILURE)

	Local $fnCrypter_Function = _GDPR_Crypter_Wrapper()
	If @error Or $fnCrypter_Function = Null Then _
			Return SetError($GDPR_ERR_CRYPTER_FUNCTION_IS_NOT_SET, $GDPR_EXT_DEFAULT, $GDPR_RET_FAILURE)

	Local $vReturnValue = $fnCrypter_Function($dBinaryData, $bDataAlreadyEncrypted)
	Return SetError(@error, @extended, $vReturnValue)
EndFunc   ;==>__GDPR_Crypter

; #FUNCTION# ====================================================================================================================
; Name ..........: _GDPR_Anonymize_String
; Description ...:
; Syntax ........: _GDPR_Anonymize_String(Byref $sString[, $iError = @error[, $iExtended = @extended]])
; Parameters ....: $sString             - [in/out] a string value.
;                  $iError              - [optional] an integer value. Default is @error.
;                  $iExtended           - [optional] an integer value. Default is @extended.
; Return values .: None
; Author ........: mLipok
; Modified ......:
; Remarks .......: !!! this function is only an example of how to anonymize strings, you could not take/raise any law issues on the GDPR.au3 UDF developer
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _GDPR_Anonymize_String(ByRef $sString, $iError = @error, $iExtended = @extended)
	Return SetError($iError, $iExtended, StringRegExpReplace($sString, '(?i)(.)(.{1,2})', '*$1*'))
EndFunc   ;==>_GDPR_Anonymize_String

Func _GDPR_Crypt_Binary(ByRef $dBinaryData)
	If Not IsBinary($dBinaryData) Then _
			Return SetError($GDPR_ERR_IS_NOT_BINARY, $GDPR_EXT_PARAM1, $GDPR_RET_FAILURE)

	Local $dResult = __GDPR_Crypter($dBinaryData, False)
	Return SetError(@error, @extended, $dResult)
EndFunc   ;==>_GDPR_Crypt_Binary

Func _GDPR_Crypt_File($sFileFullPath, $sFileFullPath_Encrypted, $FILE_ENCODING = $FO_UTF8_NOBOM)
	If Not FileExists($sFileFullPath) Then _
			Return SetError($GDPR_ERR_FILE_NOT_EXIST, $GDPR_EXT_PARAM1, $GDPR_RET_FAILURE)

	If FileExists($sFileFullPath_Encrypted) Then _
			Return SetError($GDPR_ERR_FILE_EXIST, $GDPR_EXT_PARAM2, $GDPR_RET_FAILURE)

	Local $hFile = FileOpen($sFileFullPath, $FO_READ + $FILE_ENCODING + $FO_BINARY)
	If @error then Return SetError($GDPR_ERR_FILE_READ, $GDPR_EXT_PARAM1, $GDPR_RET_FAILURE)

	Local $dFileContent = FileRead($hFile)
	FileClose($hFile)

	Local $dResult = _GDPR_Crypt_Binary($dFileContent)
	If @error Then Return SetError(@error, @extended, $dResult)

	$hFile = FileOpen($sFileFullPath_Encrypted, $FO_OVERWRITE + $FILE_ENCODING + $FO_BINARY)
	If @error then Return SetError($GDPR_ERR_FILE_WRITE, $GDPR_EXT_PARAM2, $GDPR_RET_FAILURE)
	FileWrite($hFile, $dResult)
	FileClose($hFile)
EndFunc   ;==>_GDPR_Crypt_File

Func _GDPR_Crypt_String(ByRef $sString)
	If Not IsString($sString) Then _
			Return SetError($GDPR_ERR_IS_NOT_STRING, $GDPR_EXT_PARAM1, $GDPR_RET_FAILURE)

	Local $dBinaryData = StringToBinary($sString, $SB_UTF8)
	Local $dResult = __GDPR_Crypter($dBinaryData, False)
	Return SetError(@error, @extended, $dResult)
EndFunc   ;==>_GDPR_Crypt_String

Func _GDPR_Crypter_Wrapper($fnCrypter_Function = Default)
	Local Static $fnCrypter_Static = Null

	If IsFunc($fnCrypter_Function) Then
		$fnCrypter_Static = $fnCrypter_Function
	ElseIf Not @NumParams Then
		If Not IsFunc($fnCrypter_Static) Then _
				Return SetError($GDPR_ERR_CRYPTER_FUNCTION_IS_NOT_SET, $GDPR_EXT_DEFAULT, $GDPR_RET_FAILURE)

		Return $fnCrypter_Static
	EndIf

	Return SetError($GDPR_ERR_INVALID_DATA, $GDPR_EXT_PARAM1, $GDPR_RET_FAILURE)

EndFunc   ;==>_GDPR_Crypter_Wrapper

Func _GDPR_DeCrypt_AsString($dBinaryData)
	If Not IsBinary($dBinaryData) Then _
			Return SetError($GDPR_ERR_IS_NOT_BINARY, $GDPR_EXT_PARAM1, $GDPR_RET_FAILURE)

	Local $vReturnValue = __GDPR_Crypter($dBinaryData, True)
	Return SetError(@error, @extended, BinaryToString($vReturnValue, $SB_UTF8))
EndFunc   ;==>_GDPR_DeCrypt_AsString

Func _GDPR_DeCrypt_Binary(ByRef $dBinaryData)
	If Not IsBinary($dBinaryData) Then _
			Return SetError($GDPR_ERR_IS_NOT_BINARY, $GDPR_EXT_PARAM1, $GDPR_RET_FAILURE)

	Local $vReturnValue = __GDPR_Crypter($dBinaryData, True)
	Return SetError(@error, @extended, $vReturnValue)
EndFunc   ;==>_GDPR_DeCrypt_Binary

Func _GDPR_DeCrypt_File($sFileFullPath_Encrypted, $sFileFullPath_Decrypted, $FILE_ENCODING = $FO_UTF8_NOBOM)
	If Not FileExists($sFileFullPath_Encrypted) Then _
			Return SetError($GDPR_ERR_FILE_NOT_EXIST, $GDPR_EXT_PARAM1, $GDPR_RET_FAILURE)

	If FileExists($sFileFullPath_Decrypted) Then _
			Return SetError($GDPR_ERR_FILE_EXIST, $GDPR_EXT_PARAM2, $GDPR_RET_FAILURE)

	Local $hFile = FileOpen($sFileFullPath_Encrypted, $FO_READ + $FILE_ENCODING + $FO_BINARY)
	If @error then Return SetError($GDPR_ERR_FILE_READ, $GDPR_EXT_PARAM1, $GDPR_RET_FAILURE)
	Local $dFileContent = FileRead($hFile)
	FileClose($hFile)

	Local $dResult = _GDPR_DeCrypt_Binary($dFileContent)
	If @error Then Return SetError(@error, @extended, $dResult)

	$hFile = FileOpen($sFileFullPath_Decrypted, $FO_OVERWRITE + $FILE_ENCODING + $FO_BINARY)
	If @error then Return SetError($GDPR_ERR_FILE_WRITE, $GDPR_EXT_PARAM2, $GDPR_RET_FAILURE)
	FileWrite($hFile, $dResult)
	FileClose($hFile)
EndFunc   ;==>_GDPR_DeCrypt_File
#EndRegion GDPR.au3 - Functions
