#include "GDPR.au3"

#AutoIt3Wrapper_Run_AU3Check=Y
#AutoIt3Wrapper_Au3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6 -w 7
#Tidy_Parameters=/sort_funcs /reel
; #AutoIt3Wrapper_Run_Debug_Mode=Y

_Example()

Func _Example()
	_GDPR_Crypter_Wrapper(_Example_Crypter)
	Local $sText = 'AutoIt v3 is a freeware BASIC-like scripting language designed for automating the Windows GUI and general scripting.'
	MsgBox(0, @ScriptLineNumber, _GDPR_Anonymize_String($sText))
	Local $dCrypted = _GDPR_Crypt_String($sText)
	MsgBox(0, @ScriptLineNumber, $dCrypted & @CRLF & @error & @CRLF & @extended)
	Local $sDecrypted = _GDPR_DeCrypt_AsString($dCrypted)
	MsgBox(0, @ScriptLineNumber, $sDecrypted & @CRLF & @error & @CRLF & @extended)

	_GDPR_Crypt_File(@ScriptFullPath, @ScriptFullPath & '.CRYPTED')
	If @error Then ConsoleWrite('! ---> @error=' & @error & '  @extended=' & @extended & ' : _GDPR_Crypt_File' & @CRLF)
	_GDPR_DeCrypt_File(@ScriptFullPath & '.CRYPTED', @ScriptFullPath & '.DECRYPTED.au3')
	If @error Then ConsoleWrite('! ---> @error=' & @error & '  @extended=' & @extended & ' : _GDPR_DeCrypt_File' & @CRLF)

EndFunc   ;==>_Example

Func _Example_Crypter($dBinaryData, $bDataAlreadyEncrypted)
	_Crypt_Startup()     ; Start the Crypt library.
	Local $dResult
	If $bDataAlreadyEncrypted Then
		$dResult = _Crypt_DecryptData($dBinaryData, 'securepassword', $CALG_3DES) ; Decrypt the data using the generic password string. The return value is a binary string.
	Else
		$dResult = _Crypt_EncryptData($dBinaryData, 'securepassword', $CALG_3DES) ; Encrypt the text with the new cryptographic key.
	EndIf
	_Crypt_Shutdown()     ; Shutdown the Crypt library.
	Return $dResult
EndFunc   ;==>_Example_Crypter
