#AutoIt3Wrapper_UseX64=N
#include "7Zip.au3"
_Example_1()
_Example_2()
_Example_3()

Func _Example_1()
	Local $ArcFile = FileSaveDialog("#1 Create a new archive", "", "Archive Files (*.7z;*.zip;*.gzip;*.bzip2;*.tar)")
	If @error Then Exit

	Local $FileName = FileSelectFolder("#1 Select a folder", "")
	If @error Then Exit

	Local $retResult = _7ZipAdd(0, $ArcFile, $FileName)
	If @error Then
		MsgBox(64, "#1 _7ZipAdd", "Error occurred")
	Else
		MsgBox(64, "#1 _7ZipAdd", "Archive created successfully" & @LF & _
				$retResult)
	EndIf
EndFunc   ;==>_Example_1

Func _Example_2()
	Local $ArcFile = FileSaveDialog("#2 Create a new archive", "", "Archive Files (*.7z;*.zip;*.gzip;*.bzip2;*.tar)")
	If @error Then Exit

	Local $FileName = FileOpenDialog("#2 Select a file", "", "All (*.*)")
	If @error Then Exit

	Local $retResult = _7ZipAdd(0, $ArcFile, $FileName)
	If @error Then
		MsgBox(64, "#2 _7ZipAdd", "Error occurred")
	Else
		MsgBox(64, "#2 _7ZipAdd", "Archive created successfully" & @LF & _
				$retResult)
	EndIf

EndFunc   ;==>_Example_2

Func _Example_3()
	Local $ArcFile = FileSaveDialog("#3 Create a new archive", "", "Archive Files (*.7z;*.zip;*.gzip;*.bzip2;*.tar)")
	If @error Then Exit

	Local $FileName = FileSelectFolder("#3 Select a folder", "")
	If @error Then Exit

	Local $sInclude = "c:\Program Files\AutoIt3\Examples\GUI\*.*"
	Local $sExclude = "c:\Program Files\AutoIt3\Examples\GUI\*.au3"

	Local $retResult = _7ZipAdd(0, $ArcFile, $FileName, 0, 5, 1, $sInclude, $sExclude)
	If @error Then
		MsgBox(64, "#3 _7ZipAdd", "Error occurred")
	Else
		MsgBox(64, "#3 _7ZipAdd", "Archive created successfully" & @LF & _
				$retResult)
	EndIf

EndFunc   ;==>_Example_3
