#include <MsgBoxConstants.au3>
#include "7Zip.au3"

_7Zip_Archive_Size_Example()

Func _7Zip_Archive_Size_Example()
	Local $ArcFile = FileOpenDialog("Select archive", "", "Archive Files (*.7z;*.zip;*.gzip;*.bzip2;*.tar)")
	If @error Then Exit

	_7ZipStartup()
	Local $NbFiles = _7ZipGetFileCount($ArcFile)
	MsgBox($MB_ICONINFORMATION, "Size", "Total size of " & $NbFiles & " files in archive = " & _7ZipFilesSize($ArcFile))
	_7ZipShutdown()
EndFunc   ;==>_7Zip_Archive_Size_Example

Func _7ZipFilesSize($ArcFile)
	Local $hArc = _7ZipOpenArchive(0, $ArcFile)
	If $hArc = 0 Then
		SetError(1)
		Return 0
	EndIf
	Local $tINDIVIDUALINFO = _7ZipFindFirst($hArc, "*.*")
	If $tINDIVIDUALINFO = -1 Then Exit
	Local $Size = _7ZipGetArcOriginalSize($hArc)

	While 1
		$tINDIVIDUALINFO = _7ZipFindNext($hArc, $tINDIVIDUALINFO)
		If $tINDIVIDUALINFO = 0 Then ExitLoop

		$Size += DllStructGetData($tINDIVIDUALINFO, "dwOriginalSize")
	WEnd

	_7ZipCloseArchive($hArc)

	Return $Size
EndFunc   ;==>_7ZipFilesSize
