#include <AutoItConstants.au3>
#include <GUIConstantsEx.au3>
#include <WinAPIShellEx.au3>

Global Const $VERSION = "0.0.0.3" ; ..don't think there's gonna be other versions but knowing me, who's to know.
; v0.0.0.2 needed more, like, load previously/current build of CHM "w/&AutoIt3Help" vs. "w/&HH ( windows default )"
; v0.0.0.1 had problems with spaces in the path.

Global $g_AutoIt3path = StringLeft(@AutoItExe, StringInStr(@AutoItExe, "\", 0, -1) - 1)
If @Compiled Then Exit 4 ; not coded with compilation in mind
If Not FileGetSize($g_AutoIt3path & "\AutoIt3Help.exe") Then Exit 6 ; well, this shouln't happen
If StringInStr($CmdLineRaw, "/ErrorStdOut") Then Exit ShellExecute(@AutoItExe, '"' & @ScriptFullPath & '"') ; free up SciTE
If WinExists(StringTrimRight(@ScriptName, 4) & "_STUB") Then Exit 5
AutoItWinSetTitle(StringTrimRight(@ScriptName, 4) & "_STUB")

; If you rather not run the GUI, just run the function.
;Exit CompileAndRunCHM()

main() ; https://www.autoitscript.com/forum/index.php?showtopic=211676
Func main()
	Local $iGuiWidth = 460
	Local $hGUI = GUICreate(StringTrimRight(@ScriptName, 4), $iGuiWidth, 29)
	_WinAPI_SetCurrentProcessExplicitAppUserModelID(StringTrimRight(@ScriptName, 4) & "-ModelID-" & @AutoItPID) ; keep away from other scripts
	WinSetOnTop($hGUI, "", 1) ; keep this window on the side and run at will
	GUISetIcon($g_AutoIt3path & "\Icons\MyAutoIt3_Green.ico")
	TraySetIcon($g_AutoIt3path & "\Icons\MyAutoIt3_Green.ico")
	Local $iLeft = 2
	Local $idCompileAndLoad = GUICtrlCreateButton("&Compile 'n' load", $iLeft, 2, AddBttnLeft($iLeft, 100), 25)
	Local $idLoadPreviousWAU = GUICtrlCreateButton("Load w/&AutoIt3Help", $iLeft, 2, AddBttnLeft($iLeft, 120), 25)
	Local $idLoadPreviousWHH = GUICtrlCreateButton("Load w/&HH", $iLeft, 2, AddBttnLeft($iLeft, 90), 25)
	Local $idViewLog = GUICtrlCreateButton("Compile &status: none yet", $iLeft, 2, AddBttnLeft($iLeft, 140), 25)

;~ 	ConsoleWrite('$iGuiWidth = ' & $iLeft & @CRLF) ; for use as $iGuiWidth later

	If Not FileGetSize($g_AutoIt3path & '\Testing123.chm') Then
		GUICtrlSetState($idLoadPreviousWAU, $GUI_DISABLE)
		GUICtrlSetState($idLoadPreviousWHH, $GUI_DISABLE)
	EndIf

	GUICtrlSetState($idViewLog, $GUI_DISABLE)
	GUISetState(@SW_SHOW, $hGUI)
	GUICtrlSetState($idCompileAndLoad, $GUI_FOCUS)

	Opt("GUICloseOnESC", 0)
	Local $cMinimizeDummy = GUICtrlCreateDummy()
	Local $aAccelKeys[1][2] = [["{ESC}", $cMinimizeDummy]]
	GUISetAccelerators($aAccelKeys)

	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				ExitLoop

			Case $idCompileAndLoad
				GUICtrlSetState($idCompileAndLoad, $GUI_DISABLE)
				GUICtrlSetState($idViewLog, $GUI_DISABLE)
				GUICtrlSetState($idLoadPreviousWAU, $GUI_DISABLE)
				GUICtrlSetState($idLoadPreviousWHH, $GUI_DISABLE)
				GUICtrlSetData($idCompileAndLoad, "..running..")
				GUICtrlSetData($idViewLog, "Compile status: ..will see..")
				If CompileAndRunCHM() Then
					If FileGetSize(@ScriptDir & "\hhp\Testing123.log") Then
						ShellExecute(@ScriptDir & "\hhp\Testing123.log")
					EndIf
					GUICtrlSetData($idViewLog, "Compile status: FAILED")
				Else
					GUICtrlSetData($idViewLog, "Compile status: OK")
				EndIf
				Sleep(500)
				GUICtrlSetData($idCompileAndLoad, "&Compile 'n' load")
				GUICtrlSetState($idCompileAndLoad, $GUI_ENABLE)
				GUICtrlSetState($idViewLog, $GUI_ENABLE)
				GUICtrlSetState($idLoadPreviousWAU, $GUI_ENABLE)
				GUICtrlSetState($idLoadPreviousWHH, $GUI_ENABLE)

			Case $idViewLog
				GUICtrlSetState($idViewLog, $GUI_DISABLE)
				ShellExecute(@ScriptDir & "\hhp\Testing123.log")
				Sleep(500)
				GUICtrlSetState($idViewLog, $GUI_ENABLE)

			Case $idLoadPreviousWAU
				GUICtrlSetState($idViewLog, $GUI_DISABLE)
				If FileGetSize($g_AutoIt3path & '\Testing123.chm') Then
					ShellExecute($g_AutoIt3path & "\AutoIt3Help.exe", '"" "' & $g_AutoIt3path & '\Testing123.chm"')
				EndIf
				Sleep(500)
				GUICtrlSetState($idViewLog, $GUI_ENABLE)

			Case $idLoadPreviousWHH
				GUICtrlSetState($idViewLog, $GUI_DISABLE)
				If FileGetSize($g_AutoIt3path & '\Testing123.chm') Then
					ShellExecute($g_AutoIt3path & '\Testing123.chm')
				EndIf
				Sleep(500)
				GUICtrlSetState($idViewLog, $GUI_ENABLE)

			Case $cMinimizeDummy ; https://www.autoitscript.com/forum/topic/184084-disable-esk-key-close-window/?do=findComment&comment=1322740
				WinSetState($hGUI, "", @SW_MINIMIZE)

		EndSwitch
	WEnd

	GUIDelete($hGUI)
EndFunc   ;==>main

Func AddBttnLeft(ByRef $iLeft, $iWidth, $iSeparate = 2)
	$iLeft += $iWidth + $iSeparate
	Return $iWidth
EndFunc   ;==>AddBttnLeft


Func CompileAndRunCHM()
	If FileExists(@ScriptDir & "\hhp\Testing123.log") Then FileDelete(@ScriptDir & "\hhp\Testing123.log")
	Local $sRun = @ComSpec & ' /c "' & @ScriptDir & '\hhc\hhc.exe" hhp\Testing123.hhp'
;~ 	ConsoleWrite('>' & $sRun & '<' & @CRLF)
	Local $iPID = Run($sRun, @ScriptDir, @SW_HIDE, $STDOUT_CHILD)
	ProcessWaitClose($iPID) ; Wait until the process has closed using the PID returned by Run.
	Local $sOutput = StdoutRead($iPID) ; Read the Stdout stream of the PID returned by Run.
	ConsoleWrite($sOutput & @CRLF)
	If StringInStr($sOutput, "is not recognized as an internal or") Then Return 9
	If StringInStr($sOutput, ": Error:") Then Return 10
	If StringInStr($sOutput, "The system cannot find") Then Return 11
	If StringInStr($sOutput, "Unable to open") Then Return 12
	If StringInStr($sOutput, "<filename>") Then Return 13
	If $sOutput = "" Then Return 14
	If $sOutput = "am bored" Then Return 15 ; got to have some fun  =D
	WinCloseEmAll("[TITLE:Testing123 Help File;CLASS:HH Parent;]")
	Sleep(200)
	FileDelete($g_AutoIt3path & "\Testing123.chm")
	FileMove(@ScriptDir & "\hhp\Testing123.chm", $g_AutoIt3path & "\Testing123.chm", 1)
	ShellExecute($g_AutoIt3path & "\AutoIt3Help.exe", '"Function MsgBox" "' & $g_AutoIt3path & '\Testing123.chm"')
EndFunc   ;==>CompileAndRunCHM

Func WinCloseEmAll($sTitle)
	Local $iMaxCount = 1
	While WinExists($sTitle)
		WinClose($sTitle)
		$iMaxCount += 1
		If $iMaxCount > 5 Then ExitLoop ; Don't make endless loops
	WEnd
EndFunc   ;==>WinCloseEmAll
