; ------------------------------------------------------------------
; The Binary Code UDF (2011.6.2)
; Purpose: Run a machine code in "Binary" format, like DllCall
; Author:  Ward
; ------------------------------------------------------------------

#cs
; Functions List:
;  BinaryOpen		($MaxSize = 65536)
;  BinaryClose		(ByRef $BinaryBuffer)
;  BinaryGetPtr		(ByRef $BinaryBuffer)
;  BinarySetData	(ByRef $BinaryBuffer, $Binary)
;  BinaryCall		($BinaryBuffer, $RetType, $FuncName, $Type1, $Param1, ...)
#ce

#Include "MemoryDll.au3"

Func _IsBinaryBuffer(ByRef $BinaryBuffer)
	If UBound($BinaryBuffer) = 3 And IsDllStruct($BinaryBuffer[2]) Then Return True
	Return False
EndFunc

Func BinaryOpen($MaxSize = 65536)
	$MaxSize = Ceiling($MaxSize / 16384) * 16384
	Local $BinaryBufferPtr = _MemVirtualAlloc(0, $MaxSize, $MEM_COMMIT, $PAGE_EXECUTE_READWRITE)
	If $BinaryBufferPtr Then
		Local $BinaryBuffer = DllStructCreate("byte[" & $MaxSize & "]", $BinaryBufferPtr)
		Local $BinaryBufferArray[3] = [$MaxSize, $BinaryBufferPtr, $BinaryBuffer]
		Return $BinaryBufferArray
	Else
		Return SetError(1, 0, 0)
	EndIf
EndFunc

Func BinaryClose(ByRef $BinaryBuffer)
	If _IsBinaryBuffer($BinaryBuffer) Then
		_MemVirtualFree($BinaryBuffer[1], 0, $MEM_RELEASE)
		$BinaryBuffer = 0
	EndIf
EndFunc

Func BinaryGetPtr(ByRef $BinaryBuffer)
	If _IsBinaryBuffer($BinaryBuffer) Then Return $BinaryBuffer[1]
	Return 0
EndFunc

Func BinarySetData(ByRef $BinaryBuffer, $Binary)
	If _IsBinaryBuffer($BinaryBuffer) Then
		$Binary = Binary($Binary)
		If BinaryLen($Binary) < $BinaryBuffer[0] Then
			DllStructSetData($BinaryBuffer[2], 1, $Binary)
			Return True
		EndIf
	EndIf
	Return SetError(1, 0, False)
EndFunc

Func BinaryCall($BinaryBuffer, $RetType, $Type1 = "", $Param1 = 0, $Type2 = "", $Param2 = 0, $Type3 = "", $Param3 = 0, $Type4 = "", $Param4 = 0, $Type5 = "", $Param5 = 0, $Type6 = "", $Param6 = 0, $Type7 = "", $Param7 = 0, $Type8 = "", $Param8 = 0, $Type9 = "", $Param9 = 0, $Type10 = "", $Param10 = 0, $Type11 = "", $Param11 = 0, $Type12 = "", $Param12 = 0, $Type13 = "", $Param13 = 0, $Type14 = "", $Param14 = 0, $Type15 = "", $Param15 = 0, $Type16 = "", $Param16 = 0, $Type17 = "", $Param17 = 0, $Type18 = "", $Param18 = 0, $Type19 = "", $Param19 = 0, $Type20 = "", $Param20 = 0)
	Local $Ret, $OpenFlag = False
	Local Const $MaxParams = 20
	If (@NumParams < 2) Or (@NumParams > $MaxParams * 2 + 2) Or (Mod(@NumParams, 2) = 1) Then Return SetError(4, 0, 0)

	If Not _IsBinaryBuffer($BinaryBuffer) Then
		If IsBinary($BinaryBuffer) Or (IsString($BinaryBuffer) And StringLeft($BinaryBuffer, 2) = "0x") Then
			Local $Binary = Binary($BinaryBuffer)
			$BinaryBuffer = BinaryOpen(BinaryLen($Binary))
			If @Error Then Return SetError(1, 0, 0)
			BinarySetData($BinaryBuffer, $Binary)
			$OpenFlag = True
		Else
			Return SetError(1, 0, 0)
		EndIf
	EndIf

	If Not IsDllStruct($_MFHookBak) Then MemoryFuncInit()
	Poke("ptr", $_MFHookPtr + 1 + @AutoItX64, $BinaryBuffer[1])

	Switch @NumParams
	Case 2
		$Ret = DllCall($_KERNEL32DLL, $RetType, $_MFHookApi)
	Case 4
		$Ret = DllCall($_KERNEL32DLL, $RetType, $_MFHookApi, $Type1, $Param1)
	Case 6
		$Ret = DllCall($_KERNEL32DLL, $RetType, $_MFHookApi, $Type1, $Param1, $Type2, $Param2)
	Case 8
		$Ret = DllCall($_KERNEL32DLL, $RetType, $_MFHookApi, $Type1, $Param1, $Type2, $Param2, $Type3, $Param3)
	Case 10
		$Ret = DllCall($_KERNEL32DLL, $RetType, $_MFHookApi, $Type1, $Param1, $Type2, $Param2, $Type3, $Param3, $Type4, $Param4)
	Case 12
		$Ret = DllCall($_KERNEL32DLL, $RetType, $_MFHookApi, $Type1, $Param1, $Type2, $Param2, $Type3, $Param3, $Type4, $Param4, $Type5, $Param5)
	Case Else
		Local $DllCallStr = 'DllCall($_KERNEL32DLL, $RetType, $_MFHookApi', $n = 1
		For $i = 4 To @NumParams Step 2
			$DllCallStr &= ', $Type' & $n & ', $Param' & $n
			$n += 1
		Next
		$DllCallStr &= ')'
		$Ret = Execute($DllCallStr)
	EndSwitch

	If $OpenFlag Then BinaryClose($BinaryBuffer)
	Return SetError(@Error, 0, $Ret)
EndFunc

