; ------------------------------------------------------------------
; The Embedded Flat Assembler 1.69 UDF CRC32 Example (2011.6.4)
; Purpose: Demonstrate the usage of embedded flat assembler
; Author:  Ward
; ------------------------------------------------------------------

#Include "FASM.au3"
Opt("MustDeclareVars", 1)

Dim $CRC32 = ASMCRC32("The quick brown fox jumps over the lazy dog")
MsgBox(0, 'CRC32 Result', Hex($CRC32))

Func ASMCRC32($Data, $CRC32 = -1)
	Local $Fasm = FasmInit()
	Local $Text = ""
	$Text &= "  use32        	            " & @LF
	$Text &= "  enter   400h,0	            " & @LF
	$Text &= "  push    ebx                 " & @LF
	$Text &= "  mov     edx,0EDB88320h      " & @LF
	$Text &= "  mov     ecx,100h            " & @LF
	$Text &= "L3:                           " & @LF
	$Text &= "  lea     eax,[ecx-1]         " & @LF
	$Text &= "  push    ecx                 " & @LF
	$Text &= "  push    8                   " & @LF
	$Text &= "  pop     ecx                 " & @LF
	$Text &= "L2:                           " & @LF
	$Text &= "  shr     eax,1               " & @LF
	$Text &= "  jnc     L1                  " & @LF
	$Text &= "  xor     eax,edx             " & @LF
	$Text &= "L1:                           " & @LF
	$Text &= "  loop    L2                  " & @LF
	$Text &= "  pop     ecx                 " & @LF
	$Text &= "  mov     [ebp+ecx*4-404h],eax" & @LF
	$Text &= "  loop    L3                  " & @LF
	$Text &= "  mov     ebx,[ebp+8]         " & @LF
	$Text &= "  mov     ecx,[ebp+0Ch]       " & @LF
	$Text &= "  mov     eax,[ebp+10h]       " & @LF
	$Text &= "  test    ebx,ebx             " & @LF
	$Text &= "  je      L4                  " & @LF
	$Text &= "  jecxz   L4                  " & @LF
	$Text &= "L5:                           " & @LF
	$Text &= "  mov     dl,[ebx]            " & @LF
	$Text &= "  xor     dl,al               " & @LF
	$Text &= "  movzx   edx,dl              " & @LF
	$Text &= "  shr     eax,8               " & @LF
	$Text &= "  xor     eax,[ebp+edx*4-400h]" & @LF
	$Text &= "  inc     ebx                 " & @LF
	$Text &= "  loop    L5                  " & @LF
	$Text &= "L4:                           " & @LF
	$Text &= "  not     eax                 " & @LF
	$Text &= "  pop     ebx                 " & @LF
	$Text &= "  leave                       " & @LF
	$Text &= "  ret                         "
	FasmSetSource($Fasm, $Text)

	Local $Input = DllStructCreate("byte[" & BinaryLen($Data) & "]")
	DllStructSetData($Input, 1, $Data)

	Local $Ret = MemoryFuncCall("uint:cdecl", FasmGetFuncPtr($Fasm), "ptr", DllStructGetPtr($Input), "uint", BinaryLen($Data), "int", $CRC32)

	FasmExit($Fasm)
	Return $Ret[0]
EndFunc
