; ------------------------------------------------------------------
; The Embedded Flat Assembler 1.69 UDF Demo (2011.6.4)
; Purpose: Demonstrate the usage of embedded flat assembler
; Author:  Ward
; ------------------------------------------------------------------

#Include "FASM.au3"
Opt("MustDeclareVars", 1)

; Initial a FASM object
Global $Fasm = FasmInit()

ConsoleWrite("AutoIt Embedded Flat Assembler (v" & FasmGetVersion() & ") Demo" & @CRLF)

Demo1()
Demo2()
Demo3()
Demo4()
Demo5()
Demo6()
Demo7()

; Release the FASM object
FasmExit($Fasm)

Exit

Func Demo1()
	; Demo 1: Using Parameters
	FasmReset($Fasm)
	FasmAdd($Fasm, "use32")
	FasmAdd($Fasm, "push ebp")
	FasmAdd($Fasm, "mov ebp, esp")
	FasmAdd($Fasm, "mov eax, [ebp + 08]")
	FasmAdd($Fasm, "add eax, [ebp + 0ch]")
	FasmAdd($Fasm, "pop ebp")
	FasmAdd($Fasm, "ret 8")

	ConsoleWrite(String(FasmGetBinary($Fasm)) & @CRLF)

	Local $Ret = MemoryFuncCall("int", FasmGetFuncPtr($Fasm), "int", 1, "int", 2)
	MsgBox(0, "Demo 1: Using Parameters", "1 + 2 = " & $Ret[0])
EndFunc

Func Demo2()
	; Demo 2: Read Time-Stamp Counter
	FasmReset($Fasm)
	FasmAdd($Fasm, "use32")
	FasmAdd($Fasm, "push ebp")
	FasmAdd($Fasm, "mov ebp, esp")
	FasmAdd($Fasm, "rdtsc")
	FasmAdd($Fasm, "mov ecx, [ebp + 08]")
	FasmAdd($Fasm, "mov [ecx], edx")
	FasmAdd($Fasm, "pop ebp")
	FasmAdd($Fasm, "ret 4")

	ConsoleWrite(String(FasmGetBinary($Fasm)) & @CRLF)

	Local $Ret = MemoryFuncCall("uint", FasmGetFuncPtr($Fasm), "uint*", 0)
	MsgBox(0, "Demo 2: Read Time-Stamp Counter", "RDTSC = " & Hex($Ret[1]) &  Hex($Ret[0], 8))
	Return Hex($Ret[1]) &  Hex($Ret[0], 8)
EndFunc

Func Demo3()
	; Demo 3: Using Label
	FasmReset($Fasm)
	FasmAdd($Fasm, "use32")
	FasmAdd($Fasm, "jmp forward")
	FasmAdd($Fasm, "nop")
	FasmAdd($Fasm, "forward:")
	FasmAdd($Fasm, "mov eax, 0")
	FasmAdd($Fasm, "mov ecx, 10")
	FasmAdd($Fasm, "label1:")
	FasmAdd($Fasm, "inc eax")
	FasmAdd($Fasm, "loop label1")
	FasmAdd($Fasm, "ret")

	ConsoleWrite(String(FasmGetBinary($Fasm)) & @CRLF)

	Local $Ret = MemoryFuncCall("int", FasmGetFuncPtr($Fasm))
	MsgBox(0, "Demo 3: Using Label", "loop label for " & $Ret[0] & " times")
EndFunc

Func Demo4()
	; Demo 4: Call AutoIt Func From Assembly
	Local $AutoItFunc = DllCallbackRegister("AutoItFunc", "int", "")
	FasmReset($Fasm)
	FasmAdd($Fasm, "use32")
	FasmAdd($Fasm, "org " & FasmGetBasePtr($Fasm))
	FasmAdd($Fasm, "call " & DllCallbackGetPtr($AutoItFunc))
	FasmAdd($Fasm, "shl eax, 1")
	FasmAdd($Fasm, "ret")

	ConsoleWrite(String(FasmGetBinary($Fasm)) & @CRLF)

	Local $Ret = MemoryFuncCall("int", FasmGetFuncPtr($Fasm))
	MsgBox(0, "Demo 4: AutoIt Function", "BitLeftShift the AutoItFunc return value: " & $Ret[0])
	DllCallbackFree($AutoItFunc)
EndFunc

Func AutoItFunc()
	MsgBox(0, "AutoItFunc", "Called by Inline Assembly")
	Return 123
EndFunc

Func Demo5()
	; Demo 5: Call AutoIt Func From Assembly And Pass Parameters
	Local $AutoItFunc = DllCallbackRegister("AutoItFunc2", "int", "str;uint;uint")
	FasmReset($Fasm)
	FasmAdd($Fasm, "use32")
	FasmAdd($Fasm, "org " & FasmGetBasePtr($Fasm))
	FasmAdd($Fasm, "rdtsc")
	FasmAdd($Fasm, "push eax")
	FasmAdd($Fasm, "push edx")
	FasmAdd($Fasm, "push string")
	FasmAdd($Fasm, "call " & DllCallbackGetPtr($AutoItFunc))
	FasmAdd($Fasm, "ret")
	FasmAdd($Fasm, "string: db 'RDTSC = %08X%08X', 0")

	ConsoleWrite(String(FasmGetBinary($Fasm)) & @CRLF)

	MemoryFuncCall("int", FasmGetFuncPtr($Fasm))
	DllCallbackFree($AutoItFunc)
EndFunc

Func AutoItFunc2($String, $Edx, $Eax)
	MsgBox(0, "AutoItFunc", StringFormat($String, $Edx, $Eax))
EndFunc

Func Demo6()
	; Demo 6: Read CPUID
	FasmReset($Fasm)
	FasmAdd($Fasm, "use32")
	FasmAdd($Fasm, "push ebp")
	FasmAdd($Fasm, "mov ebp, esp")
	FasmAdd($Fasm, "pushad")
	FasmAdd($Fasm, "xor eax, eax")
	FasmAdd($Fasm, "cpuid")
	FasmAdd($Fasm, "mov edi, [ebp + 08]")
	FasmAdd($Fasm, "mov [edi], ebx")
	FasmAdd($Fasm, "mov [edi + 4], edx")
	FasmAdd($Fasm, "mov [edi + 8], ecx")
	FasmAdd($Fasm, "mov al, 0")
	FasmAdd($Fasm, "mov [edi + 12], al")
	FasmAdd($Fasm, "popad")
	FasmAdd($Fasm, "pop ebp")
	FasmAdd($Fasm, "ret 4")

	ConsoleWrite(String(FasmGetBinary($Fasm)) & @CRLF)

	Local $Ret = MemoryFuncCall("uint", FasmGetFuncPtr($Fasm), "str", "")
	MsgBox(0, "Demo 6: CPUID", "CPUID = " & $Ret[1])
EndFunc

Func Demo7()
	; Demo 7: Error Handle
	FasmReset($Fasm)
	FasmAdd($Fasm, "use32")
	FasmAdd($Fasm, "jmp l2") ; a wrong label
	FasmAdd($Fasm, "l1:")
	FasmAdd($Fasm, "ret")

	FasmCompile($Fasm)
	If @Error Then
		Local $Error = FasmGetLastError()
		ConsoleWrite("Error Code: " & $Error[$FASMERRINDEX_CODE] & @CRLF)
		ConsoleWrite("Error Message: " & $Error[$FASMERRINDEX_MESSAGE] & @CRLF)
		ConsoleWrite("Error LineNumber: " & $Error[$FASMERRINDEX_LINENUMBER] & @CRLF)
		ConsoleWrite("Error Line: " & $Error[$FASMERRINDEX_LINE] & @CRLF)
	Else
		ConsoleWrite(String(FasmGetBinary($Fasm)) & @CRLF)
	EndIf
	MemoryFuncCall("int", FasmGetFuncPtr($Fasm))
EndFunc
