; ------------------------------------------------------------------
; The Embedded Flat Assembler 1.69 Object UDF (2011.6.4)
; Purpose: Provide the ability to write assembly language in AutoIt
; Author:  Ward
; Flat Assembler Copyright (C) 2004-2010 Tomasz Grysztar
; ------------------------------------------------------------------

#cs
; Functions List:
;  FasmObjectCreate($MaxStructSize = 65536, $PassesLimit = 100)
; Methods List:
;  Add			($Text)
;  Compile		()
;  GetBunary	()
;  GetFuncPtr	()
;  GetBasePtr	()
;  GetSource	()
;  GetVersion	()
;  SetSource	($Text)
;  Reset		()
; Propertys List:
;  State
;  Error
;  ErrorMessage
;  ErrorLine
;  ErrorLineNumber
#ce

#Include "FASM.au3"
#Include "AutoitObject.au3"

Func FasmObjectCreate($MaxStructSize = 65536, $PassesLimit = 100)
	_AutoItObject_StartUp()

	Local $Fasm = FasmInit($MaxStructSize, $PassesLimit)
	Local $FObject = _AutoItObject_Create()

	_AutoItObject_AddProperty($FObject, "ArrayName", $ELSCOPE_READONLY, "ptr:" & Number(DllStructGetPtr($Fasm[$_foSTRUCT])))
	Assign($FObject.ArrayName, $Fasm, 2)

	_AutoItObject_AddProperty($FObject, "State", $ELSCOPE_READONLY, 0)
	_AutoItObject_AddProperty($FObject, "Error", $ELSCOPE_READONLY, False)
	_AutoItObject_AddProperty($FObject, "ErrorMessage", $ELSCOPE_READONLY, "")
	_AutoItObject_AddProperty($FObject, "ErrorLineNumber", $ELSCOPE_READONLY, -1)
	_AutoItObject_AddProperty($FObject, "ErrorLine", $ELSCOPE_READONLY, "")

	_AutoItObject_AddMethod($FObject, "Add", "FasmObjectAdd")
	_AutoItObject_AddMethod($FObject, "Compile", "FasmObjectCompile")
	_AutoItObject_AddMethod($FObject, "GetBinary", "FasmObjectGetBinary")
	_AutoItObject_AddMethod($FObject, "GetFuncPtr", "FasmObjectGetFuncPtr")
	_AutoItObject_AddMethod($FObject, "GetBasePtr", "FasmObjectGetBasePtr")
	_AutoItObject_AddMethod($FObject, "GetSource", "FasmObjectGetSource")
	_AutoItObject_AddMethod($FObject, "SetSource", "FasmObjectSetSource")
	_AutoItObject_AddMethod($FObject, "Reset", "FasmObjectReset")
	_AutoItObject_AddMethod($FObject, "GetVersion", "FasmObjectGetVersion")
	_AutoItObject_AddDestructor($FObject, "FasmObjectDestructor")

	Return $FObject
EndFunc

Func _FasmObjectFuncWarp($FuncName, ByRef $Self, $Value = Default)
	Local $Fasm = Eval($Self.ArrayName)
	Local $Ret
	If @NumParams = 2 Then
		$Ret = Execute($FuncName & "($Fasm)")
	Else
		$Ret = Execute($FuncName & "($Fasm, $Value)")
	EndIf

	$Self.State = $Fasm[$_foSTATE]
	If $Self.State = $FASM_OK Then
		$Self.Error = False
		$Self.ErrorMessage = ""
		$Self.ErrorLine = ""
		$Self.ErrorLineNumber = -1
	Else
		$Self.Error = True
		Local $Error = FasmGetLastError()
		$Self.State = $Error[$FASMERRINDEX_CODE]
		$Self.ErrorMessage = $Error[$FASMERRINDEX_MESSAGE]
		$Self.ErrorLine = $Error[$FASMERRINDEX_LINE]
		$Self.ErrorLineNumber = $Error[$FASMERRINDEX_LINENUMBER]
	EndIf

	Assign($Self.ArrayName, $Fasm, 2)
	Return $Ret
EndFunc

Func FasmObjectAdd($Self, $Text)
	Return _FasmObjectFuncWarp("FasmAdd", $Self, $Text)
EndFunc

Func FasmObjectCompile($Self)
	Return _FasmObjectFuncWarp("FasmCompile", $Self)
EndFunc

Func FasmObjectGetBinary($Self)
	Return _FasmObjectFuncWarp("FasmGetBinary", $Self)
EndFunc

Func FasmObjectGetFuncPtr($Self)
	Return Number(_FasmObjectFuncWarp("FasmGetFuncPtr", $Self))
EndFunc

Func FasmObjectGetBasePtr($Self)
	Return Number(_FasmObjectFuncWarp("FasmGetBasePtr", $Self))
EndFunc

Func FasmObjectGetSource($Self)
	Return _FasmObjectFuncWarp("FasmGetSource", $Self)
EndFunc

Func FasmObjectSetSource($Self, $Text)
	Return _FasmObjectFuncWarp("FasmSetSource", $Self, $Text)
EndFunc

Func FasmObjectReset($Self)
	Return _FasmObjectFuncWarp("FasmReset", $Self)
EndFunc

Func FasmObjectGetVersion($Self)
	Return FasmGetVersion()
EndFunc

Func FasmObjectDestructor($Self)
	Assign($Self.ArrayName, 0, 2)
	_AutoItObject_Shutdown()
EndFunc
