; ------------------------------------------------------------------
; The Embedded Flat Assembler 1.69 Object UDF Demo (2011.6.4)
; Purpose: Demonstrate the usage of embedded flat assembler object
; Author:  Ward
; ------------------------------------------------------------------

#Include "FASMObject.au3"
Opt("MustDeclareVars", 1)

; Create Object
Global $F = FasmObjectCreate()

ConsoleWrite("AutoIt Embedded Flat Assembler Object (v" & $F.GetVersion() & ") Demo" & @CRLF)

Demo1()
Demo2()
Demo3()
Demo4()
Demo5()
Demo6()
Demo7()

; Call Destructor
$F = 0

Exit

Func Demo1()
	; Demo 1: Using Parameters
	$F.Reset()
	$F.Add("use32")
	$F.Add("push ebp")
	$F.Add("mov ebp, esp")
	$F.Add("mov eax, [ebp + 08]")
	$F.Add("add eax, [ebp + 0ch]")
	$F.Add("pop ebp")
	$F.Add("ret 8")

	ConsoleWrite(String($F.GetBinary()) & @CRLF)

	Local $Ret = MemoryFuncCall("int", $F.GetFuncPtr(), "int", 1, "int", 2)
	MsgBox(0, "Demo 1: Using Parameters", "1 + 2 = " & $Ret[0])
EndFunc

Func Demo2()
	; Demo 2: Read Time-Stamp Counter
	$F.Reset()
	$F.Add("use32")
	$F.Add("push ebp")
	$F.Add("mov ebp, esp")
	$F.Add("rdtsc")
	$F.Add("mov ecx, [ebp + 08]")
	$F.Add("mov [ecx], edx")
	$F.Add("pop ebp")
	$F.Add("ret 4")

	ConsoleWrite(String($F.GetBinary()) & @CRLF)

	Local $Ret = MemoryFuncCall("uint", $F.GetFuncPtr(), "uint*", 0)
	MsgBox(0, "Demo 2: Read Time-Stamp Counter", "RDTSC = " & Hex($Ret[1]) &  Hex($Ret[0], 8))
	Return Hex($Ret[1]) &  Hex($Ret[0], 8)
EndFunc

Func Demo3()
	; Demo 3: Using Label
	$F.Reset()
	$F.Add("use32")
	$F.Add("jmp forward")
	$F.Add("nop")
	$F.Add("forward:")
	$F.Add("mov eax, 0")
	$F.Add("mov ecx, 10")
	$F.Add("label1:")
	$F.Add("inc eax")
	$F.Add("loop label1")
	$F.Add("ret")

	ConsoleWrite(String($F.GetBinary()) & @CRLF)

	Local $Ret = MemoryFuncCall("int", $F.GetFuncPtr())
	MsgBox(0, "Demo 3: Using Label", "loop label for " & $Ret[0] & " times")
EndFunc

Func Demo4()
	; Demo 4: Call AutoIt Func From Assembly
	Local $AutoItFunc = DllCallbackRegister("AutoItFunc", "int", "")
	$F.Reset()
	$F.Add("use32")
	$F.Add("org " & $F.GetBasePtr())
	$F.Add("call " & DllCallbackGetPtr($AutoItFunc))
	$F.Add("shl eax, 1")
	$F.Add("ret")

	ConsoleWrite(String($F.GetBinary()) & @CRLF)

	Local $Ret = MemoryFuncCall("int", $F.GetFuncPtr())
	MsgBox(0, "Demo 4: AutoIt Function", "BitLeftShift the AutoItFunc return value: " & $Ret[0])
	DllCallbackFree($AutoItFunc)
EndFunc

Func AutoItFunc()
	MsgBox(0, "AutoItFunc", "Called by Inline Assembly")
	Return 123
EndFunc

Func Demo5()
	; Demo 5: Call AutoIt Func From Assembly And Pass Parameters
	Local $AutoItFunc = DllCallbackRegister("AutoItFunc2", "int", "str;uint;uint")
	$F.Reset()
	$F.Add("use32")
	$F.Add("org " & $F.GetBasePtr())
	$F.Add("rdtsc")
	$F.Add("push eax")
	$F.Add("push edx")
	$F.Add("push string")
	$F.Add("call " & DllCallbackGetPtr($AutoItFunc))
	$F.Add("ret")
	$F.Add("string: db 'RDTSC = %08X%08X', 0")

	ConsoleWrite(String($F.GetBinary()) & @CRLF)

	MemoryFuncCall("int", $F.GetFuncPtr())
	DllCallbackFree($AutoItFunc)
EndFunc

Func AutoItFunc2($String, $Edx, $Eax)
	MsgBox(0, "AutoItFunc", StringFormat($String, $Edx, $Eax))
EndFunc

Func Demo6()
	; Demo 6: Read CPUID
	$F.Reset()
	$F.Add("use32")
	$F.Add("push ebp")
	$F.Add("mov ebp, esp")
	$F.Add("pushad")
	$F.Add("xor eax, eax")
	$F.Add("cpuid")
	$F.Add("mov edi, [ebp + 08]")
	$F.Add("mov [edi], ebx")
	$F.Add("mov [edi + 4], edx")
	$F.Add("mov [edi + 8], ecx")
	$F.Add("mov al, 0")
	$F.Add("mov [edi + 12], al")
	$F.Add("popad")
	$F.Add("pop ebp")
	$F.Add("ret 4")

	ConsoleWrite(String($F.GetBinary()) & @CRLF)

	Local $Ret = MemoryFuncCall("uint", $F.GetFuncPtr(), "str", "")
	MsgBox(0, "Demo 6: CPUID", "CPUID = " & $Ret[1])
EndFunc

Func Demo7()
	; Demo 7: Error Handle
	$F.Reset()
	$F.Add("use32")
	$F.Add("jmp l2") ; a wrong label
	$F.Add("l1:")
	$F.Add("ret")

	$F.Compile()
	If $F.Error Then ; @Error is not returned by AutoItObject
		ConsoleWrite("Error Code: " & $F.State & @CRLF)
		ConsoleWrite("Error Message: " & $F.ErrorMessage & @CRLF)
		ConsoleWrite("Error LineNumber: " & $F.ErrorLineNumber & @CRLF)
		ConsoleWrite("Error Line: " & $F.ErrorLine & @CRLF)
	Else
		ConsoleWrite(String($F.GetBinary()) & @CRLF)
	EndIf
	MemoryFuncCall("int", $F.GetFuncPtr())
EndFunc
