; ------------------------------------------------------------------
; The Embedded Flat Assembler Server X86/X64 Demo (2011.6.4)
; Purpose: Demonstrate the usage of FASM object server
; Author:  Ward
; ------------------------------------------------------------------

#Include "BinaryCall.au3"
Opt("MustDeclareVars", 1)

; Get the FASM object
Global $F = ObjGet("AutoIt.FASM")
If Not IsObj($F) Then Exit MsgBox(16, "Error", "Please Start AutoIt FASM Object Server First !")

ConsoleWrite("AutoIt Embedded Flat Assembler Server (v" & $F.GetVersion() & ") Demo" & @CRLF)

Demo1()
Demo2()
Demo3()
Demo4()
Demo5()
Demo6()
Demo7()

Func Demo1()
	; Demo 1: Using Parameters
	$F.Reset()
	If @AutoItX64 Then
		$F.Add("use64")
		$F.Add("mov eax, ecx")
		$F.Add("add	eax, edx")
		$F.Add("cdqe")
		$F.Add("ret")
	Else
		$F.Add("use32")
		$F.Add("push ebp")
		$F.Add("mov ebp, esp")
		$F.Add("mov eax, [ebp + 08]")
		$F.Add("add eax, [ebp + 0ch]")
		$F.Add("pop ebp")
		$F.Add("ret 8")
	EndIf

	ConsoleWrite(String($F.GetBinary()) & @CRLF)

	Local $Ret = BinaryCall($F.GetBinary(), "int", "int", 1, "int", 2)
	MsgBox(0, "Demo 1: Using Parameters", "1 + 2 = " & $Ret[0])
EndFunc

Func Demo2()
	; Demo 2: Read Time-Stamp Counter
	$F.Reset()
	If @AutoItX64 Then
		$F.Add("use64")
		$F.Add("rdtsc")
		$F.Add("mov [rcx], edx")
		$F.Add("ret")
	Else
		$F.Add("use32")
		$F.Add("push ebp")
		$F.Add("mov ebp, esp")
		$F.Add("rdtsc")
		$F.Add("mov ecx, [ebp + 08]")
		$F.Add("mov [ecx], edx")
		$F.Add("pop ebp")
		$F.Add("ret 4")
	EndIf

	ConsoleWrite(String($F.GetBinary()) & @CRLF)

	Local $Ret = BinaryCall($F.GetBinary(), "uint", "uint*", 0)
	MsgBox(0, "Demo 2: Read Time-Stamp Counter", "RDTSC = " & Hex($Ret[1]) &  Hex($Ret[0], 8))
EndFunc

Func Demo3()
	; Demo 3: Using Label
	$F.Reset()
	If @AutoItX64 Then
		$F.Add("use64")
		$F.Add("jmp forward")
		$F.Add("nop")
		$F.Add("forward:")
		$F.Add("mov eax, 0")
		$F.Add("mov rcx, 10")
		$F.Add("label1:")
		$F.Add("inc eax")
		$F.Add("loop label1")
		$F.Add("ret")
	Else
		$F.Add("use32")
		$F.Add("jmp forward")
		$F.Add("nop")
		$F.Add("forward:")
		$F.Add("mov eax, 0")
		$F.Add("mov ecx, 10")
		$F.Add("label1:")
		$F.Add("inc eax")
		$F.Add("loop label1")
		$F.Add("ret")
	EndIf

	ConsoleWrite(String($F.GetBinary()) & @CRLF)

	Local $Ret = BinaryCall($F.GetBinary(), "int")
	MsgBox(0, "Demo 3: Using Label", "loop label for " & $Ret[0] & " times")
EndFunc

Func Demo4()
	; Demo 4: Call AutoIt Func From Assembly
	Local $AutoItFunc = DllCallbackRegister("AutoItFunc", "int", "")
	Local $BinaryCode = BinaryOpen()

	$F.Reset()
	If @AutoItX64 Then
		$F.Add("use64")
		$F.Add("org " & BinaryGetPtr($BinaryCode))
		$F.Add("sub rsp, 40")
		$F.Add("call " & DllCallbackGetPtr($AutoItFunc))
		$F.Add("add rsp, 40")
		$F.Add("shl eax, 1")
		$F.Add("ret")
	Else
		$F.Add("use32")
		$F.Add("org " & BinaryGetPtr($BinaryCode))
		$F.Add("call " & DllCallbackGetPtr($AutoItFunc))
		$F.Add("shl eax, 1")
		$F.Add("ret")
	EndIf

	ConsoleWrite(String($F.GetBinary()) & @CRLF)
	BinarySetData($BinaryCode, $F.GetBinary())

	Local $Ret = BinaryCall($BinaryCode, "int64")
	MsgBox(0, "Demo 4: AutoIt Function", "BitLeftShift the AutoItFunc return value: " & $Ret[0])

	BinaryClose($BinaryCode)
	DllCallbackFree($AutoItFunc)
EndFunc

Func AutoItFunc()
	MsgBox(0, "AutoItFunc", "Called by Inline Assembly")
	Return 123
EndFunc

Func Demo5()
	; Demo 5: Call AutoIt Func From Assembly And Pass Parameters
	Local $AutoItFunc = DllCallbackRegister("AutoItFunc2", "int", "str;uint;uint")
	Local $BinaryCode = BinaryOpen()

	$F.Reset()
	If @AutoItX64 Then
		$F.Add("use64")
		$F.Add("org " & BinaryGetPtr($BinaryCode))
		$F.Add("rdtsc")
		$F.Add("mov rcx, string")
		$F.Add("movsxd rdx, edx")
		$F.Add("movsxd r8, eax")
		$F.Add("sub rsp, 40")
		$F.Add("call " & DllCallbackGetPtr($AutoItFunc))
		$F.Add("add rsp, 40")
		$F.Add("ret")
		$F.Add("string: db 'RDTSC = %08X%08X', 0")
	Else
		$F.Add("use32")
		$F.Add("org " & BinaryGetPtr($BinaryCode))
		$F.Add("rdtsc")
		$F.Add("push eax")
		$F.Add("push edx")
		$F.Add("push string")
		$F.Add("call " & DllCallbackGetPtr($AutoItFunc))
		$F.Add("ret")
		$F.Add("string: db 'RDTSC = %08X%08X', 0")
	EndIf

	ConsoleWrite(String($F.GetBinary()) & @CRLF)
	BinarySetData($BinaryCode, $F.GetBinary())

	BinaryCall($BinaryCode, "int")

	BinaryClose($BinaryCode)
	DllCallbackFree($AutoItFunc)
EndFunc

Func AutoItFunc2($String, $Edx, $Eax)
	MsgBox(0, "AutoItFunc", StringFormat($String, $Edx, $Eax))
EndFunc

Func Demo6()
	; Demo 6: Read CPUID
	$F.Reset()
	If @AutoItX64 Then
		$F.Add("use64")
		$F.Add("mov r8, rcx")
		$F.Add("xor eax, eax")
		$F.Add("cpuid")
		$F.Add("mov [r8], ebx")
		$F.Add("mov [r8 + 4], edx")
		$F.Add("mov [r8 + 8], ecx")
		$F.Add("ret")
	Else
		$F.Add("use32")
		$F.Add("push ebp")
		$F.Add("mov ebp, esp")
		$F.Add("pushad")
		$F.Add("xor eax, eax")
		$F.Add("cpuid")
		$F.Add("mov edi, [ebp + 08]")
		$F.Add("mov [edi], ebx")
		$F.Add("mov [edi + 4], edx")
		$F.Add("mov [edi + 8], ecx")
		$F.Add("mov al, 0")
		$F.Add("mov [edi + 12], al")
		$F.Add("popad")
		$F.Add("pop ebp")
		$F.Add("ret 4")
	EndIf

	ConsoleWrite(String($F.GetBinary()) & @CRLF)

	Local $Ret = BinaryCall($F.GetBinary(), "uint", "str", "")
	MsgBox(0, "Demo 6: CPUID", "CPUID = " & $Ret[1])
EndFunc

Func Demo7()
	; Demo 7: Error Handle
	$F.Reset()
	If @AutoItX64 Then
		$F.Add("use64")
		$F.Add("jmp l2") ; a wrong label
		$F.Add("l1:")
		$F.Add("ret")
	Else
		$F.Add("use32")
		$F.Add("jmp l2") ; a wrong label
		$F.Add("l1:")
		$F.Add("ret")
	EndIf

	$F.Compile()
	If $F.Error Then ; @Error is not returned by AutoItObject
		ConsoleWrite("Error Code: " & $F.State & @CRLF)
		ConsoleWrite("Error Message: " & $F.ErrorMessage & @CRLF)
		ConsoleWrite("Error LineNumber: " & $F.ErrorLineNumber & @CRLF)
		ConsoleWrite("Error Line: " & $F.ErrorLine & @CRLF)
	Else
		ConsoleWrite(String($F.GetBinary()) & @CRLF)
	EndIf
EndFunc
