; ------------------------------------------------------------------
; The Embedded Flat Assembler Server BinaryXOR Example (2011.6.4)
; Purpose: Demonstrate the usage of FASM object server
; Author:  Ward
; ------------------------------------------------------------------

#Include "BinaryCall.au3"
Opt("MustDeclareVars", 1)

Global Const $Compile = 0 ; Not to recompile the source

SpeedTest(100000)
Exit

Func SpeedTest($TestLength)
	Local $Binary1 = "0x"
	For $i = 1 To $TestLength
		$Binary1 &= Hex(Random(0, 0xFF, 1), 2)
	Next
	$Binary1 = Binary($Binary1)

	Local $Binary2 = "0x"
	For $i = 1 To Random(1, Round($TestLength / 10), 1)
		$Binary2 &= Hex(Random(0, 0xFF, 1), 2)
	Next
	$Binary2 = Binary($Binary2)

	Local $Timer

	$Timer = TimerInit()
	Local $Result1 = BinaryXOR1($Binary1, $Binary2)
	Local $Diff1 = TimerDiff($Timer)

	$Timer = TimerInit()
	Local $Result2 = BinaryXOR2($Binary1, $Binary2)
	Local $Diff2 = TimerDiff($Timer)

	$Timer = TimerInit()
	Local $Result3 = BinaryXOR3($Binary1, $Binary2)
	Local $Diff3 = TimerDiff($Timer)

	Local $Msg = "BinaryXOR Result Identical: " & ($Result1 = $Result2 And $Result1 = $Result3) & @CRLF
	$Msg &= "Method 1 TimerDiff: " & $Diff1 & @CRLF
	$Msg &= "Method 2 TimerDiff: " & $Diff2 & @CRLF
	$Msg &= "Method 3 TimerDiff: " & $Diff3 & @CRLF
	$Msg &= "Method 3 Is " & Round($Diff1 / $Diff3) & " Times Faster Than Method 1" & @CRLF
	$Msg &= "Method 3 Is " & Round($Diff2 / $Diff3) & " Times Faster Than Method 2" & @CRLF
	MsgBox(32, "AutoIt FASM Server BinaryXOR Example", $Msg)
EndFunc

Func BinaryXOR1($Binary1, $Binary2)
	$Binary1 = Binary($Binary1)
	$Binary2 = Binary($Binary2)

	Local $Len1 = BinaryLen($Binary1)
	Local $Len2 = BinaryLen($Binary2)
	Local $Result = Binary('')

	If $Len1 And $Len2 Then
		For $i = 1 To $Len1
			Local $Byte = BitXOR(BinaryMid($Binary1, $i, 1), BinaryMid($Binary2, 1 + Mod($i - 1, $Len2), 1))
			$Result &= BinaryMid(Binary($Byte), 1, 1)
		Next
	EndIf
	Return $Result
EndFunc

Func BinaryXOR2($Binary1, $Binary2)
	$Binary1 = Binary($Binary1)
	$Binary2 = Binary($Binary2)

	Local $Len1 = BinaryLen($Binary1)
	Local $Len2 = BinaryLen($Binary2)
	Local $Buffer1 = DllStructCreate("byte[" & $Len1 & "]")
	Local $Buffer2 = DllStructCreate("byte[" & $Len2 & "]")
	DllStructSetData($Buffer1, 1, $Binary1)
	DllStructSetData($Buffer2, 1, $Binary2)

	If $Len1 And $Len2 Then
		For $i = 1 To $Len1
			Local $Value1 = DllStructGetData($Buffer1, 1, $i)
			Local $Value2 = DllStructGetData($Buffer2, 1, 1 + Mod($i - 1, $Len2))

			DllStructSetData($Buffer1, 1, BitXOR($Value1, $Value2), $i)
		Next
	EndIf
	Return DllStructGetData($Buffer1, 1)
EndFunc

Func BinaryXOR3($Binary1, $Binary2)
	Local $BinaryCode
	If $Compile Then
		Local $F = ObjGet("AutoIt.FASM")
		If Not IsObj($F) Then Exit MsgBox(16, "Error", "Please Start AutoIt FASM Object Server First !")
		$F.Reset()

		If @AutoItX64 Then
			$F.Add("use64")
			$F.Add("mov r10, rcx")
			$F.Add("movsxd rcx, edx")
			$F.Add("L1:")
			$F.Add("xor edx, edx")
			$F.Add("mov eax, ecx")
			$F.Add("dec eax")
			$F.Add("div r9d")
			$F.Add("movsxd rdx, edx")
			$F.Add("mov al, [r8+rdx]")
			$F.Add("xor byte [r10+rcx-1], al")
			$F.Add("loop L1")
			$F.Add("ret")
		Else
			$F.Add("use32")
			$F.Add("push ebp")
			$F.Add("mov ebp, esp")
			$F.Add("push esi")
			$F.Add("push edi")
			$F.Add("mov edi, [ebp + 08]")
			$F.Add("mov esi, [ebp + 16]")
			$F.Add("mov ecx, [ebp + 12]")
			$F.Add("L1:")
			$F.Add("xor edx, edx")
			$F.Add("mov eax, ecx")
			$F.Add("dec eax")
			$F.Add("div dword [ebp + 20]")
			$F.Add("mov al, [esi+edx]")
			$F.Add("xor byte [edi+ecx-1], al")
			$F.Add("loop L1")
			$F.Add("pop edi")
			$F.Add("pop esi")
			$F.Add("pop ebp")
			$F.Add("ret 16")
		EndIf
		ConsoleWrite(String($F.GetBinary()) & @CRLF)
		$BinaryCode = $F.GetBinary()
	Else
		If @AutoItX64 Then
			$BinaryCode = Binary("0x4989CA4863CA31D289C8FFC841F7F14863D2418A04104130440AFFE2E9C3")
		Else
			$BinaryCode = Binary("0x5589E556578B7D088B75108B4D0C31D289C848F775148A041630440FFFE2EF5F5E5DC21000")
		EndIf
	EndIf

	$Binary1 = Binary($Binary1)
	$Binary2 = Binary($Binary2)

	Local $Len1 = BinaryLen($Binary1)
	Local $Len2 = BinaryLen($Binary2)
	Local $Buffer1 = DllStructCreate("byte[" & $Len1 & "]")
	Local $Buffer2 = DllStructCreate("byte[" & $Len2 & "]")
	DllStructSetData($Buffer1, 1, $Binary1)
	DllStructSetData($Buffer2, 1, $Binary2)

	If $Len1 And $Len2 Then
		BinaryCall($BinaryCode, "none", "ptr", DllStructGetPtr($Buffer1), "uint", $Len1, "ptr", DllStructGetPtr($Buffer2), "uint", $Len2)
	EndIf
	Return DllStructGetData($Buffer1, 1)
EndFunc
