#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=open-webui-ToTray.ico
#AutoIt3Wrapper_UseX64=y
#AutoIt3Wrapper_Res_Comment=Hide open-webui's WindowsTerminal.exe to tray
#AutoIt3Wrapper_Res_Description=Hide open-webui's WindowsTerminal.exe to tray
#AutoIt3Wrapper_Res_Fileversion=0.0.0.7
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_ProductName=open-webui-ToTray.exe
#AutoIt3Wrapper_Res_ProductVersion=0.0.0.1
#AutoIt3Wrapper_Res_CompanyName=.
#AutoIt3Wrapper_Res_LegalCopyright=.
#AutoIt3Wrapper_Res_LegalTradeMarks=.
#AutoIt3Wrapper_Res_Icon_Add=open-webui-ToTray_red.ico, 201
#AutoIt3Wrapper_Res_Icon_Add=open-webui-ToTray_gray.ico, 202
#AutoIt3Wrapper_Res_Icon_Add=open-webui-ToTray_green.ico, 203
#AutoIt3Wrapper_Res_Icon_Add=open-webui-ToTray_violet.ico, 204
#AutoIt3Wrapper_Run_Au3Stripper=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****


; coded in Win11 and Server 2022. No other testing. Hope it works on your PC.


Global $g_SiteLink = "https://www.autoitscript.com/forum/index.php?showtopic=212908"
;~ #include <OnDebugMsgBox.au3> ; https://www.autoitscript.com/forum/files/file/500-ondebugmsgbox/
;~ _DebugMsgBox_DefaulText(_DebugMsgBox_DefaulText() & @CRLF & '( ' & $g_SiteLink & ' )') ; added for v0.0.0.2

#include <Misc.au3>
#include <AutoItConstants.au3>
#include <MsgBoxConstants.au3>
#include <StringConstants.au3>
#include <TrayConstants.au3> ; Required for the $TRAY_ICONSTATE_SHOW constant.

Opt("TrayMenuMode", 3) ; The default tray menu items will not be shown and items are not checked when selected. These are options 1 and 2 for TrayMenuMode.

Global Enum $eExtCmd_SectionName, $eExtCmd_Show, $eExtCmd_MenuText, $eExtCmd_filename, $eExtCmd_parameters, $eExtCmd_workingdir, $eExtCmd_verb, $eExtCmd_CtrlID, $eExtCmd_UBound
Global $g_ObjErr = ObjEvent("AutoIt.Error", "ObjErrCatcher")
Global $g_ScriptLnk = StringTrimRight(@ScriptFullPath, 4) & " (script) - Shortcut.lnk"
Global $g_hWindow = 0, $g_Compiled = (@ScriptFullPath = @AutoItExe)
Global $g_aExtraCmds[1][$eExtCmd_UBound] = [[0]], $g_sINI = StringTrimRight(@ScriptFullPath, 4) & ".ini"
Global $g_1stRun = Not FileGetSize($g_sINI)
If $g_1stRun Then FileWriteLine($g_sINI, "; Make sure these settings are correct. For more help go to " & $g_SiteLink & @CRLF & _
		"; In the first run this file gets created with defaults and hints. Next time it runs, it will execute according to the values from this file." & @CRLF & _
		"; If you wanna leave a comment in an entry, add ""<space>;<space>"" and then the comment on that same line, as you see them here on this file." & @CRLF & _
		"; if for some reason your entry as a "" ; "" in it, just add ""; NoComment"" to the end and it will not treat them as a comment" & @CRLF & _
		"; If you'd like to start anew or recreate this file again, rename/delete this file and one will be created again." & @CRLF)
Global $g_sTitle = StringStripWS(IniReadOrInit($g_sINI, "Run", "title", " ; A title entry is not needed ( is self generated ) but you may want to have a custom one ?"), 3) ; v0.0.0.3 ; not needed.
Global $g_iRunCmdOnLoad = Int(IniReadOrInit($g_sINI, "Run", "RunCmdOnLoad", "1 ; set to zero to not attempt to run"))

Global $g_sPath = IniReadOrInit($g_sINI, "Run", "path", "; empty") ; added to 0.0.0.6 ; try finding a running open-webui, else, default
If $g_sPath = "" Then $g_sPath = IniReadOrInit($g_sINI, "Run", "path", FindOpenwebuiPython("python.exe", "open-webui.exe", @LocalAppDataDir & "\Programs\Python\Python312\Scripts"), 1)

Global $g_sCmd = IniReadOrInit($g_sINI, "Run", "cmd", "open-webui serve --host 0.0.0.0 --port 8080")
Global $g_sCmdForUdate = StringStripWS(IniReadOrInit($g_sINI, "Run", "cmdForUdate", "python -m pip install --upgrade pip open-webui"), 3) ; v0.0.0.4 ; ioa747 's idea
If $g_1stRun Then IniReadOrInit($g_sINI, "Run", ";cmdForUdate", "python -m pip install --no-cache-dir -U pip open-webui ; ..hope you know more about python than me") ; v0.0.0.4 ; as a hint ?

Global $g_iWait = Int(IniReadOrInit($g_sINI, "Run", "WaitForWindow", "5 ; Max seconds to wait for the window. If the default of 5 sec. is too fast for your PC, change it. Max. 60 sec."))
If $g_1stRun Then IniReadOrInit($g_sINI, "EnvSet", "WEBUI_AUTH", "True")
Global $g_iCloseWindowOnExit = Int(IniReadOrInit($g_sINI, "Action", "CloseWindowOnExit", "1 ; Set to 1 to attempt to close the window when exiting this app / Set to 0 to not even try"))
Global $g_iIconForOnlineAtStart = Int(IniReadOrInit($g_sINI, "Action", "IconForOnlineAtStart", "30 ; number of seconds to check if online. Set to 0 to disable this test. Max 120 seconds"))
If $g_iIconForOnlineAtStart < 1 Or $g_iIconForOnlineAtStart > 120 Then $g_iIconForOnlineAtStart = 30
Global $g_iOnDClick = Int(IniReadOrInit($g_sINI, "Action", "OnDClick", "2 ; 0=Do nothing / 1=HideShow window / 2=Run [ExtraCmd] entry"))
Global $g_iDoEnvSet = Int(IniReadOrInit($g_sINI, "Action", "DoEnvSet", "0 ; 0=Do nothing / 1=set those in [EnvSet]"))
Global $g_iExtraCmd_Add = Int(IniReadOrInit($g_sINI, "ExtraCmd", "ShowExtraCmd", "1 ; 1=yes / 0=no"))
Global $g_sExtraCmd_MenuText = StringStripWS(IniReadOrInit($g_sINI, "ExtraCmd", "MenuText", "Go to local open-webui"), 3)
Global $g_sExtraCmd_filename = StringStripWS(IniReadOrInit($g_sINI, "ExtraCmd", "ShellExecute-filename", "http://localhost:8080/?temporary-chat=true"), 3)
Global $g_sExtraCmd_parameters = StringStripWS(IniReadOrInit($g_sINI, "ExtraCmd", "ShellExecute-parameters", ""), 3)
Global $g_iExtraCmd_workingdir = StringStripWS(IniReadOrInit($g_sINI, "ExtraCmd", "ShellExecute-workingdir", @TempDir), 3)
Global $g_sExtraCmd_verb = StringStripWS(IniReadOrInit($g_sINI, "ExtraCmd", "ShellExecute-verb", "open"), 3)
If $g_iWait < 1 Or $g_iWait > 60 Then
	$g_iWait = 5
	IniWrite($g_sINI, "Run", "WaitForWindow", "5 ; Max. seconds to wait for the window. In case the default wait of 5 sec is too short for your PC. Max 60 sec.")
EndIf

If $g_sTitle = "" Then $g_sTitle = StringTrimRight(@ScriptName, 4) & ' - ' & $g_sCmd
Global $g_iHideOnLoad = Int(IniReadOrInit($g_sINI, "Action", "HideOnLoad", "1 ; set to zero to not hide on load"))
If $g_1stRun Then
	If Not $g_Compiled Then EnsureScriptLnk()

	; added on v0.0.0.6 ; the ability to have more menu entries
	IniReadOrInit($g_sINI, "ExtraCmd2", "ShowExtraCmd", "0 ; 1=yes / 0=no")
	IniReadOrInit($g_sINI, "ExtraCmd2", "MenuText", "Edit INI")
	IniReadOrInit($g_sINI, "ExtraCmd2", "ShellExecute-filename", StringTrimRight(@ScriptName, 4) & ".ini")
	IniReadOrInit($g_sINI, "ExtraCmd2", "ShellExecute-parameters", "")
	IniReadOrInit($g_sINI, "ExtraCmd2", "ShellExecute-workingdir", " ; This is an example of adding more menu entries")
	IniReadOrInit($g_sINI, "ExtraCmd2", "ShellExecute-verb", " ; Add an extra number to the section name, like ""ExtraCmd2"" or ""ExtraCmd3"" and so on.")

	ShellExecute($g_sINI)
	MsgBox($MB_TOPMOST + $MB_ICONINFORMATION, StringTrimRight(@ScriptName, 4), "Since this is your first run," & @LF & _
			"review/edit the ini file to make sure the entries are correct." & @LF & @LF & _
			"This popup/pause will not show again. ( you are aware of the settings )", 60)
	Exit
EndIf

If $g_iRunCmdOnLoad And Not FileExists($g_sPath) Then
	MsgBox($MB_TOPMOST + $MB_ICONERROR, StringTrimRight(@ScriptName, 4), "The path:" & @LF & @LF & $g_sPath & @LF & @LF & "was not found, bye.", 60)
	Exit 11
EndIf

If WinExists("[TITLE:Stub - " & $g_sTitle & ";CLASS:AutoIt v3;]") Then Exit 6
AutoItWinSetTitle("Stub - " & $g_sTitle)

Tray_SetIconIf(StringTrimRight(@ScriptFullPath, 4) & "_gray.ico", 202)
Main()

Func Main()

	If Not $g_Compiled And Not IsFromLNK() Then DllCall('shell32.dll', 'long', 'SetCurrentProcessExplicitAppUserModelID', 'wstr', @ScriptName & '-' & TimerInit())  ; look at _WinAPI_SetCurrentProcessExplicitAppUserModelID()

	Local $hTimer = TimerInit()
	If Not WinFind($g_sTitle) Then
		If $g_iDoEnvSet Then RunEnvSet()
		Local $sRun = @ComSpec & ' /c title ' & $g_sTitle & '&&' & $g_sCmd
		ConsoleWriteWL('[' & $sRun & '][' & $g_sPath & ']')
		Run($sRun, $g_sPath)
	EndIf

	Local $idCmdShow = TrayCreateItem("Show")
	TrayCreateItem("") ; Create a separator line.
	Local $idCmdHide = TrayCreateItem("Hide")
	TrayCreateItem("") ; Create a separator line.

	Local $idCmdUpdate = 0, $idReloadThisAndExit = 0, $idExtraCmd = 0
	If $g_iExtraCmd_Add Then
		$idExtraCmd = TrayCreateItem($g_sExtraCmd_MenuText)
		TrayCreateItem("") ; Create a separator line.
	EndIf

	$g_aExtraCmds = ExtraCmds_GetFromIniAndAddToMenu()

	If StringLen($g_sCmdForUdate) Then
		$idCmdUpdate = TrayCreateItem("Run update command")
		TrayCreateItem("") ; Create a separator line.
	EndIf
	If Not $g_Compiled Then
		$idReloadThisAndExit = TrayCreateItem("Reload script")
		TrayCreateItem("") ; Create a separator line.
	EndIf
	Local $idBrowseSelf = TrayCreateItem("Browse self folder")
	TrayCreateItem("") ; Create a separator line.
	Local $idOpenAboutLink = TrayCreateItem("About: open link to web site post")
	TrayCreateItem("") ; Create a separator line.
	Local $idExit = TrayCreateItem("Exit")

	TraySetClick($TRAY_CLICK_SECONDARYUP)
	TraySetState($TRAY_ICONSTATE_SHOW) ; Show the tray menu.
	TraySetToolTip('DClick to show/hide' & @LF & $g_sCmd & @LF & @LF & @LF & " ")

	$g_hWindow = WinFind($g_sTitle, "", $g_iWait) ; added for v0.0.0.2
	If $g_hWindow = 0 Then
		If $g_iIconForOnlineAtStart Then $g_iIconForOnlineAtStart = 0
		Tray_SetIconIf(StringTrimRight(@ScriptFullPath, 4) & "_red.ico", 201)
	EndIf

	; these can be used for a default action when loadading the script
;~ 	If StringInStr($CmdLineRaw, "/CreateScriptLnk") Then CreateScriptLnk()
	If StringInStr($CmdLineRaw, "/hide") Or $g_iHideOnLoad Then HideShowCmd(1)
	If StringInStr($CmdLineRaw, "/show") Then HideShowCmd(0)
	If StringInStr($CmdLineRaw, "/runUpdate") Then RunUpdateCmdAndReloadThis(0)
	If StringInStr($CmdLineRaw, "/exit") Then
		Sleep(2000) ; just to momentarelly show if it worked or not ( blue vs. red icon )
		Exit 7
	EndIf

	If $g_iIconForOnlineAtStart Then
		If Not IsOpenwebuiOnline() Then AdlibRegister(IsOpenwebuiOnline, 3000)
	EndIf

	If Not $g_Compiled Then ConsoleWriteWL('Loading time = ' & TimerDiff($hTimer))

	Local $iMsg
	While 1
		$iMsg = TrayGetMsg()
		Switch $iMsg
			Case 0, -3, -7, -8, -9, -10, -11 ; do nothing
			Case $idReloadThisAndExit
				ReloadThisAndExit()
			Case $idExtraCmd
				RunExtraCmd()
			Case $idOpenAboutLink
				If StringLen($g_SiteLink) Then ShellExecute($g_SiteLink)
			Case $idBrowseSelf
				ShellExecute(@ScriptDir)
			Case $idCmdUpdate
				WinClose($g_hWindow)
				WinWaitClose($g_hWindow, "", 5)
				If WinExists($g_hWindow) Then
					HideShowCmd(0)
					MsgBox($MB_TOPMOST + $MB_ICONINFORMATION, StringTrimRight(@ScriptName, 4), "An update can not be attempted while the app is running", 60)
					ContinueLoop
				EndIf
				RunUpdateCmdAndReloadThis()
			Case $TRAY_EVENT_PRIMARYDOUBLE
				Switch $g_iOnDClick
					Case 1
						HideShowCmd()
					Case 2
						RunExtraCmd()
				EndSwitch
			Case $idCmdShow
				HideShowCmd(0)
			Case $idCmdHide
				HideShowCmd(1)
			Case $idExit ; Exit the loop.
				HideShowCmd(0)
				If $g_iCloseWindowOnExit And Not (_IsPressed("11") And _IsPressed("10")) Then WinClose($g_hWindow) ; 11 CTRL key ; 10 SHIFT key ; ..to skip closing the window
				Return
			Case Else
				ConsoleWriteWL("Case Else : $iMsg = " & $iMsg)
				ExtraCmds_IfCtrlIdExec($iMsg)
		EndSwitch
	WEnd
EndFunc   ;==>Main

Func HideShowCmd($iHide = -1, $sTitle = $g_hWindow, $iLine = @ScriptLineNumber)
	Local $iState = WinGetState($sTitle)
	If @error Then
		Tray_SetIconIf(StringTrimRight(@ScriptFullPath, 4) & "_red.ico", 201)
		Return SetError(1, 0, 1) ; ..Return error not used in this script but, you may wanna use it
	EndIf
	Tray_SetIconIf(StringTrimRight(@ScriptFullPath, 4) & ".ico")

	If $iHide = -1 Then $iHide = (BitAND($iState, $WIN_STATE_VISIBLE) ? 1 : 0)
	If $iHide Then
		If Not $g_Compiled Then ConsoleWriteWL('was VISIBLE = YES' & @CRLF, $iLine)
		WinSetState($sTitle, "", @SW_HIDE)
	Else
		If Not $g_Compiled Then ConsoleWriteWL('was VISIBLE = NO' & @CRLF, $iLine)
		WinSetState($sTitle, "", @SW_SHOW)
		WinActivate($sTitle)
	EndIf
EndFunc   ;==>HideShowCmd

Func IniReadOrInit($s_ini, $s_section, $s_key, $s_default, $iIniWriteAnyway = 0)
	Local $sRet = IniRead($s_ini, $s_section, $s_key, @CRLF)
	If $sRet = @CRLF Or $iIniWriteAnyway Then ; init the ini entry
		IniWrite($s_ini, $s_section, $s_key, $s_default)
		$sRet = $s_default
		SetExtended(1) ; ..Return error not used in this script but, you may wanna use it
	EndIf
	If StringRight($sRet, 11) = "; NoComment" Then
		Return StringStripWS(StringTrimRight($sRet, 11), 3)
	EndIf
	If StringInStr($sRet, " ; ") Then ; ..in older versions of AutoIt this was needed if memory serves, it don't hurt to add this line.
		Local $aTemp = StringSplit($sRet, " ; ", 1) ; I keep comments in the same entry.
		$sRet = StringStripWS($aTemp[1], 3) ;         Clean up the entry and remove the comments.
	EndIf
	If StringLeft($sRet, 2) = "; " Then $sRet = ""
	Return $sRet
EndFunc   ;==>IniReadOrInit

Func Tray_SetIconIf($sIconFile, $iIconID = 0, $iLine = @ScriptLineNumber)
	If $g_Compiled And Not FileGetSize($sIconFile) Then
		TraySetIcon(@AutoItExe, $iIconID)
	Else ; use your own icon
		If FileGetSize($sIconFile) Then
			TraySetIcon($sIconFile)
		Else
			SetError(1) ; ..not used in this script but, you may wanna use it
		EndIf
	EndIf
	If Not $g_Compiled Then ConsoleWriteWL('Func Tray_SetIconIf("' & $sIconFile & '", ' & $iIconID & ' )' & @CRLF, $iLine)
EndFunc   ;==>Tray_SetIconIf

Func RunUpdateCmdAndReloadThis($iExit = 1, $iLine = @ScriptLineNumber)
	Tray_SetIconIf(StringTrimRight(@ScriptFullPath, 4) & "_green.ico", 203)
	If Not $g_Compiled Then ConsoleWriteWL('Func RunUpdateCmdAndReloadThis()' & @CRLF, $iLine)
	Local $hTimer = TimerInit()
	Local $iPID = Run(@ComSpec & ' /c title ' & StringTrimRight(@ScriptName, 4) & ' - ' & $g_sCmdForUdate & '&&' & $g_sCmdForUdate & '&&echo  done, will reload in a sec&&ping 127.0.0.1>nul', $g_sPath)
	Do
		Sleep(1000)
		If TimerDiff($hTimer) > 120000 Then ExitLoop ; should not take that long !
	Until Not ProcessExists($iPID)
	If $iExit Then ReloadThisAndExit()
	Tray_SetIconIf(StringTrimRight(@ScriptFullPath, 4) & ".ico", 0)
EndFunc   ;==>RunUpdateCmdAndReloadThis

Func ReloadThisAndExit()
	;  Story time:
	;    Task Manager will show the icon of the script
	;    if it was a link that run it, otherwise
	;    it will show the default icon for the executable (AutoIt)
	;    Therefore, is preferable to load/reload the script from a link (.lnk)
	;    than straight from AutoIt. That way you can see the icon in Task Manager.
	;    And if you look at it to check on memory, CPU usage, etc., it's easier to find.

	AutoItWinSetTitle("Reloading Stub - " & $g_sTitle)
	If $g_Compiled Then
		ShellExecute(@AutoItExe)
	Else
		If FileGetSize($g_ScriptLnk) Then
			ShellExecute($g_ScriptLnk)
		Else ; if not there, try to make one
			EnsureScriptLnk()
			If Not @error Then
				ShellExecute($g_ScriptLnk)
			Else ; if it fail (read only folder ?)
				ShellExecute(@AutoItExe, ($g_Compiled ? "" : '/AutoIt3ExecuteScript "' & @ScriptFullPath & '"'))
			EndIf
		EndIf
	EndIf
	Exit
EndFunc   ;==>ReloadThisAndExit

Func RunEnvSet()
	Local $iChanged = 0, $aArray = IniReadSection($g_sINI, "EnvSet")
	If @error Then Return
	For $n = 1 To UBound($aArray) - 1
		If EnvGet($aArray[$n][0]) = $aArray[$n][1] Then ContinueLoop
		If $aArray[$n][1] = "" Then ContinueLoop
		$iChanged += 1
		EnvSet($aArray[$n][0], $aArray[$n][1])
	Next
	If $iChanged Then EnvUpdate()
EndFunc   ;==>RunEnvSet

Func RunExtraCmd()
	If Not StringLen($g_sExtraCmd_filename) Then Return SetError(1, 0, 1)
	ShellExecute($g_sExtraCmd_filename, $g_sExtraCmd_parameters, $g_sExtraCmd_verb)
EndFunc   ;==>RunExtraCmd

Func IsFromLNK() ; https://www.autoitscript.com/forum/index.php?showtopic=212920&view=findpost&p=1543594
	Local $tInfo = _WinAPI_GetStartupInfo()
	Return StringRight(_WinAPI_GetString($tInfo.title), 4) = ".lnk"
EndFunc   ;==>IsFromLNK

Func CreateScriptLnk($sLinkFileName = $g_ScriptLnk, $sFileDescription = "Hide open-webui's WindowsTerminal.exe to tray") ; added to v0.0.0.5
	If Not FileCreateShortcut(@AutoItExe, $sLinkFileName, @ScriptDir, '/AutoIt3ExecuteScript "' & _
			@ScriptFullPath & '"', $sFileDescription, _
			StringTrimRight(@ScriptFullPath, 4) & ".ico") Then
		ConsoleWriteWL('FileCreateShortcut FAILED' & @CRLF)
		Return SetError(1, 0, 1)
	EndIf ; added on v0.0.0.5
EndFunc   ;==>CreateScriptLnk

Func EnsureScriptLnk($sLinkFileName = $g_ScriptLnk) ; added to v0.0.0.5
	ConsoleWriteWL('EnsureScriptLnk("' & $sLinkFileName & '")' & @CRLF)

	; Retrieve details about the shortcut. ( if it looks straight from the help file, well, it is )
	Local $aDetails = FileGetShortcut($sLinkFileName)

;~ 	If Not @error Then
;~ 		ConsoleWrite(@CRLF & "Path: " & $aDetails[0] & @CRLF & _
;~ 		"Working directory: " & $aDetails[1] & @CRLF & _
;~ 		"Arguments: " & $aDetails[2] & @CRLF & _
;~ 		"Description: " & $aDetails[3] & @CRLF & _
;~ 		"Icon filename: " & $aDetails[4] & @CRLF & _
;~ 		"Icon index: " & $aDetails[5] & @CRLF & _
;~ 		"Shortcut state: " & $aDetails[6] & @CRLF & @CRLF)
;~ 	EndIf

;~ 		Path: D:\Utilities\AutoIt3\AutoIt3_x64.exe
;~ 		Working directory: D:\Utilities\open-webui-ToTray
;~ 		Arguments: /AutoIt3ExecuteScript "D:\Utilities\open-webui-ToTray\open-webui-ToTray.au3"
;~ 		Description: Hide open-webui's WindowsTerminal.exe to tray
;~ 		Icon filename: D:\Utilities\open-webui-ToTray\open-webui-ToTray.ico
;~ 		Icon index: 0
;~ 		Shortcut state: 1

	If Not @error And $aDetails[4] = StringTrimRight(@ScriptFullPath, 4) & ".ico" And $aDetails[0] = @AutoItExe Then
		ConsoleWriteWL('EnsureScriptLnk, All good.' & @CRLF)
		Return 0
	EndIf
	ConsoleWriteWL('EnsureScriptLnk() FAILED, calling CreateScriptLnk()' & @CRLF)
	Local $vRet = CreateScriptLnk($sLinkFileName)
	ConsoleWriteWL('CreateScriptLnk() returned val,error,extended = ' & $vRet & ',' & @error & ',' & @extended & @CRLF)
	Return SetError(@error, @extended, $vRet)
EndFunc   ;==>EnsureScriptLnk

Func ConsoleWriteWL($sData, $iLine = @ScriptLineNumber, $iError = @error, $iExtended = @extended)
	If StringRight($sData, 2) <> @CRLF Then $sData &= @CRLF
	Local $iRet = ConsoleWrite('@@(' & $iLine & ') : ' & @HOUR & ":" & @MIN & ":" & @SEC & "." & @MSEC & ' : ' & $sData)
	Return SetError($iError, $iExtended, $iRet)
EndFunc   ;==>ConsoleWriteWL

#Region "are we there yet"

; ...because the window may be there, but not the service ( Am impatient/restless. Why do I have to wait !!!   =D )
Func IsOpenwebuiOnline()
	Local Static $sHost = "", $iPort = 0, $hTimer = TimerInit()
	If Not $iPort Then
		Local $aArray = StringSplit(StringStripWS($g_sCmd, 7), " ")
		For $n = 1 To UBound($aArray) - 2
			Switch $aArray[$n]
				Case "--port"
					$iPort = Int($aArray[$n + 1])
				Case "--host"
					If $aArray[$n + 1] = "0.0.0.0" Then
						$sHost = "127.0.0.1"
					Else
						$sHost = $aArray[$n + 1]
					EndIf
			EndSwitch
		Next
		If $iPort = 0 Then $iPort = 8080 ; default
		If $sHost = "" Then $sHost = "127.0.0.1"
	EndIf
	Tray_SetIconIf(StringTrimRight(@ScriptFullPath, 4) & "_violet.ico", 204)
	Local $sRet = InetReadHttp("http://" & $sHost & ":" & $iPort & "/") ; $INET_FORCERELOAD + $INET_IGNORESSL + $INET_BINARYTRANSFER
	If Not @error Then
		AdlibUnRegister(IsOpenwebuiOnline)
		Tray_SetIconIf(StringTrimRight(@ScriptFullPath, 4) & ".ico", 0)
		If Not $g_Compiled Then ConsoleWriteWL(TimerDiff($hTimer) & ' to come online.' & @CRLF)
		Return 1
	EndIf
	If TimerDiff($hTimer) > $g_iIconForOnlineAtStart * 1000 Then
		AdlibUnRegister(IsOpenwebuiOnline)
		Tray_SetIconIf(StringTrimRight(@ScriptFullPath, 4) & "_red.ico", 201)
		Return 1
	EndIf
EndFunc   ;==>IsOpenwebuiOnline

Func InetReadHttp($sURL)
;~ 	Local $hTimer = TimerInit()
	Local $oHttp = ObjCreate("WinHttp.WinHttpRequest.5.1")
	$oHttp.Open("GET", $sURL, False)
	$oHttp.Send()
	If StringLen($g_ObjErr.description) Then
		$g_ObjErr.description("") ; got what I needed. Reset the value back to empty or it'll stay there next time
		Return SetError(1, 0, "")
	EndIf
	Return SetError(0, $oHttp.Status, $oHttp.ResponseText)
EndFunc   ;==>InetReadHttp

Func ObjErrCatcher()
	If Not $g_Compiled Then ConsoleWriteWL('ObjErrCatcher string = "' & $g_ObjErr.description & '"' & @CRLF, $g_ObjErr.scriptline)
	SetError(1)
EndFunc   ;==>ObjErrCatcher

#EndRegion "are we there yet"

#Region "added on v0.0.0.6"

Func ExtraCmds_IfCtrlIdExec($iCtrlId)
	For $n = 1 To $g_aExtraCmds[0][0]
		If $g_aExtraCmds[$n][$eExtCmd_CtrlID] = $iCtrlId Then
			Return ShellExecute($g_aExtraCmds[$n][$eExtCmd_filename], $g_aExtraCmds[$n][$eExtCmd_parameters], $g_aExtraCmds[$n][$eExtCmd_verb])
		EndIf
	Next
EndFunc   ;==>ExtraCmds_IfCtrlIdExec

Func ExtraCmds_GetFromIniAndAddToMenu()
	ConsoleWriteWL('Func ExtraCmds_GetFromIniAndAddToMenu()' & @CRLF)
	Local $n, $aSectionNames = IniReadSectionNames($g_sINI)
	Local $iIndex = 0, $aExtraCmds[UBound($aSectionNames) + 1][$eExtCmd_UBound]
	For $n = 1 To UBound($aSectionNames) - 1
		If Not StringInStr($aSectionNames[$n], "ExtraCmd") = 1 Then ContinueLoop
		If StringLen($aSectionNames[$n]) < 9 Then ContinueLoop
		ConsoleWriteWL('index #' & $n & @TAB & 'ExtraCmd #' & StringTrimLeft($aSectionNames[$n], 8) & @CRLF)
		$iIndex += 1
		$aExtraCmds[$iIndex][$eExtCmd_SectionName] = $aSectionNames[$n]
		$aExtraCmds[$iIndex][$eExtCmd_Show] = Int(IniReadOrInit($g_sINI, $aSectionNames[$n], "ShowExtraCmd", 0))
		$aExtraCmds[$iIndex][$eExtCmd_MenuText] = IniReadOrInit($g_sINI, $aSectionNames[$n], "MenuText", "")
		$aExtraCmds[$iIndex][$eExtCmd_filename] = IniReadOrInit($g_sINI, $aSectionNames[$n], "ShellExecute-filename", "")
		$aExtraCmds[$iIndex][$eExtCmd_parameters] = IniReadOrInit($g_sINI, $aSectionNames[$n], "ShellExecute-parameters", "")
		$aExtraCmds[$iIndex][$eExtCmd_workingdir] = IniReadOrInit($g_sINI, $aSectionNames[$n], "ShellExecute-workingdir", "")
		$aExtraCmds[$iIndex][$eExtCmd_verb] = IniReadOrInit($g_sINI, $aSectionNames[$n], "ShellExecute-verb", "")
		$aExtraCmds[$n][$eExtCmd_CtrlID] = 0
	Next
	ReDim $aExtraCmds[$iIndex + 1][$eExtCmd_UBound]
	$aExtraCmds[0][0] = $iIndex
	For $n = 1 To $aExtraCmds[0][0]
		If Not $aExtraCmds[$n][$eExtCmd_Show] Then ContinueLoop
		If Not StringLen($aExtraCmds[$n][$eExtCmd_filename]) Then ContinueLoop
		$aExtraCmds[$n][$eExtCmd_CtrlID] = TrayCreateItem($aExtraCmds[$n][$eExtCmd_MenuText])
		TrayCreateItem("") ; Create a separator line.
	Next
	Return SetError(0, $iIndex, $aExtraCmds)
EndFunc   ;==>ExtraCmds_GetFromIniAndAddToMenu

Func WinFind($sTitle = $g_sTitle, $sText = "", $iTimeoutSec = 0)
	Local $iWinTitleMatchMode = Opt("WinTitleMatchMode", 2)
	ConsoleWriteWL('+ Func WinFind("' & $sTitle & '", "' & $sText & '", ' & $iTimeoutSec & ')' & @CRLF)
	$iTimeoutSec *= 1000
	ConsoleWriteWL('- $iTimeoutSec = ' & $iTimeoutSec & @CRLF)
	Local $hTimer = TimerInit(), $n, $aWinList = WinList($sTitle, $sText)
	If Not $iTimeoutSec And UBound($aWinList) < 2 Then
		Opt("WinTitleMatchMode", $iWinTitleMatchMode)
		Return SetError(0, 0, 0)
	EndIf
	If UBound($aWinList) Then ReDim $aWinList[UBound($aWinList)][3]
	Do
		For $n = 1 To UBound($aWinList) - 1
			$aWinList[$n][2] = _WinAPI_GetClassName($aWinList[$n][1])
			If $aWinList[$n][2] = "AutoIt v3" Then ContinueLoop
			Opt("WinTitleMatchMode", $iWinTitleMatchMode)
			ConsoleWriteWL('- found >' & $aWinList[$n][0] & '< (' & $aWinList[$n][2] & ')' & @CRLF)
			Return SetError(0, $aWinList[0][0], $aWinList[$n][1])
		Next
		Sleep(500)
		$aWinList = WinList($sTitle, $sText)
		If UBound($aWinList) Then ReDim $aWinList[UBound($aWinList)][3]
	Until TimerDiff($hTimer) > $iTimeoutSec
	ConsoleWriteWL('WinFind() - $hTimer: ' & TimerDiff($hTimer) & @CRLF)
;~ 	_SQLite_Display2DResult($aWinList)
	Opt("WinTitleMatchMode", $iWinTitleMatchMode)
	Return SetError(1, $aWinList[0][0], 0)
EndFunc   ;==>WinFind

Func FindOpenwebuiPython($sSelfName, $sParentName, $sDefaultReturn = "")
	Local $aArray = ProcessList($sSelfName)
	If UBound($aArray) > 1 Then ReDim $aArray[UBound($aArray)][5]
	For $n = 1 To UBound($aArray) - 1
		$aArray[$n][2] = _WinAPI_GetParentProcess($aArray[$n][1])
		$aArray[$n][3] = _WinAPI_GetProcessFileName($aArray[$n][1])
		$aArray[$n][4] = _WinAPI_GetProcessFileName($aArray[$n][2])
		ConsoleWriteWL($aArray[$n][1] & @TAB & $aArray[$n][0] & @TAB & $aArray[$n][2] & @TAB & $aArray[$n][3] & @TAB & $aArray[$n][4] & @CRLF)
		If StringInStr($aArray[$n][4], $sParentName) Then
			ConsoleWriteWL(StringLeft($aArray[$n][3], StringInStr($aArray[$n][3], "\", 0, -1) - 1) & @CRLF)
			Return StringLeft($aArray[$n][3], StringInStr($aArray[$n][3], "\", 0, -1) - 1)
		EndIf

	Next
	Return $sDefaultReturn
EndFunc   ;==>FindOpenwebuiPython

#EndRegion "added on v0.0.0.6"
