#RequireAdmin
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=IconGroup99.ico
#AutoIt3Wrapper_Res_Comment=ImageSearch Test Suite by Dao Van Trong
#AutoIt3Wrapper_Res_Description=ImageSearch Test Suite v3.3
#AutoIt3Wrapper_Res_Fileversion=1.0.0.0
#AutoIt3Wrapper_Res_ProductName=ImageSearch Test Suite
#AutoIt3Wrapper_Res_ProductVersion=1.0.0.0
#AutoIt3Wrapper_Res_CompanyName=TRONG.PRO
#AutoIt3Wrapper_Res_LegalCopyright=Dao Van Trong - TRONG.PRO
#AutoIt3Wrapper_Res_requestedExecutionLevel=asInvoker
#AutoIt3Wrapper_UseX64=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#pragma compile(x64, true) ; false

#cs ----------------------------------------------------------------------------
	;
	;    Title .........: ImageSearch Test Suite v3.3
	;    AutoIt Version : 3.3.16.1+
	;    Author ........: Dao Van Trong (TRONG.PRO)
	;    UDF Version ...: 3.3
	;
	;    Note ..........: This script is a graphical user interface (GUI) front-end for the
	;                     ImageSearchDLL_UDF.au3 and its underlying ImageSearch.dll.
	;                     It allows for visual configuration of image search tasks on the screen
	;                     or within another image file, and now includes a file browser for
	;                     selecting existing images.
	;
	; -------------------------------------------------------------------------------------------------------------------------------
	; #SECTION# SCRIPT OVERVIEW
	; -------------------------------------------------------------------------------------------------------------------------------
	;
	; This enhanced script provides a powerful and user-friendly interface for performing complex image search and automation tasks.
	; It acts as a control panel for the high-performance ImageSearch UDF, allowing you to visually configure, execute,
	; and log search operations without writing complex code. It supports searching images on the screen or within another image.
	; NEW: Added "Browse" buttons to select existing image files instead of only capturing from screen.
	;
	; -------------------------------------------------------------------------------------------------------------------------------
	; #SECTION# FIRST-TIME SETUP
	; -------------------------------------------------------------------------------------------------------------------------------
	;
	; Before you can start a search, you need to provide the images you want to find.
	;
	; 1. RUN THE SCRIPT: The main window will appear. On the right side, you will see 12 empty "Image Target" slots.
	;
	; 2. CREATE OR SELECT AN IMAGE:
	;    - Click the "Create" button next to slot #1 to capture a region from the screen.
	;    - OR click the "Browse" button next to slot #1 to select an existing image file.
	;
	; 3. FOR CREATE: The script window will hide. Your mouse cursor will turn into a crosshair.
	;    Click and drag a rectangle around the object on the screen you want to find. When you release the mouse button,
	;    a bitmap image named "Search_1.bmp" will be saved in the same directory as the script.
	;
	; 4. FOR BROWSE: A file dialog will open allowing you to select BMP, JPG, PNG, or other image files.
	;    The selected image will be copied to the script directory as "Search_X.bmp".
	;
	; 5. PREVIEW UPDATES: The image you just captured/selected will now appear in the preview panel for that slot.
	;
	; 6. REPEAT: Repeat this process for any other images you need to find (up to 12).
	;
	; 7. IMAGE-IN-IMAGE SEARCH: To search within an image, select "Search in Image" mode, then specify a source image file
	;    using the "Browse Source Image" button.
	;
#ce ----------------------------------------------------------------------------

;~ ; === INCLUDES ===
;~ #include <Array.au3>
;~ #include <GDIPlus.au3>
;~ #include <ScreenCapture.au3>
;~ #include <WinAPI.au3>
;~ #include <WindowsConstants.au3>
;~ #include <GUIConstantsEx.au3>
;~ #include <EditConstants.au3>
;~ #include <StaticConstants.au3>
;~ #include <ButtonConstants.au3>
;~ #include <Date.au3>
;~ #include <Misc.au3>
;~ #include <Math.au3>
;~ #include <GuiEdit.au3>
;~ #include <GuiStatusBar.au3>
;~ #include <GuiComboBox.au3>
;~ #include <ComboConstants.au3>
;~ #include <File.au3>
Global Const $UBOUND_ROWS = 1
Global Const $UBOUND_COLUMNS = 2
Global Const $STR_NOCASESENSEBASIC = 2
Global Const $STR_STRIPLEADING = 1
Global Const $STR_STRIPTRAILING = 2
Global Const $GDIP_PXF24RGB = 0x00021808
Global Const $GDIP_EPGCOLORDEPTH = '{66087055-AD66-4C7C-9A18-38A2310B8337}'
Global Const $GDIP_EPGCOMPRESSION = '{E09D739D-CCD4-44EE-8EBA-3FBF8BE4FC58}'
Global Const $GDIP_EPGQUALITY = '{1D5BE4B5-FA4A-452D-9CDD-5DB35105E7EB}'
Global Const $GDIP_EPTLONG = 4
Global Const $GDIP_EVTCOMPRESSIONLZW = 2
Global Const $tagRECT = "struct;long Left;long Top;long Right;long Bottom;endstruct"
Global Const $tagSYSTEMTIME = "struct;word Year;word Month;word Dow;word Day;word Hour;word Minute;word Second;word MSeconds;endstruct"
Global Const $tagGDIPENCODERPARAM = "struct;byte GUID[16];ulong NumberOfValues;ulong Type;ptr Values;endstruct"
Global Const $tagGDIPENCODERPARAMS = "uint Count;" & $tagGDIPENCODERPARAM
Global Const $tagGDIPSTARTUPINPUT = "uint Version;ptr Callback;bool NoThread;bool NoCodecs"
Global Const $tagGDIPIMAGECODECINFO = "byte CLSID[16];byte FormatID[16];ptr CodecName;ptr DllName;ptr FormatDesc;ptr FileExt;" & "ptr MimeType;dword Flags;dword Version;dword SigCount;dword SigSize;ptr SigPattern;ptr SigMask"
Global Const $tagGUID = "struct;ulong Data1;ushort Data2;ushort Data3;byte Data4[8];endstruct"
Global Const $CREATE_NEW = 1
Global Const $CREATE_ALWAYS = 2
Global Const $OPEN_EXISTING = 3
Global Const $OPEN_ALWAYS = 4
Global Const $TRUNCATE_EXISTING = 5
Global Const $FILE_ATTRIBUTE_READONLY = 0x00000001
Global Const $FILE_ATTRIBUTE_HIDDEN = 0x00000002
Global Const $FILE_ATTRIBUTE_SYSTEM = 0x00000004
Global Const $FILE_ATTRIBUTE_ARCHIVE = 0x00000020
Global Const $FILE_SHARE_READ = 0x00000001
Global Const $FILE_SHARE_WRITE = 0x00000002
Global Const $FILE_SHARE_DELETE = 0x00000004
Global Const $GENERIC_EXECUTE = 0x20000000
Global Const $GENERIC_WRITE = 0x40000000
Global Const $GENERIC_READ = 0x80000000
Global Const $PROCESS_VM_OPERATION = 0x00000008
Global Const $PROCESS_VM_READ = 0x00000010
Global Const $PROCESS_VM_WRITE = 0x00000020
Global $__g_vEnum, $__g_vExt = 0
Global Const $__tagCURSORINFO = "dword Size;dword Flags;handle hCursor;" & "struct;long X;long Y;endstruct"
Global Const $tagICONINFO = "bool Icon;dword XHotSpot;dword YHotSpot;handle hMask;handle hColor"
Global $__g_hGDIPDll = 0
Global $__g_iGDIPRef = 0
Global $__g_iGDIPToken = 0
Global $__g_bGDIP_V1_0 = True
Global Const $LWA_ALPHA = 0x2
Global Const $LWA_COLORKEY = 0x1
Global Const $DATE_SHORTDATE = 0x01
Global Const $LOCALE_SDATE = 0x001D
Global Const $LOCALE_STIME = 0x001E
Global Const $LOCALE_SSHORTDATE = 0x001F
Global Const $LOCALE_SLONGDATE = 0x0020
Global Const $LOCALE_STIMEFORMAT = 0x1003
Global Const $LOCALE_S1159 = 0x0028
Global Const $LOCALE_S2359 = 0x0029
Global Const $LOCALE_INVARIANT = 0x007F
Global Const $LOCALE_USER_DEFAULT = 0x0400
Global $__g_iBMPFormat = $GDIP_PXF24RGB
Global $__g_iJPGQuality = 100
Global $__g_iTIFColorDepth = 24
Global $__g_iTIFCompression = $GDIP_EVTCOMPRESSIONLZW
Global Const $__SCREENCAPTURECONSTANT_SM_CXSCREEN = 0
Global Const $__SCREENCAPTURECONSTANT_SM_CYSCREEN = 1
Global Const $__SCREENCAPTURECONSTANT_SRCCOPY = 0x00CC0020
Global Const $SE_DEBUG_NAME = "SeDebugPrivilege"
Global Const $SE_PRIVILEGE_ENABLED = 0x00000002
Global Enum $SECURITYANONYMOUS = 0, $SECURITYIDENTIFICATION, $SECURITYIMPERSONATION, $SECURITYDELEGATION
Global Const $TOKEN_QUERY = 0x00000008
Global Const $TOKEN_ADJUST_PRIVILEGES = 0x00000020
Global Const $HGDI_ERROR = Ptr(-1)
Global Const $INVALID_HANDLE_VALUE = Ptr(-1)
Global Const $KF_EXTENDED = 0x0100
Global Const $KF_ALTDOWN = 0x2000
Global Const $KF_UP = 0x8000
Global Const $LLKHF_EXTENDED = BitShift($KF_EXTENDED, 8)
Global Const $LLKHF_ALTDOWN = BitShift($KF_ALTDOWN, 8)
Global Const $LLKHF_UP = BitShift($KF_UP, 8)
Global Const $MEM_COMMIT = 0x00001000
Global Const $MEM_RESERVE = 0x00002000
Global Const $PAGE_READWRITE = 0x00000004
Global Const $MEM_RELEASE = 0x00008000
Global Const $WS_VSCROLL = 0x00200000
Global Const $WS_POPUP = 0x80000000
Global Const $WS_EX_LAYERED = 0x00080000
Global Const $WS_EX_TOOLWINDOW = 0x00000080
Global Const $WS_EX_TOPMOST = 0x00000008
Global Const $GUI_EVENT_CLOSE = -3
Global Const $GUI_CHECKED = 1
Global Const $GUI_UNCHECKED = 4
Global Const $GUI_ENABLE = 64
Global Const $GUI_DISABLE = 128
Global Const $ES_MULTILINE = 4
Global Const $ES_AUTOVSCROLL = 64
Global Const $ES_READONLY = 2048
Global Const $EM_SETSEL = 0xB1
Global Const $GUI_SS_DEFAULT_INPUT = 0x00000080
Global Const $SS_LEFT = 0x0
Global Const $SS_RIGHT = 0x2
Global Const $BS_DEFPUSHBUTTON = 0x0001
Global Const $DMW_SHORTNAME = 1
Global Const $DMW_LOCALE_LONGNAME = 2
Global Const $tagMEMMAP = "handle hProc;ulong_ptr Size;ptr Mem"
Global Const $VK_SHIFT = 0x10
Global Const $VK_CONTROL = 0x11
Global Const $VK_MENU = 0x12
Global Const $VK_LWIN = 0x5B
Global Const $VK_RWIN = 0x5C
Global Const $__GUICTRL_IDS_OFFSET = 2
Global Const $__GUICTRL_ID_MAX_WIN = 16
Global Const $__GUICTRL_STARTID = 10000
Global Const $__GUICTRL_ID_MAX_IDS = 65535 - $__GUICTRL_STARTID
Global Const $__GUICTRLCONSTANT_WS_VISIBLE = 0x10000000
Global Const $__GUICTRLCONSTANT_WS_CHILD = 0x40000000
Global $__g_hGUICtrl_LastWnd
Global $__g_aGUICtrl_IDs_Used[$__GUICTRL_ID_MAX_WIN][$__GUICTRL_ID_MAX_IDS + $__GUICTRL_IDS_OFFSET + 1]
Global Const $__STATUSBARCONSTANT_WM_USER = 0X400
Global Const $SB_GETUNICODEFORMAT = 0x2000 + 6
Global Const $SB_ISSIMPLE = ($__STATUSBARCONSTANT_WM_USER + 14)
Global Const $SB_SETPARTS = ($__STATUSBARCONSTANT_WM_USER + 4)
Global Const $SB_SETTEXTA = ($__STATUSBARCONSTANT_WM_USER + 1)
Global Const $SB_SETTEXTW = ($__STATUSBARCONSTANT_WM_USER + 11)
Global Const $SB_SETTEXT = $SB_SETTEXTA
Global Const $SB_SIMPLEID = 0xff
Global $__g_tSBBuffer, $__g_tSBBufferANSI
Global Const $__STATUSBARCONSTANT_ClassName = "msctls_statusbar32"
Global Const $__STATUSBARCONSTANT_WM_SIZE = 0x05
Global Const $CBS_AUTOHSCROLL = 0x40
Global Const $CBS_DROPDOWNLIST = 0x3
Global Const $CB_SETCURSEL = 0x14E
Global Const $IMGS_UDF_VERSION = '3.3'
Global Const $IMGS_RESULTS_MAX = 64
Global Const $iSleepTime = 100
Global Const $g_IMGS_Debug = @Compiled ? False : True
Global Const $IMGS_ENABLED_CACHE = 1
Global Const $IMGSE_FAILED_TO_GET_SCREEN_DC = -3
Global Const $IMGSE_INVALID_SEARCH_REGION = -4
Global Const $IMGSE_INVALID_PARAMETERS = -5
Global Const $IMGSE_INVALID_SOURCE_BITMAP = -6
Global Const $IMGSE_RESULT_TOO_LARGE = -9
Global $g_bImageSearch_Debug = $g_IMGS_Debug
Global $g_sImgSearchDLL_Path = ""
Global $g_hImageSearchDLL = -1
Global $g_bImageSearch_Initialized = False
Global $g_sLastDllReturn = ""
Global $g_sImgSearchDLL_Dir = @ScriptDir
Global $g_sImgSearchDLL_CustomPath = ""
Global $g_bImageSearch_UseEmbeddedDLL = False
Global $g_sImgSearch_TempDLLPath = ""
Global $g_aMonitorList[1][9]
If _Singleton("LiteON-Tools", 1) = 0 Then
	MsgBox(48 + 262144, "ImageSearchDLL TestSuite", "An occurrence of test is already running!" & @CRLF & "App đang chạy rồi nhé !", 1)
	Exit -1
EndIf
Func _Singleton($soccurrencename, $iflag = 0)
	Local Const $error_already_exists = 183
	Local Const $security_descriptor_revision = 1
	Local $tsecurityattributes = 0
	If BitAND($iflag, 2) Then
		Local $tsecuritydescriptor = DllStructCreate("byte;byte;word;ptr[4]")
		Local $aCall = DllCall("advapi32.dll", "bool", "InitializeSecurityDescriptor", "struct*", $tsecuritydescriptor, "dword", $security_descriptor_revision)
		If @error Then Return SetError(@error, @extended, 0)
		If $aCall[0] Then
			$aCall = DllCall("advapi32.dll", "bool", "SetSecurityDescriptorDacl", "struct*", $tsecuritydescriptor, "bool", 1, "ptr", 0, "bool", 0)
			If @error Then Return SetError(@error, @extended, 0)
			If $aCall[0] Then
				$tsecurityattributes = DllStructCreate("dword Length;ptr Descriptor;bool InheritHandle")
				DllStructSetData($tsecurityattributes, 1, DllStructGetSize($tsecurityattributes))
				DllStructSetData($tsecurityattributes, 2, DllStructGetPtr($tsecuritydescriptor))
				DllStructSetData($tsecurityattributes, 3, 0)
			EndIf
		EndIf
	EndIf
	Local $ahandle = DllCall("kernel32.dll", "handle", "CreateMutexW", "struct*", $tsecurityattributes, "bool", 1, "wstr", $soccurrencename)
	If @error Then Return SetError(@error, @extended, 0)
	Local $alasterror = DllCall("kernel32.dll", "dword", "GetLastError")
	If @error Then Return SetError(@error, @extended, 0)
	If $alasterror[0] = $error_already_exists Then
		If BitAND($iflag, 1) Then
			DllCall("kernel32.dll", "bool", "CloseHandle", "handle", $ahandle[0])
			If @error Then Return SetError(@error, @extended, 0)
			Return SetError($alasterror[0], $alasterror[0], 0)
		Else
			Exit -1
		EndIf
	EndIf
	Return $ahandle[0]
EndFunc   ;==>_Singleton

If @AutoItX64 Then
	FileInstall('_DLL_\ImageSearchDLL_x64.dll', @ScriptDir & '\ImageSearchDLL_x64.dll', 0)
Else
	FileInstall('_DLL_\ImageSearchDLL_x86.dll', @ScriptDir & '\ImageSearchDLL_x86.dll', 0)
EndIf
_ImageSearch_Startup()
Global Const $MAX_IMAGES = 12
Global Const $g_sImgEmptySlots = @TempDir & "\" & 'Default_UIF.jpg'
Global Const $g_sPlaceholderPath = _Deploy_ImgEmptySlots() ? $g_sImgEmptySlots : @WindowsDir & "\Web\Wallpaper\Windows\img0.jpg"
Global $g_asImagePaths[$MAX_IMAGES]
Global $g_nMsg
Global $g_hMainGUI
Global $g_hLog
Global $g_hStatusBar
Global $g_idBtnStart, $g_idBtnSelectAll, $g_idBtnDeselectAll, $g_idBtnSelectArea, $g_idSystemInfo
Global $g_idInputDelay, $g_idChkMoveMouse
Global $g_idRadNoClick, $g_idRadSingleClick, $g_idRadDoubleClick
Global $g_idChkWait, $g_idInputWaitTime
Global $g_idChkUseArea, $g_idInputLeft, $g_idInputTop, $g_idInputRight, $g_idInputBottom
Global $g_idChkMultiSearch, $g_idChkFindAll, $g_idChkUseTolerance, $g_idInputTolerance, $g_idChkEnableDebug, $g_idChkUseCache
Global $g_aidPic[$MAX_IMAGES], $g_aidChkSearch[$MAX_IMAGES], $g_aidBtnCreate[$MAX_IMAGES], $g_aidBtnBrowse[$MAX_IMAGES]
Global $g_idRadSearchOnScreen, $g_idRadSearchInImage, $g_idInputSourceImage, $g_idBtnBrowseSource
Global $g_idChkUseSpecificMonitor, $g_idComboMonitor
Global $g_iMonitorCount = 0
_Main()
Func _Main()
	If Not _ImageSearch_Startup() Then
		MsgBox(16, "Fatal Error", "Failed to initialize the ImageSearch DLL. @error: " & @error & @CRLF & "The script will now exit.")
		Exit
	EndIf
	_GDIPlus_Startup()
	_InitializeImagePaths()
	_EnumerateMonitors()
	_CreateGUI()
	_UpdateAllImagePreviews()
	_RefreshImageTooltips()
	While 1
		$g_nMsg = GUIGetMsg()
		Switch $g_nMsg
			Case $GUI_EVENT_CLOSE
				Exit
			Case $g_idRadSearchInImage, $g_idRadSearchOnScreen
				_UpdateSearchModeControls()
			Case $g_idChkUseSpecificMonitor
				_UpdateMonitorControls()
			Case $g_idBtnStart
				_ExecuteSearch()
			Case $g_idBtnSelectAll
				_SelectAll(True)
			Case $g_idBtnDeselectAll
				_SelectAll(False)
			Case $g_idBtnSelectArea
				_SelectAreaOnScreen()
			Case $g_idBtnBrowseSource
				_BrowseSourceImage()
			Case $g_aidBtnCreate[0] To $g_aidBtnCreate[$MAX_IMAGES - 1]
				_HandleImageCreation($g_nMsg)
			Case $g_aidBtnBrowse[0] To $g_aidBtnBrowse[$MAX_IMAGES - 1]
				_HandleImageBrowse($g_nMsg)
		EndSwitch
	WEnd
	_Exit()
EndFunc   ;==>_Main
Func _InitializeImagePaths()
	For $i = 0 To $MAX_IMAGES - 1
		$g_asImagePaths[$i] = @ScriptDir & "\Search_" & $i + 1 & ".bmp"
	Next
EndFunc   ;==>_InitializeImagePaths
Func _EnumerateMonitors()
	_ImageSearch_Monitor_GetList()
	$g_iMonitorCount = $g_aMonitorList[0][0]
	If $g_bImageSearch_Debug Then
		ConsoleWrite("Detected " & $g_iMonitorCount & " monitor(s)" & @CRLF)
		For $i = 1 To $g_iMonitorCount
			Local $sInfo = "Monitor " & $i & ": " & $g_aMonitorList[$i][5] & "x" & $g_aMonitorList[$i][6]
			If $g_aMonitorList[$i][7] Then $sInfo &= " (Primary)"
			ConsoleWrite("  " & $sInfo & @CRLF)
		Next
	EndIf
EndFunc   ;==>_EnumerateMonitors
Func _PopulateMonitorCombo()
	If $g_iMonitorCount = 0 Then Return
	Local $sMonitorList = ""
	For $i = 1 To $g_iMonitorCount
		Local $sLabel = "Monitor " & $i
		If $g_aMonitorList[$i][7] Then $sLabel &= " (Primary)"
		$sLabel &= " - " & $g_aMonitorList[$i][5] & "x" & $g_aMonitorList[$i][6]
		$sMonitorList &= ($i > 1 ? "|" : "") & $sLabel
	Next
	GUICtrlSetData($g_idComboMonitor, $sMonitorList)
	For $i = 1 To $g_iMonitorCount
		If $g_aMonitorList[$i][7] Then
			_GUICtrlComboBox_SetCurSel($g_idComboMonitor, $i - 1)
			Return
		EndIf
	Next
	_GUICtrlComboBox_SetCurSel($g_idComboMonitor, 0)
EndFunc   ;==>_PopulateMonitorCombo
Func _CreateSlot(ByRef $aChk, ByRef $aPic, ByRef $aBtnCreate, ByRef $aBtnBrowse, $idx, $col, $row, $baseLeft, $baseTop, $colSpacing, $rowSpacing, $slotGroupW, $slotGroupH, $slotChkW, $slotChkH, $slotPicW, $slotPicH, $slotBtnW, $slotBtnH)
	Local $leftGroup = $baseLeft + ($col * $colSpacing)
	Local $topGroup = $baseTop + ($row * $rowSpacing)
	GUICtrlCreateGroup("Slot " & ($idx + 1), $leftGroup, $topGroup, $slotGroupW, $slotGroupH)
	Local $ox_chk = 5, $oy_chk = 13
	Local $ox_pic = 10, $oy_pic = 36
	Local $ox_btnCreate = 5, $oy_btnCreate = 142
	Local $ox_btnBrowse = $ox_btnCreate + $slotBtnW + 6
	$aChk[$idx] = GUICtrlCreateCheckbox("Search", $leftGroup + $ox_chk, $topGroup + $oy_chk, $slotChkW, $slotChkH)
	$aPic[$idx] = GUICtrlCreatePic("", $leftGroup + $ox_pic, $topGroup + $oy_pic, $slotPicW, $slotPicH)
	GUICtrlSetState(-1, $GUI_DISABLE)
	$aBtnCreate[$idx] = GUICtrlCreateButton("Create", $leftGroup + $ox_btnCreate, $topGroup + $oy_btnCreate, $slotBtnW, $slotBtnH)
	GUICtrlSetTip(-1, "Capture an image from the screen for slot " & ($idx + 1) & ".")
	$aBtnBrowse[$idx] = GUICtrlCreateButton("Browse", $leftGroup + $ox_btnBrowse, $topGroup + $oy_btnCreate, $slotBtnW, $slotBtnH)
	GUICtrlSetTip(-1, "Select an existing image file for slot " & ($idx + 1) & ".")
	GUICtrlCreateGroup("", -99, -99, 1, 1)
EndFunc   ;==>_CreateSlot
Func _CreateGUI()
	Local $winW = 1024, $winH = 791
	Local $cfgX = 10, $cfgY = 2, $cfgW = 460, $cfgH = 350
	Local $smX = 20, $smY = 22, $smW = 210, $smH = 310
	Local $smInnerX = 30, $smInnerY = 42
	Local $inputSourceW = 196, $inputSourceH = 23
	Local $btnBrowseX = 167, $btnBrowseY = 76, $btnBrowseW = 55, $btnBrowseH = 23
	Local $paramX = 240, $paramY = 22, $paramW = 220, $paramH = 120
	Local $labelW = 90, $labelH = 20
	Local $inputW = 80, $inputH = 23
	Local $actX = 240, $actY = 152, $actW = 220, $actH = 132
	Local $actLabelW = 40, $actLabelH = 20
	Local $actRadioW = 60, $actRadioH = 20
	Local $areaX = 10, $areaY = 356, $areaW = 460, $areaH = 80
	Local $areaChkX = 23, $areaChkY = 373, $areaChkW = 150, $areaChkH = 20
	Local $areaLabelW = 45, $areaLabelH = 20
	Local $areaInputW = 35, $areaInputH = 23
	Local $btnSelectAreaX = 191, $btnSelectAreaY = 373, $btnSelectAreaW = 268, $btnSelectAreaH = 25
	Local $imgX = 474, $imgY = 10, $imgW = 556, $imgH = 546
	Local $slotGroupW = 127, $slotGroupH = 172
	Local $slotChkW = 100, $slotChkH = 20
	Local $slotPicW = 100, $slotPicH = 100
	Local $slotBtnW = 55, $slotBtnH = 22
	Local $logX = 10, $logY = 604, $logW = 1008, $logH = 158
	Local $logEditX = 15, $logEditY = 619, $logEditW = 1000, $logEditH = 136
	Local $sysX = 10, $sysY = 440, $sysW = 460, $sysH = 160
	Local $sysLabelW = 440, $sysLabelH = 20
	Local $sysInfoLabelH = 40
	Local $btnSelectAllX = 477, $btnSelectAllY = 560, $btnSelectAllW = 100, $btnSelectAllH = 38
	Local $btnStartX = 580, $btnStartY = 560, $btnStartW = 324, $btnStartH = 38
	Local $btnDeselectAllX = 912, $btnDeselectAllY = 560, $btnDeselectAllW = 100, $btnDeselectAllH = 38
	$g_hMainGUI = GUICreate("ImageSearch Automation by Dao Van Trong - TRONG.PRO", $winW, $winH)
	GUISetFont(9, 400, 0, "Segoe UI", $g_hMainGUI, 5)
	GUISetBkColor(0xF3F3F3, $g_hMainGUI)
	GUICtrlCreateGroup("Configuration", $cfgX, $cfgY, $cfgW, $cfgH)
	GUICtrlCreateGroup("Search Mode", $smX, $smY, $smW, $smH)
	$g_idRadSearchOnScreen = GUICtrlCreateRadio("Search on All Screens", $smInnerX, $smInnerY, 180, 20)
	GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetTip(-1, "Search across all monitors (virtual desktop)")
	$g_idChkUseSpecificMonitor = GUICtrlCreateCheckbox("Use Specific Monitor", $smInnerX + 10, $smInnerY + 25, 160, 20)
	GUICtrlSetTip(-1, "Search on a specific monitor only (2-3x faster!)")
	$g_idComboMonitor = GUICtrlCreateCombo("", $smInnerX + 10, $smInnerY + 50, 180, 25, BitOR($CBS_DROPDOWNLIST, $CBS_AUTOHSCROLL))
	GUICtrlSetTip(-1, "Select which monitor to search on")
	GUICtrlSetState($g_idComboMonitor, $GUI_DISABLE)
	_PopulateMonitorCombo()
	$g_idRadSearchInImage = GUICtrlCreateRadio("Search in Image", $smInnerX, $smInnerY + 85, 132, 20)
	GUICtrlSetTip(-1, "Search for images within a specified source image file.")
	$g_idInputSourceImage = GUICtrlCreateInput("", $smInnerX, $smInnerY + 115, $inputSourceW, $inputSourceH, BitOR($GUI_SS_DEFAULT_INPUT, $ES_READONLY))
	$g_idBtnBrowseSource = GUICtrlCreateButton("Browse", $btnBrowseX, $smInnerY + 115, $btnBrowseW, $btnBrowseH)
	GUICtrlSetTip(-1, "Select the source image file to search within.")
	$g_idChkMultiSearch = GUICtrlCreateCheckbox("Multi Search (All at once)", $smInnerX, $smInnerY + 150, 200, 20)
	GUICtrlSetTip(-1, "Finds the FIRST occurrence of ANY of the selected images.")
	$g_idChkFindAll = GUICtrlCreateCheckbox("Find All Occurrences", $smInnerX, $smInnerY + 175, 200, 20)
	GUICtrlSetState(-1, $GUI_CHECKED)
	$g_idChkWait = GUICtrlCreateCheckbox("Wait for Image Found", $smInnerX, $smInnerY + 200, 200, 20)
	$g_idChkUseTolerance = GUICtrlCreateCheckbox("Use Tolerance", $smInnerX, $smInnerY + 225, 200, 20)
	GUICtrlSetState(-1, $GUI_CHECKED)
	$g_idChkEnableDebug = GUICtrlCreateCheckbox("Enable DLL Debug", $smInnerX, $smInnerY + 250, 200, 20)
	If Not @Compiled Then GUICtrlSetState(-1, $GUI_CHECKED)
	$g_idChkUseCache = GUICtrlCreateCheckbox("Enable Cache (v3.3)", $smInnerX, $smInnerY + 275, 200, 20)
	GUICtrlSetTip(-1, "Enable persistent cache for 30-50% speed boost on repeated searches")
	GUICtrlCreateGroup("", -99, -99, 1, 1)
	GUICtrlCreateGroup("Parameters", $paramX, $paramY, $paramW, $paramH)
	GUICtrlCreateLabel("Timeout (ms):", $paramX + 10, $paramY + 22, $labelW, $labelH, $SS_RIGHT)
	$g_idInputWaitTime = GUICtrlCreateInput("5000", $paramX + 115, $paramY + 20, $inputW, $inputH)
	GUICtrlCreateLabel("Tolerance:", $paramX + 10, $paramY + 52, $labelW, $labelH, $SS_RIGHT)
	$g_idInputTolerance = GUICtrlCreateInput("10", $paramX + 115, $paramY + 50, $inputW, $inputH)
	GUICtrlCreateLabel("Delay (ms)", $paramX + 10, $paramY + 82, $labelW, $labelH, $SS_RIGHT)
	$g_idInputDelay = GUICtrlCreateInput("500", $paramX + 115, $paramY + 80, $inputW, $inputH)
	GUICtrlCreateGroup("", -99, -99, 1, 1)
	GUICtrlCreateGroup("Actions on Found", $actX, $actY, $actW, $actH)
	$g_idChkMoveMouse = GUICtrlCreateCheckbox("Move Mouse", $actX + 10, $actY + 20, 120, 20)
	GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlCreateLabel("Click:", $actX + 10, $actY + 45, $actLabelW, $actLabelH)
	$g_idRadNoClick = GUICtrlCreateRadio("None", $actX + 65, $actY + 45, $actRadioW, $actRadioH)
	GUICtrlSetState(-1, $GUI_CHECKED)
	$g_idRadSingleClick = GUICtrlCreateRadio("Single", $actX + 10, $actY + 70, $actRadioW, $actRadioH)
	$g_idRadDoubleClick = GUICtrlCreateRadio("Double", $actX + 70, $actY + 70, $actRadioW, $actRadioH)
	GUICtrlCreateGroup("", -99, -99, 1, 1)
	GUICtrlCreateGroup("Search Area", $areaX, $areaY, $areaW, $areaH)
	$g_idChkUseArea = GUICtrlCreateCheckbox("Use Custom Area", $areaChkX, $areaChkY, $areaChkW, $areaChkH)
	GUICtrlCreateLabel("Left:", $areaX + 13, $areaY + 50, $areaLabelW, $areaLabelH)
	$g_idInputLeft = GUICtrlCreateInput("0", $areaX + 58, $areaY + 48, $areaInputW, $areaInputH)
	GUICtrlCreateLabel("Top:", $areaX + 135, $areaY + 50, $areaLabelW, $areaLabelH)
	$g_idInputTop = GUICtrlCreateInput("0", $areaX + 175, $areaY + 48, $areaInputW, $areaInputH)
	GUICtrlCreateLabel("Right:", $areaX + 252, $areaY + 50, $areaLabelW, $areaLabelH)
	$g_idInputRight = GUICtrlCreateInput(@DesktopWidth, $areaX + 297, $areaY + 48, $areaInputW, $areaInputH)
	GUICtrlCreateLabel("Bottom:", $areaX + 374, $areaY + 50, $areaLabelW, $areaLabelH)
	$g_idInputBottom = GUICtrlCreateInput(@DesktopHeight, $areaX + 420, $areaY + 48, $areaInputW, $areaInputH)
	$g_idBtnSelectArea = GUICtrlCreateButton("Select Area on Screen", $btnSelectAreaX, $btnSelectAreaY, $btnSelectAreaW, $btnSelectAreaH)
	GUICtrlCreateGroup("", -99, -99, 1, 1)
	GUICtrlCreateGroup("Image Targets", $imgX, $imgY, $imgW, $imgH)
	Local $baseLeft = 479, $baseTop = 27
	Local $colSpacing = 135
	Local $rowSpacing = 172
	Dim $g_aidChkSearch[12], $g_aidPic[12], $g_aidBtnCreate[12], $g_aidBtnBrowse[12]
	Local $idx = 0
	For $r = 0 To 2
		For $c = 0 To 3
			_CreateSlot($g_aidChkSearch, $g_aidPic, $g_aidBtnCreate, $g_aidBtnBrowse, $idx, $c, $r, $baseLeft, $baseTop, $colSpacing, $rowSpacing, $slotGroupW, $slotGroupH, $slotChkW, $slotChkH, $slotPicW, $slotPicH, $slotBtnW, $slotBtnH)
			$idx += 1
		Next
	Next
	GUICtrlCreateGroup("Activity Log", $logX, $logY, $logW, $logH)
	$g_hLog = GUICtrlCreateEdit("", $logEditX, $logEditY, $logEditW, $logEditH, BitOR($ES_MULTILINE, $ES_READONLY, $WS_VSCROLL, $ES_AUTOVSCROLL))
	GUICtrlSetFont(-1, 9, 0, 0, "Segoe UI")
	GUICtrlCreateGroup("", -99, -99, 1, 1)
	GUICtrlCreateGroup("System Information", $sysX, $sysY, $sysW, $sysH)
	GUICtrlCreateLabel("OS: " & @OSVersion & " (" & @OSArch & ")" & "   |   AutoIt: " & @AutoItVersion & (@AutoItX64 ? " (x64)" : ""), $sysX + 10, $sysY + 20, $sysLabelW, $sysLabelH)
	GUICtrlCreateLabel("UDF Version: " & $IMGS_UDF_VERSION & "   |   DLL: " & StringMid(_ImageSearch_GetVersion(),1,56)&' ...', $sysX + 10, $sysY + 45, $sysLabelW + 20, $sysLabelH)
	GUICtrlCreateLabel("DLL Path: " & StringMid($g_sImgSearchDLL_Path,1,65)&' ...', $sysX + 10, $sysY + 70, $sysLabelW + 20, $sysLabelH)
	GUICtrlCreateLabel("Screen: " & @DesktopWidth & "x" & @DesktopHeight & "   |   Monitors: " & $g_iMonitorCount, $sysX + 10, $sysY + 95, $sysLabelW, $sysLabelH)
	$g_idSystemInfo = GUICtrlCreateLabel("System: " & _ImageSearch_GetSysInfo(), $sysX + 10, $sysY + 120, $sysLabelW, $sysInfoLabelH, $SS_LEFT)
	GUICtrlCreateGroup("", -99, -99, 1, 1)
	$g_idBtnSelectAll = GUICtrlCreateButton("Select All", $btnSelectAllX, $btnSelectAllY, $btnSelectAllW, $btnSelectAllH)
	$g_idBtnStart = GUICtrlCreateButton("Start Search", $btnStartX, $btnStartY, $btnStartW, $btnStartH, $BS_DEFPUSHBUTTON)
	GUICtrlSetFont(-1, 12, 800, 0, "Segoe UI")
	$g_idBtnDeselectAll = GUICtrlCreateButton("Deselect All", $btnDeselectAllX, $btnDeselectAllY, $btnDeselectAllW, $btnDeselectAllH)
	$g_hStatusBar = _GUICtrlStatusBar_Create($g_hMainGUI)
	_UpdateStatus("Ready - ImageSearch Test Suite v3.3")
	GUISetState(@SW_SHOW)
	_UpdateSearchModeControls()
	_LogWrite("═══════════════════════════════════════════════════════════")
	_LogWrite("ImageSearch Test Suite v3.3 - Initialized Successfully")
	_LogWrite("UDF Version: " & $IMGS_UDF_VERSION & "  |  DLL: " & _ImageSearch_GetVersion())
	_LogWrite("Detected " & $g_iMonitorCount & " monitor(s)")
	If $g_iMonitorCount > 0 Then
		For $i = 1 To $g_iMonitorCount
			Local $sMonInfo = "  Monitor " & $i & ": " & $g_aMonitorList[$i][5] & "x" & $g_aMonitorList[$i][6]
			If $g_aMonitorList[$i][7] Then $sMonInfo &= " (Primary)"
			_LogWrite($sMonInfo)
		Next
	EndIf
	_LogWrite("═══════════════════════════════════════════════════════════")
	_LogWrite("Ready to search. Select images and click 'Start Search'")
EndFunc   ;==>_CreateGUI
Func _UpdateGUI_SystemInfo()
	GUICtrlSetData($g_idSystemInfo, "System Info: " & _ImageSearch_GetSysInfo())
EndFunc   ;==>_UpdateGUI_SystemInfo
Func _UpdateSearchModeControls()
	Local $bIsScreenSearch = __IsChecked($g_idRadSearchOnScreen)
	GUICtrlSetState($g_idInputSourceImage, ($bIsScreenSearch ? $GUI_DISABLE : $GUI_ENABLE))
	GUICtrlSetState($g_idBtnBrowseSource, ($bIsScreenSearch ? $GUI_DISABLE : $GUI_ENABLE))
	GUICtrlSetState($g_idChkMoveMouse, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idRadNoClick, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idRadSingleClick, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idRadDoubleClick, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idChkUseArea, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idInputLeft, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idInputTop, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idInputRight, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idInputBottom, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idBtnSelectArea, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idChkWait, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idInputWaitTime, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	GUICtrlSetState($g_idChkUseSpecificMonitor, ($bIsScreenSearch ? $GUI_ENABLE : $GUI_DISABLE))
	If Not $bIsScreenSearch Then
		GUICtrlSetState($g_idComboMonitor, $GUI_DISABLE)
	Else
		_UpdateMonitorControls()
	EndIf
EndFunc   ;==>_UpdateSearchModeControls
Func _UpdateMonitorControls()
	Local $bScreenSearch = __IsChecked($g_idRadSearchOnScreen)
	Local $bUseSpecific = __IsChecked($g_idChkUseSpecificMonitor)
	If $bScreenSearch And $bUseSpecific Then
		GUICtrlSetState($g_idComboMonitor, $GUI_ENABLE)
	Else
		GUICtrlSetState($g_idComboMonitor, $GUI_DISABLE)
	EndIf
EndFunc   ;==>_UpdateMonitorControls
Func _HandleImageCreation($iControlID)
	For $i = 0 To $MAX_IMAGES - 1
		If $g_aidBtnCreate[$i] = $iControlID Then
			GUISetState(@SW_HIDE, $g_hMainGUI)
			_UpdateStatus("Capturing image for slot " & ($i + 1) & "...")
			Local $iResult = _CaptureRegion_free($g_asImagePaths[$i])
			GUISetState(@SW_SHOW, $g_hMainGUI)
			If $iResult = 0 Then
				_LogWrite("Captured image for slot " & ($i + 1) & ": " & $g_asImagePaths[$i])
				_UpdateSingleImagePreview($i)
				_RefreshImageTooltips()
				_UpdateStatus("Image captured for slot " & ($i + 1))
			ElseIf $iResult = -2 Then
				_LogWrite("Image capture cancelled for slot " & ($i + 1))
				_UpdateStatus("Capture cancelled")
			Else
				_LogWrite("ERROR: Failed to capture image for slot " & ($i + 1))
				_UpdateStatus("Capture failed")
			EndIf
			ExitLoop
		EndIf
	Next
EndFunc   ;==>_HandleImageCreation
Func _HandleImageBrowse($iControlID)
	For $i = 0 To $MAX_IMAGES - 1
		If $g_aidBtnBrowse[$i] = $iControlID Then
			Local $sFile = FileOpenDialog("Select Image for Slot " & ($i + 1), @ScriptDir, "Images (*.bmp;*.jpg;*.jpeg;*.png;*.gif)", 1)
			If @error Or Not _ValidateImageFile($sFile) Then
				_LogWrite("ERROR: Invalid or no image selected for slot " & ($i + 1))
				_UpdateStatus("Invalid image selected")
				Return
			EndIf
			If FileExists($g_asImagePaths[$i]) Then FileDelete($g_asImagePaths[$i])
			If FileCopy($sFile, $g_asImagePaths[$i], 1) Then
				_LogWrite("Selected image for slot " & ($i + 1) & ": " & $g_asImagePaths[$i])
				_UpdateSingleImagePreview($i)
				_RefreshImageTooltips()
				_UpdateStatus("Image selected for slot " & ($i + 1))
			Else
				_LogWrite("ERROR: Failed to copy image for slot " & ($i + 1))
				_UpdateStatus("Failed to copy image")
			EndIf
			ExitLoop
		EndIf
	Next
EndFunc   ;==>_HandleImageBrowse
Func _BrowseSourceImage()
	Local $sFile = FileOpenDialog("Select Source Image", @ScriptDir, "Images (*.bmp;*.jpg;*.jpeg;*.png;*.gif)", 1)
	If @error Or Not _ValidateImageFile($sFile) Then
		_LogWrite("ERROR: Invalid or no source image selected.")
		_UpdateStatus("Invalid source image")
		Return
	EndIf
	GUICtrlSetData($g_idInputSourceImage, $sFile)
	_LogWrite("Selected source image: " & $sFile)
	_UpdateStatus("Source image selected")
EndFunc   ;==>_BrowseSourceImage
Func _ExecuteSearch()
	_UpdateGUI_SystemInfo()
	Local $bMultiSearch = __IsChecked($g_idChkMultiSearch)
	Local $bFindAll = __IsChecked($g_idChkFindAll)
	Local $bWait = __IsChecked($g_idChkWait)
	Local $bUseTolerance = __IsChecked($g_idChkUseTolerance)
	Local $bEnableDebug = __IsChecked($g_idChkEnableDebug)
	Local $bUseCache = __IsChecked($g_idChkUseCache)
	Local $bUseArea = __IsChecked($g_idChkUseArea)
	Local $bMoveMouse = __IsChecked($g_idChkMoveMouse)
	Local $bSearchInImage = __IsChecked($g_idRadSearchInImage)
	Local $iTimeout = Number(GUICtrlRead($g_idInputWaitTime))
	Local $iTolerance = ($bUseTolerance ? Number(GUICtrlRead($g_idInputTolerance)) : 0)
	Local $iDelay = Number(GUICtrlRead($g_idInputDelay))
	Local $iLeft = ($bUseArea ? Number(GUICtrlRead($g_idInputLeft)) : 0)
	Local $iTop = ($bUseArea ? Number(GUICtrlRead($g_idInputTop)) : 0)
	Local $iRight = ($bUseArea ? Number(GUICtrlRead($g_idInputRight)) : 0)
	Local $iBottom = ($bUseArea ? Number(GUICtrlRead($g_idInputBottom)) : 0)
	Local $iScreen = -1
	Local $bUseSpecificMonitor = __IsChecked($g_idChkUseSpecificMonitor)
	If $bUseSpecificMonitor And Not $bSearchInImage Then
		Local $sMonitorText = GUICtrlRead($g_idComboMonitor)
		Local $aMatch = StringRegExp($sMonitorText, "Monitor (\d+)", 1)
		If Not @error And IsArray($aMatch) Then
			$iScreen = Number($aMatch[0])
			_LogWrite("Using specific monitor: " & $iScreen & " (faster search)")
		EndIf
	EndIf
	Local $iUseCache = $bUseCache ? $IMGS_ENABLED_CACHE : 0
	If $bUseCache Then _LogWrite("Cache enabled for performance boost")
	Local $iCenterPOS = 1
	Local $fMinScale = 1.0, $fMaxScale = 1.0, $fScaleStep = 0.1
	Local $iReturnDebug = ($bEnableDebug ? 1 : 0)
	Local $sClickType = (__IsChecked($g_idRadSingleClick) ? "single" : (__IsChecked($g_idRadDoubleClick) ? "double" : "none"))
	Local $iClicks = ($sClickType = "single" ? 1 : ($sClickType = "double" ? 2 : 0))
	Local $sImagePath = ""
	Local $sValidImages = ""
	Local $sInvalidImages = ""
	_LogWrite("Building list of images to search...")
	For $i = 0 To $MAX_IMAGES - 1
		If __IsChecked($g_aidChkSearch[$i]) Then
			If FileExists($g_asImagePaths[$i]) Then
				$sImagePath &= ($sImagePath = "" ? "" : "|") & $g_asImagePaths[$i]
				$sValidImages &= ($sValidImages = "" ? "" : ", ") & "Slot " & ($i + 1)
			Else
				GUICtrlSetState($g_aidChkSearch[$i], $GUI_UNCHECKED)
				$sInvalidImages &= ($sInvalidImages = "" ? "" : ", ") & "Slot " & ($i + 1)
			EndIf
		EndIf
	Next
	If $sValidImages <> "" Then
		_LogWrite("Valid images selected: " & $sValidImages)
	Else
		_LogWrite("No valid images found.")
	EndIf
	If $sInvalidImages <> "" Then
		_LogWrite("Invalid or missing images (unchecked): " & $sInvalidImages)
	EndIf
	If $sImagePath = "" Then
		_LogWrite("ERROR: No valid images selected for search.")
		_UpdateStatus("Error: No images selected")
		Return False
	EndIf
	Local $aResult
	Local $bSuccess = False
	If $bSearchInImage Then
		Local $sSourceImage = GUICtrlRead($g_idInputSourceImage)
		If Not FileExists($sSourceImage) Then
			_LogWrite("ERROR: Source image file does not exist: " & $sSourceImage)
			_UpdateStatus("Error: Invalid source image")
			Return False
		EndIf
		_LogWrite("Starting image-in-image search for: " & $sImagePath)
		_UpdateStatus("Searching in image...")
		$aResult = _ImageSearch_InImage($sSourceImage, $sImagePath, $iTolerance, ($bFindAll ? $MAX_IMAGES : 1), $iCenterPOS, $fMinScale, $fMaxScale, $fScaleStep, $iReturnDebug, $iUseCache)
		If $bEnableDebug Then
			_LogWrite("DLL Raw Return: " & _ImageSearch_GetLastResult())
		EndIf
		If @error Then
			_LogSearchError(@error)
			_UpdateStatus("Search failed")
			Return False
		EndIf
		If $aResult[0][0] > 0 Then
			For $i = 1 To $aResult[0][0]
				_LogWrite("Found match " & $i & ": X=" & $aResult[$i][0] & ", Y=" & $aResult[$i][1] & ", Width=" & $aResult[$i][2] & ", Height=" & $aResult[$i][3])
				$bSuccess = True
			Next
			_UpdateStatus("Found " & $aResult[0][0] & " match(es)")
		Else
			_LogWrite("No matches found.")
			_UpdateStatus("No matches found")
		EndIf
	Else
		_LogWrite("Starting screen search for: " & $sImagePath)
		_UpdateStatus("Searching on screen...")
		If $bWait Then
			$aResult = _ImageSearch_Wait($iTimeout, $sImagePath, $iLeft, $iTop, $iRight, $iBottom, $iScreen, $iTolerance, ($bFindAll ? $MAX_IMAGES : 1), $iCenterPOS, $fMinScale, $fMaxScale, $fScaleStep, $iReturnDebug, $iUseCache)
		Else
			$aResult = _ImageSearch($sImagePath, $iLeft, $iTop, $iRight, $iBottom, $iScreen, $iTolerance, ($bFindAll ? $MAX_IMAGES : 1), $iCenterPOS, $fMinScale, $fMaxScale, $fScaleStep, $iReturnDebug, $iUseCache)
		EndIf
		If $bEnableDebug Then
			_LogWrite("DLL Raw Return: " & _ImageSearch_GetLastResult())
		EndIf
		If @error Then
			_LogSearchError(@error)
			_UpdateStatus("Search failed")
			Return False
		EndIf
		If $aResult[0][0] > 0 Then
			For $i = 1 To $aResult[0][0]
				_LogWrite("Found match " & $i & ": X=" & $aResult[$i][0] & ", Y=" & $aResult[$i][1] & ", Width=" & $aResult[$i][2] & ", Height=" & $aResult[$i][3])
				If $bMoveMouse Then
					_UpdateStatus("MouseMove X:" & $aResult[$i][0] & " Y:" & $aResult[$i][1])
					_ImageSearch_MouseMove($aResult[$i][0], $aResult[$i][1], 0, $iScreen)
					_HighlightFoundArea($aResult[$i][0], $aResult[$i][1], $aResult[$i][2], $aResult[$i][3])
				EndIf
				If $iClicks > 0 Then
					_UpdateStatus("MouseClick 'left' X:" & $aResult[$i][0] & " Y:" & $aResult[$i][1])
					_ImageSearch_MouseClick("left", $aResult[$i][0], $aResult[$i][1], $iClicks, 0, $iScreen)
				EndIf
				Sleep($iDelay)
				$bSuccess = True
			Next
			_UpdateStatus("Found " & $aResult[0][0] & " match(es)")
		Else
			_LogWrite("No matches found.")
			_UpdateStatus("No matches found")
		EndIf
	EndIf
	Return $bSuccess
EndFunc   ;==>_ExecuteSearch
Func _SelectAreaOnScreen()
	GUISetState(@SW_HIDE, $g_hMainGUI)
	_UpdateStatus("Selecting search area...")
	Local $aArea = _CaptureRegion_free()
	GUISetState(@SW_SHOW, $g_hMainGUI)
	If IsArray($aArea) Then
		GUICtrlSetData($g_idInputLeft, $aArea[0])
		GUICtrlSetData($g_idInputTop, $aArea[1])
		GUICtrlSetData($g_idInputRight, $aArea[2])
		GUICtrlSetData($g_idInputBottom, $aArea[3])
		GUICtrlSetState($g_idChkUseArea, $GUI_CHECKED)
		_LogWrite("Search area selected: Left=" & $aArea[0] & ", Top=" & $aArea[1] & ", Right=" & $aArea[2] & ", Bottom=" & $aArea[3])
		_UpdateStatus("Search area selected")
	ElseIf $aArea = -2 Then
		_LogWrite("Area selection cancelled.")
		_UpdateStatus("Area selection cancelled")
	Else
		_LogWrite("ERROR: Failed to select search area.")
		_UpdateStatus("Area selection failed")
	EndIf
EndFunc   ;==>_SelectAreaOnScreen
Func _CaptureRegion_free($sFilePath = "")
	Local $sTitle = "Select Region (" & ($sFilePath = "" ? "Area" : "Image") & ")"
	Local $hUserDLL = DllOpen("user32.dll")
	If $hUserDLL = -1 Then Return -1
	Local $hCrossGUI = GUICreate($sTitle, @DesktopWidth, @DesktopHeight, 0, 0, $WS_POPUP, $WS_EX_TOPMOST)
	GUISetBkColor(0x000001)
	WinSetTrans($hCrossGUI, "", 1)
	GUISetState(@SW_SHOW, $hCrossGUI)
	GUISetCursor(3, 1, $hCrossGUI)
	_UpdateStatus("Drag the mouse to select an area. Press ESC to cancel.")
	ToolTip("Drag the mouse to select an area. Press ESC to cancel.", 0, 0)
	While Not _IsPressed("01", $hUserDLL)
		If _IsPressed("1B", $hUserDLL) Then
			ToolTip("")
			GUIDelete($hCrossGUI)
			DllClose($hUserDLL)
			GUISetState(@SW_SHOW, $g_hMainGUI)
			Return -2
		EndIf
		Sleep(20)
	WEnd
	ToolTip("")
	Local $aStartPos = MouseGetPos()
	Local $iX1 = $aStartPos[0], $iY1 = $aStartPos[1]
	Local $hRectGUI
	While _IsPressed("01", $hUserDLL)
		Local $aCurrentPos = MouseGetPos()
		Local $iX2 = $aCurrentPos[0], $iY2 = $aCurrentPos[1]
		If IsHWnd($hRectGUI) Then GUIDelete($hRectGUI)
		Local $iLeft = ($iX1 < $iX2 ? $iX1 : $iX2)
		Local $iTop = ($iY1 < $iY2 ? $iY1 : $iY2)
		Local $iWidth = Abs($iX1 - $iX2)
		Local $iHeight = Abs($iY1 - $iY2)
		$hRectGUI = GUICreate("", $iWidth, $iHeight, $iLeft, $iTop, $WS_POPUP, BitOR($WS_EX_LAYERED, $WS_EX_TOPMOST))
		GUISetBkColor(0xFF0000)
		_WinAPI_SetLayeredWindowAttributes($hRectGUI, 0, 100)
		GUISetState(@SW_SHOWNOACTIVATE, $hRectGUI)
		Sleep(10)
	WEnd
	Local $aEndPos = MouseGetPos()
	Local $iX2 = $aEndPos[0], $iY2 = $aEndPos[1]
	GUIDelete($hCrossGUI)
	If IsHWnd($hRectGUI) Then GUIDelete($hRectGUI)
	DllClose($hUserDLL)
	Local $iLeft = ($iX1 < $iX2 ? $iX1 : $iX2)
	Local $iTop = ($iY1 < $iY2 ? $iY1 : $iY2)
	Local $iRight = ($iX1 > $iX2 ? $iX1 : $iX2)
	Local $iBottom = ($iY1 > $iY2 ? $iY1 : $iY2)
	GUISetState(@SW_SHOW, $g_hMainGUI)
	If $iLeft = $iRight Or $iTop = $iBottom Then Return -2
	If $sFilePath <> "" Then
		Local $aMousePos = MouseGetPos()
		MouseMove(0, 0, 0)
		Sleep(250)
		Local $hBitmap = _ScreenCapture_Capture("", $iLeft, $iTop, $iRight, $iBottom, False)
		If @error Then
			MouseMove($aMousePos[0], $aMousePos[1], 0)
			Return -1
		EndIf
		Local $hImage = _GDIPlus_BitmapCreateFromHBITMAP($hBitmap)
		_GDIPlus_ImageSaveToFile($hImage, $sFilePath)
		_GDIPlus_BitmapDispose($hImage)
		_WinAPI_DeleteObject($hBitmap)
		MouseMove($aMousePos[0], $aMousePos[1], 0)
		Return 0
	Else
		Local $aReturn[4] = [$iLeft, $iTop, $iRight, $iBottom]
		Return $aReturn
	EndIf
EndFunc   ;==>_CaptureRegion_free
Func _HighlightFoundArea($iX, $iY, $iWidth, $iHeight, $iColor = 0xFF00FF00)
	Local $hGUI = GUICreate("", $iWidth, $iHeight, $iX, $iY, $WS_POPUP, BitOR($WS_EX_LAYERED, $WS_EX_TOPMOST, $WS_EX_TOOLWINDOW))
	GUISetBkColor($iColor)
	_WinAPI_SetLayeredWindowAttributes($hGUI, 0, 128)
	GUISetState(@SW_SHOWNOACTIVATE)
	Sleep(500)
	GUIDelete($hGUI)
EndFunc   ;==>_HighlightFoundArea
Func _LogWrite($sMessage)
	GUICtrlSetData($g_hLog, "[" & _NowTime(5) & "] " & $sMessage & @CRLF, 1)
	_GUICtrlEdit_SetSel(GUICtrlGetHandle($g_hLog), 0x7FFFFFFF, 0x7FFFFFFF)
	ConsoleWrite($sMessage & @CRLF)
EndFunc   ;==>_LogWrite
Func _LogSearchError($iErrorCode)
	Switch $iErrorCode
		Case 0
			_LogWrite("No matches found.")
		Case $IMGSE_FAILED_TO_GET_SCREEN_DC
			_LogWrite("ERROR: Failed to capture screen.")
		Case $IMGSE_INVALID_PARAMETERS
			_LogWrite("ERROR: Invalid parameters.")
		Case $IMGSE_INVALID_SEARCH_REGION
			_LogWrite("ERROR: Invalid search region.")
		Case $IMGSE_INVALID_SOURCE_BITMAP
			_LogWrite("ERROR: Invalid Source bitmap.")
		Case $IMGSE_RESULT_TOO_LARGE
			_LogWrite("ERROR: Too many results.")
		Case Else
			_LogWrite("ERROR: Error code " & $iErrorCode)
	EndSwitch
EndFunc   ;==>_LogSearchError
Func _UpdateAllImagePreviews()
	For $i = 0 To $MAX_IMAGES - 1
		_UpdateSingleImagePreview($i)
	Next
EndFunc   ;==>_UpdateAllImagePreviews
Func _UpdateSingleImagePreview($iIndex)
	If FileExists($g_asImagePaths[$iIndex]) Then
		GUICtrlSetImage($g_aidPic[$iIndex], $g_asImagePaths[$iIndex])
	Else
		If FileExists($g_sPlaceholderPath) Then
			GUICtrlSetImage($g_aidPic[$iIndex], $g_sPlaceholderPath)
		Else
			GUICtrlSetImage($g_aidPic[$iIndex], "shell32.dll", 22)
		EndIf
	EndIf
EndFunc   ;==>_UpdateSingleImagePreview
Func _SelectAll($bState)
	Local $iCheckState = ($bState ? $GUI_CHECKED : $GUI_UNCHECKED)
	For $i = 0 To $MAX_IMAGES - 1
		GUICtrlSetState($g_aidChkSearch[$i], $iCheckState)
	Next
EndFunc   ;==>_SelectAll
Func _UpdateStatus($sMessage)
	_GUICtrlStatusBar_SetText($g_hStatusBar, $sMessage)
EndFunc   ;==>_UpdateStatus
Func __IsChecked($iControlID)
	Return BitAND(GUICtrlRead($iControlID), $GUI_CHECKED) = $GUI_CHECKED
EndFunc   ;==>__IsChecked
Func _GetImageDimensions($sImagePath)
	If Not FileExists($sImagePath) Then Return False
	Local $hImage = _GDIPlus_ImageLoadFromFile($sImagePath)
	If Not $hImage Then Return False
	Local $iWidth = _GDIPlus_ImageGetWidth($hImage)
	Local $iHeight = _GDIPlus_ImageGetHeight($hImage)
	_GDIPlus_ImageDispose($hImage)
	Local $aDimensions[2] = [$iWidth, $iHeight]
	Return $aDimensions
EndFunc   ;==>_GetImageDimensions
Func _ValidateImageFile($sImagePath)
	If Not FileExists($sImagePath) Then Return False
	Local $iFileSize = FileGetSize($sImagePath)
	If $iFileSize <= 0 Or $iFileSize > 50 * 1024 * 1024 Then Return False
	Local $hImage = _GDIPlus_ImageLoadFromFile($sImagePath)
	If Not $hImage Then Return False
	Local $iWidth = _GDIPlus_ImageGetWidth($hImage)
	Local $iHeight = _GDIPlus_ImageGetHeight($hImage)
	_GDIPlus_ImageDispose($hImage)
	Return ($iWidth > 0 And $iHeight > 0)
EndFunc   ;==>_ValidateImageFile
Func _CreateImageInfoTooltip($iIndex)
	Local $sImagePath = $g_asImagePaths[$iIndex]
	Local $sTooltip = "Slot " & ($iIndex + 1) & ":" & @CRLF
	If FileExists($sImagePath) Then
		Local $aDims = _GetImageDimensions($sImagePath)
		Local $iFileSize = FileGetSize($sImagePath)
		Local $sFileSize = ""
		If $iFileSize < 1024 Then
			$sFileSize = $iFileSize & " B"
		ElseIf $iFileSize < 1024 * 1024 Then
			$sFileSize = Round($iFileSize / 1024, 1) & " KB"
		Else
			$sFileSize = Round($iFileSize / (1024 * 1024), 2) & " MB"
		EndIf
		$sTooltip &= "File: " & StringRegExpReplace($sImagePath, ".*\\", "") & @CRLF
		If IsArray($aDims) Then
			$sTooltip &= "Size: " & $aDims[0] & " x " & $aDims[1] & " px" & @CRLF
		EndIf
		$sTooltip &= "File Size: " & $sFileSize & @CRLF
		$sTooltip &= "Path: " & $sImagePath
	Else
		$sTooltip &= "No image file." & @CRLF
		$sTooltip &= "Click 'Create' or 'Browse'."
	EndIf
	Return $sTooltip
EndFunc   ;==>_CreateImageInfoTooltip
Func _RefreshImageTooltips()
	For $i = 0 To $MAX_IMAGES - 1
		GUICtrlSetTip($g_aidPic[$i], _CreateImageInfoTooltip($i))
	Next
EndFunc   ;==>_RefreshImageTooltips
Func _Exit()
	_GDIPlus_Shutdown()
	_ImageSearch_Shutdown()
	Exit
EndFunc   ;==>_Exit
Func _ImgEmptySlots()
	Local $sHexData = '0xFFD8FFE000104A46494600010101006000600000FFE1005A4578696600004D4D002A00000008000503010005000000010000004A03030001000000010000000051100001000000010100000051110004000000010000000051120004000000010000000000000000000186A00000B18FFFDB0043000201010201010202020202020202030503030303030604040305070607070706070708090B0908080A0807070A0D0A0A0B0C0C0C0C07090E0F0D0C0E0B0C0C0CFFDB004301020202030303060303060C0807080C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0C0CFFC00011080156015603012200021101031101FFC4001F0000010501010101010100000000000000000102030405060708090A0BFFC400B5100002010303020403050504040000017D01020300041105122131410613516107227114328191A1082342B1C11552D1F02433627282090A161718191A25262728292A3435363738393A434445464748494A535455565758595A636465666768696A737475767778797A838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2D3D4D5D6D7D8D9DAE1E2E3E4E5E6E7E8E9EAF1F2F3F4F5F6F7F8F9FAFFC4001F01000301010101010101'
	$sHexData &= '01010000000000000102030405060708090A0BFFC400B51100020102040403040705040400010277000102031104052131061241510761711322328108144291A1B1C109233352F0156272D10A162434E125F11718191A262728292A35363738393A434445464748494A535455565758595A636465666768696A737475767778797A82838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2D3D4D5D6D7D8D9DAE2E3E4E5E6E7E8E9EAF2F3F4F5F6F7F8F9FAFFDA000C03010002110311003F00F90E8A28AFED03F2F0A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A28'
	$sHexData &= '00A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A28'
	$sHexData &= '00A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A2A4B3B39B50BB8ADEDE29279E7711C71C6A59E462701401C924F000AFB3A3FD927E0F7EC23E14D3752FDA16E355F167C44D4A25BA83E1DE8178B10D3E221597FB42E14E632C0FDD4607FBBBC648F3730CD68E1396124E5397C318ABC9DB7B2D124BAB6D25D5EA7450C34AADDAD12DDBD97F5D96A7C5B457D8337FC14DBE1DD84A61D27F655F82D069AC70D1DFDA9BEB9DBD809CA2907DF6D68E85E2EFD96FF6D8BB1A2EAFE1597F676F195E46D1D8EB7A7DFF00DA7C38F2F3B05D4726DF254F4CA851DDA415E74B3BC5525ED313849C61D5A709B5E6E31937FF0080A91B2C25397BB4EAA6FE6BF16ADF7D8F8B68AF40FDA67F665F167EC95F15EEFC1FE31B38EDF508116E2DEE2DDCCB69A95B3E7CBB9B793037C4D8383804156560ACACA3CFEBDEA15E9D7A71AD464A5192BA6B668E39C250938C959A0A2BF487FE0DE3F857E1AF88FAF7C5F7F10681A46B6D6BA6585BC3F6EB44B8114731BAF355438380DB1338EBB457E7BFC45D3E1D23E20EBB696D1AC56F6BA8DC45120E888B230007D0015E4E0F3B862331C465CA2D3A2A177D1F3ABFE074D5C238508576FE3BFE0CC6A2B574CF02EB7AD786EF759B3D1B55BBD234C60B797D0DA4925B5A93D049201B509ED922B7FC21FB36FC45F883E1FF00ED6D03C03E35D734AC13F6'
	$sHexData &= 'DD3F43B9B9B7C0EBFBC442BFAD7AB53134609B9C92B69AB5BF639E34E4F448E2E8A92EED25B0BA9609E29219E1731C91C8A55E360705483C820F635D4F82BE01F8EBE24E95F6FF000E782BC5BAFD88629F68D3748B8BA8B70E08DD1A119FC6AAA56A74E3CF52492EEDD8518CA4ED157392A2AEF88BC35A97843579B4FD5B4FBDD2EFEDCE25B6BB81A09A33E8C8C011F88AAD676736A37715BDBC524F3CEE238E38D4B3C8C4E028039249E00154A49AE64F4134EF623A2B7D7E1478A5FC69FF0008D8F0D6BE7C459C7F658D3E6FB6E719FF0053B77F4E7A74AB9E3DF80FE38F855671DC78A3C19E2BF0DDBCA42A4BAA69171668E4F2003222826B3FACD1E651E7577B2BAD7D0AF672B376D8E528A29F6D6D25E5C470C31BCB2CAC111114B33B1380001D4935B10328AEDF55FD997E24685A23EA77DF0FBC6F67A7449E63DD4FA15D47022E33B8B940A063BE6B88ACA957A7515E9C93B76772A50947E2560A28A2B52428ADAF047C36F117C4CD45ECFC37A06B5E20BB8977BC1A6D8CB77222FA958D4902A5F1D7C2AF147C2FB88A1F13786F5FF0ECB38CC49A9E9F35A3483D5448A33F8565EDE9F3FB3E65CDDAFAFDC5724ADCD6D0C0A28AD7D4FC01AF689A3E9BA8DEE89ABDA69FAC8CD85CCD672470DF76FDD39187FF0080935729C5349BDC4937B1914576FAF7ECCFF11FC2DE156D7753F87FE3'
	$sHexData &= '7D3B4444F31B50BAD0AEA1B555FEF19590263DF35C4A234AE154166638000C926A2957A751374E49A5D9DC7284A3A49584A2BB997F661F897068A7527F879E394D3847E69BA6D06E84213FBDBFCBDB8F7CD70D452AF4EA5FD9C93B7677094251F895828A28AD490A28A2800A28A2800A28A2800A28A2800A28A2800A28A2803EB2FF008269693A77C1FF0008FC50F8FDAD58DADF2FC2BD2E383C3B0DCA878E4D72EDFCBB57DBC93E572C78E37060415C8F1EF8437FE13F8E5FB405CEA5F1ABC69E20D234CD69A7BCD4B5BB5B437D772DCB7CC32A01203313C8538C0180391ECDF0BA54D43FE08C3F142DACC6DBCD3BE2169B77A8375DF6D24091C4BED89431FC6BE48AF99C050FACE23195652719F37B34D5AF18C6316AD74D6F272DBAAD343D0AD3F670A514AEADCD6E8DB6F7F9248FD07F0E7FC13DBF653F167C0AF117C49B1F8CDF1065F07F856F21B0D4AF0E89B5A09A66458D44660DED92E9CAA9033EC6BE56FDADBC0DF06FC11AC68B1FC1FF001BF88BC6B67710CADA949AAE98D646D5C32F961372216DC0B67E5E303939C0F71FD9FBFE509DF1EFFEC6CD23FF00475A57C615C9C3F87C4CB135E55B13526A9547049F2D9AE48BD6D14EF793D9AE9A77D31B3A6A9C1469A5CD1BDD5FBB5A6BE47D75E09F88563FB5CFFC13B3C4BE0CF13DF69CFE3BF827147AC783EEEEE454BBBAD1F245'
	$sHexData &= 'DD8AB9399162501D530480100E178F916BB9F0E7C0CB8F11FC05F1178F93C43E16B6B7F0E5FDB5849A45C5FECD56F0CDD24860C7CE8BDCE470AFD769AE1ABDCCB30D4A84EB4684AF1736F97F95B49C92F26FDEF59339311525350735ADB7EEBA7F97C8FDC2FF008236FF00C140752FDAF3C19AF7872FBC29A178757E1DE97A7C11CBA6B32C779BC4C99F2C8C4607920E013F78D7C2BFF0515FF82B56B3FB5BF80752F87377E05F0E68D6D63ABEE6D42399E7B83E43B01E5E4011962393F37048F7AF65FF00836BA743E23F8C506E1E74B63A632A77601AEC13F9B0FCEBF39BE31D9CBA77C5DF155BCF1BC53C1AC5DC72230C323099C1047A835F9E645C3996C789F1A9525FBAF67286AF46E376F7D6EFBDD1EDE331D5DE5F4BDEF8B993DB5B3D0FD6CFF823A6A3E18F0D7FC1287C61A9F8BAC6DEFBC31677BAA5D6AF6F244245BAB78E2467565FE20557183C76E95F37F8BFFE0E1EF8ADFF000934A3C29E16F01E87E1BB76D96361716535C491C23855775990138FEE2A81D2BD7FF603FF0094107C61FF00AF1D7FFF00496BF282AB21E1ECBF30CCF31AD8EA6AA38D56927B2D35696D77A6BE418DC756A187A11A32B5E3D0FD18FF008262FECEF65FF050FF00DA1FE207C77F8BB67A55DE89A35CFDA6E2C522F2EC2E6F0C61CEF424E628E35525493B8B0CE79CDCF8EDFF00070CF8B34BF1D5C6'
	$sHexData &= '9BF0A3C29E12D37C1DA631B7B27D52D25967BA8D7857091C91AC4840E1304818C9EC3B2FF821B88FE26FEC19F1BBC03A6DD44BE23BCB9B892388B7CC12E6C52189B1E85E2719F6AFCB7F12F86AFF00C1BE21BED2755B49EC352D3677B6BAB69976C904884AB2B0EC4106B6C065183CCF3AC5D2CC23CD1C3F2469D37F0C62E3BA5E7DFF00E0115B13570F84A52A0ECE77727D5BBED73F5EFE067C60F017FC174BE03F883C27E39F0CE99A07C4FF000DDA79B6F7F6684987770B716EED9758F7801E16661823939047C11FF04F9F01DE7C3DFF00829E780FC37AC408BA8687E287B1BA8C8CA8962F314E33DB72E41FA1AFA07FE0DD3F84FABEA5FB46F8AFC70239A1F0F689A249A64D3B29114B3CD244E10374255622C476DCA78C8CF9F7C17F1BD87C48FF0082E3D9EB7A590DA7DFF8EEE5A0704112283228718E30DB723D88AE7C3D28E07119A657846FD846973257BA84A51778AF5DEC5CE4EB430F88ABF1B95AFDD26B5FD0FB8BFE0A9DFF000536B3FD81FE20C1A5782FC2DA0EA9F123C47611DCDFEA5A844C63B5B45664855F615790921F6AEF0ABC9E49C1F29FD85BFE0B55A97ED5BF16AD3E17FC62F09784EF34AF1A16D3EDEE6CAD5D60F3187CB15C432BC8AE8FCAE4118257839247847FC1C27FF27EB6BFF62B58FF00E8DB9AF97BF63BFF0093B8F859FF00637E93FF00A5B0D6592F06'
	$sHexData &= 'E575F86E188A94EF5654F9B9EEF993B5D59DF44B4B2DB42F179AE2218F708CBDD52B5BA5BFE09EA7FF000564FD90F4EFD8EBF6B7D4345D062687C33AE5B26AFA5C24922D5246657841272423AB633FC256BED6F813E05F00FF00C11CFF00616D27E2CF8A3C3B6FE21F8A9E2E8633671CBB44D14B3279896B1B907CA4441BA47504920F5F9457947FC1C81FF2723E04FF00B179FF00F4A1ABD47FE0B6BE19BDF8E3FB05FC25F1F786637D53C3DA5AC3757925BFEF160867B65093363F84300A4E382E3A735854C756CCB2ECA70B8C9BF675DB551DEDCDCABDD8B7FDE7BF765468C70F5F135292F7A1F0F95F77F23C7FC31FF0719FC59B5F1AC373ACF84FC0B7DA019B33D8DAC1736F71E57A24CD3380C3D59083CF033C75DFF055CFD973C03FB40FECABA37ED35F0B74E8F4C5BF58A5D6ED6DE111ADCC72BEC32BC6BC2CD14A76B91D4124E76835F9915FB09E06F845ACFC1EFF00837DBC43A6F886DA4B4BFBDD16F35516D3290F6F1CF71E6C40AB0055B6156231C1635E8E7F95E0722C4E0F199645529CAA460E29E9384B7BAEB6D35F3F430C1622B6329D5A5887CC945B4DF46B63F1EEBD77F618FD962EBF6C9FDA67C3BE0586792CECEF9DAE351BA400B5B5A46374ACA0F1B88C28EBF338C822BC8ABEEEFF0083786357FDBBB54240253C237A57D8FDA6D07F226BEDB89B1F5705956231547E'
	$sHexData &= '28C5B5E4FA3F91E4E5F46357130A73D9B47BEFED97FF000536F0FF00FC13235083E0BFC09F06786E3BAF0F451FF6A5E5E46CF6F04ACA0EC2B1B2BCD395219E477E09030C738A7FB197FC15DB4EFDBB7C5A9F087E3C7833C29776BE2E736D61756B6CE2D5E6C656396395DCAB920EC951810DB4601F9ABE35FF0082B87C25D73E15FEDEBE3D6D62DAE23B7F105F1D574EB975C25DC12804329E876B650F7056B8FF00F827DFC20D6FE36FED91F0F748D0ADE596E2DB5AB5D4AE6545256D2DEDE6496495880768017009E37328EF5F134384B27A9912C6CFF88E1CEEADDF3735B9B9AF7E8FA7EA7AD3CCF14B19EC97C37B72DB4B5ED6B1B3FF00052AFD8EC7EC4DFB526ABE15B379A7F0F5E44BA968B2CA4B39B690902366C72C8CACA7D40527AD7EAF7ED17FB4BF85BF635FF827DFC30F1C6ADE18D3FC49AD69961A7C1E19B4B8402386FA4B223CC0D83B36C42424A8DD8C818CE6BE29FF00838AFC77A77883F6ADF0BE8B6AD1C97BA06823ED857AA34D2B32213EA14671FED8F5AF59FF0082CFFF00CA2DBE06FF00D7F699FF00A6B9EBCAC6B9E6D86C9BEBF76EA37CDAD9B56F2FE64B5F2674D2B61A78BF63F652B796BFA1E01E2EFF0082FE7C6FF18F87F57D32E34DF87D15A6AF6D25AB08F4A9CB408EA54942D3919C1FE20C3DABDFBF628F841F0FFF00E0995FB07DBFED05E3DD0E2D73C6FE'
	$sHexData &= '21823B8D2A095434B6EB367ECF043B87EEDD97E777C6E032390307F286BF597FE0A49E1EBBFDA4BFE08E5F0A3C5BE178A5BDD3FC311586A3A8451AEF78225B57B790B05E9E5BB7CC7A0009E8335EC71365183C1BC2E5D8582A347115146A38E9CC92D22DFF007B6397018AAB57DA57A8F9A508DE37D6DDDFC8F20B4FF838CFE2EC7E321753F84FC052E87E7EE6D3D20B9498C59FBA27F38E1F1FC5B08CF3B7B57A37FC1457F67FF87DFB747EC470FED2DF0D3488344D76CE3FB56BB6F1C4B1BDDC6ADB2E1660B853344DCF99D5957BE463F2CEBF59BF66DF0D5D7ECF3FF0411F88379E2C0FA68F1769FA8CBA7C17276B1176A20B7C03FF003D1B0C0752181A9E21C9B0592D4C2E372A8FB2A8EA46168B7EFC65BA6AFAFAFF00C01E071557171A94B12F9A3CADEBD1AD99F933451457EA47CE8514514005145140051451400514514005145140051451401F477FC13AFE367867C29E24F177C37F883A8369BF0F3E2EE95FD89A8DE900A69376AE1ECEF98120011499C93C00D93C035E75FB56FECADE2CFD8F7E316A5E0EF1659490CD6AE5ECAF56322D756B627E4B8818F0C8C3AE0E55B72B619481E6D5F4BFC06FF82893786BE14DB7C37F8AFE0CD33E2F7C3DB371FD9F6DA95C3C3A9682BB7611677432D1A85C613B6D001519AF9FC561B1585C4CB1B838F3A9DB9E1749B6B4528B765CD6D1A6'
	$sHexData &= 'D2692D535AF6D3A94EA5354AABB35B3FD1F975BAD8C7F861FB57681E09FF00827A7C4CF8497563AC4BE21F1A6B963A959DD451C66CA18A07859C48C5C3863E51C0542391922BC02BEAEB87FD8A35B9DAEF6FED21A2283B9EC21FEC99D587F76376248FAB9A7EB7FB687C19F825E0AD4745F82FF07619F52D56DDEDE6F147C405B7D5EFE247C0222B5DAD6E8703AF20E7953DF9B0B8C74E73FAA616A73549734B9AD149D92BB6DED64B48A93F234A94B992F6B52368AB2B6AFABDBE7D6C7837C6BD2FE1EE989E17FF00840754F126A6D3E876F2EBFF00DAF6F1C42DB5339F3A28367588718CE4FF00B47B70F4B2399246638058E4E0003F21C0A4AFA4A34DD3828393979BDFF438272E677B58F67FD857F6D3D7FF00617F8E1078BB46B74D4AD2784DA6A9A649298E3BFB7241DBB803B5C100AB60E0F6C122BEA1FDB87FE0A39FB347ED43F067C4E349F839AA58FC4CD7A3468F5B9F4AB1B7682E015CC8D7314C65930063053E6E01C57E7BD15E2637867038AC6C3309A71AB1B6B1938DD2774A56DD7FC31D74B1F5A9D274159C5F46AF6F43ED1FD98FFE0A55E13F82BFF04DCF885F06B53D0FC4373E22F1443A84161776AB0B5928BA8447BA566915D4A9C9C2A36401C8CF1F175145776072AC3E0EA56AB4159D59734B5EBB7C8C6B626756318CF68AB2F43D4BF643FDAEFC5DFB16FC5FB5F177'
	$sHexData &= '84AE23F3157C8BEB19F26DB52809C98A40083EE1872A4023B83F76F89BFE0A61FB1FFED4F343AEFC57F831AC41E2C48D64B99EDAD63945C3AF44F3E19A29251C71E6A018E2BF3028AF3F35E17C163EB2C54F9A1552B73C24E32B766D6FF337C36635A8C3D9AB38F66AE8FD05FDAA3FE0B4DA45E7C1293E1AFC02F04C9F0DFC33770B5BDC5E491436D7491BE43A43140CC91B367994BB31C9C60FCD5F217EC81F1B2CBF671FDA6BC17E38D46D2EAFEC3C37A925DDC416DB7CE923C156D9B8805B04900900E3A8EB5E6F456B80E1CC060F0B530942168D4BF336DB94AEACDB93D6FF0097426B63EB55A91AB37AC76ECADE47D19FF0544FDB13C3FF00B707ED383C67E19D3B59D33498B48B7D3523D51234B8768DA46662B1BBA8199303E63D3DF15E39F03BC7B07C2BF8D5E0FF00145D412DD5B786F5BB2D525862203CA904E92B2AE78C90A40CFAD72D45776132CA186C1C703497B918F2AD75B6DB98D5C44EA5575A5BB773EA8FF82B07EDDDE1AFDBCFE32E81AEF85749D734BD3345D2BEC27FB55228E7964323393B637750A32003BB279E057ACFEC19FF00050FF1F7EC4FF00EC34CF89FF0E3C47E29F823E206923D2EFA6B12042AF92F144D2810CF1372446CCBFC5B588040FCFEAFBE7F619FF82BAF87BC1BF03E1F83FF001CBC283C63E00861169677515BA4F2DAC00FCB14B0B101D13F85'
	$sHexData &= 'D4875006031C11F299F6454E86514F0186C37B6A506AF1E66A696BEF41FF00326FBEAB43D2C1E3253C54AB54A9C927D6DA5FB35D8ED2F3F6FBFD897E1B6A7FF097783FE04EA7A878B997CFB6B5BAB08A0B3B4997E64CAB4F245110C7EF4313118F615EF5FB42FC7BF11F8BFF00E08BBE30F1AFC48862D275AF1FC323595844ACAB6D0DCDC2A5A42AADF371105639EB96638CD78CE93E37FF0082717C36D563F1369DA76A9ACDFD91F3EDF4992D757B840E3240F2EE310BFD2472BD2BE66FF82957FC14EB58FDBCB5EB1D32C34E7F0D78074272FA7E965C34D71263689A72BF2EE0BC2A2F0A09E589CD7C8E1B21FED0C650F6187AD08D39294AA576F9AD1D54209B7A37BB5D91E9CF19EC294F9E706E49A5186DAF567ADFFC1353F6E2FD9F7F67DFD917C5FE18F889E1A173E27D45EE1A6FF8938BC6D7A164C47089082136F230E55467703926A8FF00C1BDD34571FB7D6B92410FD9E07F0A5F34716F2FE529BAB4C2E4F27038CF7AF82ABEB7FF00822E7ED21E0DFD983F6C0B9D7BC73ACA683A35F787AEB4E4BB9219248D26696091436C56201113738C671EB5F5BC43C3F1A396E61570BCF3A95D5DABB96ABA457FC3FDC79982C6B957A11A964A0F7DBEF67D4FFB447FC150BE17DFFC6FF1CFC2EFDA07E180F1AE8BE16D76E2DF48D56C608A5BA8232E70ACACF1B215040DF1C80B01CA923270'
	$sHexData &= '9BFE0B09F003F649F026A3A6FECF7F09AEAD35ABD8C47F6ED42D92DA1638F95A593CD92E26DA4FDC62A09CFCC339AF83BF6D5F899A47C64FDAC7E2078A3409DEEB45D6F599EEACA678DA333445BE56DAC0119C670403CF205797D6581E03CB6A61692ACA6935172A7CF25072B2BDE37DEFBAD0BAD9CD78D4972357BBB4ACAF6F537FE28FC4DD6FE337C43D5FC53E23BE9352D735CB96BABBB87EAEE7B01D9400000380001DABEB2FDBD3FE0A55E13FDAC7F630F865F0EB47D0FC43A76B9E119AD67D467BC5845A3186CE4B72B0B248CEE097CE591381D2BE2EA2BEAF1393616BD4A15671B3A2EF0B689696DBB58F329E2AA42338A7F1EE15F5B7FC139FFE0AB7AFFEC436573E17D634A1E30F879A948D24DA6492ED9AC99F87680B6570C325A361B58F3952493F24D15AE6795E1730C3BC2E321CD07D3F54D6A9F9A270F88A9426AA527667E9C41FB767EC23A66B4BE2EB6F81DAD7FC241BF72D8FF635BF931B02486F24DD7D940CF390B9E9C71C7CDDFF000517FF0082A4F89BF6EFBCB4D1EDEC07857C07A4CBE6DA69114BE63DCC8321659DC001881F7500DAB93F78F35F2C515E365FC1F80C2E2238A6E75271F85CE4E5CBFE1BE8BF33AEBE695AA41D3D229EF6495FD428A28AFA93CE0A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A'
	$sHexData &= '28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A'
	$sHexData &= '28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2800A28A2803FFFD9'
	Return $sHexData
EndFunc   ;==>_ImgEmptySlots
Func _Deploy_ImgEmptySlots()
	Local $sHexData = _ImgEmptySlots()
	If $sHexData = "" Then Return SetError(1, 0, False)
	Local $hFile = FileOpen($g_sImgEmptySlots, 2 + 8 + 16)
	If $hFile = -1 Then Return SetError(2, 0, False)
	FileWrite($hFile, Binary($sHexData))
	FileClose($hFile)
	If Not FileExists($g_sImgEmptySlots) Then Return SetError(3, 0, False)
	Return True
EndFunc   ;==>_Deploy_ImgEmptySlots
Func _ImageSearch_Startup()
	If $g_IMGS_Debug Then ConsoleWrite("+  _ImageSearch_Startup()" & @CRLF)
	If $g_bImageSearch_Initialized Then Return 1
	If $g_bImageSearch_Debug Then ConsoleWrite(">> ImageSearch UDF Version: " & $IMGS_UDF_VERSION & @CRLF)
	If ($g_sImgSearchDLL_CustomPath <> "") And FileExists($g_sImgSearchDLL_CustomPath) Then
		$g_sImgSearchDLL_Path = $g_sImgSearchDLL_CustomPath
		If $g_bImageSearch_Debug Then ConsoleWrite(">> Using custom DLL: " & $g_sImgSearchDLL_Path & @CRLF)
	EndIf
	If ($g_sImgSearchDLL_Path = "") Or (Not FileExists($g_sImgSearchDLL_Path)) Then
		Local $aDllNames[3], $sSuffix = "ImageSearchDLL"
		$aDllNames[0] = $sSuffix & "_" & (@AutoItX64 ? "x64" : "x86") & ".dll"
		$aDllNames[1] = $sSuffix & ".dll"
		$aDllNames[2] = $sSuffix & "_XP_" & (@AutoItX64 ? "x64" : "x86") & ".dll"
		Local $sPath
		For $i = 0 To UBound($aDllNames) - 1
			$sPath = $g_sImgSearchDLL_Dir & "\" & $aDllNames[$i]
			If $g_bImageSearch_Debug Then ConsoleWrite('>> Find and Check DLL Path: ' & $sPath & @CRLF)
			If FileExists($sPath) Then
				$g_sImgSearchDLL_Path = $sPath
				ExitLoop
			EndIf
		Next
	EndIf
	Local $sArch = __ImgSearch_GetFileArch($g_sImgSearchDLL_Path, True)
	If ((($sArch = "x86") And @AutoItX64) Or (($sArch = "x64") And Not @AutoItX64)) Then
		If $g_bImageSearch_Debug Then ConsoleWrite('! Wrong Dll Arch [' & $sArch & ']: ' & $g_sImgSearchDLL_Path & @CRLF)
	EndIf
	If ((($sArch = "x86") And @AutoItX64) Or (($sArch = "x64") And (Not @AutoItX64))) Or ($g_sImgSearchDLL_Path = "") Then
		If $g_bImageSearch_Debug And ($g_sImgSearchDLL_Path = "") Then ConsoleWrite("!> No external DLL found, trying embedded DLL..." & @CRLF)
		$g_sImgSearchDLL_Path = __ImgSearch_ExtractEmbeddedDLL()
		If $g_sImgSearchDLL_Path <> "" Then
			$g_bImageSearch_UseEmbeddedDLL = True
			$g_sImgSearch_TempDLLPath = $g_sImgSearchDLL_Path
			If $g_bImageSearch_Debug Then ConsoleWrite(">> Using embedded DLL" & @CRLF)
			$sArch = __ImgSearch_GetFileArch($g_sImgSearchDLL_Path, True)
			If $g_bImageSearch_Debug Then ConsoleWrite('>> DLL Architecture:  ' & $sArch & @CRLF)
		EndIf
		If $g_sImgSearchDLL_Path = "" Then
			If $g_bImageSearch_Debug Then ConsoleWrite("!> ERROR: No DLL found (external or embedded)" & @CRLF)
			Return SetError(1, 0, 0)
		EndIf
	Else
		If $g_bImageSearch_Debug Then ConsoleWrite('>> DLL Architecture: ' & $sArch & @CRLF)
	EndIf
	$g_hImageSearchDLL = DllOpen($g_sImgSearchDLL_Path)
	If $g_hImageSearchDLL = -1 Then
		If $g_bImageSearch_Debug Then ConsoleWrite("!> ERROR: DllOpen failed: " & $g_sImgSearchDLL_Path & @CRLF)
		Return SetError(2, 0, 0)
	EndIf
	OnAutoItExitRegister("_ImageSearch_Shutdown")
	$g_bImageSearch_Initialized = True
	If $g_bImageSearch_Debug Then
		Local $sVersion = _ImageSearch_GetVersion()
		ConsoleWrite(">> Dll Version: " & $sVersion & @CRLF)
		Local $sSysInfo = _ImageSearch_GetSysInfo()
		Local $sDllType = ($g_bImageSearch_UseEmbeddedDLL ? "[Embedded]" : "[External]")
		ConsoleWrite(">> ImageSearch DLL loaded successfully " & $sDllType & @CRLF)
		ConsoleWrite(">> Dll Path: " & $g_sImgSearchDLL_Path & @CRLF)
		ConsoleWrite(">> System: " & $sSysInfo & @CRLF)
	EndIf
	Local $l_MonitorInfo = _ImageSearch_Monitor_GetList()
	If $g_bImageSearch_Debug Then ConsoleWrite($l_MonitorInfo)
	Return 1
EndFunc   ;==>_ImageSearch_Startup
Func _ImageSearch_Shutdown()
	If $g_IMGS_Debug Then ConsoleWrite("+  _ImageSearch_Shutdown()" & @CRLF)
	If Not $g_bImageSearch_Initialized Then Return
	If $g_hImageSearchDLL <> -1 Then
		DllClose($g_hImageSearchDLL)
		$g_hImageSearchDLL = -1
	EndIf
	If $g_bImageSearch_UseEmbeddedDLL And $g_sImgSearch_TempDLLPath <> "" Then
		If FileExists($g_sImgSearch_TempDLLPath) Then
			Local $iRetries = 3
			While $iRetries > 0
				FileDelete($g_sImgSearch_TempDLLPath)
				If Not FileExists($g_sImgSearch_TempDLLPath) Then
					If $g_bImageSearch_Debug Then ConsoleWrite(">> Cleaned up embedded DLL: " & $g_sImgSearch_TempDLLPath & @CRLF)
					ExitLoop
				EndIf
				Sleep(100)
				$iRetries -= 1
			WEnd
			If FileExists($g_sImgSearch_TempDLLPath) Then
				If $g_bImageSearch_Debug Then ConsoleWrite("!> Warning: Could not delete temp DLL: " & $g_sImgSearch_TempDLLPath & @CRLF)
			EndIf
		EndIf
	EndIf
	$g_bImageSearch_Initialized = False
	If $g_bImageSearch_Debug Then ConsoleWrite(">> ImageSearch DLL closed" & @CRLF)
EndFunc   ;==>_ImageSearch_Shutdown
Func _ImageSearch($sImagePath, $iLeft = 0, $iTop = 0, $iRight = 0, $iBottom = 0, $iScreen = -1, $iTolerance = 10, $iResults = 1, $iCenterPOS = 1, $fMinScale = 1.0, $fMaxScale = 1.0, $fScaleStep = 0.1, $iReturnDebug = $g_bImageSearch_Debug, $iUseCache = $IMGS_ENABLED_CACHE)
	If Not $g_bImageSearch_Initialized Then _ImageSearch_Startup()
	If Not $g_bImageSearch_Initialized Then Return __ImgSearch_MakeEmptyResult()
	If $g_bImageSearch_Debug Then $iReturnDebug = $g_bImageSearch_Debug
	$sImagePath = __ImgSearch_NormalizePaths($sImagePath)
	If $sImagePath = "" Then Return __ImgSearch_MakeEmptyResult()
	$iTolerance = __ImgSearch_Clamp($iTolerance, 0, 255)
	$iResults = __ImgSearch_Clamp($iResults, 1, $IMGS_RESULTS_MAX)
	$iCenterPOS = ($iCenterPOS = 0 ? 0 : 1)
	$fMinScale = __ImgSearch_Clamp($fMinScale, 0.1, 5.0)
	$fMaxScale = __ImgSearch_Clamp($fMaxScale, $fMinScale, 5.0)
	$fScaleStep = __ImgSearch_Clamp($fScaleStep, 0.01, 1.0)
	$iReturnDebug = ($iReturnDebug) ? 1 : 0
	$iUseCache = ($iUseCache) ? 1 : 0
	If $g_bImageSearch_Debug Then ConsoleWrite("+ _ImageSearch_Area($sImagePath=" & $sImagePath & ", $iLeft =" & $iLeft & ", $iTop=" & $iTop & ", $iRight=" & $iRight & ", $iBottom=" & $iBottom & ", $iScreen=" & $iScreen & ", $iTolerance=" & $iTolerance & ", $iResults=" & $iResults & ", $iCenterPOS=" & $iCenterPOS & ", $fMinScale=" & $fMinScale & ", $fMaxScale=" & $fMaxScale & ", $fScaleStep=" & $fScaleStep & ", $iReturnDebug=" & $iReturnDebug & ", $iUseCache = " & $iUseCache & ')' & @CRLF)
	Local $aDLL = DllCall($g_hImageSearchDLL, "wstr", "ImageSearch", "wstr", $sImagePath, "int", $iLeft, "int", $iTop, "int", $iRight, "int", $iBottom, "int", $iScreen, "int", $iTolerance, "int", $iResults, "int", $iCenterPOS, "float", $fMinScale, "float", $fMaxScale, "float", $fScaleStep, "int", $iReturnDebug, "int", $iUseCache)
	If @error Then
		If $g_bImageSearch_Debug Then ConsoleWrite("!> DllCall error: " & @error & @CRLF)
		Return SetError(1, @error, __ImgSearch_MakeEmptyResult())
	EndIf
	Local $sResult = $aDLL[0]
	$g_sLastDllReturn = $sResult
	If $g_bImageSearch_Debug Then ConsoleWrite(">> DLL returned: " & $sResult & @CRLF)
	Local $aResult = __ImgSearch_ParseResult($sResult)
	If @error Then
		Return SetError(@error, 0, $aResult)
	EndIf
	Return $aResult
EndFunc   ;==>_ImageSearch
Func _ImageSearch_InImage($sSourceImage, $sTargetImage, $iTolerance = 10, $iResults = 1, $iCenterPOS = 1, $fMinScale = 1.0, $fMaxScale = 1.0, $fScaleStep = 0.1, $iReturnDebug = $g_bImageSearch_Debug, $iUseCache = $IMGS_ENABLED_CACHE)
	If $g_IMGS_Debug Then ConsoleWrite("+ _ImageSearch_InImage($sSourceImage=" & $sSourceImage & ", $sTargetImage=" & $sTargetImage & ", $iTolerance=" & $iTolerance & ", $iResults=" & $iResults & ", $iCenterPOS=" & $iCenterPOS & ", $fMinScale=" & $fMinScale & ", $fMaxScale=" & $fMaxScale & ", $fScaleStep=" & $fScaleStep & ", $iReturnDebug=" & $iReturnDebug & ", $iUseCache: " & $iUseCache & ')' & @CRLF)
	If Not $g_bImageSearch_Initialized Then _ImageSearch_Startup()
	If Not $g_bImageSearch_Initialized Then Return __ImgSearch_MakeEmptyResult()
	If $g_bImageSearch_Debug Then $iReturnDebug = $g_bImageSearch_Debug
	If Not FileExists($sSourceImage) Then Return __ImgSearch_MakeEmptyResult()
	$sTargetImage = __ImgSearch_NormalizePaths($sTargetImage)
	If $sTargetImage = "" Then Return __ImgSearch_MakeEmptyResult()
	$iTolerance = __ImgSearch_Clamp($iTolerance, 0, 255)
	$iResults = __ImgSearch_Clamp($iResults, 1, $IMGS_RESULTS_MAX)
	$iCenterPOS = ($iCenterPOS = 0 ? 0 : 1)
	$fMinScale = __ImgSearch_Clamp($fMinScale, 0.1, 5.0)
	$fMaxScale = __ImgSearch_Clamp($fMaxScale, $fMinScale, 5.0)
	$fScaleStep = __ImgSearch_Clamp($fScaleStep, 0.01, 1.0)
	$iReturnDebug = ($iReturnDebug) ? 1 : 0
	$iUseCache = ($iUseCache) ? 1 : 0
	Local $aDLL = DllCall($g_hImageSearchDLL, "wstr", "ImageSearch_InImage", "wstr", $sSourceImage, "wstr", $sTargetImage, "int", $iTolerance, "int", $iResults, "int", $iCenterPOS, "float", $fMinScale, "float", $fMaxScale, "float", $fScaleStep, "int", $iReturnDebug, "int", $iUseCache)
	If @error Then
		If $g_bImageSearch_Debug Then ConsoleWrite("!> DllCall error: " & @error & @CRLF)
		Return SetError(1, @error, __ImgSearch_MakeEmptyResult())
	EndIf
	Local $sResult = $aDLL[0]
	$g_sLastDllReturn = $sResult
	If $g_bImageSearch_Debug Then ConsoleWrite(">> DLL returned: " & $sResult & @CRLF)
	Local $aResult = __ImgSearch_ParseResult($sResult)
	If @error Then
		Return SetError(@error, 0, $aResult)
	EndIf
	Return $aResult
EndFunc   ;==>_ImageSearch_InImage
Func _ImageSearch_Wait($iTimeout, $sImagePath, $iLeft = 0, $iTop = 0, $iRight = 0, $iBottom = 0, $iScreen = -1, $iTolerance = 10, $iResults = 1, $iCenterPOS = 1, $fMinScale = 1.0, $fMaxScale = 1.0, $fScaleStep = 0.1, $iReturnDebug = $g_bImageSearch_Debug, $iUseCache = $IMGS_ENABLED_CACHE)
	If $g_IMGS_Debug Then ConsoleWrite("+  _ImageSearch_Wait($iTimeout=" & $iTimeout & ", $sImagePath=" & $sImagePath & ", $iLeft=" & $iLeft & ", $iTop=" & $iTop & ", $iRight=" & $iRight & ", $iBottom=" & $iBottom & ", $iScreen=" & $iScreen & ", $iTolerance=" & $iTolerance & ", $iResults=" & $iResults & ", $iCenterPOS=" & $iCenterPOS & ", $fMinScale=" & $fMinScale & ", $fMaxScale=" & $fMaxScale & ", $fScaleStep=" & $fScaleStep & ", $iReturnDebug=" & $iReturnDebug & ", $iUseCache=" & $iUseCache & ")" & @CRLF)
	Local $hTimer = TimerInit()
	While True
		Local $aResult = _ImageSearch($sImagePath, $iLeft, $iTop, $iRight, $iBottom, $iScreen, $iTolerance, $iResults, $iCenterPOS, $fMinScale, $fMaxScale, $fScaleStep, $iReturnDebug, $iUseCache)
		If $aResult[0][0] > 0 Then Return $aResult
		If $iTimeout > 0 And TimerDiff($hTimer) > $iTimeout Then
			Return __ImgSearch_MakeEmptyResult()
		EndIf
		Sleep($iSleepTime)
	WEnd
EndFunc   ;==>_ImageSearch_Wait
Func _ImageSearch_MouseClick($sButton = "left", $iX = -1, $iY = -1, $iClicks = 1, $iSpeed = 0, $iScreen = -1)
	If $g_bImageSearch_Debug Then ConsoleWrite("+  _ImageSearch_MouseClick($sButton=" & $sButton & ", $iX=" & $iX & ", $iY=" & $iY & ", $iClicks=" & $iClicks & ", $iSpeed=" & $iSpeed & ", $iScreen=" & $iScreen & ")" & @CRLF)
	If $iX <> -1 And $iY <> -1 Then
		If Not _ImageSearch_MouseMove($iX, $iY, $iSpeed, $iScreen) Then
			If $g_bImageSearch_Debug Then ConsoleWrite("!> MouseMove failed" & @CRLF)
			Return SetError(2, 0, 0)
		EndIf
		Sleep(10)
		Local $iButton = ($sButton = "right" ? 0x08 : ($sButton = "middle" ? 0x20 : 0x02))
		Local $iButtonUp = ($sButton = "right" ? 0x10 : ($sButton = "middle" ? 0x40 : 0x04))
		For $i = 1 To $iClicks
			DllCall("user32.dll", "none", "mouse_event", "dword", $iButton, "dword", 0, "dword", 0, "dword", 0, "ulong_ptr", 0)
			Sleep(10)
			DllCall("user32.dll", "none", "mouse_event", "dword", $iButtonUp, "dword", 0, "dword", 0, "dword", 0, "ulong_ptr", 0)
			If $i < $iClicks Then Sleep(50)
		Next
		If $g_bImageSearch_Debug Then ConsoleWrite(">> Click performed at X=" & $iX & ", Y=" & $iY & @CRLF)
		Return 1
	Else
		If $g_bImageSearch_Debug Then ConsoleWrite(">> Click at current position" & @CRLF)
		Return MouseClick($sButton, Default, Default, $iClicks, $iSpeed)
	EndIf
EndFunc   ;==>_ImageSearch_MouseClick
Func _ImageSearch_MouseMove($iX, $iY, $iSpeed = 0, $iScreen = -1)
	If $g_bImageSearch_Debug Then ConsoleWrite("+  _ImageSearch_MouseMove($iX=" & $iX & ", $iY=" & $iY & ", $iSpeed=" & $iSpeed & ", $iScreen=" & $iScreen & ")" & @CRLF)
	If $iSpeed > 0 Then
		Local $aPos = MouseGetPos()
		Local $iSteps = Int($iSpeed)
		If $iSteps > 0 Then
			Local $fStepX = ($iX - $aPos[0]) / $iSteps
			Local $fStepY = ($iY - $aPos[1]) / $iSteps
			For $i = 1 To $iSteps
				Local $iNewX = Int($aPos[0] + ($fStepX * $i))
				Local $iNewY = Int($aPos[1] + ($fStepY * $i))
				DllCall("user32.dll", "bool", "SetCursorPos", "int", $iNewX, "int", $iNewY)
				Sleep(10)
			Next
		EndIf
	EndIf
	Local $aResult = DllCall("user32.dll", "bool", "SetCursorPos", "int", $iX, "int", $iY)
	If @error Or Not $aResult[0] Then
		If $g_bImageSearch_Debug Then ConsoleWrite("!> SetCursorPos failed for X=" & $iX & ", Y=" & $iY & @CRLF)
		Return SetError(1, 0, 0)
	EndIf
	If $g_bImageSearch_Debug Then
		Local $aNewPos = MouseGetPos()
		ConsoleWrite(">> Mouse moved to X=" & $aNewPos[0] & ", Y=" & $aNewPos[1] & @CRLF)
	EndIf
	Return 1
EndFunc   ;==>_ImageSearch_MouseMove
Func _ImageSearch_GetVersion()
	If $g_IMGS_Debug Then ConsoleWrite("+  _ImageSearch_GetVersion()" & @CRLF)
	If Not $g_bImageSearch_Initialized Then _ImageSearch_Startup()
	If Not $g_bImageSearch_Initialized Then Return ""
	Local $aDLL = DllCall($g_hImageSearchDLL, "wstr", "ImageSearch_GetVersion")
	Return (@error ? "" : $aDLL[0])
EndFunc   ;==>_ImageSearch_GetVersion
Func _ImageSearch_GetSysInfo()
	If $g_IMGS_Debug Then ConsoleWrite("+  _ImageSearch_GetSysInfo()" & @CRLF)
	If Not $g_bImageSearch_Initialized Then _ImageSearch_Startup()
	If Not $g_bImageSearch_Initialized Then Return ""
	Local $aDLL = DllCall($g_hImageSearchDLL, "wstr", "ImageSearch_GetSysInfo")
	Return (@error ? "" : $aDLL[0])
EndFunc   ;==>_ImageSearch_GetSysInfo
Func _ImageSearch_GetLastResult()
	If $g_IMGS_Debug Then ConsoleWrite("+  _ImageSearch_GetLastResult()" & @CRLF)
	Return $g_sLastDllReturn
EndFunc   ;==>_ImageSearch_GetLastResult
Func _ImageSearch_Monitor_GetList()
	If $g_IMGS_Debug Then ConsoleWrite("+  _ImageSearch_Monitor_GetList()" & @CRLF)
	Local $l_vLeft = DllCall("user32.dll", "int", "GetSystemMetrics", "int", 76)[0]
	Local $l_vTop = DllCall("user32.dll", "int", "GetSystemMetrics", "int", 77)[0]
	Local $l_vWidth = DllCall("user32.dll", "int", "GetSystemMetrics", "int", 78)[0]
	Local $l_vHeight = DllCall("user32.dll", "int", "GetSystemMetrics", "int", 79)[0]
	Local $l_vRight = $l_vLeft + $l_vWidth
	Local $l_vBottom = $l_vTop + $l_vHeight
	Local $l_aMonitors = _WinAPI_EnumDisplayMonitors()
	If @error Then Return SetError(1, 0, 0)
	Local $l_iCount = $l_aMonitors[0][0]
	ReDim $g_aMonitorList[$l_iCount + 1][9]
	$g_aMonitorList[0][0] = $l_iCount
	$g_aMonitorList[0][1] = $l_vLeft
	$g_aMonitorList[0][2] = $l_vTop
	$g_aMonitorList[0][3] = $l_vRight
	$g_aMonitorList[0][4] = $l_vBottom
	$g_aMonitorList[0][5] = $l_vWidth
	$g_aMonitorList[0][6] = $l_vHeight
	$g_aMonitorList[0][7] = 1
	$g_aMonitorList[0][8] = "Virtual"
	Local $l_sLog = StringFormat(">> Number of screens: [%d] - Virtual Desktop: Left=%d, Top=%d, Right=%d, Bottom=%d, Width=%d, Height=%d", $l_iCount, $l_vLeft, $l_vTop, $l_vRight, $l_vBottom, $l_vWidth, $l_vHeight) & @CRLF
	For $l_i = 1 To $l_iCount
		Local $l_hMonitor = $l_aMonitors[$l_i][0]
		Local $l_tRect = $l_aMonitors[$l_i][1]
		Local $l_aInfo = _WinAPI_GetMonitorInfo($l_hMonitor)
		Local $l_mLeft = DllStructGetData($l_tRect, "Left")
		Local $l_mTop = DllStructGetData($l_tRect, "Top")
		Local $l_mRight = DllStructGetData($l_tRect, "Right")
		Local $l_mBottom = DllStructGetData($l_tRect, "Bottom")
		Local $l_mWidth = $l_mRight - $l_mLeft
		Local $l_mHeight = $l_mBottom - $l_mTop
		Local $l_bPrimary = ($l_aInfo[2] <> 0)
		Local $l_sDevice = $l_aInfo[3]
		$g_aMonitorList[$l_i][0] = $l_hMonitor
		$g_aMonitorList[$l_i][1] = $l_mLeft
		$g_aMonitorList[$l_i][2] = $l_mTop
		$g_aMonitorList[$l_i][3] = $l_mRight
		$g_aMonitorList[$l_i][4] = $l_mBottom
		$g_aMonitorList[$l_i][5] = $l_mWidth
		$g_aMonitorList[$l_i][6] = $l_mHeight
		$g_aMonitorList[$l_i][7] = $l_bPrimary
		$g_aMonitorList[$l_i][8] = $l_sDevice
		$l_sLog &= StringFormat(">> Monitor [%d]: Handle=%s, L=%d, T=%d, R=%d, B=%d, W=%d, H=%d, IsPrimary=%d, Device=%s", $l_i, Ptr($l_hMonitor), $l_mLeft, $l_mTop, $l_mRight, $l_mBottom, $l_mWidth, $l_mHeight, $l_bPrimary, $l_sDevice) & @CRLF
	Next
	Return SetError(0, $l_iCount, $l_sLog)
EndFunc   ;==>_ImageSearch_Monitor_GetList
Func __ImgSearch_ParseResult($sResult)
	If $g_IMGS_Debug Then ConsoleWrite("+  __ImgSearch_ParseResult($sResult=" & $sResult & ")" & @CRLF)
	Local $sCountStr = __ImgSearch_ExtractBetween($sResult, "{", "}")
	Local $iCount = Number($sCountStr)
	Local $sErrorMsg = __ImgSearch_ExtractBetween($sResult, "<", ">")
	If $iCount < 0 Or $sErrorMsg <> "" Then
		If $g_bImageSearch_Debug Then
			ConsoleWrite("!> DLL Error [" & $iCount & "]: " & $sErrorMsg & @CRLF)
			Local $sDebugInfo = __ImgSearch_ExtractBetween($sResult, "(", ")")
			If $sDebugInfo <> "" Then ConsoleWrite("   Debug: " & $sDebugInfo & @CRLF)
		EndIf
		Return SetError($iCount, 0, __ImgSearch_MakeEmptyResult())
	EndIf
	Local $sMatches = __ImgSearch_ExtractBetween($sResult, "[", "]")
	Local $aResult[$iCount + 1][4]
	$aResult[0][0] = $iCount
	If $iCount = 0 Or $sMatches = "" Then Return $aResult
	Local $aRecords = StringSplit($sMatches, ",", 3)
	Local $iValid = 0
	For $i = 0 To UBound($aRecords) - 1
		Local $aParts = StringSplit($aRecords[$i], "|", 3)
		If UBound($aParts) >= 4 Then
			$iValid += 1
			$aResult[$iValid][0] = Number($aParts[0])
			$aResult[$iValid][1] = Number($aParts[1])
			$aResult[$iValid][2] = Number($aParts[2])
			$aResult[$iValid][3] = Number($aParts[3])
			If $iValid >= $iCount Then ExitLoop
		EndIf
	Next
	$aResult[0][0] = $iValid
	ReDim $aResult[$iValid + 1][4]
	If $g_bImageSearch_Debug Then
		Local $sDebugInfo = __ImgSearch_ExtractBetween($sResult, "(", ")")
		If $sDebugInfo <> "" Then ConsoleWrite(">> Debug: " & $sDebugInfo & @CRLF)
	EndIf
	Return $aResult
EndFunc   ;==>__ImgSearch_ParseResult
Func __ImgSearch_ExtractBetween($sString, $sStart, $sEnd)
	If $g_IMGS_Debug Then ConsoleWrite("+  __ImgSearch_ExtractBetween($sString=" & $sString & ", $sStart=" & $sStart & ", $sEnd=" & $sEnd & ")" & @CRLF)
	If $sString = "" Or $sStart = "" Or $sEnd = "" Then Return ""
	Local $aRet = StringRegExp($sString, "(?si)\Q" & $sStart & "\E(.*?)" & "(?=\Q" & $sEnd & "\E)", 3)
	If @error Then
		Local $iStart = StringInStr($sString, $sStart)
		If $iStart = 0 Then Return ""
		Local $iEnd = StringInStr($sString, $sEnd, 0, 1, $iStart + StringLen($sStart))
		If $iEnd = 0 Or $iEnd <= $iStart Then Return ""
		Return StringMid($sString, $iStart + StringLen($sStart), $iEnd - $iStart - StringLen($sStart))
	EndIf
	If IsArray($aRet) And UBound($aRet) > 0 Then Return $aRet[0]
	Return ""
EndFunc   ;==>__ImgSearch_ExtractBetween
Func __ImgSearch_NormalizePaths($sInput)
	If $g_IMGS_Debug Then ConsoleWrite("+  __ImgSearch_NormalizePaths($sInput=" & $sInput & ")" & @CRLF)
	If $sInput = "" Then Return ""
	While StringInStr($sInput, "||")
		$sInput = StringReplace($sInput, "||", "|")
	WEnd
	$sInput = StringStripWS($sInput, 3)
	$sInput = StringRegExpReplace($sInput, "^\|+|\|+$", "")
	If Not StringInStr($sInput, "|") Then
		Return (FileExists($sInput) ? $sInput : "")
	EndIf
	Local $aPaths = StringSplit($sInput, "|", 3)
	Local $sValid = ""
	For $i = 0 To UBound($aPaths) - 1
		If FileExists($aPaths[$i]) Then
			$sValid &= ($sValid = "" ? "" : "|") & $aPaths[$i]
		EndIf
	Next
	Return $sValid
EndFunc   ;==>__ImgSearch_NormalizePaths
Func __ImgSearch_Clamp($vValue, $vMin, $vMax)
	If $g_IMGS_Debug Then ConsoleWrite("+  __ImgSearch_Clamp($vValue=" & $vValue & ", $vMin=" & $vMin & ", $vMax=" & $vMax & ")" & @CRLF)
	If $vValue < $vMin Then Return $vMin
	If $vValue > $vMax Then Return $vMax
	Return $vValue
EndFunc   ;==>__ImgSearch_Clamp
Func __ImgSearch_MakeEmptyResult()
	If $g_IMGS_Debug Then ConsoleWrite("+  __ImgSearch_MakeEmptyResult()" & @CRLF)
	Local $aResult[1][4] = [[0, 0, 0, 0]]
	Return $aResult
EndFunc   ;==>__ImgSearch_MakeEmptyResult
Func __ImgSearch_GetFileArch($sFilePath, $bAsText = True)
	If $g_IMGS_Debug Then ConsoleWrite("+  __ImgSearch_GetFileArch($sFilePath=" & $sFilePath & ", $bAsText=" & $bAsText & ")" & @CRLF)
	If Not FileExists($sFilePath) Then Return SetError(-1, 0, '')
	Local $tType = DllStructCreate("dword lpBinaryType")
	Local $aRetAPI = DllCall("kernel32.dll", "bool", "GetBinaryTypeW", "wstr", $sFilePath, "ptr", DllStructGetPtr($tType))
	If @error = 0 And $aRetAPI[0] Then
		Local $BinaryType = DllStructGetData($tType, "lpBinaryType")
		Switch $BinaryType
			Case 0
				Return SetError(0, 0, ($bAsText ? "x86" : 32))
			Case 6
				Return SetError(0, 6, ($bAsText ? "x64" : 64))
			Case 1
				Return SetError(0, 1, ($bAsText ? "DOS" : 1))
			Case 2
				Return SetError(0, 2, ($bAsText ? "WOW" : 2))
			Case 3
				Return SetError(0, 3, ($bAsText ? "PIF" : 3))
			Case 4
				Return SetError(0, 4, ($bAsText ? "POSIX" : 4))
			Case 5
				Return SetError(0, 5, ($bAsText ? "OS216" : 5))
		EndSwitch
	EndIf
	Local $hFile = _WinAPI_CreateFile($sFilePath, 2, 2)
	If $hFile = 0 Then Return SetError(2, 0, "Error: Cannot open file")
	Local $tDosHeader = DllStructCreate("char Magic[2];byte[58];dword Lfanew")
	Local $aRead = _WinAPI_ReadFile($hFile, DllStructGetPtr($tDosHeader), 64, 0)
	If Not $aRead Or DllStructGetData($tDosHeader, "Lfanew") < 64 Then
		_WinAPI_CloseHandle($hFile)
		Return SetError(3, 0, "Error: Cannot read DOS header")
	EndIf
	If DllStructGetData($tDosHeader, "Magic") <> "MZ" Then
		_WinAPI_CloseHandle($hFile)
		Return SetError(4, 0, "Error: Not a valid PE file")
	EndIf
	_WinAPI_SetFilePointer($hFile, DllStructGetData($tDosHeader, "Lfanew"))
	Local $tNtHeaders = DllStructCreate("dword Signature;word Machine;word NumberOfSections;byte[18]")
	$aRead = _WinAPI_ReadFile($hFile, DllStructGetPtr($tNtHeaders), 24, 0)
	If Not $aRead Then
		_WinAPI_CloseHandle($hFile)
		Return SetError(5, 0, "Error: Cannot read NT headers")
	EndIf
	If DllStructGetData($tNtHeaders, "Signature") <> 0x4550 Then
		_WinAPI_CloseHandle($hFile)
		Return SetError(6, 0, "Error: Invalid PE signature")
	EndIf
	Local $Machine = DllStructGetData($tNtHeaders, "Machine")
	_WinAPI_CloseHandle($hFile)
	Switch $Machine
		Case 0x014C
			Return SetError(0, 32, ($bAsText ? "x86" : 32))
		Case 0x8664
			Return SetError(0, 64, ($bAsText ? "x64" : 64))
		Case 0xAA64
			Return SetError(0, 65, ($bAsText ? "ARM64" : 65))
		Case 0x01C0
			Return SetError(0, 66, ($bAsText ? "ARM" : 66))
		Case 0x01C2
			Return SetError(0, 67, ($bAsText ? "THUMB" : 67))
		Case 0x01C4
			Return SetError(0, 68, ($bAsText ? "ARMNT" : 68))
		Case 0x0200
			Return SetError(0, 69, ($bAsText ? "IA64" : 69))
		Case 0x01C5
			Return SetError(0, 70, ($bAsText ? "ARMV7" : 70))
		Case 0x0162
			Return SetError(0, 71, ($bAsText ? "R3000" : 71))
		Case 0x0166
			Return SetError(0, 72, ($bAsText ? "R4000" : 72))
		Case 0x01F0
			Return SetError(0, 73, ($bAsText ? "POWERPC" : 73))
		Case 0x01F1
			Return SetError(0, 74, ($bAsText ? "POWERPCFP" : 74))
		Case 0x0EBC
			Return SetError(0, 75, ($bAsText ? "EBC" : 75))
		Case 0xC0EE
			Return SetError(0, 76, ($bAsText ? "CEE" : 76))
		Case Else
			Return SetError(7, $Machine, "Unknown (Machine: 0x" & Hex($Machine, 4) & ")")
	EndSwitch
EndFunc   ;==>__ImgSearch_GetFileArch
Func __ImgSearch_ExtractEmbeddedDLL()
	If $g_IMGS_Debug Then ConsoleWrite("+  __ImgSearch_ExtractEmbeddedDLL()" & @CRLF)
	Local $sHexData, $sDllName
	If StringInStr(@OSVersion, 'XP') Or StringInStr(@OSVersion, '2003') Then
		$sHexData = (@AutoItX64 ? __ImgSearch_GetEmbeddedDLL_XP_x64() : __ImgSearch_GetEmbeddedDLL_XP_x86())
		$sDllName = (@AutoItX64 ? "ImageSearchDLL_XP_x64.dll" : "ImageSearchDLL_XP_x86.dll")
	Else
		$sHexData = (@AutoItX64 ? __ImgSearch_GetEmbeddedDLL_x64() : __ImgSearch_GetEmbeddedDLL_x86())
		$sDllName = (@AutoItX64 ? "ImageSearchDLL_x64.dll" : "ImageSearchDLL_x86.dll")
	EndIf
	If ($sHexData == "") Then Return ""
	Local $sTempPath = @TempDir & "\" & $sDllName
	Local $hFile = FileOpen($sTempPath, 2 + 8 + 16)
	If $hFile = -1 Then Return ""
	FileWrite($hFile, Binary($sHexData))
	FileClose($hFile)
	If Not FileExists($sTempPath) Then Return ""
	If $g_bImageSearch_Debug Then ConsoleWrite(">> Extracted embedded DLL to: " & $sTempPath & @CRLF)
	Return $sTempPath
EndFunc   ;==>__ImgSearch_ExtractEmbeddedDLL
Func __ImgSearch_GetEmbeddedDLL_x64()
	Local $sHexData = '0x4D5A90000300000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000100100000E1FBA0E00B409CD21B8014CCD21546869732070726F6772616D2063616E6E6F742062652072756E20696E20444F53206D6F64652E0D0D0A2400000000000000E7657E71A3041022A3041022A3041022AA7C8322B3041022E88E1423AB041022E88E1523BF041022E88E1323A6041022E88E1123A5041022DA851123AA041022A3041122BA051022268F1923A2041022268F1023A2041022268FEF22A2041022A3048722A2041022268F1223A204102252696368A304102200000000000000000000000000000000000000000000000050450000648603004FD907690000000000000000F00022200B020E32007001000010000000C00200A02B040000D0020000000080010000000010000000020000060000000000000006000000000000000050040000040000000000000200600100001000000000000010000000000000000010000000000000100000000000000000000010000000FC480400A00100009444040068040000004004009404000000A003008022000000000000000000009C4A04002C000000000000000000000000000000000000000000000000000000902E040028000000683804004001000000000000000000000000000000000000000000000000000000000000000000000000000000000000555058300000000000C00200001000000000000000040000000000008C57CE7500000000800000E055505831000000000070010000D00200006A010000040000000000004C17D17500000000400000E02E727372630000000010000000400400000C0000006E0100000000004C87D23F00000000400000C000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000332E33300055505'
	$sHexData &= '8210D24080AF61283F018F560DD87000400A05B010000B00300490900B7F9FF6FFE4883EC28B91000E809022244488D0D0B8D030048C74008007BF3FBFE488905FC8C1C89083002520283C428E95077C8177625D8CC017F3889587F77BF67766E5C8D05610C010F57C0660F7F053BEF3CB35E2B63071460D7CFE05F9A541E803F4C8BC0BA21E42706C8F77624AE01CB8C90FEB2518F82B1D330B9299F638C421E722054925179202F074C8C518C4E8CE4200F79538C508C0E8C8DD8258F178C42FF53C137B838055D504D442430B9301748910F5E7038014D502D52500EF29007164F504C500A50405EF2481350D6503C4CDE10BFE950D6CDDBC1CF963F895C2408576A208C051FB7DF6E9FA28BD926018BFA0E4908FF15D5642240F6C7ACDB7EED0174271ECB100475142890644DC304623FF8D77430EA205FC3BA18CB011B0C2F7667F75FBE8B0948FF254662DF4053D63AD67578F08B05834DF233C44928E7C70E342BB8872005EE145418CE784F69EEFF85C07403894310B9C1F25624381F76B8E033C94C5C70A1028F0F11B048106FC3776B704C688B531016084CD6895023B50F3E6CB633CCFC213C20305BC325E1B4C470CC5FAC196066C1C1041174D3633F6382177B8BC2C35FB98A92271D3EB0834C9E180814535556AF38ECD6E1ED498BF0486C247848A7D9F000037CBABB8256D11E2896CE04C7EFD304C16F654108E88B62B9FF000F48C1447B3A2CF8385F5E5D4B7F5550A1FDE4B3A12090E5E03A4C452833C0E3FFCDBEA2D13905F0892210C9744D4983F81072470FB7CA3FB6FFBFD46EC1C4E27D79C0C5FE7F4500C5F877201F84E3C4B6E06FFFC17E6F01C5FD754D2AFDD7C985C90F854004F2B4EFDB3EDAC01078C126480E3BC86076D61604DBEBDE3E0F874005390FBFA7C926080E61C9DB66FF6E0670C900387723F3410F9E1C75C106D7C8FBDCF3B6669E7576960810574476DD91C137F2065E7E446045846AF0DF0A5A6722B60CBCB6D1E94803C8498D044A9AF64051C84D67505DC33CD1EABBDAE069D0523A43B787FB17B45022C10AC0731366413914424498E1AB780C42741CDCC02472ED8E5DCF45A90D299F10B3CA8AEE904A087FDA0E688887CB158BD9141AD274352FE1C80E577E09C4C175750A83F9FFE3067A181CA421EAC276D4B287158E6F6B7737BA1E5A6690BFE5660F5D09090268C80684663BCA39860BC3BCD184D9D0BC45AA2F07014D181A124C6084F48676FFFE4933D141AC004854D241B901376C9B6E0BC1EA04B204026C0C0284044B66254F83FF43390443450F42CA41FC76088BCDB2CD10F7D16D7E932A586D10627D9883418A6DB64E85F7836B06B1489ECD01140153C3D61C5D8F19A44441620C43249BDA2A3606751D9B6BB8'
	$sHexData &= 'E700AB6D99E36442C2430D58ADAE5F2070F07EFD870AB4AF87E51253900BCB7AC0AA2EFA02687E5D237E6D0BE9A0202A5108461588ACABA10171D2D0457DF63C8706FF9F87F9DA24EF807FDAC108B01DF6C301740DC236CFE0F580074025F8C378232F023CC97F59878330DF9295C1DB5C3FA198BC974DA24110410864664BBEB766949B01823959EE01870C1FA54C7D2BB69205FA185B5FC048B6CAF05ACB70EF58BBD30E7862487C3AD91F4848A7DB069C8D70082C1215A315CE20878A6721022FDC3F5D865659701EDE5BCC7F8603E5994086B67F1D9EDE0A291917DE6E65AE82C3764CE75752FF70B6C121BF3E934660C12844E0FFEFB8834C8E5AF630794741F7D80F1F40004983E92FAA6AE702B8CD1EE016039AC266C1E004B8EAA6029C106603D2442BC15AD57686ABCA306645947C6C75D0E04180F6DBFE26C7012D00EB347F042A2CBA4C4428D11E7E8A4B9ECE592C166070A90DF94CB09F40C345852A1415148DC8C68E0114FF30D986DB848F05B385025F93971FBA53209B505A51972A26977CE330403F7979809C7D84FE59FF96ADD1D50004450309502D7C8FE88556A50558C3DC12F421DE7D515F448902D3894A08C35F210E0D030146D86433DB56F6F65018204B084C8BFABD493906750E17FEC2ED8B0B390A08B001A932C0B9F3BF2F2D50424C39493C4439027503B001AE3E4CD5C31F0192891113BBF0B59AFF3E209241560AABBFC24157EAC94881ECA0703F5462B2F0414438F2E74D1762050405D0FF52EA4DF79F82D7541C42F83E17027678105FE58AFB741541B8027A4E15F783C84A7D7C41DB3405B6060655D712CEBA2BC0056E109015807DEF0F6047129BDBD2367A45E754CF348B55EFFA0F6D2ED8DA7636124548FFC220FA0010721EEDB639AC1E48D8C238E80806F81F77A0836280F7FDC227EB0AB905E0CD29D77636F7F75B6145B74C897DC706CF0F10071D0C4F10B69B1BD10E4D1C47180FC607003A7F10A63C0BD61D2445B7CF123E8FCA15D80D72820B15A7021D86D10DD1C6451F080C24EB430E969757EC946ACF1079A990B792F2D2858F565206D64300C31C275EA9B80F8B9C24E8623AC4415F415E72A240256CC3BFBF81099093173D5728C8AF9F789E18B360AA3D422FFAAE725040BD8B72088B2A64CE8B5A046F8BB634C51A06AE687C24380FA534950F7636810F57E50EAB7374483CB60BCDE0A5725C4040A1566B8838673E546E70059D9307953758EEE6010D97CE96896F18920CBDB60FCA895F1C10772009509FE8E1E10C900260913A30C034BF785A2230521C1C6C0BBCBB6130CB660FEC322944510DEC6A0C2846139640DF06C300CB22F22C808274CB66478E91804B08AA55C2CEC1C1FB92E36819C810D9C1C5F43B75583'
	$sHexData &= 'E10F26AAB49BFCC7F0BBBC9C84A9B98B7AB64850E5A7E5E12D438B553106441DF30411EB0B961BCC4AE7A5145C0154ECD1C8E0780CF431F94277A14181C30CD54FEF08690E1DE015A7C400E0D988C30FFF6C26191878A4A0AF9452BF96055DF3FA97F0106D903678F3F385E33D3CC4DDA5424280C7C6E1699EE02838426044130E04266C42266EAE20542470AF062EB0D7A0DD58E2E056F9BF503567B10061896CB909C039D85C58DD4B33848E21C3488CD50C640607B60A95FF8A8DA45D6751C2E9E55720886693F426EC2D3604891A564C4CFE4A97CBF4E1B893B4CD24043C30490EDB5E434273F561438345F9140FFF20A3988DF117A0987E42556DE217EB68D398D0821DF121CA0C22BE40AED7C1FC290AC1C6E524F8D339FB4462DF35FD285C9E64229C0741D4A01DC125F61B4C600BA448C5649FF20056E7C730D76816118FFF3CE72817C8999A2499C029D3FEF871C208720F908AA877624832A042D9F4D330BAED9B0255010F854C1FF0F9A4E4C3681FF809698007515496BC164D5FFFFA562D33A00366E01756549BAF38C909407FCDFFFBBE1F4B2496C49F7E90A4D8D041149C1F8184988C1E93ADEEEFE3F4C03C14969C85B4C2BC912C900CA9AB8F7E90E5B917AD13AFA18D9C1E83F6C674B13E034C012D58913DBDBDBA10D9960FF5F69C245894A8C027B2BBA399F401E2027F33B0B7B909543F2037C805031908DBFB8818946F220FF5318901F33A1ED1B114F7E900FCB61D7D108AFE9D31F08A8ACABEE72742410B95D4973181C18F5C9D82E685683E75D97E2CE40060F1146064007DE7BA4804089467C76225EFC9BEBB26A7E2098D24E103B8BB24C9F2E5758457A06157C1B0A06F2390A6C7D069F18B064C17E514E49219B622DFA38853A7DFA30D645989633D2A0547867C2658130268E4B0773837C64B7E66F3A0074748B0DD276657C0425582C79DFFFD23E1404C88B0C02390D23707E2D821AF3DBBDC3F1C8833D0E99751828B53B02679BFDAD07F977415C1605CD3C709F1936F489052F02D277AC3B78A904741956E1205A6DC6C56F38796F0B28A44A75594AFF03417E0C8EFB881F2944A093BF3ADAEFC52F6804F13A874210F0FF426C8AB8688B712881009230E21720C261713479883890BFF89B5964994A33B88B474C3DDA7F750AFF1F1CFFDAC88916E926D940B5018B14AC3940D1291DC032EDC76295EAE1009A0818CF837E68DE6AF6A3A6065668EBEC6870A63EEAE7DB064E70CF614084ED861818FE0291D91CA24C004AF00FB17B107573BF066FD444139B5210B90359C72C4B100F654515FE45F883FF027556F260BAF049DC9F8665740CD4B9CC8B83AC18CAF73B1367141DB9064198CD3BB3E7C683B00183DE1218DCAE6F433DB88ACEC143'
	$sHexData &= '0883F8D844A395820902035008A3606F3D24698230BFFEDB99E18D20A6CBFA9A59183F0C5F753728154E499519A0817B4CBCDDFB072B0CC7434CFE10E928708B4E68BDCAF10B6F93FE644532F68268EF803DFF30C03939740D10D106157E70B3DCECEB248C9DCF6C38E104A2BE7908145619829F8E700F8BC58747109547C13F4D730E07CFEB0341B601354FADDCF0E348FA4584F6198D737F38FB07F54F108BD8278BD0B6792BD174FFA968BE7506713B6D64FE3BD87463876F2F9B16FC1083FD03745BDA4F60CA684860814EF70387BFD9C916C78717FE0894CF1BF91B4A80BF64ED34EF03528D57607A184A2F1B1ECEEC74E9A147E9F26C2479C53794680CC3CFD149418769C27F097715E350A9B80C41067201C7034297171F797F6069EA525B90FE037934AD366F0EFFCB8711A690090810DF4016156846485C41471FC6F0F30A4981BB946551C79F9F6DC383946F42E84883BBB0027DB77BD18516364873198E2B7C9B7284A3EA7A481838CA250B3972723BFF08F9C1461992CA038A48BF879E8D5C2668BF0A32119776DA83BD9AABF84F303131DC208E28BF59CA62AF0B22DB7436BB30BF457F3AB9C993C31B10E67B0C83FFC41A2E21609FAF90CD6B9F143C03039D73B2728050BF1E49CF8830E1AA53C1082201310CBF41937E5C38CA75071E45C4DF4AFB88C1902C4B74141E483BD863D3F1CB0F95C2E6204338E9BA400EC3565403BF193D058A16B12F919F136929A4944971F3C445C15E98CE5E90217F58B42B1B6A940E34C395940F1E227E9D3820E8585EBC83E287D66A443CBD2F551F443EAC7A0A89B72C740C8C1C5FED30C18D746C720E5F564668A01B6D028501457967180065B80610F445ABC462520E2B8AC1FA03C1BB720C8808D1001FBA15EA6171D077456FB96000EEB8D9343352625B8B7E2BDA4C6EB41E8F84CF41D07EFB92AEF7ADC70CDFAE6E4E44C6B1D48C9F615E20768F4CCC9F3A1564C30944F3459F72EA301910725EE07BFCF938764C897910F40C18BEEF81FDC04FB44D8BF0441C32EA660E0CEF798B0ECA1A413806485852287BCFE97F0630897168C74120C1486C2270064A205862B9802FDCEDB337FB7204F0FF1018780833D20A2A481040BB32F2E79D880C900F118398A866B30D34B85393C81BE80DF867E42D4608467CD8E0DA550DF089B3180101D0CD442C1C73C199CD49200D280EFF744BBF1DDC4347E8832D8A31898B3001C870E07C6938F53B439E23D810501C0C27CCBED5B61C8D89E5480D50C3F98D8C5840539B609E1D56BC341C686B780CFD0247455776B038FC5027E9D95A73D00D17E9120C77FE2209A973874E52AF583C4333C6E55F1018C9026106A9F1C28785A02938C078B702F9120C5E4418C20D8D8E91C0D5C19'
	$sHexData &= '9858B9ED3EC2921669369171D270C03063C3316CA62287B639021991C0A904E09F45C08384049B1B6454FAB08C73080060074BA81C1EA32173C79AA114548CE6EA8BF3E1A4C90EB0595807B0D4EAA006FAEC22FFC1039007513005FA0526C58DA040F94C0FFE954AD5245DF2CC31D3C559548F23F18E2F21AF18B87874E4B8B5E6824918DE3C4BBAF3650636C90B948938491F0ACF86B27FCD479E796500C0C924183002FED8E5F10CB48447C73804F778C89394CC9D6AE41BD206D89B0BE549B6EAD770B2866087C0E1C0DC2CD37742041B00160D090A15D0070D50EF081340F8FF0E42D6BD7EE53FA830152B913129ECBB3DA8B58CF4088C6FAB079312C8E70AF3F404CD80B2E55F9923050C9F30F7F8E3CF194267A5ADC2AD5B80E9127B1C03AEBE475317C9EC728B9D06F381FFE96DB3C41B829512FD666C57C84580F2FC74797980BBD4D702EE8244F180620CDCFBFD72C5C2806380E484889475878DE537E6D068788B38754680670D8EBFB01AF89B7A8956057898F53B48397DC8887DB18B8531F3440F6967B20C02F1206CA487BF31224AF9FA5621370F04989BF8067764F7890E9AAFB6416CC9055168721570DD5D6D1484ED7109C71231D362DD7E7804055CA8C2554CE950A53A5476B5FDA8DD0E1D6BF41BAFF7523FB201FCA3EEDC47790FB3725D3EBFF80011EE28941B08D15B8F510EF0E56E40607F2380BBAFE4A873FEC9059EBF8EBF67F942E60E5182057F280DA00A7375EF68FB20153B0410D1E3F005F24527F70015E8D0425D483FB8608BB104FA65BE6BF2E22DF338E2B95467D484078B9400514B68F2E28AB33F60C703883E1A9773C464D1A6AC153584830C85C5DD8C4979C10DF759D20BF0B3D4F78A4D20B9710CF897738A69F808425CBEB7EB581B35DE928CEAC6848083E385C6B121208C16E5808857C1A9EF172C79EF60802A429E7D7A0D5E9DA78789B21E140501778A456CAEB0E44B4D7B60D39FE0723EC4C8D39025B20067328A282946AE3812EDC025E3A81DB5B100673185734F0262A205EBF478424E023F1C764DE280426F1417ED8FC161E2E06A88D53D8618683D32D0B4D01B1A878012F9C6EF27EF282737B14102D4FE03BFB751DA9364DC156C7168C24A50E6D870660482766221E77960E2BB878335EBB0CDD6AB9DA21C08CF8534003566E6986842396C61F999E2EA8C0843570384933C72A7013206290D2DE6AC1308C84242E01309432FB1C20B238C98C443B204CA8071AE64193CA85B29C783C1A7012D5EAE0903890CB41D862086EDC0F271B8C232D36EA01738FF018A6A8B03C205F50A8C364A7545A283FF12558011434709A7000155BA8853BE128E3669F3C7B089E52B0036390030ECBAAF8832DC98B465E047561807BD47583'
	$sHexData &= '7FAD4D0456104F833A007425E84107FE5F8D41B101450FB6C1A4D17EC33A26AE8B35D8116CAA0E1F18BEF588FE411770B0210E4D0EB3A4C2478061245CA58683506F5A4F206F6CEAC2162D79DF6C61E876163D280C9F408BAC85E70B4868700AA9712831817FF91978F078F904201CC17001C145C02A17162BA16FB50C41E148FF6008C3AA0120C33F107F5275A966186B21849076030E39632688EBD94C546D50D94B800666F2F64DE2D0D8549702CE4A0E9598E25D215A07AD4C34382BF00073283C39FE7380ED0A1F146E082E385075385BD710470B11C3D587452B2A950D708E3F134C44C8E40D707A4125C5114CA4D1D3DC2DA077C3ED88EA6C462E90306B3821A62E3931DF4009BCAC7A84062030E7384B18D02AC63DC3DC498A1327EA4618F35B08D78E81C591035E10CC19224FDF247D0064C04278022D81C0E9BC6BA52EC9E6F6064E4C2B6A397FD376107E024F09251A47205C720C34E51832305854FEB384098B511883EA01742A1D9F1168AE1083FA038CB607657232B2330FDF64B79F4AADE1901F5812DA929B13032B4C99EF0201404E05C27F0C632A90ACBC8A38F37572003911BFBD623E384C0A46B237739A2D04D35405FF300E57BA860FED83E92849093B2D83F93308DB351F32B26C341BD8E0BF203A3C7F7718EB33792AEFB3B81DC7EB19109E10755EC2ED53075C636FCBB3B06210DE7210061875426A100E1C487F09B4C9177F09C07ACA74C5067DC0D1F949E60F8C242E5544C045FF568C41A683E0DF2D41003A006C1A73057F77256ECA04C366BA5C74070D2F757041C1E8108CBCF77F66047C6A440FB75106420640FAFA9E0067D7593974138030F91BECBB6B470D2F7440244102994BE9AC72E5043F741A2E70333FDF1978BB664439F4480F44C808A4037C5D6777B0F675E8987221DE0A05B0CBA0BAD81100C274FFE804CE2C3CFAF97AF7BDC1D0AE9026023A6CC31FC68D51EA0B78FF97F0AF85C136C49611FE077674B07685E41AEB0308DF04FDAC68802E2F07C2646F6C9F865DEFCA4F8D3C3690CF4894487C333638200D86032348791141B65D460A5E43231D2C7B18B6F053FB9B3B1BEB394B8D141F84CB302DAC4C7C4241073EE354DFA030C109971E1D01103F4D506BEE0F610EB87A9CE93774DB1ED65AF66D43100CE74D8D2C4353182790D59EEC102DC82C270ECC412CADE0EDD638F825F714F0492BF366FEDCE0AEA3BDDD74553004C64D2BFC32D424FF74FF097CDF2CFE4D0F42C75C057C00493BF7720260135CC176272F7F7A6647109A12A9E039335484F5571E1C980AEC06EB06752B4864A8C0FB3973100F8246E2A81007B3DF55096C0B8E66890471EB6A0E90B069F8BF1473EB5F4D3BFD750878FE54EB2970B9EC7D45FE47411'
	$sHexData &= 'AED62233E845318387326F6019E43A5AF823DFA9C4613C7044A5C705F9A76341A16D34B0E41B90FF305052751791CFCEEDAD648D1FD4898B6B0EF8BC5265F0C0E9E1EC35262505BB80EAC11C70787B647D13CFF5441556FC94B03F18BEC22802F1F8D57FAFCF04C8BFA4C55A8744910C3AB0FF04A1E7D4210A37A0AFC507066C74270EC3A7A35D74918AC307F33034DAE344B48078409A195826B77F8F1B6D06C7DE006E8587517FABE5EBCB5EEE041B8894CE6E8907DD0EB1DA3C3A080682A9CF8D314D0616666F6765B7C283C5E5820886F0744370E0788D0180450488DA87ED8CE55D00841BD4B3BD014163AD554643A04442A7C3FE96B7E022475EDB74DB8F8C8B9DE9B0A6B42B5D8A8B8B8C0762193BAA8C26D2A4DB80BDBAA7B31368C2BD188E2F079F3E6574518488B41C84883E9F91F776CC03BD4C233895DC25D68FB83AB3C83C78EC84532E40C75A013C78E800EE333BFAF73DBE0C0E041B401ADBDD64CD0730E5BF0B62110420174E0CF2A12C7130897510F9D458BCD15813E77DBF4C602B0BFB9BBDCB51F2031BFCC7102EBDB48CEAC0C1384413843797473F986EBD77E88FE741EFF073B0F2EE0527E094883C7FE442B6C3850A8942A32A8A45DC8E0526802F0123339DCA13AF8E083C310F1425CEB5B4CF0BCB81594A80645A04883B89790A185A9443D14394CA6F9DEE1045CF800742B97153B8F3930907B9E7D959C9B61182CDE998532EE7E13DBD9EB04AB7DB8DA2D62863BFBB504830DD134A95C9F80702B7D237DD2300F83FB01752585375C4ADD3158E44F6A8FE0FCBE3478F395EB76540275555E9B5D1B284D4344D474287E6C95B88F82C375103A8EE03DEA7F7B30665AE093743FEB304584E47507A18A70A04E2832760A5E8B02870A1F1E895A83E66F901011198D4610C3B70F6ADC6033DC94A084AD619AB1093ECFEB0AC382E0025314FB0E48C1FFFC059B860D2A722D927875262C419107058FE866701C2F49D98A3770C374DAEB45743B3C7E2E40BA5241BEADF647088D42F42A4D4A2E19111774BC6924A23451EB12FCCEC1D785B0B417FF79D52C28D29CB4127DE0165B133F49A40715CAEEB64D52ED80C50F10647607D670F06C0E4DE04F1C755CC7D89063B25F788B6616F13D8F1490014BCB454534BCBDB8A2C8DF90CC0AC71FB95CD2C4F0D080415D415C7468D3534EAF7F91061880684992134EB10C20B76117DAA9C4702050A0781843083C37D04D8B30F6506E8D2ADA83376F1C2CE6C56EE0FE4890267C87667C14418B06B997ED803D9248C76512C2081F912FA4104E55E15778813875568B07377B879AD74CABC409CAF44803F104A71A1744F2979410C1112C700E333A035F54004E08D150D6C075F80F935CACEB23D9B4919F9507B8'
	$sHexData &= '12442FFE2FA5749FEBA1BBC0E308D44CD8AF12083C5505E8C58CD7A8D2F8B5CAE62FC448589AFD6C66C79ABCC1024D3E38D67006734C4D053AE869F0BB99571D84FE401C903303025662C12796BC90884071A62568451EAC595CDFE9B301F10197AE06C63D9F901FBC7402461357F14148605C41FB4C27292BF49118DC90C6BB66D8F001F8AF4628544E389E4640C9F3DE47D34E282A482658602E341A841646481D70571D3AAF79C0D84A68048EF88AF109B7CBF78D4E686334B889D7C6DB48FA70409092507F5013C883B55E8501F8C62048A4654D5AD7E4C88E099F484246584660B0DF50162ADB660F6F0D1E6D725E70D60807402C24AF98560723044391AD2B63F02DE3980EEE9CE05AC30D398C2410970EAE0DC9E38C9ECC8804308A0FD9422E0C814C5E180D271F62903B91162F02F1FA049C551ED84C764DE745E430E888C7AB19890E8C5B570EF9FA10995FE93E019F09E044317863BCCA03C3A2D7220EDF3F5F55456CD758D6880F1C6C9032521969567E06C646090B2217EF26770865D2837B3141BE046745E81FC4D7BA5E44460304551FEC390C320BF0571873139A5F100B61B4A7E97C2CD25FC67E179BF901DF4F41B80385935629A6D27418AC0F270FED8CB7B11F332AFF00742CDA64649ECB3321EF07EFFF4A315C43CC1257AA633C9724470FB007A698FDA4FD04012200EB1714C70C41B12277BF324887A1BC1E07EF39B262144645FF4507420E796D8800A6270F48490BACDF2FD68A1AF081BFC1D50E3ADF718B915F0D5414C668363D076EE4D34BCC4378839DC3126FEFE94368001F3E281105EE7A955C5ACE1A68FF1571284434EB1357D68897C6A8C409D31F41C1E0604D6053EF12920C4411C12727A07A01623CB48405508010B431461560CCD13A305601FB58CB2D542C41BC904C1560451810595F65B369D4AC6037DC22DFA85461C9601F61D49FDAA967B451AF292BAF51A935278664ECD45147A2988CE4607BC0038C53624F28291A05CE21CF484868348755ACE6420CC7C1FE78802505E2000FC90ADEC620EF1CE7024F38355EF5ED7B03F9BC389C2BDEBFAE32B245BEBFE0A43248307590CA053050D8DD022E258F4150BE81B84B7E2D4311DAC0FF47A8E3671E04528B491C8BC183E003095B11F63C03756A24ABB96D1FE0EF5F448B421041B9FF1241F6C001B4C9894B80B7DBB7040CBAE00A732534143D0C30A0750AB890D93B64FD28403A3D03210A7DD2BE51AC72107424033DB802EECDC68713F6C10274944A10EB06C8032F7612B37A38684A20B80736E03C0929CB020C44106131DCFA68458B5483040B3E39A801352D2B230CEED61C4E3481F92FBC7FC120ED3F52160363C01083C820C1E80498BE69C1EB35EF5A407711742270B75B9'
	$sHexData &= '515101D0816182032EB0D1C7B740E0AF837372674096A740433C0EB05B8D06B629461066140183770C5B55BDF901341469989CE0F58ED44C5B0F9A68BEA88250482081C4EE1060E3CE109BED96C43BD706FFC41A4483B4310201270C20AA9C2CC9FF8E030A3EB34300938E989507878D2023F72905D69AA6D8CBF31A8E27BD42556181B720555E3E0E8B298DEA6043605FA7F077F66837F2C2E75290FB7472E66C40D97F09A133C1C1A2A301A5F699B01C36A5874D2EB4A41DD5080FF8BDEEB4583FB05750D94C5863ABB126AF0A003EA339E2E4D202AE3B24AB8E0102819C127783038462C005B84B218069B6145CB282F52BE8426E83CDC02B35102070BA5D6FFE4162E08B4C18B02A4D911F15634240A14C7411CD6F79648DB3B1E3E7520CE1C48C1E10C4220B0D19818C844820E0F766A68D6C7C02EF58D783A5A2CB0409810E9D9DD42E9CE35DA381140A6451A56AFE82820DFB6152ED67718B91FDE9C145B055D6BA325E240413E57EBDEDF06750977EBCD74411FB28D42FE41290E70492C28CC5008DB2EAC46E44980D1FA52DA72799AF156925710D9DA0FCF549CA751512D1AF9538B12CB282162219FD141907F20252736561F0B090DB88F84D5F1446F45FE14E82DA8E6A5120E98293F76A0248027480F7C6D52C11B99456933EDB0767E0E483CDC1F551C046E721F49C706119E49958347E3860E8128EBD0FB6EEB68BA39268B38A4ED836817C10C3D6B3CE254C20E464C8C8D18EC83703866137E727EAB815F30CA66F3ABBFA4418980F89103F8A714967D01BDDC1474851AFF983E04D6E0B400871618CD453DA21F4F4F850C14483D6EEB20A65B69F68303995385ED0FBDC3BD49D0A1F86184163BD7FC96164DC18A519F26EB5280CACF736B226BFC4E423E12C758C8772F831F0A8377C26306880D0E7A02AD0E89821EF883439F7F0450EB0EE802E00207287F41C00B0EC1828306440C5309C02BA1ED9082E902FE3EBC3E0630090BFCFA457ABB444A69A3969D5E184C1969701D7220DB5AA052C1B157BA480F42DF91366AFB073F421DC67D19145E0FC263815976883EE913A0C1D8D32E415FF50690289EA539EE4C46DBE7E0747C3608727166082A121AEA2904256E3ED7758DA7C0DD3047FEBAB722C2D0A5E03B433D0E9AC10434FAE85FEB79FEFFFFFF51A7897E10EB151826C8AA2A0E597E1E49677022755E0CBD3829750A418F243931E13B7F030A3882090B7888491CC1004771B55F061F0C2355AA7547FFFC8422FC0FBAE10A733266345919B9026801EE1E424304E81E7FC2CBC20BEB5F7707B90AADAB22FCFFDE83E11083C920C1E904EB2E83FA498F2707FBC9EB05B901B5678913B05CC1298123C819ED3815C12C448932C06A324644B31F93ECB06B'
	$sHexData &= '544B3FE3084C1F369C19B74110F625E2704C8987E00F8962B27514C702034342045884FF61DA28494633FF893ABD2739C0433FDFD721C61D85948CA8863A4253E816D09D9ACC2F2DF4538AEB0860B579E9E6F1483441A9A777682153003BC6741E9F6E9DA880D10949C6EAD56AFD4C3BF675E74C2A3548202BC6FB1EC8538D067C2573157A46047D022AF45C0404084C76D61C30812520478BEF008A3EE0AC4C492698FECE03B06DCDEBCC484B1580E2089A07395127A8C24E4D1AB032865E9AC8B11333CA22E0D64816B40AE4C35C3C403220D42BDCC4E1BA60137424D8650F20AE5DA97C680C07028BE9C8F7D8C57FBDBD754870740D8C44E98BCDEB3A348B2E57DB44F40F570C47118F0B17CA896708990FB6E036148307CE18753A4D915C4048926B96972E90C371B58E34A34AC6B0A45040013563B295D7A5069AD8522130C2685A22E11E2716AEDA9841C7433596C8A1AE14BAE47063788606E7B572355A5C7588E526497E187E10AE431C1EE435498F3A2F3D9A3F1118F710026001704C220424349B67AF99886010837E74E950DCA9549E0E80E257524DA72B1D0E43793E39890BD47706629D6CF82592D4B608137BB1E9071130F90A557ABB48E04930ECE700A8B47DE062E512F00B91ED8B45F03C14477118FA082CB869CBC003CB734DA8D0D70ED8856A0887C26847D758C0831CBB132F4DCF4D41D0760163C91FD5CDC8C973A0B0B8D0FAF6C8D334C2D0A041B5015FF21C3C6F00061020C8A0B80D9E90E7A0B0F87540093B83A10BB190FF451D19991249BA0F43745B3041A9E1E440481F6F4881E0AB4A2445128949BC0E065867923C9567E65D11381040186EF9E3A94820F005E15934B3BE853EF3288F2817A874214829094050034C0E69124D4D5CF2B9D61AAC2C38875988BF653648B33810584839758B3355ECF7506F5A80295508C7F1037489E045CB505CA7BC51763C883BA0DA901479EFB2759D018645D04E78C03AD89806254C1287ECBEB3104A855E1D09441BE805604F7D7C2088C46AE7AE9523DB12DB76C843AE9D697D903E73D925BE144478A84C706240AEC412A11280CD116E559FE5233F70490ADA44C0880E54147160092180A787FE7E922BA51E4F4F4585F6114F41BE37C2A025A9B8C15A4C3BC15D0505C2771D5688B74247811A579C41EB5538AF33B93C8874634CA74C49507907520E008E430D184E894199BD4DDCF171CDC5C14166377CAC0626BB25D236E606216E09D3ACF89688D74FBF4196AC84951FD22E427783120FC3B2DBCC26681E71077C8866CAF8C7A9444128DBAEF8FBC947CB8841C566E9D84E4F44081281F53C1FC1605AE434268BC31F2010E2F21AC39F181C74DF5751184532EDC55CD5C50F163C1CEF03F1E80872408CC'
	$sHexData &= '3897C89CD41B5ECF084C163B1902F51712214844E99CD6E900F719B7D88EB1780C801393CF1759FDBCDABCFFBCD3EEC100037FC53854CE1BD48AFCC1D383A0813CB4578152945C027D05B05AC02AF7948E4D8312F819BC013E09A6760C12F1CC430C0F2844BA8E828AF3090CD2C5001A268899E9F688419A9417E27014180600111B7D11436A3457DBE9F5D38FC2A1F8DAC24A0D82460C1CB959702500292FE0285406DD7502BE0F1F74CFEE463A400E744896456F84097EFF322FF354C4540149A5050754327348D2ADE107036C6802006F5539ADB98A1555877324FBC7135E5386C609C2D87531E1FF6B5BC6C0D4027448D816820A4DDE6DDEC440D3C6458AC0FBAC84535AFD546B6A5C0FB0CC83ACDB31311A4C05CB85062A5DB26FDE4BA023524F70E02BC1BB8FB8503B94803CBB60841FF10816B0515C8CEF35F642D8D42FB7507B067F047E57EC3A0BC277F3E8B8DD1B580DA9E7E050820747C85981A7C180D3100001B7044CE04F83E107C182BD61138B7CF0F2BC2EB2E5C047546775E4BE2CB79375C7088E9283495A8630342C6101126C80CB22984A70518AFAE6E165C860E98A4EB08B9FA1A3C0C2BCE29079DF70EDA0EB22F2CA4C7C32F28B8E258B1DA48FFC838F321FC8148DC18F0498D560107D685E5DBC41DA1BD3AB2424C833E0220E4D8E9A1C001D86F41BFFA7E7687C241DC7BD30D57560CA07EC7CF15520FB701FE3BC773350FB68181E0A836045C36D41EF60BCC75E64A8D0C763B12807C3400C63B7483F83BCE74B8E902EBE5AAF1ACFF602D4E8D1C7697BA13C1463AB0663D1103EC76ABA0F9B75C4C3BDE740F4983EBDAD2DBA56812BC3ADE48D1FB96563948C26109ECA9550F96345C783114830F4C2459D4DD496812D018942917A6FD3B02FBFFC966833C4A2E751A89B294F77C3505EB68D7B1FDF871E8DC5104F6154019EFC572F2F682150654FC1060DC233A1D8E3FBD920D18BCAAAB23CC8DBDEDB00255425E8E500260023BB8585CD0BF3C99BC1CDDD315635004CE75841A14DCC3191338C018323714BCE0B43264354B881AA48ABC0BBACB89F50C203D8BA169E98D1E80DFD49041B2BEB90752130BF91C54D20200FF58FA0292CA0139403C370B3179A59A3FC4DA2801EF88B32E433CA2740933B3BD2F5311023D1EF136A6981393464B39DE1558E0603553013E18404317B41E0F01F0E26C0B782767EF541424EB068C0F766C18FCEC80C1DF30E66EA28BF84A7BDF4CEE7D19C60562FA000C5CE6213C12493D46E82E6D47355032D2901B730CA8FABFE032562E063C060F94C232C032C98432246FBFBC5DC87C1F52078BC381E30E23C0C1E86EFF9AFB05240181FB1556C1A78805FC35BE880DF7C63889EC0ABF3F82AA2B8F1CB0F933F6360A'
	$sHexData &= '2E5F65BDFA09776748982CC898E88B8C800C69CD4AE257DA03C8FFE1F0DC3A4F9ECAF37C10133B46523DC995E7F95434003C2B2F224FE5A93C66199D10C460D8792A07EB0CDD717DF00FC6099C902DFC3433C30922B8DBA1685B0937407978B02159786ED89AD2206618A134E0DA70684017419E086FAAC1C28E5F1BE464904858485881C00E600B9F2908067614F5489128212319E46438283844929391011528EC3313CFE3DC8907850ADB62AE5483696D984CBBDD4815688F2E8FC6EB1B268CB01067025E691866908D67F8069EE7799E967B726960575058E7794E45DF55D435348B56C1EC7EE97B19FF218B511C85D27E1A052B08410FAF2C01D0F508F9022EC2BE7AD25C2B6D9FF3E458486DD01BEA028911662ED87654602611412AD0067EC910F06A0C0CA7D74A300526C14AAEA814A3C92B1BB2CBB8109F0C800216D23BB95CF6027023B1128B0A8938A83936F802AA37F6DA255AAA0F60B9F2DCA7D985D6BA0614C83D021838877A17AB81E43BD75334820BF838FC88FB907EE27E5E72EFF7833DFF0C7215DFAE03B4E3100FC750092B1DE1B6587A05D6306B0529F911B82C20CFF702DD1881EF473C393C756711D783506DF838F7330E2F701538B1BF98AF8049FD21345F77EBC6936F8041D9C094B83970F0800716EBB386400168152B8BE6DD363E8CD5404B2C229F5C584EBE3464D0F3F402C8A0C0D978D128426EE04C3824B47890527C10CC22879C838374625C142DB00A661D0FE2CC5CCD87A11A1795334C87E1162DA4E4C95A04E0D678D07E2DAA3458FE6C86F602992848DCD3156D0DD66C590E8356C39A2A5FEF5CF6683BA480D6B4266D9946D68D70AEFB83BC243E88ED1D0932669C6BD23443DB5B20A922A28DBC219DD58599753141164949681EC0E88E199F0BC42F0A0260D357483CCA7F02DA023A75E7227BA28E0D51E21082F9A52F24A14E10B08849125BE24005E8CF691CEA0B41C6EB053FCF5413D276C8D0D73038D2C2915A1930DF48C617C8A72805354055536573B5B0381D8080015743397202F30270411F44B01A23E10FB6B5722FDD2A7C91375B2C90DB25701953BC1A47914069706C78A3B27EF544805E4EAF0494F6866A43887534AC7BFC35CEE26A473DE347020D0C70DB31C463298D9116FE0C6C9AB59177DA886409C4A2885865C01B5A253A65F85547E8CC077E6807166C05FE0BBC6064800E8C4C3963107447C5ED6C4A30308D401580472A2395EE202C8530483040B706E211455F1770C11110904728C832C43BEF4E5F103A29332087CC54B4373B0DDFF809BE1655B4B23D14049B8001F29001A902FC86A3D5E88DC7A40C0447E87F944DF88BC124223C02C05869E6C645C89515A845F0E374E3D4740888283B6F6E7C6AC0832'
	$sHexData &= 'B4AA00C3139E0C6D87D09319429568B7D4CCF2C38695E146C8890785703F9607E3C8742AD02BF50A4C96F61057000176352A680B45B5DC3F9A101AE7F5580DA20FFA7C91E5AE001CB2CF0697080FB22A56833F6627D68F07F0A2F48BB25232284E49CF2CBBA059DC5174A742749B9B30D06E06F2BC69F8C040A9ED8490FAFD948FF9922DD08D0C872ED4FB0F9F448347E29B004F2413B92CD73C048AC01C8714FDE529A32AA5F01BCA277E535E244740DB027FF0DAC36B2C8F3C801BFB06304AD8A75307E98C833DDC9E1F89DC0B918B2B762A3D319E41E28A7122F429C1CE4C301793390F7F10607C066D31C0ED1321D0F1F09667E28B1384626D90C4C084DE8309C3C87543046003AC40432F2E018180767736C1DB4F66F541A45B6065F38E6283F70085580F195C70A2FA9B059CC9024468C3A0BF53EC6910FCE708DB055360C46DB5B250DB913B2336E20D215B595C990DB76E0CFFD8D4DA1AD61A9FEB03AB019C99C3457FFACC8D029F41C6A7E6D95FF01F99C9CB8A0D08FE001732AC1288C5D7FC94B23562598300FED2A2881A31F1CB3C6ED957E784C397910AE69B64C359829693590ED9A85F61F93A7AFE9FEE7418BFFBBFE3F6BD364768B069B056034FDA97FAE80FFC7DC5FFCFFD1C383FF037CE432C0EB02B001886A84C07505E99B408CA036D0EEDC5576E040A25FEC10A42BE11BDAE40FA14DB6C088585C3A2A230CAB2C5274EA3B246BC07479B9E9CE44FE017801C953B03681C120B548EFE74F6D8B287737CB39579AD6DEAC0C2535FA50940C0CF2E05C6E85208408FD3C769E6BDF29C60C9CEB0E9259800BB6B8A78AB6E4BBF31C263788AF68942D8801D266B51B7B296B81E041B87A7CB6261B786AF0663A1703C8B2F6460523399C408F5A5EB821FEE1B73559E3E0437F4D1FBC39F0941E6699BC39320B5E1013B20A06C4FC8A1D92099A9B8FEE7DEABE01617C6FA0CBB439FCA7B613F0B984239D53230DFF6927498D1C46167C49CDA92EEA67EEF8C041328183F82BFE48D19E961F90529D0B77D0DBEBE081F8D316399599B6203B4AFD37FD48A5864B815B839D365C721372ABB0C0012E065EFB933B4282FAE30449C7C0EDA985B32092D0C0C684A47B7224841478CFB009C15235BC1EB818B2C977B769E823F20838C0411ED6391C5DE11BE26AC244218E95D825A2750DE601290CB97C3F15005B833F22230739BC9370DA5CBB52C4B00B219B9CC823093BB033B4CB04C99C28A5956F76B3F6FB41833ECBA125D38D7FD02AEB8710276A60EAD768FD812BEFECE2FFF0D8428C1750C32E8F33DBBA143A4A138937BA95385D2F135C2F123603D953E833CFE7B073132E222503162B134C13F1D58CC64A01919B0FE1BD7144AA0664CE175D738DF21284F283'
	$sHexData &= '6C728C7869C5383E746054347C3FEA915EE5400DF8247AF96476B9AD95ED4F66901C15E1FFCAF476E5FDB21805CCC84823D050B78B0CD1716FA57019BFE90C0DB414747838DBBB088B77BCEB07201D9B580CF7D5C0377A5C33ACBF3B1D8932419E76DE733F7C78CACB6685D87ADAC84C18514DAC29A5822EDF84C924730EDFB000F87C58305AEBB8195490EB055678800C8806359840B0B9B40ED16FD01B0CE24A72906F4B039C02394D6CBF28F9EC54E047F90105E1F80CC9F04207030DA62A80B64F38F062740EA66CCE70FEF679200B74D0200230020C8048533840AA340A5844BF9F6A016F2AE0E2C0BAAD1D7BD997875C05FFB0D53350CCC8C82010504CA760850BDD8B5EBE5993EC340005F2F71C9F59794D58DFD0019FE55B81F506C023B2F904E2498BD1BEA9C1F0EDCC6C28396970AED809F36E93F4351E227EA3919FF36E9358F958418BF5BF013FE4F313DED76449C4F5C6D1C783797EE492FE606E93498BD788939107041688A0DD6F684DE5B9480847E2480790652EA31C8C91388DA52438096E0186178291B8A4913243760B47E28A2B596C2A0723B17F3F100A2C85744FEB2E5F29BD724118899F83688FC4D7A878A6D7C90B7EC8894CBC0568919322BF7446E214E693C3A5A5DE4174C96E10CAC4A5C0A338340C72E46E08B000BCB9F2F2106F236E4A37B00007E465E5588CF5203FB8005E416969B5483F08B000AD2DBB4F35A3389DB40C3578B98D546E58AC85B8CCF491CACB866F4534B80034E8B03AD82A0159EF3C7F38CA95CB876FD0202CAC242084D82EA912EB6B6F426C294851176FA82014BC88F49D8F980D83C3A01944F4E5C14753B0A9EF15B426E6C0930C95EF2E1470900A69C6D491549CEF0AC7C0C76B5D8E2517E0FDF3C788B8B2D20057404DB94921F29ECB0939C001D001404879F2524B9368232327390A307FA8A536C9C92123580858EE401EC954A1F3321C976EED92FF0C98ECF82E6090E088794839716CA6C2074571362D408B1D584927B9404801343ACDC019721349B9D2204F4CCF1F49BA9044D0E47FBE4C33C84D0FAFCA114CAD2CC250F4CE1DB9EC459055613834C61E92C9DAE07635D13415B81A2F70B5472AAFD3DA30202F830D02A40E7077570315130D827BEA19729D253E24E53A07C070C2685A9C88510C040F2686E6C833FEFE4E33ACDE0AB9C283ED1DCF1C1C76460EBE1C72D3416533B2AC1CD0971CD07D583E150E0F1D734C8B00492954F856FE4A72BA81005CE0EB87C33F65DCE46BA27E801CBCA9F3DC574848337511EB324787E05DDD340F10C1E82020333B44448D2EA949F892948E06C4E18D3CDA1A218BD01E8B202C45F8582C7F3658E2701BE7D65200AF68A1F165AD14E8E070C863CF4EE203F78F5E621B6'
	$sHexData &= '5E3C7918E8F4ECC45974C4610364A050A4D1934221EE1F8CB33C949BF4366CC312825941F5FCF817C2A93C6209E1B8EDC0CF23D961BF93D881B74578BCDF36D7F3020FF1A827309D67DBD80C9621BB7E43476486C9E95103E4CD11ACFBF1A15679393AA1AF7221BD9E2BB688C8D79D8C7C49C1AE702E3C0D9DFD316C7A90682D6C8B513BFDF905730059FCBA5CB1A0CE4809CC31AB51ABE21871458241218FD19C833BE3173C80F107120E0207CDD937A4DC7CA87417EE419E9E59283D219BD1CC80574A82BA5D73A666CC64520C6EFE04B30D844CB3BDB4DFF5015A48C85B07B14B01060EFE68A8589A41F87FEA701EA94CE294D9F82AFEEA666FD138D459F3807F555C7BC1AE4C5357C2ECA19DB044C19921797B6C23BCB2A29191A9013F214198C1959981628AF0506199316C57DD02C0C368A45C7F212526817757F41C6461801EB050D006B540EC689DB901786E000562873F01AB5D498370CFF089D80D33CE5B9667230560F892FCF3969566E3D4A187DCFCFD7E93906E943EB13D363C06BC0188174217B1860C011307FC306FC22707E448F187D5E5EB21287187918767F1012E8A0F03010F9547E7C044F1006E017CECE17744B2B2FB91714C88420C83BA75EDC4A3047777166AC068E03729A85176FDFF2396440FF0F6C178E938FEF4D8DD642BFB76B669E93E7C71F17273620833C1F68172FDF293D07E4951717174A2507D9F19F720117EF16E038C3E4DA16775317714903F11CCD16BB1ADF171C0483FAB707B54FDB430B961029E4693B34F243E2861651DE7116819CE4245C16471608931CE44F1644160B9007CB06842716F89816081BF01C1A164D7F693079B2780116EF15FF1534870C72D016105A4818298315646A7A6AA60528300F06E96988CB7057BF5685A7028E15DA334033ED1C0282DC9667D9024EF90A0408C0DF9AEB017C2201B73D8B4645057FD902C26A7A9778429075036B7AE2F3CD7425773AD788E99F7F7B0E156E06F960811D0615D91DF8141F0AC0467A2020B2CF96D7749014BD1471A8146AE304F014421F1802C704EED2CB287D880063036D44A7EF6C7D919EB766381828C5CB771458147175043AD006A179D9B8D0C8BA2A6CA155EA850CAD5394F33FEDE5E085EC3A2FC04C12154C3BC0EFCF53DC770C34582004498D50FFDC010FBE1F2B23CAD8F713288BD8EDFFA3736B07BCC32CC2A634C5002C5441F8CAC8133C0E007523DD7DF7AEB42EB089040EACAD14229E130DE068D3BB4023C3AEC160C4A1CD6B2904691E662E8C83D23AD222319087950EBA51C23054ACC4B9FB891D679BFF056848691320CF4583DDDE2D5213527AA6FBBCF6394C03E0466FC0A2E7ADD823C018124EDEC049A80E85DBF2DF1E13E9D3143C070013B64E2F'
	$sHexData &= '6FA92095CA4CC941DDE40A5AE04F083A5847DB545647EB7435BE35C6218D004C322473FD127BEA660161086CC59617F0D30BFBE6032160255F74B0026E87D07F4AF95BBA845555775F554A2B11DDAB054C2180FA481A53F05C09D0A1D5022F7CCC3CD5024E0CC7D5E70157DD49DE05CAD50205BB1C87B4DB383B94E7428C1122F06CF7D6356A122015834BA72221E0565250C825EA527A6A7C8E90A33A56440F474812A4CB7410E264ACC814C8DBB808094CE9C7C0DB6A45904710751C6825F37B5751F71CD418E30D095C4C7D8BF0E80A48CE92EB2D0A9A812A4CFFDCF7F4431771DE1114071E175453D314615D1F0CF70FC7BFAE4240C12446EB064BA3BD1176270ECF819057A9A5A510A610F29017728C107B1078104DF3540E6E10F8F9CFC792CB412E1C3F100BF2F2B91C27100B24101510164CB80CC78BBE8A326BB00244A6E779CF9B1DC71ED7100EDF18DAE1799EE720EF280E1EC7D56F2EC016597D583DCB0F37004607EECC0DD524C420E01C7F5DCF7B8A974D1850850F0F864EF11E188D7E46761D69C39B915D58DA03D9DA540FD83F0FD6546529264B170E130EC5E7110FCB060FCC82AA41863C4CBAED0E006CA38FBF5CE35E125E08E4132B981D829099B03891795FC977489308ED57D102271CE920D2F26858770EC8CA65A3D22895E25EE40EC84356C7D2BBD23CE43FD480A1A15E822500E9CCD8B0FC322FB008990F7742330D90649C705C3E0B800EF24764471880533180DC00FF9F67FB1FD06050F8498968F80E48F001CF3D9BF040E8E839424C411CBEC054CA8B4F20C05F6733FB3A2A2C10A0408B54FC48F7203E13F22BCAEF3BD973DADD3751063C9AEB427636BC30C2A749FA69F8D876149BBACC2FF0D47E73EB1B3ED9189DEDC387F76BDD33D2962D03FB4C7FAC137A977D0948DF120816A6904880B608409F00606DC126EB4A262E0416D0C2F44AE2C13A6050BE217B3FFA7759DCAE046B9A9CED3EE97CA0E70BB41F7C46992EE1C652814B9EC46070AC20241A0B58A390C997D2EABFE64FCF026A8BBD30FA75390215822A5ED2992BCED05E5A7979203B148AE053E2BCD04A792027B0D031E2C471695080CE070529DFDEDF8BF60525644C2B05160C49440349B9ABAAB85F466401808A0D6D30CE8C7B03E9C17420DF5020457A0BD89E50180EC8D1C0E03FED4C03C23E0075E5486305BEA0C793673DEA735E043820D0DF1D0BFF6DE0104D8B4A204D3B4A28220731005344E4087A47F3048A604E060807C2BDC2685B01044908065106422018EB0234404514E2D1BEB3E269C04A18D2B7CB06AADF521723808D60D54313169F9F807921F4D4FC9240119D017408E81EA32070E2DC9F4E81D118A31F0356D9A8C3A818C222B001B8061293C5C278A83'
	$sHexData &= '491CD7EAC2FC05518E929894D88FCC6A78006BE55AC99A84B3361404F6207C24321C91612A44560C042E187A34D704C9B6A0D90BD07307BF657BC9028C2306025779CF8417826C6264DED84273B02F814D328458BDE18062B1400FE4066C74548002266895503D80CB4402E48BA4D446614AE30268E4488554C5885593001D85837F34E95A140FE2649EA28AC6D0EE2765C7848448B628B78F3C646D7D45DA3386C0E303715646745287E36064D084D0C6FDBF6895D1041C81845161C45B62041C645E6AE86EDDB064900102801A5CA903110023C5449858070EF16D0A3C3410F852943FE16105B2A5F0C83FB4B6F6E0151E91B38A38430619B08E30A0FE24144E098D1CFD7E1603494107005E51FC01F1A988D045C20C809A7A71F83704041105C8312F71EC849106406E6467EDF704418A0A8E47511B902B53DDC18CFF066AA6528EB31906045706E675820E78545451A60419866D1CE8BFF45F0083EB010DB742DD382C0A1E0751CCB750AB98D0F8523BC604F65423A85C56C80B076E033D45069087BE0F9700AE6326B44D2F0B24B452966567A8CE1EFABE2E005DF8EF0AC3C4420A0809C3C20E1E32DFE515A8EA0BA8B7D205015F22E8422547DFF16FFEA815C4BCB5E45F09E00FE0AE212720C3D0A2026D0E3A12BA044050D01C25001E06DBD5658897D5C7E3D0ACEE4AD34497BDCE5F2E4A050EDE00AE9DB669EA38BC3F8B40818928095009A10145EAFC3569DCE4C042E107EE17E98A31E921D0454BA2684A30644551D547A0892DA115F258D0C8DD581F9A4D2BCB94F42D04883EAFAC112A1F5BAC26CC775D9130F11482DF848007DED238121F83604760C7610C29DB61CFAA8FC455692270F37F3C773457CD04FE0BC05FCC797807D1900EE7480B71989AE740958F86F6FD021F29AF82BBFA8EAC111BE0907C9ABF8730A68F805BD41BA21EB20761E47BD90805230DF38786C388276AD7A008B16119F961854D644269325723EC2C844481CE08144449C346116105D4E3D8D1EC8FFC6605D7F878EC04C63E84C03EA98F91CB55000EDEA68E09F78C72580F6B72C74850EF6C1EE1814C6CEFB25FCB718FEC1EF088D46FF3CFDAC88D85CF7A86D7A6EC60F5B7E28F7B85E7CB6C022DB85B19DC01C59C6B4C1102CD8D095B44746644036C7F8425CC96B16706EC6D026102CAB817C0468FF90BA297A574A8D09B264480F49C0E644F70840A2451C4EC1A974CA3BCC0064745F6C6C2DC8835C7085FF7481FF5C382B956105CE805B78787C851DAE6D91D23881FAB930C78B9EC16DF0D6C1E208690BD010B311455145F322C043363C7CC8D53E0A0BBE89148841FF1A3BFBEE87BC6D597CA460FFC113F78BF3620E358B3F3B4D2049BC6391C79C8BF465889305DE748711A620'
	$sHexData &= '409D8075AA753816806224552AC2B82D70870C7C4D2BC1D462C8B8E8BA00155C306ED6C807D8C604A610F7F18385085B420F47D098840D967550CEBF418E36721FB680F0144803CAF484D70320BA51CCE6EB0960CC7111F85D07581000B9388D10E4043250F213D590E95DA47322660826624473559B04BC0806101DD6437CA3269820528864067D90A169A63252EE360A141C249CCA9A84E48840DBD8748B705A39400A189DA61136C28BCB9BC64320A46702835477268329815CC65C23CF29C2FB01F0007B5C7E08DC0836699AA60000F8F8061914618055C6E24509B8E7FDC10C0B418845200E1921D4818B0247F7F31E15980C351BC3F7E0C0AA6AEBC910BD9E90A525DD858107E8FFB00191463C0D07C19441C33F1851292CA4204B91B8948DED9BE5C0881D5F55535988FD4F364D653803A89864C40002A81D95572A8BF138AAF044F17E5A0F21E273B006181FF8D321895E4A1885C9F69A16B5CCF1A58B421CFA15560A7A52088A8EB169D1FA024C9874D091B7B5174036454910F62DE916E14181F85319FEA3DBDF4924B815AE47E17A140849F7E29C0822C10174E0B447E8E143380641BBBD2024FD01E047D84D938D1ADD7A017050BF0D49BDFD604591FE41BEB979379E9E43F6148148FB35A3D0D736D51644810118D0B32603720203FE58F518F7C1E006EC18C1E92203C6B4EA9B49BE3AD94D03C34D0272AB304C55834AB0E6745E60B823558DEB5BDF105E2E9F7B85251A4115108D981A183712CFF5D4016D3C2997D94195183F00ED2A3F1299CC859122180D3E8191F625338B940DFC005BBE73F97F183DF4D61426EE5FF3BE74BD800C4488D1154A07025F305E609C10B13F851B79902791DED401FAD4011462A1E7E4B055D484B3413779C857DC1859B5D30639C6E4904B1C98BE96E4D855C17E6D9C350D7D136763EF712B4270257EA3C785D8D3C11D238BBD339B0A014DF8A46045D8CAE860380C368C8B95DB920DB21AEA9B33E85801242F5F43E71C38EF80018001F76F44293DCAEB41F6C204754E6EB43C37975008C9742530B796E4370068010AC17108A004E700E2E0102BC3E0F048CE459F4369BB85EF28959623877C76585890F0383035904D4D36F0A81BA77926FFB066B8FE8683918F45958DB41D0BBFE1159B95CBDC857CE383A6368D33FB446F37AD5BAA818BA3C5705BC11C9DE50DE8A0C0DD5B661BA0AD1A0DB7F65B0A431A5F1089571844141CFA5720C60D33588147BA85B94F14D5F08DEDE0DFE7FE603F996ABCCE0B4606488BCEC2F84D2A5E23500885F194E4FCC05BE886D296A730152587B1A663D715351BA7EA4BD34C202ED2012781D1E0A11530529AA9519426A4E3FA932C33410B55CB1C26284832E300191FAE55C3341DAD88D31'
	$sHexData &= '64C802A890A5ED6CED8CEC38576D58B752AE054E015CFD3F83F89D15F78EC3220CD38EE50020EDB50AE9563C374D59E3118CEEC70921298299793E84AD702D3C5031BF4B04290004D604054A2A83220BE58B834820FC7F8AE8BE92EF54A4539C2F00B7E811CDA93E86690C6C50FAFC248980EA8F0904230D04F7FE04260182F93CA421816237010FF9AC541A13D6103DE63C8A244068849F3C6102673F841C1EFF8629C0079938E5DB871C6019089C74DA8808A71F16E58B86B8FB1C261385D7CC1E147C8FFCB677010AD11414963C6890C8241FF308EF187C6CB443BF01A92C5DB62A1D0565030C5453B6C3AB38111BA2B3C8C14A11301A343AEF470F971CFD857D3456EE894223CC30FC0D0B62BCBD36FC21CE25D20122077BAB7E448895CD638912E6C17B5DA6AC06D106DC861B2A9796D7018D618CD5093D21FA54F9B427D18B208BA43CF64D8930506ABD2BA022580904341A68DE8049E06969010DCD4157198D30E5EE430FD4B77D27995522812F9943D7890055013A046D2BA3CA402666784894F7C7AAF7E91F50A85939CBAAF8C89B5F80B9DB3F6F8C04D4930954F4F70D1C244DA3C8D8594CDDB70077680691080C7859122E97DBAB4A4888C9BB69E889C4C0263778EB4AE2B952A3DD4C320F04C70497AAAB4C33BC639967828705E5855A585C32F2F5B692A53493D7049784967F6E2293B668906042E06955EE44A46F0394CE587E64B70C3735F302BAAD05BD88E22C0D00AC8890ABF80BD4AF31A0E13657078901F939370700A0CD04A4B0B6E4A130465904BB38094E87870D854A9BD419A65EB1C761A2ED8809DD2BCD29178794038C0330490FCAC34CCAFD2D9A461E04C03E2FFAB52DB46EE441EE95F418B3484448BF64100ADB434445D412E20C08FEB98746641ED8805953E427D94405D990214E055A02A8CE784025890E7848838E5F33CA5255A98549090086021C094DD32DB01BE73BBA4539C0645A0D55295921CA43E41E57284B439402F70950A60808DDAFE40AF289CE6976C30C748402FCE0CFF8B093BC7011E9FCE4F4D853286B9260D6466CE57F04BC009E448C604A05D699D935E102A7B2266062694435A415595147D66984FF00675F8988827593DE95485475B39F9A42B43617078265DADA470CF673C0A301F48F0FF464A89496626E8D9C0A3F750986D9575BD0DAF1E68770AF8B6D00E700672B220257B36571047B8BC870C4747201291218B014B2C03A8451A7066931E270C49EA2001D53348189B9336B22071CC2014AE28A3CC550BA40245A5266143BEA0BEFE44887F289D00024B56FEFC0F28B4242003BC24100338035CC0AAA05BBBDF40BA80136888D84009236BF924B502C818132B5C4978E0C4475A42983DA08BE3C346F5954C0ABA20'
	$sHexData &= 'F9CE8B4599B2D6CAC43D865DFC72A9CB2E8038BB1E2C75027867C138B6644523C0DB24B7C9175D192044E44CC7A4CB10C9A7F913C8364C89787880083E10E0E07D9806984201A1CB84966302CD983401C7E8C6E79668CE98DC13F0C03B72B52C47EF1E28212292E88A44B8902234F45AA000A572A40176E8C3CA1D551A7501284D43627A233F0078A08FC0AED0A93DCD6C5045E0BAD8DC46F69CBC3FB8E6AFF348E2E1F5057652B0A0BABCD4878C05807DE13BC0ADE4A4D2C8C0C0A5094EE2F5040C8008E83C20557DC7480172D22FC0D0653A9E3AC7A462C0C21B108CCA56197284DB3E3E893F047F0806E6800C9AE1962204C9AD558A700A0AC800F1B04DB00BC175697426C01774592FF076ECD6E7BA94A708EDCCEB2134F13EB54BC21117E19C45C8583692DA1ABA24445F55B001E080035E41A203F8B8469896297C90804D23ACBF5DE1E36610C88138BF9F3A4C2153C844505C9E674CD24840964044C9901C3553485420873CCF4C4C505495CA206D5C6058585C7400B7087F3AC30332013238C09E582856841C81161F387D06227D649DFC27C99B8E0CA26831A1C720970E60AEC8C09291E757FF418BCF1A72470E003E32C9881D6A7D6FE3E87407C8A25C24013C1BB00B04F043C0A607500ED817DC884B2FADFA1700E1884321448854C643127EB3125431F2EB24B101EB9E4E6C01BE5F0C74143FEB0419706005CB40B0B048AEFB405B4458E0FF36E8B9CD2369704860D448C5017919026080194D00E22B74493B51A41C0234007FF0894210B80B83410814E648F7FE746581A101B52C372DF07915885FA5AF67C0709503974530C2D13637F2EBA0B305C0AF020E435E18D801BA76EC560577E2B6FBF50C7462056E10E20D5F0C4D7445826E5E367ED05ED68DEDCE3BDA37FCF0FF252618209C2ADF637939A8169EFA3609CBBF1992CB0394C135249397230F72C1DAEBDBEB67E4C9CBD2EBC3EB9AFE3AF05D424DF67E10AF3649B8192EE5DBE1861596B4066CFF9AB349C23BD87F15AAD174006669A1F40C9BB301168AECF6E3541E6C4E32DB6456AE4820ACC38292C70111112A5FB48D04BE25FBF285C97E52DDB21251F0A1BC84D0317D6F5127445224249C890E1E2C7AF580F089172BCA1E788908C600E19B8BCFA953B0098848890FF0C19B01EF9DB5EB4D7521576E5C890A7D38B466060C096BB94C9F8CA5D21ED1694D8406187F4ED3542A4D07724F0365B2C78E856B8D8901914E00EBA0BF190BB19699E95206A0AC86524D2707D27F025757D3149A0AF8F75CE268A966B44DFFD94436EFDAE7B84E203AFC7EE806D8DCF8301F228B75D7BC0475DB7709170B268B7DDFA2E32BFE2FF82AFC452BD68975AF04B3EB2833DBD08BF3895DD96443671C0BB312B7C0C'
	$sHexData &= '8614D6BA718AA30D004C35DEE7F73735BD4757B08E47576FF7571ED756C478D2416CC7E24E0448D2CE2A57375179C8FE40DDFB7A5D38BFB76EB46615BC0F752691F45AF8BF01E4B4EB34421812D275D3AF94F2DEC832B04FCE0D080418D4F0160770DB9DA6AE0458D3C147DEF26D75C9B6F9AB62A14383245F808468D2C136DE7A0C171C1FFCA280C3E45E244BF1EAAF0B04404163ED3FCF756CBB77DD70132AF044DC8413BD36E52FF2C780A17BDBF1CC1AC55E70370BCD9BB2D143BE36CC38B3032FF51D448C34B41F3A73CC78D5601CF2430CD7632DA46015CE8B442CB49CADE353768E6C560572EFA5C5020C5EFB9F290EF453BCFD3398B280CC43FFC43E8847E6B442BE3A87E634181FDB1D3A5BDF47F5A10FC51C5BFBE4EC0252EF8F8EE41597B4DC0805E5603D8291AA9A0A3211AC410D5D133036808CC35B7A668E9C4D06922397E91AE01D450C429075B3698F148CA513EFA0460B6D054F3B96220304607E018E4CD5A6A7580BA90C074FCC521754FCEC2AF515AC7E0AEEC5CAE22F6D81CB5E31CB24DFABBB930D1E334EF7C0F30B7B263E6C05777049211E86F8E3CAD835F04889DA93652A12063CAF9413653CF2088DAB73AB70BC9143D0E9424D875B4D71B22221CC7F841FE33EC0C9DA37C53750640886E28EB7CC1E02322EB009AEC8E1A1B2CEC4E24374038E2745BE644C443A0CF8B4C50411E11D944BE021EA0AE4E1C561092894618E5CD20F30C5C880E6088462077C2E64D612140886CC64612DB941171A0E97F41C0605539C946030B5681FFEF065BB7B0B2E104E84CEB690B9E81D9DC8874A91E10C9A992161C8B49047A18E880D6DEB8A842D8073BC17C30442CC81C5A881C000F3BFA21A4C3A72436655A0D9F2C0C2A08750464EBA3C872C43BBDAF7231845F808194CAE82BD2C704240016EB30A36104A4C60C24E188EE230C3BD5250804C7C2C820AA8C57AE5470C5A91AD21333F6480316105A490624875E83053AC72AC73C1C823C8FA6DD8426FA4103C51E4980AADB1F276E7D0ADF438B04834EDA8500F8BFE804437409ECC1E9183BCD7C50468B0C0B75FC5B8BB5B6D02BD18BCAF7D99ECA394588563ACA7F8206621CECAD46080AD0C1EA08354456D3FC5C7B5C413A107336C2F7D8C2498FAB7EC27F2841FFC04AC77C8E881B80D3E071738BB83BF78422FC1204A85CB00140C0288474E1F4D91F0A14301844D787151B482C77C378E9E23C7920AB93AB931CA9B8A218527A4D0C437202AB935AD8A4D2620C2071F009CFC51D95BC24F86E4005A8068B57E8EB3A41BE73867E1E2E50E09AA4F8D7C7458B660156BCD26E5504884D000142719E49D66D7A9BBFFDFF400FBEC7C5F96EE8C4C1796ED610EFC0C4E25100E870D21524DEFE00C4E35518'
	$sHexData &= 'ED010A6D18D201DA6D71562ABE40085520D0E4AB8C30A7808792B8BE910A83BDD04D18F49CC4C711B85C9A432FC08152B1128266B47E7CBF1E90783320C5D9EFE48A0C8B0789FF0F947414C5FD72D118C5ED66E0C04B7FB37417250CF87241C5F5DB1DC277AE763340F66F048B40DBAE19EDD8CB44F7DBF6C5E5D8C21EEBC940D8D5C5DDDFDA67DBCE30925B327C525C0109C10954086894EF85E2718D480706BED80F8D3A730A35C57D4C6690FE22A64CE3B70F874103AAC74ECE7C510F1C958E45C81941CB3BCF7F788BE38E6FC941CB34548E01F6F8BDD26F37C83650E878FE7C488B93D152601E6A8B53180C06668FBB34453BFCE3AA3D4C42A1BE3EE93D93C2D3C7813A20E9D5C889E30253FD08018E27C0CE40FAF6E1F70D0B6EF9AF684510205A180852EFFC6361068CDA033B41183127D4A9AC429406F2309577459A081C7EBC247001B4FF7A78514A74FF7EF6EB3CBEFA72E123F67E328BB67CD6C26B94200B08F46FE288164019302CFFEDBF42A6ED62F27D487CE062D20A7AEE62F17E487F6501E93E0D7E0D6D02758E6141563AE8091C1EC384AF02D848070B803C884629D028B1E5043E2603C3B13224884F31B4DBF4FB0F75ADC5FF4963C1FC3DB86D5862D1B46F1487827422F3CE62F18D5F6CDF72D21862F30C1FC90493C96641766FBF1F5BADA95B0484446D48DBDC51DBD4D0354DE417180A65C223EBECFEB7211A7875483ECD06C4E1FB93D9B52E664615D5213429B8D1D8F10BF37FECB2904485D0E0BA0F6010F0773BD3E24C0BC2D1C0C658F46F16BA75E649F7D04C85C3978119E960DC0B6F6FF914083A6C56CA8DD434C3555A8F7B5BACEC4C9C0E60D565E06376B6053082841DBD863DF3AE944E125207F7019D02C11CFFFF481E551A9EC5C4A17E10392F1A056EAFFFA49644DCCA8BC6C1E0184057DB9FAFC024C07D18C0012E66E145D5EE7CCF69F84F5C0D1F830421605DADAEDEDA70D13F4E46D9757BBA7AAF41D0C6D0706900D082CA55DBA944CA74C1C0DD3D587030B40861B2ADEC121B3455101A26CB79AF258560B04EDF7EB474C0E04028F07F7252C56FEA44C2FA183BC67C5447F204CC16F876F604CA2BC88BC1D65A30A96A57897F74C04E088ECA55591DD83D7F677BAA10EB41D5AB757F4B38C1107C87A2300307E0BC2D8A97304402403D9DAE0851BD2AA42450533B580564AB28A9ACAC3AB5698A003DCCFA044C2D39002C660C0AAC5F542404C639010F9CC0C33FE940F59513EF00014B186443036AA0F01CE1B5D0B5F0DA8994CBC91D5147748D0FC0C0D54369849F924217959FC2015AED80B08FA34040196EEB4E29046908064C04DDB7E0916234093064D3FE721830847DB628181C5F40EEC81CBF0651083DCCE4DB25C1131DDD8'
	$sHexData &= 'E9242B344A4750EB465C052909308604FA17CF4E41E58E800BB53DC33F23E4FDA988FEB17263E0CD68EA9CF8BBF0483D1E2854521ECBC44983A2D780B59B4644181661CF4638ECCEC16EE1DFF1529A841BD0A820370357E0F47E82E8A03B85BF82B461CFFC000F7F54415455B1C283295B4584EFD20867331A57213E0C3B80B7F0500EF33DB458D6501043F3472B4DD66900C3206E8EDDBCFB0DC750B8B46A9EB070EF130D6096890EA44A670056C9F484CBB2A23BB2381581948016050A6B0544E687012011839988B788567EBC121A1FC220C0EDBCB06472AC0433B94741C2200495E91DE9DC77F02C64208208445A3968E14F68B0B4426C6AF6C669760D10EE4D23425B48153945279B0BE0FD1DC6A108DB80C9F1B79FC920AF4DD44B15CB54BC9DE23B1BCD9F649B5E8E0FE49BEB76DDBB6056A33DA892598B465B3582A0B6C10F0EEFC17B658807B3A0D80F7A0AC2CF5BA2489842B0A898BC7417D53CB4B9470167E641F172EFEBC6AF6519CA845514DD449C1F903C606C968F6F056089706D4C725633C41A084FC007643F083C3A4B290022B2A10537581B0D689403C72D6D9D8697D985FA70E4C8DEAACA54C45D1C694184E8EBDA5FCB569ACB08663680C3BA2E7FE37691E368CE1B441490A744B03B964422A0032230DCF200D2FEB0AFD15847542C89186BDF90910764838F6BB24CD9B4F614BD94883EBFB884A1170CBD508D760E1FB57418787172A6A412885684D637AB9E9196CFDA6FD01A5EB4CAD3B463888F254DA23BF2EDD1818154B4FE1155C5FAC9AF4FA055AD8028896C3D4270BE73ACA238B08BF7486BEAF5F4C0888169F0E0B391397ABACEB44A259D87988143B8C89BE3FB1DE79FA7CA93CEB050CA78CD556F713B1B602382703CB7940F0549E1850CF448EC0F3DE8084960E1C4C2181A94CC64BF3D12B908EC26841A81EFA1E3B3B56107465BE109A673A0C08440C480800EEAE794C0C867480D3BD870CF2E434181160FCA93CDD2023682870304C896C7F3311F7C71A736C6483460838E817B954B0373DB1DC90561B3066D72E74264CB803362F092B3BD82F9CFFC718C03B0C0D3BF8253C90DFD436E8F000000111A73881B904052C1C29318646FF6C7F0A825322A98D3C4767E8A87021D96E4030F0B52B492B2A046A646A10815FF88B298B313B710434B853C738EC81E069EF285FCC3389930106BCC61F9B88703951A7B848EC8041E9FF007006D6D36B62A4B24251107C5FBA8D05C83002884480CE735C9D08682C7A09853F7DE6CC1E87D0D56138304110DB12C0ED24104944EF8854777680E3EC45B07C7BB830DEDE099BCD5310432003C7DE16289A30E179C63C8E2C9E67C23682324430FA19F9717379486E775049462E4FE5495C383C40E490'
	$sHexData &= '414644485094410619586068F9D120ACB2E866645049C73220273849503458240707BFCF822B48BD8A5FE964F9B6ECFFC63B732E8C14CCE9B4702DDDE731488B8A6B9C28BEFD3E182970CC716410C3C0920F10FF1831E42229F6090CE81421126C93B0031C50BF08F596B31DB242E4C00B44084098A0F3DDE748889078D80E9868569E273BF21797500AF24DA8D001703080EB0765C04D12899DE85A3821980ECA78547C434E37E13F8B2008CAE7CAE799E4012008FBE801300814F89ECFB808AFA88588B9AA4E7399FD268F384320A5F2200F88182008DAEB01AE8AD89E2533C91C17E9BECC7F38F5A701F98EB54AC1B4F3899DA00AA8F2A0E2699DA02C9C7E80EF481DB2170185D2490F49B763060E9CA0258B6485E405063F5E2830A040F805B012815B17D01CDC2E3D7A6654F33D9B6F2B120C24804DDC0F2FC146CCE07EED66B0140D99611CC1F3443E1808115DE4ED7B9BD288D8407E58900766E44468D85DB2799A48CFD80564002995EDDB091546DBA0F8803F2F77F0B61FB40AD7233C66465C260879F877AF357870C87B4116CA8986664DE906CE3D13F2C7A628FCF0CCF8C8889D98060985A00739B00779886C603BB8075C074FC2A75BE0050BDC8B069D39095EC4BF553389778EF62996740885459530AA3FDC87C08B4E76A29C44103C10458B5DE8C2AB146C55802674BC706B55DF4A548ABC3BD6142C884A57905042184660471FA4A984F9DE1C1CD9895D9016B23FE0443BD720BCE73BD30F10DC4FECCC2BC2548BC30ED44E581107438693B6C08F8AC292D20628073FA68CDACBA700F21C7006F07C35A6192C788B6C8B228995B91088BC05F083DC7F1586DA87C63F8B8D07060F1A95032395B9520316BC5B83DA209E751D4439747517AFA9FDFC0A1875111C750BF4D1668074BBC33765F0C38D47FF3F69250EED5FD459011F5C4A10137B6FDBDE8D4343384E144BC545427FA34C38D2E0BA7E063BC77F028BE9530483F80758C2BBC0DE6AC235448F0F484590E14617B9A46E689B2B05069C61626D63DA48A1D5B0659C5ABAFCAB0CBF775420B85A570C903B3301DE8D0C721E33462301BDF1837E608BEDB022E3B4D162D9224D2C49F7327B777292A53842351D097BC87708C45358DED835430EB91C883DB3E59043BED7332381D3FC1E72C8094F562035EEA4C09A40ABD81C64264E7BE383BD54540C9638E8F02630C99CF3F6F79A9C0DEA93D5D714C97C871CE4A4A49AD74C358990CB24875F506EF76A10E42C1C044E54F8899D929B1000517CE8D6570BB9409E58E89C07B9409E5CB8608B161136C8073BD0A34233430EE952E713E810D6F4E3903050DAEDC70680046A079C9A8898187E0CA08A449C19DBC1F5AC2804361178718965C742B198146E7E2'
	$sHexData &= '00AC8A972DD3F9595194F827C5E4A695790776E56287CF2FAF238A0013EBCBF06C64B51C85F80488B18BAFB2464D3F98B3D96A21457D6F2C2DD69D5873D3D2DE59DA44B1D564E2880362DB69E29D1313C484E105D5DD526D50939D184D755EFD4F192496E2DB85089D414D111D695874705720AE444D4F8D372A20339BCD3D73FA2D323E2634444388CC015C88E852CC43FFA131CA7623547D41F7761077290A01DD4AE1D00FA554B406A791D2397A4E39665B03800492ED67FE32A6D48553E40DE56E04172A27522D3EBD239C86610D3BA9FB0D232C9B10B9F35755057703CE48442D28DFD57043890D10FD3B24EC82990D176D1E69E2045C74158D193002BE411419AEC2A4C16DE0741833C243E46144D354DD30A10180A1C69DB11EF09C63880BDD8198BC0797BD0593C7926448B8D8830E2881D4CFF8992DE5D58235E6AAD87E00B976F5E958C428E7440C02E540A7097F65DB8D79770514E8E453BC77E05086E6F96F0C17E034564561C3BD71C413BD23FA21961522CF8A8C6343B03FF0AB2FA0FAD4C90452BC74499B87F6A261E2BD78995440EBF09DCE6A4068548180C4C634D489C83C23A101DD04DC5BB8F830136EC16352E2A8507B6C67D81AF9E6C4F4C83453AAAB9BD377E58429F2192D1B5B48D554D88F0C3BD864E043B764903C781CDA12347858B8A14880BDF651D6FC127A4260C886CB07B2353FFC33B9DB17CB446338609FA86F5016CACF6C614E134B1BD134CD681F3F11C6C3DD1C352F22A87EB3F262ACAC284F095F0DEFB16F1EB0B33DBAE0418305458E33D0047B87CAD1FF2DDCE35D0689F0054027539E2CBD0E1D96AC24D83012CBC9EF528301746C7A0B1D2B634E110E321F2B800C0F33A37BC671DD8A5EFF39043DCBDC01A767D7F99D3DA03BA45E722DB556DE04774FFEE44DF9EF700C0E4E007122BCF65FB6BD7DC9529739C5EBD46C784741339845A8F4C5824CC49EC4335B6C5CE7B0110FF723A9D19780153DAD0603668C9A81578445497C9876892395C0F90CEC29A6768CE609099304FCF95877C3FF8512B956DC1FA0571918F877CC380CD4B48355E54F2E4C489CD8B439A19CD11C89313289AE6CC18F008E4A2CC56CCB74F1EC8231ACC8A99FCCB062002206AD3E17A9743014EB0212D4F8BF4800CD0DCCC5ECF52A00C327221A0B03E325E9DD03B0E0DCA7AC0014518B53E4DDD75C72B07252C13A0FB9CD11AC2074ECAB66FC30A5A0C536CF862766563AD18817F49121AC93577AA19ABFC0206D569C5F0CC354029F8293C20AAEB3ED8850CDA03A4568526ECAB5E69423E288807884F98FA7F90600F664C4183FC020F9DE75690582486290E71E4019470500008AC906EAD4227BCCB3E5CCAB6F7C542E2151DDB2454CAF61DDADA14856A'
	$sHexData &= '95F72FD9761540C0C230C2287611F09FC204B34ADB885C2465E224CECB2A5885A895A07601057803C4BF7340CFC2BBEFD5DD3FC8824D5BF040E103CAB895F867C046E32B9C8E20078FD5473BE09634F827C618071FCB3B3CD84EE6606136ED2B1578C14C3BE8731ABCD5E2056F58EC68D1E1640CCE02EB1439A0B21102B8C8B88F6E860BE22A04D860CF68B8CD2162EB2F8C5CF6C62E3CE69E5F8A96FB8530027412FD428E9641E842D8021D5EE4D824CCF184808745D819D035F3EFAA156DD02078E7747374640A6DE060017C125426C56090E30B2F8DE4393A12BCEA74EC95235D1C6F2CF886F09FF14FE1538427F379716C80784578A775F20CFB630CF82071C869DBE0CEEA0013793806BFEF4E3BBD50538B9D2F3B5D800F8C1DBD3CFACF262B7D88C0E48D040B3B4598A6BDD6861A224442142442263FD9277C9090C3442B85CC0F881F15BE219BCF8DDC58013BA9485B10995FAC1E8C06059C758BEFF057181576049B05181BBE0807CE91487F8D0D6C3802C93B441A9C88045D7D5B955FDD74596CF3D885012F7C405EF8889307FFB09DF0477AAB0098F472854452F2F75970CD62FC1E384C0685040AE10691551AF8053A65F787AB5303748C396AD024EB59A8FB692190701640FFC089B913B000DBA36E037CFEA3156FFB6F3CEB0CD7C98F350DDFD4AAE983255F2A2332489650884BC3240DA83830D3120F91474BDC29E0DFDC78201D5E70AFACDC4E6D25F819485309D01788CCDAB72F28E06DB81CA24F6FCB23AC097C2F74722000662E088B1B08E1E1051939AF69EC592112B2F2D6EC05F405212848206061EC06DC2E30A003B51D6AB607C15DCDE3093342607823A3D4AB9530207239083848488401687F902FC6723610C6A70D21D0693AC72065FBD85B5F0DCB2A0CF36A58F1B1C0346273CAAA40EB7D2EC2C339D2CE4939020F86F0D6B5C12713E11FF88770721A004999D18F90EF28922C021003EB4016D8794E9E910538E430DC27C5E43928E070B17A5DB78AEDA0C7F03C8E2CC21EC94D787627BCF0054E0CEE542D325C0A77145FE2C30449A1D0ECC5BD53570E1607028474FFD22F489C11D881BB8767851070008F2761414F7CBCC991D2CF3BF418444297F54D9C1FD91E1C45F84C0FAFCB38E0DD633C8108C52AC1DA9E82050BBEEE75962315319AEF44D4EDD46444744A0F9B85281239CBBDAF8A84C5602A5E34D7B179F34B23488B4FF94883EFFF1F0923E1B7E0D57A3CA40D1A1925175DEC19E1210856D73CBF3040B771DE33A685B385748BDBE72F14018F9E83B68E35782CC86F1BF05B041B3BBDFD16443B8D8CD0034669191CD37B5285E927AC7C50D4293301BE55487D271011405280510E74199001392807101027021C19187422075508C74E8'
	$sHexData &= '10001E77C282D15AD4A03909D73C0A214FBD2DCEB194FA969D57905DC42F4488142C182102A8709145E24E41BD381395A2834110303AED84663C419E0ADC3C9CB679228CF9007880739221CAE87D5889984B437625268ED7440101957DD4ABA1CD09139CF892F68C5740CDBFFF6C0C2582FBCD01D0438F1C1EA49FFC5119113554B287EB65456055B46E1CB7CBF0D2F60AE255332F13B598141C13C2FFC300650EED0106CA52B4C2BA5741A5F6956FCE74863464C7E07D4483948A4F4E0E1E53B273DD95A722009557C9795CB025CEAC7094CCC09939F7C2E09008CD65900303EA45E664320F68BED2009E13DE5412BCF012533739925025D7F384679815BBEF8DFCB26C8A009B086266D12A840C965910A34138825C109891F26E16BDFE62944574ABFA9D406541904837E50F48B4419E41971C5089948D1F845DC180C9ED4A9FF3C02EB06458BFA2A416DC9DF3A0F11AD4F77BDC8B129812192355CC8B7292DE295D81A08456F562E5372390C4CFFC7097C209AC2FC7AD6D343BE0BD9C005BDD49B391C0823D23FC05D690A4F0907AE3E3B9BB3F4E941FD1895082A50AAE14C663FF240EA20581CA924A0E480BC46B978095809F75CF2F2A009A00947616EEC4835977018DBB950097464409E8809C30E4CF08133D2761810BE1A19D9F5987F7A9C0A950800E24029D002BF902010721813AF49EC7C25B39EE21736535F8C6D951E3E4617BF5B1FA940B40EA7C9FB21FDBC8B5AD94009C189019017DF34171418EB136AB3BE17313195D50754865C3A849CD0D8B2EB07EE35395E60F0E8637A8D301AFF1FD2F8B8DB34B6D782DE1B430296FF0BB08BDA48C1FB12488BC3B9780C28C220ED099C84B87D4CFB5A55A01B2BE0CBB5876C4E5C2C580145085290C9D34CF2247804789898CD254F737088B88880C504963CD8280D7DD411C2A5B2D9F5673DF29D7709DC0D8BF784A2F03A8639F23AF119F84EC97CF8517C87433EEF9826C818058509635CF23C2CCB38E8EAC1240DCC95E49D05A0C49E5949DE702678442874598901799878924A0A263D7F92874C2B8549803A8C85D049BDA37F6A110EEB835ECC21D068E3F7E0483DFB68E365043F85BBC031919A64D12159EAA04987232D8F051C72A429C828885804E0A062131637787946E8DBFB29799808FF48F7E32BD96683C3FAA9B4E1714189193BBAD222F6442CDF7F012C07417BE86F4A5C1AA806718E2D5E0C8EC4E444AD9800CAB01985F30CB0B63302987D04E58D3758C365E331EB8918AB1576BB9B7AA78F5FADD89B4C72C86CE8A9F0D8E8723932800A58BCD821232313B8C8D0BC5232C9B8C8BEBEAE424B582E180CC7482D9CE11FDE736464E42275060606E44A2639060609E46C327285BB0679200A5580913C300A'
	$sHexData &= 'DECC28FC5BAB2BB5913C90F2DA7B18C91CB7012D9B7801CBE74A1E8801CF7801E47264903008CEBA30694A26B998A84C914146DE089C98500D1EF292915F5038024802AF67754A8B4C814B8B108A0C3B0CA50F79C86BDB3E33ABB801C80192CBE70068B801D8266464E40C76D8D879079049E84DA0A8D831BC0719B84181CE3E80A5699890D903B5B8180DEC12919228FEEE1EEF3D00261A7559C438DD717493043D1D039E104026B9B63BC198A864E4F2991C30069818909143061B39189840269958681ABAE4C87B4298BA58F803194D6F1929800BC33BCD1C3232723848503887A6F69237EB1879859A90C291D71DC9C8E5B4B5F00500083181DCB22FB500170EE48347A9F6B669F0051092434646202810499A09642016CE5E4EDBA0D6F9B568077807BCED4D5E80072FB537C848331569150A2132C955B8658F7888231FCF0414904A78D8D63EE49203133FB2013B09E490C3BBF80108814D9EA7128E88F8BB26E4F29011E1B1B8383C07C84948011070210332F238980F544DC8C8839818FD197907C82878B0187861E490010E2A780364928B2900010372F9BC0DBA08F800580C1EC8C821205845783E07C8ABED88000BE00773492F5352A9030A0F64E44809DDB303E0079E03E421F00709B8C6C02247E007C10824DF21B8AF81B3B0CB1890CF65D3305CB5B878BDC8E20C37260790C2B249E86DCF3E28C00771017AA155EAFF657ACE16E07BD8D0B90082BCC6E682D00616ECC6A5950CB3672CB976D8199E33388B801C73446158AF4B0EC83133781801B00119909838B89BAB800C6C33D8650258973619FD072406ADF9675D5832B0B4B59B583220B31D1D33983899821102766B0236D8402ED84D3385B5C106F8B5191C72EDE6ADFD012D307803F2D88010F1200A06810536200033198D51219C98D14BBB766DB67B0547B8752D0119906F197858062D19903818970636905BE3D819981806644078589FC6E44030E12807667C6924DEFC132422BDC8CAC007D8071FE919C693C204A95253D81575A8B83C5E8074E9E4461EF810005D522964FE083920074AB9780858083C97BC3CA008A008475020BF34D97008FF0861840CC808C13A79E924EEF733C0DC5A72400008DB0AD67AAD7E8B9DEFDEAAA67EF1EA76BD1CE408B980A04AF8400FDE08BD42B006710907559D857D83910A2060587D685E261193601F770EB6A91275EF5D10680B099243E092062051E302A07939397298069106707806684C261970705408E4C43DBBBAF32D9FA1BD08E277193522F0958555EE055AF80CE4DFBA45A80B0602970B1028C226335007FD8523F116D40D397D5A0F904708AB387714E49BBCF1DEAA1DAF64905F83542455FD7683433E9711AC35E272C865925818C725210FB94C1'
	$sHexData &= 'CACF2A91CF290CB20915FAB6431120FB9768CA9BDC42D3C365B3551A9059313F2E4407616A9257685C50AC9E3A8C18090BCBA0B9CA87121476CD45D4D5CF2EA165293170EA8051986077E75912CB1E8BCB3160D102411BD31395B81E15FC0A72C5815D83D31D3A569C12D8989BEED30362D5F4D00551C1EC88704E7500AC00B3E9FED42450843D04BC053B0B145617D5BA01301D45500239FE008C2C9C7BDC1612F6938A4BFA155BFC745B7EF02C07BDB6FD2893A047A08061035039F00BC9071083E46181AF84E5E9F01F02B1C6CC9E7F29B07F6F0141A6F24BDB42C3B70601844AD018CED3B481C130070BB061EC0DF89D04507456B30FE3561EFE88B55F7588E15CCAC8AFC45FB85C0E24DE7607810B0B47C0D0C07AE4ABA8533813EC0E7C5167C0DC9B6014D1F418DD4D2C4084F655E06760A57281116EC088239A04A7F205205B5908B48EA07016B45A140530F7C605A03ADE702DE5A4D6DA035D945066EDFD6C0A7758EA0C7BF30C27B44092FFC270AC13350BEB20F99FCB7A01C5C00F87423807D457839C04967CBA3DFDF5EDC266E69C3992001B0838054E02C01384F3B203032D7103020CA53792A3828403053D1089C48FAC1A041E1C044E849107F807A054F6244C4E93A100811134724650D6448D3111734D6E200655F958801C8F81F95889553B0FB50050F8B8C08B20A5F68735F0226C28179DC1C56F90BBA0B1C59B8F7F6DBD07809881731CF292905B02D17C07B5A8B13E82B4F5764F003BEF04BD003267966274C2758B0F8BC4FF2545490E08B53509A70435ED38222E84CBE5006E4691EC3264830406906E4692010381CC8D35CF2F0023018D00CC8D30C2814B0206662C8D31090503C9670681C3A62C449BAF209D804B59FC2F01079053A049798E2E511250DA6A6982F4E26B4705E0C9B50609C815B465020062906D12C2248195A006C970D3C9317A3DD90962F04147974EB5D13DC8D4B6A70A5B52F930508A301337D90865CBBF09233DB82AD48226887AA2E79CF180D4FAE500764422E47A0A250D079AE669565AB28D046462E193008323002996442B0C09C92916730B010C4A1649209B91090A024479E093890F001A1B6C8C80B3E33B39909E47670A58040CB914B9E449ED00DCEA0AB1D9990D0504D6099462E799E4850B00C61E4644246B03040941CBC2F4D8BCD9430CE90399990EFFE9F9590102029799E23CC1070399990919B70F0004A9E8323CFC0F0509C4CC86C309550D0E0973CCF91CED0300632219723D59E30B0792E1772C04CB0104246462E018610C02FE46490A066490F7E4E43EED8529011F8B49389FB73D908664824D22247902FBD4A2ACF8B6290801CBB6410B02D30E492E1D2D0ED50F015EA00197090497215EA638DA5D02F'
	$sHexData &= '192A5D7095F0900060DBAA2403A9336440066430D05007644006F070100400F1802483B0817CABFBFB90E16B071B6CC7AD0319900119903050701990011990B0D05B449001F02F120FE45A04A0053974D318C8059FA2C301634563F9C6F9BC0180F9B74863F24D5E6B60D2696F20D81A50BCD1A1B6A0B9FFFF02C86953B0423D0F4ED8464C0C9D00BD57D8D24869C739344E102E0808FBDFD54E5801E0BC3AC6D021DA27E5F2689499AF49F8830849F7F9AA8D604CA7DD21712495570F44DCF7DEBB02DE4981F8692828D8C254AD43800AC8580684C161A77D098E84B8C7499296F6B920F95244CA72F90AB789B7D05E073B4823540B5F8D7313DAABC1DC55864A845DC9E00634357889B8B72932F83A08F86592F24871D9123122F00CD80E882554E3D3DED66768D7932B608BDF4AD59231854E179F416C61225D8D0C6E128DDA78F176507D9ADA7217C40C3918451301E334980022E2BE013794D0F43E1E94C609A84A027294905AD0386B2CD8D155C0CD8B142B810D30085192CAAF4F0C687C7CC0A21BBB499C6875B1B7B9B728FC877B9F7B93690C72057243071E90235F8105751FF99DC96D50F074623561D832F215723109752FB7CFB6C24F751041C706A60C0710EB6C902B824FAF068E81C8AB8C5C20400E1E0228D424CE0499543A82140CE0EC605D0030B486FEF09CD462658D458BE090C93012A3A0644DFDF0108EFD93BBCDFF670A5F3A3BF38BFB45CB4FFE2BE9442BF204B563028EC532CE76C249DC4ACE03C83466E6C993D1DFDE0E2EC177060A51C1EB0D0F28C137405A649C28DA240DD834FEDF54CA342FC877518D043699F7FF3BC34123FAD5D04CF33BFB7C4C3F7756F43AEDC63842462818C6160A97CCD68BD1422ECED0339B9967E40E2663AD3908D15518DF7ECB7C98C56D99AD04CC30FD66FD887335687E57EB8BFAB0609235176481DECA7005A2090690DC56B33498DF4E80B7A09E7160B77980F80AAC8D77FF3120121BA6F2741F15A197F15818A9158C53B08BCD028303DA21B19B148062013F5C40623638DF7F3BDE7D0BB932495B8B7CB5A790D329E4B6CBE6EC8012C15C655F7DD237B6067E7D55498D6BB1B53F79E936F0A551F74D8963D0D0F9B14324A00C73E01263F141A180F6329F1A7B68F2261DA04165CC65EDF734F33A277448E630080F34B3968A0EF7267721501578B74004294532FF6F230D5C0639BE6548C047AA00891DE0DBA8B55F60B33882384597216D874D2CC3F0DE52E00EA70BD66DB7489920BF143898294C4C7294033C8780EC404945943EC70EDAE50A4FF8384AD0C68F21CE050EA48F5440A4970A6C4087DF52485560D019C0A78B74565BAD6D29514A974C5AC152FA33170C3E2FCB566AB82800535B24B3A0B3AAA86'
	$sHexData &= '4FA740E3843C0AF45D653B01E41B7019794C99A23B2DEF81A35D9AA87E932E968A34546D49FEAC303460ABE72FCBC4239186A381F7E90FD1858545134C52189677098AB290EB32FC3F3BCC1FA06D3DBE72636CFEBD2A7E0BB16C7CF75E3771C2978EF2C11756FAD291BBD979960A9A0CF99324E22AF6364E9631BBBFD5FF2E8A62690102EEB381D6C7F6E9703D3631E61CC2BFB8D5725649AECFFEB040CA849328679534DFDBC150ECD4BEB53CB64E80038C75DF0D76D7F52010228398C7E44C88E536175A39D7D9F749163EA504C0E8363687380E5E3F16D9770AA3820998E279A75C7C7298EC72873559771D86086C66F5079F5D8E1F1740B73883AAEC207E840CF487D938E2515B67ED118D9631DC9756D620C4D3CEDF12E282074B02AC5008E7AF77FADD812C0592A8BA59388477F650856583864DC4D08896E184726753C83781BA9001D14047B00563E8D20E56160174D41AF70DAF86FF808C69B4E192A8EF98CA72BAF8AC4F550083008E460953A9F22609B7699644A50F1042A7A081E77C269EA57E30104279C12C1310E3D85476B4B5A1742CE5A4120D551D0D84BC172C3D848336826B14135318CFB90440933915E56C108A37145466C5E1463F51DDB2845DCEEB5E14B0D047C3DD3C0AE432DE1DCEB13A52AF653064820A0280CECB07A755FCE5F10D1E86CE1640903EB83C6198F9C0BDE2D610FE143288E0830EB1122404734393F0CA914F1A53C55E93823177250906000FCA103038B4228394128AD460A0B851FC9CACA67C290F87008A84BAD3484E36007659EC908D72EE252217B1A71C6DD341E449501CBDF4443D8CADC302B178547D18BDFE75305A42B7B8C8EBD02CD4E60F048AD5A01613959A9E4C37869A621CE40747CA3D16EE1A86F5D1F6275B990814960601C4069CFE57FEE411AA614614CE23C29F3451DF5B0B2DF2ED620CCCFE461DB5EDFE13D8104C1C80ED9015960689360FD5E7939C8CB0651F85E06518F5E4A06A47278BEB113DC809C6B5EF51B7B32C851F0059C690F264170C31B51BB505936D3CEE5070A4B21CEE25DC1791B4BB5826972AA205B2171B25D4F1E24033C56FB6D5D51583521C03B770F84522167681DB4BB8AC238A1A77CE079F0A916B0AC4C49BC8849ACA0959C5B4F325E774B111B4DD354F004C4EF497896FD42016D6C33F6734C8D4374DED92C5649BF4B79C337108E3C764D03FF3108BD170D6F0B204A8B1CFB39CB1E724036955C1F5D08B3C9A6F24839FACB505C0823826F50FFC65F1C9886021082800752DBBC5E93B8D2E61890D7D6FBEE1061302475EE7784DB6B8721818D1426C1E20402BA903B71361E3B582485E33CEB261193AD4378C1FE3CFBEB8AA16431A0B8470298A660077152780DC47D4E0ACE589F6D'
	$sHexData &= '466B2BF22047A9D8E62DE849FEF15BB2613388572609F21361622838CD860B780460453D0F4A1057DC450F4DF8CC4961971EEEF0B86424464F161A5B08758830B4EE09AD5C020ECA04C3DA95C0AF6E85F675093A0540B5260701F89C86C416278B20F0B15D1BE87E16F9ABA012AFBB08031C03FC34141906872C2044B044FB296000A2EE2845225DC0010FF2C42AFE482930302877E48BC659BDD49048800213265B5F1B230F8D37134602F8B642C081C6A1348BD9DA8DC11589F70A45CA1F5C04414A228BF244CF325A003D1032CA08AB21D03DAD010B2D004455B80ECC0646838AA66A92258A0A401D0D0728038CB9FFDDB702808B55CC83FE215DBC03DEEB1B8BDAEB175145D9B9DD2C4E3C0F45FB2A4437F150C0455E629EB4E7F0DEEACAB00C0EB41DBAA184F0ECF93C8B1ED6D0A040F3C4992545B4B320DC23FEDE98AE56E00EE8C745E4E2DC433CB814627859E91C8B3820F0D31C81EB1044DA740767780BAB2793724903A0AEF8C0E16313060B9FB229A6B0990458CC44D62A454A50B0F904F01A5D924784EACF0C631A46CF46A310F68CE78DD5CA2E7CEA1050FEAC046CD51CC203DE49BEEB1481AF3CC62165956D5881FF35F02340418D0C063BC87C6CF637EFB3507F66223414073BD07C5A3B5CDB84C1E83C7F54AC9F2A2E26FADD44390341E3B24D8A36EBC81D04DB9C1A49D8CED82A83816A4F0892F00F69058C410644889FE3EA61475CFB5D17A487C5017B5184D464629CDFC8918F3959F9FCC894434A218234EF81C36DD6DDBB0DFE7F32DE94012369616BC0FC22C84219A87904C9DE3683C80189127E460190F830F126B8088F200C655C634EC4F3C4DBCE4DD7A8A7D310BFB4B633A04C1D455F189B0A67D3344DD39F6FC777CBBE2A030664DAAF8E8587A5FBEE3F9FCF8B859F109245D32B978BD57DCDDFA711E331DBB8878912FA68D0758F0893F497BC8107F0EEDCB91E38E106AE2C10CB3F36FE0ECE20E83F2D00F10C24D548D45F0AEF765863C7C8EB0FDFC7646531DCC0005B42D765AE1CC3794815C17E614B001B0EB99845E848449243F27BD09745B5A6E180917D8CA7B1A0CE68A507608F0389D30D78E9802D69A7C02170EA861C18697746DE389030941E94202323DF3F28A03857AFA5EF9C002DA4774015C248C450D01BE91050018688A44411C90CA68CC7705CC3A38849CFC03955B4E8655FE4403CCD952948154E7D459014BD6088E54444610C5214E485877B861ABD743CFDE7D487582E8F143A99D2819397458B865C9B674DE970641A1257B302D4E8147D7DB74860BF71C7A856814C6930FF152DB014ED1AD97002B0A104F8388BE987A542B9160CC68ECDB0247081A5E9BC4F0069201F9C93C06A13571EDA20A7835B3F78A0F1E24480D'
	$sHexData &= 'A8437A13A58B02567D7135F1A749F8256F15450095822180B61C771B9CA46172B6092164102717FC85368600FB6F84439443046121F70137F5983BF7020667B1361AD93380584CBBE55F4B6101C9F05BE60080610C4D6B494BF0107E32028F1AE9F256198D8EE16ACB0FC671072D750444F36B274DA4808FF4710345BFB02744485683C61704610923F7A4178F7042892171B48EB1633173D1583BCB6344C249A20182C28833C833C34303C382160AE0679702D8DF8511BF86B450B244181FFA5FB551B6D41C1E00857289066904BD0F62CFE9DCAB05F54440BC05B30D8963AC0A65934578B94DF0F52A9746538E0D23C81FA3DD221215D70EA53019D87BB24A5CF6C0A7B8C4AA212073C1F0E704C1661F7D84041C3112C51B58947783C00F778292318494E8800113020374F4060547E01402DF0A022B74003A986069213933C0ADEBEBC95BF623A7902134C1646018BCCF0E41D79CA33AC461654902E4DAC14CFEFE2445308782D4D0117C70D327248CCB8D0B8FB3494428D930821A4D2C640ED5F17898B67681B011DBCB671E9443B1850998D8B54049CB4444D4E0BF046A5EC0D7C4708498D06BC08218417385BB15879AF906237604D03F04047284196D0AD85BDCA2D2EFE4A0A260E80DD20498B0749615219762B0C0A9B4E400C4C7F3BC00C39EB4128E75F4B8701019E63A80FFE1784931C540F8D48FFF7C15D7BB016A88B64980211169B028CADAF18C4064E208F9A3989EBB60A1246101C415392385D60DB9FC342DD03C87438C375E8391B8A6DB466F2FE400AC30D9724DA7EDADEE54BDE42188E76E70E9046FE962429DB48D1FB4C8BC378F25CC2589C7898F712C65B3B87A887B0C9154D8D98B5B023C20F5EE8F8118C16A0864741B91143CFD6CFA9F183F349BB35D8F3207C676D08C77568928484222D1B23D68C5844B45DA672400AC1240C484EE070C8F5477E0D81C468382289C10A3EA4F7DF75A38C80DA2A23D7876240C1DB050EF76C1274465988661882D085847C2E1780AEA05CB71A0E1470CA3A92E82A0B3B1011B927412DD28DE341B2B0904082144C9A881D49E9D8AEDC4CEA48A16E2188C736984BD4723B04F15953310CB9E83942D0A73EE4743281234231961F9811843146E52F23A349E50C0B47ADB6831C482C1EF045246F0CD58A460414A9A501C24858AA4004E2B3AA5039C2498F803C64E58B4B7C397039792FBFDC6943702975852C940501F98873A73030039158838440E3A1962B13F9280679018EC817906F462020D578476A1151FA6C1C0E3D3CBF34E8057B998140449FE26F123078C5A12C8B35B34204614D9E077CA3072B783D1A7CB94F852B3D06750262C9BCFD2D77740C4C8B3548F802080FCDFF02F83E4B115F0A386F8B18B5D4'
	$sHexData &= 'E6730254E27E760F15DD8B159B0A8A0CCC22ACA4D0BA5864F3E89C06531CD1A87A817829E23C2E481944BF4D980E428A5E49031DD548BCD91830F889D10D4EC10AB85558B0BA5B57225A859ACA36D29D0FE97310881CBA000D6AD043E2038CB5785D90AFCBD23F73360247DF48423B011AB983FA2122E0F3C51AF282DB810185463B0FB987F174406EF96A9559C4B9352F2812568699F400A8D0EE3FCB85343B691502301FC68F2360A0BA406DFAABC1A5E14831C47C33E1A1AB1EE4806B28A1014BE042C121C8F330F87B4FC8EB0517890DFF6604986BF04AFB33C933D2AC368905577296469A2BEF361838BBD233C9193AB7BD7F71E7EB3933DB4D4A2BE20D256356363585124CD2451D1354DEFBEE23391D340C74071E2B10EB220A2D5DE9894FA855CAB8C2BD490C6415608711404731CE601C5F481098E42E30F03402E95B5928E1CBA4204805B0F2373835A1A71D0C99833B00F76E9BD9752D4D30F947250F56BC18CAED3981FFC260033FE123DC01C48B339F8D3CF57BC00F11F77118735CC41C0756F0263D527568D6DB807924E81462439AA69D8F44700D405C407788455E20133B8B906D5ADA20F81402744B3B02FCAC01F09B13009D52CBF836351DE771534233A5D36E4C4F948ECC1052552524AA9F064C909FE514AE5A6187480A17044E0FF0F13334E7B1A06F01197B165610788801ED58382106B4411D7B6DE83DC094640F87189736760ACA9F7C8BCD7B1C30D7FA08811DA21CD2461A5B569E63CB047717CF828649077EE75D6A55EA06C604CC4BB44EF2611C246C0A46186C130ADB9BA43BF07728579A558830EB21EC02B42114DA114941783E72362D0011A4ADCEC0FCEAB904F4B51A0ECE15B8243C1445203B2B7701A03175BBB81282C190486BA6FD12DF8711DCCCB9163F0EECCC2CEBB0623296CBBF646565239240FEC0025E3207921EC46C11589D0B1F9B39C7C6D7F106BC25AF58FD1635126D5021DA405C8B243CDD6652BDAC76CE04B6FBAE2B720D32C9A81274068995290FB75C95B4E9DA2166B8A917B62388E7A477D0BB8885AB0A84B91F12B9584F201381BF204985011BDADA25284603044310413CCB58945944044EAA4E4139A58ED419DD7409437D301BC4AB70F4125873A69049891E5F22DA4BC80C7ED121996E11951B1A3C2E11D18B9DBCA18C2FFC4150C27883CB8A301AD5078464E555FD0003C002272F1C691F10D53004789184AE24803B0A4CCA4139E068A843464C4E60D23575B22477181F6820E11444F3CA3437B0C3E233ED2BC85A60AC94D3DBD244A309BC6E606E11E4CDE5064E2848896882D00DEAEA315FAD7C193A7A404212E940456805781F7ACD827220EF304CB960F0A691DB44705047E0C10203B4064DC27A7C310ABB4'
	$sHexData &= '53800082AF87E62002388053C5443BABD0AFEFE9B3A4C314865982136359B6A109A5D2F7DCEC86F42842FEC2120C64AEB393362506C07362A21821C4A6941A4EF0CCC6B396307013D8503E968840AB6690FACEDAC21AC541642048A23795BF8301881E1C0A70EADC16A0316742A4D22976983C7A2C85431A03CC42677BBDBC030C6744F18CFEBD98567A310D04AE0C4EC99A07F66450B493BC4752D5FCBC92B79922BDC400521BC0C072D6F55AC8097D96A3128B86B0A94C087C350C13DEDC2420CD3907B9013034AA7ECAC04E89C509A16265730534A84842E69B039101D098C240C78148BC1C4A861FF89D7439356047A09218887E034BE99899F93AF4195BF10402065E8A7F222CF30DFB9389524B1D6C52A34D04FBDE4380155AF7FD5251DE107B2059D7B01D36722B4991D370477CAC878810183A41FBDC47ADDC01A1E41B70EBF5214CE41916A4DFAE116FEDE1429EF2AFF06E7C645DFE31D49CDA6458FF2D31062746631D5BC18EAB409B8D2458FA07D175FCD38A07FFE295F4CC96B49A31D09D7C2C283C683DA38DE40009189ECB0994A2F9748C8AF082474668B330A3A0B0B4CFC046248BB54EB0DED3789990963D027968632123C249E46447F6CC112CCAD07A02B19B6B250B8C9BAF2B9254CB28A0D7DAAFB1CD061D4486529DEAF64C93A8215C8C0668523AEF0BA2C486BC3B6DA033A9016C447063B64ECB0714DFF40E2132C503F238338301DB26871D8786A1B193D01E98CF086343030FECF61604CD219567C909EF8590B5965DE3C6761E3C585137D405B96AE98DAB7E92AF88021859412728911E1715ACD1F4A47A204EF26C6411074315830842C95C906B4634EE20DC03E12B743341525F3D24820C7C3178BB8047D4D9F844083A46CBFD2E38591155C18B9EC9246835019E9400B443BC3E5F9BCDA87DB7761FE750DEE79019E580640382205443972349580073E8DF6693E9C049D964FF99DCBC9A6358FF81CD78895BA09C5092809AD163FFF2416D2B8707DC311314427307F1253F0D2856248B950C9D83D6AC921508B3B826E5FB5A21C493090000815D249E34000A71E4252A65B5E3A1FC6475DCB93A783BB3366F8194862278D068DC7ED563BA6F352705F83413D88628506017F2239240FD67D847EBC820AAC5FDDAC208F00F9ED75313B9D8A9047DE3C1856A7160B2CE7249B49FA03F029FD7F8B79089F0746E1B8124D483BDF0E48875B3B85BAA5AE06903F0ABB612BC164480FAFC269711BBA1E432DA02E26D7C185671A4B50BC9146AD69E0B30DB720A4600F7029F751322BEC137A320BDA02367E04C3601AB00110A89CBF117AA80138BC3651F89717000C5EA1043D92E6060B8B4AD1439A81E0C021CAD0E149418D038CB54E042B12E51F174929'
	$sHexData &= '18851071361039646058AA3CDF57F9E9A7D23C2B857471DE7443FCF8A24A03DE75BD9557D451AA5C2C74D0FE4D8B441C950F0747481D933C475F7F864BD2CCDF54B3FAAB80C7A0F5F6199070D006D789316B58801758E1EB2CA326B3E8E9D13D4255187EB201DBBB702D9906408877283C7028955E0B1BB882DA0AB2FA043C70105100182978A636174FD3D5BCB648401814180C1C1C7CB66F3AA7055E0F21214188707081A7852154A0444B2639288B351BC00A18031EC160B195548E4041C2A92355933F37459800EFA7D5024C894A100618F5028413B205F3269263839A916A164911758A6AE57E20ACAC5F746E4DCDD2415711050685FC9854405613E04094A05A23FF0299485EAF6C2E44210239E0F5C993E7442F69D02F697C51C16BE8CC40D54808482C12D1AC8B0032C920642A1A188BE046E61AB0DF5C8441781A28B4B6D604D33CCD53A20C08080C0C78478FCC10924218BA280630F3347257961821C728286390E7E84818C8283038AE199FD949B1DC0C847C5F56A8AC343D5928F23BCA30201E7AD1D950B24C11F086CFD7F6A930B0E0260B4FC1586069DD720D9317A81F8B1B380C123EC228700F48BA51E511CE62B366710305A388706BD038691437064FCF854CC60610DF40973F492C60034708474A5F4492104420E994F42B47285F5E7F08814E50E52290668ABF03C50683D1D2B5380EF1AA8172C78B39A63326024E121DFFA25E69381FE44F31ECBA3070010CD4E7FBA4DF5ADA2692350E394784703713E9471F328538408090C72A2C1C18F072853CEF0304402920C4D2401425F862F486403751183E17FFCADFD02C7B210E74596A03DA4823D8B80A602C71365ABB6074BF408B3F7CC3AAF5656F200193750825C06251EF37C3302D043F08040B2A5A53C37F490364A0E2BA387F38B1A4870F1F301729A4B7B485793469764F8503D02A031F8877C1E94E86CC7618A2C005AFC60CBDFC898C4646E249C42436122FB024E009BFD09C1C48533E1E4ECEF3FB9B788748DE085D8900175BD4D894302D1D5A8D551D571E6A48DF1DC64696731CC32EA542AD9FD095B635A9AAA9DA4C1290FFCF7B158CC0ADCEEC267C4977F750091E772305764389056FCCAB1476290F445A7030C68CA5E8DC368B0D4A203CDF244F15A80F382A77040C38EFBC0FA8272218F4049E5730AFC633B3749B211B8910031AE82CD5410100F6945732460A8E4303296FD751CA41209FF24A12FF05DA57D21AE576CF35CB0DB3F91CAC887FF428AF57FEA6E453FA9557813B1D725790BC1C180374576D57CD0323A0FCF5491E370C37242F5BB10F9ECBEC2CA91D40D7F51CA76033A0C3C7B04723950695434FA74B06F780C60188562F85C911E0E79F20417C1ACBD62A90CE497081ED0'
	$sHexData &= 'BC5D17313CE049067C21E38D21A48764C5048CE824E08D5D076B8D2018FD23F6ABACCD263A1F0CAC7CE3C95006088004B8BFE71B1AF3B5B336DB1CC8275EC36CFDF3F7D849CC6AFE5378AA747F85A7657D8C97488004F2016BC2B5B5282E4AA850FBC85DB4373080654069BF471CF8B47080E8171C490CE08A9F8D7952BC282791F01C0231AF11A585110DD4B09A1080B1E5A788B94100FD671FA34E580720EF2F68F925E4A197E01388697A53623D22AA0B0B0193E7569E4A2722BA26C1B3F48023CEB58F83D1446F7D2C068010E6C0821FFB707F265DE00C00296C275E7855D326E4AF1743C7E743702FA090358F0D1F8E6D2B43743EB626810FAFA1E3C0B8B0E4289A0EB45B74A490B0B1C6E92D97422320B2F79C4033D494CE1BE7303CA443C75E16685E994D41347C766680D2BE19092FD43CF25C8A7269964BC974219938CE7E405053DEDCF56DA50FB4D8BC392D6606AB9DFF48B926D0BFE9BF1D4846A260AF0D1D8DB4E8918B79A270EB343124FE0102B260E193828F5C0B9C83BC0CE85798281106701427B65986ACC8CBD728E4FE86C9AAAC04DE8C449BC740006D7FC6C3036E141D2225DA05DE0206A18DFD7E7B14BA9F78D559ACE1D8C7B22DA1B06A2FF02742A7E0E75878C0D91010C0E8E48384C2AC8860C304C81E5C76E2237A944DC6914B0A881C8A83BF19358A79F63453B99B22574061D8BBC21A873115769200D958C0FD21E732631DCA29E033C28455B6F66C1CC11168F213490CE90E00BF54AD22315AB3F8204747BF6F313BE7A092307238B7B5E1606116B4B188F980249CF46434004BABBED69F1EB5A40037415E4DB0D980FECFE0F0275D84E0881E2251FC2BA2CBDF182C40E5180BF0204DD4FC1416845F8A4F39D0DFEB38B600199C4277FA2860F3AFC83EF017438CCB83D6BB2CAEF09D0BBB0291B8B8B1D447C02DB24BB0977A1D5A61F481ACCAE02B535706FCEBF6801801A484E5C20A56348535D400D3AE879B1050D4CD0F853815281C43B20BE9C0C21202800DFFE9D38644830288355A042321C310D86905C11321B5D504A0A1F405CB0901802D1D28B91C848081CE8201C74402AE90D5A5FBC809418907A4A08746827DEC808F46A59821A409D806EDF96F1E03C33D29D2C382D0D22B5C1C1358545BE7D2F8A7A8CE59BC2EB8CB7243554BF1C2F792501110A6B255FCE982C10AA4E23BF426838B30A2B383F518B4ACCFDDF2D8D43388BDAEF386E1019CB9BE91EC8151644FE187472E2138037BD363A91A013C0602F24AC0C3B17CC889D30A4D1E00B952E4F469AA6135C4B4F470F452AD407D3E146C93A9F85074C8252F9C456F0024A585E1184F896429A42791916621F9148F9489E8100C33F07E14644A09F9E9129A8703558A74D080BCA'
	$sHexData &= '8C61120618C1256A8549FCF4CFD4852E644D04BE8801AB8513A47F8C3C41383A8D4B43E87736796AA570303C870479C2155E0692DE5027226E1F05C80772C6763412937674B508275E9227A4915486E7C10F863EEBB4620CE2F9DA19C63DA19568E44E027DB04BE30E0F42F1A67FFD37A401CA524803C97518C2EB1321A2DA4A5806E02CB0D2D05BBCEB059BA745622D98889E94CCA06EC2BE346B051797A5675B4BBFA423B07C9E08DC04941EA17FA0391507A5C735A6415DA6A2744389430314C5AA489BDF53250372CD5A0F95439E3476BFFFF74390412A9B16FE0F710FB19B78A6C60F9A7621908BE25B6027000180B938932ECE6516F8A4F98C47A5422DD89A05274D038A9F0C197646EBB8C3818C0CC54601BB737B1237905A3F510341AF906438C2720C488B728003A9510DD79052080953B43150A03952577B0C47D4F8BD10233BCB3874867B6238B73C49CE7919B315D8DA9BDF5E416F206B8BD218A6092AA5A6A14C49044CC89A4A55C0DD86FC4D894A6212497D007A6B8C5C54A80E28DF11F72ED1B1D3A59F667C261CFE61011B3C4F3A0F1F60397A2D0E74133868EAE1A130B75C9468BCDDC0482BE85CFF83B9699C3E235BA674391E6135131BB5E8D7A5A90F1B1A663B173082936816DC8B513E21958455C4268099C1DCA502510255C2654FABC14F3F4D41F940B09E57D20D4DFB04037AB185966D8983514D7CE19DA6F8B2524644C718FABB0F409F41C6477C0188477219DAA4816E6A461B49D4BFF17E7D893B2D894F7416D30DE91A68BC833CB1AC959E43E10A02DA8D3582B40E49035B611A86B41BF9357472AF52870FCA934CB2908FDDF5E0635981B7205553421C0D9DDE7AAABA0252B77434477049142454B497F100C59723890898804F9D400ED1445A6F424FB0B157608BD496B5821D0B042287E0449495EB1572D6AC636C4B032505C69546B1C1B32579C1625FC5FE0925A2D21A4A4871FCE1B2544CE9574C3930751141A9307524EE0B6668604B2CF883EE02FFEF47059161AA86F77E98F6A6F582B56374170BF886EDB241500CC81F5D2D3983DBA4EC822B204318CF209093CAC88B9348434F33C8E54B530F5747CFC9C825074747C7625062246F2D994D1678611B1F493904F0053FF0C17098E4A588C808F96FAFA8C41A02B62DC849504D637854B5A1114C52541DD4691F4B7441890144578449452A1048E20A82A2B4342C944A068CBF1780E7E4BA9327A38E0FA5C743013551C3C347C742093D2F265D9C64B81820082C23A0AE39D346EF541EBB9D6680B7BDA770A403DCD8E90FA4C0D221A3721FE21CB365270A7B4680766EA26AC08E774961A581A517FE4D1FB00460CB83CA207EBF219D30E636D20F442D92DBD488045894EB0DDCA98406F'
	$sHexData &= '8C8D1BF8C11D5CC1596D94D8E4C383713497C70294C758E4FE53DD1B3100930079D4E792A28F7E6054F40B7D0826838491A730983E87757F0DB6F499B598B5D1C398CB02B0D4465D8B3E745F78A49762268C03BD9D8CB1F492B280A412A108A72182E23A409258E0DE9E11B723F1DA4485CA119865861BD809A5C98282CC5772B0F17AA5C5F6376C15DE70A7E042B0FBE18EB49486D333E4A5003D8E27E1FA6CB678E146C400C0B14976C1C31E1C58A5D064FEBE1985D079A496694002C71DD2EDD5642071A493978E06A20BF383F22FC532D3EC051504C63021642D823496A73099A593640AF40D5FF5004F8B88F01A439AFF8BEAC7601EB8DD7B52010F963DB5B1CC01FD146FABEB06AA10C87893EE7EF2BD5AE6A0873359AD6CC3951FE752A2650B1A97E6544E18300FE9C34FE66066084D7B8F8BD28F7BE19F43542809B794A74748A057B9A087B0E541A7BD36CBAAD7A28C675C7944B38532925A8FB1174524CE0CE5A93126B509A7A0055E0BB97E44863B00177F0026DBC288B1310090D6F159CF450C70032091F1D5813612EDB7F435E8AA178809E041A1C0E0F01101CEA053C9A138D4D8041402B9EAF9927317C584B0E504C48E2763D217C4AFFF4B5912E6B8B534A824966223834488B90791376B0C0D3750A234CFC8841410396B9EECD918989AB121B0842C4D14B685AADF4C11582EB546F667A06AC5AC237E42478ABEEC3B841CC521D584D3AB03C8CE1CB48BAACB259489C162843C21A3D1023FB5EA6AC17CB8A14653CD419B2FEEBD9B53EEB436E409F2BE8747E64EC804445988BC5BA01D346C5F969976EE89D4AD29D56DDC64372E6E450820B97884603F998325D944B8003011669BA909D07442D18259629763F051F8A67A156DCF853010943A261117EF1EA6B3753817B43807B7C6C7980833CCD48BB46434393B04A21238B044A0A239CFFEF257130C33240AA48AB2E3AD2E22320A68B25032AD286865B4374CA68B2EC34091B2C144C4C216BC5DF39C03C885A65DF6442C10A439302A7CAE80A02033AC926BA37E1E49A581A318B81F54C27435F844FDBACBCFCCAC241504C8B084D41304168753221834DCBC31CD2ABA66F40562802583733B804D983E6AEFC87C686F6FA0474D20232C94183E10205D5D04008F69E0251E124586A3D2BFB0576241584C9C0500C84C00FDABF3B3549A0490318654D8B7B38060701B6869411163043407977B841710A38727304497E2A50064DD518493268305554938D6FBF3E7A616DC3C0FB48DB01DDDB116C456A05756298628D3C841F44BC5E3614F3893FA7583C83609050A69E55B76DBA4A322D24246310F10C600655A420BA51F4742E07D734C729310A4B4423FE6E0D86AF891AEB0749C7020849583C8CD67ACD'
	$sHexData &= '116D9087E62E422B48429246407DA6C25EBF42690D75E094386B98C10412954197F2616B95B2D234C328E002C10264E80108AB953B3C60054AA53884D251E463B887BCB50E97498B2F09864200933A18451530F7481B61CAC6680A16E90F08A158D27F1B544E83E30380AB5887AED6842145985CED074AC316DC85FF47C549D86522EAEB24C84DDE4309013539C1B674A32821606CCE777253DCA76B19149F05746376715934174AF74A8D1C4F2F14681FD3B1182497C04E149F1C5268C3184D890A5FF581031D38D87CC9D2A278324569D416851EE0E17051FF7E6B704A0A714F1659504963134DE44D3BC8730548311602F601C33C4094E4B4C52EA17528CBAC8720FA6164CD891E08A97E8A76024189036987AC20804EECDDBF7395FB423E41B933CD4877A371C3187800763F1CD1740D0AD20AE7F750FE7406D402752CA74109BA669F410AC3088411DE78B075C02314D0DCC2C35AC1C3B26E34937F914434D216D989B6EF7F54E05E93A495FC664424096CC43CC564139054E4DF53E3486ADCFC2698486311498D34C6732814B0A7F01A124B403818286A25069EFA4002D0E435E0CC1E688EC56AD4882E1E8D73180B1C204B64EA41AC53E8166B971EA23F732C2C364194E8CFA370E854F5480308F444BB4198FCEB6E52FD2F5A672BB74EEA273ECD0F86EB1C837F0F267656838387BD3FB9252608133090417D54AAF885302878274983E7E0F647F830152A461E381874F4A31E993A2EBD8DCD25AD006DD4A203F6C7C6A8C40251B5923EE0D3292878EACC4AB603EF709A2AD4F054FDD8AAE1C87C05890889BA43B207DAD5C422063038BC0D52F42E960A20EB2F1F9268D80EA4EC069CD44D446A02CD6C4F4F0655377A4D9C944E32C095909612ED1EAB4A4B9E4CC66ED6A2D81E3C5310834B76FF0839E0B185452139EB0433A454680289B12AFCD824FF510128AEA850CB834D526DF70D4617D8E3161CC6724AEB122FC6788B564E15265123E210DE848BB703D259AB70C2A582D04D79887C0E2D1920E80893B0097F08836370FEFDFBCB0D546104A90E47D0C0081F2077943A661BE390BF92D6888569CD18A4E0EFEA7D91330B0F28DC308046182C9BE0869537D1833629D361BC0116784C5A72A37714A60EA6A60453CBA384BC04F59040F6C6CEB80188B5CC8C47401F7A04BEB4A6891121C915C8F30C5969CA060CD148C4C7D000D4296C2BBBFF2B840FF78DB158AA7F0668634037DB64BE04A2774E8E840835062B08DD7D77458D881B45898C08542B8D4E089C763EB85B730B01100A490F5317170885CEA9605163FF1F818C9C92505746504EC8C8C9504C10DB0A05C8214F7A0A10AD5B93A91FA605ABE427E1989F64E4945C68274D6892464E0E686418904330CD9'
	$sHexData &= 'B5699AD09038251F2F8009FB156C9C854FC78FFC6A0C658ACF951493A127223A7FE4521E7D0751BAA945B95A441A1020D94E6814974BD0346E23057D1FB781274A1F50A5A6EDE07772BC608DC657CBE03DB4C63D601940533853B922F8D4092C76AC3C57626279990315A5A74900379046432E898782ABFE9488D4D55AF26A0D052D002709E8E51C69BE646F8EB087F5F88854117B8D6569A5CAC69195D300F152C181C5AC952600C335B22C39A80AF9F0D286C02FFBEFBECF0516845EA603BC6255B690FF2B0FC0F7720180F42C604800D098833010F25F7029EEFA5C6761E39902E209E37F06D899D8045C6A4FF050F5DC0EB2A9D4AEBBCFC78414DF23CE747F817D00A75088920D50A5EA000AB6079CF498976363B472A3848F741F59F2A1D8718511958395829B5FEC55C972C901FDEE32F2E3516414D48D8343363F3B8A4C3255F683F44F292018E455B5C9D2D432003335B6078A82DAC464997CBD331465ED73E6E6064B03CCF6DA0B51A16C148775B81DCD0B53FD9BAC098BA9CBB7FB2F9E023C468A4C730D65DFFC81B6F24D5498D2C17BFFA697A5F658B71EACD56C9CB773F622AE9336B6ED1EADF2E073D8422321627C8BAD80BA52005D7CE4B1717C3D3695E051D0B408F2831BDE4255E05746771D370030F6F104EE35F69E2F90CAA495E4948D33300785711753F2F23000E72210BEB19B0344B0C09428AD786E386218F2F60D15A0CD7D0F45FCF29641C169AC19E34019C0DDBAA12F102631B2E189279183774F44C0FE147430B2805C8BB58DC6175204E7CABF9F729A841EAB437B8F73EE96F6DAB4C151D4A104674E07714493BF47784909AD6C50E9CFEFC26806279E851FE104526173F0045FA4EA78D1C46D402F0769D4C9F8A3711A14E74ABC782442A34E516B45633C5FF405A0D7C8F5891345209FAB55CC3BF3131B09E58142262516AED98DC3F3F506E9D66BED9041197C46343C11045F20616783F043401771A831AC3145A6082E7C8C43BFB1F4F883BAA5C4ED0772D4E96A65C5AA7EC80BDCAC0A328495D9A7C2413939431BF18224DD26222C5BF7C9256B0014CAF09493BF87639840CC905490917039007F22A1102E102494F21A76113756690F7724A361E746BCC01754993F29E2483BF7F5E2492FB20579C4283CB045B72250D4D713C4490CABB9557680174A3D450C10F909BA497CD78140102E4242B4502F000556C846470BFC304BC8AD540455CAD17C741EF28E124B41E60234C44888FE11814B7557BF521C5F4B2E2D8D2CF4E11003884AF6E413D2362D24684C1A50E51C55C874D5A34E5486EF15A62C86FC03B58BA5AB8C76645EBD783F83BCD7507BBC93018CF751C4CECC048A82381A89F323EE8464E10A00BD44503ABBBAF7FEB4856C5E5'
	$sHexData &= 'D2D2F3304611485B80DA810A0C4ABB4A02C4409A009220D6C1059BCA3579E14763A888FB63FE621D8BD28211631D3E4F64489252B1751CFA0350026DACCF958A17773D72840C24865122B189F32011FF5274D56D48ACB4EBEB2BE38A8B4D056706BC4C0C2A4FBB2B3E6C2978B35F6743424810499F00BE0478325F2B4C9701B8BEC820B825494A0AEE49922405B641008614CC04E9606CEFDC86C2079E342495CE269466A303C718029C6DF649B97B92045FF88D33A8174A69946013E1652A424CE2D63FA1A197E6C2C09A495626D100032DB2022CE09730AAB043E85EB4DEEEA74D3BE9476BCD0BE001C9A812683E72177E0BB243EB4D893476494B4E699A1D00DE09DA405027327B0BC80AE0164A0D472D50E01E9128B6D05D442252288B685DE0C0035E6892086BC0387B1EAC006D98487098401A21A4533E078030E7B14D6BE83824114434AA0AB9CF60831B6909387BADB43C45FF6A8945A7799AB70A47040C0408080C4007759A0C10FE57FB6B4A0DE44D174983C5388162E2DD388D7FB0EE0175BE7E95F5A9AF0179B0656E7E131E5BDE11F1443BF6B38D3F9792884D8D46185ED4942E5406348B4604D0F0344FF30C08080C0C109A0B21B57481626285107A484D896079A2364801D09E4938E0DB6C0DE638BE52384038D8759CB12CE86963E90666E12E443D21B823A2774543750A9A4F0AF0F00447BF06C80A46004077700777230E250E270E88B8CD042901611006A9A206891F4C30421D5C3038220C25492DD1A915F5EC75995A8CC71887D05382D0D7066A8A4C7C4FFD8D5B188B038043699A3682DA0A08080CF3D099A60C10F1411C4D41F0DCC84D031F0E4B30901BE49921634323E387D00F47144D215B38549E0C8C23427BDE02C00F4DEBCABC90128BAC34D16D0BFC147913F2546BEF387E27E520B22B261948B26034459B8368815AF6F5F579A542EEC6D67C4C8D464E18E02809BCB4FF012497CBE5B841414141E01A9CC500A706B9011F419EA772B849486141F23CCFF3214883C2C14049CED482088042FC1E9F862DBD3C90F2EE76C8CF22232397064646468B33C9C30409AB3EEC4725E01B05D6F34E8D342B2A56D0766E1233AC92494C1CB43EA8EE8D5C1D5A2F00AB404A3B644E9F36888903848943830AF4644EE6810A7F0A7DD3DE391749401C77ACC7C403C104EC86698F381007A8E22B0B543C1D3F0A7B69353C414B1784353C9D9FDEC99CCC698B427B0A790A06481ACC770A9E41C1C8602E79C2D69461185620DEF3DF4911C478509E494CDF665AA788C14C2566F48D44A06B35F9710A57075FE1AF76C13EF270E6010F4D8BE10483A2BA040794B23D818F049E846E6AD89414A2C7DB49BDB728111E6DBF9E2BCF087E840E5CAE49C1FE9CC60E4'
	$sHexData &= 'C03F04D57FF9F04156B0649D1FE496BDE8CDF878B6847E2C8CCCCB1D8AC6B6DC019BD2C3E86F02DFD0FDAACADAD0D235CFC72FF90F967011B41275DCF3553C86DCD03C52275C7D17C226D22E2CE49AADC0AC77D86193F2FB7BB69ACC61E3696F76E1ECB8AC12938C86DB9AD0F8DCC140EABC40CE848799D5C6A923129BE0FB9C1100CDA5AFE3ECBB6C4F8626368CF38BF59C82A8B043BA7ED32D0EC8C3B040CDB3A03789A08DF0C7110E97806D0101072E720C92D9E1880CC32180A2A4FE5D9110FE8F7F0FFF83AD3867807B214E031C73094C1E828277B436908A4EAC63DD606606348A8A845380D66C10B418F14FEAE83C48B029DE61F483FA730188D94476C93B0C10655E8C88146CC7F46D0AB83136C7D46D47B46D879E430253882E081017DBE302530257BB67974CC505921774707B2B2918DD8BCDB46CC46D0987499B246D4B8C857211852F15AE8C7D90B9A56C133D2D1DAC895C0E0160584709D6BCCE9D7370ABA0E1FFA8D5018055D188A4097C4B961841936EC8D07364C846A471CA7B6B1B5274720200C21512899217E219B5067420712470721F49006FC20E11FA046925313834B36D818B110990C4721D0580770D753446355BFCFB5007A22C8E2016FE82387EA08797730066E520D078198CF2A76411AB01A1F3FD47254CD899C7EC48503083C2B4F4885ED6EC74B4034A339B02CE716FED581A95690D0E8CF9B8C075395E6E10C7CCB3375D48BACFBE30C7A48F7206B8EFA03BC65534DD1B938A704917452E467E47993C604CF4C8BC5ED3ACDE7CE6D6CF76F26B893DA1E34DE566CD58D34766FF528CCFC4565A38CAD12584D79A30C41DC5C80E6FC33ED8067110B1ECA6F76C40C64B800F36A4D3F9E79D03036D87A64043ED7CAD9E24CC1443EAC130EE0A1542A9550E858F06B277A823E0EA40830C7260C63B4A3FB72284269C1AB8580D67DD471AF36583ADF6C1B7F0F9083AC34E46EEC6EA634546B98C3797F70BCC24013B243E14BD89909D21469010741E0EAE06A5361550C4E52F55F29526943F85559658E847FA0345608F030816B1682320FAB110CA998C69F4282055F059783C3D05B4A0260708B60636F8CE99D4AA106DCFF8F041D8D0C2A34BA453D44920EE4B87333F848AA46B82C83EEF925C3EE5BC0012A1702975C72C903040506FD80C92507AC2356308DDA696DD0B703C040C0C20A15489666282C24B6D1B40DD2744528D214D5EB9BB2977E0FB92D45FDB302A91C75F149890E9A4E6AF46400CCDB305670708971E9AC550105A015600518466A0E0334D55902392B0A5ECCF721A4B1816C14995AB7A1D5795B0EE8A7233A6B180620A48438E9289A5C7801FF1F8E7807F3480F2AC1EB159E82DC8E05C683E1080BC1252AB04B687C58047E'
	$sHexData &= '38A81E699E19D550D27657D7EB18CFA7F216A9E9A083E05CC8D1D0371388D2D40C5ECA0F2FCBE2CFD0BD7472BE18A230BB33C9B7FD5C44E80D0934C17216185CC1104CC00E0092B800A7F0126E6F8C2CE203C1B9CC04E0B6138F47C80CF97319537E2A8D72EC5C8D3CFD2BB87619A20319C97C9DA14850150D280B379C219D100FE213F2D4141F42412935ADA51912291855FF1CDB7062FC863A1ADEEC504916085EAAB2304923C75860FC76C604C14D3B04240C891CDB04BC68721740EBC7BA75061F948DBEE20C4654C1087505580C4EC6A39D25967136FE6D257032F68E2BD10EC96028A1135A075017EA6CA30CCAA07C027239A81006072677D0CE8D42DF04205E962734AC485BA13C24DEFE1437DC522D5214D5B768C1E90368AB4C03C6471300603E4DB21D34748348DF720667A0B11E1A38BE01174D3BB208C39F40482600775FE94295262F6A8748BF79B6E429A9CC1FE6A3A4A351907FF8D800EB90F9CFADD0D49014DE7D4CF0425B1FA55C0F4588675D723C10B0763314E9CACA91A2C64555281FEDF21479E98D6D084BC864386400270F4C8BF0D3818C3B6350094D8966D87408A4E85D00CC4D5D38E4521979C5DBD3CBC3425EC88375DB2631918354AED9FB1CDD19560694D9546F799EA2D3EB5CEAC44D45C17601AF725C5558DA2E03C91983082B6424C83F2D3080524ACF4246FDDA9A8D20E4281A064908EB048241A90224107EDEE24A08CF7C14810B5A3C96AC76DC08EEEBBBF90A6BF1A6747C8AE6224543DBFF42B2164D897E9E1A65060672424D45304830377D4E0C4D00224C89347E7A2B03C815384C39444DAF095088C176373847CBD40930D2888BC2A4509801AC042044DED58807E96C1E1196883868BD49CED1767A8B8724DA0237774248BBF5DC76404F24C30F87B6A94384134332E8882E522F3C980B25D025199646DD4486590140DD2B8685C995F4B84C8D4393B43A832BCFD20A052D234865A4082E4949AD479006B85A5C30D03001803B5F694E202D8496263E3E305BD7DADF50EA3EEB763A7823DBB5C66888349DC67D3E0B2B0046BDEBBFA86CED56C5B958EB1021E996B44A2C85E73B3980E14343BF039027873C78A21F791623409E0B03CDC804C9C8EE7CED030472901CDDED848610C8C5B85437E0068E417CE392A8020648E101B1A0C6684C02543952BFEC7A9041426EF0326064EF20934CC837EC79D7F8B99C482A177A96FF215C72207A96723F017C40174D03F6495E01CB418C184EF1B98105F57856F0E9C261A3146438243E8A08771806375A443E02DA855C15032615A4D6E2CE5B46C9944CECF4A40E0F0E40374C10BAC6244B845E116DD020215FC5E1C8D0C1696AF07F388DD05680773B2AFDDD31A030A91BDE1C8A4E18031A3'
	$sHexData &= '767E85008B1002C3C33F6BD58A9C88D6199286EB483FECB7C123A5E55A4F9877C40488BD5483BE8772F482AA259CA8B7C18CCF70A03F2A0577C1874076E0C31B71892AA360707973477CAA5F75CF2AA1AFA07366D022C18C5C5699D1449A107E9431716E62194B638E533F7999A8401FFFFCF4072027D680F433612722132E065E360BE36C995A7F9D0183D833148C87D61A550846EC8B9C3B0E1408E95620BCB63127E93E14D8D4701D9B02495E40F76450A680B4193D1010C1C460CB57F461F0AE821ED470BC148D470443541EB343191A180112217DCD459CDCA07C748019DCB03BAB370D51C2AE1646A11659465EB30CBFF19BC4CAD0860C1DD1F0CC601F2216010C3599AC7865CF675430386122B79D3989FF8F643F21CFC7FC681F1F24CBCA6F1E88D89EC5FC141C2AA218E2C2E18DBC1123E786235C6400800251BE304E7999F2401011A2D1FA808001E32C0FFE05A0A72D101B180E4D20A6F163A1C02300F3D34BD815C49FE00DC8104DE5A723CB913C7474C363A374D4D4237730112B0C1DF880D80BBEC52139CF6F5F6800E1C409838AC2305DD40F519C612EF3883F20900947662151CF2A5DEE181C32083BB263A269FA739EC023D8D8B4DA216832B676F4B74E5C9D3E1753238129DA6D412FE5428FE4011003C7C10EDC502D089D440476021B44EB90249438604B1B45FD420D370C8EFCF30CF203C9023CF20282DE1F6E2BC043785DA37D3646A3818C4687B20E4211D261B6520E3E07D7802B5914B20D10000A734D88DAEBC6A635F101C80B9F1141CCDFE9B1383B9E30AC85050619AA69BE22747B03C3823501C41D70A31505D1CC8523E5AD253104DAB02D252C53ED95E242327D488FBDF2F9A6E400DF21F4ACEE4855C213885DF424E210F4EE132E1F3E9CAC6491E831E487390CD2828DF8329D02103C8C9DADAD40EA9BC1C8806DFD42802E4956CC3DEEEDE8190A3642828792143C8DFCC381DDE9253C803E6DFCADF64001964DADAD44D93332465D3DD1F3485404EC8DD04D9D36493A15CF41B1FC52938A4D4385051271719233737B1E00F84E44533807C3F85193CD76D85CDDF0E562AB69621AB8AADDDCD111A4A0F5D1F837920990F4B99F611DD329C227B5E9307621B4281DC214517C47B1036277F807E51325EF40CF87CCFDA32814DF34C7FE15B078B6C7999EAB606359DDB258EA9C17EDD84800AF8E7504D8BFA498B7034E217A495DA0D37642BEE121F935A7471751D2AED977E68890A5FC2A0725044A26EA68D481F0B4067BB487A1D11AE52F8634AB1E64C2BE396D462E03298AF41718312016396C0EB08743790152D070DDD06767A26F1273F2C0BBE2B103E09D53CE0D087E08ED211E723875CA492E9600A1E80CE68488E928C7A4C70CE4C88'
	$sHexData &= '35BFA756CE7A224923CF2C4E843C010F74B44377A16834244DD6847D080138EC869BDCC9CDD40EA3D320D3D44CBD2DD949BAC780998470C89F2F052310DBDD86810CCE82AD881D1047B5DC0EDC8696E8902C0DF105E099D2AD05E20CCF0042520052C8EC1E8A48BB832DA7A224BC976A24D6DEDA1D91C16BABED5E281D871383ED3681DEECA002804C228188BCB00638B10A9F1C0A80C16D28C8C1282D1F1CBBB5CAD354003E7303492828380F878AB6897581C10E0F8D578A788D183C01C5FFC69AD6576C381F3E9E87FC70C804ACB904D9B082917FB091046E88291D03D991762414A44A1ECAD80A42F03DA6A49D3714750CC1D961E0DE9E23043CFC6190E11A04D96CC505F103D112BD0CCAF35007B2325903B2231C2D0E39A5CDB9B79D52480A4C9FBF59804BAB3F7AB5C529D5FFE8A93BD08B8B9B1B0A51BB3428078EB6B030A94E511852F9ED33348EE270180678204C8960E0B4F404A06829B5B2306944289D48A46B68456AA2BAB8400D83ABBB59184440D544221F20E9A9117604DEC12D2C2DF877D308C972424C17116E6A3EE0044ECE254021308692239181BD7703C2F5E612F108755FFB800840D304F31BEB41BD08C5E848A9F80470F41778D1FCEF84E7EE588B6DB81C24E9112275C294C740408CE7D7C9D4E2C96CB50166D330820F276D5F387BA3C04185D431D5466CE906C12648BD89A4A51908BF48D50158F03EA7C448D30EB013D83F7CC14C24C140C18C55C19A7FBF2483C1234C44BB7A3C8503B5F87F87E0B3F1B2BE89B481CE943267BD185978276075B38BC5A6958611E70A545500F209B8839D54A2558ACCEB4C9D0016779F4984034107ED415F5618707A00E55B616003A85F04A023D04D4261894E4E20DD0E1E48446B2D5291D24AC547AF8CB2C65C5E10698A609FDF969ECBD84DF31C7238DB464E5C580E56240C086AB086988574777F463E42BF4154584C8BE24DD073F927052F0002004920305D4A80D89C5FD423CC0C514CC1589D6D44F849C1761D0B48B118901C4173DE8B96C86E0E9C50D898C215DB46E25003A22246F550BC8411A94F2C0DDA5688A3EE60D2FC0BD648131E883F878E33D66D5630E02A01FF44BA81233846BEFCC16428605E2ECE488B344A221450608660598052D80DB18A149EA70A4A474E4F3371B60ED7B2FC1D5311CAC1D90E38902205392E2A11DF9616FE950F34EA9DB92D2B2A01E4DBA5BFB93C7216FF010CFF01BE8EFC4C3BFA74070687827414EEBC2137F1686005296CD7981C5CF0357D1C52CBE03629204AD48C75017EE0AAC105B3D6FC75B0C1E2B5F334A7FEFA980D567F58797713792D8D51FF506603D340692B3A8D8530658106E05E695A1472DBF916BC5C6647FE013EFE9BDA0519E0B52AD3F711D1C'
	$sHexData &= 'A91AA0722410BC8FA381B9692C4A975245ACE1D559FCD40BA3F0E3D0D17D20304AC421B3FB4043E42F2F93650538625EADA882E24585355D647429E06027944301B94B62E3073158CD62228955F358E121E88913C5A0E045A0DF89BD10364D32F3D0C556C5913476C0050DA400C3648F56D61676B4F209C117ABB0335EB82D15508038DA3B6AEE182F28FDF6278505A2100273D940563D2DF22D9D22E4E7BB6B00B9084F81364BC301C6BF111266B93D6DD8BFF08546985A703B8B2CC8C0D9AB1D25AC2C1A3980160C59F55DA4C98911C6140B5EEC904D90C9EF1FA9EA62D0E60100CF87950224918805200FE1DC44FEC8903085F105B4056973423AFE5034B7030A0264609AF49D2341B162B84317D9760001C6021748469ED5510609324CCCFC4E14E6EDB8F284D03E457D149719AB56B243B318E339526314600DEB95DC4568213AF8CC5B4460AA19B801A6F4DCA4CD8303CE8C885909E3F09EB2B3F018B0EA994934248E40EA30A6040C92F4DC0959C93424C8A49C943983449DD46E16048BA48489C9EC679058903E42E3062000B8F8B03C005D7914BFBCA8B0258502FA70659A51FFF60F6E3BC58FE134E875C68809421807972000199C9CA13137832E0447D351DA570891375C67C79EA26AD8041B46ECF000BEA19264B27595E8827E3B4B09A8B3D25274A13635A3B6536E03E377FF469E4031353384C8BC76D3FF88BD6E6B409807B4894C0EBAD1090DAB53206A9B0A732204F9C3FA3100148A82EB4569F118D175B68ADF3BF3B002B9990093864E4554D7F018100AF50DB007FC7100BC9AB502B8BFACB6BCE920389E551CCF30406C91CFBE805E586051F5FE9060813231F56BBF5B4DC383110F7B99628B0365F0AD6CCEDD1E4345ED8D1719724D0E05905521049CE956006A25A8572046CC1E7A6A75208C7F2C1045A00EA97EC6A0142D636AD2EC0FD3EFE43F892F935EA855FC43A85FF193D3B4F73A906FF294FCF4481F63AA5E596E334580151691AF0E343CFA9B86AA5601ECF83E1148D34192566B4751E3D49ADA88FBF304C528B164DF0055FA722AEC019F20EED43F8507037E24D2BC7F2270187438B06143A488B5640822041421D096BE83A1F3D3DE5AE0834120EEB5DAC9346A06C4F89E85118AF20B15EC31F2FD62D1D56DB484D8BCD27699AE869B8EE4D8BE1FD562AAEA104AB54E898C94A504E46C0708BDCC0C5643FE54B1685E8C4980AC5201143556C2F164E49F833491572400E98CF9888841289E2142451AA0114B728E60E5F895608496A69B15C703EAB21552CB018494492CB2B7F577990D2B4FAA6702484C7803CC9DF6D9A627C246890AB84439A687F44423945982CA99A684A3048A75D9A1E9F73431F927E4E8D3C776EDB58091F8CD4A0DED0'
	$sHexData &= '41C1DC18007E38950923A88454AA7DA1B8A19B95CDAB824CBB902413A1D60A84A312A368EF2D2455C2A25F01D242BA623F55A338E541D142C6E93B9C1F850731487030B14507401E019C259C25420879219BCD0B8BF6C0F74FF23F4334824B161643358C5E6C905322043C474B5D17436914F751CDA914520A1308754806A018075D2DE20D206D1CB2D6C9A20FA9B4E8946F152879307012217906385D43849038066A8A4845A8CED27F91911ED056854141706D9C9141410040C0C02D302C50280670AE8DF76A4118233828FD0430306EB6C038845260A04051764104039A8D10384C984E585C46E731F92C09AC09AB0B3BD136AE18217FD85170EA6549AE391ED4C6A9F1965718DAA47F009C91168FD5BEA5A7003238CACF42375615BF3FDA38CC2233C2B250EB42BA5BF8B1C6998413111B9F42C0A8A08EECB2DA19507B5F99A04D505845C05AB1619AA60AC408C808581A1B4DCC4307D0998792149A12D849E3799EE70EE010E818F01B569287B0A15ED24718E8BF242DB741FFD4841DEAA0F9AF9E9D73A6FE463FE8109A66BFEBF6C8A9549E2A6807474747BCA062DCA46418CEEDE3433D4F0ECA8B4544060AC43ECDD33646040CC808CC0CF307949DA46ED0F38211425B3E6E55D8F2DEBA2438EBF82CBAFE7CD75245E8083D749F4AE56980CE06464688DB2D954646A69FF7C1E0C08A52388F75C22E2D469020C12B2927BD8B250D2548E578D8AD05F4011F5C6E0B037D059DACC225C6BA0524E570404DEC597F50A2D2A505CE1CDA291227405BC32BD56C58392586D107BDA20C2BCD94963095AC05A2A6FC94B02B9FA2124C8D622C4D0D390EF2B8960CE9F25EF86F358BFD49C1E7054D5BF6EB40490DB2A5392C49494AA7E48359089D498BCF7E844CD04A00C1FE05D42C7D8408C1E132CE3A5A0215689232047802867591984340678B094897ED6400DED020061815C8001E080A101635D69BCB47160FCA4EEBC2E87046D63879914EA4EF6A646A187A1A63C198A8EE4A8910BF529BC61BEA5220986E758E1DF8B112E60580A1742074415F90DD2A369D809D0C0EA1040CCA20CE8135714D7C3C6FA7D04D60C1A345E7694EDE6B9E432B49C30CE12D98DAEC901C0DEC018B6F972F26188F5FBFDD753A62B381EFCD85E03A0A86423770E4520380070DA2C8677604374BAEE8BDF20E3645503849AD1185FF439E10AEF2BB66408A274BA0E8A0F6AC9FF905AEFC4A06C0BE42E31FE3DA93896F38B928C32311B78556C2FE4219F742528BE0375F388CA9C3E5C90FFE9E402B929C10DEC3DA8E79BF350464534C45F7621096C417E5C00D0176CCC0901701DA59EB89ACD74778C65907167E0E66C7771140A643A93AEF4E086AEBDC7C28E940E0AC65CBA86AC973C18913121'
	$sHexData &= '80B4F484141C6866F21425262982DF24BA9539F9A95AC1CE8090C5023E25B4073A479A51230A5120840E1381CF69F033C0F1CC6E7762F0FFA804B0F30BE3385C1075C2A35F25038A058102F4D6A337C8383C044A52120FFD531D2810A0261383032351D58917F3E30D04E693AF0EF071208088FBCB8FAC047281EDAF3C34E81730B451341CAF30217C22414DEEB66EFD00DDCD2B1EB307E7F06E0D9E469AE574EA869F6DE815DBE305F75D2CF5FCFEF0CC18563D45628823EBF029F30493BDCA3DC051E20707E9CA1A15581519F0C8535E00364A452525B0A9AD6416136D0A5B87F81DDC62E2649B9411E7AAA4EB7A88FCE49CB0E019C2AF042C8BFA8955A6024BD6644C66CA9D21F9C3BC24C664D3C3BA80302827F5185EDE44EEB02C9912C79A202964CC9488BCD21188C316C247580E6BDA02AADE249C1FCCC50B3FDB4F1E1E81C64E3A08659A83ADEC82C088AB400A174381098E36B8345B5BD5A3D6DD0EAE541ED121C9026F40A5608D40D6EA80606721AFA7577D066B1120A746569565008C86CAC1BFF3F02C6D01C93C009B800842643D34EDCEC96C440284148C68D4930BEF055C016E60EB630C875B0A0095D100A642A049352317654A7DAA84C43692DAD465AF3DFFEBB64489A51515212DD26C2BE10B275B1DDAD38C1260C2003C6E4D0767457CD683480DA9AA8BFDE00A78D0221FCDC40C137D68940F2C7DDAC75B27AE16434401E4B7228A343C2678E1390D124585A6A360E412115103EB3C92A08D421C78836191F4F7BF98204E036C69023DC3BC01C2E0E0437D4B78801404D30CB6165B72C011D0173333F4D8BE0962B47726607AA2D02742446FC2497684CAA334C8D7A6732B2D67CF7493BC7F00CF135D44709E8BAB553F6F2694E6EC5FE4ECEAA33D3E4425EA9EBCEAECA600783261DAE920FE1A80EEC41BDEF179067945330B54C8BC57A9DB0E747041EC4D52528303201E574470246151B4746554BA8BEBB0A4CCB0ED7CAD4110C7E58321E35B3214FCF89AC45716C3B7F28DE31855441ACDA3D9E34233F0F482BD504F1AC940A60044CF5DECD2BEC825233263D47007C18654FACA07D3DCC9A4C6848FD8EC51870B215E7349F4211C710BAAE050464498E18B1294CC558F2AA69AC4DABC7785177F8921EB8891A5A8D710CC104BFD2ACB584DF560CD7C644D70868263CC7F81B0E4E2D22DF3871751A01FA4809749B637C0313F0C642F80122E504EBC50E748C5A1C257F5FEE01C92E485E40672784D459B062E44FF334ED1C905E03490BC341C4D5A93441DAD90A25340F54AC6ED0DDD57A8E4ADD06897234D41149FD3EBDD45A001130E8EF4C7897EB1A026311385E7A38195F1AEAD0AAD6B5925B9572C1711C9F55DF07719CE4EBE81C05AF52DF034933'
	$sHexData &= 'C8740564AFA4E9D8A0588FDEFCC4814CF2BCAF5805F162D00139AF58AF0B8BF138941067DC600C1AE8D4F09DEDA4BA01B631643110CCE73ECA0950450025104D104F9A6AC024604D454D005C6994417F294A3C66900D3418251FA406126803E742E0E9D03559683849AF09103D476E81C6AEB6425F83EC06B49F829E7B5DB0069DA6833F013CCDF3CE69069E4903414BD020CFF3494B430B344E466E83C65C164A0483063E7FD2A0A30F63377B91A20C3A141F937B8015F2E4745D5F8F425EC55FB1C4B1CA07400E21B1CAB1CA078AE425B17DB18C04854C25E0271FBB8181E031488775188CB8712BD6755ED4131A526AF438068662FDB51314C8490F2DCE533603462327E0FF26042F2DB2020B0F4E2D849C5815B51934481D447258A246D20E50091B05FDEBC5B519174CC04ADBCB5E8234598558AC6A24358152B40799DAFE1FE82926FBCB5FD9496BCB3889043941799EF7B76E4439040E08080C417B9DE70C10FA0818A4F01E01EE39280966471827D324332B024F28304C2823A3A74030036F184D07CDC825FD50DA90B3DD4EB0C6D42BB657189A4DE049F5DF01D832014F4AA6DE6480938837981A411E24F3B49D7141D00C0CD42D19D09D1037D8BC0AEE7BAB086AD806E0F640C8210525F17B3E324AD84DD49D80473A3EE068C8495F6B43F0ACC0F3387AB4DF72036620BB55B190FFE2FE86537560B3064818380E08589EE6D974775143A914188C9F1F1C48436707B0601BAC41D080864E071643BB3815F358A878D9759DFECD6349740828ACF8DF201F42E090E7784C8B6C26508AE95E5E9D1F557181AE12253923BCBAB52196A12BCEB9170C9A092106302072D484411E813FB708CFD492B82BF102447728A53745FEA374242099B70E4E83066CDF8D7232C68C980AD4CC0EB6C93548894E8590971C4AB70EB6C09B262F84D7A4CD6766F4D81A6401543103EB24EBB1893FDBCBF4804AC5C0928C838AC864B496C09674E4481E15994F144D81FE3091210480A977507E444B8D0CB6908AEC446CA08BA389573F2849AE8404BA70B1C05D1C155681B55F568A53A981912BD5D890E7036E170A7DF048C887FC72B9E0CD48897C4C8964E15024736C2BB9E692E6A9587AE262C4CC121ED4F3B9E6497A254F85C4BB93FDEB3D0D212F79B9E6B9954D607A522F0A7C5C0356A9815EE5855B6F95E402BC4A0825182C552A5B96DD07AC56EA061C2E93307C090E7076EF6806B0BAD406167545A033EF225E4F096AF4BB1A4928FA48EC621006BD6646BD6428562A72E882F00A452FB50651F83CD14FAE5B6CA174B0A603E9722B64742F818202BB145C80004E496BEB59C21D08E7095E057EC7301F488B533D88CFC64018E9034EE779AFE606082BE29C4048E8A891D750F89'
	$sHexData &= '7E6A1741313855D5F51DDC044612547E2A0011647289664695D387CFDEA5917BE706C314137B8A0851C5E1F8D66003151F2AA614B7D492A4923D1DB035101A212E61E5A581E416085F1270106BCB018BF28822134988C2AFFCA93020CA8770815048CDD2FE92750AF2A43207407DF134D910C410BBDC9DAD9A076707D95C1841691740688ED293495B008F7DFA005F4D8033B5E66EFC68114130715DB1866C16A3E59FB3FA995A61641F974D0BC350E8083E421B83F165860336F92281694F89695BC2C1870A001BC3BBE5BD63ED8FAF5738CF5EB099AF02D6C770806DCAA534554F5063C84BCBBF54D2BF75E3B01B819860233D219E002CD6DA15242B3FF173875404E599E13E8F84428AD7CAB954EBDEE9F1F421604306AC0E322CEAE59A570CDC2DF559F0F9990E661FFC4BDCEF2259D2714484828884BBA483353C949463EFFEB4835BDD42921075AB0BD02363F2E5BF848896E3C3C2CBCB09B9F864AA197F4C5715869B2026591630DBA44844B8D302F42066016BD2C0A6F25ED1BA8D6A1307220575D747C5DC22152B3D75E56541E32CDBFBFC7494C92018083BF7693C29592DA706964FCB934CFB461CBCFD4488BC74B2EAF9CE014488BF9F80792CB934FBF7CF6BF7C80593A21BF232B67A14AC49A18AC546C6701E2FA3C3024CE188124DFFC07766B49004BFE3104FE488BCD0FB7C028E03C0BA26528AA04AC7C464E4B9B1C9201332249CFD8EE5A81B0C9C8C1D4CEAA142F4EE9BC59B6890C564917706281C3AC6AC5B51A88A78127C8254307DFFFB6B314484EC0E4CD2BA94C72D7F8170D200790FFC0EA6B6E32483471F959FF45BF2D694FFA57014588243EA244437200D33E0147231238A8B5208FA761741029FFF42046D2DF38FFC6C3929387C27416E539404E05C27A7BA7C3C1202C3EE632077183C3242EFDF557B95A5C5A03C594CD0FD60EA0F852AA3C052B2C256D481AA6D69F22815C804B6418462BA41E5DF1021E4646C71725E1E42A1131319584C8C43B07D906732F5B7308E951C92F610D063F7FFAA68A5609F14B230F4440E10A83515D5A08B47F1DA59442A67F301F85B69047BA8C0489C05F020CEFB5C4BE3902EAC164DC697B420EC80BE09DA99FCBE7913C8D9FC401C4C4E80AE4C9839DC4CF21AF80DA093F5F669DC9293924239D4E9DC805D410906A1B9C90C5868F05BFBF7B28BCC3C74BBE8D51B8BB3A9F0A4F2A807A328A28152E24DE9CE1F0C1F68BC6431C74E5AC0844C5C041C3EF0A01C361B78A6DDF80B96792218A4794C3FF8AD24826B928C672405ED449E09BA99DCB0BE4118D9DC6C4C50AE4C9839BC6CFFF42BE96163F669B200348C5FE9B9B251720132828812A840C28BF34F02A12F74B30E38B4163817F8D59089C24B0F8514B'
	$sHexData &= '3876FFBAA11F42D9BA483158C06250914164E2741F08C3FF08BC82E5898E7F4940899A3CB16B559A004115091C4F7F07090CA80ADFE546124320F6A5D500155A42A09EF4DE38B093522D66252C61B794169430FEE30595056B84D2E4C1906296107E7997264D27B51E0825068C54F9F601DC0215A522ED095D9D1E565004BEA1E75B4F46C4781950EAB808190A474848DA42AA78F926EDD17412C805569877645EB5E481325E7EA993F090312EFE41C75E524961799223EC7F9E76200FA4F6D94C0610189E8263E11E39D418185E989D7634411CC178B9C2CC5D42A0657D18A8A3A5C37397C331CC201D9F6C293E807AB0C63FAD7718AAA7F0277D1916FECE87ABC175464B3881B84202EF6C2D4D60511F00AD14E91EEE7478B5381371860AAA4260DE5FDE557AEB6E6B5710503665B9901B8135260E088C08C4ED129BD2C645276BF4B8AC153F47194D8588A723DAC6EA8345C80735779A48818150C94811B5C368D6306B5003C58DB1B407AE14C6482E2CDFC61EC420BFB9B09142F7BEBC4D6B6D95D80A01C949DE8B7648631C1D1A7ACC9640A4C304250AF5A1ACEFC7CCBE22D596E4E443FFEB39254CE4428613AF54CEA63C00D8EEE7DD56AF47410311370D588B888913DD96D1802C4E11DDA5E58EFEF87410CC83C7081AD8F505E6F49F20E86179537307783A017804604DEBCF003A12E8FDE1A3C3CD14C68C844FFF09AC6C4D30FE225E03BBF4BB0167481B2E5863D794843F0F5AE9C0560172FB087314F01A9B3599E03BC3CACEDEAF352C344CEBDAB9E169B8950E8074352CACD0D8AA31B259CED80CDDC996ED849C8A64ADCED87048D3FCCEA8488D68E545E8A9A3847B68C6BFBA72BC545869CE0594F5D1E98156286FD1202EAED9781F9E404A460E76180D89684A8954900315B0D8024A2ECB16962BFA409CFB9D530FF65115624C4C03FF2861DF2AB570F36C8BFE4BFA4501056303909E3FD6E8D40E0033D2EC03A11800DC1B91CDEB34CBEDE3CEB69E0512361E0666F23369AC4A0E06D9B2506F9CDBB38C85F40DE7BE003396865075502D8A4FD129DDD4342F011D93C0FBA175809B892D7F17724738265930333E01EB3C8310905333BE0540F2AA633FD0FE1E803CE4E4BDD0F8D0F8E411F242D0C87EBD7900F22A41BD1ABD47202702CABC9F17258F90BC8CBC4BA4517292BC37BC534A8B083FDF7DCBD496CDCB00FF913F752F06B192DF1F30450DA5030B86C26BB9C4245E8D802BD25604F036B5A20CDF4B978CD57E9200513A3748B504540178392C4F2D6189BB515ABC014D362E2C59B9B0D0513AF08F97C8C11478A4B7FF363358787261B60AEB0E2803E75D9FAE20607932F02D381919499E64CA0E533BAC23F9632AA4B527BCC0199F911C623E5BD100586'
	$sHexData &= 'E08CB6D66B9E800C5E315D28180BB6D59CD4F8A2C2FC12EBB8D4B85224F36B9909F8E835C55305E847CBF288DCAE7058DAAF3CA0196CD42D387653F209F3010B5E432286541C20B6A82D29CC49223A924C54C38A025B0587B883E8422683E7F280001A041C2438BF2F30C124CD216F1212268C94079944A0E0DFF00018386B69821E4CC9F8657A8C923CCE7D51DA70935201948CC0874C1C06EBB12C92067EF811C50C3C410839FFACB87B99885208AFBEEC114F696A2065E9E6028E91095DB18F73A0D21CE08FD01620F4F4008514818F53CEF443E1E2830386381346884E0C6E49CC64E5F4F6D7A1D870004514886376401036F5D20BA9D150938C542E9A4804D0482680FCFC6409AFA965195125270988040AA46D1F0DEBA4202BE831777BC90100291E65830316281F75011A5EFFC904FFCDCBC26194D5A8D004D18BE71792487C645185DCDC6AA8261B5C59A8D8BE3B56264A8A281FF8810BA25AC3F8AC8284368A54787373E72D1FE726E3B8477101AD0813BD67D7B266EC208BFAE8D5738706CE2CE6B8D4F700C03F0BDA00FF6D7F6D8DB1BC94C6BC5C2C8BA3246021C5B6814DCCE4E8B95B7E1BCD48904388BB6380410080869E0A93C0C0C103A27746731941EC18BEB34FAA00D707C8E7A4C4148407C6F13206BD5F2CD943AC8799E775E808B443ACC0ED008D4B0DB84E70CD822E089AD03D7E0A985014004A980BB01A0CA6D0CE57D600C6D1CA7DF75242E0C0C284CA74E1D181C9E9C123D9AF176B78490DED74304D5ADBDDF4F14D3430CD14310C7C180CBC0AD7CEEBEE67CA8FEA481D8CC0E7BD446723B656446460E83C7B98B5A8249E9A329C5D0215F5771C0E219C0EE49461E6AA3D24D34F903FB245089D68E281CDA6868B8AD294FFFC059ADB581AFAD6BE0996010E8E12C5C01AA34F11F1A0D08660C2E070B028F1749C701F2A4DBB2EF40142D22172D439280BD9A5BF34D8AC9B53B145AF4A02E9DCB680772C9D3D3CB5B426785C6344D049A78929E3BE22D724CD3A48D3D3790592B87B4CF1D2DDBDE17876F5BD5640267E1E35949D568A12DB948655BD9C085C3C1872E1348C19EEACBCFD6586428C817EBBF8D548901EEE93FFF85A404824C305E8460920337662470B5726B7EAA3804384517962EDF7BC849F661E0A3CB75153D19C0EDA668087ADFE772DA64F573281D8CBC049F56CE1635A03F1BB8570933F572DD253C0D980C61690636B09B22FD7337A721DB1D0C1D8C20461FD793FEF7906E888A6C72C94D3BF4763D8E4DA0069641CD7FD50C3B48C7991CFD3BDDED09EE551BF8F5A472C67C2A16A67DC29080DC5A2AE7A2BA44D1EBE691F70DECD701B587F6EB45DC46D0F06C4953E9DE7533B959C3D3C86E22EBDEEE2CCD7C52E36494C41E10C1'
	$sHexData &= 'DB4CB6D88770D018E0832ECD3DB0E626B43318020713DE7DD22F222C66537FAD730B390120F34C756155C99A86FF200F404E41C599C00B80E251ED717F08400EC9F58CDA8487E5046B204169851E001262730E6049E2E9BB9068D0C0DC10716083D4D380AC29C0F1AC14B4AAF258D47D5FD304BD0534C65B888311ADDED66098C0F95C29D55508126A76370C4C03F3381A607600E334F059CB05C4CCD0F61E042FD4042B3F2FD4AF058D48F6482B28A67C9CB4D1CB93BDBB3D94B6A52D4439486A4091543ABB773CB18AA656C059AE37D693BD609700D8054397387D598DA617367FFF5ED732AE88319AD51A7A8420E2A8415BF0A6D0E12F704BC7B0BCE782A4CECFBE2FDDB42EB87E0EF3BA2F3BE37C735B5008DE072D5D572C8327CFCB2B472813E8C2422E9278BF2149233432B90B237974BFE2BF2C3878C1B7A6B640BE2C40E84295A1AA05D836A9BC905ECF24F7CCCC4E5DD826CC2DCFF7CCE45BC957241E492BF69DD361B403B9D3CB5B70C18573CE94D4CE0B2EDC59ACA0CF079003C8F7CCF7CCF7CCDA4A1E21F7CC6527BA30DA5BCFF7CC38480E20F7CCF75CC8005DBF30D0122543803001E9C20DE088BE30F2400692D030F7CC90A59057E4BAED249354BABE30D0309EBCA439F7CC30F7CCE3AC85C59641303DC04323D5BF8F1010C634E06CA8219F973C1EA96D8B4927CC750929E439C03F48ED04DE793619A1AFAC6D5501DFE13856726D253F30366155325FDA7F6A46CD844168CF2090D0625997387532357C00184A0F65F6EE1101C07E375F5095F0B7BA845816607B9A7BC276A4978B0B637D0A817BBBBBE45F8912C74348346F018005F005C0BFF151E6F9806A3F338077007410D5196CACEB2D80E67203817F0E27807F4780F42695475753D0A9D0BC8C473807C4855856F37612E32890AA600C9B3D059EFF462690D1280C8F2F9CCC496638390EB2D5F60C66F7AD3EAFC948C9152E686786957C3E03BF60324873C81F6950D9205238404ED57A40C8E679B84B40BE48CF3A7A4006791E037C7F472001F072E87B4801974819AC6CEFB19A93062BBD4A0340CBA0D34E4E4840D200712469B56F150A26C20A33F760FD0A6193B0DFBFA642D8EAF1D5E8A7C77CD2011A7D7920E9177F5103185D9FE55C5CD2BD59748B292217B10997115401A31201952298AA8429CC5FC348101C747A575A72705567564A46A84838884E23312417C13DC8404269A5A45BFBB030F1353C0FBDC83784B1899D48D3E0BCFC68E3035482B3D8F4770064E250FA42FF534C41A17BB60BC76028E163AA7D6DFFC166E70D143F4FDBAC0861527E386247460028468630D10ED1802BE3C5C05AEAF825D0130891C72D499CE8E1800B0FB6413E08C712C21FF8124D33C74CCE969249A63D2'
	$sHexData &= '0121513144C2699641516170141F03D9618152328C2D64CDCC64E8B0CD03C0E8D1C4114A19B62CB9A8982537708EA54EB7549840F43DB88EE2A4010AEB736127E10D17421DA3E110C42084D3D0A67E78910496012744AEA08D4F71441087938680F5EFB762BD27B74501C75F166513A12DE3BCDD30C4A01406C4806520334BCF37C4164CA3ED34F644C4961E9ECBF6C4CE31348A5E5785430E81BC31A11EBB392CFAB12BFD5B12776A7A3931115501D4C8B3A2E0D9DE9DF19F880CEEF757FE77525037ACBFA23F80AF72E70220A6D08BB6172141E0239CFD22E364614B699D3E338FC7CF9F0A1421B49895D43FF49EAA3A7087D7D423FF8F80A273C75ED9FAF9C8C3443EFCD29209C0209C00DB441FFD25FC88E02692C5AD0579097C6420B067604A24F047169E18D0C12BCD0CD700AF8741D5F42013A0A4E2E484D04302EFA82F037A0EF037D1849392F75D3683FEF8E3F49897FED7F49C60881DD34866F48F7839584EC32DD0950ADF23B0D6B164D85D20DB0C2548F751A719D03D345211680A65758323AE3B3898B6E01AF3879C3786A900C565FF6342ED8F7EB7C121F7453CEFBF7536CA47228207606FD8A8D4A41EB088DC0754D5BFB2673A475ADFD0C194348C32577FD48894B3FE14A512A94BE194CF583180CC2EC1C1FE4047494556A48DB90F14059DF705D857854F0ECDFEB907F10A6D91845F9C6261817F066AD5C98C012CEC63C81070C21C41C2BA299F855CA27C07643F319EFD1C014CB49464EE02AB503AF2B85239E721C5FC92553041F1FD5DE2863457F7455EC8887262875444B7472F91C98044D3D747B4CA7B4472C573621D989B3238462D9B9241B9C4438394FFFE5C500527FD29C631056C928BF14421EC803B1C8011C40C00ADF3AD984092C8C4D7BF18D0CFD1631ED562218B9640F8D4646A664DFDFE7EF1A5FA5D9467018F6463075B786CEDB84D2D7285943494568D79200F878A6E2394A190DB795900FB608CE703299C080EEC803178D81008605D4501301886DB237DBC00B70492B57405B46851F88242BF22D9C6D20111958209A3D28DA58067F0784A1A0C2BE55802B196D7CFFC8FE6005FB36D5BE69BD66EB7D3CC7EB201C5FBCF706077A07EF63674DFFF20F0CF742FFE087320A565689884001909F2F0526884801C874146E00C71A0371381CEBE08A02A283E7FD26FF476F79BD015F091EC796C6C1069EEF400C000D0D0E89ED149D5F33D20431223EB98010160D6AB58AEECBDCA109B300006807103406F3549E56D2421686612D5F7B270E105A5BB2471A4F1C3898A184120E899C90B1A975C0C0D87726F095283B9BAC615D4D3F708AB184C96774E45D1917D2C5D0D2448B31AE696E1867000C367902CFD68B79CE717BCA91286F15E838'
	$sHexData &= 'B97CB18430A140488B482224B0C60F56C2084DB01D36248C7D115128762C1B0241899E6604A008421B0C0808E37DE6690C0CDAC21814107C5BC36D5738F677FA5EDBD04F0E8937346F6E77687F0C01CB100BB9381E22B026058D421B189C00DCCDE410D4B49FF57D4E208F80E16E01AB562507429BA9924750051FF7BD79801C02A16C01A74680BC0233A84B4EA8051C855C58403860A4391AB6C0B8AD4F7B2DC90D98D229F2F130A39AC2C93840EB80A7BDC0462833029CC206B335D4A82554C24B4DAC2DBCE8B60C1566E92792101EB0C2A1E301C082611364835549FFA38A570A6402B1458CD4588751F38D59B20EC84B6CF366C068896AB983584BB56D378E462647F7A33AECB40400EF3870144AACDD30FBF99DEE3D0B0C4FEA5443E6F316396287407D31688DDC4429535625DA80180CA71214215AB50D7CF0605F6E4258955D3F278513276FA3FC804B10FA050427C64138B6ADA97838DA4039047908D0B36979A7B661C5436806780684EFB78388617B580660C78168B07297553250CE48735B73BB9C3D0CA0A8CF6F64F666B00DC0D03783E088E1D27A40696618F0F28C91764CA97CECF83C2A12076FBFAA559017329438E0660A39853CA9688D68C92113F29068D9281EC92BE40669516676668A50C94134668EFC247414B579307AA4E4E2BD50CB20180620CE28E279933CCB675006607091439AE7C840488038D241109684AD4823978A15C8C8D0D89091412EDAD4E0106084903FC293088C2C6B60B8C32061FE357D18C59B6D104C23361E2C0561590058D0A630F03928321FD75B9C8B906363505007DD8A64C114B9444520C9405F99005AC928FF480F23C9013963FF3C50E180FE94A0EE5CB8251F093F303AB529A00D42FF6CFF607F6983232A11848A1210D812F2827C0133DC0AF99F31A7DEC23204719A205603ABC840E748F59C5F04155CF0F90FB6DA3790D0DB302A4252A228DF82E500597E19558D7939321084FFBCC95EAB00E020529B423E580D01FF89A02B8AD7A6EC7F095A7F3F9A42C8B66CAC0C5F0295D66008513F651D2A680D01C27C21859DF8FB51071CDBF22A113FD86DA5B3A44B84C6077C9F9F28C0A6E63485A93C9F430581E4759F3F5C406335131FF418B8DA8BF71930BA5780233D230B718C0284E706C6B80B45FBB4E01168014B383B6A1ADA43CB6B7B4718580DE272AF1AB9C349E813473100061641C029BCED236889476C81C638253116F880FA1E630E4A018D2F816D1E614158BE266016F0450312EC8AC0B34154F0250827C78FEC53C86C3971AF1382B1629412F20524E082C0C64E4DEBD0DF06940F4606D79CC9C039B6F69B5B308AC0386AF9C501E3D2761F07E58E3C208A5F02FBDB9F4EC82B406E616E5F3954F2485361016'
	$sHexData &= '1C92B1922E7AB609C82E4146F9E04ABC82B408E7B99BE5F54F2484EBE5DA35F941C2239515FEF9F11728AE4FB5EBF9C4001858056D8B2D152215D0E426618CFF3311E30309FA8268109D9D5C2071CC01F02016CD2565048A17FC10E772EE6CF8C1293E4D456C820FF031C9207F2887798031CE411C90104CC679D4C58250F04CCFFB6480AC8977B3F87E4803CF599080C359C04BEB0627FE05C82C7152C795F792F0E5CC05E77FE59EBC75BB89101797F47AB3701D9AF69EB7407C70E019CF6743DD4C38CE720CF1203C1FF02054C6C1626B71F7C5E994E643AF19001E70CBF95E4946C2B7E094CE5AC2D39919CA199C9512EE157F25E5198486341FCA4E924A77DB4585C1756FC578CC09C909ED741B9047D03FE80B182D7368D5111D60B4285BE58E54512372F189F148BC875080474353D48FA372D740583F925752B2F3C4DE72C877938CB03206973D9C95708D7571B53BA4AE797C6F06D3C0AC058F0880038E81F05C24181E2FE82F0800F6DE3808D26CD843C234989580060A10E8D43A84BE8F6B34F00CE8027C8458953E0C484B5099C6407D2F2E0E1E7F9FF7482D456F744999D34025C133E2B433F1D30B2B9E9FD06038DD344E6802BC168EB09B094C15E4DBB247CC857A86810974691D6538F50FCB41C83060C00BC046181F74FC814D86F0D3DADBD9CC24462D080F2C84F9D820D778BE918DF74875FE40C2BC15622443DECF8B570D1C0754893C2CF2B2027D4173087C49C8937A528FE5D7BA44DD290960C1A7844EB08643484BBD044FF38D17A4B6973680611B8BE0950415E8F5E5C363599D9A4E3550F9058017DDAC1E18E5A3C3BBA1ABFB70DBC5AC0185E234183C9F81B580195990C4419B81F34A1F65C100F44C7811D9D90700A901247422A9B61EF9AD1A1715312C08FB42A861CE4406F5C554A5A12AF021197623AFF3D41AD2FA18A840A504139A46C2513D651C22E1063BB73747037CEBE01EB89031E042B43D1A206168785D3242B6191CB8639A738EEEE5420A42697CB005524240EA828BDABC3AF50C89747861BB0D043010480FFE3A0016D418AD880E3019F04BA20FE4AFBA93C29A143AC104E7F52830D3E578B0F2E83B005E0F1C8FF41BCA74F154441330C058C66CC820E05203058F26A5AF7DE81D24A103E562C442A13E536956E0DAF4D0D080F8523EDB2E1615DAA6A0F5450122DB0B86B3818203ECED141EB470841D653195AB07DA1750B160A540DA8A526D84DB453EB64965E19758BD66C4410AE78EB1243DD13E5170044433C783D783B6022C14523C4A80545AF14140820645ED5F2C94AFD130C3BD148B9000F54C210506656EAA17BF6663C2E14065F0D130D415B216E46146CFBC545038B9E3A56E236F101938876283B12C1B8304219F8'
	$sHexData &= '41C1E11549B2E0C7397848BF0EE4BC52DE69C19F816C8BC39FB6C2266B8387EE2B0EB7418347E3B40F3BAF18534D291206CDC75AD2F254EECB6DDA3E7090529B57DEC7A360E050B09C52DD0DD4B40BC7C18A81180A47BE0836D1409A0A1FB68DC8E5906D22C2A452B20B7E782CCDA539E20CEB07C70DDAC1C108671EA018F784469A91EEF97453AB28E9602AFC1E0C694EC742B3B1510DCEE63E158521BADB567130CD602D35E740870C18DF832600A6401D0D697C640F4A2F7440A9A0016B18200FB00261D06B37C83C516AE1B832DBB406D111082F2AC0927282F1D03790D0D1D0BEF4F7034ED533CAAB20034E8D4707EC0E3E60D509608BAE6951C97563B1BCF1696FFC34B0BA9828EF7000963BD94A40F0D5358F65E031D62002011E34F087388533F65B1E8036E23B40B7585DB860E1012D137110131307FF0F3F65D350317FC645B0018975B4E50E02509F4CEB3934C909C97CD911C9B9CDB829F8F7EE99408AFECD72A0408875B018B418E410993E5B0E5011312098D8BEB28FC22A0B58EF38003312017B78DCAEC266D46662506316083174110647DB2A58740CB73A102950AEEC1236E8B182FF14800774DF80DA8D78238B031144E404CAC85BB8D3DCE51E502F7D1A0888BAC9CBE18D109E6A4F20E7DEAE2C48945445E8A8FC7383F00193A014FC6E6A6AE897AC5B74AE090218BCE1750965EBA613CA189C5BD84DE86D677803FC800D37131EF4B405271127F02ABF13336E4F1D10DFEB0B6E6E9F328C1E08017419327414DEFC85680B82E83B740A83E826F86A7502B60F0590264D258682DC531C54382265F7209653F301E24040C5D352D202A41024686EB0F16E85DBBAB909042E80A207094026224B878486A303C687E0B260B50D2A5CDEFC4E37D849013F2460EB082D60112E57E030C553CD030F87DA3EA47970BBD1AD25A44E13C3B8037C8E9EED7FDB30E68A160FB64C02FFC2050B805D84CD0442803CDE27EAE8813EC875E7ED99D318B3A0CF2057115F0F694E2625AB50D72B2C2D207237DE3E36A656ACE7702A64600D9C6800367BE2BF7105297901DF895A151BD05264E81A422061F74BC43BEF414DA80F7AD26F5100787B9E04F85380D86A2303D109657D40DA193F197F6409DC3817C8752B63A5FD1B4C3075EC83E00F46D01490793F502904A940750C3C0269559450EDFF2B02D82DFFF1279B304958E0DE603C0085264C331E9C28F16FBFC727F9A804AF14E9A820742564FA30761F84E202189E0877105618FF07CC0EAE0F97C103C9EB24A5F766CFE1101B3040FE0876130A500375229EE8FB2E42890B41384E4A23687C7F255502135C84C0B7DC20B71FDFF902191CE215504E01756B707D1A78745C593C0860B7F4282940E51451E677648AB3A'
	$sHexData &= 'F69A0FE07FEC64405482084762DE075EF65924648E1A1B05F445FFE9FC845430228CE2E4D803E1253A77C483052E2EB6A3207ECC7FF169CEB67D114C390F880E4FA741AF2DED461D2BE92735BE8C1E4327BB4DED71FDF7313D70C482B65A0E6C108283D0F43D1DBFAAE4BF2580199D282940C5F2509DC1CD49208740BC5C5E2D37DF2EBBE3FB2EBDEBE6A71450866E63AEB66B6D85076D1F2E2E069164C0F44008E5B8ABFC04CA2534500DFC8D8C5E161DB60DB25B83E786518DB015FC5E5CE8AC0579750C1DE575D44A3E0B59CEBB01C7426001FD40694BE7824C169095F459610C4E26D8C7955047090CB94D262C2464302F825490368134508398D16FFC0452741BE2E17F103B4E846B0428ABCC0560D76DC5A031849B4F074CEB274CA314D4650061B3C94C2A1B484C8C790F38DDE515ABDC0C20BE949A427773FE7EB99868399F01686A85F58C059887CB6B683398003137F69124CE2F5A28346833C09F80F013A5A21C02949D5B30C38A2D40E5DB641B4BB84F202178354C06CBC562B613CEA0AC2A17AE223661F43F0DF86E8785642BA5E2A3A61F07172FF9B04BE1F4475E3B50218E449D18E96F082EED0FD107219928A0C05162A2788D2637511C5224CEBBEE91BCF00E042EB2CEBA0CC0C136CD144A87737CA5414A55890685D57059FD54427EEE6F07AE7FAF75B81838445BF47E42B0EBE41EF06FD3448271F9C252D075E5B675FF7F3126BBE60E3316A84FEBC6FD5C4742B9F5F095505EF9D39F15C57CB310F5454CEBE45B405B601DA1141F2F334F3893185EF467ED0B0C8872AB8F83C751588301720131C5CA4E0613910072362C3BC750B382A3F4C0F0A1EB482606114BC53F9FE75E20F875DBA9501D0D18FD203406C17086A1698EB0723D4051108BD78400121A419BA589223B3D0BF57FDF21C2B0D780BC5244978FABC0817A01A5C8ED0FB80075042202872581CE07C0AE32DBCA40E359404E0BFC9AFCC7D33645FF0C5F1EFC9BBD9A4FACEC5DD62E876D972D40536DFFCD5767536D222DFC61647D0C5EDDBFC50C135FFFEEF1D090A7D8855AF73BC83E307747F63085512CE1B99EDBA87D50000B1B76DDB0546B6DBEEDFEBFDDBCDC5D5DF051A17E9EFB0F576E2A672D5195FDDFECC6D365D200A6547C8D6D48BCB6FF87F1B19D3E0D8D2F7D2FFC823D07421ECBDC2B91FDD67023818EB19C2DE1304DA2214C945431FEB0AB0C1701B9F308A2D4D30F0B1375F5B9F14C1455C7C48425025B4E484BE35D201FC9242516B14774F7E3C80377A44C81B9410D1408A7F245290CA385DA041D71D96123883E23FE4187AF08007D7F9CC003212CA23DCDF56CEF30EEDEB80DF75CDE983A4912E500752E2016B4267031D66BE0391C1D3B880D4FF319CCF88D47CB30E'
	$sHexData &= '85E03E57BA0614D817A07DD7D04560837BAFF210C0203AC818D96B0940F77C9E30C94D40D1110030F73F1AC4C1C4C37922C2010BD4DFC100161A25E36922D101DE99CD760BD2023216D0033E0A6DE986C100DACA00C6180E0979EED1694229E6201F4C4EC886C2F8005C34AD37011C8113550C2B040FA20156E99DB70FF8308E202C1D956C1DAE7268F1010095CB4D51393A8BE2A203400514D0C2C75CE4B2E73FD8610FD279407C750FE2F14181E68CEE3E59BA74745C2A5245FCA30A4255DFF3450FBCFEC4004E191642AAEB6DD29BBADC720646066103E9BD544D3BC57252D668C17358620FBF8FCC14E07F51DBE317C2191D859ACF634433F0759EBD46115E2AAAFC101C336F0BEDA0CC7580FECEFF9010F6AEBD825C5C1CC7BE90D7C5F8052F46794DF179554D2BFDEDD614EC1EF3445EF6C6A2C7773F9A45B8B0B64860243832C484BF2E3DC206868B4180EF9814DCC0983D0B744334CE059C373832B41860C6D3692283B7FDF8DCEE6F214BC6EBD50E66C4EBCDADC1B301421053CAFAE50EAE1D1604420895E1FC4CC1459A1F0589494228B4167F86DFD6069B169A77390AEF0B39C975A493A41D3645E09856810B1A2A2089C4AE2AAE6C3808966F79B7AD4B37037C3593FEEB9348DE0A54D8731D623F45210D59856822F131C6150138EA958F30869C3AECCA1FF76520718949FA0E6CF640E16D05159C27E1F445D22F198B2B2834D6158CAC09C5D1314E7BC558824CE0BCDE526AC3E1501646804E8FD1FDA0CE951BBC8DE39720D80ADFBD0C3A106213FEDF1F7303F7C2D1C003D1EFBD2634A6F1942BEFD5D2BB55E820902CF0FFAC2B6CC203014E0D103EC2BF06C310EB0FA68D1C431619788D828EBA409076D36D7057A0C1F0409EF0AAF0187AC9B0D1EEE7DF99C8D26A9573768904A20B38E143EB7058CCFBA1CB6A9016DE2BA2F983A5C2519F0395FFC08213AD360607846EDC3D4E772B510F57C676173534E8028E4C7E64C050B8A04EAF694FD6E833AF5476AC06A70887471937DE9D9829E1F3CB684136E1E020987C2BD2C2022FB1B8814DDA74C25CEA0375F83FE38D1D0E00044A6639044B750D2C55789361BCED761ACF0EE89EDBDA75D4D5893D18CA014CBC1F99064EC8159C1E3CCBE5D2AC1E41B20AF7F9FB5C2A2F97FDFF01420305029F00F0CC2460115BFA74410DF36B01C191C037A80341E31D7A6E600201742C3FE001CC5A0CC82147443D1A47B0D023194B03CEA9866C03108A461E7C08296D0BE4E901B524FBBA7F0DF92EEA92836D857EC1C11066F7C15201C316C910B04E0BE9D02DD4B7287977A1CFF86A223F16846824E54F60E8FD8B153B6B30C08E28896D0B9C820383B9146704D05E5459661B3830661BA7BB66EA3E0073A3F9DD6562EFB'
	$sHexData &= '724CCD78CB630D7803E28A225D700CFA6D2EB450E38156F416E9FCB33AA4E5C86EBD652FF74DEA4E11AC6FB9CA4368A14577015C07E2D1E0610FA4E69E7922D59F75285A407241BF4B167BD0EDF17EEC7E76129A567C3DE062A2E6AF7E1F7BD6E161F284821FF30E74808045E130E0A6633C00CE0E1CDAAB10DC869D0EE5981994FCFB001EBF777C22CD1FD322B38EB191F20258E02B66B0FB462EB35300666B34886301F0E4C24284CC26959959F9730388AD6DA0BEB6912197BB0EC7FC000B6F723092942BA01ACB741824F1C0BCB50E94D72B61EF575166E11010488D548EDC7DE7C3C80197358AAF755868E41E1FD456120782FFAD7109EDB932B6AC868013018BA0012AC05EC60050D2924CF494DF7370037382774C605817A410682870163E714123182B70973EBEAC104DC71A7F73D48723CD975672E08C195206A232ADB7524F29ADD7932890C85101E3A5734F04E742EC233A47525313A13500204E9AEC86005018DF80A0C1D0A0767C1191348DD6701A233101E7225DD3457E04FE357A6B84D5A5039053510D67DD3CBFDF07848630D6810EECDF8DD5E0D03CA81395045785FB80B024D820485F141187554F0693B0728FE14C218144106B281764C4E4C06CAE6BF183A444918188B4A0C4C3BC1720AC5EF058D03F272085A28EBDF5E8EBA9FE185D24B837A24007D130A0E0687337CF40E022D18C3478AD92B87C042B260E04A48390C3BF587150A67718FFF660F4D08D8548EAA0CD9B84161C78ACBA5BF440FE0BE833DDA58361937F2A1D31ECDD3BAC46612D76684A90C7A26D07914DB7FC75F259C48F7D81BC006FFC891B67E408F99E8F725F0911CC8AB273F6918A6E001A2C783FA03868584A9C0457A0D716603BD0130009FB134A61BC215122A54378B1F1598011FAA44DF10E716B083534FA5F0EB0179EB1208116B189BE02F3CBA1C2EDCC26035BDCD1123BEC6AB16045FF615E96501E0D30804F013FA41BE13E530B11B42647CFBD7235810BBCD03DE49C436893BEB2FA6BBF102FE1E7528B943EE0071F4220518D85A055AEB6828089BF6043639CB0CFDB0598863C710C310FF3261113C9E43DC192B72188B0FDC332454F039FC28090B471CBA02FABCD923803B01BEC82330D60D080FB67D9590481F106927B04D37F0E609BD1D28C82F06163C68B1E7F1B3BE7A7D6923ECFB28A28041F8A11C808AD8883A9F713B5490887D64E65228BAD6DD36EEC7056D186FF01A35A4A10E713471EC6F0F7CE51376150640D7F73F4BEFE99EC030301A5DBC203EC6E76927973F772AA818021D81FAE84032FF99254CE63F92E00CCBA17652F906B29C1A248A24B45C5BC0D588C6DDBAFFB64BA0031A0D029841FFD1FF0519949B8574837DD718A46B0DB7220790FB07'
	$sHexData &= '4E1B97408AF98B05D963783B6D607985C07F0D7F0DF760026CC03033D7E1B7287C3D662002753675A89B81BBE641FC982F704B2E0193E8299869C4AE4B701514A2AB48D859D8F0A307B1920AD19027C2401869A8A1A5AE046F090F4C19400C280B41EF4F500F39153CB47F87A0008574022A66D8050E8F3582ACCC65A28C954035ACA4EBB8F40056029A3DD87E0E201C3EEF2A5C60950FC9F33E32603444C00119BC78870222FA369E32501B611EDF37B0EC48FBF8A0E899E658740E4748B43A2DEC7D60E8C8C103B6B8753CE374255A1E8614840D104F6A3E5EAEDA06F6DB0F80B034E694F140BD913054580FF8ADD46B849330832EE8C73361154E35F111291D004D854C574DFDCA2E4D9F5200622AD49F3E43FAFFD67CD104DA418B0883E1F841F600047415171D533A940EF70863D04DA09BD1FE03CA4C23CAEB0384CAA84A8B1409E7C223D810E20C103EC557B201030F7412C80EB9F0D8108AB839B8196D241D4EC2AE66E968A4D9D064777F00084381108B81F16E74FAFFE0FF656C81F2696E65490BD18B3C2D1E0081F347656E750BD353FA9B9ABA428BF9755E25F03F9E1A67873ECC0425FA1401EFB22F71523DC00610583D600602D0C7576E0C213D701A05B0F9FC50202FC9AA91B6B97525252E90F5A3C1737405EF60A770DE57B40144BEE414EB0726DB9789962077D950DE41026C7C4212C2F6F2D179DEDF36D30FBAE309730B6202B20253E005EB7C0DA540FA67BF123644CAB8C63BE87C0F701F243C0040DB10D1E0115E88E2F0652498E0FEB0AC4AB0623F2411F4392469EFEDAE784614C0E714731F48EF341A779E76262B200D064801081F801B122DBCCB73A4D669CB341C0210BC84A0CB156C36D7C5851DFAD323B2E0740815D74EB390C02303B0BE12D2C2E7F234ED2074623020A705A59A11100802A272ADEF0E0E7E4423D12AFD169F1B3BD175377B3FEF7FC322C23AC275254888830D6D0A40500E2778DADB965B067D6C23B71CED1B7C486323C5E617730C480CF0024C7B530A005116E113734E9F43B28093DB153831006013BD7573CBA20681E1FF229A0D292F52AF409C0D3928803FDB82F73A23D088150C80F901769EFD4D9930A215FC22A915731589FBDA5BD8E0C0090C35E034D3D4000D0728C36C4B10A105B10938B9027DC3BE90AB417EB161008E61005AA7254CC772A524344FDCC20FED0070B77B5AB150CC39057CE802BA9F949C8BC9B8663387B03FBB30EC2182F583FEBB32A2DF2D992B3AC37577F90C9C36AAFE45B8EB31B3EB21D81AFE5005322C2DBB827A3117D931B2DECA4C9A1FD1451820F0B0695720BAF2331606F0C14869EF65926192231833DBC0E0A21102C114660B81F30E6F32AE1C974845306BFC645AD9E79D0D12346'
	$sHexData &= '85A311EC96A9CED1124E21605CDBF0E3F9342CE83082405E8FC72BD081002B34609600059D9A170EDA2E7A0E0A05B32C8033838727779212307BBB4FC37696641026E8A350A3C2E97CB774E17585A5C0E79A9BC5C00F234049E354BE5E552888A2436FE72F92E9710FAB40BD6C882C3CBE5BACCDE3577F01125041007498B59688D602938FC83AC0961A25316B0403504FC045917E08FAFB0042466F6D8B5451B30F7D944A90725FC03C844854B04221C0788117EBBAC2E052946B9BCF3E5E55279F90BEFF135E3D5E90495CEC77FFFE005641B54BF787236B7227DA2F88A8EE9705C1F80D806512F0141F08A4017BB1DF9585F8D8A280FDC1F30470D76723B3E4C1F207C5F7D2047A61F3030EC001C6CFC84F90D5F5401EAA751086471DB206AA5BB6A3B533D288B5D56854E297723DCFE1F328095CE6A3E9F1AF6633700214C902B5CD5E1526809F534F0C815AC35FF501BFC40E3CC044213134D40C43B1C7CB91B902B96C7F0CC428351001B6CDA5B1AFF2D294CE129450886876D275F370B701431EE8475357E5B7343D920A965EC4C9D0D1813632EE95520035BBA35552F3BBD2830607802C85991498ECC5F401CBC40630B9B902820519990B7E4E1296E281CD08642C6589FEAE0588249469683D2B0BDA280FEA51CECB1AA78F0360C766CC9F3179C18DCC53B9DC7334B2F25279083492D212DC941E8580DEC80B4E48D61572E28220AF2DE67957C2E381F0880917737AC4E38372587875C43477070FEF8C9C41EDE60E867474B02172C58C8FD5F4708B4B784B60C174CFF1F904B6ECB485F6060BC0501B960CF17991E72157F2020FED9021CC5002EC7686B840224B948877221971C7E303030D8D60E46277F9F6D51482E5F205D7FBCD02E4E002D27679E78E4926B97E017C0A0EC5B8BBC0001B71798CFE79960087F021839A771B6FD8C8D407A6B0CC2D568AE2B53C1D7854C2489A8BD2E3926F66D23B4551C9D089DA96225CF20F728692EB960604BCCFF88683EC925D71748280DC9550161E43D03AD01333C1EB9183028AC41ED3F0496051A2301CFBC250F11B98D4D68AB0F8F6B298A5B55409CA802DA62514516B5CBE2FB822785A8D9BD8F01DCF628E6F04B14B32883B1681FB634129AB42ABD56FBE0E9DA408CB70F96DD66DC5B780CE676025C3086C8F8413445384607D28838EF929810416BF99685128DB884F0666F7EB94F85FDE014BC5CBB595990CC8D2E61115F6191A92370BF9715C84B1EC74D7091EC2870004035797974297000D75051028EA99F6420B8E4B000650DB05C14BD9BED2E239F8D140DA281016070B85E209790B00131D3B0A8B09F068C8E545DC9F0784E0178FE2E79197910B08D271089B47B4618CD2E23C883ED217E4D6C1F526A1C9D'
	$sHexData &= '4BAE5DD017B030A2A5403E8C332C3B40B5A441DF58D7268A00D538EFBF209297494EDFA88526C3B47398100F2E23080F8C92730DB0256EDCAB02973C084068D7DA44316A89DF389FB160A1C0D73F03ACE4C0854800FEC64A4EC8895079504EF3C276DE87D7177AFCB60B6F230B2FFF47865C726D887720200A4E4B359FD736DC3F634203F3091417EC9F820449BA081F7C57FF7B41AEE9A86D60B7FF36A39B4D282F8217A01F523326F92EF80088BD3E835C11FF3C3C00021B72924B2400022E373275BD235F3C109C60E2329FF7C00165C0EC924BAE975898D82FDED925DD0317C00847029C5E70C185824BF0C79FCD18BBAD1F87823F472A00A81C108BA5B8D931E32F4DB8912DA94497867729B89CE152F1A433433230306B403B92A9F68CCCFFA8387B2900535B7F85BA1F84F6AE250410061E81A51CA42480DDB4EFFF1990931C22036A222009561EB272F222200970078B6CB787242F5AA0081117502FB96492013010E800F60AD86A778F200BA74BD2340AA208172339C96F5F5802F807AC8239664707510C377367031107A08F2ACC2FD743DB423BF0CCA72F47888CE4C1A208296600099A91AB52A6F3601060E44535501C556808941AA69DD807B11001A7B7254F3A4638172A2C82D62639C9F0067801105F54B4F6D88FE82FCD05B81CC820DF0A63E5212F79831F200A0B209C3CA4E4200A0C40BF477121F9F00622F7C0753C249008BF5725974C7B78051798B8495E72C9D8F818062FB9E4923858789806C7C0164CDF7705FF4B5ED104982FD801728269602F07F71001509D404E780298023FE492D34E3803EFF803020D2FB9B62FD8B803575860587203E7476B03BB162F58EF04772B5A459207EFE54BAE4D4C2D788FD86B810582F84FBF2F6081E3929818678F926B6B425B2F7885ADBDE438E008A72F22753211D910EF55844435C4E73F119E21D260556068398EAB5D58BB6DE7DA2507967E2AF0D0174B2EB9E4B0907025B9E4925030104B2EB9A4BE0303032AB0E4920300232D796DED05475FF00181AD0381D7BBEF2910AC03D307E4924BAE3BF070D0D30BA60BB09B9002FB4070C90470F0DF5D72C9B52FD030B0A1949C0A95100270E3A8555FC63F62C21370295FABB6C42850A7E617E3924B0E582878B605C874D7988735016605F0921ABB2C33D188FF8081610AD285DF306F493A944975402EE47214C055CC975820CBDB5E0E28430C1788404EFB82491F01D10C17908C2174D40AEFC5609DB0E80B8303CA4100BA04074F1854A8510690010790CB294F38012801D2E58609939CBED7D0B64007363717AE30F938778E19C14D0C27385F0B1C9FF02505214EDF36500DDD5A6C71BFF09283048B1F0F66504A2075E3205F3FC8401510372011BD911C30A'
	$sHexData &= '99F52AB528F903FE48A00F297FDFF30C8901CB930946C28C81B250716BE70B5129BE4CA2CE517A3970073EC57DB5DE2431A68360E7D607D6C2DE101C250493E033CADD93EB24814D370D322CBCBA6A69D6DE2869CC7BECF3C6B0B1F504C3A70B6D4BD3B94A21343ECD3D4957BC115A83B9C8246C2041B902BC9CC8E3470854C5969E03082452BA2DD08D63E5048C5091E155A43A2CF3F69746A55288111C9AB2AB0177FE58CC024573BC32C3F6CC292891B383B7F8C5774905A1F27DF01044EA4C9E8BC3D811C76DA5BE2854FFD2C47D41C175C72C9D5CC4028285630B080DF0C1F554DAE041728FF40DE4230123F5F842C6032523066482A2FA4AA6FB7DFF381817C40583F3E3C908489535875A16AE54C60C2139F125558D0969A9E9D01F89C59BFCD33D02E3940BF4040419E8C3423403F40FA7CE5E0D44ABF2058700107B045886BF901F11BFC9B40AA5A5A4A60E3C02078CC3F085C9FB12A7094EF5C5F473235E04F1F501EC38441A80CF5985D10580B9C2D90BBAA8D46377D537F39513CA43858082DAA124B1E0807A810414093910BF940FF1580103840DE28E80EE0BF011A81B8473178A29B00118ADA33E170DCE9D64C2DADB9FBC05FD2395F036723875923D830BF8B10601D080FE32E012B49BB7AABD5E2DB3770051A68E55C489004A38C05F59F04080FE91D2B1813111855ADDFE534CB104828D68B114B0AF7D916E4818DC01D7EC91639DECB2F232B5F5D3B310C1641C41740763F1FB1FF39723B38875FBFAD852CF202B9E4A191BD3A906F4B4EA13A3F25FF0000B6CFED09177C8DFE97649D3676FEFFE6D500B867695060D9177E5108A16127020C2A10714798140C4544A07840B1E0C8F260718968A5C1F88B151E39A5906FC33F67030CD0613EFE383990231970DE30E0E21C0B3FEB3DDB588F7B4440053A5EE2986A192F627E13B8301C08BD3410DF5C325CA8515C31CBB2C35409CE11BC0438888ACDF175B7510001B793EF214E3B030F3E281F1C969127270EFE3A684F6EB3D301C4391FD60FEEC05727272723A69076B49CDC4E6E4F5A440F280EE476DB9EF4568F5F9E0F8EE4E4E4E478685848727232F288559CA8BA79727272CEDEF6125639393919303E5060393939398096A2B439313C39C6DA566FC6413919791BE80F16424A6A393939398EB2BEEC9C9C8C3C1043303C529E9C9C9C6072C004444F4E4E464286C87C4146DE2667EF4E450F2E466E234F4E4EB4F634476C91272727B0FA6A48C9C89393A2E022496664E4C9C9AEF03C4A8893DBF6E4D81A4BAF0FA6C9C9C893E2404C84C8E4E464E40C4D5094D8727232F2164E3684D28C3C19792A4F805E413C4E469E9C1EF840DEAA4E4E4E4E88684C3227234F4E1AF43FD0AE912727277A1EE63E'
	$sHexData &= 'C8939393AC6620DC3DE4C9C9C99C580CC63C32F2E4647E36FC3BC2747B7272A47C9E418F45E476D744BFE25FDA0FC8E4E4E4E4B49E0A1CE4E4E4E428384454F6E4E4E462707E8A3AFF4E6E232744523A0F305A2727234FAA51C2DCF49393912700520A1CD9899DD82652CF94511F74534F0979BB90CA2A2F1A537621B793B4BE3FAC8E1FF636032EDE2FD60FE8573F6FB755273454AF6FA40F765427272723685080DC084E4E6E4F188CF69F4E6643410F522F4C568CBC9DDC0F606A2FA05210B99D9C9C82D4381FE84F2E763BF20F08DFBE0E5827234F660F04FA57F0FC79DB5E0CEFD64FAF0F0650393939191C3A505C393939397694AECA9C8C3C39E214512A369C9C9C9C4E6076BAD8473B170FF601011B100F694B4E3E0231002001DBC54EEC022FCE81022CA3400FDB6E27B7C0D1D0100F906FAE76D656B1016CBC0F26307F7B43DE80100112013F7F41B41507210078002D5CFFB7F3007300790E640065006600610075006C921F433BFF1E6C006F00630E652102030469B3EDED0506070D07000F0D061E01BBB70519010F0D047E212327B33F0202026DB720B31F010F040764E4E6CEFF0CFF7F03031939191903030303193999253F020202B705990D1F010F85C8C9C830FF040404B62D32C804041F0FE464E4E60DFF040404391919640404040439992D19047F03034E460619030303034E664946033F020241664346021F018C4CC16D0F42FF05052343B09D053BFF0505C821232705050532C8C8C9050505054C32723205050505838C9C8C0505050521232723050505C8C8C9C80505050532723232050505058C9CCC02FF0404042327238304040404C8C9C821040404723232C80404040472325B32047F03039C8C0C32030303039CCC928C033F020282CC868C021F014854A1DA0FE1FF914146AEFF060606E4909193060606061964E46406060606261939190606060641464E46060606909193910606060664E464E40606060619391919060606061939992DFF040404464E46060404040491939143040404E464649004040404E464B664047F0303391919640303030339992519033F020205990D19021F015C10A0B80F06FFFF052723838C05050505C9C821230505053232C8C8050505058C4C32720505050523838C9C05050505C821232705050532C8C8C9050505055632723205050523838CDCFF04040404C821232704040432C8C8C9040404045232723204040423838CDC7F030303036D24232703033F160BC9C802021F133D5CC30F0812180207980B339802940F0702E6C24213761F0F07020B2DD404183F1F0F5413980B07024A7FB0D0422D3F1F0F7F8327BA0702470F090A0B0C0D4BC896D80E0F1B1E00011BBB35E702077F3F7E3FB2B4C4421'
	$sHexData &= 'F1B0B2C5B5BCBFF7F1B3F1F6E6DB44B1A7F3F7E6B2FB1D03F1F1B0F6B6F2D04FFFF1BFFB5C5DE601F1BFF3FBBC442BB7E3F1F1AFF4BDBD6567F1B7F1FB796DA5BFF7F3F7E58C15A683F1F0B6D5B7228FF08091BFF2D2D6DB01F1B7F3FB6B5D06E7E3F1FF3DAB6960AFF7F1B7FB5D4DE5A1FFF7F3FBCC442BB7E3F1F1B6B6F6D15FFFF1BFFB5C5DE601F1BFF3FBBC442BB7E3F1F1AFF4BDBD6567F1B3F1FB796DA5BFF7F3F7E459658683F1F87FF2507E4000A0B0A0BB5B4B4B51F1B7F3FB0C442BB7E3F1F1BB46D2DB1FF7F1B7F6BA9BDB51FFF7F3F788985767E3F1F1BD6DEDAAAFFFF1BFFB628B6C11F1BFFFF5D62A1053F1F1AA56D6BABFF7F1B3F5B4BEDAD1FFF7F3F7E8A4B2CB43F1F1AFF696F050BFF1BFF2D146C6B1F77FF3F5962213902031F1B69DB5A68FF7F1B3FD6527B6B1FFF7F3FE0120BED7E3F1F1AD6DEDA80FFFF1BFFD642CBD61F77FF3FED120BED7E3F1F1AFF2DB15B5B7F1A7F1FDD5A6A6FFF7F3F7EA24262A13F1FC316B6A2C2FFFF1F0796B6B6977F3F02030B4B2C241F1BFF4BDBD6127F1B7F1FB796DA5BFF7F3F7E559658683F1F0FFF6CEDD656FF1AFF1F5AA80A4B1BFFFFDA25165A3F1F1AFF5ADAB6B67F1B3F1FBBB5D4DEFF7F3F7E3F50B8C4421F0BFF12722048FF080910AAC2D21F1BFF2CB1C556FF3F1F1B2C10A4AAFFFF7FA8CA124B1F1BFFB1D00241FF3F1FAD0D082E1AFFFF2A1B6CED1BFF1F1B165A60A1FFFF3F1FB7B6DA251AFF7F1AD4DE5A627F1FFF7FC442BBB53F7E3F1FA585A0B206FFFF5A6061811F1B7F3F5962A1DD7E3F1F1B69DB5A68FF7F1B3FD6527B6B1FFF7F3FE0120BED7E3F1F0F6B6F2D40FFFF1BFF0B15D9601F1BFFFF2EB1D0023F1F1A12BBB5D5FF7F1A7FADA5F6D61FFF7F3F852516DA7E3F1F0AFF1B6C2D01FF1F1BB45B4B2C7F3F7E3F969A4B2C1F13FF7FDE5A62B71A7F1FFF42BBB5D47F3F7E3F0520B0C41F0EFFB8546089FF1F7785165828FF7F3F62A966891F12FF3F2DD4DE5A1FFF7F3F6EFBD0121F100E0E0C020C0A07B4CD856D020A080F070208061FA86D2E2C0F070206043F3617165A1F0F07020402B4500BD57F3F1F856A2E2C0F070202FF5A5B850ABF1F38F4425C7F3F3F4835E8251FFF01D6160CBF1F7F065184DA7FFF9A6B3018FEF64604070204A1AA6A061F0BDBDCF6201C1C18021814070214100F075C58689B02100C1F0F07420BB517963F1F506D21C20F0F7F21420BB53F1FFF88458905CF18080BC19F8EE159BA85973F9F0FC1B9550BFF1F0B0416B6625F637F6D37D6219F0F3F86030221BF209E5A0327B010022A0737FF01061B4A2E00FF032ED0CED17F1F076303133168070FA807909F88B02F260402AA2467B797D007C00FA02FC2F8E4B0FF3F62616420616C6C6F63617469'
	$sHexData &= '6F6E7FC6006FEDFF87556E6B6E6F776E206578636570557F6FEFFEFF72726179206E6577206C656E6774682F737472691620746F6F366BAD69286F001876CC69562E6F69EF6BAFFD6067756D54744F1F206F750666228A08B3209C62103AB6B566E65A0EAE92634E7952656DDFF72130415616D54661696CCA7873B36FAE6368656475FE166865206F726521CFE0FF9A9F6869732066756E6367726ED706D7048AC46244E8602026D98199FF612064656661756C741A6C7554B5F607ED3074C66BBF726F6B6548700C6D60D6B6819026947475B6207A0881B9994012E80A606965761FFD706C0B514173AE736669B0B3838D41FC042692978C8C7BB32F5C023F06F7B77B07F7070B072200222C080164765820B0696240BC795F5E0A831DEDDD3A3A9B7573002A3F69C88E132C353B1244274F6F839F82B370132B2B1F55004E00432FF7FE27824F47004C004F004200410E5212C102C76B02543F3EDC7473B661EDF07C72656D6F76630CC05FDD856D230D1073772C6B6CF82038188B86E8691877D190D83C424900761369BD0A73214A200070D868126F7DCFAF9DA60A2A6D2267006566276D2DEF8DE3431F1A697A653B5A3BAF2E6F0A6C2A647B722E1BB4CBDE6D1363008F6F9CF70AAE740E846376651A6EFCBEF74896765663AB63526E0074045B82F778576B73B3DACDEE1D5336753A6F702A62657B57C3E13A400F7336615BBA7772E768FBA6D737700C0383F31E6393628F3D780A16DE61653B72ACF63EDC6A2A0776476FBD6977144B286A1F2922626A2BEAE14E74AB9CEFD6DE826554FF7E741F8E8937C07F5232732FBDF8DEFBFB745A69A667976F0F4CB887A98D87DF6D27A7375B2E765F1A6401553A5E8787E76B006E7777137257FBFE6736F6067D005B005D003C577B67E9E078757C1F64CF7EF774F0EF2A4106480045005F0A4D225316CBB8DB6B26522B265600320A04F7DA854F362E4F0F2A1FFBBE77705F534F0B53AF4C4A1B5C13DB441F2FE247BB0602EF41AE58E031BA1F8387374B1729062C03E3B79A684B3A1E73B39E7D78DB8B73F770373FF7786A876DDA364F3A2F762FF6DE49D1C265723A70DA739F98B68A037293432CCDDEA33BDF9A1B6E9BAF752D6FF41EC75FDBCA2E3DE7632D30DBCF726FBD1E83759B6D2F5F677E745BD35AB7AF4370FF17B6E4DEEDC13D17665B002701B0E2E06B525B0B0F000717580B8FB335308DD86CAF535FC256F4D6F3CF677F3B98DE9A535E68333ACF536CC915536F48A21EAF025649C64D62EC3DBD7890793B0013AF8F417129583F863F417040703A1F748F348DDD80B7738FCE5D059B669AC730E7BFBAB58122E33D2FF370681CC5E0AA4A2F59350CE4E906322F5FFBDEF6BE6F70663D433B072DDFA2C1265'
	$sHexData &= 'AC33D6F53340D89A53F135FAE7678F85B7343063F68AD61CB2E2B377F371D6C1589AF135F626852F1F09F6B2F2E3DEABD51A09B8E6A7522665BD8DABB5F73E67AAF5F01E598561F6FEE9F70C3D274DF6DC7791EBB5F65273C6C4F17010307F07E6CDB64674F9764DF968001AFD7788F014C138E69497F53134415E88406524CAF33423376EDF17B125BAE3600349E1632CA063BEFDDBD353231120A1620023A0FC0C507AE448E9E56BFE2FD80F9BE72D72D1F9ADEEB18B2BA477650176E59F706764E4E01434255AF74C2C38ECBC225C6D675D3562F277C06A384D97BF86F253A780B3F4D1AD32E5693B7374CAB9A0B535F74074327BAAE5D74937A222F5F4227D1E886DA5750A2EF53EE7A21D85337010B726F80131ED632270753653635FEFF7450726F63657373447069417761726E16436F39B185063E78743F50492D7130687D474B6282838A570F5CDB5F83ABD88BB61658DB00632390316601762D4F13FC05DB756E1A64653A645F6D61702F736A35022DD04B018FBFFA626F7C706F7369B22F5F7669FFD7C60C1A396F68617368206275636B5B98EC8D65DEDA8FE67175770A2DF6653C543EDD1FC8B00F7A323BF20194D080401F7E7EC0D9CB8302AF7E70B5D00F9D9D5CC8084030205FC850F2BB9D9D0FC7902FABE81FE0FF0012133B1976C70FA0306FC24BCEDEB6B8FF2F7E108F94A08FE09B7CFEB1B8BF98CFCAD0E4C89123D320C6F0C57072E4C8098190AE4805A078327B3200AC38FF56168090234F26CF3DACB8FD90C530B99DFD700F603F91F789E5CB784FAE394E71E4EC02AFC00F066001F07FB1E014132147D3B0AE0FED6D3BF20010600FF01FEF0B500FA505B7C9A0EFBF5FC5C9C9F66D0EFEE0B0A0EFD670C304A90F165F6990931DBFAA20E075A53154771F72AA323D400EF2FEB0C388BE7884DC70822FC1006F20478E9CE3A9681F9510835081E09D184E24B3386F2CE0539C68B80FF06FB6204FD489E4C89170C4F0C370C80939D1B9F8EFE4E0EFD0E442CE4ECB280F08B03099E805C52FB1184FFEAA93DB0BFE700F60201FF676BB2D8F582F4D1F4D305F6D7B32724B904A20911F3F93D9C9ED47600F50403F464227B7B7452F44C00F60101C232F7F8FC7601A20BC0FB1B709E4AD60AF4F08800F3B81DC70703F60AE709F9DD809390DA0BAA82F2BE09CE090674E8880FF58F0703BBB9D850F8B2F52D00F70763BE9D63F1F00970F9D3F1B6476E4A350404F4FA90F9CE87672AFB5FFA8BFEF90DCCE4E84AF481FC9900F50C815989C30AFA02347CE1EADF82F55F03B00B5DC268E27FF50BFFF9FFF862D640E4FFD1F108A809C88EFD27009936E55DDFFA02F0F90B613546F2F11402FB48081C8C9B9DE3F02B06FB808E0C309E4EC03A05FB778BF78'
	$sHexData &= '2F754C2E76800F70BF9B401E606FE8C4FF33E1840CA0BE500F601507322140B97FD7E4E4ECFE000FFDE0B01F2D76E405C7E8E5100F404E30BD8FE4F04FB3882767AF9AC25F08D41FB8F8C81372E4548FB6F82910BB607B5084F0AFC5600F6742F8305F6F12833A5409614D08586DDF9B9D84AFF00EA0762041067F4311DB824715430F6B44602304073D681330017DFF0738A4A11601404122E9EB8A035FEF2A926EA767880F986182A008AB7E9C4FC9C9C9ED900FA0A8B03D55ED88CE0102D050198EFC9D0FD9F01F038CC46838BD2DE00F905090710300D85D7149D71EB006BFF08AB6B5813FB917875713BBC5D121E8AE4F5009F64A9A6C0180CCF79B0704772BD8D3026F607B78CD0E6D113468174FA08B436CD26CD8D690CF6839417092D110864F10CF2C27D80940734F08C2B2D94C30DF77E8C320BAC8AB5D5B37029FE8C3B339C54EF8CFBF6072E0CA6C0EB149804F2097B0D4B3E045D2A870705E60CD9C405E49D0209190CA9D92ED84C0BB7E98BEF8B9D99E07ED2FFF009CC64E50BB946CDB2988D826C0C436E8C283551182C73FEFC3ADB6D800C74FEECF15DCE614108F38DAF62F0A59B07960BC78D236A8C0DAD71C5A9F4094886E38BC5FEC95149C40643E0348D9B777A9ED125740C1372370C502369B074C4FF083A0BCB8BC641A9E48D0CE02BF99A30BA60950D701979CE03A49C9D07B6F88BD366C4E31EF706210DBAE60BD4D109C48B0D7CF2030C5F0EBE6F0A6A0BD770A097602F97E90C228D6AFC74A9ACDC885B8C9F857013E56834F7F6F687ADA11739E20483F5E49B3BD786F4E48C670D88B38212718BFE0D4A06C39859C203FA0D2507D8201A4EACAAEE8D4AF249BCD29308DA0C620BFE803164806DE48BFE24A72A21FB0CC176DB50D18607E28B937EF00D26C5EC07EB8CEC0093920C2877FE021073FDA50D51E08FE60D97EC24D218B4EB0C30EF8CC091314AFCA115FA8909FC0BC2082023EAF50DA402690877062DBD3B128C0775E974C21034804C890E15580F7303E182F40D11C542CDF563678C6DFE8971C2058C6CF38C08CA6264C20B86FB0451B4C0EA6047FB8C12FE8C2EF12B68FE0C19F4E20873C38BBD030D7D23D12238FF61F083445F476044FF8D96F10D1E6E9554F40C4BECB88C50F62ABA213D8D02F010C70BCB016FF6005D32196074FC23922C4CA6FB8401E5D38FEC3CF786C70428A3D28D19F6682E0D59E3E889F40983F29AA137278C120D337AB1DB0AAB02F169F4E720A697ECA88CB408A14C52B6909C8BDEF3D53D1D7186F3F08F8A42B355DE6804FDED09C401AAC7F63C8D42325EF84D0C87ECF93138782D750C72E7EC48B2186FFC0EEC0D7E001F2684F609098D0032FCE898F48BA3670D40E31C4A81FC69ED0EEE8A02DDE4'
	$sHexData &= 'F767EBDAEC0AA79D14FF072283F96035C11D7039ED0152E99BAAF20A0BF3061A004DE5F09A6495EA8C47EAF054F48C8B8CE77FF6A549A13B89B20C6CF281E208F30D410D907211754271085DFCCED030E48C69E78C79FC304074EF0791FC84FF200D91488379FB88352C810BC3687D8F6A00E08C7CFA0D557B2E02480DA7E50DB9713F280481F40D6CC3CDD880B9F6705983AC955B00FCEE0807024130C1FC1980A948A8B4F8AFEC8DF82131C2F98CC8FD0CA2F442F79A60520C0BE0F1C11E312264F7C70916C162E90C090C9D47A4426B8AFC7FFCFE630B8428CFEFFCF90E3C08B38D26F90A163202730C82729645BA4D8EE38CDD610DA56C185430F565F6A788213A77EA8EF4438C5F448D02F90CDEF0E640279A073C980905313AE9E08DF50C039916C98BE7E68C048D7172F0E2407B0D3CEC11B4E201706D478D56E20C255984836B0D9013EE0A45080244729D936D76F90A8CDA6F0CB74E08A1AB7504F8A4D30E1B071FFC77F2439417470CA5FE0C628D40B22C770D02F80033D30CFC7FF3C401EF2A8DA108A68C470418D81B7C8880A27282F28D82F2B38C1F580C97FD8C32F3BD07488C34F2FD8D98FE431E004C0DA0F2095185C1409D7B8B6F28716449726E8D1026FAD8E55BFC78A1DF0AD9E500E4FB89266F3506C80CC78A0E0A061B596A61F0042EDBA55FF5EE73F244FC7236F038EBFCE401EA54EB8D5DFB89BB0420A392076299114A84E1ECFEC5AEDD3865F784F27C9491E144FA0CF907EC14E155A0FF0934F854F2D39F0D637D48B68C0FF97C08FC8843CA05F38C96F6882510770570452979A34569807675CEC80DFC6CF8A9F236422D6106F6868CDA069B681D05FDF25267915FFA0BF94DF130FE40188BC88D7B4A0C0808FA70CA79A0E27E7F0831FEA620016177CEF481E10EF50C9A86604A6ABED263F10D2FFC4CF7DC412A916EE50D23540A6262F6F204408BC1ECF1AE72AD456AF30E44103B0CEB8D2AF60CAFBD04303865EF87F72C0A557607B6F7880190F5A87CFD7EA44E4BD3FBE00CCD5801FA0208F6E3C7E88D3BFF072380F664CC49FF8BC956013851FC8FFACAE6FBD562E08EF64800A4F56DFCC6078C82378BBD8909F5985859CC8CBCE28CFC001F220E8D588998213143FC8D60F10A78BE90270D788FEE85A350227EFED508B6400D6024F10E1855CF838CAFF1124281ED0B9BF47A008870A270FD4208BE66058E7CF138D18EA48D36EEFCD62418D21C730C62A78E6EF0E0103CE418FF007A418F560BFBE1F78C809465F70BA608B39BA03292FEF50AE6871C9E7020280D1CDD18AB6551FFFF7CF2880ABE1608F30EFC5B5382EB91F9F6E9D20C6F08F10D8BFFC965B29865EE8D7A0C683065F78CB4F9C78933C58D6BA8EBF7F0182914686AF82E3'
	$sHexData &= '63C990C0F72FB54A1168587F8625DF22785FB0D79F8B8B1AAB629FB7F2EAD60B069FD0C9E1881013CF5F10C64BDD38F64F3F032A9CE04FF06E3F327403CA70D3EF083576E84470D69F5F7274E25138D97F088EC081448F4F0F836ABC60D85F3F9C607815F7207BDFF0D349218E84C7AC44AD8BE70117440795F8EED0DA9FA8CF50820A17D03F57B11E74B68E28DF7AA49013541FE0D2838BBD58F6CF789F183FD9DDF35A8002B42E20D40E979132F9349BAFA7066735953CA4063DE66B9FA756AB2C1246144EEC18D16C36DBF3090EF8228D0DBC30743ECD666B47311E500E3C40833F6181FC5A68A1BC64020057E9326E53250701A624D0F8D6F843544C30FC002E3CB97DF80E2464694F1226B02E026D6EF9C70E3E3740E727243030003041D6340CB2B02078B6617797FFD9323D796401268807696461746124EDA634BB3597887738866366671EC01B49AC3C084352F44341936E62575F274C6FD0EE40566E4F5508785A2709A93C9010444118B1CB817C4F204928277639902F4F304C3827CA8454264340441CC89790489F505003F912BB58274F60F3257997546826184F80364F79B0F8C6721EB83000E433D2412454B726EC2292B69131259CDB4E780ED97C7F766F6C746D642E14DC14047AF24F1EDC006462671E28E0727463244941C01E1CEC30275A1F384F6643DEC8544026104F50463EDDC327746C731F609009243E3037F98EF0E91F64D7F8E9DD38F26C304178282BE603663546611F086EE02E116D8EBC01466580302C0107CA21DBCA32AC3126140033C8C0159DC05734D7038EBD7FF01E2736B94EFD243CA3CFBD27200FD823E2B01FB496C02A1F782BCDEE7367509C0062731FDC5A182540D61F7089D07B1B7E18663F73724030314526516D30E4F0036E01B58B08E48000073F0014124201FAF64F14010A04000A34060632067019150B89F41D7E520230B83AA64E7EABF1FF12050012620E700D600C500BA0191D3E920250F26D03552C7E076F12E637AF3208061E32110401000462E8EFBDCDB03F64EAA66D087406020C60186DB6335BEC66564782000F42976464D8C8D260B772300514B0195219262434D3DEFFB71D060114000CF00AE0087007600650A840C4D40A9EA7D99214DEDDEB047E51FBFEDFDDBC01023A0D800A74004C022C0436024504BE1B067E09CE656D341206B283CF8C1FEE692E87E23E085219179566679A0A72CF3CEB3A457C43C17B104C06020E1FB65004D80236FB3A2CA919076844606D4F34D36DB8660011472F808689FE6E3EF895EB560A504E603EC2300424020EE067370F46010F0F640B06F60F720BBBE1E79A0E77BC68C5EBAF0E6B7B9D74BB002105080574061FF2064C34C5819DA9DA1F1913379A0E8722D7110C0'
	$sHexData &= 'F0C5206DDDB45B718EC362109ECB7D00BFA83802E4004DA02861312A9FC9FDD2612540D066612520EE00C700B604CBC61C853555C1ED1020280E7C381E06F74EC1679EC97A73B90468C7F959CF0CB87C787401602224E97075C333504BF500E5F0672B0B510BF1FA7E0F94797A7E9F0707660042E021C00F96CB043EF2708ED0DED54BA83E00857202F251EBF29387C2F6E1E09095205E0036064B3F9C802300C00702DBC2D30EDA53BD85A1FCF709F7553D46E4D0E10D610340B06328B199D699E17DF08073267A4187D542AA974AE021F7EDEFB52FF2438C908D106F6040812FD3B4099B98C1E061310306F9566BB0E1E417E14386ADE01537CA7DF80FC0C045002A89F32E70C5BDA7B9BEE2916081E0670980A4606E9EEDB0B700B420750065E4F343E3C309C7E90045C9CE69716CFA74BD2D25760286981BCEFBD3E0A0A77A0366C422836890A8A765CFF5B6F600858001602AA085E0A7F509F539990661072B0B93FBAF7EAC6EEB7397C320A3A9E0459037BDFC88B027772DC4438E908F7067EC31FEF1DEF3008A940424B0204FFEE83693B541235DC4214CA61385FF1AFFA14CE11801843F6BE063E0462FA7972680738EF42EF027A048BE6D97C2F06641514F27754369582FEEFEF87EFC087EEEEFD80369CB02C15408A700BBA0B867EBB6350104482025AC0081C02CA0A1ED06C776C2C19250613642206342101F526804906CEC7B894E32BD4F70ED6C510F10602F0980A8941D4EBBD41033EECB8661788DA7D82BFF72EF034D10B605502F3060C0EF952FCB5C06FC63644F4050E84A8E02E5A602AD402512C380CCEB66EE5C9A1DF28F032F072044703364FA31E570E0D920B2F07AF8DAE543CD45E5D10642E02C002542C7AAE54028E4BD506293F357F397F1F9B6DC7031928091E541906341801123C9D036FB6E00D700C20BFB48A81C1E7A9BDE20C0CB22F0D3A40BE6962D780503205FEBFD780A57E1770089A042008680C9E2F19600872077E8779813BBA0910905EB6D70B0A9C7C402630A21F559BE6E009E60852013AF63AEB5FD4FCD4060035C407545E0C7208F006E00470E07691C0378EA01A341A06F210F01B2452344AD0FA8F8F7CF1D3DDAB3472851092F70AB047367E1730F832A047015ED2AC04510E02B20F028103DF6826C619EC5387FF3215F013E011D00FC01F0B1FC074BEEDCAD386C9D40E10450A363608069976F3E89A1601342F1414640A06A32BDDCD34095210706FF801F20250BD7E8D7E580C10182F6C702E7C4537001C699EDBE0066F0E0D9230F2952FCFF3395008C0369CAC44BB183C2A86D6561A02D2BC821BD64F1A12E5E08A437CF28F8506977FF70A6E0ED0814AD0320B900A2D020258046860551D56D94C79128F0F8740302E9A'
	$sHexData &= '0F680F08621F9F4A0317BCC5CCF2CFC0D8C10AC072345721E8BA6987E857F14FF3DFDD17DDF360362C463C083A021C041C06C711CC0009E7050011DC5402BCDB8BF724F3CF2D1004561CF2DC1E244F0E1E4C3AB0E0AB55085CF31FD63E9D2E0FF15D979240BF1A1E0AFC9B06D207E00570046003122741362BCD90F36299F3A6F3C103D3DD80320B4008A4B84A2D03B6AFD225A6EFF7C8D16EDDF0D4E92150362506E05946030ED17C40DE1FA7846FE4219608F4111018F40480E3F94EA03D8986047FF33CAB1E250A13129212F010E00EC0A93CDD0AE67744424D9EED83E5545B0411E6E50532C474FB0B46246814001C343506012A0013799E6F8E178886320191C1A5FBF2E00EEFF081033A0D0158E02AB71A023AD0040CF27CC701364F61022EAD48D006D60829C15EFF17F4D20CF1030E6D030C11070AD7020C0607C8FF4D38276825001F3456001F014C0CF1F79E83F58E02151031060A0E8547BCDF4FF73A1009417A2065EE053E5F1610237EFB7716340466065408740AEE085906025008A7E61D8A973EBF09041E22BBD33ECDB63F0154660666160E5300F3815607C6127BCED1F112011616708790F599084CCB06DFB306080AF521022AFE0E7CE90B90500A5582029004920690083EDD74C196BFD07FD9E4F5609F06BD1FE07DF004123C08DA152D671F280D34530601F09FE60402BAF708F67338151366CF7B101E062F06F9804D60133DB026F6590C20B8E0FF6E040CD80076024204CAA4042E9EA6D902B97F676421203EB79BA81A1A0DE00BBF68CB00479EE779758394089036EA19B9BD3CA868C804068B62713E6A82A942B68A1856DE025E063AC23F0B6E010D420970086027FCF4DB2626DE1701100BF009E007C08B3002F1559A779FD8F672E11003F7CD8B3F60B8B7365C49988A49822B3E772BE0322B6066B414902A02361675FC17A66608320A5E08656A197EAA00C6CD76F3CE2E1D6443063442013C005EA57933DBCF40F7D249109F5E6976F6061A3AC3114A5AC1023E2F14B377F1166265DBE741A366AEECCB90C106A20D420FF5DF88234F350414B9E402620446066D83BFE9820879BC3A0C9010741ABC372C0BE46415FF6FB64E06344D01460013F011E00FD00DC00BAFA77D95E6E0F723ED1037F8065CCF0787F71E0A90653C302440033EB82E609A7EBAE909FBB2207ABA41F4074F574B41F396380A304301EEEFFFE3E62DA071040414181A46A2021A1C530D2EB60FD01312C0534B14CD178E7136FD3BFE10411A1EA97A98064A08860AC60CD8FA10C1F6FFBB9E12D016110518681A1618050316356044128F7924CF3343423AA8F8799EE6B3C301B5F8E9FA14F765607AB0304570D09EC0F4A1C19BDD2EF109034C2502E07E7F118C3FDE017E1'
	$sHexData &= '012F1F8CB1F4CBEE07F70661A3A7E06250308420AD6480C860EC61035752C6E841244161E0A5606681504384EEE9FF35EA5D99734F98B41105606674E95E1C30A3380404F40A00AF05CDED806085EF964E91C85C0957D011852046C068A38662260B3B92D262268061E64253424011CCFA9AE90EFB650979CF9A5FFDFE579C6B20470B9F006790402FD0304BDF43C0F9B021A09761C1B16792ADF523EF07FDCE5F2B0E9CF0B900CC204CC02BC14029F03D739A0008714FA1DFAB70ECA214C5F15D615541DD985CE6C06341CD6F36758E83D9548516A0608F6DBE125446EF290625F9034179AFE82BF400E800052022970EA066D02081E06CC02E3C46E271F491B8B1F827978601F111E0B4E1BB32182E9961E0350F7C44A57792ACDE80CD2EEBE87C1DE052EEF6A9D400A8A3A40F0BB4204A103063808E6172148F0CC918E15A6D29B83D391570E18FB21FB2D77070F5E9D9882E046AA0C9886DE3F3140C1045D76AC44570CA4C8636C069206FFFB3C1ADEF7765D18068E5C55C778FBEE35B8F7810891472E4DD28C0983495D9F9C042A04066784BB74CDA8FBAD08BC19390FED06133A5619AE1E20344006012FC07F863627D00CC00A700960083FE0FBD3E2AB3482E9102BFCB059E2217BE4A181057A0D451CF485EF589234046E66924ACE197726D425E10376B34882B6031F9C16AEEC7C06CC513EC11D5FF5A504106D9AAD0A102D02621086125FF0CD8C0758FCAF611002421AB0ADDA4E360E1078318468328E670DF1FF073FD009C0077006600530040F90F87B43745503FE10F1061C0E104E1CF9910D9E414E01083E5F4E010770475E1E6FB06106501316E060D3095E0D01A0126404C10224F98BC105E81E957A0288AA36DE8004D6850C042FC0FF177EEA0EDD1718CD031AB90818EC1C590218C073B0E08C1AA89E330F661213F380A1A9FE3228CF48FDE9F0BD4A1A51106506060A8161ED551F1901081D0706FAD50D0690AE2708DFB51A9E0117B6F00BE009D013CB9EB57BB7EA2F01E4C6EBC4110037ACFD5F50E8E83AA7B5C7969E027B6BAD5DD7540916429B6B2EC20DFADA21CE188E11F082D00BC07F33DA777B30065001302E278620F01EE01CD01A8DB8E9FFC018701760163015501931CE1F64284E27A7C0BF352076F016E014D012C0100F30FEF35EA500F6F33D1060067514AC46C50E464F6ED03DE0E17B1474DAA0C8F770FE3F81B0E270E006BC901E80100A68FE4371ABFADF5D5EF10D18090302790C4938780499FC0A1A580A520A1E04F10702FA0EB3E01736664E08AF5256111F320DDA701F6807BE54169614E0B4C60D02701060FFFE3038E5E70ED1040E90E1006F1A764872E804C65342B8B6009FE7E9FF3AA8B7003298B8002D88B96EBABB820156'
	$sHexData &= '1D4036780118FF86520B8FDAD153101D22DC424F0E0C5018D9F42781243A709B90C11D22094BE54E5DE1027205BF375796870DE8451503632C95CB5BE1A703DD2015C60E95B6F9D9EF6109424D1F3A2BF505103D011D4269C307D86C7A87B2B1B502D03AE4CD7ABCF81E42D000101E7EE5A26D3A1D7C5B9C25250229212299018366BF83E1D23EC86A95219A0D3A6C8727E84F6107411C3AA2282072972DBAAFE11CE2303A0D3ADDC11BE1387B67BE053741A2523A1B7D06FFF07D3705DD06B7BE36F3088507752846115378F09D034AB880C5081923CCB0823B2774FB161BC8C8C8C815161617C8C8C8C817181819C86CC3C8191A3F291A6CF65AC31577760D07451A0E09B61B0978D9C8EC40F1E109B5610A3705CE6691D90C0D0F37611B610B161999CD290E1B0C14294666B3DB1B0D3713DF1C1B666F4528153F3753612C32BB4DC31237081B6ED9ECC861E1110D07291B058D8FBCCC37108123107D19FEA53AB4D8BEBD2E8276F4DEFAFFFF7F4404B4067D050A9D060C200A59030E2810FA12581458166A14DA0A28FFCBF3ED7C0A8E2C0502E46214E20A200C4E0A7F91BDBB1125FC1256534AC81AF5020AFA2432FDFFFFFF262824790428202475032A582C582E6A2C4E24C63020326434283620388C6F15AADB12303CB83E146C48E84A2048BD82FFA6DF044C14DA4E616A2052C250645435054E40FFFFFFFF566058410346A45AA9023CE05C445EC460110462CD03603A642A60DC3CCE662CFEFFFFB768B0266C266E267026727E7428762E78327A287C2A7EEC8026822A84FFFFFF0BAC862E88AE8AAA8CCC8EAA906E922E946E962E98709A2E9C789E345DFFFFFFA078A234A476A640A886AA3CAC86AE3CB080B23CB4B6B6B494BAFFFFFFFFB4BC80BE3CC080C23CC480C63CC876CA3CCC80CE3CD07AD23CD486D646D8A50EFCFF05FF662D03DA9506DC91CC201C540AE1041E5E205E22CA20600A49F3510B761F241CFA7BCF0F8C030300DA9510AE06080E30568E8EE1B432A7BB889ED6C2BF0791D50202C102068808277F97AF09E7CC0303D510026A021901A429D2300BE6B4AA14F63DDB0004E6420509101905066291F6223FDF130D1A12919191911211111091919191100F0F0EDF5803650DEEBA4114994566230D4F071B41C82C9B1DC10C0D06291B410664D9ECC10B0D05291BEB403530E00AF90A7B803CD0C9C103B909049A25D008C72908FF8B5ED4F0549C008A285206280824CE0C28FFFFFF479A2812281428162418B41A941C7A1E2E207E2232247A2632287AFDFF6FFF2A322C7A2E3230740C346E362C386E3A283C6E3E28406E4228446E82061A241A6E05F000BF546E4E524CA107DE1308AEFF27355B0D06340C7253191B04000DB206D82F7DE1F00'
	$sHexData &= '4E00F86211026D20A074C48E234133B63F1AEE201006B06844C67640B423BE57D1FB126985E1F7154EBC0670114F6420B9B9F10380530977205F0037016066C0BDAED0016E4060E6407BE5436C00D9EEE0DD50E6CD2FC1F1922461496122E88F6E2833EFF6F95066FC0198E19F41B000BE41C0004C41D00D6229BCD800EA20E34061FD69A20A11F48AC06027087FE6AAD71200836763412010F010C017BDF1B8867B466523E28BD10C40635FFD329DED006A902005202DC0BD60D6BBFC66417012134160601C857954FE5E97FF462FD0407608E65FAAD396E1D0CAA5E182A0D941F1ED205E09F4843C1A6F91B2E43540D000AF40B6410199EF860CB6648190C071F1924080D52F5086FF2C3A7788D5A6F9E001C0DA209F0EB6F833E4E5F192308A619003B81E9A6131FB06F2092E6E24233A66F367E052BD1B4B1622F8E2D1EE617F0A0271EF115E013C0520F7FECCABE29F5367B00C7F9180A08066AC7275FB40108038D0A06FA4D0913E08F52AABF1301684FD0FB6678D206C003873864330396B8D4F3DE4510880699189FF9B6D04CD350F7D0620BCAD5B2A57232B03ABF5C7076AD7A9A0D11041C141690BF586F8ED058E51018C0C43208990510266CBD6AFB12AD0410A934CA08042216261024E4C16167689EE25C3079507E1E825FE8C85E03E0BFF110FE06DF1B30579EDF2202C3086D0202828CAD295C4482EC119E11825E003BE58FCFFF09D8DFEB30862D083306020E10592448C2A8627402FE375460DB9E34600601589F5C543F3C4FB3B20C6E6589103D6036B8EBBCBF4C7A62D065011468B23C1053B5FFEF025691180A6E0046049A06E410C6B6125D4B8F6F7F77000E1C306A34DB640F06340D52337FDEF3693FC438D1E506F60A0A10E14F7C1703CC3A90A00A303818F5F7E117D20406ED09B9C8D4C9050CCA7EE9EB9BECC606E8044C50008F200916AB691F1ACFFFDDFAF7940A0852060E0816105AF8A00E2DDCC1E2016A3915A4A83FF827DE3E5816F222C102089690A60C5608540133025F071606D96295A0A72F800AD901D83B8910900676201B11F001E09C37CF7D9E0657B017B9C50C0804CC8ED10132BE60FE5E9ECAB7B5B71106D20657DCE5FEEFE0DF7A0ADD303EAC4C6265ECA61BB89A0AF8524A0625F8C1F2FC10CF08606E60575F2F397906080BD71F35CCE5DA5F70640A1158DBDEE906385F1FA6D854E09FEE14147277800C94A7E02EFE0B0B23B239CC8A6EA82EFF103D253D3CC3064B1FE73D3D7A09D7961F117F0D7C2ADF690CE7F4FD040C3E5D6FA164E69E2C0107424558A901F2A6210D1EE4C9B32D6E0605340A22E616400C8DF6BEEF540B1F2F06140CE71FCD2533AC674F6434800C3669B6415EA341601FB5249B17F7F04109421FBD63'
	$sHexData &= '3B844F9FA02EB4DBEB2ECC077FDE1FE006BCC779305A681F672E4043325B4BB263431FE752F9BC66609EB056CE280D4D2F244D2600A7AEF41BEDD27C4E074444001F6777AB7958560542E300B660C90D7709AE50467ECCD626CDAD469C1F5F34A4F9349764F00C47CC9B671DD81F0112060A0900427B88CB1232113E341506B2F73E1E4CF72C0E6E35084206E3D7EAAC04CFA0AF04B204C0012BA15E0267F6F354BA55236F646D8C9F849FC20C973A133840C3EF915B60889293107C2C02AB04FF1D2AF00424063A08880C1E9CAF82D25D081F9FB45E337E1FBEBD1002C20207D00EFCC0535886470688216E2FBE063209E0528C84BEF8A704D73053AAC1EEBCF50680E75C2E274DFE09803760540100765401F1DE15891FC7C01EFA06B4E1B203DB6F1F1917AECAE4E41A48A3FE2852430730362FE61186F30FD885074EA80F03007AFA6FE0DEB110B806B7B004D504390CDADEB30136BE364E07F885249BAED60BF2EE2108B360A3DC6A7E905B46065C8161B065CC0F1F873E7C05D01410B6190802498711E1F319E937523028393F101498603E16805B80063E10BE8A369E3EF47639663474F0F0A502877F405F78B0E559DEAE5F101F0151CCF6A0ADAE51F4764C7E47647E425463168C8EFAC0F717F05D719006B010BFB910045C4AF2B09341010B9632F3217863871B0F0400806A5A629366CF6AD01F46003990DB428FF0E45D3C9BED6B6EA66B181108B674B10BCD00B02FBE1F67ACDD37044700562FFF5B69FEC85213060013E40405B06C9E6C629366D96C7C1F069FC6AF85BC560007525BE0F9F597C0A7740C0B97106E1D6CD26CA63A6ED01F12348BFEBA6E12740967106FE62C6FA8C884589B1F170EC2BD910350125D106E06F0E683FCEE6512E5050EBACA06A6044D5B0B0B426804E49E1717460934DB641106341072FB21BE57E99FA0AD08C106D212B7DB14E27E603A70A40AB7C9C7D522019B5B4905661202DA0EC00B70B6047C7204640A32A6F0BB0825565E14F012E010D0BD53E2917F0ABF0413C611E7AD3DEF083906561032DAC6E03230F57B47DEDF680A0DA2D0D918D015021BEC53F9EFEF08485E0A0C0E4F0C020180345C02CAF86F32E10C6182329E04FD0C084D040E389C30603B060C220C329EB210CFF3E9EF7C29868E90646AF633DEA902F04A57A81EC05B19B20294478F9EEC15921167DC13E513B405A06CEC131708692224BEEB746C5A008D030247ADD9DDF40C14B71510443E23BE14792220241F3C1403A6ADD07745104C140FBE857C0A9B9BE93200191114E611992E70E8EFD778070A9EA776818E0436F526B80082EF30D30A063D2A10B903047A43E259E7A6080429D2B6106820831E5983BE1449331B4C1FD71372CBE5A94CE4EDFA70C'
	$sHexData &= '01F84CFF0D2088DB43A04B5066AE191F0570E327F5BF48441CE7FC66086EE5B62CB665C8708151F47C05A92CDC087BC881F7585A7393E0542C0A73E62B57A27F4CE2E96208996D8A4D9765089601F56BC44799E000000010F6B9A8406363203505A92CDA987308C598C1F17D646D78737EF5189871C52808D468D0706532AC6161F7F88CF3B5E54168F5D163802F45DBE3A4F7C160385108C169318D7783F4E1A9816BC56418C210C0F214FE5F967B032B9C09083E0F3400688840007D8F9776265E1A602A7809401009994366F830D1F4730955A9586031B15DF1F01754EA9207EC775D4CE67C412005534DE9200BF5607500167B21F50216CD5C4D6A7D40613C476745E0B64CB66FBD404169099FEC4994817E779DA621F660000002746489E00004FD09B86031BF20100329C1F0178CE4B83E7BD788E6D8665564FA234531182C04A07649F588B6C16CE9D9FA0EC1FE079F2609724182D186812D27C12BED70D32607EA185B7B2EF58781654CC9F0F38A37E80A3180C36B44DCF27001F9561D74C5FA0F7A93666D1538402B760211CD61C749A6D81CE1154BEA0A5A6DBA5ACE769894D1F5600004BD3B490008E07423C71CFABD0475011AE4F6CD96C8B6E40A7AE86A700191F572D965D04AF4FE7F0F672AA252F740DE0A8A6AAC426CD10A9541F2F3CDF42DE5600AF62D0CFB3999F18080018B6C405060EC426CDE60080AAAEAAAC1F2CE479D908B75E0000313A2A351604572586164814BB0E17B2CFFFF181A6F21A03005A1A1ABFF90BDCBF12C1020281BC1F150014922F4FB323745C6E7D84C0F80277E000A4066EB6023174035DC20ECFB077B9E21BF8F3E40E0C2091CE3CBBBB7063C532300DFEA420E4253E20FF0A75A85E33483F140894043C06050B7AE1BC0E76DF2337AFDF48B75E141BBE001D18048973A060A0021E9F441B9496CAE64D1B541B107115306F56EC023D08FF7031F269F4B76FF4640DB8B0D8B2595EDFB8601B1F180B7929FF56005FB782DC3F6206C0F624561FE4B69F161236D406F740BAB67BBACB263669B81F08B75EF26D21CF0000BFD00470B3D93C57C464B0BCEBBC6F6DB165181C1FBF5E00CDAB20245F70BFAB46045B92BF1F5FE6649AD63F37E02859B03CCD28D41D125EE0C129B149B32AC2C81F0F2DB6E436D45F9785A6285252BAD0932186EDD569421AD612FE30C5B67F098B2D9BC5281D1FC9158BA5D7578FE0C8E643826F2E1DD412C4894D9AED20C7B669C7801F7BB1C90DCFD45F01543E4B0D2E635454AFD7CFD37051621F17AE17120DCDB691032E27D0CADEF0CAF4B78AC4261F0F5E7058B190000F4A933C9B0B472323F4E4502DB66CB6CCBE7ECC501E1F552CE4ADBF5E00CF103944827FE6C46CD26C0F76E0CDB60ECEB01F'
	$sHexData &= '8436B9480EC4571BF2274A2F90CF0100C0CF1F580B95582F37810CC81547E0F48B2D9BED00D1B62ED1501F1F62B1C905FFC45FFF2679359FCC1FD5180C6800AA020101F08801902EBE8D8C8942AEFF118F0A9E0DA034098F0C20156498CFF80822204E80A5376B17F097246E04E76075D6C30937A6EFD8DF8D78168EA6D8207F091FBFB0D14C7926307A1F67C5480720E7540E86B6F7A0E5740714E5067C6717CABAC11F4F64FF504006D6C6A8DAEF1F082A6F7ECF540B0A0013326047696D7B6FC046E706D8BF1FD5FA045E273207D78B2D9BED90DB5EC6DB10211FE219216946007F66D2A6E0D60876DC23DD971D57708E0AB61DB60D0E0A2FD312DBDE920654AF1F86006DB00BC9004E1FD7BA04B279F0DE43DF2FB2DA96D8F606C0D71FD787AC126B174E1F3725566B4426372617BEE78F87502259086022260127E3E7C0225A009E07E44B4C8E5642BF80224106D86E895F480247A46E80C894AD2C77C8EF78C8479FD1DE22760C3094028685331534B2D711FCBD9143D7002309101B06060CC03A3D08774D2C006FA3084CAE00FEEC043E0226065E2FF05705F0040FDEE87E7936CF66EBE824231B1BE4D41D5FA7C6862FF706342347D86813BB3627001F9F18924E1A017F0F010842D2D31F0F279EE6647310F14BF10F0F0AB682D74D2F5706C82727A1B5D126001F9FF3D7237027C7EF4424CF7BDF406BAE51106A067B0C71A187C2080A6E50323CB03F89AEA10D9609C034722409341B0309E85E045BA986DF9424049C067C08B46C1C3006BF2ACF48330FB2A453B13D88CF7BC006D10808C073F661BCBF807078C8AB485F4131307251030C52B42AFCBB44642E5F743824065C1B6CD528EF1F4FC013025BF2D01F776F98670C60FE04FFD47916E050F9CE89F925FB2A4E458814F61E0627D20629C262EF3C25971FD7DF018B99548FE79202D0213A34A00A15AE3AB62E3E245E7BE103F60E5409E760FB5E7BDD05F6069CE79627F406A4E70D4A4C6C1F0E2FF8429EE7A6000000111C0B1492A6D2761B124CBCF7ECEF4026490866060A6C5F9ADEF7B029804096A85F082ECEBC82C4FF0E1D020440068EC80A8402C4822EF812F89624A6156806280742E86FE6581A5A7E057612000DB234578FB03FFF11FE10B2D9BC6A22FF2697D526E8266E8E2348D4704534179AE36AE2600AA2FE8E0668987E01B402E902A7C7833D7CCD880ECF06F426671F1EE03501073427C63D275C7EAE6C4427300D021C003016204DF3680E22211C9FF77CBA6F6C38799206BB0A0865C31B4179A032102E5E8066BA47A3419A5380FC9A40A1669D10355860A803E3157D0F379716A104D2D627370085820CEA7E94320814779912B202169F52DC82B2EC5BDF29E608EE27BFB7606E0FB90AB'
	$sHexData &= 'F6208285712660246FA10B002A2FF071BBE6F40303C603508024E87B37D14960AEF5F06345E5A040A630156476FA0D86C1FE0E86F740F06640E540DE5C43707860C9215E01925FE3EFE6A0A561717B617D2100727C83C9DBCD601EEA60A0FC21408779E14F8043E087E192ADE2B8008A1516744000FE0122FB7D0C0A527FE5ACEC146E15597211E46680416C5562AC60ADE0B1F402EF6DA62CB66812EDC281F5E00B190E77900000038B54A48CC4E68460B46E1280C1C3E0A7E514D7C06466611A22FF9001C820F192EBE1F00BDE4050187A4002C070364B6027E2E06342D862A858207A7CF6FCCF379C54FD829DD2998FC762A801FBF340E493502003F611964D3B0CE020250084CF154EA07C606706F09F8E9C0F30807F606E011157F3E9E58662E154615153211E04EB3F974BF02EC375B3857FCC2DAEB01BE16C91F6F0869365FA7670446033925396EF24EDE3BF85E391E87423E4D2C74AD5B1F4E3F091EC185C00E761A7222701360D7086FF30D8546623A9B610F3CCF04578F50D7070605A76FE0D3120D045F863DBBBAAC019F180F482B03A331C0655FF09C1A03486D702E37E66DDBADCB1F8DC02B41BF5F564A5E282D4F4EB16E628F88B74D8FD02C5BC9115B3FF0231B8408AE50FE979F506C646A3825A03C1FC8F299D80B40647F28301F6E279053602BB04C8F2E957C26087FA0302C10C3E4822F782FBBE75DC958042E70186E7F911C86103F6071A7E494B44E197062E01A716A3825786C5F503C085EC9542FA07022C7959C5AB77763EF4019732153C56F4F9005072118CEA837EF4C119D927060178F1000B573919801A7646A0FFC390327541E554AAE36259A4F66E44AA6F618589F44BAA7E4D5AEDA27723B8851C9293925AC4FF23AAC644A4E8E527A40252B657F4214B44001B20AA2489E57100080FF002E452D48D340E64FD1FFCD5D20D266D4DB3A443CCE02831D538185B7FF0175984F02B9189ED8A0701F9F38034702055B2600009F406C955C32EF035028216F020FF280E0A40807998F502E3F414DBC01C65672DC696D655FFF41FB8D674073746440405F3C6C616D626461DBFEDFFE5F313E403F4343063F5F43616E63656C416E645294436F9A71EB2CE36E756F7338245F548C7FEB94645FBE706C4045406465746BED33B1302C486375DC650A79D818B7DF7E554541415F4E0230304145425662736861B38CED0FD0707472345F45B10912AC7D486F6C7A7283695AC680E0405A405F50C302A5965FB71FB3BFE1836646616B1E6E6F5F636F70790878612068F661626C208E61140665FC7C8E03324744556E69B72DF88F98496D61676553657C6368CE594197FC118CB7FA7369635FFF405F5755B805F614BE635F1E8C747320915BC6252950DD'
	$sHexData &= 'B387056F042832A72255A1500836836608E873CB357F2ABE658C279D407055B19F31968E10C4B0123F3007BF47D7DC3606796EC376658F6F65B6F37FC1664055506978656C427566666941707FCC0B51EA4024240CD90B28DC55320B7F1A0FFEC15F4D96566F6964546F4A74460B124C0AC86B5FEDC30E1A0B184136FC58788E36825A11395835CE89E238159F4249B08286190B463C42886D488A6318235F35B244346E05CC743C526573445691DA1A9D35E9973D381EBB23304800F2DC401567314D7534B215A48A16363634337BD4B08A0271AB11A2C01432BF0BA651D4B7EF04B0428F74DD6315328A2890A8D5FF6955C966344A4D1035A4AACB176B238AA737BF8C67E263B1D4851D4F46ACF64CEF519F2EBC69A4D6B7FE0C75ACBF3752303F3491C046114C533571A2C53A61974063C52AC2C35F5865793F350D6D3B585008555F7F480264988AA7AEAA42733369944239AA122272DF31285855B2464C7F50807C26334746023104821256679CE8D8D22173BF5F490DB3C473007075E7848196E0D8616F8F23B5D58C53714F3E6C4C2C675F2F8D9A52ECD2C31F0B824134111F4530280D633F50C0F1801FDF9A4AA58D365F5F5F8A030558DF7479D01871E1150A6E666F40FF870E29CC4C5128D7570E50C5CD34355824244F0C8182569FE762756609A6540CED7F753CD28146812A14674281A6B70E793263EFE82336A2879F5265662E5D25D436AE48626A328DCF50D120FF55500DEA4EC3504CF540452549D669A211D7045A2D58B35E1F66AA337C5404381C7ED0386CF74E6F412585CBB1862DBA0C2449E32111C59722DCB663D23779BE4DA0055CA3DF8A8250D40D5155B506589C45DF3528806AB98F2B3C444F696F73A1D10AB422AA9F2D94A242A0530B8B20C4CDFFAB916A835F5F4F22C5306A6FDF1044AFA0C873C8697264F962C5172CDF476469B07573241AB15943171F0BE48B53596F665C65616D1A11C768EDBF1E511C1F6DBF5F47561D0F825961486582187F324401461851FE9440139E716240483F5F15740227CD60114C182187964A14BFCCFB5A55A1401F1AB4A02A05E1C3A90081FF4465AA52310C8528FBDD481507BF97545028500B5162D5A93F5F42DE8814FF696F2CA402242F23BA3054F700FFBA353402AD31CDAD8DC020ADC6D1A0E1DC9F1DB0AA0A2CF39F21510097D30BAA501505FF0A484D576BDB052C40A2BF8780404B50C5BFB42A58C43DBFC06A1855713B6D55B0A2BF777F2FE00B48BA43B8055B70018FEFF0540A812B2C1AB069544F6F7188512130DFF08386541BFF5061636B16C44629481BD941240A7132C15610ACD855BF3F54A55513353F1610D558D9AC2A56177FBF3D135148ED36452BC002465F9F80D516156BA3D420AC0'
	$sHexData &= 'A5F3F8B9017187F69A1E48A082F45AA19AB091F21E2C4EAD4BF19AB6685221F4BC5AC541D239F85A63446216C79A1D9DAD052201A626A180D50C86DB2671C0ACCF0107C6557181BBA14DA663456EDD25B6D15565DA95901DF880A61551F62AC0B891D5F2350C328632B6A60159D3F52550290695B297C11A927B9A08042C03F6DAA56458AE7FF02820AABFF1156D53858EFFBC4AA6800BFB7095E857F44697280756DBDD6141A8C4177D30C45D40710377CDEA185E64016B7C0F5F9DEC8D7D02E0711100E871604FADF3BDBA79013125E68FB0E9E16F8E9F7CEFB34B0421346EA0EE816E6D37C9E14F07E15248015E7693ECD5A173C6017934C37FB669FC003188F700E91182FA016E7799E93CAD0E054E03CAF3BCD0019780F3D164C4074CF73F27D8092808F199ACDA7D9661A88701AD81A98F3DEEC530E1D1B5F200E421680B4CF3DCF609FA8470E9E1D8EB0CF37C1A70EE31D4FF016E71EEA5FB3D93C1E291F10EB300E881FD96CF266479016DEC04653207C0BBEA718600E8120C72E3721CFF3DED324400EB31654E019F81D7CB322A7500E7022DF0FAD22B25DF06D6F0EEF226723D63A249F37C137400EA824C7B016E270EBCDA7F934F07E259C8025A6B3E1F33CACB07F26E6F0EB9B8393CD26CB2626AE2800ECDE65F33B0EB02900EC02E316647D4FF379F0182A7C200E4B2AF079DE9B77500ECD2EA0D04A2B7DAB807137570F95F73C4FF316ACEC959BC0A00F776FDF412BDF0FFD5F102CE6067993CDC3D0EC0E2CB32C16EC5F77F739F0002DD6460F361610ED30CEF334406E28F3BC6E153F0FF1163CF1F3349FE6032E50102E2360D37C9ACF301130782030DFDD693ECF8CE05031AC0F697CDA77B632BE44EE0EDD331694F0339BCDA7D95934CC6034FB3548EFDFD36C360036C33798D00E04398987EF6CEE38F00E4439573BEF5BB32F0FB5466C0FA5F93CAFBB1680C0BD3A90DF7B9A4D3A463BEC500ED10610F17DDE3B47B63C062416509E3CCDB7E19BBFA00EDD3C6F46933D2C369FF63EC03E8640163CF0400C469F66F369581046A847A0E047A2EF69369148E0A00E7649E60EBBFBCE18F20EF24B5E16B0067BAB7ECBB04C0F3F4D4F0E99067B4FFBDEA846A00E274E16D4300E90063ECFF3EE0CF38E16E334F059509E66F369646050C55174D0D36CBEFB0E0D53C65E20532B56E84FDFC8E630563357400E7059FCF4B4EF69BF020F7B61165C800E19652EE0E19BE0F920656537B00E43669FE7BDB35644F50E7416548010677DEF7E577F0F3469362E700EAC697D4FFB365F0E226B2EEC300E126D7D4FFBEE8EF6BE0EEF6F16B4F00E0573DFD3BEB38E1CF70EEE7916B8F00E137A3EB7B700170E7E1780DC7EB7E13B1BE680F80E3E7F870EA77D67C16C8106'
	$sHexData &= '18F90E8C841674E87B9ACD90849487BCA00EF88A6B26A1C0E66EA73C4FF3750F51167CFA515790FB9EE6F360C98EA0D00ED5907EDED9F0BD16E00E4692263CFB0E7D7C9ACFF31698804B9BB0709B349FE6D3A548FCB0E3AA64EA3BDBF7F00EC7B0A618FD0E2FB147ADDE9BAF300EB406807FB126B2FB26FA260E7AB30F800E84B6764DA57D4F70900E86B71690B735A7D97C9AB9C040B9ADBBD8E0539ACDB0BB82BFF00E68C6DFD3BEB33608FE0E78C8169CE00E51FE6C2BBA775E16600ED4014E0303D669369FF70ED016BC10013909D84611B7EF400E410A06700503A77D6B14B1DF0FFFEE349FE716B0FF260BC40FA7D97CDAB80C16D4C00CB40DE47FB74611970F6A0E0100080603A388F32E7316244FDB9DB65B0F191116500F481216E7799A4F6C5012DC7CE09CF63DCD531494700E081916CC79DD0A453F0FF61620B3F9B4DD0F0C1A163C101A591BF9349B4F4C601B831C68901CA7ED4EB3D01D840F361F2EA0E7BD91CD401F8520900EBF16BC9BCD779FC09B23EE16A02395281408DFD36C36B028B229B8C00E0E2BF9EE336A0688870E632C5E46702C4FFBCEE62D08090E582F163860CD3ECF7B0E951694A00130D73067EB9EF60E0D322EA4100F33D6040A3CCDA77D0E1E34165C20349F6C9EC7E0F3D02435C6F70EF9A7D904F706982EA816E836C8C4FB669FF0B9372FC00E5439A79EF7AD42EF0FCB1614CB78DFD37C0C3A28300E983ABF69BF5588EF0F563B1644CDE779DD0F941658A0B23C68BA558838AF0F60E23CCFF31694609EA834ED5621AF0EA63EB8F994E6A93E3ECC16783FB10A11A7DC07E775AB103F0F80162C9EE7799E80DF40DFE95021E2E07D10418E41973CCFFB56370FD6166CD6ED5B8588F380370FE7799AAF5E16900C5E9FA410B10611DFBAD376AB170F164316D00F22E23CCFF316E42230F4E6EB56210F0F9616040D41C4799E96AD188838D7AD8F0FF47F16CFF3BA35DF0F361658366D3CCFF33C6C6D737C804EFBE6F878457F800E4B462E8CBC6E0D22CF0FD416A88838CFF3D4DFBCCFF3BA35B70F8E16D88E9C95E1F33CECA0FE47B7ED539A4D20BE4F49FC0EF64A1610EF69369B0E004B814D48900E4C9EA7F9B44E16A0504E80C0C0E333C679F0170E854F69DFEC9B37D00E14502F200E485176DCFB1C714F0EB1065F0E04524740C4B23910522653D79DF7ADFF0F792EEC0F8916E49D3CCD040F899AA05ED696CDD9E7E00154BF10546054BD6F0D225F0F8F061841C479DD760FB4162CEB4EDBAD5F0F3E552E3C0F4616DF6932CF505036562E305666F369363957746057225AD89DF7948C0E9016C00F8C5BBF1588B88FD70F0B5DE779DD6916E00F2316F47011DF3BDB4C5ED604100EFA0620104EDB0D027F0F10601658693ECFE'
	$sHexData &= 'B0F39166C40F2617C088F44E2D0FC6401EE8DECD83700657ECF65D00EEF06EF699F23D70E9D665E98A00EFB2607BD7106476766671BBE05F80E1C688F0E54689F6FE4737B0EE92FF02469300E7E5B8188BB6AEEA68F0F9DD79DB66D6B16E00F7316F45620E2D70F790604110327693ECFFB0FDF1628DF9B6C3C9EE779DD0FA11654A1A76476EB0671F70F036ECFF3BAD316880F0916A4090FD60DE23CB4E7693ECFEB0FE516DCE5056FF8D7AD1BC4DF0F7106E6F3BCEF0812030F8A16209074717D4FFB9E30800E3A731680400EA4796F03BEA716E4B00EB07C4E13030FCE8EEFDD677DBE16700E53807E18149D204EFB0E1F831658A7CFF3BC6E0F7D16A07DA4B410A7F93CB05286C4795EB74E170F961618963A419CE7C02C1741DC79DD0FF6163C0E5609E22E9F16AFE775A7ED0F948A16700F9A168CCDE7799E9AA09CA0228CB8BB5582386F0F6C8DE779DD692ECC0F7216E872AB04719E78F86F349FE7750FE41620E4028E34EB9EA7F9308E6044D027901EE6D36CBE164090189198209173F6799E88C8E0449347509388A36F642894300E7794E73BEF5B23D70FE746E40F1A419CB6289516F8D7CFFB7EDD0FAD060817030FE6161CF011C4693E8D992CEB4EDBAD370F9F9B16540FAC1688F33CCF78ACC58877AF5B234F0F7D06AC2E0F3DCDE75EC106C04716499FD0508D200EF00E629FBF3FBEEEBC6F0FE146F00FEF060418EF8D6CAE1E9F81A0900ECE0614AD9BE07B2ED00E38A1AF400FA32E30BA158238EF0FE6779ACFF31658E625A46C0F6FF6795E3A1680406BA48F702E94E0C9F33C90A0CBD0A410DB8B54B6A50E79173B6DB742E70F28A716B80FCEF33CAF2E16D42E34E4DA6E85209F0FCDA81614E7795E770FD3162CD3D9DD0A419C3C4F0F66F3BCEEB4AA16640F6C16806C758138CF7290EF79DD69BB0F23AC16BC0F2916DCE7799EE7292FECB0E2EF033ECD0C1AF059AD07600E6D7BDAF7B4AF2E18700E1CB21654200E4FB3F9EE8FB3D61690B33EB5F04009C4067C0E9FB86E1B03EB4EFBAD9F0F31BA16700F371688F33CCF8C373D9C9DB65B133F0F98BC16C8E7799ED70F9E16E89EA4F86DB72210DF0F56BF1628F33CAF3B0F5C16485C626E4520CE589F0F795E77DAC8C12E780FCE1698CE8A409CE7D4A83FBCEEB4DD0F17C516D80F1D16F80E10BFEE0F2306081D03EFAF3BEDB70F0CC716380F12165420CEF33C12186477DA6E1D8F0FE4C916900F9EE7795EEA16B0EAF0C0F00788D37CCFCAE027EFFBB15B0F39CC961E030F3F162020CEF33C3F453077DA6E15C70FD2CD16600F9CE7795ED81680D8DE90B4DD2A40770F7ACF16C0CFF3BCEE0F8016DC8086ECBB558038470FE8D0CFF3BE0F261F030FEE1624EEF4D600E23C34E79DD7DDED0F78D2'
	$sHexData &= '76160F7E168041799ED70F842E9090E9F672E35BBE0E29D3D70E6917D97CDAE770EAD45EB0F0D40FD569CBA66A4ED55DD546D57D93E7E4D6D6D70E30D749F3BDB7A70E8806E446B0D7D100E234DFE02E47D8F46E1520D6CF070F9DE6F3BCF51648F504D95C1A409CD70F1C166CDFF3BABBDD0F24DADE160F2F16A0AF5B0388D70F852EB08038AF3B0FBE16C8DD69BB35AF0F35DB16EC0F8B6F0D207E060021036F0F795E77DA91DC161C0FC21630C20A409CE7C840F7DBAD01C45F0F7DDE163CCFEB4E6C0FDC1688DCE2E23CCFF398E2E8B00D205600AF175E77DA6E0F9DE016D80FFC16F4F76061770F02E18E030F9EE779DE08161C10342C407916C079521F1672F79EE63B804667E23C700E9B0648355A00F7E256E34A7CEFBD0EAF066846B00E16E4F7D3BE1D5F0E63E4370E27E5468C9ACFF3DE300EB816B0C0E7E6E42D7CE27BF00EA2E8FFADDBC2BA9FD7A7ED4EDB0FC9E916480F13EA1664799EE7750F51167851A688F63DCDE7B07FEC98800EA7EDD7B36F826FB00E38EE07400E67EF2F70B7853B9BEF0AF15E7FBB755B58B70F31F2DD79DD6916DC0F7B16F80FB9EF3CFC7E060C24030F0EF3CE240EDF37F27082F40730F526F5B00E38ED53DA09F7462C0E08F8168CF3BA555BB70F752EE0B585F3BA0FB116F8AF79DFB75B0F17F97E25030F5016202DACDAC21FEEB4DDAA770FFCFA16540F1F5F77DA0DFB166C0F33067C251EFB6BB6B03CFBAFEDB76A0B1F0FA3FD16C8F33CAF3B0FC316E0C3E9BE093ECFF0F078FEDF800E08FFE43969CE1710FF8590C4D9E6D0E7D0FBFFC700063702EEB46FB01C261E0E500316780F6CCEBED987052F900EC70717D00799083DCDE6D398A008B609B0C09BB3DDFB0E800A02BF0F960B2FA00B650CDF9A2D2C670F133CCFFBBE0DFE27030F211614708B75B8D7E9EF900E9E063FB06F64F3E42ED1000E190E200E55C9A6197106EE760E8E0E4E3627CF0E0E0ED20E0F33B2397B0F2F300F4B0F50BB3ACFC95E7097072E1D3CCFC9B8C0EC244EF0F3BC37F22E0810100E37164C40D9BC06E76A1197115E111828473667DF0E1A132F20139C13A01338EB4636CA14D00F152F801537C3373906150ED41587E0169E93E6C81E16201654609E3C27CF5B5E16161617670DDC9B0E38069716794E9E9358607880900B045B370FFF7728DE1018E073F2261620EC6319FB0EDE9B4F640EC1069C7EC40EE41947DE7BB3DF0F0B1A170C0EE6066846E8F7BEA7F9165B1B385C0E7C1B470FD36C76DB9C170F151C2CF118A5E1C8E6481C28ED7E1F5644779FE73D0ED61638D805227616ECF33CCD0822D5A4F80323A78ACFF3DE040E41164CC09D2546EF6C369FB8A026122954290E554FB3F9B42A1640602ABC2BA0C06DE1349B2B352E7876A'
	$sHexData &= '7ED56CF0FFB2F16F00F10303ECFEBEE06460F541620BC22313EF79ED276C40E5E06E0BF0EC9313447BE091FCC164732483284C95BB49B0FBD320F16F4B9BD0DBB0F0933B70E3417347D9FEFE4494C3EAC332A030FDC239F5BB72F0FF017F02A342CC1E7799A34B74CB850354EB7EFED4EE40F74352F0F9D17A06EF89C3CDADCF335CF36C16788D3062F270EBA3607F73DCD37BC16623720640EB4375FBBEF69BF0FCA382E38CC0E4F39CE16AF3BCDE65039783AC80FB5165CB39D7D9A0AB8D53A773C3B46D73D337AAB4FF8043E460678CF0E1BD96CDFEF060C2B5E143F2F3F380E82B7EFE8743FB70FB017404036D36C8EC8BF4048760241189FE779DE20162620C0DEFCED696FB76D0F170F4B4246EE0E6CDFFB3CEF89168CDCFA42470F184FB3F9BD43170F784324EF9CB9EF8D7CB3435FEC161244360E920614BCED5D03F6451E452F165CB279F29CD0F61047414727CFC9335F8585AB0C66DFF9B448062A3CF60E62482F62C8E6D37C4449A45C498A498E7C4EDEB416DAE0114A2F4AF6E4396955B8E9534BBEF6B97DCB714B0F8F17C0F14B4758DEC8761F4C2E3D4C6416824FDEE4397E4E4E1688104FF6794636394F5D7B94FE2E1CF94E9E90B9D0160C500A52F3E419D93352B7F31153736473643A53FE552756305677C1E64956D058EE581F59EEFB9CBC9159681685C8035A473C79B36F0E2D5A2FAC16C9385BE7F619D9555B80A65B775BC1C6BD915C340EB206B64FF33DD6CA161A5D94E85E46305FDEE7F646480E9017A8CE5F8F034F7BFB0FF41758600697CCBDDB6D9D8E0FD6170F33614E163FEFED46EF0E570604B60F6E61770FAF9B3CB78717879B0FD15EF0BB75003A470F28627D9E377BBEEB0F2E16E030606293E7F632BF0F1790C039F2B9750FE017E00C631063D783D0A495CF64D7100031814D9214D452019504A880785043545F54FF96B5C386014711416464EB3FB7AC72181E6C6F62616C4D8D6CDD615C72795397450166BFB5782A4638654C696272612818D9BA7D2609697A655326737448F001C233B08F3D54E7B6AEB0A441734652137B06003E31430BCFC600ADB5DF495A51756592500666CA6D5B02022F18ADD04C6FDBB6DBC96164571A57616B966C6C3A6E64E4F5609BB50A562CF0626CAB5468685BB7B2B2A9533065705780CDFDF753529041637175697217C0636B6F01011748B069768E5230C3D5B66542617331430E2C3DB65D09C7B3594D758019B82DE039CE4D01A003B053CC2C4FD29E03C0626AA26C724274AF6D7830574B5422705024681A5396B29A0D444C614545B855B66E5344EF3E602D7B6666DAED15067258BB0916EB8F571F4A234EC803C0EF3641D213417405842DAEEC62FA6A2B82151B2854014E611A4279A3B850'
	$sHexData &= '445E60539605752108736139353D32BC577CA61841B370D4414E5349A97B8CD8158D478F6F5769C322008A64B6FA546F24101CAE596C383474BCD224ECC737F0A38A694D2A6167C4E3C7BDF79B3B9F80D74FE0D899E1418C2A7A23429452540C566E15828F1C0F05A4A45F77633CE5699FF96F75693634156C3862689CA781C56CCE05162A4F1B73E81B4487806D4A09F7CEA02C3C6310542D4F1BB46814665A88A6A0668382B6006C633C6FB8706E7E8ECCADF2B4633AC7B072F66E646679DA9F0946AE0C7371727476E6D01826127072F15F543C8727507E7C7B6F346577576436A66E6F6C6F64FE3EC3B2457B0F1A5F20190C38D3B08560C07B741F5F694281B97712A86D5D34A267B70BC55122F4487776726776D9883D6C455979B873346D894D7FCA76F66428BAB72D243E3E68E9AA30706383CA6C94086D98E8F33866666379662474707010B58112F20E761804C030794FC2246332737EED81C00572E6546D6DB05F61664DF4767377706EBA662C7D77C5EA8BCFFD5A656B8B66662C0DF796CFAC774AEE447075AF1085F2147C67631428A8E6303CBC6C776C04A100BC3DB384E77611E40F1402BBFC1F73747269F612228E4E032E44492600FF02388C3EE5A042EA52807D772E11EF698FB6D54B4443424474138585CD469251572B6F284F81E19A427A5853E0A6ED1D09D099D134045CE664A6A733902C539D9C0F9488259F5B6282ED47725468699A4D2B64D94A5AD539AFEF6A3B03C3126101758B8D0198539D4F663FF80782514DAA27484249544D4150D54B2C33298DDF738DE144612C9B2F97F62140CEB19F329A01828A53DA6F8A622BD8DE8762440024659923D5ECE12B84771D525E49274125145C5DC19955759D2E86D780706E896D48088F05AB086768358861826193A4987570E9530D0956608830350B0A3F9F8A6A6C78613F5F585C15850B856F5918DD0F0D884244405A3ED7841D040AB8BC083B9B193E088B0ACEC4405FF732FBEE4A40310859693C30A1637674C041C06F265744555F4D628939E0C30DF73256306C355ACF04B7124041FDDCF3F075616732BFF948A15F68C06312155074FE4263B5B76BF06C435F4E465845C1BBE093A8226F798741450809A339607478615B8FB63696F9256DB35265C02327CD74687742436E645A6180631361148D5F17DE6E01C93B77611555B80301B65F7008335C66B70B2C2F795962C07AEF756F0A38FA16324040280202BDC1C0C2D3B06D90C03FB8CB58954970667840120A9888755145EE28821F193F3013497E800297CDFD735ABE97513B44DA82471C812951732056834E08119A527464CFAD62D8704C5D5845C188083CA640DC871B2A4E81D8236FDDECEC5815844F73E53342865539F77DF42520409'
	$sHexData &= 'A31970206588D1827410A420309056295B8E0488977926E7B180630259A90E1851544B770F96117A243CCF1248536C009926E5F4A582C288E54600C85695C81CC10613155622BD89B6DD77939A07DE15F3E40815894A8AD1026852A8A4D58D06F7738796365A684BD654D8B58F88303264082617868E4E42A8E6D4D41482E283A78014D3541BBD5826E9350824020C81331EF3241C34C4548695C650E04266881584E4DA36813CBDFB951EC2AA2E76F75AB2668C036AB304C50368169A27012D73142B5B305793231B76A17B503E48548836AA90A8E4A8D853A8E4AAE4B4DC1611FC5114D676F6F1E471C1146D1B94EBFBBA8C6665F4761747D535E4CF7AB534BFEA2566661632E016AFFA66E25340F756E73686966992FB04137FD48BE33B84416B49FBB31260F976F758F807497BDE69110AB33D88205ED696EA9390E2115B6030BA74BDB426DB810776179BE6E6F747640BB8104170CDD5702ED0298404348E758A890F202605F6F665F2324E802F15F49806E1C27F83618D8FB45305A7908600388BF29E26A0BFD815880E3B844A73809670103DB1C73B1BF43341238C1FFBC8840226DC64A231A6175340C3B0E107173A74838F4078D546A5F437070C3222B5C95B730617029B9A50BDB3331166B0D72A395A0717547859E0432B36F0487C6A17009572834F6A43B4BA120442141A6A561E01BC45E4F09B8F152DF19B86084388853412360BBFD697A496E434B5F11701AD869A73B3541E85856589502AB91611B270D42B06AB065A523589859862006B271C0D56AA3DC70A6556E68C8C0C50E356445A111B036805BFB01604E04305FA15B27E0749125F62D8F5D37B3E8B05B31C5362961A58467572278A3473F4576E032670B01B74119517985B0A1D8958781587DA25D01B865A76483DAC1013845177E9584C08689573E6B49740A42B5A73887138B8A152B2BBD80702C9248D31B47734A183CFA64C7A16804B210FBA16C05A8F5407080AA7195813342D913C66903DB048A64770674457742185D6B9869676E25805D5DB7463E284FD8419847BF22980256E00819BBCD008DBAD8409758000E2C8B8179E458648817C07BEB646F77BE1D60494E805AB3732956602BAC60918145EC4368EE642F6E1800D973235C2E794D6FBCAE350C1836739B541C3504E608B11852EA04B48B0149734C503E58B76AE679D753316D6F75BB043CAEA66553AFE190822D3257FB410AA04D33D74D1072D656E03C05B684D80C7878B41B83076FF1BE5073330166CF0FD4CAFB5F6B1D4E10BD5F64F5DCAC53E05F6C743B433E3463696608DB0438CC5F726703A9858D576731A50C784B322A704AD060EC9C80E154EB1C38602ECCE87A1F53606F05120F668895354503E540658B4698304847'
	$sHexData &= '7EFE9DFD340001F28C67081010083808C56E7EEEF00027211D1808800D0801811C2039100820086023625310591DFB4AE51FF01801180888188820A810F09024FEFFFF7F30B030C030F0C00190F07002F0080138F0E001282830A0C0C04048284090C36F86FF3620B058385060A63A7001F0380228D89BBBB76B01302830500E4017F020026002EDFFA96E4220017046961003306050704038307E60BF5BFBBF609CB05050483048F0D04CE05E0280500C980248F4BF04840036648606004FD9076922432116C70097F5AEFE0B020E320056024A012726F2EC60E20010218001109D766CE4060679031E0463DB50D40ED4690D2A53596A1F156FB6EECAD45E40C1D00E9004766C4CA65701E01EA91497A074D56DD9CDA1FE28C0B6028F012AC58E4D176F6041676C6F1160CFF34C02D0F7043357CEF5F21E4DDD203A2FA6F0F907EB3900EA5A874CB7D0ABD3DE6DEF40042E4D186A034E3E993A79E44403A7D115C0E479DE7007304EA0248278991AFBE7D1539F0E7CF2BC6159D04E06A617D27766580293653847E077F2C9F34E04AC27D27F42372409FFBE00B5FC0F7CFE0300002A4992FF48894C240848895424104C8944241880FA010F859B02000053565755488D353DA4FEFF488DBE0040FDFF488D87C48C0300FF30C7002D439280505731DB31C94883CDFFE85000000001DB7402F3C38B1E4883EEFC11DB8A16F3C3488D042F83F9058A1076214883FDFC771B83E9048B104883C00483E9048917488D7F0473EF83C1048A10741048FFC0881783E9018A10488D7F0175F0F3C3FC415BEB0848FFC6881748FFC78A1601DB750A8B1E4883EEFC11DB8A1672E68D4101EB07FFC841FFD311C041FFD311C001DB750A8B1E4883EEFC11DB8A1673E483E8037219C1E0080FB6D209D048FFC683F0FF7458D1F84863E87238EB0E01DB75088B1E4883EEFC11DB7228FFC101DB75088B1E4883EEFC11DB721841FFD311C901DB75088B1E4883EEFC11DB73ED83C102EB0541FFD311C94881FD00FBFFFF83D102E81AFFFFFFE960FFFFFF5E5F5889074889F7564889F748C7C600560200B2095357488D4C37FD5E565BEB2F4839CE7332565EAC3C80720A3C8F7706807EFE0F74062CE83C0177E44839CE731656AD28D075DF5F0FC829F801D8AB4839CE7303ACEBDF5B5E4883EC28488DBE00E003008B0709C0744F8B5F04488D8C30943404004801F34883C708FF150C19000048958A0748FFC708C074D74889F94889FAFFC8F2AE4889E9FF15F61800004809C074094889034883C308EBD64883C4285D5F5E5B31C0C34883C4284883C704488D5EFC31C08A0748FFC709C074233CEF77114801C3488B03480FC84801F0488903EBE0240FC1E010668B074883C702EBE1488B2DA41'
	$sHexData &= '80000488DBE00F0FFFFBB00100000504989E141B8040000004889DA4889F94883EC20FFD5488D873F02000080207F8060287F4C8D4C24204D8B014889DA4889F9FFD54883C428C6053C000000FC488D8E00F0FFFF6A015A4D31C050E829000000585D5F5E5B488D4424806A004839C475F94883EC804C8B442418488B542410488B4C2408E9110CFEFFC356488D35C849FEFF48AD4885C07414515241504883EC28FFD04883C42841585A59EBE55EC3000000B82E0480010000005838048001000000C49C03800100000058380480010000000000000000005000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000700000000000000000000000000000000000000000000000000000000000000070000000000000000000000000000000000000000000000000000000000000007000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
	$sHexData &= '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
	$sHexData &= '000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000672E0480010000000000000000000000400100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004060038001000000000000000000000000000000000000008877028001000000987702800100000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009CDB028001000000000000000000000000000000000000009077028001000000'
	$sHexData &= 'A077028001000000A877028001000000B077028001000000B877028001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020010000000200000801800000060000080000000000000000021B003A9000001000100000038000080000000000000000021B003A9000001000904000050000000A4400400580300000000000000000000000000000000000021B003A9000001000200000078000080000000000000000021B003A900000100090400009000000000440400910000000000000000000000A0D00300580334000000560053005F00560045005200530049004F004E005F0049004E0046004F0000000000BD04EFFE000001000A00E90703000F0003000300000000003F000000000000000400040002000000000000000000000000000000B8020000010053007400720069006E006700460069006C00650049006E0066006F0000009402000001003000340030003900300034004200300000005E001B000100460069006C0065004400650073006300720069007000740069006F006E00000000005B007800360034005D00200049006D00610067006500200053006500610072006300680020004C0069006200720061007200790000000000460013000100500072006F0064007500630074004E0061006D0065000000000049006D0061006700650053006500610072006300680044004C004C002000780036003400000000004E001700010049006E007400650072006E0061006C004E0061006D006500000049006D0061006700650053006500610072006300680044004C004C005F007800360034002E0064006C006C00000000005600170001004F0072006900670069006E0061006C00460069006C0065006E0061006D006500000049006D0061006700650053006500610072006300680044004C004C005F007800360034002E0064006C006C000000000034000A00010043006F006D00700061006E0079004E0061006D00650000000000540052004F004E0047002E00500052004F000000340008000100500072006F006400750063007400560065007200730069006F006E00000033002E0033002E0030002E00300000003A000D000100460069006C006500560065007200730069006F006E000000000032003000320035002E00310030002E00310035002E003300000000008800320001004C006500670061006C0043006F0070007900720069006700680074000000A9002000440061006F002000560061006E0020005400720'
	$sHexData &= '06F006E00670020002D002000540052004F004E0047002E00500052004F002E00200041006C006C0020007200690067006800740073002000720065007300650072007600650064002E000000440000000100560061007200460069006C00650049006E0066006F00000000002400040000005400720061006E0073006C006100740069006F006E00000000000904B004F8D303003C3F786D6C2076657273696F6E3D27312E302720656E636F64696E673D275554462D3827207374616E64616C6F6E653D27796573273F3E0D0A3C617373656D626C7920786D6C6E733D2775726E3A736368656D61732D6D6963726F736F66742D636F6D3A61736D2E763127206D616E696665737456657273696F6E3D27312E30273E0D0A3C2F617373656D626C793E0D0A000000000000000000000000000000D4460400D4450400000000000000000000000000F6460400E44504000000000000000000000000001B470400F44504000000000000000000000000003A470400044604000000000000000000000000005B470400144604000000000000000000000000007A470400244604000000000000000000000000009C47040034460400000000000000000000000000BC47040044460400000000000000000000000000DD47040054460400000000000000000000000000E747040064460400000000000000000000000000F34704007446040000000000000000000000000000480400944604000000000000000000000000000D480400A446040000000000000000000000000018480400B446040000000000000000000000000029480400C446040000000000000000000000000000000000000000003C4804000000000000000000000000004448040000000000000000000000000050480400000000000000000000000000564804000000000000000000000000006C480400000000000000000000000000724804000000000000000000000000007A480400000000000000000000000000824804000000000000000000000000008A48040000000000000000000000000092480400000000000000000000000000AC480400000000009C48040000000000BA480400000000000000000000000000CA480400000000000000000000000000D6480400000000000000000000000000DE480400000000000000000000000000E64804000000000000000000000000006170692D6D732D77696E2D6372742D636F6E766572742D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D66696C6573797374656D2D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D686561702D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D6C6F63616C65'
	$sHexData &= '2D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D6D6174682D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D72756E74696D652D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D737464696F2D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D737472696E672D6C312D312D302E646C6C0047444933322E646C6C00676469706C75732E646C6C004B45524E454C33322E444C4C004D535643503134302E646C6C005553455233322E646C6C00564352554E54494D453134302E646C6C00564352554E54494D453134305F312E646C6C000000776373746F6C00005F6C6F636B5F66696C6500006672656500005F5F5F6C635F636F6465706167655F66756E6300000073717274000061626F727400000066676574630000007763736C656E0000426974426C7400004764697046726565000047657450726F634164647265737300004C6F61644C6962726172794100005669727475616C50726F7465637400005F4D74785F6C6F636B00000047657444430000006D656D73657400005F5F4378784672616D6548616E646C657234000000000000FFFFFFFF0000000092490400010000000B0000000B00000024490400504904007C490400901C010090200100A0230100B0280100A0280100D01D010010190100601B0100101A0100401F0100C0200100A9490400B5490400CF490400E6490400FD490400144A0400284A04003F4A0400594A04006F4A0400834A040000000100020003000400050006000700080009000A00496D616765536561726368444C4C5F7836342E646C6C00496D61676553656172636800496D6167655365617263685F4361707475726553637265656E00496D6167655365617263685F436C656172436163686500496D6167655365617263685F476574537973496E666F00496D6167655365617263685F47657456657273696F6E00496D6167655365617263685F496E496D61676500496D6167655365617263685F4D6F757365436C69636B00496D6167655365617263685F4D6F757365436C69636B57696E00496D6167655365617263685F4D6F7573654D6F766500496D6167655365617263685F684269746D617000496D6167655365617263685F684269746D61704C6F61640000002004001000000090AE98AEA0AEA8AE003004001C00000058A8C0A8D8A8E0A868A980A988A990A998A9A0A9000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
	$sHexData &= '000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
	Return $sHexData
EndFunc   ;==>__ImgSearch_GetEmbeddedDLL_x64
Func __ImgSearch_GetEmbeddedDLL_x86()
	Local $sHexData = '0x4D5A90000300000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000000100000E1FBA0E00B409CD21B8014CCD21546869732070726F6772616D2063616E6E6F742062652072756E20696E20444F53206D6F64652E0D0D0A240000000000000078D41F0D3CB5715E3CB5715E3CB5715E35CDE25E2CB5715E773F755F36B5715E773F745F26B5715E773F725F34B5715E773F705F38B5715E4534705F35B5715E3CB5705E2BB4715EB93E785F3DB5715EB93E715F3DB5715EB93E8E5E3DB5715E3CB5E65E3DB5715EB93E735F3DB5715E526963683CB5715E0000000000000000504500004C01030064D907690000000000000000E00002210B010E32004001000010000000900200B0D0030000A0020000E003000000001000100000000200000600000000000000060000000000000000F003000004000000000000020040010000100000100000000010000010000000000000100000003CE80300A001000094E40300A803000000E003009404000000000000000000000000000000000000DCE9030020000000000000000000000000000000000000000000000000000000FCD20300180000000CDC0300C000000000000000000000000000000000000000000000000000000000000000000000000000000000000000555058300000000000900200001000000000000000040000000000008C57CE7500000000800000E055505831000000000040010000A00200003E010000040000000000004CE7D07500000000400000E02E727372630000000010000000E00300000A000000420100000000004C27D21300000000400000C0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000332E33300055505'
	$sHexData &= '8210D09080A30A9CA6F41C6E51436BE0300B0300100007C030049090006F73FFFFF6A08E8090232046800026810C7400400A3000357D0C7000BDB1BF63F36353B83C408C3CC01B92CF8640150E9A67D956C4041593DCC2B70974BAE2DBFD0E4E492834C20B069006FBBBF3F558BEC6AFF34508564A19950510C03204033ADEDEEFEC5508D45F464A325C745FC0D6A1810F03621F767FE834C0183C404890089F82150C7050AD31DD2BD5857135C607FC63BC8EF6E02B941506A103F64076808135079B00D4C0E803F4EDC7C30C1BB055F91048B4D08890D8B598BE55D6EC88349838B50A26B07F6F63F589E568BF1FF7604C7063AAB34FF150A86FFFDFF73908B4508A801741DA804750E5623788BC65E5DC27A7B3B7C052056E63ACC6423FF3141821B9EF66CC39F83EC082789925D6BD070B80CF8218D0C50CEFF7CE6FF9F6485C074038946081D9C270F57C00FC383C5F611008B56B24DF83A1889486667F0E07650085E1EFC33CD6C313EA51BF060C75AC01E5E21CC01FF7198584B5292015CC241B8FE20512C3258389FDA8D4D14516AE076680B967510040C5A726CFF705D50F0AF5230872483C9FFDE1C440F48C13F52B081DABFE4E0C458C489442454F7BF17FC5666895424162A8BD18BF21218578B7D083905D0B7FFFFFF24744683FF1072410FB74C241A660F6EC1C4E27D79C0C5FE7F6820C5F8DBDF7DFB770F1F4000186F06C5FD7521FDD7C885C90F85FA03A9DBB4EFFF83C01083C6208D48103BCF4E76DA12040F8734DDB6B6B540BF9726080C61C00670C800996DFEB6387726101F4400000F100675C10698B66BDAB6EAC966A0752F9808105C4A76E02EF8B0FF937756F30F7E4FD084D28B681C74409BE17FFB67B6C0BCC9D1E903C88D044A5FF4D654336D903686CCD5352A3BFD1FFC1F8BC13BC77313668B743E3934428D0C42741840D95BCDB02472F23257205C2C341D56AC251FBFF810DCA1B5930C5680895A04B81854AEA135C889C008C53530C3307814F884C99F029B185676B883F9FF9D0503C220A385FD617076DB7A1D7739C7A2E66978D85AFF6C667F7E0E8402676895E7C8C93BF41089C210C333720C8FD87D0A97F861FB6E61D180FAFF740EB6CA0808F7D1C1366C78AE0C672C044E94DA920FBF701BC083E0FE401F0C5F0DC9302CDD0C1A0EB7EDCF716DB70C4606144266CA759BEB51AD39BCEA5C14F365DF166CF5A7D68D460450E79AF85ED6006A23139C06C220E172807DB4BDA5BB5E8B4904B8269B283245C1C3BE66D9857F7877637CF2F6D64BB1CB82640B6A58C155852E6927B6018D417201598160B0A87F32B0221DDB3DBB4C04F03C5B9B204B51A64A30D96D70D01F68D89CE080C1F1562038320D037615EC4B71D80B56535081'
	$sHexData &= 'DBDEDC56AD61B6DF5AA840E4423DDD1008C0DA3705E35089DC7B7DBFBA661F0CBEF4AA060C90F7682928BEC072223EECCC1F62ABE170320AA57F7CEF4A0604682E544D283525390A7F38D2F9EFFF563CF07D704DFA0A85F6792FF7DEB8CD52834DDFF582E996E6C1EA031A9203C02BF03430B7C3DFEC668931544275E083C1FEB82D202001EB20816F186A59511EFA50518BCFA2C015D8B0751CBA8BC75FBD30213F30BF0CF48B0EEF7F88B88D4E04C645F8019CF41C3D6EB80C0F160109B28FAA28D6B076C3211F0E049089AA8A5B077EC271042970B06684CA203244F8A103DF8B550C8910BC039ED8D27A083F018D55026605B85108AF52FF50E275045406FFFFEA8B5604163B4A04750F8B003B067509B0015E7A81296CFB8032C0117F7084F757E13374603B42828B063B450C75075C27D3836D59E98911DCD2C0FDA00BA2844B538BDCF432E04DB504A4966B04896CF0C9D14E6E05785342202EE93A1CA3115040EC04377CC3BF1B8B532085D274C273248D4B10522BC283C5F6FF86F8761E83FE0F8D42028943200F472A66A17081FB7FC798120411C644110200EB116A026823F0DED47C34E2021ECD4B7655D4FF738D683018102A14083401ED661B7E1E837DE8084DE484148B4324C220FBD9FCFF2BC6894DEC51523BC87725837B24040E8D4310421D864E370603F056DBDAEC72C43F1BBCF60CC60406CE0CC0512AC54DE883F90F3B5EF0DB76283ED44181F900107272128B5058C12308F06F0764C00EF81F77478BC25150AF3EF0374043C70F1107C7471061E6802DCDC414142816F0C554C21E6036135F3F80557CBF8BE35BC3B9051CCD29DDA74432D49F141FF87E37C924539B4DDC8975F857068B7D38989AEE745D0853BA07BE7C7007D36D6EF00FD43D005A538301CC4C062B88F484370C39A661F041DCAB800C212D879E78D30A1E7E10C65F895E0CAFC0E0B1E9A45E5BDDF90D6D875C85DF2420D01056E8AAB0A02218908BCCD6340750809335FF1A5F4CFF754C3E2E5CB0C0DE9A098C8BC8DA34791436028B09A00B833185BA5A1C5C08DA97B79A50C60828A77A10417B10A9298B3804ABDBCA4CC832086F4E0C8AC1262CF824895610B3BFB4C12018C80CBFA813AFC141D174046F7C100CC0C1A3CFBF1A0B3CE2F5C85010780C1DE3293F75E90439C00A108D47260706BB0518E22127AA2C4905B7AE8246384EB0470AC7894F40071BC43E2A5F6D9F9223B1C4B2A59F9363C60733DF316A2026C3BF58B80EE4029B9C515670E86E800E23C82FD08BCAFC4AFB72D3C48806C7468D79011214F4C5AAFF8A014184C075F92BCF9A8BCEE8776C5FC8691060F0BF33A84BC9D3CA3808FFA4D21439555F42AD5A10E10AE01A327B4534341D544AE83E516EEC2A4'
	$sHexData &= '54600FB5E360E9ABC1FAC4EA5FB0681DE4085C974085A5251EB076A0DB00B52D0EBA7BC21CE97911E0F050777EEE83D72302950BA1DA0F0C0E42A58AF5FE0B782D56AD1AA4E85B804893E161C1AE2EB1B5783AC9E2E750B9BFD05CC22FE9A8CEB0989061584FB50810D075F99FF206482E88CC35F0FC2E7A2C47FACA904738811AB8D3F0FCC4484D86CF6D87EB3BF84C45EC9A933C0215878E0C28684119B8E5061EBEA70108A6A1812C33FB006FB7F481481E1FFF3FFFF81C9AE68891C90CBD086103FEF20CD955C8EF90883047C051E6423FF106AD957895DF4E9D33B5E95D4E0F88955FC61E8FC02DC36188BF062FC8BFA4880969800751CE2BFD15FCA18506A6457F7415C89038BC38953047A7E3BA2AA5B584600366E01754D49B72BC42742453F24682B8BDAAEB7EDBBDF53506B2BF029CA9A3B1BFA8F49526FEFF8B650653B53C4F8EB3A5393407CE0D9E9ED8BF35B3356517AA27568A31D54DE514C517740FA16FCC12776450384F413FA8978508930E4A21209559FD4A7417208AB689FF3D414E4430D9D750889DE07F82AC5FF7610E8FFD0561E01EAA870373DF80D1076821883913F10566041A5C252EB7A080C8023D0BADA56C6FC490578601DF81260897608AA8932B314075C7531AC7E074F510CCA2797E100134C0E6AFE082C0503A682E878F0FDDFA4C1143230F1B9001A1601AE0C4F99969A2A15BF6AAFE0519516E6162865B42BF833C1790F837DF8007466122CEDDFBF37AB0DB4748B0C887858483B810C267E2DEE015A746F48759D80833D1B98B2581D70175267D03F9FB5D9E14C2CCCD1045830DDE3CD789E90D1741320B3308207A45357F6327FE5CA5C25F806E210813DD2819F95A8D4797460C0AB9F435DA8AB0207085347D96B13BE4B42F88D4F088701CCF0FF1F16A3A8085F4E4382F301407E8DA5BCC0C7730C22EC7670D437DA1D0F5415B6F82C3DFF007F7005EF56341AC84F6E662F32882CC6CD617AAFC864E48939F6BB7E07CA00837B3C3405894B3CEB0658DFB3F8AC40704B40CB94FFC7ECA22FBA3F807DF300AF16F1721C34C47B41C18D5FC6CE4AF00FB10BC06377DC75E74DB903E7C62B3BC60FD283FE0247C515FC75478D7734565B7418057D67F687E0C863750C486A0689182B56C6F1A482EC476401F3FC0C331CB7863F9E83C8FF2604B4C101484A3B0622CCDF043B5BEB21870C0DDF8D0C6A787018A9C000B1E0900372178B17423C14E20DFA945133D2C03938740A36C17A06813E10F1EB749D03894A633308202C6CB8105340E0FB10A4345072B80282870327058AC1A29CC49E10EB3EA2388B07CB42031777B9FCFF19BCB9F38BF085F6747283FE037707FF24857CD8A7D817983D3BF0745CC7F80374509F607851037553F3'
	$sHexData &= '807F64008386EF0FE475168B1D56E456F6D35E18467077223174F05619EDD8C15004A9900C7B07B88608113F51C1CF0C4F078B0ECE103341050312E009DE04E981204381415FBDE8708B067C8B06B48235684A9592B0CEC10592E744DFAA1404282688FE50578D7E2857F547019CE13F1947837E64027D1553FD57560D6776B7277CF35B8DECE2C361C70D6EBF7179255783728BC7131808F05C4604FC938E1827BCCDFD7E084F75091B5CFF60675F2C79FED451A111FCCC53720A465FAB688300392AFEC104E90901492C1FEDF8D001BC4E24E60613A8ACFA7F8ECB2374158B113BCE0F9518B6C0868EC0170A5210C746244728F7C38755916B3F313C0D0C0BD8278940F85CAB56A057B7BF30BB481E443CDAB0D03642990FF9F8CF12A1FE50EFF0C747B93A33C98B5624EEFE9D507C0C8B028BCADCBA894F2483FBFF7552646838EF4E6202414F4A4E2E19CF4757AE58A4C4DBCAB61345E80337C0173EAC828A40075A93D0DE8B56703AE8236C9F670CE20357680619A0F71EFEC28226EB089712CCB421F00EE43AF115071B5703902A3D3F44061E2C9060D3EC84185A28317F805FBF03085210DC0D91F4CC245AEA4787188D4E7A4EE83A0F60CDA3D0B5C74088941F84EC3896DB70A20C500117E28D44F712786CCCF4063C099CAF44D520DF98D994895DF8569A13DE7006848903C743ED0C0886DB0F460C5141082B8CC1F802F62D78AFAFFC4C34373F773757944B0443D69AFFCEFBEC8B75FC8B7B46047652FF4618ABF85731EEC1FE028D0CB7894B7C2950A1083AC31562A29C921D5E35BF8B09C37210538FBBB1DF105292D2F4EA3057EDF4160C8ED59E215F04660E0884466623EDB17C46303838180D1C5CB611463C9A28140240D140998D440D4CEE061588F1CD407D1083CBFFF42C14E63D65A4425054C458066865F71D8186E4DA86943B869C9D837C3F4F7C00218086A08E1DF29DF3780235A4A813AC676A3E5804FF7441470237C977D7A03CBE33898EB04BB4592B6C85677534651048B0EC2ADC1D087525831C79751DD20C4898EEBCC0E193438E13C4B889B6C8830138FBB786CC1D46480A43C8C13B18521EF51215438511BF185F084B35F81713148E5B1A50FF446C821193A01B4BD261D5B6D880C703DF83F9E40FC6E027F355178D8BBC858BB34586EBCBC9141F0F169D82E99A1D08117362F64C0352745BDFCD107D2583108965F05E03AE6A078080B600D6507531DB7046BC7A4DE43E189CB3EB102E98BBFDD22047C31D8B613C16F8D9BF6F4D837E0C7C0C7563EB06518B4E0433C0D0A5826F20040F94C040557EE554B176DD21FC08201EFB5682ED176C5026261620DC26F3BA6E81CC2F2CB07D64A320B04FC81C6C17DFE20172C8451F304DE03BE5288'
	$sHexData &= '62E848B30DE8D8168C19FB9B857D89B9C6A28FB80A7F37FA9D8895DDC8D73780396EF11C0020D04010D08871A5C2DF790F888D8DB06A433300041400CF00E0E0A02C8A0039650D7EB52B339A9E46C045DFCE040FC0CAA50E4BE6A664E04FF551F77E0038AE88AD873CF164EFE2808217ECCC38AC382E21035C58379401C72E828EAC33F455514E4177E81837D0CFFF64DEC74C26270752E683B2909372C1801648B89B05CB0CDA636561810188B4F8D22C04E78985A37B1C723FB4E2268C30B7ADF752111E1C8C4710345E851C82B00B25F3F4595D6084C323457BDC1A5C50DD8B24026F8461858F1CBF1837F041C592BAA0C44FA10FE3E16EA57D5A2E006F4E87419A852776AF805C360E919E92023F88B118D413DE49DA4E6A43652EB6982E1B8150AE8108D8FC84BFCA8010A850F56461498F8601EAEA9400CFA10B80832C07AD5F0D1FCC0CE74F2C4348BD0ED1E566F391A7C02A61CCA403B6BE04788C8B1EB095056D83A0C680D000CD0EC028CCE435F0C68C60977084E6A0DC0803F79218F61143D9F460689EB71C848EC92C5058D8082D97CE00155760BA94F2044F5D7A7B423F0013C46DC54BDA085532372037ADC8B7008FC3B84D73C37C912003BFE7550381D2C18F608FF33C95A0BA2558CCBA825FEC515E713948955D48D7A08C62878F54E07208B4845B49CACB8D6FCA904AC4C8955B0B818D889B841D1166740D0BE04288BF46C83CCA840E0074AE44DD0ACA0600492D05610892CD2BB1C18CC8805E8356F405A3C4824DD79ACE92B934B8A4CC8C0D808C6253C90D824E1DF1ADC18F8401F2CA30E68D004BD00460CE33F0F001A610E75085B6044C807ED7D5F08203C648E1F5D38531AE9324179F001492C5E08073B331A0B22BC52A9AE861D52242F30B127F0E71B1CF075F08D5EAF19300CFFD0895DE4C743D305825CE3B39B85537E2C1C8977DE118F5D403AB9BCE62E310AADA93408C2D2E8569B9162820CA77FF10182934651B9F18D4E200856AD9F5D4E10F7DD8B0BB743994E0CFA4D11159E13558B7604F30A603523FDDF482BE581B58D4608570023A56FB4DF08700357037338BCE063A8255ADE82032194001E210AF99FB0A36E84C6E403771FB5288C974B77273E9C14C30B24405CE079DEFBC333C0C3903E7006767C82B369008E5F14F8EC27EC226660F9D88D45EC9F1002A3E438DF6720245710FF773424649C68520C288D41FFDDCA970E0F482A00BAEB130D248141E5CAEB0C40EB055C9AF0AA06AC413B6690550D3C353FEB2F51A13CCFFB4E0F1F402978067F868D1408EE0D9F196AC37F6201F00B74F22BF1D1FE57100F8CFFFFBFAA0C2BE0018BF80FB7D883E0DF2D41003A00C1EF1083F81A730AED2514328C91C3205CBBBDB5DA7409082F'
	$sHexData &= 'FA60C776047C6466FDB51F6D59064406EE83FB3C072AFB2F754EFB742EF3347412DA6705750432DEB1A76DEB3F227902F6DF2B0E4604E97F376B3F58082E740DC6FF3F7510663979BD4A4AA0220A442BB7C05B8EDD6A967C410E73341A15F183CF2B7426043BC27421FECD9B5BB330EAF92E1583F91083C00275A5665C8CEC19C181E620F31E0A2A1C78403D7FC7BAC9E7057507B7563F72CF666E82FE1CC00C83FE40C2FEEBD7C046E28BC25E31DFFC9782424EEAF806723BC70424A07BBA7D0A701604722FE6BA196A0CFCD66F0E040CED19E00E6178BE4008F7F106B001FA45AADA4F32C0EB9F1A96C305A1F0A0FF18532A7495F0BDB3F3837B14077C338B4B052AFCDF2C4DF88D14098D04328955F05640D1ADE1458BF851F8E72DDC06E56968B87B0F8325837DFCD016B64678D21E41642D25102F7F14DD15E05D7A897DF876920FB4D18BCD5ED7B647C85DF4C241BDC33003101C34DD033C6CFC55ECAF828BD6E6C061A7E819B2FC70F21F0A1C6276F828E8AE342B962D6A6F24C6D1FA3B4A550042C270ED3DC270F235D52D7E3B753282DB82E676110F870B44E8D8F003EC3BD3B7A2820731F65C0237209C06EFEE397710612EA5E91AE1164E1EEC361C010C3BF0672C550C3BFB0B0537EC152E9A611B961497696717DC2B8BF78E1F37524AA4F49B8985D3F033C966890C30AA81304380DF22FCC0D67E20CFCBFC2DB10F0BECF78B4310B757144EDA77327C83DDB061C3FA0783500089805653510C6D08B9C9F850C589FC3D7812C2D47F71076570EB4FD3C8502D1E39D46858B852D9F442EB0E4240FE37328B77EA9A5E20029A3BCE73185601EA3F1845CF7F7B3C485CEB106A7D383C825C9D908CC81E2BDA2C2ADCFF662BC1D1FB3BD87738DDD2199AE03787334480451C1B508D0C4E521B90418681FC4652AE856FEDF38BCF53AC8C2F1EE1FC5838E4885F18145DA431B104075622627C240CA12A2AF8D4318B4164CE9A465DC5C201AA144F2BC6340C6D648BEC00FF7408D48D54905E16148063E17BA418DA78AC5B55844B621689C3269908821FD0FACE40600C16942BA532C951041F1410072A3B95E3895CB4EA20391F983A2ACFA247DE242B2C2BF27C9986F015FECB89447488C11617C31EF78D21A7885F46B5AA0283D207A7B64B34E3651668F474AC50688403B822F10190106CEF80100E890AC741783C6ABAFA958BC14035B47E8F365C5B6E389AA48955B4AEC4725FB50D66F77E45C880751533D2BECDBEC070838855D88975DC922CEB46854A4556C6B8EA5046B61B4F9E7948DC8B38C4E95629253928BF5C854744C402916A5E55C8D6B6B78ADF98D0741066833A6003863A83C2021E75F0883178F0EB043146663CF0B7B463690CE4336068980E1F231'
	$sHexData &= '1395F55E0931600BF4258F02BCA5152560735DFE00B1EE06A136A0021E13C8B45C4B4987C74A366BF82B85E7B37682F056AF932B180D86A42411B9CAB014A197A56D87258192A83694D11B05187C75D35D64FB4B2DC5EEEA10966B1220AB5A98D463FE7ADE867304375E090E468E0897DC01FE136C03BC75933AE6ABF8BC6B751BFF883C6086A01DC9C7C8B387A50576C2D50257CD83C1C58842733DE82BD8896AF9C8014B857351505D30A78C43B6B2AB8B68389B1C0A5C19228388990F79B7D9FE0DA3BF7D5AB31E914A03BF225FB33156E321F406F5F5A8D7002345CE95E6174189F0E2F0C0783C6FF557CEAA42BD4F9883B7DE8741289D86C578C077C4FC983C7B20AEB58D320386A66C424B8724CE080FFC1EEA9EC364656EB3D397DE07406E544B7439428742F79188CBC4D532E8647851275A8BC1FD670A177C9ABB46ED8C0BEE908223B4C85343B228D79F0C3C4F019297704FF3761340A3C3B1C647DC4740BC20C8971BFE27F2FCF8BF78BD710740E8BF88BC844B45BB76F50E8D02BB4C1F903D6722BB5C3B0C044607525E972F404F06770F0EEC1A4C7A4EF6F78C2472A16B2ACB834EE6690F1053F0ED6B4756E84DC3BCA73575EBC29E9B1FAE95ADD8A807D5628528842C58314A65827CAE8CA02932E9E88462DEB5A8BEA3055552D24C02BC142B44EC4D7816F7A1ABA7735837DDC880AFD0EB4CD4E750618125072B48AAABEB90389C40345AC33FF263CF0CEB4B920D8EB0EA4B6B452C065083E85BA7677BBEC99C7850CA6487539D644BDBE54F883F801721F807001C9A1B95E66468DCE30DC5E04D11DBD084102EB0FB5A2C8C21C5AFDAD7DB0E68C3E70313162090110E563C2CB40BD1145D8F048530029079D7EEC0A7053CEE8C1F80382C53381FAAFFC4F48FB71FC83C2232BCE8D41798BCE5275BDD19451D8DCE4B5B0C1AE3835BBDC07762E9E2E0C4DC90423E1DF912E152A11699DD3120A9C8948A63945813589BF47170398400E20FA86D6DCC48848EAC80ED0CC100E9594E48CCCF81062B1D85010B0B82AD8D1D8E3B6B018D485D25337A9AE136F86E6007C138B01E782C83951E535C001D937A94DFB42E537A94FC83F9009DC51259CDA03C708E4164807952AFE9A534A32C08845A657E6B8880DFA03C133C96203C271275091E0073B860E84A8B8C4025BBE28FED0F5C51FA11CAE7A0CEB1E86B8EB03F8E74628FC67AAA5B001EBA3F835825B883EC275E435D23638B2060A74DC575DD4B4ABE9D16259DC6AEBA00BB9586BAFE691D4085246D404D84B9E087667E090E0D50E33D24D3561DF4C1441EB2057240E5DE0C239B8514FCE4A030C2A0AB08A6EC6B53D5A086F083F146D2D40263A043A6B217CB00651DA4B6F065E89BED5609FBF182D644826'
	$sHexData &= 'DA4604C1221410AB5964187CC371C439D5BFF088D0C415423C18C0E352FC065CE8260C54F410A0C2DF359AB441871C3BC8754135E2022AD2393FEF0756892D492F7FD308D5DA3F604010C3894BDC10C42E18660A8E6803102C1C4581E1BAE2A8C6630612F2D722C301D2504704160AE27BB51A30191489771C5FAF35C951D3BF630895F1B43AABB4E834C427D13404100C36FC014E45247D5FA8744793910683AAB024280027ADBD142A2C0C3C22402C781B173F888D4E4466BFDD26B8F84B0A0F45F8C741E98E10F4AF109414628955EC8A104084D2E1A54AB9A60E57A5A171AED0F1930C009F5F89E44047AB74EC3405AF2B7B0C5078CC141029C182805E1457CF9983C1E02BEADEB2C7E101ACC03DBBAD6C07AC3A1ED41E733AFC2CC0017ACB1A86BB1F3840622AC1548BD48D7F74088248C684EC5F8A08893E2C05D4C93A8942A25443E3BB6A508BD7823BAC70502013C989D545D424355982215B6C9DFCF84A603E580F8D4144A600C3A3660C755FFEDF8CD11E80F2CEB004B46F0C44B010638B0F791B0C63526AC142018007F8D4228AADC892301288C07AC1C317AAF04ED15082BCB25C1074016081C99F78799558F40D347010B8514CD406782834E0D5141B2E101CC49E0F95C1708D04A1E9FF3F03CE034DCC03C8394F1473168B77DECE36D21F52CCBD91EC7E56A8EE9002C0C88B530C166928F06E5E3BF07731EC06148CE4D73EA6B8E0980BBF1052B85603C152503BB8D1EE7F33315803C6C6040800EB0D5652AAA856B52ADBA7F1D48BC1C630ECC9DF6F7231808D46039783F90F6A0374DB15D8170088A1123003988067EF59133633A316A588FF8039A2164C5E4C837DE49CF4A43DD53DFA96C6337187C2A5A81ED2D7CCFE8507B5124417E48C89040A65A452D9A80A04048C04CE6C9C8DDAE882807C7036E10475E4AA844B4710D6CE17BEF63954CDFA0F66C758225A6A2254B5F1280DD20C53421C94C66E65D05B21E4D6BE3E78C6700083BC454841882C57011B871048DF3EFC46082453835C5F4206798358292C8B4644162110FC54923FEE31342B85479704580FC6209908CD8A40EB2C85022CE47F599289E4A49228143584052C10CDBE89800B8C26DB87D6841040ADA5E8202FBA9F483D81EC41481558D64575A835FAD10F7C67D818D00270763D021A695FE045D08D579E4BD85E8D70385239F6588D6CC16CB8851FDFF904568CC0839F0ED085F0581A479795A836960725A976A0A93A3C1475F6841EE8C0427250758D196058EB01012A2C1F444B429101B4E24F44F10FC950C315817FAD1A0E5632889182E00FDA415C5769271824360E8076E6870615165FCC88686962C9C9868A3A5C68C171E0AA9FDD3F78191515F8003A8B720454D8817626A9B8E'
	$sHexData &= '686D878FB8D464A0678BF702550A9925E2C0CB86D04F8BF3B1A57BFFF0A8B5610F6C2010F444AA850FA01FEC2C1E80AC22903B762E0C43DC0A0525FC70164D88ED00A393D03250AF16ED41FC1EA0483E201E65F891121FED73083EEFA38407711742683E8029B5BAB10C4E8A21C1232EB0D7B74099F3E9B1226746A74348901663D6F7857F9155F5CF0438634308B511C4283E003FFCC6A05143524D7563C037578F210B44D36107B338B411BB834019D30774C345A5E900A492CB4E7DC830D4E9907B895EBDC8E0FB6B6AAF5E11794C802EBCED1EA24740516EBD7F83F308C837934078D71208BCEE650F844D5C66A03C818FE921B1CA73A499DD210FADE12A087F412D6424CEA6B56489C7AD885EC8C80087C57FF4009E0434756B91C9448413C649043251F491544E0482C19F0C5218016ADCBD682C6F1F01F184010168D4A02668B02F4669314777FAAF52BD1D1FACB45873BA0A06D3A7DB41056656A64D0000E9341665456CB4DB033CE76D012C818AC20CC015112094E6DE6B0DF7C3F8053076F1CE2328B45B0E41105260F4580C0A0BBB519578222BC305ECE1AB69A7538440CFEEFA98B1F66837F2C2E75240FB7472E7EEBFAB56AAEF81A1628300075745363FF7F0BA375FFD7EB3F33F6EB3B83FE05750ED1EBF693D1E286C39E2FBE126528FA4F9182C123ACA6C824CCA68058405E4E49734284BBB94D0F45F13817D8E0811C2410EB0C50F0305223D76B40928B0DF03F00324CC2494D9F28833A64C0D13EFE421AA3EE0258240ADA421C062D067706BBE982A08B4E1C2C034620348643A1D5A6D1284A0C1470DB9DF116F04A04562EBD2C8D7A404DE4867EF2C78D51020183C1CA8845EC1E4029AC80D1F96861CC212E5228AD29DF48E047C009F2331F8BFCFF01FCE2CB8D1473D1C3D1F83BF07272837DEC522FE0093C310FEEB82D38BF76CC50248855FC27E04026921B9DCC206C4805C4CFBD238DF405813F3420462E1321303420C375BF40F881EC5CAEA5842E404CDC24581A8628DBC7ADA03373FF7638F5CA1274E8A28F814A7148152A7C243CAB346AA65617443E59D4082DD3506E918E74C771060496DE56C0AC0F8B8CAF89888A2B257304031366A258700DF1165B1570DE52048C64B597B50AA0EFD0D23FFCBF15420EF99F7D1457F6CED89A7A100749CF33FF1653E10BDDB2127640689E52FE1D782A8F1DA68BCB85DB75755168130D75228AD35BE9009D72BC46E82B43F18DD15416F6572A29A530DFFE721AED4660AA8456E36E1188751F281BFDED8BCCBC6EFFEBCA5153893B5DE4722D2C1C08F02AEBB7AAA850945A87CB386F8B5D8E71D07026969F196A0AE95CD1B6B06DA76F2BAA4349C0FEF80EE46BFD90FF3736002B7C01510370A22FCEFCD7B0'
	$sHexData &= 'EF093BD80F42C3BB2B12468D045D02FCAB804391D3891FEB5B6A0837EF834766F8435AEC804983FB023FA4E9FE72608D43FEB90691C1C8D98D56044BDAE069964AFE2C96522EC1EFE70F6A0E9D0C51997B4CA08914034F810D7F22AC1C724C488BF2EE0BE94C8408FF0CCA39A41114F62D3028E86C4BA5101024088B4D23E262FB8C0ADE01CA2C3C1207DA945E92078E481C4C5731B0662A239F0CF058D0A856E40825B4B65328602909422C750536A13316E94F0C009D2CBDA67674799F510CD87E344A5909D985D2831593964F7C9D34DFC00039E449BD38F1B0E84492D086C7421587C0EA938AC70243E0CE31F018E34DD17A3838A186CAA0534843801D84B34B9E7C7C004C2A7A901618C48C4D8FB63B07265F25CE30C8DAA19FB5760C0ED6108D3C46BE7DBC055402C7FF88CC1046E1CB86A8061B23B1A8232FF7B68975A400987474C83BF178C708D64025FCE6067C23CF739AA6DB6120F283FA73FA06042A840BE16ADCC6D0F8C148281246292C168CF6BB00488D7DD4560F47085181A25398ADB504A4167F0A1C5B8B66EB0E6685AC8C33D2C645BF808682D3EEC944B83F4D608260858C5E4FC8E4F952EB841C7F3F0C7476A940B02228CEA82BCA04EC040CDEBE0A786021B1E2F2773D820683262D2A03C18E0752450BF8D603A9470AC003C0505241105CB993CCC033F668EA2C109C2EA66E685152E6941B1C7F6885028439BA97530AFF178BCABC2A9ADB3F860A2383EA02741E0801741932DDDC6EAB2C8BD10C7B740D082674086A7403BF040E467878954C8C8827B02004FCE1FE130A81EB44D20CCA10A08938F571118AE8C74063BB93EE92032D8A886920896904BF2B39401E4B1C3C1C72A0411F4A33D0014E11CB45BD50CA5372EAB40A5CAC60644EF7A2855416392B4F637AD897497971FF1416CA4ED76291482C8B98435053ACB10704C4BA5DE00F1088D2A678A5BC47E41854878B53CF20CF37964E493F3A6307093E358B112208FB85C0AC77948B935FA1A0FB4707B34DB88873303C05C67003CEF33E88EEC9D37C1E2EACA0022F3CB2DD2F34002AB7C685670A4EA17BD659A0B6230C0D38AC1A98718B18B4073268B74762D519F94740302E41335BBED9679E854427340C6689E8A719BCEE89B547C7396312483E12A79D07444C7439B5B09A7AF5E53652F53F6E898353306C22B84B80BD67B462D3E78147D83B199FEBA5E049BA0839C63FCCF0BCF034CCB8033AB817DC2FBC0BF2D0898D60A917141867E2F83E2E11D70A6E18059603E97ED37EE1A63054E481FA38721DD50457F8749201880848EB5DCA0132B944C055906A1C46559B40F10474B2557B2C8995860E583C50E269AFD9374CD1E9F3AB1380088B2F97EFF228C0115168B5E105D07C3B51D'
	$sHexData &= 'B691C60FF089A21DC60881E88752B5A051E99BA73FADE21F40332730DADDF529A857117C709F1ACDDC0C2AF78B54EEE40F09BF939797397FD83BD5F8558DEBE0079BCF7FF75092D83F021CB66E6D7401CC25A1946C75DBBC3FA2D702BF8228D047DEBB868EB82815CE9398285C1AA7905800B6EBA4211288FFF50137426AB543A19BC551F1A0F20363895A7580E095B54A79010058987CE72E318090F71D9E5531E85F835600AAE554F8D47EFF92105837A6CC8F983C204088C30C4EF047321DE423CEB10F7ADF81EF544038439015C1C63321C2CFA1452EC952250CCAE0EA8F8BB7480B8A06C1B873A74ED5548549D8081CD5580DF0AE697D3B971B0B8C791910EE19D0CB8C8A8D93F8DC8CFCC3BD1EADE556C045359DB10E5706A95AB01CFB4AF80A1086692EC67B879A4292DC14D9C3F9ACC92C879C022E488F0986E225C709C2F88769BD451012C42D9C58B3060F57489388B2D02502007CF31C34013268F3E4DC1A93213B4507CC5167C2F32808FA40F868053A5A075E8DDA1E9167AD10678E4C55F4ABE81ECD40CEE8E0483655C118D38BC3A1BCD1304346840A96D818D99B96A003230A7D3A4C015323C1FE055C944BDC7412224A86F0FE3A51850AA4CD12C6A7E58CC2DD53A9C0159898ECC45C6021D382D7676B5F09398C78405A7ABC427A4E6BEEA4816419889840D6F8658A18DB49BB9FCDE58748690ACAD809B5F940DD810B05050F5958276D803D3706AC8F0A22002090C1E1A6DC0849F5022EA62D470F803C668A16C6830D122108521CE1CA9FA7D3C04247F8857B8406A3C127C6925FAE6109D506CBCE4C9EEAE8575888C1D27579404704280F8B1B0E04E019EF8107215DCAE4FDD659D6451043024F0E94D61A8ECD02401CF20FE50AF0907E3BAB951BA345EA35CC277FC663BC273347E20BF3D3A43C63E59019E466675E28D3473FEFF5D6940063B80BC350074313BF3742883EE02EBE5B2A7F0FE3A90668B169F9A0E83CAFB8B6B740E4405E166122726FEEB042BF3D1FE462B5842C66E2155790457145D1A1C65E276EC4241353332FEFE2E75158D48FFAF33072E07141DAB48978D517C48B2694A8C159C716CF53D9E54AC60718C92113C6CA43A7439A9B4E1DD5DA28D7168DD443098D7E44EB0676737CDCED442443294C34EB8BD8BCE2D5024E55EFF251FA2440CA5F5183540C9247FD36C3D6A48F610140FACD61EC1EAFF8A9B811EC8CA0FA428C1E00203F013D1851E20D3FFD27707720A83FE647205F6603215693561A04FC60319A9486F3B0974A0941AFE7279980B46DD2928890BC6B64077BAAA6A416E33FFBE976BC6643CC4A781B42B60223DAA741BFD2ADC683C47D1C6FA7CDF32C05F8886DC8BB5688BC321B0011F61AF19E3D37F80791ED409'
	$sHexData &= '5E91B4019207D55CC339800C15FF1857A4EE8CEE004047E83759ED503A1BA9EA51AC46ECF00DF400460333AF3173A899B03B15D42E0001A90AC8D558DFF0A48E1F9C283CC08D7D48C944B7AA0FF60FA28B7629DA5B89079CDFAF20DE464F0889570EF0017D10C605D6A800AC80505945474460EFEE54707A716961AEE1DD68C1E81A2480A26D69683D801BFF4B152B5A20C77F684C0A0A5B1A9B80947746535D3077E5EEABBE5C68EB3D0DA4EB36E8EB2F283F57EE9A9E280DA8EB21E0EB1A9F20EB46E5CA951360EB0C90EB05BC4AE0BFBEBB078CEB9FE8518BAF868D30C467E7504B0F874AFB5B957010FE2476C11B844010B8E4C740886EE411B1400899DCFDDC78C35CA21298404C56754BEB0507021CB845D89114CFF525036A239AD0130EC185775D2329E4C22146957D8E426E2F929BA0E8D208B154B0B542210E20E96CA770F25E870B5CDD92D4881A200505CFD016E188D37366B45B5AF33CCFF30653614C453E5AF43CCF373029221D8013D819BF7E1A6AE1DF6D2D1C7E13320FAF510C2B01C1F8521AAE6FB00310661881A1423F51FC0BDDC022EC4518041C8658E83A08E806D49A66209C46240A10080436A169140C1C4610E09ADA70F3A3189423B530B309017142C0B7067BD1560AD9DFBF814FEC33F6393518E076386600BFBBFF3EC0D1DCA108D803CE4823C813D4FFA67F7FD834886D504C8930463B6F72D35EC3DF4A2B84835085C5094DB2E04002E40DA64EFB82C8B5D4FDFFFF0ACCFBD7B83D0A217C2EB5D0FD655FCD8D85D816FE001EC050332F68483D0221E0DEE316A5601B8D8D3B4A974240053E51DCC2AC0EFD21802BCAD1F9023784CEBADFDFA6AE8D3409BF0E6C0F47CD6CB35650B70F16B1671FEB18F1FFF624DC073151B9630BC685CA7D4FEB3F00F2B4FF59BA391ACA0EA7AD784C223F89713F9B274D6A3A8B8DC82425891917C9B4FD5CDF4BE156E985C4FD618FB98FB1C144C067680D8BCE804C9CDA2D13E4F4F0DC3E8B5DECB810600DC38BEBA0A37595BBB2B76A68B47A1D0E0691ECC558556A51BAEB9AFF279297FC1FA9800075A03C2537600478CF09F8F6028C1AA889559C75423028184A1DE49D0D2B569262AC0FFE6CFF1E859A78C2802945AC3C10EEA3E595390BE7465E0DAC84C745B04E4DF8A86D6495087D3E0962CA6E84E4AE3374B4CCB34D98B784CA44808973DF8041A093919498843F950A960C2630E0605A81E150CC0E9676547D58B1D2D8147DB0A2EB0FAD808B3A3556068BFCFE7429E12F1C83BFB7AD7354A7D7E06E2683C702D0386480027F0B9EFE75E088237DE04B11D9A833473AE5CCC740289CDC364B43C363EB7658A89C20B474263D051AC8B4302202A00DDEB6C28D7DB43210CAA0A87D30680AFA100C22669'
	$sHexData &= '0FFE877A5F74DA88C507EACB7003795287AD93962AA45A8A195C6338E3BC05068AC57281500431F4CA11072902FF400049374730E048A4510D4EAA0671FA25D0C238885087F0C58A8291409804C5DBBB1E8140610018DE87BD2423D108D787720FD2D335443283D8D1041A60A8DBD3D1052B9649010100C28BB9E9A4C28F4835BB1B7B66413E355C086D40768D128A54E20E2F6C085D2CB7A0A7C8C2EAA74A7820FE9748BD6EDCEBAF8C2978DA5F01A5B4C413CBD9FD616A086D872E8D88BC877CC0595CEB17E9443D8ED2D399465CBD3CBEDBD0F7653B0157831CB28FF2820378BB5173374E83FB479FB31E545E06A0153874E74DF4514D91041831826F9065D0C999F30F5A51C2417624D3FC02A80418596115E5501ABB71F4CD0E043C8434001C1898518841D8FDA640A14231C67B010B22F9E8B7A102DB07B05F00BB2BEC59D1C8103720FB60C0292A951407BCE69F193AC0116EF5007D3B931202320D2489A8661881C30B41DB7B0F0FF20FFE490CBC52301202025970139201C389D1C72C8387074BA38524C36DCA0007F9F314817E4D019F0565930A9DCFD7CF482B4FE71ED6381757BC2F422316977A8DB85E41A26F8BCD578A9E72BED61ACAE856AF3A4CC2C0529C0E9026A5E1592D97679ACFC1021A9FC3CF7D6DE57A9F7ADF507C099263A0661AD3C39EE7100361C7A2AF80F9C4ACE006FFCFE6A7082102C42814D3FB2792F419F97C009E0FE414E901CCCDCFE4933727397C1CC0AF81C324132E4F4F893342393E40BC8B40CA753218BB5DBD276426F0A7B6A45D4E4C4E010937650E6C80F0A45B006DB9128D3410F5D4E570CF2533B716A1657202092432A971C38400802616488C601939CE2C67F4D8B90341C269201C02C4F375E6B8462F472189A15ACA8ED5798197664AC1EE5CEC048300F281C93DEEEBBC780BDB022558BD6ABE2C1EBEF844265DC68B811F7541E04787689C8FEA81194E1178E7D98078D75843B588DBC214084916A72D80321C0117C18C853018F67415E9E1404C8FEADA7E4954F036C278F90C4FED8F0F75E90FE179ED85DA9D4C6969ED21EA90C16BB49D30BBDDC5840B25844FE24EB5A4C81AD8DA2572C81A7D6516A80A5F838F0925EC6E21CE709F0091E2477A002031CB524F0F65A4063A583BDF550E865ECBD7175FFDCD93BBABCF5E007CC18CC5607D32BA56167916A0ADB28A68D552BE8C186CC87387E7C8F98E18C47CC781CE8140A2D9613A0DF6C1F6AD6714557C24156BA3024F8503512BB8B020A2BBD3DD1FFE0CFB9F103534A121B3B3BC70D400C24D48BCF1D02D8CC66C644C751B008CC9C50EE01DE38449CCD1847A45E46290F8DC42942B426F00BC09A7272362BC774DB073074F2C8918F51CE18F662AC8D0478508F0A1D'
	$sHexData &= '3E0A9E8E0C7AB09C508D357C420B3E7E9CF05056E1CEF56860A7A4DA293BB51FAE05EC45750B586433B8CFB0CBEC833F221F7CB0A9C8B4D993306B6ABCA5B46FC577351B73BDB1EEA98B6F010448EC8338B542ADFD57BAF98610273D60EA0B70B781FFF0D81429EFECC88C1750C32E8F40A039360CB8906B941398BC73F434C61092B81585F50038AC06A08B1E6D0F3AAB5533896B899D231C00CE23451CE33C44C0D7075701FF1184223820051D4BEC5C7647DE859C828BB5788FBD7C8065DF1316052A84CB8C75F4A8853A6AC88B151440B3C75631180C6EDF5C218D78B6A3B64A98F223578D42661122E0DD930611D44E23C606BA866E609013833C081430EE19EF42F53D209537832C531AEA9B2F4B4AC1ED4E64A0808B0C815A606025E0B4010E6CA7A5F9DA439189410C2A7011107476D22ECD14B41860C4241A3F5016E02C8979BE4120A14089351439B80659A317413E641C18780C9270977FF46FA917BD48FFF103CE4A23D18B349056720117653B2017F482566BC0F57EED0356FFFB7414F676B41DEE1CF81FEB862BC7051D29A13E43F15DEC68C7F1EB0C5592A9B4F270B84DC807B456F5400EA5B033679299309507B48B9CC86D628770869BE073CC58418150D5FF8D23FEF2695C8D368F688D8D38C169A8241740072C8721119F720852BA002721F10A333168D79FAD9AC098A6A3A8098CAA0C08A79BE03227903F709034954EE0E73EA0908C253D8113D34EA83F68E6205F697F4E301C01831A7158C50B0BB4927C6C73C92F1CE137F94276C10B79793976C108FF08FF05E5E4C80CFF76C1D42A642BE02C14CD439DB4536EB519EFCBBD40C312772F83BDEC88E0E8A5D5D2B32D271A144727B8A8BB3D4EAD36908E3C77519F0E09EB1E731775F5361A7FDF054EB0E049752BD72D21D1FAF842BD0A3CF05595768D95105618CE81D90B91F8C901F03F6E04038B8D04E45572D4F5F076DDE880E60D8A02ECEB009B1B32DC0904ABC18243A990D8C78C8D85C9C175D4109754424A36D42427038712DFC724180072803406BCF1882CC82417E599402E2F376C627007A9540664685C1256E7249778A5360720FF0C2008C920FF6375FC44439622F5742742186A49478D999F8080410C37FD801934E46E5C7B28536C7955090C7CD9398B5204582D2E51071849A322ECCA76F21C45C2B4C33FBC9C0AB9FC5AFFA06CC57544C6FF4CF962EB037DF9837F1178DEBB210E32C2A3F679E10A015F45E80181F7EA8E54439D5F6333C9BAFFBBA93BA7DB74189FB6040E4133C269D06882DE51B5CB72EF52D0C4157EC2123BA2CA1C81DF85C2A0FCC0F645D03B1B7478C25FF84C8B4A203BC8E07341DF35819F92E253D003CAD060A23E188D46D8B2C4220027169F89114FCD96C'
	$sHexData &= '9404CC84552A30ABBC0B99FEC254803D4B801D70A0F00BF84D588C8007875C89C02C085FD1A194AEC32919C54EEBCA85E2EE034062528F144C74A3978E2C339E445317F4EC588E243780A8975949490A185B180E182967E4A0F4275AC61ACD448712182EBF8C433C9C51566AC8BF0EA0FCE4552B15D8BC6C25256F69C0ED4628FF97B86FEA440BE8B3F0572738DEF56600AE1F212B9D206F590412E7F174233C169C8D6519DF1138BAF03514A1BEED813B723D122988B044C10401C09898918BBD428B035BEF08879FA76869B8083A406C604FB5C8E9F6593B0C769D6284A56D99E46FC8C56B83C9846D84CDF11098A8EF1DA03E2FBE8A8D1A2DDFB11FF5A699189ED9810B0511C02E7A4085A5D2E4D0846505D2C56E6227EA54718012F88EB0B0B697A8B093200B511AA9656E4C4049B39E440A13F4F0D700067E002ACD7A93C0F4137FE837E463E421E750450164139031F82E8A03B7D7E8B7A2B2E042EE612A5BD3E2804C0CF4A6AB04E48107C303D2EC953116648287C897D4C117EFC634D4A370316711909F724E0A0141D1780925385D01A7B7EE6A03442EEE96D7CB061C14BE104E58063220DC14BED986D0221D2FFFA8A8D3C85D93C0F00751F2292EB221D89BA11048B6450A40BAA087868910445BCFFC6433FD43880F645C0F0EB36198554418E4118619841387275A828C5007EF7AB7E814A3E5B4EFF03C8794D298043BFDF06791556FF4F653CB3B4E00679D9D37DD59442CCC820D80E8C0344045CB81397818D081C0A1C049B12AAECBCC16A064A1AFE3B0167402619DE1EF895CA67920BCF7DC8C4B0AF1CC825B4B481B78B72B1C3DF8B20F5F045EC03CE91E84A4E010A73360CECA947E3CC14326E1EBE1A3A104C405180FB7BB4F73E85F69B8D0335953A04176EC7E4BF9A5C650FB934C3F4ECDD7C210C32C814C3F0F0E813B839A91C0B206A2059F683514F97890C038D5F6D808E7E828B55D4C164C7016D70E9086941D2D942042711D014F0D089EEF9610405D6037850D32C3CEAF1A9FF93F4D7F04CCCC2D7A1F4763B9FF0BD020CF2ECE8968883F89A851352A6A7F472CF43E0B0CC14C9F78FEC161C4D1C0F8D082C7081FC81E338D8EB0D4D68B1ECB64437F4758F01348D7C861F1C08FB0181904C4B3718805D687F7C90EB06F04D2C371E4B570519101B5F54324D893DBFB5A4E960D3F92BF7B6C82701A723A199536194B9E60EA31D33873E32BAFA2FF05A1D5B0503C2DEF01700F3839E85DBFC8B03EB02C4876884A8481C4923CE3C4C065C3E8A1EAB3F506B50E1EC83792CC0AEFB9541093B4710751AFAF055ECA667A708397409CF46EB9D1D2007D3532D27194E0091CB18BC7A19300E01E9F45C5A546496CC66D057F0A869888C15270377BF078E64'
	$sHexData &= 'FAF93BE84F23C78D342A873C230E20E80E793E1098753AD8C79C1E1C40A8CC6901610736100D467EA945E01EA6151183BE6EE40A1890C92199E8E4697A11594F766CD09D849137CAD410E53DA1C6E1B47B03817C64763FA1294803C01463FA7FEC8F0C4FF8333CD5E95C11586477CDEB0A2E86A616D7F03D7521A6555C02278972C811AD5FF524BE20EE105D08F63E1C895DE01CDE02860518C8801C711D484878D1C8788D86CAFD2500B846848258348C1058E930EA6CE04F1C469B2C97E232123907914F6208D886A7FA588F14ADAE89FBBAA6F88BFFDA73E6890CF82740F4C743F49FA743018B6CE8EC456B24A0E14F04BA0C8383AA2A320C50F4C0045567FCBF11DAC1F9023BF173058D3CB2EB30221B1F12AEEC58B6F0760FFDFF3EB0404DE4ECBC5AEB132BF1C1E602566A0057B955F04A3103FE22D8A8FC712F384A1F890B62118693A4DF82772D897B845308EFEB3F2345D28AB5C208270AD092C081FECF4D94CB3CB09704CB3BD58D043E031EEC086E6AF14325811532C3FA0E79154B08BF502D10A1AA19427D07FA040A97D5DDDF8848BEDD560CBDD1AFC22ADB47082B07B7AF15EDB02150A87203D7DEEDAFDB00A3142B6D103469D8ABAA008B098DD68201F07417AA2B362BED226600C1FA2CD203DA75E97C98A4EF61083BD87351E857C186CF774BD88B43E83B9C742D7AA403F60BCE8B5708C7EEB353188B0FCD880C3C3F086E4D8983620CEB09F0DDC84C44C34203A1A357101AB0947F80E0AA4FC67E150A063B347406569BC047B3520087CE0D9CA2D2A2C57F50F943A79087000155E8F700B615050B0FAC8BD66307E259350D6A07C248C80A9AA02C404806B97198A83984C20F1534FF1320FF5B17722A943C30EE9CA59033FF9DBF8D5598130173CBC42754915467E3192E7F7E152F83800381E38EC007C27E6FB0662C55D35E04CB8B706275700D92B57148108973908A0BF488F84814888D6BF04DC4603BC81800B0D274293D906DED076AB251878F3C8A828B708885C3007AC3534A0BB45E017084C44DB4D5508E6720218F168A9CA1F87F5189770C884714C647E6402362F661170DB03BC6233BE9C5006CC70444A009C6552623080C085C734106DC2CE0BD78338071084E3F855C8A7641940A8B4598C30B21204A8EDECF352FE90DE918D0257236DA48C168B2375FCE90498437D42BC487751204C7048903970246D049B023BE0BA6285760063E9ABBA2C24CEB3CF689B56D0AF45D442512FF2E686A02C14A093E5B6C53E48F0494481096C0857DA50DEA70EBDF500C7749366AC68BA4F04E23DD8C5BD00B91E1E3680E821353DEC1B6397A41BE4C6D4794414C21D93B468EDE33F67E15D8D987F03D007DAB14F61721C31ED470CF848F1D10ECCCA93E6'
	$sHexData &= 'E0EC6C72E44A4FD003D0A20261A0756C88B95378154E5CBFA94A56841B634150632C488880EF20CFBA88C4990BB746B8C8AE1A1CE959195321B4649D40DD84C780119CCE449100A2E3070407A0FAFC896DCC691BF6A2CE25150898D64853C33E0CAF06618602D81CCA0A6A5428D0A08D89CEBE356FF0C6F76935CE15DCB65422B60A5BAC1860D2F05FA8EED6FF317E03019A033A41C3211F8807DE5009AD058A042DACC7409CA508FC170C41B1CA9C47D07830306636E785AEF820163E96DD5E0023484C246D02BC695C868FF6181C6048E10EB1D761B2BC8168D855844BDF36A383402550FE9218082957C2F48D5ED718BB57469953C0B75D29AC586279120AF8D1B0CC6ED43FAAFEC75CC03C2C1E102094238AFA46E2B0CB048C1E8182AF9C1EA10F21670EDC1EF082E443B689C6464F685B47DE8859128BA0F5017544C180D48386B6E0A5DD851E43A5B04F784B66DB6C22A5EC81B5E77596BE2360E59C116B5D90B73DFC3C11C247C42FEE87AD99D27423B3036652CBD79917469C13C81D97D0EC8B52F7B83B5B51C60C9E54244442358022F465F503465AA8185F58D36181B89CBB71E8D00FC4190F64EDA49C8380C810B7814A0C0D9DDA50F4EC16A5E36CC4037523E44950F8A839C78EFB44C1C928DCD52B07B8A15C240719785D28F3443D6F81061505A1081FAFF5F1A8E7CC70C8A080C34D0C1E2BDBB0CB7080AC10BD0AD1A14D351745AA41BDF8DE046F0F1B9FA148914525C3BB543474668B33C8F62FF8BAAE9D8F1418B8DAB3BA00CD3037F4F408BBD82CF773D40D38047BEBDAF74A24EDC64CED4B8E8362BA86C9660C6C1FEF61847C831849B21A4C6F7F1CBC051B3955E1EC45C814A02D39A76044CF6FA6A19A91E807C8A03FFF3942AD75F63857203CE7FC872E7C6C80378A2C56A85323E255A78E141DFA06DC25CEF68E1700CC7405F4880F2AE9BB001115008C702B8A5F14312A7D0381A2E05AB4B43EC485CD260807027027812C73B21A6824D1340D20AE0108A24AA86F0B2889A92321A442E0C8C1E60FDACC453F5398FD8A1FEC6466034D036528BC47EE5E9080452E0F0F0A6527C96D005F2899A828C32CB0D351050BBAC36ABEB14A0CE4406E74EA0183B81D63B5608FFC606D89A77010CE515C6180164A180210529DA49FB20C19DD0F7CA751DE2F9EC4C809B5C4C2908240D1860A0500A80702A5F078BCFBDBAA83230645BAC2507C9979D459844A8929EA49D05021BF0B128018A92198BC338C2C84275E11D10E00395D8995D00916E0D0C5F8251C2870E26C35F1B99B13D807EDA7421C927BA31A2373F51BEE221E4212002FA89BD7B3E190B1E2E90FE641BBB2EA1A153824BD844164B541E11F7770C3068956874437888034B8CA82D04B041CF2713'
	$sHexData &= 'DE0FAFF9D34C2A020F8E46CC3BCE0F85047613403043B57392B7100230EB16FE197AD27EB81F85EB51FA8CF7E144A834DE8DC1EA053B8EC226AD9F3022CCC8778B3FF0E3361C2B1FB604B735DFAE81078CC11C44B70133C898FB76770D0269C922190303B58325FFBFF26E8BD41AD18BC8C1E802C1E10605B979379E03DC4080F7CA03C13139DE9D729F8B424E293C5B39F0FEA87C365C212558001C90A1CB0708F0FE797200F944FEF0FEF0FE499E933CF0FEECFE0826196490084044500607904100FFB5D74EE35419F7A04CF5E5E6189B904D1C4778C980B4493C2C1040C95BEDB4A868613274CB78786B44252EF02EEAB77555BC545C9357E80ED70AEF5CFE579A91CA9979B4A4B8058B78CFCAB3F20C897DB0CCFEB48BFEB86D478EE48D4DA4A4B88B7088853D192AC2531EDFB01BF81576901DA48BCC4DA80E30E019B02DB6AAC0803F059E5D897E0CA85C2E155262FAACA8A45A8E3CBFB900C646A460FE2BAF13D77D5F60FE7908642663904FD03DBC8C5CC8A1A826CCBC384C05728DB207C3634CC6B98D3D934C6DA4C3F510584B0FA1214AA831E5C4FBD0A58D29C70BF91E8BC70315003C5076D0EB092948DDC70B369C86E1DBA4CA98A9C618FA241D5C1C5C74FC294FE2578CE8212F62F6496651AB028D932698B4DEE0E616E4B140A7005AECD5C23952EC579B008BF2BF1450BCD01055900D1114AB2AD10D38059F8262AC33D2D2A44D28A9CDE99E189A16E859508B7C39A0408D820B0C9DF8C2D239817510D0C62E75DCBE8742D08C1D3F7A3ACA03C87335442A1CB0EBF130BE29CCEE5784A780A6FA1A2119F19D26C00F2764A046E1C1CCFE495EE32194FE6294FE93BC6C8DC6DF94FE94FEEC60C13E94FD617B1C9081795183B5B5FC61306194AE83D833EE1ADAF06099F8EF3E747AEB40BD123EF8C3A83526DBF4BD0FBCED54DB18FE798D93B3274D8D1E8A0085F68E69AFA11C815B95FACCFE3526473EFCFDF8FDF571CBEDB200FE045B781AA5E1F2AAFB18FE102884E43D3CD3C8D5C1E108400B1A78E3B22BB4308B95542136393EACFE1F890C8240117B4572E2A91A188CAA51EE3B73FC3061C742BD3B37A74CADAC31F45F50E5DD97EB02CDA0987D1E53B0AE5C4F0F45C87965A0172E3C413008EBDC13D7FDC0EC9BC722771080A7CB258C0C6BDD07DE441B51E2509EE494B85B86FD75708BF06D84336A0750709DFAD65A4188DCB5359892EF43CCF0257C8CE5A0E3255521AEE8508B780B96C45626F56532F291071B989FA88BBD840053E1A4476C0D35099C76DB33FFD67BD6A06002BC5152D227AD4F65448E08C75C901174D3C1B5A4075EAC6985D087D02BF0C0C32160B1A81A4EC8B5D8A0F395F9C29A15A3D4DC70216B7CE9018B532C8A49D66816D0B'
	$sHexData &= 'D798EF8D2172AF10FAFF78842482D98594A0AAAB7D41EA21157092E303D95B33AB415270A899642C2C8A57273D88B42DCC7024242CF121CE448FEDC2B22B6C69A8A223CA2148CC956571996E10710C1F8891EFACC7A21DF0B807DE98D4DCAC9F3D43B45D8D4D499C0A8687A6C56534050ABD138C1D2F2CAAF951BC8B28945D8F08D04B50764433E518D340864752AAF50B133F686BC4A8D7C784D38C8546C72BCAF050F1889C242D1AF75A1D604CF1CCED3E48D545FC18506671440ECCA8BF22BBCCACAC1E9955850ADEDF2F2B5CCCCDFA51DA51D930C5461FD809864E4482A9898984CB0B7BC38FE837B851C9081195183B5B52C215B6B94DD34FEF3E4F3E43CFE38FE28FE3CFEB10379C9301CFE2479C86B5DB9A51DE9305646A6C298ED98802CFE3232204728FE2420430EA432CC201C0A57D80A45B554F9BB82B9C2D0C694C0CC2D329674E7C01B809756103E9A0490423007257B85DF673BD7BAA34FA08E75FCE17DBB468BBDE15DDD15063B8F612C0BEBC4758131156A240471298C0D670602BF70FBEB8D770C3C5039F25A684CFE64FE076B9D7985BF0001185916B512490741F50083E0AB4859954AB59E414CE4E8D4B54C673514A6F04D0448B506416416B584161A4701889D04A889305606F04A2D41DF2DD7DAEA65A07CB355DC46E097CB212B64FEE4E8E9872EE0321CB5A66B29974BD8D4E9170A67E0681E8BC72E8400EF27E48D4E082DDF09299006B40DA84A42A27D851C24536BD077BC728C958206A5CD74EB23304D40180049177002181F524211019005EC75022EA488C06C39807FD2D7C404FDAE337D45AC50CCF4CAC26A18B1102233D91A4AA8160A539E21D08789A1668E42B5CD72BD0FC27B163D2E5721A415E9702D176509D5C2A825D08EA90C154288EDACA89658090670536B84D62A84072719252F0F08B6C6223F76445303063F22CE908E4078A19F327DA974303AB4321BBD024C0D716537FC6A0116FF129DAEAA4A059039ACE89A20602D64BD88C07D417BF6AFC7AEE0DEE1F5057650DEEEC20BD579C9A50260359048853462B5B509A137463C6EE04588EF55882BD06A720220FFD7D4C45761B7C987387636CA33B7705CCF0CD4F0880AF7EB1E2BF164BD7598C03460358055A0CEFF696A606A937881CF8C155458A4B28C264E1308C85A4C3001A9E07800C1FC9C5902827F1BC1EE10C1E976CB0567604C26FD8585BC7C8FACC4ACC4E1815C412892C04D8466E03A528D74D904E3C2221C19645DA8B27DA899DACAA17D58FF4584656803F2900175B54C8449AE1AB8D9042B54324865905C58485CC8844CB250FF3C447364152EA44C34FF50FF3D039F822C845584C8A8807C858146283B48FF0BD4C0E544FF40811AF73E46853B888DFB60D233'
	$sHexData &= '707044EFE3C0AE0AB73A1C25641BB43855B0F03B0385B589C257B8D8428BD535AB1C0EA535A0282F7841CE732C5F2589653B8D602727C8F461B86D90122154033BE85D6340F486FE4697A206AC8149439C6AC0D9D8354F4D8009D76A0D48DC80426B6BE0DE3F72728652C2510337EB402F7280D01DDA8888458F139ECE802E4B08162A8C095305138F17024F812613875504E174D9EB229A9A0FD414D21B95C7EB06AA03C25B10DB12B682427F36D55C46730C7051806CC280A3BBA1FF69C0CD3C2CEC60937D018A3B5108741516F24210D883784373834104146A5A2F213C084690C63C8974207B3129BF1C62222EB0A8C520D48FD0909720D4EC1805B8EECD3B051C7405A30D68233D4A865A6AAE60033064888424A6BBECE36C08E1A9E229B2EDAEA86144DA7E32153B38C2150A540D418017E0776C657C7F253BCA7421CEB6B301C6C10E08CE81EC2181A122DCA8118A6BB1DF1596C32D32DB2B2C008C061F592DE1450258C97E5D8D7613026C11AF2CA0CE7424C08BCF121675F0CA89171F63AB59B03002C81051B06B0928CE125FC4437CC9D4726049B11019846ADDE04D0CECCEACDB54890111100C537527A84158362CBB88631D0C11A5B7DCBD1D6A4C7A6A4D890799086A4EAA0A1166934F5410FF0305890B481F75E0058588105AA2FB7415B198DA50B25DF88D3A7DF422060DAA08D0CEDFFCD01781070746EC2F806F0235712B85DB545A0C7523395D42756EB00C100CE48B5D7ED766614488D603C16803C42D42DCE6B1F950B07348B7B8740456C840BA75272070423A27C07509908089750E03BE2242C187DB28803945F4A08D3C2257029B1095DEC0C890D40FC1ECD90A0655F41610C146D438B06E0C026FF05A52F8EDC25358B2428D3E56FFA0D5DB9A4E1C551055CC548BDF40CD9A87B11ADC39254008283441F7DC82B5011C0C8A16640CB547E87361750C9A5E3B7D80C3CC68DA8B181AC0C288D0B0E081A0AA2B60A25DBC567E56D1F78E58867E52157F4B81FB0F4321125F0F70349475B806322261815DD9900C7DF0140759B78419DCEC276AD87CFB1207E223130C56754833C0DF251D2C9DFC1D420450B346A86E52D3682096A4DC9E8E6778BA4DE075BC9C0D488DDBD9958994F0F852ADAC89086B30B8B19C1C1C70ABBD30A914CB1A52619C290820306919E44D061F52302C7150E208C12CB6395C8BF8848BCBEA55D3F8681FB6AA14504E6EB014F06D4FD667B4CFD030EB7048D485F11936A85C2D14807DECF2385024343A4384501A71818538F0488903584B5C1AE881BA8943754343A00528A05736152A8D495A5D43C3CF967034AD3F2C0295C3F11A90F8909003C18215EC0F885EB559C89265B8086C15C2336C9740762AC61F3B1034692F24BC2'
	$sHexData &= '8425C03C6201008564010B2987514F895AEAD143E08EB457E7F19FF3802F855C6BAFFAFB5612BD6C261AC72D508A4A3544108FCA5F4ABD14B85E89EAAF5084662006BDA23B80461B854B568A81260323E59FC1C986A3A6D6A86A6AF4E1482CC308188B00FF04E40F860512B528376F8247E6F2D1C8A6D9578523E6A3BA07C51A6165E9B54B404881A8204FBE7BAFDC32BC29933C2083BC67FDC26B7D0C1EA080A1676A63D5A0833442026FCB307DB38EB10672A8BE6A0413BCF7C942DC6C264A80048418956FC82A20C3BAC2AB4AE10B00158F29E14835F5E32C0033C17487FF8571490604A13EE7ECC141C3E861885C9F5A49B8AEF3ACA008A128B72084744247FE7E58A2C0A0E3B47B7D8243803450CD0BC8834100F7D0A6B78B12266114E0E7F1BADBCE5C513401C282BD71207EDE21220170E240224DE20154BA41D24302885813B2F21088A8DCAFB0ABC57ED0F282EAC400FBFC7821C98D9C413CE07F8026BE7BF59B7D08B4424188A3C766E4567038A8830A1C665AD1DD85B36341CAC8BEE304481F81A212C1A03812BBBAB78339BD2DD0F10248426C0FE1C71F3BD5BCC1072D118CCD8E666D9D7C33DAD7D7B3FE4745DDE10560C880F54E64CD40ACEB36DAF6D3660D512C10CC506F9D01C68E53B9BF73E1468CD1CC224E1EED01C5BF39ECDC465D7E00EE7637E55DA49171772B74118C10A2F9EA25403E6C928B68D1046E1553C8D32B97F709C28FCF9048A58E2C7E13DF0DF5E7C626014927007E968F6C08B1438121884D2C77FE9700F87664BEE4DF0C01FCAB4D1023D47F97F38ED7B4313C03D288B82413BCE7CCF71709C837ED4FA103B31133E6806384961B0E15F68303032329FB48030C08A3660C12C281084D7406DDFD4023B060F9C525DC3BF52854C7290C19000E8A26A1585028BD92CAC24FB05A0B624587D2816A5F191DA5CA401A5034F551A0E29A27D59C20060A2ADE8265426557C04A48B464C9AB6B2B6420CBCA816101078B0500520CF463799299850460E2D8CB12ED6B06ACE10C70064521368AF1C605184B8A33FB42AD04AC466B8B4480CEB12DD12C07F3DFF75A86A06878D57109D50852F48450C185D14E121A002B8A0AE1130C10D32EA520B4114423652722578B753C224B26A08817057C702FB750230855F4708EB4737BD49DADDB904EB346A060CED921484E46A062411A58EDC14319E1C07FC863D5FBCCB36B4817E10F4010D37AE1AE1BCC6EB2028BF59F0E13FBCC70F47F83A2B411033D24020F7F7DCDFA361EE2A3205BCCD83FF010F8611D058652D26CF00A501841295CCC21BD2F944B033FF4A8DC2AB3EA424D73ED03B7DAC64CDF027ACC140EB07C49EAFBE09E7C29932A08298344D73E1328CC60A901094B00B40D320988068B826'
	$sHexData &= '04C28877B4DA420566554D009CF0AC08A4632355D28725A4E8D97E96E0BE558D8565DDAE0CB8ED0DC1586A80D0C6A0A5DBE1C98D3FBE531E0E32D0A9748E47C34170AC8801C0860F40E430B6938B010F14160A2E8E80F7B040170A1E56EB0693604383A351143B0C740E002AEC1F0C30C6400401831E9A169B4B029F7134DCC28C661147BD8B1F8AB07D7B799321B091D2748E02518BCAEB1617CE0C44B14A477EDB23D1D0B6B88CB0BABA247DE03220A86822DC50AC94C03A5B27E1BC0FA50EA2C02B059CA1807EF40A807974BE41DC13DE1E4F381C3618CC93F026E2023A78F1244B2E0980F7C6460939A38B2EBA626B63B110730431802C5C25E12F814D3C27C699053F14AE83DCBBF5C310B88BA05A0BDB2035446AEBC617E366A6BB6E8B5304EC0BAB558B055A3CB7F01D83CC978116C0BC0BDC5C794D7838601A5E1E5136CF8A289CE6E404BBFC092C99162FBE4C88DE8828C3AB3910070F0FA801B6CB91824089A3DBE8DFBEC21003B002A202653A32E106BC5074788CF57599C894B8129E88E235909BCB584DBF55B84264C0FF26548240AA767C1FC216CECE566CEB050CB3EC942C2E2919315E007E2036E0BC034D1038285128C11AA650640007856216A0CC03C0A815A18DB890A386C877DD80E1E12B0F9637C60B4B043B4B085B58DD13604F9384B47B848E8E906AE749FA497271C188F3421DA1A7B0108C879469DA813D9C181418980A249C811590AB288A162CB9E3156023F5C28DB9A44EE8830861C4749C0318059CFE0B0C23C092450D567038341C94A447BA92878707F88E3BF81DECBE46C00370BF0FD23BF023DDE95D35F40F984BB94500289CCCBF1231E4015316B200916083AB3CB43D715A87BEA612EC0606AB1058081D45166633416D1363D9C11544C58E3B9660C07EC795846343080C448B400C1978DC8E7AC03ABE24108A1527A13EA8610AEE710848A01D02538BAE2E2606506ADA82430C2BA21F1CA3C5B668D6209086430CDDCC6CC0A1B833434CBE0C50B363266A4314F07A1DA287AD14A458CC25C79188A7EDDA4E2A86EC4E4D4E5400928472F951798AC0C419C8D05C26B91CD4DCE0E46182938C46D0EBEEA6C70D72F212CEE4339E130C1CD6444C4703E97878184C7A477903E16ED8A4BE68F042C58C1EC408E16064FB94B00E69DFC2422E20BF2246088B888DFF201550A47640229B8432C8180837B19B84ECFB1F853CE450587900080F697779B8FC780E0AD48D8D8AAD0EC080FC79FCCD0943E0451E43CC754F4EC89929B0FDB0FD18FE93A34B3EC0FDB8D402A4BD6E69CCA06389CD9CC8804BCC4437439CE4C99F1BB0FDB0FDACFD933713EE7937C8FD4464A8AD006104A3BBE8CD2D472CCA8D95CCF07C1B6E3CC34F38F60C054A2014A'
	$sHexData &= '7A0A0D020C4B6A4C14DBE97C8FC1326CCCEC13BFB0F4EC2EC190F2FC18BA0F0CA5EBED6AC3810BC4DC8A04061C0BD7FC5FE3DC2473C0F46C8916A092E6B4FD2301EC18B3A20ED3490F63E2FC882AC86436A72EDB40E7C85057676D6C0998F40825D8574ADC0884137491C48CC17C1619F190AD7233CBD803F2324DE77DDB1519F5973349E6BD90BE86DAF020FD99DBB2BAE045CDA065C5EC64DA88525C26B8C993D01386F3316D8692AEB706DD9D8635CBE4B5100F4F80B9CA483E572B9B4B08C5F878B1E688B07DDC8FC4F188D69B53731C1509350C155B83C0F0A9F454D91318ABBDD0E2689B5A703B55D837F18AC9D50D8D9140124B58D77DCD38B23B1ABB4160E9C9547753E5A4B38D3DC8D691010431ED448D05C12340635BE572004093B1E3AFFDDFDBA3EC55D06E90C5783BD970075234DD334ADD80C0A1D10171411C17B9DBD8B69A441E9659D702D4820C048FAC79F0C815268BC3F14D8CC79184ADB677F485337C10A0C8647106D3B5923C82AED7E080EB406CB75780C27DD3BC135B0B0D58B8DCF16977F19F82BBDA49C098D8C29D97F2D9795BD873BD17D5D42BD4A09FFD9D07D53FF77FA52634F1156180AB004B28DC73E181B344907DC3394E37870C57C8BDBF4A9A40B3AFFF00096A1C032CED88D8DD07680EF99B9152B435821BDF2AFD4741B8584FC6840420FB8EA6D422E9989B794EC1E0A6BBA1254603D09BC325ACCA3052EC73B320C35321C45FF7EA0CDC148377F446C0104E7BACE47C6F6F8B05185CCFC4446B7B33D71843DA8BBC96132BA1788079CFC5CC8216D327CA46C1C722187B458B03254C6854405185FD0647C8B57489AFBC7078C50C7696F744F2CE42CD8271DF446A5DCD06FCEEF57651CD297142C69F80E1990632D30DC3477C06440C48F8D4D94E926DF0709555CD9084FAC66A0062E3C3AAF558A4B2EB909904041351B115B55BE5C5532100CC1802937277CF0B28B6C77B1E31531C3E46D4825D8FB7FE9D0B05275EEDE8001CACAAC1C3A25FC9BFC758BCA8D7102669091E0B661FFCED1F9745D52A3010C8D951528D147743811AB88CC50DB0CE978A1D96DE19A037C078C04044E5BAC0890899246DFE3FB391C00B90B8B3D7B0C40749453F7EBDC15EF2598480C6D384968D891851C24D133F013D15EB83785D95048450C225672250D20BA6825C48B31CAD74753F4B6778BB5AD2A7630314B76304AC1B03457C4153C99A213AC3FDA4D0E9276712B58515EACD60EA4D1010F905F5534B18F5145B8B9105BB3E382875D9BE9D6C81554803D4C24EDCCAED515C8854CFA128BEF3639A23C802400BE1E0CB9EFBD875CFBD60F44D14B18280041448067A63CF14A296540245772131410C814C81516208FEBC517C6C7F635A85C177E6D58'
	$sHexData &= '54080002751657F4854EA5100A70CED380E8619B83091983005D5C00CF925DB124459E71B49116C148C7CFD7C2AD059C741E0EBE3069E94340C0AA95A370BEE019B0FC97F48E50A848EA9061C6E70B4E1431B03075B8CB765F384B79ED7E0CFD2FB877652138D6349590F623FD5EAE0F3BC8A4CED03BF20F9FD44851D2D8940E1824754BD12BD6DEACD58A86F84F7C0B95E888AFD18885ECC96BA169882C0BE4525BA44A7AD8508B01524CF4FCB4DC7BEE8571377C85619C897737FBCC83BD31007E60332D5B0A23B0DFAB8D0C9DC05BB2375AF964670333E1EC07178D34883C936A8897D0DBCA46888D0495E751EB44C311F31C47C63BB5A9781FF17CB5278D63D3136348C1870C26FCD9B5A78BC781F817886CF66872792AD2817021E701028970827021245A4141188A2605E086A403D016747503122077B405D492C4CC2BC2BBBD2D33E81D5E027537E3D3AD912B97851E88AC47CA10614A6C651D9AD027D821882EE30E3D4F58A1017F3FC404186439109D52A579E1969E110660BCD419F0DE66766D5751412F86DCC305F56083FEF1850B0E1247BB6EB5D48114569A6187579E8D7C58740FE2012FC84F5D446C558A14FF4A88078D7E013BF8729B214A82091FF0AC3B75B0C8D21DBF2557030E1FC91D203211F200D1FEC8647059D8A8C60B68D40168C0255B0FAD922390202186519598552275B568B85431AA7887575DE2224F915FCC8EF9D864283909010FC661C081AD75F9296DD212684B2623833F03361AA12E6683D33368381D6EA0D60BF744BC747B3F092D24E9461CED5C488092F8FC766682C959C7D49F56692575E39DD38EAD268D458C1C64D3B106986327738C3B08EF3A289C638FC61862AA059CC48993EB3978AD048F02D95BB546CC33E44368DB28ADA52B446E6872B93C3C9DC6CBBCAF8B473096FE5CEFA4A39C6809AC9DF3AF011252FD33CCF82A973EE24B2E7C6D1DA63F6FF3BC0E0D605CC31615180F54BDDBD2FDC10F2FD0761B577436C685AB1201E342909D3577071D00557C100643BCA39803E26742017A65DF4BA6945E299F0CF2D790E62EA50D2104F25119AA37040E9494302B6501053A59F7B2C080B9EB181825B090C4B030FFD0648D402BE9A8006945D456C361088008CA8B043A8151007B728909A8818B10895598E24DF337CD360A10A08A46148845A415A563B57B184A94AAB5CD09BD6F830B81CE72088923601F844238212A2C807DEABE15D87599904D90BD1F8A7C78E0C3A2BA8871C7C70A4A059EF61A51E736A01C61FC5C266F033F94CE02EB13BF79CB84B6C09C280445F5045E4ADF29ACE8FC2ECA364B38480404E0FB5FDABF4CD729B715A80274143AFD97FC58CBC53B890800F646A380FF37134B35F258C000ABFCD954188'
	$sHexData &= 'EF32E245B3125B185ADE9746EEC480A68517C093F41AC3081FFB550A09DD069952216F009C272E9D250A66224C25DD7597069952DB6E2430181790C8078AC750BF5BD111D386A7C349DD810EF766ADBF413717D88358B296ACB19898B9B9CFC2E3BB510D856B217C003C1A479E41DD4208FA003C6B0FB0A4598D1948DF02B95F42BCC1E05A5888F7FC28CBDB447A57FA05821BBF0373C0B2F51528D55902D72E15501CDD7B8FFB69DC0189B6475A0049C567CDDA032B6FB8CF6000F8BFB8C324CBC482104F5EAE1CCC06C4CF038377EAEC629409E47FD1D6ECA391E336AAE3C07F0F5380D442D4C75305538A4407BE09865DB5B931FD92CEB58B599026F6D7374BBA38799B8D07EC740BDB08276081C207CBC77980B43F4820A5ECDE4649B9069186598075C0D77583A5474A2C468ADE9268FE388FECB8D880BF843F3C76242D7B80C2438523D43EF338B494F14171A993DA121BC50E78D7FA3276083AB5E7CA5E2FC7DC778D5746F8BDB8D8D086011CE05E70072D6F0F774025E7DC8084B0CF51021E009965861041F1EECAD8D185324611CF5F0812E3B5657259FAC4B06420217F6A107E02797783D8630DE4733C930D01CD0FF18B9E2205E675C6EBFB5C0D51C172A702AE037508DC0340B40044C5CD203F82198BC5ADA1C48E503B86B516CC0C000DEB70CC02B8D0B9BD254ED7396041877E095DC067148FC5965583AB1030FA30DF5738975A460A9321C73E55DCA99FADC258BC16BB48620C843CB1F04F0FE1667872B6717E8FE123908BCE60F2AEC0BA35C60D8E2353BF1D9DB19BA87062DB0C06AC53D19476464D61DF00DF8F4DD0EBD8686758D4D0459D98591709C2220FA479CB2276176E8E736603C3B882C54AE3035CC94C1C12F2C15DA7C8B45ED7BB05B308B69B93BF855A932E12043381B1F759DAB84F3AE342BCFB2E82AE12F3137BA2CFCB42AE1AE308BC8741E4567252C5AC9BB535B1789478233C6A86041230414951F63E3E3E0372B65F978121AF5DDE1517CCFED120E1E7AB5A6DF51900760F9010282C00E69938A8CE812ECF02E4EF14EE9DEDB6DDDE7600E7928BD0DE80C2A459C511CBCFC6E4B1E25539455A07B51A692424F092CBD1F0D1B0CD867945D2C6209E7E031E68EB2C8B702670F3BBDAF1685583297167850578D74946C0FFED9D238807D8C0079A5377201DE2E3525D9A8162B300862E7AD294C21C0A0FEC98314C00B820A35CAA051801DB8C48BE3C065C77B398B6126A4FE23CE149229DB58E97C2BA146EECAC7F17434C7BD91D3D17AB58183DC2DEB168E217AA3554DA7B8BFBEAD6A62308658DBE6E4C7AF938D0C854DF95626F9929BC1F28D46F251561826830C31C11C20422E8B0E81E604FF2BAF2BC8E5403CB1E2476C098305F77990'
	$sHexData &= '92392781A14AD7D8FCA321F9280102822AA837792781FCCBECFC9F1F40EDFD3845A87434463B10A5C0903B45B7534E9E9490908BEB0C1A03676470119F861982CF18FE894606935EE09384DE3BF06ED40C212D1D2C144A2F2B0E3BE049080769C169BE714EE88B4F30721C5BEDD3A8323E0B44C11D640EE1A37FE2EB890025CF412E0068FD10C7700F83B34C4745DC215C09680483186490CA843D0000933C2F1900FCFC1818E0EDE42050FD541333F6AE74F4F4063E897D2A1058F887AB248406AF8B2505F1BFE36BF6507F34018B04318B543104AA7825E4ACC368443108991122CF6EFAD1F80126160CDD0D2133AB8BD891B3D4BED55543C833DFFF28A941B374AC3B8FA84AF0608B734681149856A8EE5475E0816DE841024E27F53745A300F4480E29D783A7507408B872FC6A3F8378984815122EF000CACE0DD23C4DBE76A2FC4C3E70A248854C5CA743CE090D4720FD15C9D5C968FDE988FB955C1D6975903A61C90B37E95538A3081C324927AFBCC0ACA4077EB9AC40394744FA52380C5ABC571841078C1CFB52EFD34041F295C8FC2F5857805221C68B19C8E5727B464235B8B0F09797CBC943B0B4B8F8448C5C2E27B4A4D0453072B99CA09CE84618108F5C3DA4478A0DCC341D3697ECCC84C91544F854AEBF6664B814400F44C2B372E24BF0CD4349D2EC76F9A818F94839C0A94999C6665512F94D7C73FC92349CE6324A4820F0F6569AE745344B6055B82F5E4C72699EB84C78ACBC71B5818F4D8D75EA6A2B4DAC0D042C34BE69C9A61EE40F04A7EE02F7E1C883C1CAA9956F0E8BCA85C9EA507597E61908AFC24E90582E6DE490FFC44F34A85430C49149C8508B03BFBDE00A6FEC7F277C04C07321F7D983D0369A07EB00F7D800EA760B07418F3AB9E4D86A006624BEEB0D332005223717B01C3878D92BE16A0626B05125CC5112167D5211D91EC8E71D3BD8FCECFCD8FCBD4BC949E8FCB9A88D95D83070399AB752DEF940A4F5D6B70E38A3FC8B5330D88B0D08B01C42548D40419CCABD64784490C4536C3C644E4D0C25837E402A130FCA2B3047837E14398816C02356C6890F76E2EA8D97E6BEDA48650471695857BB2CB84FE127808D632211F08F35EB125257FF290E044C6959F08D9270501A05DA6C6E5CA555435C2B9109B73C04466139E0500D42CBE807CFC392E6D255F02856FBBE04E7124CC80B3CA46CC8E6B2F970A03CC0FB5708FAA7E4D21C5800C4A3D4C0DA8D3400594CE3ED693B048B5A5167A4FB73429A9176B8E4185B28762597665C30BC987068429A91305D405E199063065CDD487C999066A4485F5860A45DC9A5607C687060A59990666170627866A40D6D75BC6B64DC7863C9A59990886490C09266A45D60709065A09EA98CD2CE776'
	$sHexData &= '6FB3423CDD47148A867B84D8FCE8198FF6830D052709990FA286948E8B27D0A136AEBD60CFF9BCB82479FF0BA0CFF6B10F86C6573206CF4FEA0FC716473E00639BA6D28F8806D4606B46EDCFE71399066E4DC6F40B09109A419707C7C66E4409A7158B8725CB801D394FE252D82732A9B03D970F87420FC583497ED4A147020FC75884A2ECD847608D425CD4873A07C0877A007C0958481531C2E3410BAF8C9A0F801421D9076EC1BE45DD8D3B0F8D5B4F8A0C16C26484E08FC759CF81B3284A818971CAB7341728183887499E4904B34989C88692E482620738424931C7230342095CD05C97072A8FE804E32C921847094FE79692648716CA4FE2E78DB05E0C1AB835872692E48709068C924931C6C587C432ECD056F548C20996492907C4072C8A5B96EF050541724934C40DC6D490EB9343CECF0E6826492DC286C99E490CA08FF383C28692E4826F46B242E5894C03583F49A0B9249106A20C924875C202410C49820390CFF6994B6452911B681C13341F2E6ABC1E8FA68DB2EC84BE4F8FAE0C1AB9A0B92DBC1D067CCC924875CE0E4D0D95C5030B88366BCFB24931C52C8CCB8976682E4A8FB65B4B882B75D90FBE0C1AB8397E682E4A064A4B04C32C921B4A090E4D25C90639CA092492639A49088875C9A0B628C989C4132C9248878E4904B736184888C2E482699787060931C726974808470CD05C924605F6C6492432E707460A5B92099585E5C934C72C8686C5848B93417245D54586492490E5C48402197E6825C4450904C32C954403039E4D25C5B3C40440B924926302824875C9A5A2C383C734132C92818594B72486514F9282CABCF04C99BC100F958FBBCB9202B10F9E1C100F99A0B2A9207571CC924875C1014004B7341320856D40297E490181CAB8397E682E4C05504D04E32C921D4C0F0F9A96C26485438FF00BB70490E04AAABE4F9099224538B8DECF934E4CD0D1938ABC1D8F91C97668252D4E88B929B4B72ECABC1C02E8E800B515F06F922609243F9F99508386DA850C04C0B925B8AA1C13892432A9B4FBCF9484C4C909C6438A8F94E498EE1D2A4B845BC70417273ABC1904D9243DA21A3C0A0A44851085CAAD9154E335DA64C8778F9AFF44273404BF971F9C9B42183F9C160432ECD054A5C702099649274604872C8A5B94944585C1724934C483048490EB9342C4044E682649230184799E490CA0CF8282C1834132427F8F746FC1B3214BA080D0CABCD04C99BC1E8F845E45C92432EF8FCABD25C90DCC1D044CC492639E4E0E4D02A9B0B92B84304FCC89C649243CCB8F0FB84E6800A2342FB7341066969FCFCABC122704172D84119262820281CE7EC6694460ED832F2B511816680408C816682652D0CA8A992C978C0008D42DC0642F340DCC0'
	$sHexData &= 'BD4510DE0EC08D95090F470F85F1212CA34FA352671E469A2A709E9F20B983AC298B8D78FEBC32ED9041C0ACC16414262D40AC74082E49FB51B878A3A1630377B91D190C2C85BB806D8B9522403C89F87ECEEC87C85890EC1364FFD4C140A2B3BE5279E505EA608B55B03C8B45B4ACB0B781B069C03EE840C1E203E798E03446B1032E4826A964D8C40225390A219059D8B4B787D49F38CB74314C78165DD9FDDAA81A833B854C1B0C8DD54626619B0742202EE9492CA10F39C95C75D018FE0105711A29A51A8D9D24B82153D4BD901C15F4EB6F19D221701ED4FCA1104813054F364772C8C00E770C2D6C1005D221035814354B0EF9122CA2B048C851111B831A6CAC8416B524472047831B1C4D01855DA28175B9C61AA1EE24882F803F16C801C4D10413F1E580416748671D34BE6C4314584CFF5028A242CD2083BC539F58DE5C88EAA44EF189427D02DAB9DAC97DA4F80112A8562D615543C3DABE88DA27C946045167F604B0C948400CA559068CC43DA20EB8D90495608174BF4CD95DAC43106B436809328E4CB814EC7B19B02EF101076785C00FB46E61FD8B4E083B511A164B20E9BBF5105052BA491D8963D1CA9FC6D8DA8FD630070BBA39A930269130FA82B019111590D4F70B820AF68B8527E4A4270811CCD061612460BC944DEC84E19578461842E16EEB4A14B48A102288C25548D48B948625F19A901A080E511D5AD3F89FF60C525651FF3045C71C89DF14B85008FF250D25D170A8043109B803F74DAC308D01891B4330DF62954D9C0207D56174268B060109B35D899A0C1D99F0262249AB515F00B352F9A2300C1014899AA669DA180A101C142018485B8369243AC19E2000695C0A021FC208207578AC741A43870B25AD0D040525407A02082EA38A0A14893F13C60B92905AC22D5E218F9F2004817FA650E35584423E011B71BA78657CE08180FB4F4ECC213CE695E4A5A0F12A39D01B8F6DFBC020159FC28B16BCE86C382022BCBC6B103F1022EAA54E40396946335190072C303C9393E63994024838359D619E98031AFA344E2ECDBBB99C28047830A0CFC9A57905902CA406E639B934A818A807D23C2797C014AC08D85C9AE7E410B009600C4465F39CB40A08FD08F80531159D0B664F10669040BC80825340FEA194DDDC350DA4305125B4313993894788005E03D19C81208C2978FF570361435423A4C45C100A12010DDA2914868EF775B8DA5850A8A6460EE8BC81B49BB907A12F0F6438732023CDB470106C7320CD48701150B0D21CC84888125888D21C48331368ACA08C3407321444A0158C3407D280A8B8163423CD8114B817982023CD81A4D0189066A439A0F8D019B00E64A439A0E81ADC0EA41969E81BC89C73B061804B1C65C49A0369372F1D6'
	$sHexData &= '4E0981891E640461EAC1828EF409A1FF8945820696E2B486DCB90303403B2192110FE904846DA818C2280644823469A036928BC6024206EE6407C2F25187A0DE9E4FCCA79C8E6D768D2A3FC04FDF0FCC489350A00C60D19E4C3180004F22AE4CDA3B960FF3CFE6D8989C42BB95C85BCC0A37328FE5C0D19029D38253C1920B9C0A373482492490E39585C48E464806410442092492639241030E49093010C40445721279930F8FD2C39C92127080CF8FD2307480E18F4FD284A32C9212C18039041B4B0CF0BDC909314F0DD7364806492E000DC492639E4101400C8C80192C8FCFED879854B72DCA3A1E8FE878CBC0AC4FDF8FC2417B824A373B0C9212703E4C0C40C904C32B0D0ACC924879CE0E4D07232403298CCA8C924931CAC98B872C8C90094C8CC0324934CB880B432C921279094809C0C904CA07CB032C92487B4A0681C7232409C787C00C9249368884C72C8C964989C88270324935084604C32C921645070879C0C904C80844032C9247038931C72326C484C38C900C9245834934C72C8686C5820488357214D8C6D304D804B72349D3D11198A612754E03637BE4B36AD979C0C90DC1B401C5095B8248754A28BC8E52AE408FDFC1890431E321C08FDFC32C8C8A9ECFCFCFC01929B0BA3B9D83B2A1296D495C0B91C723240BCD0D400C92493C0A84C72C8C9A4B8BCA827032493908CA04C32C921A49078879C0C9014888C4032C9247800931C72325C101400C900C9244844934C72C8585C4830212703242C40904C32C94430189243460EFCFB282CC652E6641831DAB0B1820287E4040EA23FECC67A2620A2C82D026E3512BCE414FF58C6662055EC1E45DCFFD6996A858467ED4F8BF81EF412B2993E515F047DDA85C97F0D52FF7507BF016C97E6DB4B85DB21F6BEDB86FCBA9693D21BA9F7EA51577386F75440B2B92214C245B4941466B7F448ECF7E9F23F4080DD6780101C3076C405884780C2745DCC7D13F4252280D042D06BFF5D52EF734C8D55D032C984C938E0A7C00599038A76C49900D829E5A0616BE6E4E7DB7F36F673308D58DC529AC0378082006F8D6FEDC734F0B07CB07F08815576A6B1013C97E7DBEBA428C885DB7CCCFEC2C008865B335F2815F8785BD0E901C1F0E05C04FE5E8D59028BF2BD8BD1FA1AAC0ED2E0E3CBD1F9FB86B183144DE0956AC13708064CE433837DF4072C9618C6EF0F4706B704587F141A6B6F10B8373BDFDF0A325843683BD872CD2D4D064B6B9520E8751930D9A6D0D0A44C5584C21E7B194A0ED851580772792839640575157425B3D44E744AED4980492E0FC9250975238C6DD310F8750EC706084D10EB3F6565422E0F067520A02002BAB4CA400C1A0204344D051CF519E09726C7844C1DF852808656238C5B054D'
	$sHexData &= 'C2694D1F8545E061C00C1CE0B820541E0C8857EC2DE93FED6B1FA6478BD03BF78BC02A025FA6C90F4FFE2BE02BD1B622F08AA88BC87BAFC8B581D712E6C2037C6FA62AA5FCE6422EC877069AFA08FCF20F51C0EB058E05F206FE9BF63728302F508D043699F7FF8BD8F855D6879BFB01244CD83BF87C42ECBD3B1214AC3803C6501DFA48D0C81C20774C53202DD8497F58461E7ED060DB060B177A3B23A1AF40657F38DA19E80A9175125DAC14A21EDC55FCF1280C7C0A9C1C33F6C2D52BD855483DB78D43381D9A50C87EA3A1EC6A0003EEFFD36A0AFFD7B7F637D321F83B75F47D046A322A4612F07CD399C94062FBDF6418883024C6748449800A0230407BB0826E5DA46B4426A897AA838C5D32B000A8CB3010020737A63C840F060FBD402A3CC645BB8649F8134B012127B27869DA432280A0A08BD743493D29B2B41B9CB00DA375C00C2BB40AE8236D017EC21C506A012B0CF4E0D00FCA23F0018031FFD60603F0416E0E57CCB5DB95065EEC018ED3807DFC7423E16B6E4BD8F6A4C61FBCEBA6DA224822121EC06C505D1D1E439F281EDC9A7D0CAA78506D403A3E0C3F690A2E6D1B1AD4A8A10196A6F0C4D7C8B801436D9BD85FE42C9960284BC467DC1B5B0F16594340349C4FBBC1450A4E1CD0B02D168D477EBC505A5857D3740F8CEC9B8A1F784CEB2F99A857504DF8A4F1CA172BFE8D57DEFE0D294260A2D30B001483C3C03572CFE8FAEF1343900A82B0FDB00D0406258CC051DD221500BCCEFCB0019D808F66201F81EC042D215DA51BFCFE024AC04576AC2C9D9180C0DA38182FCBD213332AC2CA1C4202DDCE29E84F0166A188E00818C64704415C4161E61EFC505717B8131E8B4E01B7662B2C7F1172C8A35B003849549581FC7B00E363AA9E3028B5C0F77C810767CF0A3738AF258B83E0141CAB6AE8B75990EF90E857613C35859D968256C5AABC3D59CB869288F3C8F702937613DBCC1C28DC39613233AA21E02B2CC0D9A41CE45EC5C121C85D13BD9753CF1434DE8B7303388D1354D070B702563D8D54D078BBBDC10F470D057842AF79C0F719553AD70412742B51497F4B4A7F7B31DE08663B0E751E6686A9217D6B1848F43B4E02750F5AA5C0CF44442875DE33445859AA128CC8EE87236F700C7DEB1833C0398D2DDD5931202C40338BBDCD8B7810DBF877043B7708C44381987A12CA4849E2EF8AC4535589461C6720D0241820D04B55003A84BE56C6BBC93B3130EC33CCF7A18F251731D30AC841953F08C06C1780DF1C0A0C3B58C6496190640839C8A9DF5B403408A0E03DFEFA8BD985DB452A928BF3EE0286B45C215E0683C6DCD350F60435B3A4B053A05D775E6042173AEC10EB427C4427C8033958253FEA701D272E8AD8530DA88BF0D973500B6'
	$sHexData &= '03764F63B416EDB54255C591D383C0C9D01B40F27B6B25C870007BF7FCAD590DCD46A33F0F0EBA255CD422557E944BD2915CB2C88B6DC5C0122B056C3D19F1392194B6880BDF721300FEC7BC6E90C9453CC9B542664422E89EBEBEBC1050D104EC481407F13022547AA40BC0504863887575B720A56157928AF1DB028824C3803220AB2507F39876AC8CE566DECF79BB414C0192D12E84B55AA8D48376F2961AB4EDAD6C823F49DC8D5C55F5FAE58EC0D393BF1F3EFDF21E12802D12BC68BCEC1F8055E25836C431259882C4788DCC3D96E65C14433DB756AB62BFA2F1FD3C1E205EAE0410432F4029F339CC0A72A86410233B881E1DBAD8D21B52AC81EB092803127690EC070CCC12A74D4CA250372D0D0D40F5230C17568A943A5A03BD85E523F0A72295C33504251FC2371B6F0DC7C8B8DECF76395F0B0AFB0E1E0073241408527EBC07F19B620C131E78B3C32EB9F0222082FB533C0AF0EB9D3C65F2C2878593A03200C8CC590AC7B9E147D4C286B0E122A31184A18E5736321FB394D140F4D06CC2016B45F0A7A49D8B864894FD88D842C466B50338F44E110AD8880435A2EFE080409E10609360232C01AEA3450E60B46072A785D7B3020090D001E26581CD020A89A56154E1C51DB6786997408037C1803748A631B267464D6F0F75607EDEB0A8B3C302E2C22281C06E0B6DE8724A8203C2644FC090D82BFE55E5B6D4F132F085F4510564FC19182537CC8C8567EC8141A0B0C1C10AD89A38203437B7E7588FB035B9EA7E02CD554143520F8D89AC1C1185C28CB5A7C2A03FE6EE09224D24C9466F6DCFFE0244A03F3EB1C8BF2EB1857315680D0EC6E420F45FE402C0EF3741DF47058EE747BD60A090DF486D0D621D0270C9D67E4C4B370EF0E36245B673820DA9125FB7110F30E4019974F4E2C3C018044FE09C5811F7415CE7BEB0B5035D850C314354C5E8924578772107F1C0E49E5D0184FC8189400FF034B2E038BC68D50FFA6BEB0805EAEF5B55255F6E239A0B8BC07678349D63000C7890A25714BDE80DCC72E031C700B326B35502730E610035C17927EF8625514C81803D6543BE8C5FF7D207C640A1C7F5E3BD67C5A3B4E7F5415E6E7A478201C1C33FFF2F8F05F0B22204FF8BC94C30FB6F3F180E0D11651B348259DD2F1B3AB211899384CEF1C002024E8DF1C096A9201706C014792D69FCF0874A92AB086AEA80C4C035346D0E8A082F06AF523E7F644A4617EF1C8342F6C8B45E299EA75CB2C24085D102CD3BC4723A699180C341CCDD33CCD38204C245028795D5311D610587F302254689ECAA5385C34643C8D101642C1AE24F16BEB7D3B603068E8FC8DB698C4C3031C08815C35283031BA4E2F0AF7FA392D99345F85089CC9F1561043947446ABC44025'
	$sHexData &= '313851DA0A66103F0C1446464646181C20242E2F4746282C0A30013430D23E4580803F0C3C40B99176306A6044480D934CB12A7FBF7470C5E2292017BECD691E4885C6E86A30E89C91930928101C4B71465AB954582139B418E4A220A45C648124A7914FF36C2C2801440E2127CF8B48896870B032910C32241035A2322517287C5B510C4BAE8B285F04D24CC8E0A0E00C314DD31427100B3C2619B9C1972428309591494638343C02C9913C234C50C80EAB2905239E33EA8E0617FF7518DE0AE024A179148B4D0810BB615CA0298A661461420EB998FF5B58C32C429108ACA562281F873514819184EF84323F55E888E867C328684D9CB6989CDAC6991C1A7F4A9C67404D69E63EE3BCE834DE04FA2C8D145502B31474831C35348A6C93C2C1A545DCE322613BB0D54B2C853380676D013392D48B8B4427C657B7122785663A0A04919A489CD970468976D722310B3B7D2DADE967C7726BCB99737E8EEB3653780F29173D1561304B48EC32F4D62634088AC8FFC3D820D60B212549C2641BECB8928B5C7D100F4D18BA6C2EDB85D250D400D4BCFFC7D73384C4F9DC7D168135B120461E8B10027641883442B4787D18186309F63EB832BC7D4E4B732981C86DDC7F1D0E25004E43E4F5B6088D49505130A054DAED1D6D32C024000BC828BCFF6EA69C9CB8B4BC2BDC84700C4FE45167808785F3F022322E1052A5518C030D141B008D2875EC08AF2908940CEBD0DD20E24FA9EBC4943518C3851C72145FF56C9EF50823FFCB02D68D30FFB9C6A800FD11019EDC7503408B420583C8C8C3C6BC175B6A1BC940D26938481AB890F19838ACBCC44D8808CA00AC1591D3DE449B41513E88B440A064E91CE73DBCB1391216700AFA819C3D611CA8D1DEB7CF5DA4E8B38939B1A88CF0FF2134DE20087DA08BF3C8E894E786EA243C3FB4869A84C320E9B896B65CA03D34752E4EA01595CCCB1883C914235E17A8E508751C42136F530D8CC46998D937CFB4B1A5FDC742FCE537EA8D89AF8C077A4F20202FCC507E29E0B37508DB4DB0080DAD480ECC0A1CD5121A065DAEE46620E42CE882076B300BFAC8D8378A8AA3BE6A1172346A11701434F0D07F2F41F14C3BC674192BC37515066F9C807F5A9C585018DC4C324BE892A9D022020B272DDFE581912B0137EDA8B2474C321A2A02862828A385859C36CDB2168A5517F5945E959F87167B43038BCB7BE168AC38272E800C4168834196464E2303FA43401730AB119A5C2385D3150A183FAD05DE389AC3C5789F4E236BE499ACA3D596169A5BE103A49F02568BD0518CBC2A4BCBB0BFA4E0C275918A7F571C4DBC0AADAEBCD58608B810593A042ACD022D0EF8E068FEA460DA021C2B051850EB5052A56A4F10E96D1752DA4E8BF80A8A1D5'
	$sHexData &= '2A8E1BFF04C0815A084DB648B0DEBAE047EBE6A641E8B0C910FF404D7838170F08DB1A846A56888EAA5F75FB80C700F44C8516810782556ACD074113002300B4821DD867FF7B9FD753EE83D3A8610010F85B95670EB00E9C3A648393C212F21BBE2C3B760562320EC066A12D0EB122B40339BA4800226192805741B3C5E8CEB70644798814FD0E2E60B08A20C5798FAB0DDADF631D8505023595E000B530625747BB6C280664C23A157741150ADC66901E35485986792D08A4DAC4225381563CAAC771FC20084B01E5C5F8711030162431F8B01C39F9EA042C95C36441D369606B812E80F32A05B06D7EFE7C4C693A116AD2C0E3E3BABC013FA18EC40170BA15724887062C2940628DD37DD4725D08B929649048D3C9D833B34C844E1590C73E08C07EE825125405ED8F6807972FBAB0400115BC03B583C0A8B408EA790743FFA0C38029C3E4F503345948420E13E29E44A3654E7A4D44C56D720B57A60F0AE8CD181323547A816745208E8C6A32BB4D43142FC3FE2CB92E33B451406C3A890CBD294E3ECBA2A4B4A5E0594A18C155A073F0239E4415C7E180FF020E3DC86E0853CA1A423A1A9E65B3393A511784FD20FF8FA49A73D791F323D840C06A3991D58CC1A10019F7A1910BD59C47B4C2EA3483BF277134D9D1B08C90FA16F098D4745DCCE0135883780DC4277E60A7E283B46504551B403869A86C30902BBA0AD6810B49BD04AC6EB0D6275DCB4CB7E9265D34C69635650A183BB964F3805435D50A7DC31BD1630F91A2E0C0ACA0C0F8C72905315BF5D01880207F160589D8D70AA91044F62528D251344374E62DF018DBF0B19CE51B52933D21A680AB6505F0E43D046E1E091B1E28204E6C0FD4EFC0A32C983FA12A455EC668B85755284667CAF7AE98A857712884DA0EBF72430375984693F306AE04EB5A8508DBD6C4C8690E128E4AEF024844CA04ECF8910C40E24470441671661C6AAF828626442414341F4CD3C050701699F894638B64E30108E7D8C9B2025F867C5957890F46960708930FA78BA0770C22DFFB5BB8B29AD47900596ECA1E4A804A17CA015B7A42913A7A04125973F01300261F5D2B77F0529403B320F4CCA39305E0AC88BC1450D060B0974A264997FE65C5DB1EE14928D780283C780569B2C0252518448369A72C79033C903740D50BE5F28B94F4121794610FBB04EA585DF0C53EF8675876DB05C7DF88D5A0D69A781023FA4AF84D295942BD38B5E107402782724FA895DFCAC3450C64DB8135C8BDE894A0D6EE1CBD6A043A1D8D26BEF08F5047082E043EB0F7E2E6A4A06E1818933CB1786AE061B46102D2D4E005FE8E8103ED3DF512430680CCF421502144B78A3C159C39FC24A06395D451C02D5D39153E0E48840A1D2C000CEDF50E2D2C0'
	$sHexData &= '8B03E289E8D1FF57C9DA7C18248B74182085FF7C177F0E2A5180FFDF11120D7F043BF176072BF183DF3E0EDB83A899B5D80E750A4C188C8E28B438B6D8C546C02AE90627031E03CBED6E01B4E390B220BA583CFAC1BE7F52193BCB741535204FEB02B001EB961AAA6CDCA96A750ABA0DA19D18585C431B34D84AD29F8744181425C00105743B18D27B3E4E377F043193CD0EC4B6841940CA1938577130B8310C0B59CD1410BCE95F0799EB2E83C668D7FFEBC52384130CC3382AA81C49FA4FAE67343B45E875B81C6799EF020283CA04E7C7095C9EADB40E24EB5936F2E3DD4D696180B2F944A9717B74B5EBC95CE2D2A0A928AC02EFCA24708D367692431212E46806B7095BF9A614351EC2E19B240BC4DE964EAE00BD18781C0651188A0F913038090801422114619F9A3E7D0ACEC2614D2007D45AC02728F0FD45812EA5DD32C8C1F91AC96652A0E95FEDA5802CE66BCE2C030F5FF05E0F64AC229F5F5D8452B4927D1F3E25239F6EEC9CEC00742DC74EB8377E3AA9442AA327A16768663C4980150C729C19D329C449688C5F53E875413F3146B74E4177FC08742EDB0C92AE619D14858940FCB6AF790C4E8D4818AAFB582D28775153B45C1BC82103D3FFBD18DF929C02F36468D82DABBBC01815362D56E1195B972DA113BBDE0530CF1206F28798841D786291A96089404024219188760CAC803B6C8527053710E0EE647E27C92B8B8F90AF8B115740AC0A9726F9A2521C9BBD312634E4C51F5E077596B5205771C48831F4D4105CEE02612BFC4F45D1B568C8F1B86B123551EC3053783453E745C432BF683FE1B65C4CC6EE8975E0C642620B4EA35C25074598A5C4B512860FC7AB225BEB9F89378D4E5EA24E3E90472A8B8E180E8B118E0D195D90DAE1A816A49435D0B1E0A2C11FA4042447B891E41437FF5E4FF60869C4477D10FEB8C21F3F68B8A14F47F9F14C7694D01AF40ECC918EC8C445B87DC0408EDC4BBCB80C0C505C6459E444D31945F132D28007EB08B1A62E6629AB56089DD284994EE0513884167FEB4E084B06DD24C641AE22C7065BA23038295514E001E173FE51125109E2A3D40FCF02B792E5D5F604B9FAE0048B58D6BD7C7F78C01440112A490ADC3FF8D04C8514578B7A13D78D421840F02F238BD75F5152159A82361C1FD1C87224721AD833825065890EC66CCF830536A44204EA3B56BE181231A5ECA55F485D1E6457EC8B460E8C8083D41B5A7969905F2014105BCF5F5251A4760B29FF456DB621DE8E04D061A4BE2AFF042B012F02671A44A8DF42B8C94FDCF902C742DF42261727B69DDD3433D2E110C1E425174418C0BCFFD4409E5C5CCF3CB1AA61953D09BC481E455FC28CCFACA41746853F5EBE0618903F5D6FD4134536C239CA931A510'
	$sHexData &= 'F62EF3C10BB6C34FAEC1D033C8517B06E807F746A8FC91A7188E2D0A2720CAB14F1418808B98821A5870227CA7508E321EA730883C0BB4CD2328F5717935181C36A5B6EEBD634CC859F56FE566366244365066B948A344DD36CBCF40A08080C0CC3F146D3101036CE0F7764A4E2242841142BE6C71884CA412424CBE31D0F162C3EB65EE7E4280E71C4037F59171958F2B17CFD6B320801C5D02C83DF3D2D7C88B58901C9E583D84E41FD538B59CB204522F94D8BCB5BB4CA4CD3D0384798464726BD45AD4227A2C23A4144858B0908D48055E37F68B8B23034EB3F88A6801456841334870811B6B33A01A58476481DE83738931C241E723C54F961DB660DFE8EE55E22FF3325105693885F3F5C748BB0DFFA24F450768936FC8B2C8B4CC00C23DEBAB781568433F265EC7BA0617B266A740E1383C60C1A75F2BF365B30FE95F55F0425A85FF702E788C950D823781B035199061361109FCAEA01695F08AF07917E0BF12EBF8F4601AB60FC6A5E362F7161C2BADF8026545530E35F001CC1E8033BC1760FC4ACFF7DEFC3BE306C9D2C549457832E8900C3A132D50940661D7E2B44274B9C7C4603C1062AB6F4E9023B7E26C8DE2E5783FD4CF3AB5F785F8D20C8AB6844FF5EBB2994A4569CD5B295280488D9265346AB97276C2A96B1588587B9CB36568C7E18071C25B2B51AD8AB803FE86A1015A190B27957FF503EDB58ED0DB30DB70C5416F3540F1B6F276DDC36B6B18ABC8B3D9FD889CC36FEC3210F44D94B23C38D34F3E36D03C83E0E8B7972ADB013206E664A3C87301CEA140083471876283374B0F12885E0D6CFC1C13A305B9F5F46246E1F3A8C9C5FCECB8B179FA9CE4D7F0D6C6E6376E22612AB339C8910338DB79F08DBCABC3B2BF1850C6966E4531E773F8015C20A5988EBE9503F7429138311CDD1153F03C51D622582BF3F4F1C43A1DBF8D8571489EE7969077F564331F810AA008D1C466A5D7C00024B524A53AFE85D0D6050893749D0095E8B0F11A97F4904418BD05BD03B555409DA85FC005DFC75FA66B630C37E943955F47472C28D778A826E8B77185890EAD60F783BC61AD9DC4E943EB1198CFA56525321D6C0640B1E2F41414AAC52CAB1BB0218D8C3D3121A0E8D48901BD2C176C7890F3D6951D744A9B21AA72DD434BA4B60022F75A0D4231C2642B9FB26B40A630DC313A53718508014E902FE0743F3A4072BF08B5114D1FEC17F39687C288AFA89711003F65650896920CF105056C88B02ADDFDF5F089AB59A7530C57243EBC52A3612C4F77B104CBB5304140714340CD02558B3EEC810FCCCB5A83797A004D06810013307C0DA48715D16D95846F7B748100C53AFD0CB04010801FDA48B05221347DE7326369AE6D8044655A03ADFD9566BE255C478'
	$sHexData &= '82B8096C05AC7300AAD0CDD697A955B5331796402EE6EC66F81132C82219837DC4027491685F22576A31B649C16F530A668655D8D459275181420EECC11BF1114E1B944C33F675286D2CB27F75D0836B0A298CAE46CC1690B0012FE1086A742CE5672130EC34200718829B861D16C019A8D441030D809447C49B406DE879956A1406244022B391F674503C58380D3C8065BBA254FF1A3402DDF2BE001340643E68CF4853D91869586C70F90D1332F8838B5A506C89707061D8806091CAE4414CF666580DF74C14AC3E5119C7046B84A6BD50835AC5B1670679A1A9BF5F452C96083F408D771456AE9FE483513101593D0158B9806F53AFD47D0C69745BA62A409FC4746D244207940028385FA64A6E1688F808A385DB1BC26DA9122A171F080D682D542FA6089846E004EFBBF236BB01B4EB037412C10C0A024765C3DC75DA4B0A9B320282518DC003DEE59909979044EA9A021E01AC3B090F45D95D7200DC0F8DB2EB83EB01743208B704831FDF278B8FBB8307D86FDC1A6AB001D58D5FAC11C30D7C73285661ECE6E495EB467B07C7430A400ACEF7885369F09F7402F502DE743BA5C800467F7D965809ECBA476A065857D9C873EC0896DC693FC84BC95A28241B6C2239119F5F7DC1F8809456ABCC58700FFF170FA55C7A4A40A42E47C00A110483C3F8248CDEB2DA8D4AEAC213C24D945E19FC4475EDD0751885B26F747E6C8B7670631D0A5ACB2A6817DAC8DA41E3E31A5204EAB41675C37F8888D6BB31C819A7491C68C4C1FF31D226C69ABD9F092B4D858F279F8BD149116627530A90499FF44BEF89D173084EB383E8046A2B12DC464642BA33230AB76A6C3F9F950266BF09789801F8395110721A5210C4AD510AA4C85128B42A68A5BDE1E9FF11A9DFC07A103BF7771789721082C1586CB5801F82CA2DDA725E5B627ACFDD9DEBC42BC75C29414E478D3C7A60493A29E40B6B325B1F4276080C9DB67A52D35F532152B5887F7CB3853785629F9E8048586080A00CA0FEE02A538BDFF94D5D7899D84CAD5B8A788F4DFB52E12C984D7DF71F50081A4A9F654F9981251744D7031F3360F0DB0F10078A925D7EA547890E07290E8D5D9B1F6A85B0536FF936394E7540417301380A14A1536FE4C1F5134A379F55F0C25784C869368378020741111861A864A4101802334F54B256957FE1886DCD893AA59FF875A2EAD4F21094003E81FBFE36FC9F50495E4083FB07771B895E10511D429D0D9EC47CFD8BFBEE017757940781FF617630B806BF17A02BFEE203C03D0B428D4823FA766B5181381881F76821117353BA4F0A23F87FDB016A988177417275C4EB148D41232A3861FD83E0E08948FC36DB850128C5BE6B54A6F5832322FC2450897E14B046A02C4A3ED423305C5B8'
	$sHexData &= '70ADCEE7C9F7A381A60E2E60FA47A0BC1F038EB6EF6D53A24C002007735643A1F47515E106BD36A26B7A0FA9EE218779B575A154D0803CFCFC604196A30EA8D00E95753FA57D402198A6F11444DB7889F8D27411D146C25171F0CD0B16EFC7D06411FD82D6A7201252896FCF11613776CFF3C1990090FFF60313F840CD20F0F0F8109015FC5C07D9BB223B94280BF79D4E561C920132816C523737480244F143EEBC9F3C5AAE2014B01EBE02D02800BF5DFA4CD4D7444394AA8731D90587191026A7C56BE4F5002BC84E6C03C0ACC994B0410625F36AB7FF80F50200AA63BC2721B8B0904AADDA16C1451890E9E10865E03E607EEF90C0F1801FCFEE20C3FD15657F502F189028D70BE59C6062EBE65EC06C237D90CE8E2FF574A3AFCAC4D27A1CF39A40D5F0A142FB3EB61BAF838F12F4DF537D28378837E4C0074C0432882F868A8FF2174013EB9B9C87418FFC088DEC4764C993044084BA57BF799C15E9EC3A88043B8C67F5E88BA6921662E0B4510EC21C8743E04CD774CBE0AE1269C4903C9E2569B28DBBA07C896A03632A78904BF8847480188473E2F37DFBE46A04088150E44893E894F408957B9FBF0E044C7478B5F695FF80F4EA4384D3FC096E013C003559A131254B1B40333EA10F870D0D8977FD87356A66C901D837A426A7BD020D896CF887320A4451C36419388ABCE208947723C08C58E0B74443906B857548B082BD1920AB44AE1471CC2080C2C04A5061382775EB84C65B4F52573890B76F4F6A0A0898973EE7B14EB2399F5C425CA038A008D1518EC0D4BBE4310B8884DAD7C2320042B82457FDFC718FCFF202E8D4F3C3908751A837D140175D6FF587A616E20750C20C6FE83D0FFEBBC2087BB0614200BA4DB06C5636663C20A1F1D14DC9F040C380BC175068D530CC366A2925156471C795E148C1C0C714849000C4024D7B0590805C041801C3FC40F031EEDBAA95824471B8C9F3F54836C2460DF5FAD38AD6E1D21C4E88B462D06F0FA202E8B0282547FDA5F6414FF0A1A1C4802890A7E0A3BFD14CE6656C9750A8069F8596F1F8B4E5446C369B0DF98460C5C5A4E5153D8C1D9A2095A647C1060E291744C75220740E029E9CAB235C43ABCF721DB8CC19B5E493C3182DF016516914E313ECE508B7344EBE27728A2C814846A148D4E3112D46CDCBC66A5D1D4A74EC03C1DDC9694440FEEAF93A40DC403FEC8C69A85D1587A8808EB0FB3CCB5EC5B913AD20C8E168B7D59BCE766CD4DF925CC734CEE06EC2F008DF8D051E2C4AE663C011C2603A083E82A0AD653135966718DBBE7FBEE74CC8A1D8EB155D0912BF8C929B04B7A3BC7E82F1A98E86C85C7BCF604D7E66EB4043AA8C5200CC15B4B65C4FF704CD710DAE1E19BA6652EF38204F030CE54A4ED'
	$sHexData &= '2C11973CE2F966D1667E5B0A14B36E07BE8A321CECC3EBA279794EBE0E43B9D2208B8B75E4981DC402E32BF1031A7E247FDD146FA7844A440EFF4EC92CD6686168EF3C0552EB64B72EBD19F85820559FD8E6005A8DC79BA4E6001450087854593C05CE3CB7D0BED20657FF501C6CF83FC7740BB12A74243257D8664019EE0DC0C39FF1BB415B35BAC80F812F0C707328688F2E9075DF740604FE751D0833C9E267ED674C428300FE2EFBAE840F44C1A83B18195530045E5D59C3D792C951A663733C5B5300EB964639421A566807AC6D1074125E0CC08B0375EBBD57E413894650AE8BEFE24829E334BA1E548913E71044B377708355C90C16C32053456D333F34C098A26A2ABFBBC328841E1C9AF154751572C0F56030C08169209D19A4795B313025C868B732BD20205F8B322063891E5E7355B593D57D6969237134A10A6D24385E2C7A536151703E253838CB1E1E8CD6A07ACFA7C1BF77D8CFD38E02C406FCDCD0F974F33CDAD84640506F9C86E783D4120102C6FD35FC0A4075D8EB9908D4662BD87414D3F42DC9E9230618780DC9F03BD875BCD8D8399D4C7DE4A4FEC6463E0EC38AA8C3FECC33CBFE21B5788B41AF0851B059C31300CCC11FB4C9FAC2AA9FA5E043037AA5D4327E6107A0046E70285B8942D616363F2946807EBA8842AD2109335796615C0823532F340D0D4CE01BA480AC9BD619B8FF15E515C09185C4CC561838AA858908C74001901387109F5FFED08080D41DA123A45614DFFC423632F5250DEC02D6F5E7D0138B425424223C56191026C0DBA338111010283B4A50B6063CA3DDFE8B302BCEEB23F6420475522A3496E86DD3AC3DF2461624345E4403C942031A8D840076A475930CEA1AA054F9BA1F715046237EDD496DD23BEB0C28E415C3218528E15F536402DA492CD4F1E00915299328A2925EB1B7050AF61C047404B2B1D27CFF40D283E7022102B1C9842794BD87E96C6984C90F5617BA8B71035D14D0134D184F8992817505D34E2C540942E950EDB270A2EB110D0839BC2B27BB507303890893FE38E420005EE20590589939B5A0EE880A87AD72D06A70AB3213500B44A433136CC13E405E837CA6DE7D23C08E529E708B642C29D5CC9646229F1CD06B120602E0A68854BECFEB4EC7D0A02C330C70312D6980D76024C47C58D731207DBF02F10C487A388D3C5A1E2BCF298DEEC157EE384E120DA3025A1C188964102C2A0D61FF4D405FFDCA017C02C55E69201D7A52B95BDF20305C206316188BC2E890868171D092D61862E87065B3DB8BFADAC65B562E8628E3DB6E590E857C38B837C2BB1C43E90C7218C34C9B3DA5D74514956812019B8B3206F8EFC69984C2EB6083E20380FA03E4D4509AE12C9D1BCAC3CC2DF8908507975B328E132'
	$sHexData &= '0CD3253EC3DCA4152714D4C11B9761031D4B883D5037D0C3A7AF6AC5CBCE9D8106E59F813939F0B5112D8101874168FA7F89A1C7B0C2800DF8D147B545E23EF04987840282160B1B81DE731729B0EE68B677667F92856832824A05AD64D14E518195CA61572853B7419DF38935B0A3214C0B941D5A3A25A4A3BDEB84A1489E8C05B09DA4F3BF973F207AEA535B87342063802AF0616993C2072385642F03BF7865411EC76218916400B5CEED96526461E2C891C6C0A9730CCD8042D3DE15ACFDF8F9F21CDB72FD74A7452455C0C3B30763E4DBB93BA0A34F9740CA4FE7406D2B5A50AF70275299EC6423608DAAA27C3690833B6B7C122CFF2C0870AC644E15FF00C589D3F42FFD816B68109F647A8FF7158767CC215365A750B0FFB476E320E16C45730640A1E8D1C48DDEC3F36AB70603BC37326B85849890A65B452A13E200B0C4B1F2C99AE8E4F38B8AD6F8C5FBE0C4A2F7DFF0658DED1FB83FB2073051AEB7AE9B3A194753F7355224727588D0F716103C06475070047C9ADFC526B575B0F863F5CDA2070C917714C81990370E945F486F210DFABB4A5B835A482E908533033DB25877570349430045CB8E4AEACB809E57E57C6E01F128B5DF4505653D6C8D4427A27CE8B556E03D303CB541C11C0526C47B2471D1E8D7AE7473347D67C5C67217404171D2D1C09703D0C232C39241E5CC64BCD406200108632687BE14AF253C5D9C2A1EA80A2277AD8C203990712772F1DB6F6ADFFE4834F5EFF104F20C91181068B06270117F602B32E02258BC14B604DB4069FD26A0718841201C620D0411C3AA174380200892B4D0F0F0ABC3041EB0D24CB6E5AF3DB0C0E4C509A789003C96F0EE86EC1800A15B675CE1964D8652B9A112C101F19E6308B273083663CFE02BE900B130F1A1AC0E23F791870C27A3611AF7933AD55BF602086C140202B4C46275E1FA1EC32F2483300B4D7C4161C104C1549BBCF42505F8E6D8DBE212E00189A07790DB60C747D000146820B014D0DB65E44DF4E70AB1200270808A3BC0D9021EB747F4698405233000A98F48C06AE6D07D144319422902490806D3CA405DF0F3C659C5B014640EB2BBFAB94F45C90902DA5A47B66BF908CAE2D46C9C116BFB848A680F57D1F5813724110DFC4B0112C6E508DDF945CF0167D1F4457004F20F8A375DB50E000C4F86C1163F4A1C13BC675179675FEA30E85BF582BF0D1FE81FE570AAF02CB763EE0772889636C1D85775157631602D25A90D4798C5205BCE2CB0781FBE5D4582E5705E945745A15F0187726E5D8001D9822D8BE8D4381B8990AEB49C333DB8691FA7764582383E3E08943FC709FE03544FBD80C39FF75F889C09203F91F538947141ECE780855FB5F388D0D6A32BC4D680C5730538568EDFCCE'
	$sHexData &= '097CFE66C61F8C773C566432BB2F4B696DF7E331807F33D0F2BA82BEE012F7E2856F4EE8B78BC126DA8BC8E22D03CEA9EA9ED2BE0903F083D3F0F9C06E74D9E0A68ED17803D9BF6D46EB3C130CCB8E13D078F08BD72BD11B007FFFA65DC4ACDA01D1EB03D113151D69C26AC1FE401EC1EB1D894C10F561A3513ECFA8FCF2C080853F3FEB2D0CFE470B8BCA83EE0175DF8877F085C010807770728D159E0F99D85E7FE7F883C73B425401D4C685965F808FC4F1CBC39F934F3A0E3D07084E38FF7841B1F84E582A77225651570458740CF2340FC6280002F30B58EE2D081277B8EE053C4EB82C17C023502F19E43A132A1683C3B9008708E4A61792EBF88E437CC37642EBC91B53713CD8F14DFC1122894F17C95CC082201E001F083AE40660DF0C0835E8940985EE540413504FC00726C75200AC2A5089C0EA30E5A325B61E10403F8B3281360A57FF3051892EDAAADEEACF5640121449B9D8D648EB1485BB270B51AA3F143D1A5C39551542577F79FA29897031AD24AF5150C740A37920574D0681082FB911430557BB178943B9AA9584840870507F2494407339B9D9D92800E0F6CA5E7B477275C433214F53F52E787AE74751847C90CAF87038578958225672D53E77080673116B3F85B955001BA40F0E57100C55FC8D1DBF84C8AA7B428B5F6C0432B813F181BEF483CE4FF176374F980EA0BA3D0071182338C8557B3D3FD3A6E9F8857B17D7393ED1E8E4ACF1EE02C87607BED9EBBA03C3936E314C904235828100CF0164A80E4F3884A2041EBCB09AB8134EF626771476C2092BEACA04258C62217E7E87458D0C451B420A3255C119C518443A6E5243098F8BFC6C7CA75157A07BCA9060304E8F7F3A1AE085DC4D1053579F5AD8C3839760100A1095B8D382C3FB8E4C0F891FF283FB036AE88BA23230241AD0320273F86486DA056AC67617167E1E7AC7C1913404EC0A882BDAD1FB923A80CA14E2F8E00FC2578703CE565F8D3C1B450B2E0CC256E7FCF02C6BC300688C2BF34D0DFDCC0A12DA3603CFCC3DBB29F08A64C4245E5F83516E0753D85EC2E7AB1C2FDFF50AAA417644CA5706466A77920C078D79ABCF589904AC188EB7B45A554EEABB01C6F26668819F60550134840C18E4C5DA0076E307BA5DE8424FE8FF46743920395C39247C11230BA37431A16CBA042BF0A44333D4B6EC39385ADC43075C2A933CCF0738CFB9195A9B4F43E0542A4726BB7E2A0738504612873ABF4A9ACBCD442F8B07393942F007D99BA6EB244EEBCD2187967F864108FF75E45E2879DDC02D8429A62843578076740392D712044E18BA8C3C8E383820885ECD90E21D7E21767E332438C0101D076A005303900379CFDC25473192C7DF95A958401892D6328BFB4EAA7D09885DEFC6A8056'
	$sHexData &= '1140E3BB12A4E25D012CF8D70F8532D7AF1D7FF7FDF47C6371C13BB4D0DF53E1C38388F8597A2C08B54BAEE2A2FBA89E982D85B072D85E8681860B301160B6B060F6B22EB7D6E800D107281FAA37207BAE1FF16A6D16B8B5E143BD3731C8D42015D07DE43F5FBEB5850F34CBE92D1EA5002EB15E465908C2015DDD5B108F51B56E8C3AD960E7FCD1CE48A623E8334FA82DDDB7507F47E43B1A44502735249453C72D1A1DCC2494E0111FF52B80460807F4A2183BC60DD3CEA89D6F5DE3C4EBC190E05BCA96AE24546A161A0F5EA06C01013F8E6371AD8B8E9A28B2EDC2BCBF7E9DB1F10B8D4C1FA0300E0C1E81F030E5DE41460F84BD382AED6FC0DD2AB38861251FABA5D74D1052BC60000426CC393F501D65D2B08C7837C9A75B271EC03C18DDC4BC8BE3BD041A3C1D4D03BCA4735B01BB80654E02E43C814D4997B1481F9A3316BC19047F8BA8CA3AEF634EB39A1FD137290278335824A8D702383E604669801049521BD8A3002C4CF2B4DD8356176708AD1039CA22C600D7C41BCB46BC02C03C606AD0B586E9CCEB8F162E091FA4DC890506BC22CD466B668C68548A0C2AFDCA804DE4AE3E801750B5A070FC6EE6606A856EB140D8BD7A0B010783FBA8CE1CF7C8BD31DB9DB3890C2A20B36438B53D0005239430B1250824D0433339C1E34188E456B962833604304D40CCB1DA60FD5A08EFDC90C2BC76BD12CC551AB3627A08A7044F32B82D353565F9847BDB0FED6538956960C040D351CE0C3A60E074F083A55260D0F870555162A570B4C2004D80CEFB07497B1E1D150D3B219DDAD61D1ACD3B97CD962B4ACE0D0925849BEF45A6A9044B876C8BDEE08A18C51327F1679DD537A9D0C7C85BC819F1E19CA3A12A6DD9A15BC2137EF78CC8350F9CE96A36BC62C897D03D607A34AFA516BD65846577CEDDA3DD303D7E4AD442658DCB1B84E05B352D02EBFECE44486563BF8CBD77F5545EB146115FF9361C023F68A16C50A15AD904E3DAC626DE9A7805484C6A5725C4DFFCE1F0A1856837E75130D837B08FEAC833AAC5F4884F394D1848CBFA2716BF02C6AC0D45003F76F4AB7211BE86C320E2A1A8984B07027EA5453344C083CDEBEE4A9AAEBFDD0D1FA400306C150B443EE9842CBB05A895308EB85D1FA523BC67D12D075838FD814024C669CEB10A2B4048706672375B089C6627F4ABFCA368DFA840CD66BB24C04C1A10A978BD01A031BFF914185D74A6BCA2C8ADAC7CDD604396E443910348B0C04699EE669C408C80CCC927A92B00F147AD09AD6D3525124D420789AE6F5BA0F18D90C24E428C0389706C8181E2E17747779D818978A01A56B0D542ACFEE83F1B7809BE6EC69821AD428C0A748C4A69E0186FC2D2F5A7B38A88F1AFF78AC4402B3D5C16D0C16D1BF2B'
	$sHexData &= '864E8BD441574642C688C0A0C103D3B658F64610E746742878F0E546E301DF410CCE86C1234804DB544A8125D8884114D71AD5055D858A1983018980D1852C5C51370F4447108D47142B58847F38261C2BF750C1FE6269C6A5D570FA393C3763C95597612734C3C3BC64BC83EE2C6E123A583A09877B6185E0E937C9C28FE0D6DFF9807F182960D046BF87BE50533B49B0DD3BFE238807363B073B19045D9A4757CF61C14C9053309E30870021D4CB479DF310D61A5647C06C36D1FC54B6461488B61A4715C42075EBDD004A52A0D9C9074989966BAFBEEA5A140095FFC871D33A55FF38462F1A57C49426B2BA0011DC783D3F296D35581389273ED62B78013EAFD7DD215204068D46E0B01E3709825103D718A534BFDC56D0EFBCC819E4D7C3CA68D0F15CC4CBDC757F8BFE2B7DC046E083E7E03477DDB9C4BC2BC1D6B8C77D10BCD7C0AE047F4816B479F0CAEC4DC0EA23AE3A4DC8F51DC1436E3B8F3A8C5151304ADEBDB9BC6E050300030A885550B5BCE940FA8A2A482EC8A6C0C1E1057DFDFAA5DB7EBFCCDBE9AFE7D724F7DC149B39185D7771A7B4E41E9D2083C195D3B35C3A1CD928E8D2199B0DD98D88470C5C1F1490C04DEE7CA5E40379949CD08B1E0F038101188E8A04896478F8EB6483FA798934413A6CC5C309B21FFE4A8D7E043473793DD26B61D0D0EA5C2E93DCE0E4DA08866A7147A1E0C4D72268B8730246420443760BD722BC30F5411C89580A84FAC12BF9E8C1FF05504CDB81BCB2B52BD05F2BE84A4220AB428A074C92C133E9D57F610364A88D95DF24B409D05382CA5DDC24370D050A98F4FBE503C9D0460133D00A0269CA06486F80C54603B7052523F769C10FDB9A21D0D0E0E856F9C77A45A67FF034F50B8903FC2E8D12817F082D0177439E0A750B022A68D984A71C9ED43453804A01D8D4926114FB28BB328045C2D8FA4E0860C3C72209C7ED81810E544C401E1FD8407D174EC008F20F5804C5B1AF7D51D4504F5AD0350F28CA3BEF1B0ABA34CB0F2FCB766D10D3C2FDD85E5824C2F21CE8DD0407D3FE83E90BDD5DE82410EC3609FA736326419CB90807AA9BA6EDC40E7310F4027307C184BE9650751AA8C151F86C303830B4F2884030D2DA703A397E62083A9E4A52FF72F2B8499003D210308972631B022AEA4F8CA0182368F615FFF43CC13B3B7505A2C1EB123BFA110DD104C037643954C104752C0A8BBAA4057558338CFBBC6A4AB03CDF61D502566A9052550C3B006234F9D8FC034A10321F00601228020083545BC6BE22961EF10968D0FF6961E9D7D3C669F08FCA78F088D0E05652D88BCBF50246F617CA1C1CC8E2004103D20055817B9067E2B8C0711C073943E02BA232692487EDAB6A04005686089781E32F33472023431B0C811'
	$sHexData &= 'C20437173811C9143CB1CA443F4F9EC56EE1ECBCA1C382E0CC08D2B149E9CD02C3217BFF9E9282C7A244BEC8B43C68B34C13B73F291559E043CF21124ECB661A6737C846A0660C1F12E215F8DAF0045DCA353084B84C5B375F21043414D22F4DCF4BED30AF8A1F06E900ED33F5E45C9FD907A2BD1B8194E8BFAD1EF2EBC7BB73ED07607BF23EB0703FA969200A8D042FE7642CAA1AB7C5C5D168B41C8A474496A4D4B4AC065C41A291D572D23A52005F0F8342C0240219EDF1F5C413232B96D763C6F8912497DC4D7EE0225A56CA22B75FC960C4C280DBAE4A3187405A18515574A7BAE2013DA73412135030E93DF41CB1DC09EF553DFF00370E4F691D7CE7314578D7A03D86CD80189EC183BF9A2D209A4F0F991D24F950F607291A4F0C6F1B06663E47607BFC63BB9A4B207F191D2F6F021E82F158E7B148D3C1234266158747667BADB565CC2F90511552E34014D028612EA314004FC04F64431021E23572E221957FA8D47FA24E008845173C3C85E93AE59B35753C3772AA0583410A70C37B6041530D837025BB980B531A25F44406D5CAEBCFF5F30890E2B08303BC2C5930AA8022AD013C2563C819BFFBEF883CE0F895DFC268BF1CF5F01EB04C19D92E4C933C92143FFCB1C016EE04E010898206FA14C08F10D4F9307EBAC10E30A845101F846812AA0085040AA83F32AE0AB4E5076488B37A54DFC1042554041990524A2B7F389185E5FB9A318D85689368918815147D46201352760841AB7C31F8D71604491A40C555A87ACB69A0CE94E1B7FF7B4F51B248D9183C6818D3E02B479C2015C742A528B080C702908DC51448D357500DB4EA14B499DC5560B1ACF469813EFA50E588BA9FF8C920D2CDF620D17B533014D7E2C3F43C02FAA573500F4A252504F92E30BA437E8DD0D80BEF9B6C3259B9532B0245799CCC57BF7F784C0293CC686430138868E0C75FA0D402300A4E85EC6EFD0B4781F4626BE4E341EC26939E18D5E5C9FA2606F666FA970E43B74EAB3DCD02D78754C3810740C505511587A21BC97C2A4904A0E022384805F38CC576F195653681FFFBFB422E4904D0C261A0E4311BE40631B0EED41025FDE5C12E11ACC82E05DEE02896164D8434A49AB6A3DBF218E740ABE8D615802BB4270A474162542462C68002F1E93E029242969005CBFC68CD3695AD529BF5178B85388E469417DB24C7F0C0132441C0A90343F35087479985F14368E37FD9869C6467472467E750F0918034DD31F037E78601A4C264B4C433E5F325815D32092ED3F0C0F00321C7E7E002FAE314C131E2D4C3F14D30D9B3937F133CA68066172D87D06E4E8FDD91C7413C7CE1C14C616DE4D194E085EE95A083862EA74BF4B042F80275C2E5F43A6AA192F04924B0849234A0403A8DB00'
	$sHexData &= '23441C49E780B60A75DE09837B3D1B4634B0627A5E1AD5D60FFD544E8B04B0A46A206780ED983A7FE6604BEE148505992220351E98A9514C418421578705BF384899C6D234A0C472042568EFE4207FFCC17012FECD202BFECC0068618A5E2080F79800F70C1E2026502700603C3F010206EA08A8201018681F345DCAED1E20A3C3EB0E71F3DC773E762434D7F433061C845E578C52311D2B4C3918BC0D07DC83C89BFC5D28C67A2F02CE1EBC1EAE0265F05E4A13FDCAF0D96F3022188B3C888B4A1E784948BA1BCE703C2CF6DFD28B14881701385B8B4F001CA1077A049D1105C601B6A2255BAA287D0D801B1F77A3A27408855AB8A13E41D92C8DC645FA323C0783062E851C67530757063E90B32884A01A45E834FDC215195D1FF44CA30FC77F6737EAF6EB076746890D83EF0175C5AE0E0E2BE39CFB5216F22C41C1AD5CD09CBDB6E2C2FECDE0C783DB4ABB422FF63460006607F5182472696EF05A2CE3068B4E0646539A5C3272F6ACA0B6E5FE1B1F2D9E591F11E30C47428E0E3B1A526CD00634F79C1C950340DD0B54214903CEC0340CBA27080A34062594F7A60743ACDD2576246DE45F02002237F5C203C6833306C7F7C8C13A385EC57F05CC21E120995782A8800C39780A33A57FE0CD0E83781C0704C118520F061E0CC60BE1FAEC844210A80A51F79449C956BE6DE6902A7D178BD890DE0ACB516E0965AC5CA20D35A102A204C8609D1A490699F465D08821F10B4BE84EF3ECFF4F2A959453DB3B2E741EC04A26F7A715003C3635F43945E475E5698207436D4DF814F0F8E8C6DFC2D7DDEB23221D052C89315A3017665C012EC3512529F07A06049EE3BF9C7E128C6CF056087F75E4BB7DE710A59266F10A416A1A1CF233C369D8E08155C315C28A55508D0CD8C204924D2600376886D68B368B18DCE06C3D044F395DE46A40D061A3E4DECE3C834A06A6E03B5D48E69341A528C3882A28102C70AB600F099E1C6F54C6442A739E4DAE182B80586430DF500468219486B40891601360191209482AAD0E0C23950EA577E35003D080063F9FE0B47589027FD236836FEB08890A7405E2EB9329DEEB033E5015F8F6837F0869607E23190ADC079FFC1130400165035C3C4F21D465AD1563D22176DD2672E5754835C07ACFDF54B5354B65EA53F443669DCB0B3DD0DC8081167881433A7DDC3955CC9A8511A8FA75583207FD5A0531ACA17D6DEF0C2B8096EB05420C9BA35568ACE0F10E8E2B45260A03F880DCE8A1927227148AA15A624A6CA8347A8D01CDAE8FF87838C506C255F04EDA5652B554200EF25F8C8B27EB83945E7B3D90A0524B408EB06BE7F900B1743FD8D429EA4114D3A287243360D5DDCDE0091B99CBDCDC5FA0DCAE6BAA73D257D0A2DCC77548502CCCB'
	$sHexData &= '3A9723DA9AACCB2F8C015759320626690D44EA1613072FDDAF6505764581AA6453416CE0ACD021EECE2661E403018F03C50874258B828281A438AEFAA9875B50735D2D4559ADF4E176A1AA0DB4E11E138835C8105E0DC0AAAC76B3FA1FC6762DFE43308AC3EA70C4C5DB90E8AF0A35E9CD4DDA08887D06645A374121F534F7442C2567510E769A1B53D854C03A4C449652DD18DE0A4AE3460C97D2ACA49C33844FD44E1869940E996BF704CA3A92E94501622492DE8B6DEEF01221483D66D5F201D8807EDE70EF240BCBE350E64EA088B6A0A48DFC4A45212D70F25B1A581774714E501015D949436009ADA788F112E92DFF002FC425F1F03C928535156525141A6161B08878BB270AD38AFAC8C1008282C5F83032582DAC7BC6BB09A0C990C5F864450EED6560495F58D8D0A83142BC13BD076875AC07677603B16775BA0E20202B500A5D84A44D68907B10A02366B67043B09B38A437C86134AA79D2290D660555FEF66C0034585116443C009F876322C33C34316D4AC8101909018CCB1436BB30FE253D7B3066F1DB8F4B2F3AD8C2FB0A65B86C8073DDB36640A8023F8FEB947C441411DA656E72283076ADD6770C1328034AFA840CF74BFE185C160282218D0728F0E4E14078945F4B316150DF2C98C500A65762D84618D74553A23ECBB5CAC3D515352452101832E399CA480DCFF281C2A69FB4FEAA730807E3E133287343450BD764EAD902C24BBE3CFF35C21CB981F1E4E44E02DE188463E8A080CA4C113E220950BC996ECF8573137D53DF87517FB5F5C7148C064688A80953C1A05B001497328B69FAB9028E0A480576280BF1A2443B5B5092B48511BDF1FD95824CFA7D024644E09F83F965C5F94A38874815EA561909C7CBC4D3C847089110E9834C3C88100119F25AF03405F4817B366C21E9DDE470415071FADA9E0652881EFA28D70012BCA2A0A56EFBA96B8318BD1D1EAE3EF17E3F5E0A9DBDA14C60F43D881FB6DB5C2056E2BDDABC73CB3E12653152A41F9828B885C0725705B15C61EC66F42575022C6DEC1FA70FD0292072BC851505685EB268B0FBA5D02E0367172117806BF4C408D14C6B12C5202A882B4EB08F4547BE16BA3E13C9CC0CEB01148D43FCB0FB636D65F44EA6813E417720C5F43AB118B4BCB95CA83AB0CFEF881FF20071A6E2BFD5FAB0CAC4186574D106541111A6AE009356ECA8AC913720C6903258B0B5E09D87943041E225083C208B049651A6757CBB4366C08056B615F1898C10E04148265F4321D06D0315672730ABE804BB477AC7746161B80793422FC8D86038014C62B699C9007AC72AC4448E5D158A32AC7F90D954372C7AC72FF5FD0C14B63FF435E187C700CAC4073144E50D28D34079608DF65C65776608B33159250538FC604'
	$sHexData &= '4D55D286408ED15918C3D2044179381F9D7207C6BB3356B012C5C09A605B3FB990411EDE10F0FC24879C1CADFEF8F411F2421EADF9ADC71A1E2B79ADF9B0E4F8456AE070DAD8503942A7769C895C518D92C2323CD8C91D04474A7668F4432EDC60D83D148E6F6A0D0FB8F562A8703C8C18FEC00562B341261053CB56BF5371645CBABF0D10C5416025DFB8400E7962DE185104249E020EE608E902571938B78879B4C26D010EB065878E41021DC8D869F5260165CC248E086C7F4104231D193745A44024894E56023069D9BF89A7F4C787B0000112B45BC06D02E68BF4BA2E352A5511740E5081AC110BE15A8F86493AF60C8B380CBDB4E42C204DDCBF472494D90D1CA057BE2E4CB466182C2332E5FAC1D690EB348D0F83CAFF3035ABC8C24D03B78328F76B398949898F17F3BD5B3EABC20D1C7A23F2769166100A2575E05621000E660D18654851298C8A71FA7E120242156B1C1A40E085BF630D7A343494F9E35BB820941A10E81D0CA4326912B21F2A02580E4574368B07A892701266A7E0BE1142B6C62C8D7F2C7CE3895805F875CA7ECEA9CBD002C559849252A0C31FC0790F22837F98D44101CAE572414141B5804504C19DC0C0821C46380E04DBA95AA3C12CCA759F2B80510C5C5E7F660930A2FC122277123FA93E01D49683EF2C8955120E059B3258D518C3F64F341205676C56336C75CD290D009CA5870DBF001D005CFABD5417301A3ADE392BD9365824E8A675AFF43C5FB04E019FDA8BF13D604130B8065A91E077B0C48874919C83C72C705881E49CCE1F6C0219E4633D40C220A02749BB244DB8A855D17401851A26B4AC7110EA19F05EC0F61BFE548EC0A8F4FE3504082D0CF3E04645D023D4A95E942ED8B09C543B120F24741424A40D1BF5F20045EC412CA461230B4B001D12EC92B20ED2316878498F4624B8D4B043A3238956333C7C78987642CC10425245C818E8ACAC45CC45D0288C855A310CE396B3DBCD04E619B2AC56B2AF4384604801FFDDC1698F13EA7ED08575C413D4942A580D88C09EC62361ED29EE01880CE01E3D05305112FDB4303E5BB030444D0AB29C4851583B97BB070E99E01F7D3077E2128F009CBA3740E04FC07064C82BCEB88FC8A1D15E2A0C02804249E018F4C68FC7912800263D0659D2C410B0B64F363C082A00AE32F0B83760FFB5D1A4E9C0F0E8B64A8D04318BCA707B86CA3BC2E80079314964AA0D115AEFE80239218FB64AB64340524AC0245E4B6A7804D240F00CCE8BB0D792405118AA9E0434AD18F004D0D48340042103A993280509B80DDD76408B475A57C8280F5680F3FDB01C8BD028EBCCCC54F89687C8210F2717135858EC4A8B57474604302A0F2B8F91E12097EC3A4CB7A45103AFBBB8AFF2A03783D84FDED'
	$sHexData &= 'C030E300B8342DDBDA6227423DDFFE6BC30A882BF7874E10B52F0D60884DC48159C0CDBEE00F985CFFCA88081C79842C747851C09784C0CAFE84267E903870453A7E8132A0B3003D604D4462A3948BB20FA0222A988C7CE8111C833C883C430E8262E8CA07E81E02E061942530436EC020E5E68D0800FAD822E1436AE47984A04F90B1B2C1D81B3C47081C0DF49898BC4432EAC901375E46F4CC05278C3C683FB394589D5C3FF643E5C4840225E519658094BF9A48D96F18B9B099C06DD022E8A1F69892CCB424214895224CF0EC5961806BF86B03D86B4800BE44BFC897D0F7909C7C80E2A2EBF4F290639E40347473D699A91914747475647A8A6F51901ED5C068E0D19B1300948EA14C2C9D4044B8CAEA79C4A4B1CBEBF8E96E4855021B223AD190AE158426BB1C83303B79C3C521F100A6EC8181E8449A8128EE303C66EB7921395461F646D298D068CA6B825FF0A370336BC3BF80ABB898D77208958C261CB75C81A8A069B57194FE604AD46104608029C703E4614E35E5AAB5287CC75C04668AC32B551F509851646D1354EF16606230CE438DE75C47422192AE397927FE0185619E652F2E434F95B1A9FE28C624275DE448C810A93333D45D0D0608436343E42EB650E3C57088309C7F53314AC3233EC0589479D47A2F3C136CBD6EF205975D689CE0348B392C6C083C620231F260C00AFE48975C8D0CD811C241BB80FB0269F607EA8BA2020E011DCFF64AD0C69252AFFED2EA091D1744DFEFC05DFB3712A80ECEAE81BE0DBD8E248B007C3BD6B81B103807C3E2BD722FF3334F907C1FA0552BD668D04178BD1BFF7813AC681FA6D318BDA9AD468E1C1E3050C04283D4F50E696A1275CBD29961EC86650BD5F673606D7A45387F0D8139E496D3003CF624D789418FC04428D412066A6696C863CCB1F5B1706F32401B29342380D670320027CC23350660E565A8B0E6E821B2657F32557ECDBC027CC210E573A20A21588A503C1FF48C4443B893E8D4001C1E06C036C8551C7CEE68CA5AD141346372F0D80401F7BFC0289603ECFC845F8023FBEDCA9A5B02699DE289679186B0E814A13F201A03A7FBED73F48BE54642B4A02F6EB3A920721DA3A50A9BED0B415B56453A0C0863400D61A38086DFCD460C995258E58544B6046480C50685CD8B55EBE034806374878184B62DAC91091B1CBD12A181CE28A01F43686285443F385308D0C335E5B5FE1E361DDA9BF0CD000AC292B6B88B48379C407C0B4EB03573C798E4178E91F7DC0AF5E9327AECF3BC7A93EF97513C300DC31CD0FFF72626AA39F405141C0A86818D45AA93EC7E1366030D792BFD55352D30AC60A01AAD278C18F5413D8CF752198F83BD674005F3049C49340966D12E056C6414A1542DE9B562E75E8EB4C'
	$sHexData &= '3A18F30704A3EC5F4DFC4B2EBFEE53042FF25E06C706C6E990EE92F20B5CCC41620A981CCEECC99A89E2A92C8BCEA93BC7784B300086AE8B8AA9A900FC140891A0000EC59F0856346F747812AB19C8792107376C8B37D081FC3C4A0E72F0C27BC276F46E37867B2B538D1C492FE411D2C803C276C26F18DB0A21F6E1A402CCE8866277F0D020330F100188512E86B375A856BC107D60820E5F0A0178A727DDF8C6700F661745E3009B17AF57C0184C50062347756FF82E52B59C5C376FF0FC5A74E36A3C3B570E2507A83FC454C44F7991BC40C44FC44F7954C90BC448CFACE4909C08CFACCFAC740619A2FCF40E19AA97CA3F03F8B45A2D4DAF3E55B3A9B53184CAC63358414AE52A6F3ED0B8391EB77CB3F241D0C62E118BCB3BC375C823AABF2B6BD92C39C62E569F405EC6276B55F82C3A84A9401C0C3C1684844055360A18C4822E080B9C5156D5001C06C014A0D21CAA563F77B08CF85C955D0C2CFE5029774749656AE9BF470F965C4D58A72D1054EFAB716BC82CDA036F0CE042887FAAA68AED1F4EC856B86766008B33B34315385941645A3DA4990F780C0CF2C7CF3C085E035C65F0B837F3C7CA7FD57B4B732BEA3C89C1E70285FF3E1F9910BDFF47233BC7C7CA804C7242C7C35760D5B482DE800A0C8E5C4420F044F640055825BD81D7FCD04C3285D3140B3C9A52056AC08BEC80A218A882AF2E359DCE83E6F4333FF8FA41209434F4374DE1A3C3DF51182C235510AB819AF8E214D07494255838840085FCAAB33285F8FA093B4808740C1A84337BF26434164855267222D0FA088DDA4F0A218857CC7F721C819B571F1C56B80AE7F41D571FBFA54709CE3BB4D1FA85A5721C2FFCC76D8CCF7F23EC3D55555515CA0BD03E0854CE0A23D02539E3ED2D570ECA06CE3BC6752B0A3443ADA090E8BB424EC80BCA06C9FF9506A7156CF84034704D98898F0EA0505E5B95F078088B10030FA68E4509C63AF450C50187CBE6FC5746D477291C149C228D4688F82C61F6B65023335D542114487412D86ED827847B3A85F375F2A28B039D1016892FC18E830267EC723B5E7B3ADE02EDE40A8F71E803CF5F771E8F74AC7F78842476123D7F04247004BCBA8D4FD03BF19C453A265438718D00897610D604EE6B5AFB966A09500CD68BAB5268305A11A4174250D744350A4878A47713967604EBC66A0E5BEDD96B263AC6AC5EA1201C30C580D109BD255F911600BC872E3B1E24D0A73FCBE74041834C0EB0BB9C7C702D16EE0F531660D1EED84D96FE5F3DCBE28D1C0E3BDA6ADA56C863D0EB0C69CBE2083951C23A9FCBDB1DA45E42FE780220A8A98A51688606B006091E7D34693210832E92181B2716153213F83247401856C98314477F1DA12410F0D5D91D1DB175C4D7CD7'
	$sHexData &= 'E1403D96169C2B62B742A23A264CA6701771E348726E1F851CD031022A295D04117BE817AC963BA23FFCD03747782491862F708B0A160124CBC9C5203C29B8483F8333D26C6D6F8A05303C2928346F719C29AA14D05AF21144284211F7D86120A19635655E260202D60E0578626FF6C2BCE6B8B7B081048766B7DF462A124C725FD43481E90996BC7FFEB23360A8573CE70110A1CA49B0D5E73143A03C64670095F140C0FA652765CFFBD0431813E37F8BF310200692041C6CD427509E7B3565A5CC2ADAFA6E35520AC19D1FF26E00081792B20A8B548561CC2B154FFD934BF928BDAD20EA19005B69EB69808D25D609CA9607F5220915CC0772A40B090A77A18B17F5C18840C801AB0082784CF8B32065F5770D87A163A3E1F8B0820073431A5C396BE25E9B482ABC4F744A3FE9B009E06D6BF644949611CDF00BAA9652227F8E0773E10269CB834C0CB072055D2B1E2D9F2D90072424ED1F3D1B2F2903FC8BBD80F42D88D43D1F3D05A48320B9C5C082E3CF85F14205A04F43BD04DA430B45076748B1F536C0B7395F91002487DFC5C12A0302A06B97E6BA160AC90D503C266890C469FFC694A53EDDA8D43DA51536C482A23C73057E300B4955C13C4130C9764ADF34E86411039466984FFFF8013A5545701D3360003287ECC568D720146CBBC287950C5D30AD33B711AA590F00F34298003DFA856037060A3E530AA00FF2A5441880417C64417019D7620E7401B5E5F53A7CD2E24068A02C3880CA35E0DA9009B5857957F1B4E48320CAA851E84BC0353D493D4645C20274AD498100422C9955B41207340C851E0AD921EB8B04FE0A0CA18AC01C82EC34C4637B9C72B51501D86C8880C07E7C35060C0180305B60EA11E3577484A42C910CC0F353430CE12546F2414420182F1825D6A151F3C08C23113E18843F27718A0525A81E73F380C121E8B8EC0D5D6E244291D0B8AEC65819C9247D6E7D6F1AA52DA0C1B66905FE9C1286451F4192CC670804A698B898504B3E1F084E9857F50470282B2A6228E606B89225035C643A9B3E11C0DF521258967E3FC7C1B830F5FC891C00C80B98EA1C80015A294C6DFB0202E6979D8BFC581E4949CD8C4D8CEC5EA929A1790BFB990BC1851BFB01A694460BF4844219948EE3F3022D28893914044300B5AE60404DF4E2C083433F498148B889E10424144880A2665268F864505085697006380A3BE3BE4274058BF2550D248069E8B492CDD25D0C0820AE2C02079349F64E5249634C9FA30022B0AEF1D8D5F9ECD0FE96CEBEC018B4E2C085B9DC220C7D7FFC282BC60BB0851379A1C9209BF042F080961F3895F04244C350484C11F7F741B2A5A425ED6606B2A145F59730C438D1256E42357355FA410E4053B10536DE0076B071F24B8C3'
	$sHexData &= '1868663AFFFFF0088E59540FF7C3DFF1590A3C16F8AB4CB838C364C1973B0C56D33E03104A080A0C0C551B8301DD3FC1164B6D9F9B741BB3DB2D59B0D6B599A1008946BF763EC23D806222158A4E2E9D90C389509C5940A11B615FF7634F828A78105D6B56082C5E9920960890250E9680152DFBA92F0961BFC73E6A255008CED6CA8B063BC7E969FC863EDD4AB13F8C1C05F0DD6AD3362305709283DD6A746ECB8E20DA044BCA03AD059552473C272A85B00108C82FD68933680136B46C78752107D05833463E044BA38E9A00F49659CF84F0604108382ED67D247DB02D07B4FAF3AB598C42844DA39F263BE80C3A0A60F208404B193B5710661210AEBF24805F226C0172C4B214AE9E0873133F725368B8278FDF42030EDF382C277A71F086B7032083F5DF47F1F59C901772DBEB3FDF47DF3B1D24B808173588D15E25705DFCD1EAA8BB60A5CD8A052406EE0A76FAC26DF51DDD2BF18D3C88B838882BF84B0B03CD8E757BDAA7040A00682E7849E8DA7B3BFE77425B56B84B520AE02253CDF84AC403C4DAD4E002665E9E52B0D784BD2453EB42DA78D00E19841CB5539AE0BB9795AD5CB203C303FC4861B7015DBBC753179709426586832C3430B066794A71D1BDE468100521013508CC60C161EDE8A48A4317B7F9DCB9F904C855BFD8555555051EC82107E122DCE127E485BC48E127E11B42AE902BD8D44AA64A0ED4D4B9E420E4D4D4D80239190AD8D4402EB2B065350AC4162629A5D4D2D758C4A00ED801EF5A02BD11D0C06E1CF765E2840251DF5165B5010CAEA7387761C9B11F503F658810C2901D85FE1317468714E3006A405107103CCE8F108B0DE3E0F482602CFD0182100A0CFDB6FD30E5EE3C4E444650899A009C2E03ED70F4514A5823C56BA504D1360951B063D3069C4846A9CA4080CD616960B50DCC33C02922690E885FF8500303B57A8B8EACC78D783143232EAB65047C52135F0D0C28310A3F59DE8DC04CA52D746103C784372575010D6C25F3CBFFFD0D6DA04165E34C5589814C55B8A586D4648D173F2445A38191BC98D1B0E4B8A1EFC02560EBB43F996154DDA162CE649C5FBC26BD887FA9888DE5B40E46203787C45D2A868308F5C8D18447DDC41F65588C92E3067F18C0357128D243E0DC497C7499F301E6355ADFAD51286AD58D4B2C104324936125AB2828BD12F7231A382EB78D430C8E4A004212F45EC07D2B12BE28FD4C6297343FC9194B1C020367E0C130484B1CE802B58110652D73936136655E8E1711A126283DCD01AC0EB7DFC27549DA09BD104A6F086EA1AEF0304EDD9083B0F80E88AC7DFBC14F857A3F8D343F6BCE8C2C03C1500A0793804F58FF557EBCFF3740FF08F7DF1BFF6B4DFC2C0203FE6BD72C8B041A8904DEB3DDF0198'
	$sHexData &= 'B441AE84419040E1308081E0C09B5CDF30E0C100B108814EC9B58D52EC1BA03CBABE2859F000852D6F97C9345601BB83E2E127543D7560ABB2E753E146BD2F0CB7453528FA9D43C1AD8320CCCD33CCDDC08E00CE4DD262AF2A8E833A1F0340B7AD47D579E0C30D10763B01550F790F3567627A03383C13A7172B6AE52A9540A144141414102FFE09DA4A343397DF87CB060606068EE58B95CDEC13630027C4242421594E4724242BF019801583F5D2CE08B84F049FA24E053375783F8285CE9C54033A192DE4092CA58838185894E2830484DF0E0C75008FFD3810A174CC0F73CD7BAFF7C8E28AC4D0D3B3C372527D5EEEB20F8393F573A6D1BF697804AF8575633092C75ECBB2B0930D6C6569B21604B3B8030D69831613E81919A08240A9E50571452490A46F49ECFB6E0DA100708A108072A4BB6D51CDC5B2CFC566C8263B7FCCF5657502055B8D84005E225EB2EB60CC13B7628315653291E62CB8358A3586D53437AE8211CBF1872150A19C2DB349A5EBB00AC8D2C3E12C673A581A1E32A8BD836D440D3D7586DAF81ECF45619001496B8123ADE72DB208735519D26D9B453371753C7B665774C2A1B0CC32C3E72E0A813E039854E5CFBD8CC4035040BD9D84806B306C6BF5BE45B26FE580056C31722225B506DE16CDF94D7B1DE43A8C940E842D84A03EA6EF17D0C72C68CA49C5C70FC9081D77CC873EEFC60B7A144108D477DF0FFD3696C208C206A19A4144CD07CF0120701475192D0C3F03E293BD7A6F804EC7274A4B0F797741DDDE8B604C17523E6AEB086C174701EA6D369A6072AE806BE480E12EB7D0313813C58B450752A112F15D7C1C65628C883EB0E213A33D2724C0522105C57117CEA26CA6610041E6D30AA943945E034432BBEA88958047D7F926B12CA46A6C0583E599801FF41A152801BDA219E34435578183EBFCF3CBC8A0E4CDFECA515255F9002009C921350851FEDC51AAAE40B0202CC14AE0FE241C5D4C6DA13A4C2ABFE6DF82EC6E1A6830920BEF17D68283001571F3C9C8A2038B9C2D35A2240C058F857287A0428D81BC0C1E605684E137006A0E2F82E0B820748C1E760DC8D33C1DA041E5A042445441FAF5ED63F6689441E1CC0827CA5F0842B73FDEC9633FA2E5C76E720EAA4969078DFC9DD13DF85E403C24D2819FCE06A08788538FE7D47C03CE1047EDE7EC3849F86DA30D853E326F0D202DC8B0397990406D0EB6D148B431C9817D3EAEE09BEC0184DF3DCB503E80C0367555F5064983026979F141579132E0593F113C130C0C0CE1EE400D4844AAA7206A8F897862618E00204AB97F8DF6AC24D3E976DF0936082099C9A1D032F31A1F4454056367BAE82403D1ED69D5655F27C26A49BF82B7DF0F89AF0144AEC459B6A4301B72C125B'
	$sHexData &= '26DC6AC29B2C9B3762C285269B386A07A3099B83536AC222C4DF9F09400EE420E0C3922192202019394A6EC29F20E013DEE42220B59FE5096E14699E206F72C84820E020579BF036E183EB209F759F613433C8F1E32039562C4D319F541FC62DF494EF04E99EE0A630B7042BAC148451CB781491561741F6A73E5483C1208A72D2290D86FAB1CE6849BD01FF59DAB84A509A562C908B795B4617E08EC011D8796D8571DD01B2018C3121AA8E2D581380880C60072C4A69DE43D00B171009CF2D10095350BF5EBF5F822948E0108A1022C91B81C35F2DF0AD6EC9441E824443A3F5186F1356655EC9A112B85F60BFA85868709258B8A60927E1DB102B59C3FF0499815C5B49243F18C82B2460DF65950BA11532344B048446D28FBC5BE0D56801EBD7C452815678881E804F770F0338862D4625080713889AD64B41B95C01A9BF49D83FBF8DFBF68A807DD8C364E021EA740D8C09F8C290A693EB2C3074903A4B2622438B97A26994C6B80EA50036484DE4446C14243410D09CE8B3E4CDDB0D4695B4C974231204D5E4792343D9C03B45C4C014838CE5C0BB6DC042B0C42702C7D70C8332E02E05DC2E8456A3A18E5886039F57C8211FFFD524F15C48E5208EAC75D0606612962DE4240372C5FF4747F586562B86756940B9C13091A9ACBC85CEB01AD60025957C4EC43B07ACF776D0E4A8811F3C608422C59FD04A56B5EAA057790D2626C39F3F85E00312626C130CC4226AC93F700BC85C104D0FBDC8539A68A4F60105C72096A0C2D3E098984E8C34266B7041CCDD8A8013D8E05D8D6DD405FC4901D3E78D4B7E3FC7DC7CA3F18B009E897B1C894318FE5E6B9588863BC64EF9A8C08ACD049FE081F26060D718622A69FAC8E77EFFFB500933FA0A0A69FF1F170B1B06BE3B69D70F8B7B1823FA3F0420B8D28B1CFAE4D63BDE750728C60DC28902D4EB6D8B947818035A2F4A7A08752F2A25AC0B426E1C5826B2FDDE3D400B98891740547E22F889591C77E69614027E73333BDA1A4FF9B6EF3874743D1675F46A895D4A13B56B0F0148C45A582251565F19F765788CF6C13BCEC3B177A1D6F8DCF970F5E787D3105EEBC5BFA78CC3C0702118FFBEFD436AB83CE88BC657FFF83A2C75B850BC00FFE6C5D29C5C3646734CFC25FD2936368BFE71FBC1247C0350027F2097B0430A9E51106A7DD8809169241106F0E80080EED20371859DF89F6A741C12F9D31BC05F1A0C104233CB69D9A1D71F1B9F8C8DE890490C23804E0BF7D38D0CD188A40ADE877735D87104E9D4B786837BD453CB7800684A72838077DBEEF7B4E0018514F1CBBAF039419E754FAA44ACBEC9135112E974F18D6E35D10BE2CEA85EC026A185A93B30890AD292B0F8D63197FC2E6B1ADC1AD25572F7C62328A4F'
	$sHexData &= 'E1A391A744D5E5B0F1704449A42453902B8A5C10F0818D1187C5D2217D24D0009A0E9AE153D994518C38780565E56CE3A8E19F4A90623E189300012A8648F1BD83C1A51F73BF831FA5C8807AC99561B69EBCE0C10B0085F6D61829AC07092C809F1211478FC4706BCB29C8208BD40CD36220A2554C023244837C99768BF7B03565DCD4062E78907318D06DA29603F73D8BADDA137883E807F42754256B5051E30B57E2C170F6A760CB60A9C2CA9C6BE0C44025AE3AB00AB8178B924BF918C9C02BFE34CB0F29D4A60FFA9A4601001A29681159F5820879C664738B5951E193A75CCA7FD9910382C0188A9C1D2C08BB9790CD190102E017A058F60BFB1B2EB03B07DC81CAEBA02053580704574C2508F726A30E206ABAB908071AF9D349A3010CE55E1119A817E428C548C70A5D31BB8B8144A9190755D845B45857B40F295612183C0C3078250E2B8738BF8FD0B560FD4FBCC960FEBB90D98A037761B2D400000474AD03D350483B85F438D7DD0B7E06629E5740683C72A88B827D259406288BCB83BCFAE09E08D295052DFEED348CA56B6114DD47053D6D917F30E9AC8A8599B750830BC2B06289B8C660A600E0A096A81C1E1C60C08BF36B802620896BDE0872517984802ABB074656B69924606F43A95819D6D475708B45DA97CFC19B0165A571C0CF73684036AC908E00319E07F408955C867600D68B4EDD0A825848A5E307E1AD0C6101CEF2C04D4CCD0BD8433C009E0BFE4CC31401882DBF040835ABFD114AFAAAC1F92F65B027C42A252A9544242427296925A48505DD80A819A505E0FD9C8D706679A1EE6107804C88DE4309425B2597616395003749FE351F81A241C243323E41A853212016BF7E429605A9F0200E940813C0203FB853C0839AA44AB407C040C58FF02031922904380062B920321AFA938ABE85A83880B2C3F070970D06C28033A15868D71C6E0B1DF92A91CECF0E08DC5109AA172143B9B32E0A75E431CCC02568B192D030A56033DB64130063C85586AAE396913213336E9300584107241FCC8202F16BF668D145023B4161F531C869937E865462421C9254696A629AD25E014E0E442854B122775A17EDB9D7566404847243B7224041CCA69DCE844400DE0769D69BBD049FFD6FE29BBD160DFD6354D3AC524B90C007597814D5A7FB043039F2003500110C24FABD88F46200D82305059DCC742B896E34638B6BC4820321B46AF300D3472D99C01AD282C0258919784305C0360C87A349A647435DAD234A5CE8814668C328E8A274E46905EC69F1C2A64A01C7F7D6205C9519914017820EC7FE093042C906262014626289EE5A128381919196940202444191919191C484C509ED0B03854A9FC2478E4A2C72995467C877E88800F2426B01F3408C36801'
	$sHexData &= 'F02BC81F58693345104947E94DBACE070F9C4BDA043AE41D8E40B8805C78C5AB0262D2AEFC0D10744C08939951C06803BF1C325546023F24908D36561E03236C3E32918683C104054C802B630998D7E009382A7F2C6147867B9EDA0E14144FBF80475019EAA6025C85BC6DAD9D0C77DF2870F5092880E608123216F3945DE3D412C8E31FA9B8DF04D2E2D0EC5F2B0417C9103538189189201DDD56D372210F16BE2B488D3B3456C1BBFF944E20AFE10D0C3F21E05228720D09F984A85C3F6019E038040D5C3F288204720822B89E024A43C8BE6C7CFFCA44E6A6C14F1FBC616FEBD3842AFA7B9C6E50DFBCAEBE974E0E6D32173FA9B89CD940C6423F66CDF031F10AB91C15D4ACB090061EE88BDF0032B5D345173CDF60D96741DE56982890835685415E83855CDF670DD1212E9040C13C5842D845C22D70C67314C00A2E485F70EDBBDB3C0256751970880F660858C4843F090C21545DDD6B0801656509B48C315480DE44EE4E05801748F3AA580031549440D036DA0305E0CA265CC4282CC613F7533781C614F875DC18F1400F6F0C9E249EB0560575AFF35D13C28AD89F4B104A40DFCB0074173E5010C8EF180FD03BC86DC73AE0E0068EA553E8AC187B059DE832B44F04ABD2B890B55568610F04C4E49F54F088710F2F7208E544B85FB18D4BC3EBB73CE2DD8420067EFBD6E1563205EBDF3954212DBF4DA8B800C8030210E4903C0879112B10E4811C55C88D103C00E40112C4130B08491E8412C4540E08AC1F701020723210225F175801035FB8FC5752111947E51F8D717082C2C1DF38C0890507CD9C7E080343C208088E061DC630E90CBF39A882255E3F10140CA70AAA447F72A2404EAA44ABB002921305ABB0090735469E06C4581BE9E7E8BC3F1F6F8C64E4ABCCDCE8B9B69A84AC613F9C9B7C5B08FF46135C7F87B49257133C5F3D1002B22610A6F69C5637A60A5F103F5CC923F97E2928F51CB8D5C279812C20BF67DF931CAA2B49FCAA748C0F739CECD20627FCFB516A6CF8C7412F4865689D15DC0F36608153DA3DB756207C139868E97A0F0804742D640037372D740525752340DA0AE0CC62FF016804EE0A46640818C9F6CCEF781263061C0FB7C181E15BC9D102FF24E2038E15212EF0A11241DA377518D5D838893D007B196F149736CC2192B390961C7D3C7A866D1E7413DF54064DECD606FE19CF13CCB9E9FD8426BEC5B406C1C34B94A4E5493DAA40C3D7749DA9ABD657DAD510C4200CB312D79DA08AB8A001FB0AEBD0D8C43EBC7CD781FAEC30752A6B576327F800ADD714F12853210C31EC33DB5359700E0087FDA7488BD3EB375667BEB7E065037F3ED6752138849D634408E11B1C34BE4284403A08E8C1E804A800BE0A10F4D6885DF85E0D1B6C28D'
	$sHexData &= '05BAD0EB380B20A4843F25006A9C8D17090565774527A564A338236D80765CD39765000AC015D24C845627C928CE11DEC28AD0C6D0D1D0EC9300B8833D208642F484756DFB802243C82B0788AD3808580F08A8024E3FE3D106432CCD4955F9A808FD60A3084D254C38B3E020AE602FE6A575852021D2305858195E834530C5CBA2492A8B440194D604F0A045AA888FDDCEE6F6B970F845493F6C32A111CA65189BBCB00DA0AF6C19044399C977728C120C1F3C1762384666935A2F4AED2203ED08DA150834C719841780002430DF5B234C350938B678B7259F9FD558BB57C16898D548D74502C85CFE57858EB2134A5FD0A2C94854B45F010584C072FCDEC50D88AFFD2101E3C0C5E000566753F7697F048CAE3D5B2770C0B73F01A656EB56D2C340B7130749632B557136386960BC20A0770FB21474078188BC16E9DF58686F0DEC022E0155068A6D3C0B9208A309948F0766F492F05340F1FFA8BF8E9988926734843A1FE286AB09C2622B6E50DFF498ADC0671A680DD2C504838A80607137C9D3E3001021E33F7C2C37443DA6945BA08DC488E090A163CC374B886ED66EB07716906E15BE81874286A184258011F46D3268BCEECE7EE47016D4700994F0C101800107E467F036A325F560315E0F507C7F5A9C9DD64F444135633F677CA566A075800E81281611E2558642E5AD29998798446A343B93E864D348E6EA4200286B54B4D015E9EDB5013A7CF502CCB85F06A05580EBB318D47A42DF5021F3F550437DC39000070D7D868C4D9B7892294C4E9422B8A7C1446DB805D026A04FC57C710139AAE0FEEAD8CEA0D33C964CCD9E07615E85930210E08317409DE4BE95316D3294C18BA62CE611FB30B0C5E3BC62984070E82543C6885D4565357876E8F8BC3B7CC9DD8EB6B9E5A584460B3256054325A576D83D7F609D4B98219EB3CBE75BC1BB3FB1E834DF4014E5E53A2FEAA60DFA7DD5BEB1ABBF057EB491AEBE8CE29AA415C96884DCCEA57533803D180C61038003AE6E67D41FD0819327414F1E6E6E60B740F3B740A2674056A75028B8A366B0676C4714588D6C3C242622DB7D08BCEC4360CDC4C02FF804093BB82BC7420007F44ED079E12662B51F410A2E94888E928855276B343866E8809042683FE58B1F808E11F6A024E68017CA785071B7C752097ACDB40AF24982E2BFC58035AE0FE535C9A0DA1F9B46829A84662471B3F26AA572F1F88B27B9A15E6C9F23825A40B71BC4DD684A8721C795E701A714A11F573B48ED64A1137C27CDA128B0F0CD66E29B0312F94EB0EA04E12861A5A1D6A25FD9620845F304EE85FE5AB85C32F022038190A0475A260FA4CD372C0EB09FA7BD0D147F35959B7B128DC67C93E3DC426D815A19BDDAF7902680889B7C9C3A52CD77E'
	$sHexData &= '90110DBF505DC31BB8248D02035F92DE027E8B8D144888FB0F369E5ECEC002C604310122530C0A6375F247670F8D1180B728DA029A808D5C3BB4FB1152E2F003D07B669032660FBCFF06F83817C8752C727CEF83E10F03D13618E0C277483FB6F7C1A68084DF294CC640EEB001E4A204B492FFE084258BB02438013D9B3AA55F20888B4018C061EC84167632352A10247D22904021F18D68C1E90580E1FAC1D561F4EA36737129E60CD8C23AB67627DD213C921EF6D08D6B98BABDCDE70CDE932E268C10E988FFA68103B95601754D3FCD66496663E01B504F0C2DCD69B71BA6A327CC246DB5CF8BD5244CEB6FA9501408FF5E59BCCFBA3534473BFE6B1AD8011F1FC25DD3C050196543864AB848CE75E98C6D1F54C4CA1E21494C0448E0A3E9DD4F1180BC49A407ECE255296149440325BC678A6881DF8B957DC56D6D5C9CB7144ABE881074E652422DE3AF7EF4EBC3DF2618AA2112A256D0560781CA825722C582827ADC25F88970D80123F9FACC17F3019BED570AC8BFCFC5F96EC10661C070C0280ABFFD00C4E37D18D03C1F00C5ED75004721B17D13754ACC203B56EC9CA2F02F551C6A129A582BCA6FDBF74DBE09C4E2758C4875C206DBC1591D0308DE686C1AF877060C663938B8E12D9416439934F309B68B44B05F03C121352F88A8474E74CC5CC006944483C42468BC19845014ABDF7BA2EF1E7F7526CB0989EAEB969BEAA48107CCCC1F5643201A6859544BC4431B8F2856E64DBC2701FC422EA483E00FF211ED15049003F146A870A8896B7AB8C4E40EC61FC1CC02254D5052CC946AF2B279D84D0AE2D5229AE6297C75B8741B18701A064CC0FD96063616BA08C13A61C871722234B488C234FC75A806167074B888710DA0DDB7EFBCD1EEA272206402EB312B751CC631C106F248D4FCDB338599CB4528C2C4BD0F4080D5BE83A5C175FCC21552D1941CE704B003FA86C21004D6F9B0804281F98D65CED1A0DD1B84D4F84604C883C183B39265D04F103498FDDA0E83B895988BD01C1EE460C3318CC66BBF72D0397DAC741A200939AAC0DD9ACE3A35CB547CCF75E6C2A76D58D35A0B30E37CE16B7C427ED06A0FBDC0420AC1070F3A631F02EB97FD03C68506861F566B745A631F30DCCA7856B7022FBC617670875CE0E052D8565B26B1702120ACE9B515012EC3DF2458614D2909BA6A25380A082A1448B627B3970F280C1EE0067F659EF7F4DEDEFE0872531A2D4EC00E35A06F8F37A9FE567D335C773E52F1EFC9C5FAEFB6E9D5DBC36076D10672D3053436CCC5E5DFC68D6F3A7D9E47C09682FC50C035FF5754011EA34A9B24BFC4C0D8E283E6073127B0E0B73B386D04F05098D1B55DF0E4C360779705FDB4C4BD0C2969AC3BBE3DA0C7FEEF447DC3CED306DED'
	$sHexData &= '0F7D24823D0742C2374DFAB3CBDCAB81F342BC1BE3D03A8B80A71742B583B8C35BE1F2976473C684C457F0CC57040112EEC1D7ABF64DF800DA40242FE02CF730D803C5934628031FA12EB07D581550D9FDF14F0B0700C9208E0EF68F8463A147752C5E1EFDB041734502633BE16C35797DBC6CA4EB403C47700C12A86E118DADACA066D28C087C02A32D0C8F34EF5EB81D5F1F06475CF7EC345007A87D40760C6123CEF0A1C18C6D9FF84EE458C48ED3EB6D7C011A089DDA09234C31D80D8325279C67D16F840F0CE4865A420D000C8F80793F6FF82DC81E37922C10153DE6E375E11C2020BCE0330C753E8C173EF0113EB3B1D031016D1DBD8187518C001E574C32F747F106C74309430762B1692FE1598F908770FB98093CD1E5CF81BC0F7D8031AA93040061369736F08480F46C02755C016633F14361050B9CE7605B90871037944612C9FB80049E164815325C4DC1C4460D23124142BF917F82120A783FA20082CAE458CF02F5250BE0A4EF216B30FA9D9F58B4BE743D83C91C203F9C6C84DA078606A4081C78F5B7C07293FF575010181E794E976BA5500B32B0A88507011DCCD1F85F958D703CA29B0245510508B0A5430F82DD2C272065401EB3236A4EAF7042E76E55051248017DE7731E39D8B6766E0DBA3BD89ECEFF51706E3FB685D339E630FBBD7728D5FA0EE5C0C6F0525E93C3B84BD4182BD0B2A6C230A4311D8C7B9EFC999F5823310DDBB7506C3F6C9BC3F10757468ED2B4B1489114E70A51DBAC79A50C1774B1703C8401A2CD8CFDBAFA0E0E00C5DA9EFD6AA8F640F3E0C905087C7BB584D971D92A78568A13B98E025CBD7D7E98C0D56832E40848B2F850F87104830939C02A8B4106203F740DBD1C04402A5B9E455B5B9834352B13EDEED2D13FF17AF42BFBB03C1CE87260E400009FE02282C6B8D72E08D5020BDC3C237F883EE047214190A3B087513B57FFF9A92E4042673EF83FEFC2C746D8A0A3A30274D73FBBF1AFD74628A4A013A4801751A18FE745502028337CDCD750DFF7448030374408B3BE4384786094B95540FC16D6158F080DF2C70308EE8F09E0E0BCE0F862A5C5BC9E1DC80701441CD03448844B53B9BFFEB60B07048BF4BD61A077434D48448FADC82604AACC22F9F0F02DF68D401DE07A7D26E10EF233C29B22BCE7AF78E54BE22821E9C9588C1E805029A5445DE1BEE2A16D898FA198245D4573129DC7FE366D75D6C4D02072F59F14CE26B54107F59D6FA05FCEB1DAF2E998BC25FD1E852233E243EBCD82C4DDC57D13051B00AA56A424C0A8DD6C0BF5A645D23D10D70C610366C37D946344E3B6E0F8E4A2D8488A8346074F0FEBD257576D37EF79C508BC88D7D51F8B4D1E99ED8B947141C7D3428A522D8B0EDA0C0CEC10D5AE04E'
	$sHexData &= '83D80F8163400A704A3347DC46A247EED090FE3734D19DDBD0FF08594E1BCB68B05C0D75F688AA4731BE520F577038A6020D990AC27DDC6ECC94436941EEF0A674AC1CDD323B3AD8A0C2737CB4D2EFFFFC3B848A8A3256D14E5A371CFD411E4228262090E66690FE02027515FF0311B26603031732018662F00F642EACEB43786A072260A014816832C19AF815B20F66390E752351093949E19FCF5837D4486C411EF162E2EE1E656AD04E93F075D1B61120D0AE3FE03274227F28D80EA86DADF4312644BB269C4F68CB64181E37C038B7C3542F54C4526AA3D8412644339DF8140233C36507C370E124D04A13FB70307F5DDC219C1F235F2F9D903C2D4C51440B4872B95C2E4C5054582B81CBE55C6064DD190252C867AA49BF2C8346FE5D746E3A7826F7048880C3222AC68000BB8BF0115273E8BB09EB1328870103C10638746D7D19FFD778F3482CD04009AFC991CD5AF901B1083F46DE897E82F4AC06D94631426811458D0C1D85E6701C7B5000B77C3B0D21CAC3EC3CF079135DEBA0BE303CEDEE3B28FCBD82BC41891356890850CA47851D200089AEF260E823B03844BC60D2B502E9BFA3574FF0039234B00FC72A00EB6205768F262FEFEBEC26C4F4B5945A629679B8DEEAC06EDA1DC4A0D14CCDEB0DE5ECE257713F0459FC0F193EFED0680558E66A16C6463A0F1476CE3D14ED164858F4483C03C85A4114BA03D04EE3FFFF10066BF02803F2EB158B4A0C394D0C720ABC0534B545FA3945120CD028D038B4D148E71CC3066E0314C4F9593D35B82AA183A9B2186B44300A384AC2EB04CE6214021A8CEC0E4E800AB3DBF03264C3B0010661AB34D8FD6A39D6EB181F31506310034EFD6F603B453F1656C61233AA84C0590F957D9B509A2BBD144317070DEEBDFB11EBED58130918B0850878BCCF7519D032F81D67A9807A4C7F33025DC0557A1C9A65AEC311BC0A59595D310CA34C2DC13B5BDF2859ABC0FC0E3421E01070DFC059E90BB538F88E481A056048019F366CA9213104F8190A6FD6134F1DEBE92E5A720A1ADF1E49A01FE05A15324F5405E2621C41B7860B261422131C0E4BE73834581D5853BB91509B2BEB30F6244A0B2E97CBE55054585C60D8F5B00F454901DA7305C741CC486E670813F52819A207F80E83B84D5A983905226FBBDF82F0AE5DA10C3C81B81950453C754CB90B701F3F95018818753E72B937F0CA381876EA3459B635EE6F2B27837824007C21A0B0E0EB1F2C14B4145C228138500948207290C12AC176331E8B65E841867E89561190F0757A1E1D0D049B098AB9AB35ADB98687754806380C121B046117DBBD0F08C5E730239483922E4B2EEB17023B860B9D224A20AA44FCEC3512A0C15B7D350DF7D85998B6D767E6485D113EF8335'
	$sHexData &= '0800717F4428D9AE804C026411A03A15029F808E0033C835C7D071408BF2A1C888BB3105702F844D33F62EB168BD7C4C9C044BEE87C8B375B18A2C833FCA479E58B1FDC27887ECE11C0105989BB6E01B2776F8BF7EBC913D7DE6AC7DAC4C557C7F08DB3C0B742C029302FD883FF1E753013605F8EE523282494CC7133B75954FAFC3E49709D248373523E89A58305F0890C44FF8E642C99560D33D23D57165433200911AD44458016401C5F002A6A27509732E19AA2339C14F8EC8136B9FA19AD37A4103A6BD2E8A77E2437C359EE6A100F48753F3DD5E3715984E337A991769E60A8255A88E76DA5178B49B140BB37BBD099BD218D400155D395AE41019A4DA76A0929475B79D47DB873F009EC483F40752959A954BAA7A8203BE0BC3A387A9F99A10232DBE74DE8AA60345B9F1043A564EE162B607076741F333431598C02BE85BF940C6A0240363A97056C596C93645D5DB31D2D0F8A9038E35DC8A43330A90A45E52207352877F91368A179104ABF0F04F07048A395F64610376C70CA0B33E05F876710202102756F7741083E354E73092A96955967385F4FA75318C42134E50984F105A21764ABCF386C9441BB49810D8B407EE018D1B054A6A0646D0C903658208372860F3925647F149F84340A8C3978738360DE31FF580A83FF02F80657826FEB3108535719A6A61CF6B5060ACD396F2D3666D1B73C800139EC9C75277469701CF62353502F85DBBDDD1650981CBDC85E037548A803C1A3B5743509EB240FC4A69E300100A6366A40837008C1E30DA0308080C4750EBC901AD26157F13C8D84B16E182B2B1C590FF7CE8F392D6004E5580C3921DE84997160D7387A9E45854A6801CB018AA18F040BEA687DCB409520FC08333CEC53514910C4C0B2084C82F0D990DB0F036B13422402BE00FAF1696E65492A356E74656C3ADAFFC186DC6A013547656E7516582C594BFFEFD47575397825F03FFF0F3DC00601ED2BB777663D6006020C1C3D70153D500603280E6CC2D33C0307031A830DB9AE12D46C24E033DBC64D45C228EAF8A25DBB4C08A5EC38CA023B183A828E306C584D8D50A14CBB42038973DC4B7A5D8B292365029EACECF7B7DB3789C34C749D0288D8017C2B2DC1BE24754177708BE86ADB0EB6E0245839D67C1D501E553320815D83217DCC2C25012DE1B1B19033C3DBC2D462109483E1FEC70187F02EDDA34189893B86D63EB80C5CE1E964045376A916640276EF1C1863AED8407623D067BC855FAAA06A4824012AF00734943E76558246293388FAE00623CEBE4146DAC113440F2DBA0803D73CF841F6C32074795B942025534197DBBAD803D0A1DA7861969E6032056457FBD6C62B404EDABAECE423C2E26B04AA00F230B82C73CCB236C7B7407CDBB789'
	$sHexData &= '0636BEEC84EB0B3963F7B3A31597F680301025FAFE41A34CAD696631E80860DF4DBD0D46E0FA06C1EF6C008D37C0021AE706A37081CF29DAE7F85DC8F7D1238DF7D7BEEB3DF79DB2AC7D3C01760F5ABF1931CAB3F10D10D6680259CD29C3EB60612375C1953CB22A8DDF0C042F0CB2B9B528CD023CF6F5AC7A2BB01A34163905A6A096A904F76A5906A696DEBF61DE441364FF35B50BF46987B66C068D2BE09392AB408E31C49889181076D9406C161BAC0309CE9AFABF4C22709929DEF9BD09BCB210673078746EBF95161E1D4831113482C3B7849A1938886C400ABC66C41E33D0C10206C477C33F864EE640BBBE7E7A35AC84960485AE267791AF526AA060CF9A4F38EB7855B7BF0E2A0A0D114748C1E010B289737D8FF86BC65F11805EC30A80CB2C2C7CEF90171DF259C3B81688C3C4CD84356FBC83082470E7EB146C35411B024477850C0BACE0C3062CC954BB09C5010A7D3BF37319573372E950104A2AB7575C5C2E97AF911F780B848C90E572B95C94989C70562E97CB74C0C4BC731097EFBB5C04002FFC0BF8E4C4E5BB7C2F08F40BF0E8D57F7CB57F3D05187C5C81F9B4C2F5A71901F20EB5754C0FAE89D0FF81C8FC83F03FA8817442A9A48254C27C62CEBEFF227122A9A0742DA908042991468C7C4710081B9320A87A2F7EC6B88F1044C88BAEB8902F9E0A02056433A35756537CA70D253C680BC07D1447C2AA9F45ACF7D8F7C8D80041DE59599D1C361C2DB56792181C182E75620BF8AEAD5633D2384C773FA3D8850ED3EB41163354C37EFFEF27D1EBD1D9D1EAD1D80BDB75F43EF0F76482BF7FBF9D9232A4E603D1720E3B4E770872073B5676014E331038109CA6D80E16EA37E083DA005B5E5F835E5515C1176C33ED631547456573F0013228F08BC3281801050BDCC60F28EB4785F36EEFCB0F094E2B301B241C33DB1210E11A58F0144D79A150D39181600CF6C95DFD7EA77B9E08EA9A0A0C75091E04F7E19E7D0FEC32530A5708EE140313E103D3DFAB5BA5B701F6C990207516C47C0A81FFE27918C062F17D087A0C7E16C2F8F59552F456C099D1E03D6A9E73A6AE5500A02C1AC319BE5E057CFB051C0FBAE818C1E904E00780E9BE92A4FA27780FA5C2D308F758D47DAA7808565E98BA5A2E97478F8082D1D4D8DC16372C5C507F2B9B0888B4DE062C90905781840F98088DE04AD407BD3256C841CED258006A2DA4B2C25F808D4B40437B0EE9015EBC460F75D0CF6DC92584DFE80D9BD8E46869E8F3B87DE4DAC04265F451E492A13DC19F015A1C59F869576C72D308453C9FE9420495EC7C5F9F68B964882D5FE4940692132C5F4E5CC0C940F2D05F001A1CECF1844C7A6A28E8192CAD1343447D4C8CF0C92B82531D18FC5DD418C496818E45E43F1'
	$sHexData &= '31417C9F8EC7FE8390D07441FE01FD45C90069F03C8198CCFDCF0161610D893E4DA0152C4E4C0A3DC43048B375B1E0FDC052339453BD5287FDA8349B8DA62D1EB4BEC54B4CFD5B0FF7E0AF8B0846AE03FED0EC0D1E265E0FE2EDC1BBCC3154BF369C0D4262CACA2E063070427D861A8E1BBADE992F8E85F7DBC9DE0C6D371EC4101A89C5E90D374408FB89FD67CBE69D726F045D0DFC8BE37EC1E40F069E0528C5DD704364F1AC6C32EE446F4E4FEE5FBDC32929FC3310219DA9067470DFDC3D0FBE2E400388B7F05EC0EF23D9180DA83152CBDE515D70BD76CED2E824CF27FD0D079D670C9D58FD0A89B789A270DDFAC47E4ACB4AB021F0EE90EBC0BA302170D91EC1F3D610DB0D07D8A584987C914D5D83FF0DA1032C9F0F0F08572B58BE554FFDF6803361D13905FD85F372C999078BCD3B00E301D20ACFFD8E80A1CB04BCC6FC8DFC9AE843CD91C4E2A0C8CAE535BCFD950636D550C7123B87D7E7CC9491B210E88B8349FC3C8A08DB314384C30C34A0A826AD0AA8E68C04E20F1298BBFC9090227D34A7B83A56DA083721D5CA8BE07599FAFC38F198CB90C3BD2E040584C6D01B4ABEA401498234D79359C07141CFE87DA0486210503EF0FA0AE4D0D4BAF8893489A1056057F972C58CDC37522ACFDF026DB926B8F8C7E6CFFB05969AA74A4084B9FA4F7C12E41502484D562B19606A32A5BDFC02DCD492A0E0C4C060CE4289C68691530863005B91043E180BC4086FCDB54462E96B4EE1CFE1C8861C825C7E940209249DAA4ACFE14E4CCA214035CFF49380E8613C8B0FEDBA0FFAC995618CE8F598CDF86CEBCE3D5F74D311DFE54A59D1C9038E0FE6882D89D350284C7C899726C179CB4702F0E9CB46FB88A2005675B4FBC8460C3484E20875CFEDC286E3864417E08FFD44BD80C459049F01120E0808CAC4E04DF28FFAE18B2B9A56C24FF2776F002391ABFD4DD1069383808DFE4D91F1DB003A6A8CFA493AC55206D14A19F5FE4D476602F95DE1C1BA8C05A7FEF8089C65581011FB8DD120FB07F438E0F81014E98ACFC608B6DC801A6B465DE8C8E085B4E6E27C8AFCCCC9FB05D3201D0D08F0790A16DEF523C7FCCDF14A3408918BF3F180D18B0E06F4342872F1AD610E33C50E5F2B5ED04144ECC0C6CAD069C222FDF74DF40642F161F75980F04F0DCE0614BB088BB4D8D4CE931D025304BAC64280A91F02C404A1E01B09E44FE79C09987514E1C8E5830C8492E10F0FEBCF282435E5D5CFEA437D4FD6276C8F6024C1408FEE42B015E201F5C69894CFED0FD26229C40E030FF80022A641B2DA3A3805CC7F2E0C805C4D3080939E10CA901CDA618E652741EA84D3CDC001E06364B7CABC528F46CAD1D699D7B9B30C03B1525702047C1A4247477600F265730F427381F'
	$sHexData &= 'E806799A275304E8B8BC1C97B4D5A98EB4E41F89218B0350FCD76097FCD1FDA96381A521FF2918FED0616B7292FDB0FD0A2B70F9EDE9C4570439E4ED2D15F0FBD8DE6A83749694FC672B37555BD5937DD82BD329018FCEA6E970576DB5518D64152D974A09AACCE94FACADAD572B15681E72EC1D6964FE57904D90F155291EF387A75521839BA45D7B83FDBFC3D6D800ABD6C7144C2481C07B75C1ED92C33B186B2C08387AA457DD45EFA26309B92CA9A9D311F6630DA083B70492CD212B55BFFB68FD3524B9E4200041458A6188CAEB9E9263AF8ACBB8F815D090879C64E8F8F718F9452799E4304860F95164DA0032F99041A8DA5524993805C041D356346DD81524572BC0931CF290FB08FA00009B649269571828302BC924934C40485824934C32607078934C32C98890A0A89936C924B8D015E8C9156B24882D104CF21D21F72B28DC32C92493407C58E424934C947020FCA3A8263988089F0F90A109FFF7E2188F5420247EB058C483024F27CD65B0A4D47F4A8A30DA8EC95A98933484F6E608C3FEE818D635C9B1FC15304815935CD10ABB93FCFC6907C821C06015031C48C508FD411320326D92694158382B70C924934C50886824934C32A080B8934C32C998D0B0E80E39C924C800FFE09A64924918F830C9B4692B7D99482B28171C573560B9FC91D083212790FBE6505664284AA8F7A90DB82FB3C90BE7B07FE40148920119929CBCFC4552B4E4DC3C9C999253A97FE808BC39F68909A0950FA8DA0A3539B4DFEF35E40099846837D6F9125C2571014E5C11910320E91438002EA7DF5C74E01F8D01642811D8E96C928ED0A17E7C94150A023EEC2BDC2B01723C6A87D23AB1626CFD999150F19E7D4E46EC1583C1386B812BC909E46CFDE9782802667FBFE1AC0FA31FB00A746DD46DE07F6017B2133F08CCECF1435C1D1AEADFE077707421067D6B7CDFC00BC272C4A76D88054AB593C0FFB5354672B05C8F8A0A10629CE31CB0C071EB189F5BE086436B974CEB6B4F965CBB42F47B786D93E606FF0CA50F62589ACFD8260CCC01E9A481BCEBAC9FF06D801018C8CFC47933704071F0FFEC811590E445EC245DC900C705BC5FEC3F21B04854CD5FF48365EC3250B034E4017C805C04C2DFF07680DC74DC1FDCD8AD9CD86AB8A81F7FA77CE7007985ED18B885827CDADC2C0EBCDBFC8DA891E414ED88710330025B0F2DEEF3C0AA802CFF990F1C20430B7FB86005B32D96BFF4FC0FD5FFDA21AC1DCC6B0F087076EA1FF4DC0FD4FC1F4A7003AFEEC8FF91032095BE8CEEFCAB4A986A7FE43F031C57C8EF28FCBF8B9BED067EBF996CCF1FE30FF6B420B081C1749B3BC74F365E0F8117AC91BD82E515EF547FF4CC42035E311DEFA89FBC1A56974D5FEFD42BAECF95C4F'
	$sHexData &= '80C6FC8A760C9F000FEDC965C863BBB328D0209FC2FE4AC0E0EAA216C92C0E80F0F3EBCD4F1F02C21CFBFEC4A7241D2AEB088580D0F622FF0CC5F720AB919BE01F7BCF0F8058E48480FEC3F0879C800E8F124964B8676106C6FEC58EC801307BF273C05001953B17085F1BFC038609A406DE48FBCB3861C604FF1C82D3509436C7FCC3FC3010C79F240BFC8388F1217AD5F66249ECB7729A8B8C331023DFD344505F7F131EFF25CA95BD8737F6F015C7F217B062CFF179EAEE4F2F4F01F23A683E314F3303FB48F05A5B0C5591D1C6FE4A2E4DAB07F5CF4CDC272A2F48C13D1C85632F0018252165E619445384D0DB601DB3B11C4EEA1136A085957D06F750838455E58B5AC268404BC4E6CA4F6EE02F53519618082A1209D3408F83AF330C0216C9DCA83841C2914217CDC6B4B781321A38D652AC402E5C8200D46DB7FE4E40664925757BCB4B4D22DDF4A5E2158135098208580C7BF5814F13D43585AFE58201A48BCA0E31456D1DC34D9385EA7058B500E690BD1121C20AA8D550BBF8585FB0BD6EE81C698126A23A234C5DF81BC8864B0C800D84F3D560D349220690001F37E222A66100300560640BBF33CCF3426168001DC0E3DCDE66B0EEE06060F742C5A44D33ECDE70E2ACC0E0EF22B06DCE7693ECFC0A6BE0EB6A6DDE7799E90807060202ACEE7799EE706405266768E9FE7799EAAC8D6E8F8182B3CCFF3342E3A4C5E723B6885F38CA7165E1706CFF33C4F4A6A8EB2BEEAF33CEF3E0E187E063A505EEF693ECF70BE00193E800EC2DFD36C3E041AA21646B406221BBBCFF33462A6E8261C7E06E7693ECFA2EA581D90CEEEF33CCD101E549ADC261FCE799ACFF306BEFE4C2088C4F93C4FF31E2160A2E42622D37C9EA768AAE604234ED36C3ECF96E63424801662A7F93CCF422400E615B29EE7799E9070563C24003ECFD37CDE14BC882CF413779FE769BA742EEA12E606CFD37C9E681CD811924C12CF3DEF3ED8105E0694C8E700FA9EE7791F0EF206E0223440799EE779505C6C7A889C7D9EE796A2B6CC0F7FF0263C4FB37D96270648265E7890F33CCFF39CA6B8C2CC7C66DFECD62667625E0C2817B2C227DD6EEF8D562644064C37260F8AC367F61D26A406AC2C2FE8242936F39EF7BC0E180E16CCB0068E79B7F7DC746F26DAAE6287D0161AE7799AEF02063827EEF86C83E7799E76808AA8A026F7E4BD93E4B6E6561E948A24863ECF7B06B70EBA06D0EE0425F33CEF69102A0E48627EDF7B9ACF961426C8DE06EA4E6E246BFCCE3B26AA01013A1FDEF36E37196C113006506036900F11E279B0609B02308FDED845F20002358A011112015F106DC53F072100782FC0EDFC002D007300790E640065620061007576FE391C0E6A1E6C006F00630EDBDB3F866521'
	$sHexData &= '0203040506070D07000F0B32D2660D061E01010F4E66776F0D047E3F020241664346021F019399DB6E0F0407FF7F036464909103030303649664E403033F02643664E402021F0123C3DC160F85FF0404C8202327040404919BDBB61F0F0DFF046490919304040404B664E4640404047F1964E46403030303251939190303030D1939993F02020205B705991F010F42FFC17632320505053BFF8C9C8C0C050505052327238705050505C8C9C820050505723232C9050505059C8C0C32050505052723878C05050505C9C82023050505320BC8C80505FF048C0C32720404040423878C9C04040404C82023270404046CC9C8C90404047F32C8C8C9030303034B3272320303033F1B3272320202021F856A0B32010FE119B92251FFFF0606464E46060606060691939143060606E46464900606060639199964060606064E4606190606060693914346060606646490910606060664B664E40606FF04191964E404040404460E1939040404049141464E040404D99291930404047F64909193030303039664E4640303033F3664E4640202021F80E21664010F06FF0C327241FF050505878C9C8C0505050520232723050505C9C8C9C80505050532723232050505058C9C8C0C050505052327238705050505C8C9C82005050532725BC905FF04048C9C8C0C040404042327238704040404C8C9C82004040432724BC9047F03038C9C8C0C030303032423B7913F0202700D5B2C1F0F0812CC604EF418020702940F0B4D602E0702761F0F5013980B0702183F602E2CB41F0F07020BB5504D4A7F3F1F9EE8C2420F0702475B62FF0D0F090A0B0C0D0E0F1B1E00019C0B2C211B077F120BEDD63F7E3F1F6D2DCBD21B0BFF7F1BD12EB16C3F1F1A7FC442BBB53F7E3F1FB510ACBD1B0FFFFF7B83ADBD1BFF1F1BFF0BEDD6163F7E3F1F5B5BED121AFF7F1B6A6F2D6D7F1FFF7F6BA1DD5A3F7E3F1FC9A160050BFF0809B4C1B66D1BFF1F1B42BBB5B47F3F7E3F5A2AD8D61FF3FF7F7B6B69DB1B7F1FFF7F0BEDD6523F7E3F1FB555F0121BFFFF7B83ADBD1BFF1F1BFF0BEDD6163F7E3F1F5B5BED121AFF7F1B6A6F2D6D3F1FFF7F62A1DD5A3F7E3F1F9003145987FF0A0BD2D6961C0A0B1F1B0BEDD6D27F3F7E3F1FB5C4C2121BFF7FF6D6D2B61B7F1FFF7F16DAADA53F7E3F1F6BABE2251BFFFFD8065B7B1BFF1F1B8516D8A2FFFF3FADAD76891F1AFF7FB5B796B61B3F1FFF7FB1D06E2D3F7E3F1F152C282E1AFFFFB0ADA5BD1BFF1F7785E4B450FF3F02036BA165891F1BFF7FEDADA56D1B3F1FFF7F2CB45B4B3F7E3F1F6B03824B1AFFFF2D5B5B7B1BFF1F77FF2CB45B0B3F7E3F1F6E6DB54B1AFF7F1AA9BDB5C47F1FFF7F8985766B3F7E3F1F8A0A8B0AC3FFDADA5AD8FF1F977FB1901'
	$sHexData &= 'C583F02031F5B4B2C2C1BFF7F1B6A6F2D6D7F1FFF7F62A1DD5A3F7E3F1F5B5B55590FFFFF1A2A2CB1B5FF1F1B586869A1FFFF3F1FDBDA6A971AFF7F1B527B6B693F1FFF7F120BEDD63F7E3F1F812041E10BFFFF0A4B4BC808091F1B165B41A8FFFF3F90AAB2C41F1BFF4B2CB140FF7F1F1B0B04A12AFFFF3F20B8C4421F1AFFB0B5B736FF1BFF1F8185AA6C1BFFFF6A9758683F1F1AFF6B89DDDA7F1A7F1FEDD6527BFF7F3F7E3F82CA120B1F06FF85059616FF1F1B85766B817F3F7E3F6BA165891F1BFF7FEDADA56D1B3F1FFF7F2CB45B4B3F7E3F1FB500814B0FFFFF6483ADBD1BFF1F1B420B2C54FFFF3FD656BBC41F1AFF7FDA5B4BEC1A7F1FFF7F5868B7963F7E3F1FB50414960AFFFF2DB16CB01F1B7F3F2EB1D06E7E3F1F1389DD5A6AFF7F1A7FD6527B6B1FFF7F3FC0120BED7E3F1F0E81251680FFFF1F60A1E05277FF7F9A25165A3F1F12FF7B6B89A53F1FFF7F434BB4503F1F1017B6B9ED0E0E0C020C0A07020A080F07B9B0D0360208061F0F075868A1B60206043F1F0F2D54DB5C070204027F3FB9B0D0421F0F07152A14AA0202FFBF0B71696D1F7F3FA097E0D03F1F5B3020D5FFBF1F116A07587F7FC1601844FFFEF6AA1968AE46040702041F1355948C2017B6B9ED1C1C18021814070214100F07B8B0D03602100C1F0F0785166A2F963F1FA1DA42840F0F7F4284166A3F1FFF118B120BCF750B16829F8EAF85C8D2886F0FCFAD58706E1F0B4F75088185637F8F40485B8DFF3F09ACE180AF208E10021A908BD6C00727FF01005D6CB121FF03011F0C9AC1A207110751446C44CFAE18D6677B9B6D11DF0EAF4405B006A016DDFF1F64BD4062616420616C6C6F636174696F6E4FBFDBFE7F9034556E6B6E6F776E2065786365703D5FDBBBFFFF72726179206E6577206C656E677468BD73747269162074CD5A6BDA6F6F286F001876AC69562E6FFBDA6BBF696067756D54744F1F206F75068D0EC2EC66209C62983A6DAD9929D20EAE92634E7952656D76EF4C90DF3616C74661696CC2A6FF3737FB6368656475F6166865206F72652100546869732066D704CFE0756E634F626E72B4623C99FFD706B8582026612064656661756C7412EDD9811A5C75543074B66B06D6B63BDF726F6BF420700C6D9016406007DB947475AE340802DB9CB999D80A60696576574939037B3F1C737673666939ECE477EF6D671E8287125C023F0601776FE05E2E070BDF2200222C08003B2C10D86469522094795F2E0AC10EF66E3A3A8B7573002A3769B009969A9D56123C274FC14FC1D96F70132B2B0F55004E00431F76EF7FDA2747004C004F004200410E521202172C50BC543FF6B474739672656DC3D606CF6F7663E4B85FD5261A0EB6BD3677246B6CE8E8B069365C491C'
	$sHexData &= 'E031491A0076DC45F42253698A2000706B67AFC29068126F9E0A2A6D22BB78DFF367006566276D43D712765E5BDE697265266F0A6C2A97BD77B46473722E6D136300155C37628767740E6C63EF9038EF6E651A6EC676566304EFF97DA363526E007478575BDD3B08B673A35336753A82C3B59B6F702A62653A28FFE4CEF7AE7336615B68FB06E775EF4ED737701E638B142C1806627FD6613DB87BF0653B726A2AFF76EE2858ED476F4B286ADAC37BD31F2922624E74A39600BD05CBD5EF54FF7E74126F80AD1F7F523273F1BDF77D5FFB745A69A667976F0F531B7B0F4C87DF6D279E07C771A64F6EB77855EBF0F0FC326B006E776F0B724FE3C1FFDA003E067D005B005D003C0F7BD1717CBA0F7CE764B77EFA7647EFDF4106480045005FFA4DFA531626EDBABBBD522B265600320A01442E264FDEC1837B0F22075F333F4C6CEFFB0B539F4C42441FFBBE6FF03FC24753BB3217290668AFC1C12CC3A33A271E73D88BB799A37E73B77037D8AEBDC3AEEA5F473A2F9D14AD762E2F7A6572ADE268EF3A70D273977243DE8F3B983B2CA78AC36E8B6FF41ECD2F756F5FCB722E3D8F2D302D83BF126B31D69D6F936D27F7676EB7A2EDDA74CF7017A79E1EEEDDBE3DFF6653002701E26FDBF0AEE3F3BFF31F68B5AF836E93EDA78EB7AE81DB5F73C7EFA2B722B777D35668B35B72C10E3ABF5367C76BC00448AE49B64D4A471F8E8C5879FB008B5B0A167BA78727E795605815077F556CC040335F1FFFD34C93A6465D3F305FB71D146F97A33D27E3BD63185C709A3AFF59064EEF46F48E3F70363DC7D207E3B6A3B52DA73B7726340569ABD337C35FAE363878C373F3B63F685A0AD21ED337DF9FB81C5B43B387626B4D118D3DCF64571328DBDE4DEF62751A66A773CE7A9F4F34BABA685F6127EF705D9AEEBB6DA7791E0B4EFB0183F7F3754FBBDF64579FF05E1C6DF764B7977868B680006F0149034C078EC753E344427B0D68844C7F331A33125BAEBD766DF1380036FE1632CA06353231AE3BEFDD120A1620023A0F448EB9C0C5056E56678E7278E1BD80A72D1F6A4E8ADEEB2A47765017CE594EC38EF74E4332559F5B82ADEB35C225877C279F0766EFE11E2502780B3F4D2B684CBB5847374C5BD3F74A274E4B434F935675EDA17ADA2F5F42478A4637D45750A25F53EB0F570DC137002B729632FF23C003BE0753657450726F6365814D8CFF737344706941776172A616436F584E6C378E78743F5049F1A921A66F47C3625F5C155770508B5F6B5F8BC400ABD80063FE607BD4B08D6F756E1A64651A6982BF22645F6D61702F735235CE786BA4A7D7706F7369DA8EB9F1C52F5F76693239006C8DFFD36F68617368206275636B6506D2A0B5DF1C17D67175653C543ECDF36'
	$sHexData &= 'CB65F06C0F80001A8100695709410001A2ED06793F0A07527728272DB36EFFD57BD1C2E300620A7E020106026B3FDBA6DB3400618B63D6847C2748EE3B07BDDB44FD9D7A09F97D70856200736E8BE731036DA80064EB6A87B9EE7D9060A9070504020376CDD463BB5E80E73D61436015969CFB0F7B2BEF40780708F5F0124C4C2FC3A7E3B16B354DBB79205B6E46036B1A4180E30CE66F36C060DD0E008F00950F69C6C0F2EB9480618605040BFDC1D1C9CAE900E80170009BC337C0A66B00BC01F0BA006903D0EBDE077BD9417BAE86CF80EA717AE7CEEAE98904E97500F9AED84B6940613800D4EB4243711BC23295006604FB3569A82F7DD0C20060E0BE006D04FB1CF86AF527A160E11600EB58CF0E2846C36D720D5B0B7FC3B2738B2A6F460FD2087B7BCA669A73DEF0AE006C0B0AFBCDC5E743D389BF76950064067E0063065BE77DEA7166664400620C6621E61F00967C7F30670300660F027D9F0A134185E3ECC1EB0ECB1580F467E670EE617B85C2816B280123DD33614C00E0F00580F4ED263FB7E1890078F80AF1CD569EFD3CE743059065FF66FD2F4BC6F023F6E5E306B067177EF79EF533E6C6B30167D0683897E30782790152EFCF0B26CC6003DCF2B7A47BEE006D080C0E1BD4FB39EB134725740868C26203C533C99A7E3B1108F0E0EDB7B27F90F10B4C8C88006D016B648D8B2E024B8A4F61560168DCEF31E2EDBB006605027F075988623BB088FBE0FD0AE5EC5B907C077BAD47E90380D474E50B454EFC26067B31DF96600BCBC0E18AEB73CDC9D7DBCA6FEC8CE90670C70060F91453D0C0787E05E1420C47464C5B5FCBE25E0B980FF84F01EDFD7F6D740EF6F12833AC01B0286C076BE173803642BF00EA040A827246C20413AD83BB1D5FD01F041267F072736211455434F3045D156DF6A6F98C03F6801C0092F4E0320D6C310E24084D0C36471986A823D02C4CC2F73BE01E9D3B12A4EC9D250C80C0767CA66F88F4036185E5D2F2EAE2C751ED8B98DBD3C06443F01FF83F600B9DD6636249401B9BCC7E8846C27355826BA3C41AC767681A74EBFBCE6E8274C909F2690DB09C074365180025C40B6DF08DD09BC648E30703A755C9DB3685E80972FA8C882137BC678274DC08EBE60E229784E2EC42C6EAFB126DB833D09F7B08436AEF8AB537B1D0F108638DF56E85610F669B6B05EC0DCB4B3ECE782DD20416F0E6637936CB65D8FB01896BCF0B2943B20B707C83802BF58362294035E030E1EC144B6FC0ED8AEC081BC980ABFBEE6458080676238BB447F35B062A7646B3F2096B250BAFC1FB2E34474C2C407B7F4F636B0B159DA04B1CD1F48F7084EC83B21A09E98C06C3FA36145B82896D4870A6FEE7D26E4B3C03DB7AC4EE49E9B052F28972BFC56'
	$sHexData &= 'B5A044B864D36125679425F09E13D109BD0C0F3B081086F7624253BEB6BC8EA487471B1CA7B9CC7F1638065D509C64AE60405857F0B3D9DE898FAF80BED87EBFECC154D51C03C394BF09CF203E2FA603E43400BA774E70C5732278A664B732982037B58B0481275F5F82A7E4E843F0AE444E3004A7D64EC803B6F4B5149BA80ABEBEB78FBED82FC40552349E3054C202DBEEC704EFC7772CC0C4F04F97748E3D8C6E5F73811C3C9D083F048B89689AF79C5FB1B70BC866459C36B888B5581EC5020C64BC38373712C8AB05662FA86EB64301E72FF85EB09025D002AE843C40BC548E8285E85C67BD547FCF72D589EA105FB8F0B63DD009B113C304240FB994E704F3F83844DC56883FD705031C8F66C68F30ECC0A32EB70407B7820B2846EEE6B0CF1A24189E4BF8033F5F2CBA966D119F16BA88677142363C302826B48CB2C41470C2C58F5847875C495607CCCE87260E34487F58DFB403227C0A7EB0BE006FC00964C5B760E63CB0B99C2F906862278C8F370482E263248F3701CF89E290974F10D09C189E830748B837B31404BBE05D1EF456E09F70BFC8361BE4BF48051F90563C206081B413B2F08E4E22A305137768BF572F239B05A7B87026C2A8BBB8493B21279018C22CBAA496D4841BC588770ECFE4002FA6CF3A18BE1C1C71422E74518016F1604A7626BB1C4A56B9D8B5139B184FD01FC130631B3CE081774FE795DA3B783E0C76100EACBFAAC2E1CB5E3716CF6002B9624C063D180840B090CD894F41E0B0DCDA4318C67FCFA706448B916D05870EC084BD1E15EF6DC2B324570EF41E7846B66C2F90915C37B21C363E28EE453481B73F30C0CE547D132157B9C6B200EFE4EBD5854F3C601E6813B20386033FB5484C703C5C14D7DCB6D4571E201F4EB610BEA800B4B8C189032597033487894D8C38C0CCF7A41F38B503DEB46806086EFFAEA40E27762277C18C77C23C67E1628210FFC4BEA0A7E26075F7066CAFAEB035AE081DB71770A7BD31D09A0126FE831A431676B6788708E080A798FED4274707C84624DEB324BF63155E5407BB389F05AA3135979C9E807FC1F1C404DCB6DFAB1D3870ACBEA73731483083507F6FA697A13838376C0F04BC36BC409A8C4ABA58DEC0A0A4195B4DF71C03EE107D2A2187C1C8A640ABD23402DFD746AECC2F312121CF894B0E30E036D404FFB788096485734F27A6B47022ACF18D3CC6F0168789086BAC3EDFC0C18913D744FC5EE8737068A2BF441F21915633D27097C7BF3170B9469E7705DE3821BDBFBE25F0060B0982171E6FB8A8AEEB470F80F7CC3020C10E66778EC5049514EE3FD88F2A1D0013AFD6DC0F3E704190C7B9BE9C42AEA607C63728F8988870B1E407C0CF0259F560C7BFC40E4BB03420D267B3C170B7E'
	$sHexData &= '189954C3F003EB7E644821F6687AE5D2B318254DFB757E185544DE0E6BEBA04026BC28977B0342F303D27D8CEFFBA68D40F4E5A504D352F7EC41E0C9BB76FC1281FB8AAE5E3AF140E74E7502A0D2AA4675F7E6426AC4A57C770E0747191FFD72E984D53822F57037F7CB198BA34565FBA1E4C1D78867DE7BC6A821B4BD65FB83427A28B17E8EFBF682E8F417481BE37BF57D1068F973FA7ACC3AAB4093FC74630C340A47F04CFE84813DE9A872F87072790059E2ADCBD846674C015AB03AF9F3C07C14AEE8F0807B25282E0A52C2697092608E54EAED7E28261A5D406DF20D658A98B6FBC6746885523C1676F260A1CF1B78E2FB0BAE658377F57B96F23C1C61810BEC73CE04413E63EA8AFB8DC8891401ED60400976DDB42912E071341723D5206789EE6F33CADE00D53305D349FE7798DBDED3C5460693ECFF380A0CD1F55559FE7DDE7950656660680B517579ACFF33463ABFE3D58833CCDE779ADDD15594D7D349FE6F3BD335ABE155B506C9FE6F3A92F5CD08B5D56305EE7693EEF06C50D5F65B5EDF3349FF52D6085F9BE615E059ACDE79D6206C116637968DE9EA7D97CC26A006B407DF59EE6D37C366C7E016D457D3C4FF379BD076E4F7DBBCFF3BCFB086F3E067DADFE20DDE7799A705595DD15711EF3349FE70695D50D724D80E7799ACFDE0D733D7DE6E6F33CCD3E746DADE51D754FF3799E5895D547768DCDF13CEFBC769677068DAA18D33E6D6B8D8002E4D4163418D50E40E6F3BCE6114A4C06B8F41F4BCDE7799EA7ACAFB21D4C256EE0F33C8D956C1182CD66DB7C76BE2872070E363023108FDB6C369B40C10C954D31014A4FFE2D77EB72860000264E077B02F34E2E82072501202427E169FE4743544C0010802E96CC4EC1EE2464694F801146B0276D863DEA21E73086A0254F780106D93A7E771E41037987AEFC95368026B469646174612435B483022B4FFBBFD72E30306366671EBC044352AB4CACFB542458434147C0274CC44E26A432C91C55E05A62978355E49F44E827EC72205F4FEC49F0275D0EE44B4FF44CF8322195892743FC44402A07B200845A04F225A4F25041084F0C4BF22E07541026104F1ECAC3E720E039C672B9AF176E47671F24B71826F843B6EF90147297D326BC01FD49DADB73787DCCD47E8C766F6C746D64E076C8F38658D5037A0064626760977FF24E50D972746324494154274606F6E05A4F584F545CFB8EB3C1274F60D93F746C731F69DDC8A768E80824DFE23F3A307ADB245AB726881789C1D37C34183EE007030165B1B968013B80091ED817325339645B980A26140033AC64B3BBA2673427600E801E86EDA530B130BF6FDE87C9F6A0311EF00DC4903F3E2777A57DC71F736567661C62737387DD860FCE70FF73720030'
	$sHexData &= '3127A0D406433EF0034E01B12B02798000072F154C02425541046D103F1A40AEFC220593190102D27C01C948F7551F0242305702A8C9257F1760BF02426BDC08142817A057484EC101EE07D32CD829789B430F3ED207D360AF5DB4AB85578CBF502EB948AE57B880E42427B948B0D4102219A95CE0043CEE767B6F44970E1F1F270F2F873660B7910380EF98870FDB2A75B64F44C08F87330BCFC2AC08971F20B88193B3411F23B46A51485E1A3C208E8705D500609130B9F0276968C7B80F45C50E121F5B0839C1D54C97D56C676DD8C8B0401F02484F03079C3D08BE8680098722C01F2B0C293A119CC6A722CC4FA60012C9D5D486EF6B5D866A881F09D657A6856EB50E58C777C06B74094C977E8D9C7D503F45E1040FE905F100E846863F07F94F06C189E09657DF6C9725B32770A260A406A097463047CEB6410F1E38020F40034804AA3A0D23503FD6F427149C16160F67D7280F915CBB5DA0FFA8675C9291EE76E00FF96703901BF91E2647550E48015377938B64A404CC80EDB4D9938893020F9EFFD810875D272717D0E9F177BB762239D84C4830CF7857E4C8D94560CF4868487372ED22B9B4A057E0484EC545D05FD90C24D7DE9B491F0E08674079ABC05B3FCF66744572ED227057A08B64A4C1B07F07CC7266B393F0F8B74A040F0803748C1C3910041B0526B7C99113EDDA28B74A974A602497BC8FD7868C6C4F4E2E583F4A4B4B08C90F381D6FDAB0C7DAC8CDAD2D074B3F97779D8213C5DC69600447DB105D70919CBFDB3080478BD82D11E12F278744CF5114A99C623A05FF3C3B727B4BE0CFE84C0B1F4C17031032D28D22970CC8DBC95B816F7E60801FC8D993D98C029F97A2040FAD05727272E4B806C3050403E4D76072020F0F27DC5025364570DCC80F4D2FCC8EFCAC1E0B660F130336042F422347CE9E4D060F580760086823675711FF0A2F700B7B21EFDA20003F0CE60D487CECF6DCF0011F0E27DD0009CA89E2C00F70AF7771FFAE086E67D7DD386788CFC064F6E442CBD3031FDE91B367C24F4E09060F15021EF231B0207F08AE09DD9CDC4E724276E8DDD047F8B7E401469F024E60DE9037B09368702F03DE04538013F2DE0C7905FFDE6E644B24BEB000B8674E2E92910374F0F8918C54CE774F0004B0479377304F1F0E4827B9482E798658F490AA30993D98010FA0B7BA938B76DF3887E0E86701D29D48466C50205703F7AA4532989F506AB7EA1AA9B476750BD81F91B793367EB0BB1FBB026F89F055BF50CE036F1FD606416627672FE106071FE93995BC74FF0EE0585130CE8EBC1D51531F5F026A030F72049CBD6D477D04BF1F85074F90086627478E9B09A6090A1FAEE8381541EFE0ECEF0A363999515176CC06C9A377E130570C9C62B'
	$sHexData &= '88D6067C00F5260AD19C38E52792F029F6127B7B75F3E810F969E5F5CB720B3081FA99FB16713F208300AC7E1D4BB4C349CA2EF9FE2083752AA18E99E5309677940CF1D79BB9D53406F681F74027F03479E8C9C0F8A0495A006AB07939123674FB608BE09C9E4CB91B7DF0FEA0CF50D54000EE4EC3672080F134FD40F541E8E1C39F2291334143F1547169E9C9DCC4F525D0F584B561A666F23475E1B694F681D0F7023674F4E7B86202F8E21996DC79127A423AF23C71FF264E4ECBA260FC523D0DB29BE3C1939E62AF1FC2C55042D91232747262C2F313072E4C9C83C31474F305A34793B19396535707B2F8638F2C4161C912A4F0F559C3C7B32F236C41FD03EDBE6400F47BE1C39F141FC425604430F44E4C891231A45254630478E1C39723B484649514A5C4BC8912347674C724D7D4E1C3972E4884F93509E51A9529123478EB453BF54CA553972E4C8D556E057EB58F65923478E7C57015A0C5B175C2272E4C8915D2D5E385F4360478E1C394E61596264636F64E4C891237A65856690678E1C39729B68A669B16ABC6BC8912347C76CD26DDD6E7C3972E4E86FF370FE715809729123478E14731F742A753534E0C8357640027FE6DB07268AFF58A70EC901D2AD0123D18F8F276D39D535786F59100E1B72E4C89101260231033C04478E1C39470552065D076808E4C8912373097E0A890B8E1C3972940C9F0DAA0EB50FC8912347C010CB11D6127C3972E4E113EC14F7155A02169123478E0D17181823193972E4C82E1A391B441C4F1D23478E1C5A1E651F70207B72E4C89121862291239C2479441839A725B247E7D4F2A8F4205AF067E800743BC9415BE82C67441C210F1AF75B70E846BA0773B0793552BF0C90A58D384EF02FC74F46B60F0F0EB802C0C80191236727051FD006D80703C1C9C8E008E8E8570A9C90873C0BE90438C26222394AFFE95C918C74EF7D0E2967016CA691EE6B555F08A04F793B69A3CEB0BB1FC602A0D65D18D17F043FFBB8317B5CE3060FEE67EA04010F683B41302C2F5D300F52D52A18EE07BE02E1C47028F7EA407742F81A4E24A70FEA745D70CFC3B44172EAA067B06F9C9A4A4EEAD85D2F3B5B3022EF295DE80F01935C70FA37FAEBD2DD4E14FF5E300F426701E4DA45327070BF9C52790F8B3766AB04DBC94532D0E0EB0F4472DAC8F302FBEFEC142423DDED5F300F38670148B948AE5D705774A029BA482EA0E08FDD4EB0DBECCC67F45760400F489D9053108FED087E0772C16EA7DFED3C4764DF801372057288787F90912395B307AC02E4DE36982EC027B72ED0754064480557014CBBEB83FFEE0C046706271C1B133B1127833E1F82861D24A78FEE50610F089C5C24D7678440489C5C2497B880889C5C2497ECC0C8DA89E4'
	$sHexData &= '74FFEF2062005723958BE44C4006786FAF5A24B762A81FB002B591B323B8030FC604CEFFC9B513C9CC630057F88BE4241730F02458242395700750836DE43BAF0EA801B02FAF742347BE0EC004CE05D6B7043931918CAC64675DC191CB641864642E97F02239EDA2876057F11C1705A7E3A0B7F14837D027926B27D8BF7C65106A918C745704A8761503EF250E4B87068783E42360ECB7F21C2D31EA91656588020F4F421EF26B4705F23024B75370F67477F264EF84C4049C5CC0C8A75239212DCE98F7920575D0A228FFB22C61202FBE6608485EBA6FD20F299703F318521979BB7077780180014EC5453254C027F380491B34DC67B037CEF0C50C8BE2F80117C76727C81FC2E40387F3C4923C200F020EE7020F2EE4C829E81F4D2FF418F4480BE4C88967306738E4849C9240F45C10C72E392127110E112DB039B9484EE0707842AEE40280F49A90137212A712EE13FD6DB71E75FEAFD80F1F02349DCE960CEC06B03FD07F37A0DDAC34D13F38A5176084F74086CFD4394C066B539D5A898347F5BC6FF62E7642B62436F718F6E81F846B17D442B76E787FAEE1D95807C75CD6263784B7409010378172C11959074007A01FFE0C4D72683FAF02F73477C1A94D87195017B0061EA1C9B54C8FFC07164EE9D16F1020BF37F62278B9140D20DF4004A72939B167BC94B721A0D94672C108905FC4A67005A7E4041B089F24942910D8055D1477F877601CD46AA767059BA4A9AF7097E736C4424E28C04E011EED8388140F03279429D5AE644AB6324F644A5EC9FEC02CDC5EC9D5AE5227728A1025A7764A3C2677602498C257320A26270344444988578A80B88D3B070282DA0180FF0A5A903C00BFA24078A899B119BF44D06E311B67017598CE545B156F01FFB1950CD05F3287164C0042E77E261E4A02A89C07AB0C5F7904CF1FA94401099AE82E3F41567284F04E084C696D655F5118ECB7DF4073746440403F1FDAA6147E5F377F3F245F46B39FFDCD616B6E6F5F636F7079085861626C206EF6B7ED76617074AA40563C1E6D62185F313E403F464C06FEBFA0F03F556E6998496D61676553656172636818C2DBDBAE594197DA7369635FF7D6CCFECF405F57552238405F1E61697473203251B8040950A5367BF60D642832402F4142559F500889606B66E65E005A33672482230AF7E5763E5314AF324245F74660056D46A642586D48A99BE0DF100540554D5E3C5265B602138573448735FF141CA425A5506978656C42756AB0B7DF6666E8403048005F4E314D2E5BC4B0C00634AE3036343F4161452166D6D0B6F6DA63EE6538436F107554650AC8E7A08A79FF344A4D555C0B007467CAFDDB83682D476B373F00523042460ADB3F340A5F53359242C143D846754D9DE0D0A'
	$sHexData &= '9545C0C0B5F9270186EF8C16C5F88654064658A696C737BB415029E514145E4555F7B2FBAD63048D664A6426F332B5183A1821FA0585A2F3120663FFC874DF8566F6964546FAC744675CEF525850D09C1832D0C077F40242441361A5A73372466F01C583517FFB5181E29E779A62785C55F9EAF9AB650C17FEA3F30D75B0EBB8840465906796E45050A73A558EC75065B3CB20BBC760AA10AE0A6A0320B1F11259F0B33474652100AA62F964410224A509F4A1CCD4B62999840095514AC2A61D381858A8FD167FE42B2B4C005972195E1C3FBC55F5F496E745075315F56054265EB6124208ED17717B41A7111DF53D1555D5855EFA7611050608F2816D4B4112D9FEF89072F4343205F4391416E6452C4862BC4756EF173811B26987E6B40450D55165F4E85410F6C023030697360A60F021374F6885F45810D09D61E486F6C76727FAF4C1442D35A9F67C4EED2C25F7F886D06A56AB057533F9A6B0B095E5F5F18316C5A172FA329059D91DF580437C17479E0BA6E666F8FA5E278E23D62756643513A3151F74651701033B6A25A670E7932DF461BD181898F15229D9AB0665CAEB862802011C76A32512FB44A7146A8210E4541159E175D431C05CF33585656DF559D2B4D3F50504C67FE254915D7AC418669CC2D58D501AA0610C654AE657027B4386CF74E6F41E18AA16C41CFB8BEDE0B0F8903CF53E1B6150F6CF179BF0B34AC2A3FA0735FC180558027076DC488B1435757285805582FC8732BE0C22B5A695264F9C4948000FF01652BA204D7782CF80AD63BDF476469D07573B01A3627851727A4900F4E616F666465616D51ABBA567FFF1AB00082635D1C04D78AAF33C42308A9465F470854E049F1C16B7C50623F716CB902B393887A201AA42D46E8C4636BFDE46769821B819992B46593410F1137D8C44A8356EDAD6BAB1AFE058477496F736240482F8DA342B149741E5123D0EB3F4465A01B0F1DF42C7726AC0A140FAF903F102087696F26AD03297F77780A05A9B74517AB6A45AB1FE788438B19734F527168417755746A5583CF3D58150A150D6304D3EA9705A43590885F6D319A923C8034357DA863C414CF1D18425DB7CCB7A73AEA51837243705631168C478FC01555936900C00104A88F2DD1B4AA405717D8AAF4AD8BAD475813AE91F1A15647A8001777E9A1C4D16750C40AA2B31256AB1B320505955E8BEE7F49447528A9AE35AD0A932F00A2440A97752845C5011D4455AB861F0701096258AFD2AA038BE79F130B8AB00E9F2B66A4A0C197830EAC13AF57AB0E600D77AF351254030FB7EA418AE4699745429C0A309FFF622241213F8D2A4E0D20EF1AB55841190CC35DAB42AC1FC3A35688545D2FAA00C900665F513112AB6D55C08ACC366FEF4051A855'
	$sHexData &= 'F531AA2660CFD51814C0B94F888840480933B03A14CF6B8A78064637350630E0C967671F552A00D75F4469DDC4DB0C3058756D9539505B5F083969844A1005AD4056045036112A2A09BDA6B1C06601474F49E82F1141646472181E6C43171BFA6F62616C4DD4727953D96F6D67FF45782A4638654C696272612874FBDC9018F9697A6553267374483380E736008F3D085D64E0545441734667097DCE9213314323CFD45AFBBDC6495A51756592500666CA6D6F89AC2718A5D04C6F6164606D7B2757D273674C46CA6A673614581E1A943457A812BA1A0A416C6CDE64D650EB48C9566269106E00E9C0E1546838DFFBEFD1B653306570575352C6416371756972179B12589BF6636B32836486B74E69768E4312D4BB90196ADB810C521403338D9DDC4D75840766A81A329CAE53CE7B67866E2C4F626A4A6CE67443AF6D783057195426705024681A5396849A0D484C614571B805906E5344633E602D7B666ADAED15067258BB0916EB93571F4A234EC8D5D0EF3641D2134174EE62022A6C71FA6E2B169760C506014E611E4279A3601C2E1491539A092F695D08C239353D32184105EF159FB370D8414E5349A98DE21E2376478F73576964B386DD90BAFC546F246C38348741B230ACCB6EA7252DBE818A694DC63FEEBD572C419B3B9F80DB4FC7CE0C1F458C2A7A23428A1475436A6E193BA3F751319500A4010672DA78AD09D27763F86C0E5F114595A7ADEE363438C6B05F066CB13302706ECF1A1716D2F2B444EBBCDE3D68DD028A6814667D6D2DCDE62087420A02CC830237B4006C63C6EA70A082E579667EA63A2BD450C53783E0626D5FD6AC087172745F70F6533381C569DD9AD00A720C4CB13CED64665E4AE4BE4044AD192E985FA812695E74C5B5B3D3E05F69EA5E9418246FF09CC19A92274B590E724085E502E77D06EC61DB0F5B6FB78374E1D83370C477401942324776F24A7D0B5B35D8B8122A67163D0A963D066E67762F9E68F3E60C1C0AEE726E6F0EB6688707FA7C0A3A206CB26C187366775A6C66214C993A44656B1101E46030F412746687BE7D0283EE4CD26D6DD85F767377704CD4BBCD58F6665F36467644B178ADC010946714636A66CA290C676A1F637166705EBA71DB5AB73F11660F0DCAAA21B2D9288C0250732C6DAC015AC7BA227786770D69E4A7010F0A00679200AD50001D46474F250BC6523D4976259B2E3B3DEDD156FB4B4443424474B0B0D9E813B851572B6FE52930BC9A424A28B760A6ED0D2D6299D15AD2E2E664A6CD336C683ABDDBC6921FB01BDA04DB59A6CE25BF4772746869C05586B6C44D2B1FB673CAB239CF7312615E92F9AE477553E303C1A8C54F664D4DBE4748259619FC4249544D4150498DDF263096EA73D39BDA97A47'
	$sHexData &= '0D1100B9F06082A5E3253E86F8AA808168A692B442066E30A6E9B0648706768AB44AC7770357BF82952A64927413F86055757C155C9C5C964CD06AE53AA3035608B4C78B004AC757055E5E95890EB48D0C090C095513F85A7135C4B8715594165AAAE327BDD3784405F4A4031095A58693C30D2574AF7556376740444555F4D62F8504AC669DB3256306CC0554A0E1B3C4162E040C058043BB3F57DD804BF504244489F5FB15D43031E5074E2428E6C415FCC1CABB54E4458434482969EC072A485B64318ED000B027478F359B4B5B14CA7256BAF1819693E52657468774243784D0104B01D61DABCDDAE56375F5D3B776115BB946C2F355F7008535C76BBC0822B3B5962BE563736607A88F8A01433F5A4808D4EC90520142AAC7F700CBF58914970667840018089183351D31D45F0C3133F300F4950E0B2997CF973586E916A87480B8047147F0D6A0E0C1281662A6644317F4998148E91584682F4738ECE4ED6E02081408EA928366C644848C53F6A1083657ECF46855CEC464ED96F21153B3BFA4F73E15AC59C9079117B0DB0A882E831FD7C2006F0446B3F4A5CD0A5FF488177DA03A806B16E7906F008A60B15AD6E675B50A4C2DC6322E801C9B0836E5F4AC4910ACC2B0A7D532B9019525531DAAA6D93556BD577A9A85EB85F2EB1A076C29055EC83283661D1B46F778479635512F694A94D89569800039AC081BF7897AB380EC2594D417241C72178E94D03DAAD165E6A8F25B582AB50EB27B6DEE580863548695A658D0A1FD07F5841420B45B42914BF95C70D188A4D6F733673046CD500302450360EE73335DDBB318A32316A07246AAFA681945CD40E487F49D542355C4A01818A23740C4D9B29228CC21E676F6F1CB3634BA004184EA706FCA21A067C87534149506F44F76A465666616328D12234D416E045DD756EB8696691B6C0046FF248AE2FAE443115A0FDCE220A8D6F7585769277EE98870C9A33696E9979D941801F0AADD60B32E197C7E477617973866D974C6A787640ABA91542B509582A64517360271CDF1B935727428304320533CA1B29DD789A5F6F665FB0CD06636F203D49B2636EF0AD30484EEE0D4330D20E084F8A77DF60B2B692357F718C59EA37E33713816D0EC06771AFBD0EEB8487430C567EC4223DD88840D1BE6175700C3B4E08C573A54884F0078D54845F4370700A9B71AB37E0076EE382C823749531315A83DC489FAD0A9DACC572717542C70E85438F6F701B65A1ED49030547210A0946B39CB700C712065459CB8D97667119D408170E2A5D41D9D86E3F138A496E43495F11AAB23613B7D95505E0C78558D5686D46860FC1C84108D69865A31E5842B1073070F86F1D80ABD5D87034556E681B6400B1808B458FF96902206DF7A95F'
	$sHexData &= '56AC664DC9596166F670B424EDE4AC5910F0B1EB31BF2267F408042CFBE345763843046FC632670751B14BCB6D6F836B7F02706117587B63033044BB856481451B0D07B583749357366B6A4B09814952B6852B52142C0F1F48241715AF4834A75CE1C1F22AF664200BB171B59FF9805A8F464340700E3823C4567E717DB04D501913AC6A64770680D1953672454FC2D175914069676E97586011E019FBA55816033FBF00DD263072B7960015C864FC8E1DB8661F807849732956CE6075ED00B24D542498E13243A1186AB0A013D809076C50C1BA4D0F9E858953312360F1F46D6F75B2656B9F99DB7AD99F964526196D8A81B473F3CB4D107206C03B00AC513ADE4CA81B7E794D6FF8B2294368AA80C31A8C648500E8A2708CC10257437878B55BA8214C04DF5FEDE602AE755F642F580E800BC0733B6446B2C681EDC419723363771180D4C2633148C00903BC2A707A9417307646D954E75E151C1430E4A216A863F04696CE570ECC11C0B7D8CE38FE9BEEFB34FD3F8C542D450C0C06170A1617FFFFF6DF0B1B0D1C12060A0A0D09060E1E0C1E061221131C0F163D06162E1BF6FFFFFF20F0400123F04201111417073307210610262A071C0C1D202011092604FFFFEDB7181EA00F140B0C2E1420AE22124412F0FA000735321D0C412744FBFFBFFD1C0D4646300EBA250E09371A66150F4A570E21100B272C2A062C782F687FF7C70CEB71250D2F5E0F2423FE38001D080D0EE05F21EA080A113A0C3E2A1239641337FBED6FBF060B0A3D12228D641A1D0F171F050400120E520D592E30FFDB7F7B0D154F1F8A2D0D26AD12626E5E0C480D1A0712E00C142AF0C6FF17FCFF01101A96123A297B12641E9C125C8A28080F0F8B24920F4F157EF8DAFFFF4742088E1257770F267C0F110E0C0F2C05060009AA1823FFDB3E2848359C230507002E4422F088010DF01903FFB7FFFF90907F10F0DF0121F015016075BC14F016B8F05003122F3966123740C7FBFFB76F164B011A44112202063015192A250F200F06225D154932FCFCFF0D7FD5CC100F6ED47F209501D90FF036014C43545E1B3E24102088FF379E3202811B3213447EF02F0356FFBFFD6FE4A412590D06261B1F0A13002D4729242C7D2A09391D09171A75D9C1BFE121551828231B090666373012330112F541FE0F4D23F04F01049E0D1305FFDFF0AF6A2214281F28110807F88736223F143C55E8802F3021120250BFDD681084B8496A14051505E84651CFFE2A202A0C821376E5191708986F4DF1F605F0CB02E649143664562810500650145A374183E3DB231622382702806B235FED15BFFD06110B09091F18660705190855500F0E12D69044D9637FC115655213123DF0E101147532050EED6FFFBB9C472814340'
	$sHexData &= 'F2E074D0C0E0BC637D2231328075816126EC75BBB4F06AE3E042D0E944A9A074B1FB9F9B7E1121A06EC08ABCB1D0C0640160B52D66E105C350F210AA80E0A3F4C0F46075BC3E53E0930212844820D12F012BB596B6894C7EE0748053E1A055B5E897BDB600F44220B1E2E090F56580F1D0D8BF8BFDBFE17F0220106A6250A191215062B0C50310E6513435F2411BFC426062976785EF01C01F01814FFB75A040E02AEF029020D7613F067E45905B7F6610E820B05EA1502F08401FE40D31FA7F6065E1E8F0C1D3E124B063B6E3F7FAD69132E809D244E0BBB4A07C6F021D6FC6FDF0258440C90625B133E4928066162F055F404EF49D4C174012D00050A0F77D382B40A1B7622091C5F5341B2DB4D0B0CA08C1925780D330F90D102F8EDFFFFF0E80112A61F241D1C1A1C2CF0440236CBF085207DF01402136C10FCFF29542D356F43252A102FF051027D1A6415AFFC375A031216241205282B2B11E839DDF126C5010B5E702B241819F0302D9B3480C7FE52100511102249F04CFC81D96D5268012E0471D401080CF05CF769821778820433F05EE22A2955C0BF41B0B519021E063C5FCC76FC000F0BF073B6BFBFFF015D1DE639393A3936023937353901F0B01742881F452F6DD2AC1103C19C0FDA9B86A6986481F8C6C801543301E1FFE6FFF0610EF02A015F3329252533EC43071745094B1DFF8BFFBFA077A2172C247830360F5A132F3116259C12401B161A0F540E9F5651F5190D1D11F20EFE160C565F0CEDAEFFCF249AC757992CD50D423E21147E1AF0B45C1E74D5F1DDF000094C010FB9222C1ED04EA2E8AE587A1A140CF0BA01E4140CFAF602C5522AD81423060800061C092407DC3A56AD4E060B1A070D240916091A0BF5A28677FE09510F1BA819EC232B0983D76FEDD63A3DA4D3F00A7E910E901B0D523446E0DBF5ED5B1E8C960F1C06180485124E0C64762F010E05F86DD7774E2B04066E040EA006142208BE00FFB723DA2B08F0EC02127AF00D01688A1BA03C0E47A0E0770956464F1112BE0D20C41FFF2FB8A0683206314E1918333FB173159C20180F82428A35C3A6FF62B7C269AA4A2E41105A185E8E422260DAAEBFC02B07AA7A0F1EAF2E083B046BAFBCE05F1A0360F070036C1262245332223E3712483B71B060C53659762C420881037003FA0B0E500024D4DD027C06631EEB1299FE45DF608626D9040D8B15042D0F162847131568DF09F0EF113524360D1B150D78FA1B253A10155B1D0DFF77112C272F120DD212076529A638105C077F0051C119A8AA0B884EF006031107710F5FD1476FCA572C1183AA562CBEE3575C84202217541407371A0D14BAB4024A3F5CC1776C3B485A608AF0BE2E2D202550E932BCF9BF605E022A010211F0EF01122D31'
	$sHexData &= '1850260D1F50A0602B78D24ECD22F0EE0440C014DCE632449B4D121837FFDFDE36F0181D586C27692A50CA013E5D1C2E43142E0C3108313FFCF56915A20C3F06C611281D5E181859FCF668B053E6961B0008C9128DF0D105F1F2FFD7810E5906476E0F31260F1673651D364056652A966606FE84300A557CF5827C34186C3D12101A2F3E3401BEBF7D9B135021DF0F335E201E171855188F151B7CFBA66F422FBE8B3726A940375977340E443E122716EDFF22AA332428111549192E2708111FED87D83BD224063235093B1C99271902172DC017FD3F0A2B0A50168A12290C260C3A470EFF0DBFA81625E00C1B900A170BCCFE000A3E2D6B147717F1EFFA8642902A15814506A606061218120B231F5D5FB1CB80E64C745A93014C4F710A02ED5FF51D721FC9F0D001023A034B27F07F0206010A5745C10AEE1EC23F70A86DBF417116A4860D0728080D0D0E88A4BF9D35144E334E174F15183E120A680D281210A95EFF4B292D36C12F0D215C007AE678FB5DE2186912C23D1A120C994F584C00D1DE0E705AF436100B080A0B1A2014B0A66D3C0A0805B0342AEAA9EA37094A4616141D3B0F09A83A01766B9BF2220C2338133A1313060101DAEF558252025B0E10343B3FF423D4DFFEFF37004F2420202D52364A714D233F6242485D38432A3F2E3A407924F0FFFF270D574A48593C0D3D2B0D69400D6E580D404A4BDBA2FFEF784038163881340D844728944839224F0206CE02FFEDBFE362F0E7A0403A78122F4886374298482E3E4D3D383A4722FE2622F0354048424A06295E2F3A366958EB667F01F638383B4740685026001D153E119F11BF4A1D0B0D190A33D81518A960F8EDF23D0816707066F0AC84AFDD9ADFFB1C04F0E4260E081D14047C3514A28568970D1A01750B36A2B6B315BDCDFCFCC804085818A81804100818100E04ED6E76B81318561F1424083376F7B5B50F26183F105A06056D976D596199775E2FDE0B7BEF296B290FD165EFB92DDB01C5554157EBE71EBCB108434935107B0FDDC2C636C9FF7BF108C0B977F09D144F6D1D13BC3077B035FBAFFF5D48B0E01DC34569E3F60EC62E0908EF07D9036CC1DB5E49E7A5D9572D78DB865BED59DB6D633796BFC32CCF3FB9B063EF2DD78914E31DC3820DCF5D211F1FD55CFB676FD52FF0540F200C2008043009F39E6FD30308000C08281408101A109C7B77ED20101D1C1004141B016FDBDEF6870507110BC7DD6EED6DC36149B51C1008B6DBDE9BA89B0C24434F2C1537B8B4DB0E24140A2360A20CDA5A5868F1D997AF06763716519CF6ACBD070B6A772448011F191E16B010FD9571CFBE0D69631187181006184843C116430C28A828275ADA7B6B41894B0D0014D8B6553CFCA151EDB815DBAA87AB990'
	$sHexData &= 'B1DEF62519F3533876A640FB1171C04204E7AD3CE69C106A5FF021C047BDB7BCA14213335113B2BC4DDDF31F0AC29DD20B424BC2C0AFF16E36D988016F06002B852303C28D001A82C1C102FD2FF28881850304850F0D801001C24306846FBBFB61E244406030E30CC1C405068403448589B6DFFEFCE3CB8643834F01002C82420345E880214645801BCB5FFFE50A848483C24385A407040A0F0702C3004C0024434ADBF1705034C01050064D90737480AA3BB66210B01BDDF5EC40E320F0E0127B7491610DA7BEFEE10800E121714063B0FBD5BD17800A003BF63EA033C401BDAB6EC78106F0F13BADE8676AD9D2CC5707E551BDA0E9004290300D01FA78094424DA0BC7B82B476DA2D656D704EC4142EA5EFA8FC762EAF6CFF2C57CEF5208603928ACA1DB053FEBD0BF7AE674F4CC7D041EEF9DE83ED402E4D0930F0384E1E0306904E1E77D16FC01D4F9E370C09704E0656B7D10363E2B1A79F726565F74E3E79DE804E205CC7D1AF4212FE9D19682748AC0F63BC030054922449FF807C2408010F851B02000060BE00A002108DBE0070FDFF8D8774570300FF30C700BF49D83F505783CDFFEB0E909090908A064688074701DB75078B1E83EEFC11DB72EDB80100000001DB75078B1E83EEFC11DB11C001DB730B75288B1E83EEFC11DB721F4801DB75078B1E83EEFC11DB11C0EBD401DB75078B1E83EEFC11DB11C9EB5231C983E8037211C1E0088A064683F0FF7475D1F889C5EB0B01DB75078B1E83EEFC11DB72CC4101DB75078B1E83EEFC11DB72BE01DB75078B1E83EEFC11DB11C901DB73EF75098B1E83EEFC11DB73E483C10281FD00FBFFFF83D1028D142F83FDFC760E8A02428807474975F7E942FFFFFF8B0283C204890783C70483E90477F101CFE92CFFFFFF5E5F58890789F7B9006C0200EB318A07473C80720A3C8F7706807FFE0F74062CE83C01772483F90472248B072C09751986C4C1C01086C429F801F083E904AB83E901720A8A0747EBD683E90173C08DBE009003008B0709C0743C8B5F048D843094D4030001F35083C708FF9610D60300958A074708C074DC89F95748F2AE55FF9614D6030009C07407890383C304EBE16131C0C20C0083C7048D5EFC31C08A074709C074223CEF771101C38B0386C4C1C01086C401F08903EBE2240FC1E010668B0783C702EBE28BAE18D603008DBE00F0FFFFBB0010000050546A045357FFD58D871F02000080207F8060287F585054505357FFD5588D9E00F0FFFF8DBBDCD203005731C0AA5949506A0153FFD1618D4424806A0039C475FA83EC80E9DC76FEFFEB1A56BEF8830210FCAD85C0740D6A0359FF742410E2FAFFD0EBEE5EC20C00000014D3031004DC03107467031004DC03100000000000004000000000'
	$sHexData &= '00000000000000000000000080000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000070000000000000000000000000000000000000000000000070000000000000000000000000000000000000000000000070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
	$sHexData &= '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
	$sHexData &= '000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000DBD2031000000000C000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004030031010D302106F000000B4830210000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000CCD402100000000000000000000000000000000000000000B88302100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000020010000000200000801800000060000080000000000000000021B003A9000001000100000038000080000000000000000021B003A9000001000904000050000000A4E00300580300000000000000000000000000000000000021B003A9000001000200000078000080000000000000000021B003A900000100090400009000000000E40300910000000000000000000000A0700300580334000000560053005F00560045005200530049004F004E005F00490'
	$sHexData &= '04E0046004F0000000000BD04EFFE000001000A00E90703000F0003000300000000003F000000000000000400040002000000000000000000000000000000B8020000010053007400720069006E006700460069006C00650049006E0066006F0000009402000001003000340030003900300034004200300000005E001B000100460069006C0065004400650073006300720069007000740069006F006E00000000005B007800380036005D00200049006D00610067006500200053006500610072006300680020004C0069006200720061007200790000000000460013000100500072006F0064007500630074004E0061006D0065000000000049006D0061006700650053006500610072006300680044004C004C002000780038003600000000004E001700010049006E007400650072006E0061006C004E0061006D006500000049006D0061006700650053006500610072006300680044004C004C005F007800380036002E0064006C006C00000000005600170001004F0072006900670069006E0061006C00460069006C0065006E0061006D006500000049006D0061006700650053006500610072006300680044004C004C005F007800380036002E0064006C006C000000000034000A00010043006F006D00700061006E0079004E0061006D00650000000000540052004F004E0047002E00500052004F000000340008000100500072006F006400750063007400560065007200730069006F006E00000033002E0033002E0030002E00300000003A000D000100460069006C006500560065007200730069006F006E000000000032003000320035002E00310030002E00310035002E003300000000008800320001004C006500670061006C0043006F0070007900720069006700680074000000A9002000440061006F002000560061006E002000540072006F006E00670020002D002000540052004F004E0047002E00500052004F002E00200041006C006C0020007200690067006800740073002000720065007300650072007600650064002E000000440000000100560061007200460069006C00650049006E0066006F00000000002400040000005400720061006E0073006C006100740069006F006E00000000000904B004F87303003C3F786D6C2076657273696F6E3D27312E302720656E636F64696E673D275554462D3827207374616E64616C6F6E653D27796573273F3E0D0A3C617373656D626C7920786D6C6E733D2775726E3A736368656D61732D6D6963726F736F66742D636F6D3A61736D2E763127206D616E696665737456657273696F6E3D27312E30273E0D0A3C2F617373656D626C793E0D0A00000000000000000000000000000038E60300C0'
	$sHexData &= 'E503000000000000000000000000005AE60300C8E503000000000000000000000000007FE60300D0E503000000000000000000000000009EE60300D8E50300000000000000000000000000BFE60300E0E50300000000000000000000000000DEE60300E8E5030000000000000000000000000000E70300F0E5030000000000000000000000000020E70300F8E5030000000000000000000000000041E7030000E603000000000000000000000000004BE7030008E6030000000000000000000000000057E7030010E6030000000000000000000000000064E7030020E6030000000000000000000000000071E7030028E603000000000000000000000000007CE7030030E6030000000000000000000000000000000000000000008EE703000000000096E7030000000000A2E7030000000000A8E7030000000000BEE7030000000000C4E7030000000000CCE7030000000000D4E7030000000000DEE7030000000000E6E703000000000000E80300F0E703000EE80300000000001EE80300000000002AE803000000000032E80300000000006170692D6D732D77696E2D6372742D636F6E766572742D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D66696C6573797374656D2D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D686561702D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D6C6F63616C652D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D6D6174682D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D72756E74696D652D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D737464696F2D6C312D312D302E646C6C006170692D6D732D77696E2D6372742D737472696E672D6C312D312D302E646C6C0047444933322E646C6C00676469706C75732E646C6C004B45524E454C33322E444C4C004D535643503134302E646C6C005553455233322E646C6C00564352554E54494D453134302E646C6C00000000776373746F6C00005F6C6F636B5F66696C6500006672656500005F5F5F6C635F636F6465706167655F66756E630000006365696C000061626F727400000066676574630000007763736E636D70000000426974426C7400004764697046726565000047657450726F634164647265737300004C6F61644C6962726172794100005669727475616C50726F7465637400005F4D74785F6C6F636B0000004765744443000000776373737472000000000000FFFFFFFF00000000D2E80300010000000B0000000B00000064E8030090E80300BCE80300203E0100004001003041010080420100B0420100C03A0100B03B0100003D0100604501003'
	$sHexData &= '049010040490100E9E80300F5E803000FE9030026E903003DE9030054E9030068E903007FE9030099E90300AFE90300C3E903000000030008000A000900010005000700060002000400496D616765536561726368444C4C5F7838362E646C6C00496D61676553656172636800496D6167655365617263685F4361707475726553637265656E00496D6167655365617263685F436C656172436163686500496D6167655365617263685F476574537973496E666F00496D6167655365617263685F47657456657273696F6E00496D6167655365617263685F496E496D61676500496D6167655365617263685F4D6F757365436C69636B00496D6167655365617263685F4D6F757365436C69636B57696E00496D6167655365617263685F4D6F7573654D6F766500496D6167655365617263685F684269746D617000496D6167655365617263685F684269746D61704C6F6164000000D0030020000000BD30DF32FC32003304330833043C483C4C3C543CAC3CC43C00000000'
	Return $sHexData
EndFunc   ;==>__ImgSearch_GetEmbeddedDLL_x86
Func __ImgSearch_GetEmbeddedDLL_XP_x64()
	Local $sHexData = '0x4D5A90000300000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000F80000000E1FBA0E00B409CD21B8014CCD21546869732070726F6772616D2063616E6E6F742062652072756E20696E20444F53206D6F64652E0D0D0A240000000000000097C4F37AD3A59D29D3A59D29D3A59D2940EB0529D2A59D29BCD30329D2A59D29BCD33729D8A59D29BCD30129D7A59D29BCD33629D6A59D29DADD0E29DAA59D29D3A59C290DA59D29C8383229D2A59D29C8380629D2A59D29C8380729D2A59D29C8380029D2A59D2952696368D3A59D2900000000000000005045000064860300DBD907690000000000000000F00022200B020A0000D000000010000000B001009087020000C00100000000800100000000100000000200000500020000000000050002000000000000A00200000400000000000002004001000010000000000000100000000000000000100000000000001000000000000000000000100000008C950200A4010000E4930200A801000000900200E40300000020020070140000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000555058300000000000B00100001000000000000000040000000000008C57CE7500000000800000E0555058310000000000D0000000C0010000CC000000040000000000004C07D07500000000400000E02E7273726300000000100000009002000008000000D00000000000004CD7D0A100000000400000C000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000332E33300055505'
	$sHexData &= '8210D24080AFAF70555963CE914DC67020089C700000004020049040068D6FEE5FF488B0948FF255E650100CC40534883EC202AD904FFFDDAFF4908488D54243048C744080000FF15A74C85C074038943D6FE9EEF10B918235D48241F8B5310624C50D9B7FFFB4C8D05E16F268948088950104C891283C4205BC30BCEBE6D62BFC2BC0D9D570BD18BC8DAB33BD7D713CE2822481008F7B696668901345C240857A73368AFB4F2678BF98BDA2A017F8A755BFB66C564F6C30174091CCF1A07653FC7769E79A7A65C985F6A3161E4ADDDC3149362BF3E29E6153BDB36F762FFFF6E01D94E70F8025CF6C96225B61BC93B6301C200A3231BDEE292282785C97419BC76610EE1FD60F64C8B00BA14004641FF107E28A1ABF8BF0F816118FFF3FFFF81491E023DC1848C748B3F3FEF20DA003232F908833004055BB4C02B16C4B75556E6816F6D8BC1EC60246520FE82FF2C58100F29CA87BFF870D80F28F1BC33FF897818788C6EC5CDC96B44401688508C24D8CBC7EF7DF39D5F90C78424909202224533C017CE9466AD58084C643C6E9A7D69BA23EF63480484350C40415845EFFC916DB49D6D584889BC24C80CD05536743F8D57025328FEB35EE82A9B6EB01A15E95A29507E5FF0DBA6991DC50A48C87803FE125508694DC11667550096CECE4E26E7827F70D32BE804009A4C6503B3EFDF152FCB2EC72C4983C8B650011F986474FB8A1C527B180872051C03EB03836E6FC5FF4C66837C50FE2E7588FFCA5B5390300D5F18291A99AC43F3090AEE776F729C2488D222B47089E24AC30EFAC45F5E5D61D95BF04DBF8D99982B9B0E17C71D3D7784A49CDF780D3A7C370515ECCA33C48560CB2016979757E820406A5C340DFFEEEDEE28BA64ADC1E81E480C80B832193BCA0F42D13BD00FF7DDBED74FC2007A33CCE60136ECE078C343C78B28B52DDF8079F474DA4522C4EB06E210FAE6815BC53F3C0EF783F8027459B76FB6FB640A1646C45B448B1DF5F60C4585DB81B937C775336F203E12251C816CDDC18533A428093068FF60769EC7DDC705BD40D756BEDE1B5680CB505B483F2203EBBD75DB21109A33C911080804240FA27F416B5FE404894C1A89E00C2A017D1AC605A4F50DB0648201D110587733F8867304060CB81F7CC1EA1A8CAD7677778980E2018F8815667C7BFF3CFA3BFFC10A83F909775E6E51EA63C18B8C82BCE6D1DF1016D803CAFFE1F24361C30E7B4E469E9CBB33626B9BB96D4F4ED30B634F0F5BEFBDD75E6690FE15B4F60606C4EE0EE606DE38CFF33CD6CEC6BEBDBE00A17F30DC49894B081B4082B72D20285B100673208BFAAEDEC85EF6F133DB411C1B7E6A30167A32B2EB4F40498D4B8012935B609C6C2A134830645B30A5E9469E2B6A3041483B5D'
	$sHexData &= 'D35BB62E9369708962B890349F54E70CC09E14059CD88043753608159A99FC3C3BEF4EDBA88BD78261143C6F3324DDB60AEC1533513519A4D7D61B30607F9701698BC8C82DB7C64C8D6C861D04184D498B1C067328AF0339D0E30F9F18564D169D0F9A50020C7CE85EFD84AFC4402233F67439356D5E8974F0D10D1BD47427E2411807CF7110E0875D77404430ACC9FF7C668931383A61FB0AC50CE908089AC3B9B4B8DF471B197058EAC83D0218777C48587FA6750F6868BBC04C7C5766F2AFBB5CB0E048F7D16041FFEC0DEEEBDE5AFBFC7BEF3DF9160826DA0E480F430DD233D2AA2B2705660259184373B7EBA5608021041E3399173BB314DBEB215D08611D3CC0AD55DCF18CF30DD780313310701E44C40813112A5E5F4084ED93BD32415441554C86EC60C245C878F2C376396AA000A32AE745F8FCF7DF5452DEED44896DC0418D7507F44C396A10751DC905ED3F94184C896910663229F81571607C36DB87900A753875E86DE06DD0037FB019B9424DD0AF904D8BE539F717A074E08AD274400F1F8400013BB68705DF280645E820F80862CA265DD0AECD86FF0EDA420FB70C6170795A664224DE757CF76349FFC47F4C3BE272C832CD8F4841BA5CDD51B37B4C7A069266C245EADAA0E8A68E49C166830C2F5C25A67BEEC12A14485B916232790A4C81C1429EA6776F080537572F6128F87468207FD82928843A3E0F0A9B49EAEF07367860F908731C9CE04F8D44734718982A6E8F8E573ECD7BF8ECEB0B0A94890720D014E047A73D18B610064F1849EB049675F12EEDB5FED40A6AD07E2FC718F8FC012E56AD41F060415D415C3B45C522B19E53A14156FC275FA642AC6600D4B0285E4F5E9CFEA656E585A875BFB20BC38BE97CB8F11E42440FB6B52E9E04B8105E08B4205A503C64217E08CC9038EF65EB6501CEAE834DD89C04579913722A842BD8569F83BC3C9065AF5607655DDAC03DB4C804D080504503FE2C043968AF8C5F10743F8ED72678F7AEED34B65E47EB55785FAA1906B73A83BD901A8D788E3EB02F9CE8FB802CD15501E00BF93E50E086C35D418BD518BB4116BE8156A33E355B72486B3CD6366D871C465C9AE1BCF5C03C56F84F5583A13958DFC826085A7F0CFEAE441424F30F108D18163FF755E090E4115CD6900F0F303C3BB633C9D84CF087174F837D68A550155846B5680E4F048D90E78839562AE2C4415E335B6AE40353E740F280300DB2038ED501793FE3708F33E8F123F923281BBA22D57670C333C96042104DAC28104A18683D2D71005CF95F02C24F052F5040CE486BDB1FD8D89049E4218BF13BC872DFA6B863B46390531C87C954759D5472E484BC64637454CC62B9071C08B88601ADFCC0E414D0CE4001078C205FACE3A2D0AF8FD'
	$sHexData &= '35B5C66577914F48EBA1F247E3BA48DB0C6364A8875F958BC0836BC2422E40E25951599E1BA7156D7F71D10638331B1C7818F31A84E70E393801AD54C300F40DB1C198AA9CB38ADF068E125AE2E87A0DAD7FC26ACD8FE837910000F84FE11449E351816FE266C15B6F61F5C284532ED44886C245AFC394E2A743933FFDE5C63BCC6FF83D3E26BD26449D43352DDEEB8FF77133D802C740CFFC783FF037CD9702041B5012A8EDCFF7B4584ED7505E9A9C910504E5F38470CBC15523CE10AECED1059E6FF7606C8EBC396E658DC885C8450F00B175C8F4CA424682283FC07AEC23E36C63E6066007F9A79E171B98926305A26400EBDE8F2B0C93E3407663902B8AA69DBED83C202ACC9EBE6B3932B5E47ED2BB0D1DE7CFF6169D2CF193CF70AEE9424784A6D98BC19292B64EE5CDC907F23B0974A8FED29510133112B7868FBC06B9B54EB1B93C7DCAC1958B850F061EF023C0F9CC9F9E638AE154541B6D3E04ECBA00DE1742ACFF0C85F47BF0EF4F527C823E2241A0D9E761636AC90E5E85D72609AC720ABAE60483BE4D7F472A9CCEB8B05E6508C83723958DAA08BCC680F70E0F39D4A328153EB0B8EE3C743B0F6948C00740EC8D1FDD1870965604F9ABAA07A11E05CF075C34031A6495F5630695CC482DBFCE0B9A88B7C244087582E8EB8BF959550E65F843A258D8F600C62C9AF2D994D8B051750D9ACD099CC04A8E0305FB350A5062B2D7E0370D9A16D726C300670180810DEA0613A25A29913541688F1AC1B10D44D4ECEF4BBE91E08E53C4F280DD1E9263BC1743B7D7F3B2650183901034C2EB9E9937807F10EF813A628EB0AF4907C7DDB766B533F5EF974620E5F40101DA94E7448054B75A0184B960311A04957CAACE08941087C284E4F6C7B374B10F6F951C128A5F5D48F908943206641CB34DE2C780478FF0D67E93320E86EA65C1F0E58F963E76D4DEFE35181BDAB385513BE1C501569EE5C9C168E4E23E40CAF481F9F25852B814C8D23991A0DB8707F200939C213FE220029867CB8B020C4ADDC04C9CA070737B4C0E6F24C839C404E76E85EE85C2D9ACA255C1BD96915A6BDFD87436A408B41388907083C8947040A40DC69689A08440C204410BEAF70671E96A63943406F32321F1A6C7B407750D1ED57E30920EC240838958D1E1763C357108FEA8B47385F699EE6690C3C64406844C50DBEED6C925B40C2C8E78BD8744DC75391E4541550C26BEFDDE5C86BFC4F8594A2760D6194038A181638A6FBE60A0D08BAE1EC4CB99124499204B8182BDB044E15562BCA8E01730E6DEDA97CD2E65AC8CC98C2C015352EDBFFD640BB40084C8918B41D1B1BC91DCD2913A58C18250B6556BEC17212940BE5154BBA4FE55BBEEB0F20FAE40432C05570ACD4C5BA15FD64'
	$sHexData &= '80004D84AB851E55E27E682FAA978FA16CC045BF3177DA57F0B840653768C8E1DCF1E48E978BBD4A68498BCC45AF1C4F19F96642E61D37673EECC6E52AE606FAAFEBF24DA71597D3F112A76117520724389AA669157C040A3C08400CE481FC68444E02E61A3BB4D5F87145DF4DF6E4D76606C7C7E37870494DC74745EF451D7BECB145F34345F74145FB3F03F208E4A8E5F54D735E5E8E3C73DC4D65E556E5930C1D4F45C73DB80D2B479ACA37E5C1F8C758A94A61C76D2EC10D16402C5B08C8B0BCA38C433DFCE4E75790E1EF3D7DDF080F8223E0E91093E79087352C170FFFF26179686ED42AFFD44527E499B2B2452B452F46C8979003C9417CFF78E4210F799908EA4957E42E1CFC3C833D44640F864615C405D17B80442729DBC2312A42D192109F9BFBBC4D5893E455C71AAFE2DC6AAED84A0E94457DB77EDF7456F70A7C239E80784900759848108079127C6A39801E76B0173297F769437E1F74F4EB204E0813BCFB7D6F7E4110750D3B492574ED193BC775ADA46D577E426EE3180F85EA193B10F89CCC73FB8B5808B8FB807B54B98883DBE3BEEF0D356044CD6533F251043F803018B44BEF2ECFC93028189B318BDF807F9ECBEB7BF4BAE4FBE2332A14F0B355E45D0028E62EC014E852D0E0EB65ED6006D349333DF5E16410011ACC5617977790E433E425460818D92D050FFFEE5844D623A88CF547ED453A81A783F3B6BE75A0F085DD4C5E20A79246CE4AB54A7669D05D3E9CEEDFC72E7D557E9C9D3C25E28718FCCDEC4A1ED610E21767FF692FADFC38EA02E00C4625E1596342374DED5208D334522830FE5D79548D0134507E90DF649A6D744568F8ABE1492BCC30DC82493BDBC41F4DC53FE2E8105185FF74415A291247A000A7487C2C07D103A8C20352247C620F5EA15A9C97C4496337B2080610BE8397ED42C2B04949E1BDBE75A9F75C5EFCD24D891BC234E108311431CDAE103C220CD2FF3BCB0BE4C19F64494B4974CF646E803DE1E092B630107288CC4067505F0DE0C80BE4050449EB4839C8434ED3DFC8DFBEDFDFCA170FBBDF5B2CDE5E44191F3B715AB8DE87038B63287E21C98944B4085367A779509D8BD940EE0F4170320C8601CCE90B4F09275C62364203B562EC1E5C493963C3CD5BC31FA834C8AB80D368766C9ECF46526EDDC843CFE95CF264409ED4DECFBCDEE428C4501EE2539E1568D0B91099381358798006BC872C6608403618C10107DA176918465C9A08E704DF8C9618083915812291AF2C47950DF1021347D1B4DEA5F1ADBC92DEE61C54550105F279200BD085DEFD51DF4383F2420E64DE4ADE91C7CA7731B7D0186E0DDC3F422FAA460E3138F45840C8771A62435CC3DDE3DBFF425649332ED34068836E6C04BFB42014782F048'
	$sHexData &= '7D91B4C1E468D210C1E691E20431866568CD38855DF5E569FCD1DC7C5406B1868204AD1FA19CD2178EAC535DBE4C993077A8F41E95C9BDC3A46C80383DC0AE434C2D7818073F040D49A13E86BED05AA1C1CA5EEDC47F324A73A0B26454C8963B2B2815A440818A30C45ADDC6B608D03B89C1BED6867408BDA3D642460680A503B1EDF219AC750411D63831B83392107924843DCBB4F39240F599D4122DC08DC23BF3039CEC2FADB22EC022AB7A44405E5DB705E56187812DE085FE6FC09C2131A5E709E388454C22483F46D491A336CC264E065257F209B212E6FACBEDA475D72E4217C217C5DD8720AA451DF1F7DDA7088E2047443635A4339C8E6B881B942DA37DA1992BF3C2DDA4C89252ADA484106640032245870E188179E7F29FA0BE35F815E10DE5CD37C82FD85DB743AD46943033EF1A2C0CB7F8F426E23E25EE00EBE08067B7B26A9A243161014DA5AC16C8543C845422B42CDCCD979DF77DBFFCB361DC2D9C1B30CEB0732B2E5D1865883FB1D205F2271D727075869A33D222E685075A12D55AEDF1478FB75D4F9CB8030498B6B38FA06A410B9BF04507040E808DC08AC2488D1E2CFE575E15EFFC278E4FE584DB9C0FE7CA2FF0381E300FC683E0512D87CF4B7C3E806C840387841751D1F4C3916EFC5021073061810EB0AC86EEF007AED3974E87F7880740D4C3B071F1BE15918721F78EB0E84510F34C48248611FD892606BD0C3243EA028DA201BD37E5A143CE0AD28A12C90386BE3150FF06B20741E4DE06FD740D004CFDBBB7DE006E8F0CE82E00E6BF0728C37693C61D489A3DC0F18DDCD44AA897E0806E41A3BA19330C0F074825F06094E7766F146081138A0C4230C784C16F02E9DCAF7758F68DCEB23BED7D60902EECBADA5D533D02A10E9B0A2CB8BB050C2AB62281F57198BD978791BE4B5F52662C275CF3BBE40F6F166D3BAEEC1F8024805702C8B2D294825276F7702280B9231D65E0DC1FA059FDA94175467D6043BC0E8486A5AD0B6283A482034F99E03D16441844C32045F41412D4732C9414141A051B8FFC2759E486305B6CEF62683E90E2FE17C5502E409309BB2DF5038D9C374224C317777884E0FE1A3431318650106173054A8209CD58395B6EABC1CD5864CC8737646F839107D18CA773B4258680A0EBCF93C4308EF6A47F30BD6E70C033B5DE260735C7974096867F8D79FEB2C1B6DB12C6557CB5B0A4E858FB00888D6EE16F922AB0E15083A3B144F3E0B5329D6AED439FB3AB10B8BEA19BF9C58C883EF3DA7F8C7B722DA114C6CB9E82C4D2BC249F8BBC2F446E02E0F42C80C760D33D201ABDAE60E70F7F146C83E41B9FD25A058F43CFE1C4A8D148DB0E27FC71A488D42038038FF720E49036E03C2B05AFF25E6F032C0C3B001C3BF14'
	$sHexData &= '5E34214141728D6C24C004ACD621F145B0D7224C56EA506AC1C8D670246C83F2AA2446D4C2F62B9FCDB194553FD4F9382AD4DB011F2E2F0E78015F758006F9009FC088851F36D30DF25858383E8CF6D3F7DD8003F72D898E929A08A099A72D18D0E02E0C60239667CC20DEAE3C6E615E5E2C45207518F45645D7C021887CCC3AD220DC4D37ED894E200A24240FB666884E289F469EE2AFA3A26CC64640A2F8E05828C3695C46F830A7065A9D8B35423D59E8850FC43B89A2371703C433ACFE628D05A4472432FA74FB80A5202ED12A1D68FE6B45D8412CED483E08EB084D8BEE44F32FE849584E6DB84D85ED75104102DB9D03159E370EDF94418B5E4589D21C81672EC6205D3896497810AC492E3D0F2B6FB696FF105744DC34344911A974EE9DDD6E04E73738388FB02F19614C636464CE488A33DE1544E40F8E94853E5CBB6AE167174181FC007DB68F1981FB968C7469179D409212FF3F04140FBAE012720C3D0A202600C6D035E81EEA75050D01D760D36810A8121A146C5490790B9DC8BB56514185813232D2A9600D18DF457FC504668C5E248BC3410FAF126314373F84F8DBC022EC909F1E6FB27BA1DC162ABB913A8F1B71C08A46062B06C496732AC8E5AC52EC90E3633B043156E042C2ED3A61533CC370452FD9458CFE45984AD80E076F2C7DA038F621DC176810DBE250BBFF88C2F994DA8425E90A0E1DDDC5F666759F3372FC040F8C842EADF028ACDA7E5D014D8D5F0822C4FCB0EC02FDAAACDE5E468D34A56B7A3C0F41BFFE8E54C2939F384BF88BD1C1EA188137ED9BC2C941C1E9100CC1E80884D26C6F67FFB42BA1413AD7118BC2646EC00F5B0428D46D6B1216005ED02CC1231C59699EF7B7C20658C3F3440F2CC82EC0C8C9DC6A95E7CACBC15D5A55BBFB7758C979054532C9EB0F9F453BCF0C4FBC3497CA331430C0C0C0C71779EF9DC060045E0D5C415A769BBBEFC1E2081E0BD00E5D11238D43AEBBE00406CA0689144E2A1F08EC8B43FC0672D8458BC8416F7982CD0C0A0845D92C89451041E00E5605DB7CD02A2B7968A1D72AC934C09E81040574D2D752CA6015340B78D745CF9D5841C18AF92ED2C50629702BE711CECB039027AF08CD2D702D70035231A0A20104C8935704D52E5B2E5BEC875C500283C3044906ABEB42BBA2FFCC462A768B4278D9EB3D800840F55FFFCB794B493BFC0F8DA0B3478D5435CAFE0879BC0CBF2F7C80FAFF11D5958BA2BD0E443BCBBA9DA61B48C32FC0C350F5CE55B90B57B5B049337C4963CA3541FCFFC7C01F1E60EF0ABB154C03F8E02097768144031C7F990F06F84841BEE37F9C3CE451A030586BAD35807C81BFC00EDA74114B26CC84C04EC637ECA9750396C6884628B9FEB5F784D960D433D4681BB8302C7'
	$sHexData &= '401B7047008063E4021BC7DEB75660E280001EB03BADE8B4620E65D304D140A245046288843215EF8F2D6488BCB432900583176AAC2E6E01EAC3328372703072E2CB9FF33CB35093FA94D30BD90A76E129E405FC15D5F10578947555365A80F949578666898022030FF07B115196CA806789892C65FC2640CBF0E4D8BE9E26B6CBA4440FAE0443C8BF2897F04C51B53F98B492098B03E578B47247F6BC80C4815E817044F084D2BCA49C166BAC5FFF9020FAFC148984C3BC820369647B75D386C455981FA4D164181F844851369194014DE82DBFF051064761F48B815AE47E17A140849F7E11AC5502CC6C14CA4D1E8FAB0E815CE508C0682B863D64D7407225C7C3F4E8D1C8539FF0A81F2FB8FFAC1B979379EDCC1E0064803C813E8021171C7BF33D94903D04D03D3B8D172D50C38239E4D4098FCF48220E7B7B0838364D1CF76DA76C84B3017175CC155D23C72B966208B57200464D3961C823424E92F87B401196FD632CF4DACB48225A4D434B48D9550DA1758F96F9A4C90208D8C2233C48977E24DC6B8316E8A0C8D41884D8E718C1F3DC83D41C64590BDB6A7D001C99E81BC8D31E133DC3340852D47B5C4AC194F164CB5E38D34102F05CF177E2F28C67766033E5930049CC8BFBDD031CECCC9EB388D95386FEB1CA1785AC741B6066620E4E24413D9EE906C5C4D5D082F52E984C81D041A54C8933326030279462A78DF2BC95919CB9C90B3A87914F2B330702EE903A8C49FBF75D833C98BD9423DCC4E3FDF460E3533394F24173587B4C00B1AD6F1886DD041BC5613B58E4D08BE63DEBEDE24D1ED356C01D1A66F2AC3417CEF078BCD2BF002B88BCAC1E978C241C1E8CABE01B102860884C3353D413ACC672820CA11EC79D79C8308158EC2B5C6C239900A74C1CE2942642AB9C690D24589D6FCC2413BD4C412D0616F5725DCCC2F61C431C0C1CC3077DFE108820BC80E6511C05004053AE40B74AA04C30AB8F42C441A7C346D7E8AF0FB43FF00F53B5F241F5C44C6307309CD055A40C8C7FE1F2B368B2F93BC45F82E7D109275F4E88C973A90335F589758C3691DB71C9734E0ECB426407C420ECF88916481BA5DB5F8745775985540217CBFC686A77A3C8BD84C3A404C6EEF7DDDF0BA079330B1F9F6D8BA020A3225C325BE531360072A54F85C2808385E47830206C90C8742EFE37BF95122745519F59490FD27908F9E2B9053212F092E1D5D6920E08557B3708F9C0C4122340B2894A4410DBAF7780B7C60A892074FADAA18DD2E90833CE4689E2E942E554C25277C2D45562083B6E7AB0665CE4745068BC7ED6B831EE1D8FB18ED70231FB4FDED181AC2835C629908B260EF46FAA0F9C37365A843EC2DA347A4527912B248E8632A3941F0DC2D6FC42CA453E84553'
	$sHexData &= 'CD657D800D85C84EC33D815838BC82AB8F1DE575B08288FEB8A82D9360A1DC65DF42E0162A721330C8FF471205BFF93C4D418D5B5E08498D77FC8AEED0C7C41734C6448D24B5653CB5872A74A3477E3F3941036492233941D739402690C6CEC61243A420B6286840C190D6FC1241DBC12DA7C69F3A2B10DF22A46050DCD172A9BCC6D1C0C2C788608D009ED9507048C1D2CB0BD101853C393B143B142838908AAA0104D982429E1C3C013C01E72994E4024D48FFCE740DACD4387C9280449B7FA1BB2C4B46493BFF3E3D57478D14845C68A1236246BE8BA2CA3E3D1F3AD30FC336248842452F0F1D708547FF0B5F1BECB051F84C03F64403B844893FFFCB0AAF50076DB845383C1C0A38C131FFCB062853C8FE233C8B4DA00F45C8890A174813768C952633FFA6178C60859EB73C7808061020131632006EF41014173A58E80C1644451849231C63C98BD5E31E0F2CB4195720B0803CE4C959278F278327030501796B2614BD8C173AF2ADBD3331628D680BC7501A2776800BAD809A800EBC850A80A5B14279B152D95C4CBFD9E000DF5FA8877120A5E20C05F4BC67F33C01A2ED53EDBC04B4CBCAA721D8BC2D76A74DC0CAFFA16DAF4C896DB755A79EE6BE413E9FBBE826A6BCA78B391869157104E7BAE25F19D718E1E7F2B1462DBA8CBF0926EB8975778B5DEFC28EB74267E623D20F81FE9716E74C4092FB2F2A26022E2E81F0C3A02BEF77F06C1A963006387FE27F33D2DD34334FC018261846243A46634DEC0417F54C12E2C1D0782A88151BF0DCC19BE04645896E1034851F8C8F0A49235E3497895D9B1ABFBACAE65D2A8F498B4ECF2509C9E9A29181EC724C334E6A558A2F68809FC4FB480FAFFE028AE1909191F7F505761B70BF5E0453881FC0AF07C1CC43E1C820073924977F002E3C35D43145E7F1558CE6458BF5C7BA7F9ACF41E6000A02872D30B903B0CBD235C60E224883FE71A1295F44BE418D5E22C6DB800348C92C1FA0428E3C41B141B1A30E6043C4042421852078CB429A1041DD48C1086E7FDAD0220C0846A95B60D101AC2127AF088ED103CF4382435231A09082A6019357040704D7446E985C50C8446E025D680E5DD940EC87C49FFCCBF5854CE15E3F483BFE7400CD2FE045C32E1F4021470E458C458C0CBEB0612FD9EF1E80C30308CB131F790EE00D3A440375771B3041BD47812F3C40AECA387D9FA5BFC0901F1D26CC418834A6D2CD9A1806BA01C31018EC002AAE14C80D2BC8CB03208AF620E00055C4525A5E08C5CD826290A938264E51CFDBBC37C9492B11202040040E240882F8F33C280C2C48B86725A4149E1B48F7EA740224D60B80523F4803D0FA840784912DA8BD2CA5C947498CDB38E154502B7D1F8BD9A8D20756928DB3E6FAAE19D'
	$sHexData &= 'B5BD85BBB05B5EBF6B40C2829BAF63BD84C40EC138D38F752D871640F8633D25A05DE2A2BDB9F0D4C381EDB7E7A4C6ECDB40DBE340529384BA2C8C92DFC841456E93BDA7F474DAD142C50D24218040A63D06DDCAEB8C80492437E8189070A4481046D549A4E200F08080C74506F6D29C718844587770DBE7CCBB215AD322FFC8581837A33FF48A431A2D926104818774668828AF844ECB0E761959AB7F104E8448BFAF1B87E415B05BCD8935041F146FE741B3087D708348050E258C454AECED02AFC5C412BFD2BCBB2496548A3BB59D03CEB04CA1C8D4B01295B38FE67DAAA3430308BCB8BFB83FDFF98F5EE5F253405418D6C3D0083FE1BF675038D7D95691B243BF52654F04CF58D42FF7A6B9B17F4F0458BEE4FE812FB0C4CFB03CBD65A814BC012DF1CF828D854AC3D40F345013BE8E8E43BEA20EA5C6D7B81DD18F03BF112802BED2BF3C47E63B07EF5233EE25F81FDAA7F57D37F4F8E0EA49BA615631CFBAE3F50E9F682432A1721F0238D4E1B5D4EC68BD5D22A1C8EBBB407A730F88D9D2817D48D10C7C4A70433C086604455C271797384E3CFA86D4B7CC3B94C91B91B54B94D3EA54AEB07E81AAB4ED0D8384DA5D2189E4FF891EFDA192520AB484110F6EE1130DB0491FFAC0F314ACD88F7F08B78E918A49884562F7E4C9816D42000CC00E038442012A33D30ECCD9262124AAD659D000E981105D47C9E16D1CE4316DC35171A1A14CA311634AD19831E24300E2ECF2989EECBE2AB14C70F1235F038A85F569412699B6743D264D945884BF610C9587423100E8B7220D20406F5C6B80846043BC1D22A5AA2ECDF01BC602C0B413B4324293EB0815A1EBF4E59684C79EB237483A4704C71C066E20CA6AEEB3FED820D1F75367E3538B881800069532536B9C921CA03D17820D46FA6265307D2D01FCE1AC42BC27973A4007E690A4121001CD6D0C80D469ADFD1BBF013C74B4E124D8B13FD34BD09B80FAFF1E4CB4503F072544928A8D74C08101AFE370047FF98C48D2C824963C64D8D1C82B351F535B74BB2CEEB5F044B68D17C142BFCB084AD7D0D0B18EE7C5A1413AEB6CA24076E5FC4442BC80FB72EEA1066E87E0B6CEFB01A411DE045C1419DC33DF0582B590341F7A90FD8DFED267B1C021A10CF7F6108C77F5C1058FF86D03F80C37C3BDE7C88050A364F838B638B8B4403BE041F68839B76C703C67C60F9164B87C702AE0C7AD414030C99D5438BCE48AB1222FCEB6073CC78385E5BC314C85471B3D70619CCDF580E204F1E4EEC4EEC4EECAA1C28561C24DD4EEC78223AA85AD298F1A4E0FDB4B0EFE950AC24901B2038CCBC34400F297408038F1B7445506F3DC5740FBFC7186C8F850A4CD4CC10EFED8EDBE62DDB1061F60670F6003B890320724EE8DAF1C3'
	$sHexData &= '631C2B1D3761ED2103C7583FC90482C0D2DAC7AE00DC038D4DF63F2ED216EC71FBFEDDF3066495005122662C6EDCB640EFF626C40672D018F0DB1A66D806DEB679FBD7C33DFFFF627462F3410C9020DBE74CD47BB6E76D68E516CFC10660C5D52669DF3DDBCD06F9D0E12E26F9C21EEE69CF73F265D6C4E0E68663E24F00F7DFDAC1C54EB44183C2048F4584A3ACC15EB83BC655453FA2634D4C66D66E4E8849CE8832C82345BEE8448B1CC36602797459BDCBC365209992EBCB4483D1104F3F3B90BE12B6A20CDB7C87EE248BF9B321D1C114FD3BFB7D43F9E97A2C7A7A984A23D148709128E648F454284CF9E548B9FC798EEA7858B001EBCA588A58B734BFFCA7B2B9A1F9D800970F29B424C000B4249EACF0A0DF44986D4D28B7C80C04E936859781C7D9DE443087148D9FF0B512BA2A728F5AF74D418D1544980F40D2604FDBE93BD620413940205351E51824247A97F12344383D59AB780D458D47BD99B84302157C1AC60D41B8060A9145D4A8167D1A3D6D23EC28F99C8A3B47748866885EDC2640B58F4C12757F5F39705D44EA77D62E576A05DF4950A38B457728CF76C31364F6F711FC44883A803DE1AAB4EEDEECC2AF844C0CEB05344A1C708B4F24BD15FC261203C3B89F786F4103C71442B7BF10A38975A7894DABE01175AFD4CF43683483C7B71355A141BAA0876EB79F2E0D89BB69BE1BCFB79574EB104E14F280BD87FBFD3310A02FE461E4202BC63BD81E3C043BB34FECD81CD92B753BBC60545557E934C0386F27F8750006081F026FD488343BE8742B9DD91CF922FE1B52384D895D009E40B4C55DC4B11042A2FF67A8F530B440003EF67FD40372A5520F483BF774319EFE9151895E0E3B99E8FF15781341F84178036D7BF844556BB4667BE87E7C53F45E67DD9ED775D379524AE98714282D03B3BC4C524D0C32C9F34D4D1B4D19D6E2118F5D10B7F102342896ECF6734852491039D26021BF1F0CE812C0CC1798562348894B06A7BDF0B92143C675344CC164DA79DBEB2AC07D000608FD14AD8B96963B26C52EDFC86B9D566B005AD80041A6DA489F30A41919F918FF154E12302818D786182B5C98289E0639217D9D58D64870A61E54CA62C10C1258EA43C354A074B87CC2F061B5DFB2669048C6115F4B467CB1C63C2804480F44BB59DAA0FB6076360A4C2BCE4B78C43A723098BC65BF2C333FD2CBB94830FF158211D5768321800A5E8D770110E39203E8F37298E45860D8298C2ED7FFCFCA8153FDA8F72009852C84C0ADC8E2E53E9F6D530AB8A84408409848889078EAC891EF3A0E9868A058A848E8E1E443F35C9C90D44CDC3BE103DF898DEA0CA0BC42386A6899642E0D3E595BD1DEF2B0686FA79D33FD7DB66B6B1638750C15571685D2750F300'
	$sHexData &= '0FF60520CC70544A723CF493BDF454B277A815D7D148C5C2E376939AA20EAF727EBF7BD28020D3002AC7C6E26159537706CA66E1198DF24CDCE2C2D9FBF0BDED95924E8501C9A941A4A1E3A1446304B0435717F0AA65E9041BE08787A712EB3D964C53845202BA5BFA56CBC8B3BF01B3B2FB39D5D0D204F38FB0C38A79DBFCB53858789BDA80AB04D2B3501AA488C40A42CC4105D68B91EFA4FC14B5D2A349EA47C9A54BE9D9DBD2C102DCA2A521115BD0E2FE8771041B9AFF9DF0AC27606450F28EAEB0444E85B583795EE09F12BD572427737D04DBB9D27DB5CF3900579256C3EC1770F4A67D76EDACC6241C4EB0308C1390D4B0B75F97B66591B05A92058242CC02EB1DDB666226ED8BE5BDBF3085ED918707F9D8625232C80069066C7454156011D460180E80379FBC2CAE003D0030CFF04E7897DBC0F4D6BAFB86C6C0CA004FCF80C0081CDFB0BAB5ACF16207E3A43ED0E5DB6608BC89916707D2BB0F6B6F465640C68412BFF466C0A6655A34D837E23F8810E3801EB3883FEEE38750A26328BC7EB34AB630ECB3BC8590DB01A55DF34E8E5E0B94E470EAD3A18458D0BFE9ED2043FD3418D1C04895DA022552006CC8247043445041045AFA02AECBA4D18526C3E83F9DAEBFCDAFF75467C568B5D1C7226FB7E7B776A7629A0EB6F56104E751241394D14C5FAF9991C0A1875061C74559E7C83481FB40DC24080F93BC87A0AA5A974B3462ACC7C0CC428E1A0DD88C3E01C5EC77E0908C06FC43BD8277E05352C1C8C7E0B3BC3773BBCD97F07D703FC44B80665B88B44D0B4BF5A902BCF894DFC8BCB0ECCF845DA4A8CC434591810E3A5606D48B8D0CB04C454C496D0416547BC3FF81787C23CBD033E8C0FB6F8856FD8509153083C4084FF741E0BD108C377197CDCBD67D58B2C9D6263783A09E0E57BFDF82B7DB0BAFDA4407006063C082CA73B2A1EE3019E6E277088060D4C6C64B77C577C4183E0007E49C486126305711AADB3F7098F0F692F797512556436EBB111A9AB355AB77D30F9CC3BBD6409FAE803B4A2D3758B50E6876B29102DF48B0D06A8D87840387D99483BFE9EC6751AA48D229DA69B107837339F8C45836C3E2436759C1E08FC870C242398B098E121262F480B8A5A4786E101F23E6611D708073D749774491D0E4153BD4833B087E31035D4A269CD5872B8606C3686216D400E84D3A06C632F1DC852558E37729043C51E106D3408FA0F0F0079142F0AE80980591A201C88A02A353F5DEA555A180E6C01F55CB032D4B1E5962E16B1973CC8CC642F0E200518B3B5769705080C6113DAD327778D2F7B90EB23E4C10B70272CF6400F94C7DC2005F12DABDE37144009DF8890337DD9A8C905FBBAFEDFF805C8CA43AE10F805F408503C400E160F870671E4'
	$sHexData &= '2087E4050F7B06410E1E00F22876082F08616131405F4CC3A100ABEB67860485E40A3972FB200638E480AC3C2006B107D30D2139C8034405C20D3C0A39C83805FE0C33072F900780EC064D384E766C7442FF5EF3D45E03FA231A4846D0E86DC801F9704C4E8906AB0C437290071C049A0C107914729004D60B0B061A200F00C4051D544EB8795F6A5960D031219B203102C0A9C8871B32D84C585C05833C400E7E0BEF026D90831C920BE302A90A7900C8A3DE0497049B20C10040B8F675033C3FFB1645396514120A18750A1CA1F33B327E6243448B4590A9194D94899DB248C96E16AFC0C0BA94ACD7182B768786C4E8B3C1E640A8560147FC79048BF7EB09B6D44FF04453D9DE627D1485FF2833FF41F8F1FF5060D80CA844183BD67E05413BD07E95CA5BA14ED01E4D1C3BCFC9C9F7D976C43BF24CA03BF90F4C89652006D411FF9F2830C64549012BD6895540C41F9A826F3645988845482CCAD1BA8002433B492F22EC6B4520F386225D2C3DFC202584033A2329309BDD4CFA1ADA1A614528574530A853AC495B3CA83765C556941ABDB61F00193284D68256274510AF451A128E823DAED41D2A63C337AE395D447E588275A87F865F0390A833549003C68D824AEDC0E43C887C63A0E2C183612E8F1C8D0C8676194A3828E002F0A0EDB7A301416EFFC33B9C7CC039012EAAD1ACA84820EB7E52E14ECA010075DE4428EF249D3880222883F7C958F84E4D802030C0CDD594BD801E301474908B45947F811A054CFE747B267C41B8076A03F913C9C4087EB5D1CED1461692902B74767E940B211DF75B1438C138F037040E0692DB7506DC2A383A320822B07504143A23EF1E20BDA0A80CA8B0215285452475659A70A0A3B95496685844C405DC5461E43C25588B9519CA292FAFBCA000C01C891ADC626BA963B770436C7940FEC27BE923A7737CB95CD23C737C48403007816002301BB137B9C06327527C32482D09C09D8E9EEFB01348AEE249EE8567BCF970D9046DD0F0FDF80D5887D6F40D354C020F9DC396C004B44A437779C860045804480CE98A77A8BCC5845CC40F14445AC8F2B645221492ABFC1A54CA165AC1EF23BD1604D31B20D8762156C2186AB72547D136DAFCEBC3BD8E680177050DCEF78EA8492BC8A4A55621BB8A203C05A800B28D36F8F869C8BE707F6DB480DE03E31B1C207DD05A45D806E88A8302915CA8018A00C86700508418C8400F6CF7E9F68146AEF1EB111404B649806F89AD12C0252247EF16D66C7244E81816EC15D40D9EB365C65FDC2B2102BA53F4005F9806C8B801B049F85AF02E6033A19CE2E0BE3B75707345C9F24D14C13823933C94F8F0E003E07E03358D1503F27E719A169510CE02EB376A88F2E88C4C807044020450236FF27'
	$sHexData &= '004707004E3C824CFC7761008F803B2F97FEE6B0D68C46C9041F6C6047439E6FB7D06B9D0720404AAFE3CBF10C1640F7C027420FD9CCB2183F8E06B6A405165DA4C6EA05CEA9D00B4820C881038C9DB416C5AEF69AABC389DDFCDBD3830BD9C8D20041C398D0842A1B2DF4D68A245394D64138E117438180492ECE6EED7044D8BE44DA44885BB95A9B7ACAC822E10070A9C9F278F8C83E9FE280710B01B019507FD3539B530DDAD0818F9A4413975A4625004581AC04A6D4A36FACC455CB0F771DA3EA1134C7F4E8B4CDB3B0CAEF6BC0F8C4564543B7DB817FC5669C755E81A323B820F8F1F4DEC9B43C8DE393B45A01DEA04CF45BED1C1CD2BCCC70F88D36A1141D6BC48D34E109018099487A33418F045A4FE0599F00B5E055B4A1C236989B5A00246A7624856A4B80EA7F904EE11ECAC8DDA61F2E2A5B004BFD00868C8E359938F3FB5B85DF20021BA77B8530B042EAE0085B45BFCD02CBC9743B86CFC0A45AD04ACDA7C4550F27F85423F0DEEAEAE480A78198D157C84DB75C141DAC740E91E8A60B450025F605A4183F4C062585D83CEE943A0167C0211ECEB614906703E7883788D85489CE3ED78D52316486340881E864105CE653085148039362064DEB32974806A59A8A34EF50ABA8FFC76BD194CA0B00C49546159259C75164A95C3BFBE6094F5011D1CE26400745B00CAA5D5CE30125168609358B71266FFF754DA767BEBC1A440001895E8F748C8CB0F18851C0110014CC1D306BC1D0E8C9029D96E6A640FF338046C8A02B8A37B4FCE3CE923F2C02AC180D1368AC948F715305D924C0AFD450F2FD563DDFA567B6A7066901CC7231104BE0F84FE0F5BF61E5EF16DC2D9B860A842C873379A026C9E11D0772E7DA8FEFAFF1B0C3613FAA47511FC21DB0C8F307B4A5A06E0182FB177C5FE8B04BA8901EB20450CC031211818B881DE4B13F5815A29D62FD71A69CC155EA0E0667CF9F02BC2DFF8065EA0854932FF2044831DC434BA66A69A29107CB7C691BC28C980055179CEC8114D6105B895184511AB8157A4B510441294F6FD74E40D800CC8D00035E000E7F8CC980166724E08015251E5079CA56D8230DCDF219CE26BE71259851A85E4EE42442AC08B85BB2C857005AA8585934094148D887774743FE4A22C9B7B604C8B856054603D23684D7E141DDBA65075EA743B67B9A1B04482BB5F493F7EC9171A48FFC73BF87322D46A8CC668B16275D9D2BCB3533639040643F51359F829A0A500D7A8C41979D062783480001B150E9637168AF03BDB0CA9BCAB43C9D91C104811CE3B46A207DD055A118E96E1A2F155C70206EE0439C474AA1ED48A0A6B546CC8DEB2C0AD582142A1F412B7BBC20AAF30EB3BEAE4807ADCD89F290E3BD7740D732FDF43660DB9147566'
	$sHexData &= '7CF7FFFF11BDD081C666A8137D79902C98F1E98C648E40F7415E302817DAF300CF4FC0F0F65082F30044BFBCEC103AF69DF89DF0FB064963575355C0454C34074C480F47037E70004CDD6F4A0403DE9E4BD098F7316EB81CEA06543F7783C7A2EE13ED91CF458809FD00E0028B4FF4DE67A0E3DF80F824500175148B47FC9966D1C806F8BB80C88B07114403E03A5FE403606972145036FB00F992610FF9F3351B8B57FCB40139A4DE001732C49AACC1E1FA3EBEF3301BB001DB6E0FBA60075203272DA746DC405AC84DFCBBFA00A5813DD65F67BD35FC35D7BE106466AD33179A787A8ECE540ED0D87690B46CB21946680317B44C0124E4FBEB13F6E3FB0A5181C301727756CB7E389F27225E022C5C24CAA805F23C91260A24CD80F0F7B24DF8AC05CC35C90C803D368B8085BC3FA80F45F0DE13490EC13B5383F2D7E9FA52802507F472329535AD5D81FD3C3B16909A813DA48E4BC9F93594306CDADA43EEFBA73670FCF1D2B42583B234C0F921CD811C77B4DEC73E6AC93C41C26D00F1907620A434A7CDFA4B0E3644AFAF33D3815CF2B59167498BD45F19085EC3D68925FA05BC9A813DA42446F835B80957C092432B31D20E64D8EDF06D0FA034D2216D401EF4F7FC6AB738A41DC835F8349C6A055F01AB5D9F80F0473E261F1ABA98E74F8A742AAC918298DB481CF25CE5899D909D4162C0A8913719B95FC05EB82A9FCA91A850071138072F2D4ED77DEB02B0E89850370AB462CFD201EB69300A72604F96F59CCB15497B9D9D5C2EC20EBF65A0DAE4A159079065ABF100FEF359B792619D807D9900741763D6E6A13139740B611E450EAC90EE70D242EE65292DB3C1A65789848FFA9D5C845D8053A0B2BD5D57176220EFC76F8DFC4FC6B8FF15BAED00FBEFCA2057C8486048F44A9EE4E4F00006F70077EE1C1B92C3ADF5F66B3731680874EBEFA3150130B85914099B06E6868326F39CC0EC03C9C820FDE80007E4659007E8EAEF0CF6C9411E207DEDFBF516058F0D713737F5F341F2400ED96CEF43701C80D881015500EE90EC16AB0109BC098E81DF63626B291C4AE8E9BF1DA8BC2009508873F0087BE045F3F97C3643D04BC053B05BA06305C6E763906B80AF032B032B7E9E22B0902B9660DD27836CECF17958F9BAF7418DC0954EC54BC86F8BCF1B5139E48B78483034A7804FF8DC837B23778D397E17A230195F1C15ECF55387E240854071AEEB558CF32D6DEF208D94A58572081669FCA507DD4C0317935C0FB0F09010B8092A5184D2D9C0845C965878426026A6E7C35FE70222D4BD8720F141161076C178504D8BE8D4C8B5017DD1BED9EE06CCCF02B3386696825820EA76CEFF5A5BD756E2355300CFB3B5308BDDF638480BC00D225F47981D068C8828C5C53'
	$sHexData &= '0D03EAD0F10FA0134FAE8C459AEEC3304779800A8BAE772C57547D69D8842084A835AE98781FA84CB41C096F9F04D20F84C0F42C7E27AF4BF3D5A8F534E23A002663901750FFF45A042BC02F649FFC875EB70FCDBFBEB0C458BC12C4564C6EB03448BC54963DC9AE9AD02701442FF047305DE2A090436E8CE28190F95C06E94C03BC40E7EED7B5309F50FF4E91FED5B1540074884F7B8AF3E0AC638FAC948FFCE92019948070734F2402E054AF32890A3188CFFBD050F920B190541E0F232B40121E909EC4A27077B29DFF5930CC851090975270772B17AED061C1D9ACA9B60E106D4CECDC1AC1D796EC97511060640CAC5DC1E06AEDACF7241C7047FA43B206E0E4500408C2223089C934AE51010020440AF851B2D7209493032E94281491E7750600501C062243F81D1DAD83D5557A128D8436DB48222D904F8987F2AE866DE158BD3FA7E28415F5FB6DC15845DBC55B953CFA3715AC8606866F58B1276E1BE875ED67EB5F1F6413BEE6E0F4FF5442BE104EA225504988CCD8EF0CD0A30EA015803C8CEBC0B78B0D0E6C03640E6020D99F500C14FC3DE2FC8760CDC5EF1E8C2DB03B5FF568D442D0099F7FE98C6644CDE10F67C18019AB741BAFC418BEDF63F28C07D676E498D0C078BC710FE0370D6040C187F8878DA1EEC1BCCE32603ED04FC49C6D1240DECC276680876056104C33B20BF24C3D3703F16554000A30E0428ECAA703A9FF0CEC6682209C6773C077419050ADD7E7CC244553AB860A52738308E7A26FEDE708D77FF9F00E860703689085920DA1ED82C20D3E7B90A1730E33FFFDC0C505A41B23BDE7D0BB9703370BE32490BD6DF7CB5E0CC9B686D309308EC128BA2E26C40A85FA1F8C092701ED6685586A922A0A8ECB1C0C1FA8F1B60084C63E1C81640DB81DADEF94D7863F202C0C3D8C269E79F8CE2443980CF18A8611CBC0E76D306CFD5DBF08A78A232ED277FD2484E629A83DA4E1F124F4FF218120262A974CC44F86BB6E98B3A4ED95A8AC410C94869C02608FED006489948F7FB7E740CA1EEB5C623F9B9134D79A213A8224207C44CD354BA42E44821494848AE5A1F8D2255D7D6DF06F793F1E90FE7F7444C8D412816A91D2884EF445ED722E3288236B81EEB0180DB7DF7DEE6A71DFE02E401740E8BD6BE1E97F8C32603C8B905B3B1E100003DD4D1823E7F56B0927E609DDE7CAC41BD97055C7618B4C800C0E9AED8EDEB7D7F5380B079737AE722B62A46CB065DC77D08E6A96C1A96002EF8FAE5FF83D5CEC322FD0ACD34770A998623FF0F89D481C0B7C64A4D8980518B55CB064643878AB2CE4CC40C086B120E4E7B6ADFBA60939178CC7EAE1A7275CFC7E0109073DFB2A1D3860BDAD74E4250DFE0225E15C091742851CDEFCFA1E944D7EB5916FF'
	$sHexData &= '897513141F0B6E3A05748FDEC5757FD7491BF2CC87E072FF446C70F288FE1D8D47FF3BD85B5DE08795A2237A707EB4FBCEB87CD5E6DE1E84E4545F923BDB0F8D436F77F1C5E7252BFB048D57FF0B7DE24853BC23322143CFD3F1347ECD405555558383B73C550EEFF828EFC3C8010E43A5E40CC5C6253E2D2074B00122D0E118974727905D7D058EF1087F823020F806590C683C6F2023D9074E028CC43D26B8CF486CB80024EFC01E046A69A77545CBCC055017C377C0746EE37808C64708015EC89E5863EB050C4D2008214C561E500830086303CF9D3F5B2056087BDF9A1C64AA6E3008E67A27EC216C507B183EC20DD84338C3821EAD745E8CC991346530303BE30DBCEF484B63B4E2C67AC00765752544202EC89B3A312A4E5F1FC0696BD46009F028B99083C3EB02A29830686816F019405EC3FF09B9326E702C6420A1B91CC1CA6DBF60F932AF8053B00C6208287FDD83E0E0C18269976560A125ED91B5979DCF5A81385567A13150AEDB531A5B498E8F58CF68D055281348B7C1E82015CA6600B2EEB09CB1E1B3E62D912D07317279D4CFA67CD26ECD30E1F659BCF0DBCF1D2BF20FB70A0404322BC87508629D56083CAAEDD80D3C44BC675A0C5E95C3A4B15E28C185FC658DC1AC3B6E2AF4308E6D316D075C8643977F8B8D7119FF52303951300F9CC09F089C86D5DBFC0897E1A09E71280F938782204A4E8696D328DC92FE2E2802A3B0BA6310E985B7CADCAC6C05BF2E10EB13E60E24C4DF744E70BE0354380A5B4F9F4ED3E6821D3520C8B636DE8B31846F991941C5173AB4D50F815C4884045C8BF7550FDC8BC3E9F0989CF219B94CD28EBF316E245B5D3272511784068665DA054BC7177B87299091CBC82A1C0D0F021F733C75BC693857B4D21A620528439A50DF87D51C0D0E30C410FC830C5A6C4F3BFA750E5A830C0E7085158DBACADDC2C03B4CCF49BE253404D6C20FA91EC62B0429CD6CD5D6E83F604C9A30FE34D20BED43023B1E9C0EF3B47BDDC650F8CDBB84716ADF38A49DCF4A90E3C103E90BBF8E0C3C9325D4040C3226498C008B02309154F27268F08CBE765C486BF63827082C8E5E3403A89045473ACE988D799B065023DC3FE34F86DE34BF8D56C707BF5F5FBD6F97D4C7924FE05E75D48F6E477AA54C5F8BC5EB4E3E4732FD74395C7314F04C207F9B3898CA338447C57C390AE95E6D0E520B20789A9B80897B3D912A01CE591F9B51683D20E6E9308BF264D558411E800C7EACF5819728311F3CE31E0064F41840888B21B8458674EE85DBA44BE33BE2DBEB0AB864AAD8487A4A891033EFDD00FA8D86DD9B0B83FF08F6B6C6EB0232C03448E6189A80800AD5FB4D53042E45E6EB034532E4182CB8B0C0DEC098537E1641B010BAD12B08A8300'
	$sHexData &= '32C5A285CBE344488C08BD774EB0D51814B7D9A74EEC606007C0B18BAF44D843A647D6C836F0143AE2172049F94400A4FA181059574CCFF5DADA43396DFD8048B6680C0A0F968B530026C189C14AA4C3BEFAA49571014005E89044E0216007E39013A266F010B6F0BB06C788C06FF08B203F7028BF07F71251D7034E608603C03FDEB1D5599BDF78BFAEB1955335844D8F7191AA29D28460EFDEAA399EDEFD685C42E8D4D4DF87FDC104E04BB261B3D73DC404EDD5EE4458CF60ACD18C63163C7C60DC80933C0041EEE20AB2B2F54B7D80831965AF913685844283B4F31E6C0AA37062E542918A201AA5C043826A0CD62D132741D5F1AF8DBBE24A550F011A49CC8468A252E55D06A512B26709E7010ED65293D489F1724E1203B1EB166404C53A0A548DD551AD1578A8983F8857C0149A75E7F78712EC6584D508D2DE8E20F7C09F0F9CA490F45EB83ACFD4D78A3B14107052750210BE6C5DA27A9612B574CFD4FFF8A8D7C8D140E3BF87C733BF67F6D3BD17C693B3DEF1CBD603C7F634492A80CB0BB5C50CD3B5F443BCB44CBD4331B7AE2D141AACA49050AAA0E4FFE8AC57626F08242B656E2347842478FD07074414B8EE0407CC36AE8E85D54E206E3951F195A0D8D1B7E4D9D9CFB7265FFF20D2A710150915612D2BC8BFEB3F16C4894D6F62575358D482885F04C056ED921CC1CE42961C740D5BE3F0650400830750DE5701D0B1F71A85E34D51E6776BED30C86850E8D97D8044F88A183E83B86BE74AB5A45BB3F9F114DBF726B18A4DCF87E37ED0BAA1940AF1289758F12B34DF3C6D08B859E1897B7A73AD234239FC7AFA744D69421562C1B9C39D295D034CBEC348838400088B1535C1296589A2107995EEF972EB108A8F0D82E7BD2140EBA01AA0D39600AC95FDF760CDA08C9699289C000E4849C62DF0264BA6F724A761848E123D59FD708F2E451746FC3D30CE7C367BE084D774F87DB71D86018A0D56EB394C66031DBBF09E0F043A530387B7587C7E2A3A2E0B5FB7D8F48A0616BD0088CAF066DB3AF2A4A01F298D79F2C39319CA262BF5A6E2879143D3FA13FD6430279F2146E63D230C888155134A300111D9689A583D4A7033220CD44878F972E9E910EF1029FA72FA061B196D400F94C4805F21BD63F67990D0750F6BE6C919D140C86D4E4B30CC8E7E7B06C6AD1009B6C30736239D9B86B305D40B21832057AA590636C8592F90D6497F6D0AB0F34ACA07A50D6C540885450207FBE46024B3C3C68023F902A050B7E1018A0A23A664D3040E19AE81CF022A1699145CCAD03776BFB692FE83383740A08790423A806026C85100E0E45E6A1135A2398D55765FBF80B1AD395006CD52D61C14C6040097C4668A4427F380EE0459D128D7C502D9785D3849533324B'
	$sHexData &= '20ED972E20A31B33D781E775E8509E8E331E20966DDB687D173D471481F9175F86B734B80B45F5BCBD8C053D85ED18EFE8199B281782A07905F38ED01706EB07443BE0FEA470E28BF03C42CFC824400FB6C544FEE00E5068C541C1E02D28440BC066EA5C2592C41F14B450006C06611B2ED42C07A3B0A3A0084F35C675EE1F083C081CC7007B6ED1EB14174B5B2C4257EB31EB58F53008865AE8875E1BA51A143A005B6CF2C7210B3C9D5E0371B36831B531B0E5CE33A4FC580D0D3C74716A0138645068E0771E4038734975575F03AF09E4456AC40C6FBB016ECFAB318BDF9E774974BA7E40F879CA0B4D895B7E006A1CDC204FF669F3143C146040E1B91E9063AC0CE496FF1EDB4CED4CBD93589AC7DAB67C2DD2A49658647C5B307A5A9E24DE48A094228FF396869AE0D749495E9AF593443F9AA968B0EC1025A13266FC1B38D27D03D03180015C9DAA37D9EFC00063AABCBD81D2854D4198102365B6760C8ECE2F7180E88704CB83557162CD4AE7DBC9A10B929C214139B91DB9DB0C4DD1277058100A05A539ECF6289F9F85D4A566FFCC00C06885100E21D057BF43F204C828E4D000D0839C92CFD000696854685190AF909568426884D000E4C8910F6BD000016850676213C8212D6724BFAF10C2190BBFF366E4208B223EE866DE6647ADBC3CDB664C657ECBCF6B580DE420030D4FCC8ED7B0CA4748BE59D8B3C660B09F63BA9FCD074E48363544664ECBDE282D2B2F66511B661E7CBF411C4FFECA190F191964658775F48A667B667E03B2F27166CAB06381BDCF58DFA9FC9BCE64B0724966CF24FD75F94C2B1D30661D49F7EB74803561C07E24C7105877AFDBF8EE862369B7BBDF0C18803DFD9EAFF6D7A20CF7D5BE407905F802C98B0DFE5D3EBA606007AD0A461CCFE6ADF19410CC224809A39391054038526D84B5EE32262C0AB4D6A008677BA4CD6F7032050C4165E0A4B06040D7D1E99F8D939777FFCAA19710E273177E0D3AD8ACC9D51AE80E807A3D28B5C47825E0E72F2802FFD05FCAF761C30E5103FC72415D9F2A54E6C3690E973698A21164C821EF118618384D7BDE69F7E3F4636D3D0CB8AF180819B98C5CA24B953EE2C5BD7848C91FB1AEAEB2645D73CFE2A1859EA41B50950CADFC8EFCDCEEAEFFFFECCD81FD62DFC8DDC3C10E905A4D264AA671A8DCB9D25A9B11CC26C7055B01072F6FF214407699EBC8E179BD5EDE1A6C22AFD9C8AF0B58138E06BE35CF275FE750503F1810840975BF974DE8AFCC180FC7431067C61A34813034BF175CDB90DB411006CA90E0C2730E083C95175855D75FCCD068A089342AC7D2F8120A6C0D7554484118A2D1F8DED36F11D11B10094969BEE99B485AC74A8D0C494814424D03C0B4424B6CDABC5B2BDFDD4C60182'
	$sHexData &= '59CE6E58209C46DB2400C5812F584048B7FBFF8DA1ED71CD98C4218421002E242209E8D2546FF4930175C7F4C01A83114275024CBEB9EE1A2F505C6D7AD0112C46E4DE10D0C4881C198DBDBC800D7024F56480157180BB231E0CD2D351207E97B716C4B6B96F07618388D2AE5D62D9171AB4762C787881B1290F3540A26DCC75030E111B3815F8168FE7EC7456513CF840A258D59802C02FEF2C88003F64378016A8B43EB94A666B00800AA188D7CB3D7EB0810400D58192848824FFF9B0D600A894B70836378FEE9AFB5D8E70344A830F7C71E7898A821BFC108DA252F56829B00C85CF3DF186F5FAB28F6417808440FB7E2810E8763742F1030DC11F0F13F1E2823E670493BD0731AA0600F83424AC64201237080A7BEEB4A492B06D1FA8910411CAF2060AAF06C64751233ED0FE1016892C525764B6802B35CE6182E9202E06D64EF022E7D900A243BC0731E48DB00FAA51CC739204172C490A77A186A02342CC14A8CB5307AF20D1F66DF87048BFDEB17A938BB03F02B70E14CE1384903FD84D17E09BFB4F0207307B868EB0E8C9AC201A5BF037CBF5D4C7F5CC8483BCF73055475EE55AC44705916DFC08BAC84A78E7C4C10A3055BCBBAC034CC55C7ECC04BEAD404982002F0FB145023A0DBDA3FE7C8D3537C9E19267553AD73704BEE2EDE4B4536BC30D1F913C381C71D0C74D804201BE66E59F334462858FE223C7B4686D99CE1335852D5231CAC094CC5700AC5D6E0463E17D71CCF1AABBC28CDB6484EE006F606308C014B01490F0A13740BE87C751E3610DC03CE5E080174198B455A70090DFA0FC4375BB377710E8C0031C84DDFECCF06480CA7584983C00249E6FA128C2AA800F395E29AC2C3666ACDBF0DD8A7E2AA834B30EFC5471A0E5EFDB0E91BDE086C18F9FF4140E12A1D39DF9C004122D1DFB4BDF23B007638603BCABE66413B50FE74069E7D9BB3F7027525365854678A00FE410E014C96E01B78904863B268561106C3D729DD2AB24E16CA5940C9817B135A26C0D2750AB8DB0A68B3E3C508FE1C24D059580B49EE06B8DBFEEAD2730D7AD42E4103A719BE41EC04751AC44867FFFFF6A83449E677064D395170762949394970730449890A40BCE73A176E032C164081545BF61A27018DE3A95F0FF8545C570679DA4CBC073DDA4F0B23399A736E49473AA90A8B506309B684B0D8F6C2819F35E524FE1EAC30BB1F1D14C3AF7068B87AF946137F844970482BA4D9EF9F084C03C1EB25300175177C3A176B3B386DCE390845AA03FA034DA810C063399FA642CD700EEEF4080CA6C12E328FBE55532758DA49724503C844293EB86FFE444A40496303C0480101BC1BD34D7D5DB6CB2ADB1F6A3FF5DBC8AB0C40CB9B8909292BD1A56998FBDFE94B7DC4E43F97'
	$sHexData &= '29E4417EA83FC220128313C8049FCF783497991DB972488B10482BC27F1EF9D7EFC80FFE4103D029108C484863C2EB1476EB1DDD0CA30F15A405BCC13300160A18D10212A26984E09648414D7EEA02D1D7C3DF084D6350088A6F05A31CB551484D0310B870DE429AD902BA5E89D8A0E01E28D1F7A10715379D1EBC7F49FE197328D2874C702BA104289143D0820B7C162933587398CCDB9095D24B409E0274784D4C714F05FA106C581743BA47E1921B17EB496741D50E3705B739FE88F735247687886AEF891A4C878B00D15D084C110BAB7B1A6241414630B588C2AA5F87E719C02C2B84C584486B27686B1E7A0E2B3AB62BE83B3D034FCC013FE9F98806EA769A2FCE2981C00B1578CCD5E11AB01882C0CF76B856E000EF0EA256F20EAE25AC05858D22318746801207C37F441C60F142AC043CF8C2E818D5A562000BC8BD7B43F006BA07DF7CEDF77BE2B74710E7890F044F244F102A45244A079F35046558A7513BF66B5558ED3B56677B0C8642F01E95A3CBE1000A1010F01A489D013CAA30B1CB9BE01A581E9249E31E542F14404BDA56C2F8A1811341638D3CE9E4109490787EF07E4A6DFB8D1C5A8A4C895E6CC61D6F5B695B385EC3460E4C964D7649AFAC3DE0C1FA02323C16C3DAE4C949D39E3AED83E0FC802D1EBE0667940E5E0B8D0DBE957E84B076894E089D48492BC1A581825FC877224B1493467829A908CA090103DFE7B08A87682BC724EB32C04BBB4B4C09D8D02C5308F862E03AB75C1CDCCAFC848E60D6488B136F0EC51C40743A4EC33A8B68100C12741446B94225B4C1B076C11BDF7A09143C1C3EE551CC7EF1F2C168A61F243BC376DCC29960B8386FBDA4EA0BC7ECB191BC0AC0E10F8381AB9242F4CB49BAB7F249A0958D8CB8D8D6C94ACB440ECD8097BD56100644D101B101B71BA67624F9C0D4F8082A4EB80433D2FCC6410901E4FE4EC1E107E0B46EE0BCA3839D86D0166B065C6C67C1C6520BF85E35C3534BBB403B0CD87699637C2A5AC3371F051F5701FA4B1D44C318BB1057DFAF515FE548051535060C744AEF505B0F3B1F7B28AC3B01F9660AF354BF00EA3CA10E16A4303B519D403458BC79DFD51612C55E733FB8E4844C28704AF9F86C5F59E98BD8AA054E74101A841552F51460E021871492484066D63019475A49D751EB0EBA39363A577B01C2EB203CE709209713B1D0A0DC4B209D6C5B58E2A0BE300CA569183437BE545556F67870807A49F2E97407FEC828BBC1B60471006E4A1043917F40E141F8488BF2751749F8791DF2384C8BC02A4B49751FAEBDE39B7F34501075135AD0D1B4D0B3A638FA403D74E74CF20785B7E08714304584128B6AF62C397DF88A85EB34014B058CEB0D530FB5A01A78043BC602A7BFCD2214D9E02'
	$sHexData &= 'AAA75E65F08F21C0934DB540120397006EC3CDFED6A7E3933756E893BEB407B10D1C5C5EFBE30752D74A5CBEB0C0712E50DF983830C488BC85CA2B6022E5F89B215987223A82FB017DAF97B0C385AC4227E3B6E0EFB8B14DF994010838006FB9BF3526EEB7E6C863640415F4989D80175C1E4061FC0D8EB1F8B498B585A81796683E2406E0C4CAD244437A41B21EB30A786ECE03C8A051C8A26BB12C0B9102366D046484108C1FA154D4888DC884E48807E486578EBDBC1A9628CD453882E29E166EF75A95E6690F0395E7B609D7E5C3BF975792F800A84C64136F17ED803BEC64318ECCE2C33B585486F325F30264075CF82EC3E9041101374707438C61328DF994082758C2490BE73EE5988209C0151B344B3E97B0BF90C01E913720BE76ED83187C2B927F31EBDC7162A07A6008B3A08EC8D1607B53D4CF84D821B08DC14731B2CA619E0FB0A0E01178CC64724837E70C2E8043E0077A9DC3C014C4E27BB00461A802B623A4602469CCE9EFA340CBBC77D52323E515825F2740A516967A127F027F745ECA059C25E7F5DC39F3CBE2C54841BC783B9988FD86DD6930C51B28188F33902B5851E50F249789E48022F1DF42E1B2BC9A827BB28186A80BB2B5D49D8ABD2CFFCFF9FB83282841B087F89C7E4055B9E9BDAB8003FCAB9206C00B11FB87400F15F2790FF36088F8BCD70207C63450FF4974E2F6FF9BE6A663B0D72185D780C322CC5056D8C1F0AADADA2BC3A72311EE02E351298604963700C42D2E2E22BB2D1731E41FF2A4F28ABD012859E4240E822741B2D0DCBC456BFB7ADAA9786A3561A7064873BAFC4688EC8109C475A205770E3B4DB52E5DFB630688005C6B9A6C023977D9CB4DC57795983B837C695C2F4AADC2DF15BEB65E7BA0D89551FC64507194DF3D4B785077E08F524578A1035A0FAB6B48848089B609206AEB4F25517C43910660E4ABF423501B352F8104902991850B80E6C7C4438A09EF7239D894C18F8A5FB45EF1A6C4DE960F0631BAE20978CED8F6168FDA0537AF1A7AD9963CEB9F7868F1064BFD7EFCF42F636E18B5DF7A87432E12933708895FA8F984721750B4A85EE62E4854E7477EE8C267D8DC6878A380AFD161A7C82391E394F9F48ED170EFE41ABBCDC208CAD4412C8F67EAB5190C26C0F8620366A2CC42B895A00FBFE777668731D9C9B40438DD3EDF3AC60E03B3033EB1D9E7521DDFBC0D0101741448828E9C6ACD9843E3AAC2D39F30C065D9B4391F065361FED12880C8C4300BF0369EB71DEC2E7F2461DDFB4DE1A6F7989B712BB908B7260B4EB55153B7E5F7CCB46B7FFC4EB26037530239DC665F30FB74DE7CAB675E8E6206DF07ADB2A74681181D73DD8142DFAB673C6182F88A6F20AA59000404860AE6B98375F1F5C5D2937'
	$sHexData &= '9EB6100912D9AAD5D23460FA080B4CFAAAD33B93390873437C26663951FE75F1A5A1C69477433BFE74680C0027222034A1DE58C9007E23FDA4A52ABA939DAEE7B491A6AC72F71132BB0E8ECFD2744716FEDAB5554CC4AA93148068BE49391074584B603AE6D41D22547CC27416AB586F9095870D75D64B784989BE9DFAA9110BCB894281C15681A73CBB9155786BEDF01F8225FE7CEA516B2D67FE53405D14160A63022441B8E71DB53E73092E845B03E37BAEED4BFEFF50382CF8B8E7C7740F3440F7DAB51ED73A3020F946062841ACF1DF90E0E4845C0F87403F93809F1AAE7D3836FAD0E134181012184A010EB08276731C2A588938AAC6A0577E4E48800A72403E057E00B2CFB2CA09B4E4551FB20E52F0145DA3C08844D8D85A3BB030443FBC41CEC36A043C58822F0FFBE439B6A9C94427CA6517771CD1BD08D1F62067B9E5B2F0810F5527D3EAAD3C5BAFB2AB010F871A9D580EB9EA7E2FBECB7311177BE5AE8CA8A61EC34017497C5A39F72B3F178818A16BAD95C307BB80442F41408834B0BDCF9EDE5D6BA22F2BC604180069DA7BCCDC78C70E65C84C524C0EC084D7066C0C0A4B27A03C95F7A410F930F7390C501EB0FF93AFB10DB0DA3CB29B7E19FABA7DD800DF1AFE2702BDB1FC74B0532EC077F78939B4E24339852F00D3800B17C2D8FF4B060D70BA27EA063418FB569979174D842E18F525F04C2BC3508051B009CE63B2EA20DB4CF932EC81C142FB014C2F4C21C11A82BD05945D4F0C9AF7E298B2D658DA03383F0D172873237C18A4F1286E552F44045F0B87495E322BC1035242B7A424B2FA2A8605F817FEFFCB0FBE0C0BF334CEED1E9CEC807E0657EBE17B8B23AD0366CDFA6FC8C80EEBBD7C36E034EB1CE808BD12AFFABC7407C1D31B049031DAB22E290471430C3F9046CC424ABF7491D8BE176CA188904165FA81F4F0D14C3920606C234DAD870E44B90412EE027C3C1A46A37D4CD08CFC7418A65F00D0750583FD01740F448C8712944AA0FEB02C246C9DC1532D19897635D22AE03D0E20CC225829957F144770488B4F7847CC861E65971D16B7D7461FB5DAC08B873DEB136C08B8CFE0C0ADF93F0B353857CABC0B0E65488154B0CBB5FFF0D082F24820ABE8FA433571EE4C2A6300F9492BF12B58053FE9490330DF9D7886469A30315E92180F0E0861016A036336B1CBFCAF4165DE2B2BE03B389012E089A5BAD2EC68F06BD2CD30C3DB9E31783FA89E1BC205D0AC23E4C1483A10C8444AF0A0029E8C13CE8B801558EDD57F0324C614C7F909FC0416E102E46E5C750B6E298CBF9A06458D41049C10A1C148C103C932744E2C5B0395E6936C9FC64901881698CD109D4AAEAC1E1847020FBC85B23FD78F5403D540B480A1181CD8846BFFBC710C6'
	$sHexData &= 'CA7FA367E0B25A30FC2BF99885018234D7BE0663BF89F741A8E8BBC99386283AE2F790946D55A0772D3DBFF484F4758BECA2A025602CCF623F8880FAD62845A490A4483B7636D0523D3642970DD5856D8C2ABDF56C622120323B35E8E34087E6026BB81C197EEBD161BA686903F015E40609784086F1CE920FC857FAB7506E0BA96A635A831976840CB4E6B06FAD2324603C683390C8ADF313938DD431CAC98C914BB51387B5E8983218303175A21624CFC4709873DEC1AE703CE9870942AED8D5002D46BEBDDAD99C001B65F3920874E7FF744E84432252B07DD44DE44301AC867611E14AD644F7D9F7F30FBAC7F94449717F2883038E95C960F640A9043AC063CBC2279252CACBEB6C9A100F9E8A8B9FF849C480E3A421942E4214F0EEA41E041BA6FE440212FBA6F63413C64F3A2BBA21C41BB9E252F9287BB9ED54C40720AE4BB4DD5AC4A5EC9E6D54CBB9ED5AC23E4909C4840BA8CA79053C8D54CD5ACE7A848560E21CCA8C53FC48314F2B13FF2D6AC0C6482935F20E218C4268459081B1C6AE0047204C6D1248520FE40D8713F6586E641E81056784318680DB453D8737758A5CB24E204C709584DB0404460790831ACA4CA0B08283097DA07B836B359211CF4C8532E0997EE4A802BA6BD2EA208D49C1FA590064522BEE2203FE221CD30FFC8014D38566AB93F9FA14F3D4C4900FA947D000E26FE343BC27775EC42153185D3EF31CE6102D14A4BCFD7CCEFAAA1108066BFE769418B045D1589ED9089010A449004040F084CA5A934080C0C10B62A340C1EEA1455A7B9CCD58D991C8894063573E6CC910A8D0A890A851A8835623F1787568238FA25E410CD8043773D746F9334272ECDD88CC040911C3C40E710428D16C138C1188998397020EC2266588AD35BEC230027EB63D7C94074081027401A969FD6E51FD91C3F39F978A418126E66C709640204D9BC044C053F4C0C13C8B917EC476A1479C7EB3B896124475B731A24E4C1537479DD282707211BDFDA7C756D18C940201E6CA860E21B42ED218158C90942FBC50C0B5A4DDC3F49302CA9A9F1B4746FF3D1618D869717D1ED3E772DDD110702E885C67436614818F5BC48067FB5A1FC23D20BFF1545A3539C6FDB3363233EC32860DE75D74C8B2D742A0B3B0F896F64947CB102611FDC5C25A938204828F24C73C52FC2C25E317EF090542C903730EECAC3AB7FDB9C486BFF388D73A674BC840A9D7498333901A6DD24804E0897AF361E9008448B5FE65E30EB5452795A62B9AA7B7C7C80344DA5FF06074F0B3B1732565EB277563CA848384C8123F12A00DF8DB11056532FA5E48E98DB05905BDA17DEF0402ED0DEF8F6C7017409ED98A1D58B120C5AB7499FC6276120D420231F894EA760BCADD9BA492030123B'
	$sHexData &= '13C54CA1BB23712456B2C27B2B68A075512B1C029348058FC2E921C3438E9ABF08CFA087A1A761C7EF96430384A152F03D7FAB472CC3D39B4996F9614BC8A0005F95B95892493E4F6CCF116C5FBA709A309FC108A73021C7C21E1071950B56487DB6810EF66318CF2473335B0B8D61567338AA6E9F066318295E79EB098B85130B718937677769DF790E180677109247663DA3025C3ACC351F5302E85C747E9D54A6BF257A104D8BE0C5A673C2E6F340065AAA649C492BF0A05ADDC4CF36F99C751FC65246076E07B41D4ACD52AF6EC452CBB550F5E11912C61616FEEF0694EFE47F27953129F824CE7E162FCC43A5A1D33772F4EC536D4E7E3E73354F6C0336D126EB245970BA24C2E06FDB7D3AEDDCF92A0880EB39800E03EB3574B09D31D22C3F3666500CE43E092B7F0843C6F360D00BCB0B700AE06A04F2C4319BA4C1A87C91EF6B6D3541BF5418B451FE388CE6E2CDFFB84C4D4A7131D52CC2D0FA017233F8824A77CBD501C1121C40669049010AC202C96CB9A6BE7DBA0F1E66390A741C2E4895CEAC83DC6EC18B8B7C13273812549E6F0122622C1A62B39AAA100AAC41A230495C042D09E6FA75E949C51A3E44D9FA1B812938888A56D3042A1C29D7CCC36B236ECD4367540762CD3ADF2B4E4DF803E15A02F02BC14C03D020C6638811389F100AC613F12DF9587802C140B1DBF6C480E3E5A1E641D8094841DFE087F5EBD068869FD111BB6021B0781366E62C486FF2641C0ADA487F3FFCDF08FBF609C651088FCFD1ADFD9DD7D874D6EB02EBAA45F6AB2C9C1902E904E07194EC5E28524CCB3CA4E8DE540EFFC87705FDA01EDCDD9B6D37DE26AC64B785150BF8A799003AFF4C8D1D18A84FD2731B5159F90D424C15C6A5841DA274CC0F2A198B011F175F495E8E909E27B0D11F74C355E88975C0A678A8026AC961DD433B4E1CFC39313A190105B3A94A7E70D4C04C895CAB5090427C10BF4340B4A601E0006606D0402A199D45F82BBB4ED481A6AA830A0F2319F06A66C95833AF45A29B4719A75D10EFCB540F3623BF22EF03488975434B18CC48C60A0FED1AFEAAC13F7CCABEA8049BCAA642404939301C03E60D9A1848A70090033BA4549A200A790472D49A419A60145C31C65A170047720A64A82740AD99D2252314B0FFC885340FD69900C39004159EA5739F4AE208A72A234D9F954BBED27436D088A482968992502ACA47FC94A0C2B0015DFFB948D0EE7C6DB7B430976698EBBA8D07AB21829A2AD37D2D7F7F9030608514B7E5E501D52F679880A49189A5E4C1F5FF50C833F2901CE69742029E913679F82F14ED10E2C6E50D753814D749CB8182CE2F2F41C69767AD90CBDFA320ECAEA261AD18E91172C6ABBFE0B350107556F47551915DD00056A4522FC94'
	$sHexData &= '11643784E2F432FF2E04CC139672EE02B2F51082F2377B40B66ED221E27BC747D3FA45BFF56CBC275545210EA37095544E30FAD149818BE190ACEACED45EB2A1E4A3F1B4C511B57240A4E12CD20BBC0846029E823F0DAC4D5E8D2D0B58BB49BA5A53CD840758A3A1324A5086CBF33B10158750971137B61D15875591733ED000F2F027F8BCE31E5922773B73FB8966BF0B9A1CD6B9F96176F4974BEF1C20AA9F9DE024BADB0289FC078BA6E3DB8410D3F4448CC6067B576654208A4C12D2497DE6E0172895028FA895108C37DDDB612DA280B58273E97268E8D17BF111319E480B9010DBF610DC9A5A51D4A10C12C101004EE97368917BF0D217E6235C82C8EAA959F8195C0E342C2E0278436067E74CFE4BA128B422EDC06CA360B9E9218EB3B77973C0401019B4589BB9860257B01F9FE2C02F77C6BFA577790B0B4047E5339F8C77293390D742B8193EB11216B391F36468AEA5B2E4DACE44893006202D561BC144F483F290656889F11D64093F4750633FFF223CB2FCA7202EF22243B048384F39A3C9194A09A1A0304ACF7601B94C01C05389C914B4186F3EE0D0609FC8B428A41077FCB30E9858D3F657055344E21896B1F7DBEC50A61150DD2C780B98ACE4017D2195ABB83DF407C95D3D82B98D9E8C645808C3497D0D0E0D04F3444C2E43AED8058BE4DBF494D258C70CFE5604D583E104B97D0540110C047E33031B38F1896A1B43781FFADD27364C4E6DC7688A78AE5C1D1AB81D8260FBAC0D52138C8A9BB0493D2874F33100FDE4438ABD3B8A3D1103FE1892C24D2492BC0BD51F83797D2AA498D5808E7D29C98F251B892D37316D9D0A36C380C449165E03D4BF7CE409120E9B419C78416C86105571DE489149BC35B138E5D6D7DE8AD128814AFFBFBBF187183E8027402EB0D31724648D33A19A230BA0A930CB8A78D15284A2DD0099D1F782ADFAA8F5C1AFB9C0590B48EB14B616E913B8155F82DEF972E225409ED024FC21712EB493900D4410BC82D34519E4D9EC6CFC289C32BD2BB9EBCB4C2F3C35F401C29B6901CE4C9430229F828ED2859597985B790D09C11EE439E9C00F4273690831CE4C9DA27D027C527BA420E729027AF279C2781ACACBC16902F9C70ED873C405E4A272A272607797290271B27112706273904202B0327B89C8F9A90003F2926A0E44121C9251E01B3F289258A8E1FAB10B283EE78244C741A13EA84B97B077A05CF479D4CA81875996FC6013E9C8B0249FF84D019273D95A8053FB21AC968BA8B07B0E96858AC5C5D34154A789ABF8EC0D2B2C434EA3CBC694A13282BE8238562E108FA5FEA4E7A26FF1933EDFBDB744421FC147883CC71DE7428C0E33271BF69BA8D027885B8F02BF0080610AE818DA70A20DEFB9D39404FEB53332F'
	$sHexData &= '2FD2A7F0161806109DD18B481CDF57C7F2556B48C2814823A48CBA236321599F0C1C79E5BB170F10C64040014101CB09A6737D405BFF968C8052C8CBAF98F0E9430CDC446BDD607F4C0B8F161E46E0BBB0781842512BD0C37EB1B165B4AE23F8039BB175340C310CB8CB6763AD66950C5A1DA89785B6B8CBA28910749E86CA6D2A42A1D3B9CC850EC9898AB9ECACECAC67A06340CCDF0343B27290060597FF8806E444722403EDEC712B2187EDEC15E052BD703131F97C57809F0E2F21E269F5743B4F5C14BE4D69438B006028EC2163F834FAC1AE289C084F6A948FEE45686A09188BB7B516F1A3292704670806B19AD5587148FBD9801C41DF04654B81AC1C8A06DFB895B2870DB7003204D106B9961C9213EF0CEF0CE4402EAA9F4A2E00CCE9D2AFE88954AE9AE1476B2BAA28D8E05880BCC789FF2B0779063F0285947F860D473224023F45981C9213F0BCF0BC8A9540AABF87BFC56E198B45BFAE40560ED893D28592909C28D88579F1CC0CD1B4E4F1CC7F204186E4800388385885BC9038D8871D5480D95FFE84D0FBF141FA750AD1C71890E2378D962D02814C60FCF08020AB52FF506035123BFB9FE9021E86E942EAE985A02A9F95C017922184C058A3D970BA92C148E864502EDDD75C3BC5774F0711FCA749729590EDDE5D498D3C28C9E7D1059DD891E283281317302695695332C0058BE53A49585923327B2F60294002FA94D005540888419795C41131794F296A85BA581BBF7D56860FC945F4614CB800D341864969ECA0AED604724A4991F6CA181815024876345140ED5DD6492BF07ACF846A03EAA4D16616C6A547B2124814C50C9C91542A9F90A6824B2995C05587FBDF4E7B1D7249A5C3487D46EA19C31AB520E79F98A40456BB9C314D204AC04C564B2210C6409C5F0CAC401920D72E2B1FCCF3D0E3AA8FB48141C0A8D58F6D3833F6E50B23DDA042FDE5EB7545145BE0087355EAA8795A693010D558EA9246422BAF28FA0C7C3CEA0C2136740D3F9D400C9C9780EF3C8105CE46783A44504CBC2C58698A346BEB15AE3004F4FE1087B9190E35F00053166F755A051FE695C0BFC08491B0287F601580799E287CFA8318910D1EC68EE7C080000A9622D201E654C54B11A1A34548F821AD80A70A130E0F5F5BCA423308831D3C63E0E6C4B7082EE149C1FC02C7563295D49E0E06BE4A0EA63FE700CBB38933401258C1540293301F554D0542C103C8770F22E1B84C2BAF288182216E82878E7C18252BC8DF5F503781CA816068ED31DE3A8043BAAB2F09C73ACE81CF225A07EA18BA62DC815C321E7A8D58A1A2505C61645843A7FD4A318D51BEE3D76C407C71C57A6238280F53692A4D2C2C30303461648F5634B233D7CB02858EDF04C68A81F360F4C0A38D0'
	$sHexData &= '0C8D0DFDE7CB6163C3BC78F745460C3F27CBD1F5159B0C020D315702DE18A782D181966CE09150A2AE0EA4A75DEC52571A3C2FD807ED474F19CDF3EAAD67EE4565262104C8B7218300758205E8D5224FED3D5EAD080001BCD3C5A0032AAFD5A184D3BDB8CFBA85B53E174804C3426DCA6CC4D865D494D4ACBF4187E81D0A5DD946641F05753A806068262EAEAB78B80C0FCEF6290C019DE0F82EC397414BD9644F7BF881F41C175BF970723EDEC12B4E4CC1F1613045E1070B9CF4482000687A2A93F867924F00C5450C100150216011934517C67DF47C70D5C720C1C0CF979ED9AD62086FA04EA12BA70412593DAB7B8B9C6EBCD2652E695053E40021EE32CC1C9BAF1C0A138AB5F75D0379E861D1CA595E512545D7D89546A22F4DB7FB3A1940CB3288A0D866F6A4E183B8C64CBF260099C4CB3CE551882A6E0D5E0CAC28F1B14430E9F1F9F7A2FF846F2149AC2C1687221CEB5BD7495CA7815907610DC66842094099145D6EAC1410748364F92E47C387DA3B1617C4D892C244D34C664A01A4EC4532FC2E0347F748B3DCB16716DC250EDFE41F0F1713129E60459FB4C42318EC59618389E0B9C3B86491848A013D3875070126C44D25FE4A22918D6D3C366C2C1174206315C7223CB150546A4D3FCF96009C8D33C21C5EBD0497982410EEAE5704B3DC4B501977BBB5F5279A91CFA409E7DD894F1B91C4D78481043114F6909142E96209CC2508A3EA885D5A855FCEFCB2BE91A9034C36F7D350239C98889C4DAF22A79D43F8014E87672421E50E859E85987924305E74CE9320A390121E89C08E494BC3312EA2386408E24E99040A04AE5405060689E0C239E75FF07468524CC807C407705C60F433570D02B586C7B50F8064D53E1055A4279AFC15DC22932A81D5E3695CA58582860797985B88C7C4628B5D628907D1AA9DE0D577C0FEC901B4089B6192CE28E2D0EE868ACB47BFE4C24DE8AC1E36F6A343A48DE061088E4E04C035F0FE2A1E6A4C8AE5022F2542A606840548A88239E4CC92509C638850AA8FE3C02605E1F2A793348897335DE196973DF659D0852B771F3DF08A561544BC94469FAB6226BEB3E2DD44508CA75ADDF328E38520AFABC0078029AA808D5E0DA52AE2F10F53796D427BDC7C689045C49186E7CDBA595D13E417CB8755308FC26A06A50109641BE488B0A8079410469A2A13ED14D34FE050C40EB2A4949F2919F80BE4C3B41404C8BC10D2B68E44140FBF19A07AD41CB56F64C444C3B4105079BEA758717C60742028E3067DFEF480130181DDFD682B37E2E2BD074490E49BC590A05C06A70B136C1582912D7EDCCDF35064693644E6029F20A69F4B77615D8D576EA424EF2EE822AD4C3C1EF3E6A93266C90101F2BD121A9EBC6E8EA26B0031841'
	$sHexData &= 'E5DC78AFE0C5F376BF1A9AB4C5D4831E104B16A462D00839301E5F403E4FAE039681907330F297670659F9EC4C8BE0C04ADBCA53AE530BBC90193A1BC3F4AA2BF1C5EE8C7D9AFF6C042776C1E7064903FC7BE6C0C860C1A914F4239E37751A3069BF56B55C0108761A176A5EA71E9FA85930DE75C875696E10613B7373934AA727C775D4D338300880111CBFFD20597947BF7680707273258FE404F03A03C9CBA164577475748E80B8770A39CAD1275C1E4E19C81F3D6487C1C449F7E803A04DC804111CD10A2587ECB85C58DA8574C3F98005C8C31F523715C00A9F18D834205113E72A28550756F2D8FF2A4795CEF2FF7E701CB245482BF1AFD250C54FBA95D9C1722B859CE4E5DF72F87E34D0D306E9D2479A17CB68BA272E35C29009679B0873F270CF2BB3488947A30EE81F305585411FF12B2F4A05BD7FB67DB06FD10E2020D97FF4F5CA04D3F2F733FF6F59F4B1BE024D746BC9387C9871E4E51552F8B671CF7D72C9859C0BCFC7DCF1793914F31CC6716BDB7EA701A19CD25E104D6BE43892A34AC84EB466783EC840D7A500DF20E419405E587138E0007E0123DF11C21330E2B399B1414A4DDFF3030B0D79E34824BE9BF163C983CF0F42FE760518EB35BE027600978BC8A0B8ABAA0E40ABC801AEE71EEA7A70F8E89004C75FEC91C62EC0BE70770407835D82A4504F01D42051121F1600A0FF77A4BB6F112143E90D6120EE8A3748889417C3D44C56197A140E7B030878202BC229CDEB1A412E4878475080CCE8F5DF8BB4894D85E4741A3510071A11266390B0F1DDF5DEA23369E3D0C603786DC11E932A01FF8562E953D8DEC823861E040CC733C37F862F0829A18357020FB9E80749FD7FC90C6E0A44953164705B13126A878043153A837682F98D200FC685EA418BF4F05912C7B07211646EAD392F8F86475DA5816E9A7AE126E424D6CB1DCA527900B9ABACED741C088161014C4F52AF9563B893088BDAA96B087008E12B664689246BB503B888D6AD3F55482B4F5CA7774A1367AF576B0879CB326BF489E1C298F748AC4D961C21B844C3A4DC3364E2B80279C6D3427A64D07D41223CB140290608263B42AFAF076500284F522F0758DD13AE22F62D7215D213D46341480D4B63A0F6D6900EC85F62F79F807F41450824F7BBA25D553A32752769220E262F57192C0DB71446B08A5F745F21BD2FA445F80A696F74935345F80A79113F859329A43F416B2CEA002D344702041175504813FCDAEB1F675A3F826F2420EE0D508905AB900E5039901042BA3B28F8226083F4EDED3840064A408842044E40807E40FBD929A4B7F951832FF94DDCF4E042BA2F4D2B9DBDD90AC183FF665CC6413E5E486F2979CDC6434038FB7C37A9AC5C41F8F64012784729C8747CEA7'
	$sHexData &= '8D1A4EEDE513A8E008881DC423ABF294540AE88414006079F9B4BCD51C5E93501D3429A9216DC5141E00DC131D1240B1BCFB04F14D2C24BF822EB4047823B0ADE1ADB2D7CAC2BB5FB0A860129DCC647255E2026E80485562A8C8F6261887E821F2A6B85EEE908F82BB80806FF6DABD35E4E203A0C2C326E203455B6E706283028F76A454E8BF40C3CE32BA7E3693CEB90DC07E61C26CE687B50492E980904381C7D5D7F32C405DF0306FF15DC6956565E21FE69177658C71E98364ADF4883397290B40BC4799BB475A3D62279F5C6755AC0CB0A49097290D7161FD4EAA5FB6DCDE9E1EA976933F6663E553CC85CF1A139350E5F8A6D004F774831F8257274265A478500360A46866995F6E35B086BBA4F203E797B509566F63777200628180D3EED302C4F807D134490B012FA68FD7489CB113122FD3748A36C565F91AA76006FA441384AAF834279C08ED2766B1E750CCC227A225C334630C33BC00B4C5E9851D8273E1004CCAD5501D0AE912BF64E400DBF0D0DF92CB050C1182D10409A84EDDD177F6071220C69F77340BA74F6894C1189AA445C4927CD28DA401D71FFF7AC317E011E12F87E0ADAFE7E05492BFE52312130787EEE4AA5115E0140310715B43BA8084B836810B2100466DED43D50BF6A653B5E098F0D3730A8BB0478C5870281FDC240311825C0C0123C8240BC60EDFDADFB52407437F92E730FB7543158E9A009C1150DAC65FBE01483CB048F5B33717BEB0530CFEBCD4659636FE9ADE14D8BC6D2D7658664C25EB0C7EFC67409E3EB2EFEB9AC64866D764E05ABD4C731400EC31CC7440BAF84D2C35CBB1704084454286F320A95C6D39CB590AE63700D051C8BE10127E49F18CA5ED24A8B4C29B8F0240441572380B142C4E3282642097F48E352716D8D3DD8F254D8092FA04CD4C4B5F282E439FF76FF8F631FAEE451FF9E36FF742827AF8A2BB92C6309287CA6186EB3D02E49344751F157B236C7C7D66223579EA262C774072CC32A6E551CCA62C3D0BD131417390E34B7D944F29297620A622562EBB41E8C1A404DABD35815B5DFC088D5191050C456077844B23DB6DF66346EAB958C6E2451FF491A5895366F0C0C7378492A5DC97ED14660452847EB5DE028D62D60B4688831E860FFEA0CB2FA041E203C5859B8BEE7499A6121645801A38C069CC27E05AEC4A021624A10663BF977BFF5C2DFB4394B18742A41B0D2DDDF811B0985DCA45C4092E106A7BFAAF49070365C5BD55BDD4CC6434262895E69E0BED0CF010AAC6E865506529DFF9FE0A606214CF0896438D3AAD29AA2680DEF9DC3A4A9AC3ACAA7A3562AA4005F1F0254FA92F86E7E953D043C38F5CF8B45A108EAA562B53B4DB5AA81AB40A3DF50679274A0D26D7F5FDCA303DD65051FFA15C4'
	$sHexData &= '0D4B268FAE5400EE60F5663B7834EE2CE81873133B8B1CF9E22B0B3F190102EFEC807824CD774D00AA5850644D0D40518793296EDC84AB241DDEF61256BECF5E893374AEB8868D15386D36C80E83274D61140E6EBE66E3B34BCC83891D7FF9550483176E367D53367089F9D226E9B25EAF00744201A3691FBFAE212A10FE61331AFA229624B2021FAC01D3B1A07AEC2A81660D11104978C90F18974BCBC17C03DE80043CFF40A60412DF932538C137F28BC2237673176B08C39EFDAF127BC3EBDC410F95C2415437A445443A1F15D3FD0164E9DB833D24F86AB7D1F791E1F9A415050A24B20198354A46CF0FC78FB9D085CC8BC2E9F767A913A12F0C2C498D48182A60D5D4B95B0F89D2098CF73DAC0703CE8ED095E92CDA538BA51C227536B06850C3DD2179C1058EB46C1ABEDADA474D1175CD055A481FC0985285C25810EB9D053503BE1881206488A9934844DFD86CB8053DEB2E7B193F77700B3A3B017DEE546CCD007E6B0F446C4BF88D563718B8837930BD4E42A1410A4CC10F66C359FD5D406FC387213A483375ABC083E954D4E8120F0D6547394F4D522DF01D31BEA5B56A41F733096A419F3513EF0E7A59F83B1D43F600B553724E6A05B74325DF407D355E30D821053D8463EB1317F0043ED3E81C0D9C2A09ACE327254019E44487691B30BF4CF52790278F32F5149C11F573485E240869149C92CF81E4087C0869B6F49057C73675BF07BAE958300A59BF420E716C21BF0869E440C8236BF3079D02E4811C149C128C11A48C46DF14B0533AC24D7CDAAC751A4F85C38301A4A098180CDC188DBC9D28E13F78689F4CF02F2018493941180F83D2DAE8359E876B182ACB6FC00A63EC5479BA7530E7C292B65C6E420E649EB69A697A54695671706383B0698609F55F4309ACB9724D8B485D0A460D2A293C6525491249FF588E55EA4CDF7EC53AD7B1C17F02C375989E35EEA9A27ECA843A709BECF47332B1392608063BCCFBCBF50A71D4CF3B981424B4705D4ED2C170E875453D1B25673AD23E152F90193F419709BC8D4C937B08ED4CB01376182AE8493B2B4038DCC3918442DBDAA00A1EC22A2B1B014DBE5382523A177CAC0AC05BF5475F9A01F94D5FE849F99001E448F9F9E2654A3E4D8BC86C5EE914C69B78061237F2817C4E6B647556010BEE95CAE7013C6446564B1C170535215EAFEFB4C2582423EB200AE3B421C36031846E81BF0AE31923D4FF0F0AA3D1278D35AA5D3BF01D1A069001CECABCCB383C805CD3011B6C22F9E1CB78BDE5BD0C63345726591655D20D7A4811CE6FEB94DD6230E7547809C5826E26E6185ADB60BB790E1019793041C813EC3C4EA6616CC960582F1CFC31089F1103EDDA281E160D207DF5A0E36109601ADB4CE708AC0854171'
	$sHexData &= 'F629D30565F9720BE2CFC3D3553EE3B02BD20BD024E08377284F6FA173AEE40B70145387949130EB0AB40DFDE00347E184183CCAAF6D8D630AEFF49727259282984C65BE84691416B20DA3BDB5AD3C4D33CFFA51848B7F016EBEAD6203710074440BF220AC61B798BC6226473AEAD81B80CC4EB18A51CDF3060BC01D12CC61D400F98C78038208E54052404B4F062C10672714953FCC1433DF017CC6CEDD568D6DCB5BB8212DD5C3F0F46D82E7524DAA1032E1CB268E278CDD844A1219741A608010ABF7B185D0C24E92292807D9F6000FE9D5D10EB558603201506A70A7D753E9E9FABC079132B52081FF0C2C184182DEE309F7071AA98D8E12309A3F13501ACD7F20EC3D5B64ED1D33A0E9035674289A45E8348169CD6A1CDDC3E301C561C24A547030E7158C41B70535A25083FFA20EE143F63EC609EC943F854198D3BC1723AF2DB3A30BDC5544343A7AD9031CB1734AA4F95954FC0FB5FB551FF0405BA6D00BC0AB04CDCC6F7EB14A753AA1A8417B01FE759C4CF6B141812DDEB29848D0CBDAF50491FCD536E65784FBB1CEB15495C10B82998C207CEBDE221A61648DE7A02F63312621FD0C6CE0823684E2B116A03E07D5FE64149841C74093B04FE504F8DD048C90C82140087F4913C0D813B9541485EEB4843E001384BEA96764C9C080611664A01207B9025F97B005A766F17FE01610D0118CCD0C16D002ADF60CEE0EA4867DF66E8C5AECE1250C12D10DB1C80216717B81074A683B72EFD4107A14127488057547351700BE01AFDD0B2820DC0813C20F14FEA13F8AEBE157B1F107489525110EF08982AF541170D00930704F5E5E90007D22AEB6B7866962AEB508E80CFB876DEA18B107C72AB3619CFAB49CF2040EC017D5172AA00DFEBE8208728E413A012EC07C801E404E814361443941C929C14821379811C90B345502C500E80BC08FBE6D54FACBC3C42BA4F0B5BC54C13F29087A2E68FE67F92137290E675E665E6007985BC50E6175281900772165A16642B3901C9E0E578E5729207C8174017401740BC0239051744E7E4AB9043907DE4002390CF156C43E41DF5A1713FF8086DFA1C349242AABADB36E42A8402569EAF292DF8BFCC184C6A92C00D06584124540E06771A0E83E1422C098BBAA7C11876574C2F8C08C491EED7CC834008D4C48EEBF96BA4757B5E74498B59DFAE09AC5A0A052651194478AD8D019F2D7FCB10D7196B167F410248AE91418B2CBC0174E9E2180F82FAE398209C1700AEED120E4CE9602918223C1F6000B10A2074373F1649A64B8432D1B516442F97503925C72FBB0669B64BCB0EB24B035720BDF31B52BD4849D104E1C924D64D0E4954EFBC6B960CC875114C19C887D73AEC0DEB24E511441929B4CD0CE6B817322820522348'
	$sHexData &= '97CAF35CF64C4949401B9347D586465FFF1A5472259797401A5E4C415C41E516E1F940851C21974041003954BDC9F31B345C464EF21B341B344040F25582C001F31B385A14ACA44EE555AD96AAEDE7ED01D58860E9E7D4CDF13240196C511BC28458553762E0E1BF52B90EE955562FF1EA0387B4D31B1D0C1BF091CFCA20C6F95303461E4973F3404885F6011CF630CA53A349937CD44528274EBA20CE1CF600483132C9979E2C2AFAE70B49EFA4ECE95F36155DB050AB3D222C36224C0500C2D56B2741D44717DD742A198D2BB403900574B745C4158512C29A014487B06216689F55F9CE7DEB391DD8238D27E901002752A96D41B26D31E9565465E0C1A447AC738848F7C2329174401D507A53FAE0E26081521F44B1D170A0A3D5CDC01889291C41AC502BC830DE80F149693899F82BD8FAA6DBA5D7C1561E768B59001114B3704029643C49E780170C0B26E7927279959C0EE6352FC208B7E0A6F654EF81686D2306DA839657FE08C100FD32C04C3BC7B13DEE69FFF83A42068BCF72655C95092812205C86518434C5799118D8BC2978E1C49948F22C2EDCDC046E95E1AC6F1D365B19961077DB03D892FC55197D0EFF1568467E7AA7096014E39E5E0E26EB32130C043374AECECD2B00E02E3AA7D813CD5D52CFC4B20A9405223E21FC3E2F8C4801931636408F6F87024D58557F48D2C3D06082BE4C18D1A08CBF38024FE90FF949F7EAFB3490085BA48EC816BE2B611FC7FEF615F00DE10AFAAB3AC3F544A27D5B23AC145421A54F847D30C649B9B18A99D33C249C5C971AF0ED2E89371503F0D6F7EE422B7117AAA5CF1338C0620D428379E6FE1A2788C77D122A15AD087D49C81011CA5D0A1E6C230DCBBFC2BF7715DCB49AB98F64EC12017E0E26E0CD53EDB12C8CBD09DDAA10C1657ED056BB3B0A9EAAA591C6840FEC295C1B2BDCEBA7FFF10D9504F7F144222C9E0E698701541860E40BE479682B488BD615D6E8C2382874E739684F62D0DFACD16985083FBE8C4AC7405EFA2C19F30CE917BE4818AE58B86BA3C928EB5C90C140188AA58573DFD8709290D0470E2F22B5758E10A56452F28AA865D9FB4292070C02216842E7A42DE42F8A476FA53F1A9B2FC728CDFE75895A64853AA71F6AE0B298E4B1412B764F7779CFCDD90812C34815B866230EEBB3C7922110DBC9CAC6D4A841DBC14D029FE425575BFF31D5D80990871CCBD8C0D802C991912841829E334AA1A6FF43AC6C036882400923CF89100D60C87B88664B08F64039726C42C158F958AB40A8417279C44C054213313ABFFDB8546BC8701A846DDC5081F04C2BE8F09A62402B06ECCF12E93B1AA311E0C29B14A6F05637544903DFD0F2285B77DAE8C2734AFB733185E73A10FF7BC81141FFD5226539BAF'
	$sHexData &= 'C15F319DE465EE4FFDF4C3BFF72DA493BF6732856CE166F45DD9EE15709924E72911BCFD0DD48B8EB5F810D6C15E87332A71CDBD31E9CBB189639744230FC86C7C9A0E1F6FE72CE08EF763D8C6537ED296D6EDE75F68F0CE6963D83EB382175ED5EDBF8BE0FC0FD72CA7C753190747177F0765DF00B314D15E1B6EF2C0D95DE2DE984248C509A7B5A6A28B570EBDADDDBC004BFEE387294615B9050C40B7327E96DC16B836A58F85878D27170081A8935EA211BDF262439C024388E6A9871AC193E05E40242568014D2D51ADB023BC1EBE2C48C38C3A90B6C707F7F234095EE430EC0BF9B503C40A06BA64D9C04480710934CBBF6082C1F48D2494D0694C41852A73A62F0B60904490806100869500DB6820F1220EBAB09F5D996069FE2DF307B21940441774FF3AE04B20C080C0CBE0C1C2CF975A9149E14EBCB9F1830C0417F68B7E5200ED0087ECF072E8CDFC85A345841549E2E02660343438C75C0A9435EC01781C441DB6541F18153C340DDA0D2413CA0DCA16B03E090010A3F351C5E8DD0417771C46C319207E9F52828EBC638648076DFFF493072250F1F89120808A70575586694490029F9822738EBB2BD9009905551F2D14DB92AE14C477F2806BAC2F6294AE8420105513CFB88A1997383E2075260F844C0126AC0473AD1487D886BF670980FE40E1A2C549AEED57C5E4EC20008D11C37EC74A7BD6E4A8829DC6826DFC4D77A1BCDD316CE334D3619ABF3414EACE15D3D19A95DEB45428BCD5E41E991D623A234B0629F2FB0644C629C81D143412ECE98C60017F13794061576311970974EBCF249C1FEB4C6F012C313892B6F4C193E9AB44AC62BB65C0078C8585DB0820EEA7C3130AC2E787092DF49FFEA83EF38F3A49E026C35900A05A86E47D0F130E385B900F570DE4CC456A6C052D8E938458B3B8503B94CE720FB492DB006131264BFF8CF002F2C289E8D51B3C2A84EFAD46224FFCF8D063C4DDFDBED2A0440B309BBAC042E1C33082E1FEF898AC55C3330C22EF6EF3860036E3A7C3F02C47CA8CE32EC69157CDE894433C88BD08405CB01F8886EFF0446842542CD172CD61556ED7D603F2F034D30A388DE51CB67403040309BC903C5534F5B5EF062574D47BF7CA749243087AD5B5B7BCF38858E3A71807A87C50F390C7AC3025907B94B053CE835C029EC6D18D2650AAFC870A488C088FD9E6C756B258C14C2BC3D8ED034F5C9A49060801B228A1B4D7014CD4C05D918DB9FFF807A632FD78133DC486E14E91EB492843BAB594FA9017FC08F46A8B2564933616A02660F2E04C4734FA72E03FF68206E60ED34EA90C360864CE88D41095CDA713888F22AF6D849E27ABB0646478C0176900588443B090C88C3C7A29572C530B75EDBD5DB6D0E4FAD276BAEEE'
	$sHexData &= '743D207E687DDC6945DF998D5F9855A30A6A3A9464A0DAD8E050CD89535FC81FFAD1C0B1F268EE288D4D21D17A73C830585D30EB768CB836840C96FB3D9F5C4513BDCE07234F215FF660433CB8FB1E7975C8F1106EC4DE724FEF762D611E144987364DF514101E00582CDD5B5D122E02E26BF5555AB1345E637FA08D245C2053790847614D40C8C2DA2AC2AAADD93702292141A587A1D6249DF71154E01F5947080E1002EB78FE062E48896E0810955009AD6647DF604220C457010409F884A7421A33FF340C969EBFC2746C574E7BA12D247689030840420C85D33CCD08080C0C89E683D649A179393E2A500C0831DE584C46EC8225CD593E130F889540EB8FFD380906D04E4F9F43ED488C4975E24DD4AD406AABE14A16E9E40606F9E0594F3056C49A1FA06A7530FFC58F998CAE78B23A30C2AAED7AE90F8D08DD24111618ED7E7B690620C6EB815EFDC8AC5AAAF48A4CE6065F81C362561C37FAB0490F44DD90A11EF81B1734DCE0CA6A2B0082580BE07DB52308072EF4DC26D8E947D04BF3DD7CCF48FFCD498EA0EF2640D67FB444508E09670BC03FC3EC41A5383F6B8BD1638D861AC64BF0826DDF985C2CD7AD2D6BB554E3175B5B65621D89E94318EB52413E42C394E45763DD18BA02BFFD63E4B48FEC43A049C743C0A613BE2F9D1AB86678A3D1A100304A20A8AF9E8C1F21463035D8890699D9AB634355704E08434557A01A9748252D3D3A240395355DEC3274603198B11EA051101F880F9F0DD214620D30EB026E428F0760CA12024D030E25380EE8D1864405C702CA7D5BA89F090B1A61BDDF670A5618C185C6B786A830C2AEEA9FFD5F2B3C7BFD1EF6759A82DD96B7426A93C094D054481715A96D4CCE125A406D0E42502A2F1EFF20D432EC6864C6E4439630191E78DA04FFC9B84C28841611C4E3D44336D999D2F4A02B496DB114C37D7F0B7502BC77334C4C1A4C89119F7844D52016E969F6F7D3F9C2041F28069356723B063B7030943BC388B54E0F2AF0FF9C3B308B99E92EA720C3F33E6FE84708F93E8197553A47043CA7B5979D5EA1A8D1436ABE23877C8E52C4201FBC701D057D03EBC142799009A2C8CD4083C2D0F9C1182747F86E4B8947C899088F48914FD0335DC538A1E0F8C2FD5CB3D4603271EF497FD24F34A74CD633D29131DC900627225009F22F68815C4CA2BFB8A95AC160FEFBC1A5242B0D02731DBB896435854901A10EE2699EE60C3408380C3CAF43DB44544110081112063349E590D8D048183AE4C8A13D0CBE46B153A954464646619AA37AE056188ADD301ED33C73B6236E0C3808CB0677CD3C0CFEF4007CF221D2AE5748784E5360D9D2647348C82E4A87A9A92D20FDD6679EC6A7201052385E381B1B34A466156DB0E07E19905D8'
	$sHexData &= '8055F1A16958863A98F24E1FB3635E6642B59E775EB5CE6035E2F092202DB102CAD2C35B5719F8BCB84371D0356E8763FDFDBC591132BD730FF25F6180ABC5C2E97F8FAFCFE002C19E772A9020406339E26AC0B3F3B0D29A4267E350CBEC1C11066F7C18150844D0402F3A8C96CF3F27DEF3CA0D6F283FC0BFE102D964E0108CF0D58ED227124900E2905AF8770002E0BB7665EEBE7F29EE17EB9088D3DFC905A2AC4DFC9E52D2210B24073ACBE7155701BD88D2043BF6149E27EFB258CF649F9703EA2DDCC0F7A2308A06367C3E1F02B1B1C8E52FEB594F7D81C784BDB1BC006FFC897BEB2A35045E0EFF5490860FEF6C202742A4408067EF61916A4BA18AD3E5040F6C6FB298AD6D64AF85D8D43F8EB16321A48C5E540C8088F10862F145BE2882B7F8365C1C2F2F6D8372BBA1CBF97058CB32804CC0DF5CB0B14F1B5DB05C201EB236423FFBC61F2D9BD0E06001737D4FB050C37462CE95C58201C030978906020DC1B8F012733FF3DE985D2934ED5638C3A29EEA16978ADC0F03A2234E6EFF48E246580B6A3457E25303D96EB10074F4B5F181A9466237AF006AB27DBC00FB11D404875E371ED3451FABD98281EEF19FE164E0FB91F613FFAE9B0F93570BA17D42DCB77C7343897E7BDE28430070CAEEFD6852934FC70E89C08493BEC4D3B15FF725A48397D0074F1C2F01645E53EDC071BC1805A67D7BFCAB7E93189FFD392CACA64370DB5251276B7CA4554E53BFB681558AB00A8A5C0FB04629748C76942CA7AA17C930DBD9FEF84CA0D85893D5F0A4538B81F0C1A7B873D571E9343A65027F00DFE82374FE4D460187053F925026FB83C16CA0551FFC9024E43470F0C4FEB3E737B6125E87FAAE92B46C705D7F99A88DB013DF4A28440C72B709E367B602B2DEE4AB102E1824F4958A4C75605ABC9BC91EFDB593DAC0C742158A3C9ACE011EB0CB96652BA5D57893206368BF8FF059FB94FE093A169457C6B58A6E33106F3B4B7709409CF5A975ED837D78215BB873AE88915E1B410E1EEF566DE12391543C30A33DB2CC8C0EDF36E3C2F74050802753792CE09E39E2B99FFD0C03E84CEBB20594A8167486E283B9187E45600C435C000966C16E47BF883FF0175353E313633D2194AC26D9786181D05D83CD831ECF40B31416685FF18FF03B8FE1ACCE14CC923CB082C706B24DEEE4ECA2AA210848D104D5FF0C38A4753950AEBB3921E03B8BA00EBC348A1D1357950CFE8604C892205221A4D829734813CC7AF0F8BCB7F6F6E3B2076526121A33CAF7288327BFC89170D89B8CB33243321B2180474B91B6080394712D9B3CC84240647011CBEC6031EA68F00E580E50AC848D73309F713930534A8134CBBCF1A1E09739C33C997D4EBEEE990B2221AD75800E7DF07DFB78D'
	$sHexData &= '1D83C008248DB81BE6B841576B74E49DB75E9058B8B12E28719A13D009BE122863F266CFF3059DB2ED681699E9FDD801F06E23A605984EB92A3F48BC1740BC8A5E2337ED717EAF835948833D72D84F33C03D2D3048BAD5C61A36541A4E4278C4C39EE425712E97660AD6C8BA0AE9A4B94F445823646887B45CF1410AC03364CB02CF3F8291FEE4780F492BDC896ED6EBE9EB4F49AE84006C685E4C284C7EED8948209A4098501053F503501BBAE14904F28360C89BD38A9DF10FAF4803D9B7B7265E6BF210482BDE0EEBE82EEAA4958F44DF07F82011EEBB3310AF18C240CE3F1D0F129FA45BB53D084B8B031CD1F82E5183C308E2ED65B78A21AF6FE74A1BF8ABE4E04A8BC1B94D5A242945BCAE3908740378F15648C0DE62C812813950454A28ED7E100CBA0B023B5118280D198137124C63413CB8ED4D829E9E031AB740144508581381AFFE064A8D4C001845301E8B51EE39613871D2720AD448215050005C0FF0C1CC2602CE7E28453BCB72E2AEE33FBA0A4225644242B0FEEBD3000566C9C72C224DF406B7072ED0235C850F8B402497816F364EF7D083E001024B7BDC8503B0220AA21601389784765786C3C5B0FFB0EBEBF59B58A20ABF32A2DF2D9992231352028A7C9EA6F8A9B1CCECAF4A4F208BD2790F8D1484B84B9AAB6A49441680D445B69E616BB0216B4C7D8B28B3C71A132223D88AA086AD1833DD1ADFCAD8FB7E05146476DA49F7D31274AFD5551EACD2899AB222A44BE5E5F20B968822201482BE10BF6E2360220F458B18D405FAF795C94183E3F841F60004D17413B16D14B1C01404F7E403D15E5420842018D15EC34A8B14FF82B8269610AE034B08F641036637D8860F080FB60CAAF04898524CCE6888C333CAEA11E9CA3D258A2E47D641D430D178C3075A29ECD3FFD0212311C23C3F236FC405702179478417F08CFC80F21FA569B7025C430494A0CEF950AC56ADDA04065528C3C37F0E6386D34123C04180E2664468600B618FB7144CE2BE01349F217B6A3C9AC0AB05DC5501412C1FB3C108C28D8A3B5A921FE13831C7551BEAC390941ACB415D354E7CED5F8259018B080E2448400010C6D682015F1BED0345EEAD6D937CFEE7BD593895450608143030813863736DE0668A4119E65E00221A059D0802CBC21580931283C41680B9A1D06E783C457048EA4A1E6CAC4D606C3E04012A1A4E982CB492AE5B2115DCC18B0267F78A40DE7A7F4BA3F37C1F94B0D624C287B41A566D7BF35B3FBE506DED3347321E1F28BF1FCE36467BDCFC9FB45513EFB25303CAACBA1F2CF4844CBF1E1DC3B6DA3686BBA901BFDF54F2E4AA5774B90C663BB19F4D587A31203321574B5B015F011848360348D11F8D4B77C8A19F018C538128D27AD4D45D4043881F920'
	$sHexData &= 'F26CE9F5C5A08009D70A658BF8BE079B1907E1445F22CD4D71C19A904C15F4015DA31F506FFC1205C16854CC11BC987B2E1AE015FE2355A537019D61EB0825561B15B68501D69FF6097DC2D03704068BC4C8189837F98836548FE3240C50521180C707C19BF8682F382B1FE1BFF283C28B889BF8A6ADFC7EC9383909344AF084B62C9C8E61D07BA8204AB8A03FFFF9F0D27E4D51EDA1BA23C3F7870F06917607E6870017C425E4529555F511D08E42AB69F016C2E9267283078B11C5825138161792A87F4BF606050A89F910379101A5008E61960377225682A6A5F5EC54AC4E87FC3BC8A93B32BDF301FBD0CC0BFC9ED41B55F49B2ED6FD14AAE8A5F283EF112F4D8574B5D68220A0FD0157C15BF23B0045E5A523CF43EC9D016C3EF53BF58E4792547501E6C384C4090227F504A7907303F40BE50E40DC840BFDB1A1A58527921F820D2966664EABF580D581507260F12C3BCBF40EC20E4A119715FB46890BCBE413F0C0CAB765F1FDF402DD416F2483FBF5CB48B5D401F783F3840D361151FFF20024C7292FF7F20FD488D30168D9701AA97BE15BF014A902707766AFF03CC40014A2A578CFF20287911F2C17F5001701523577208FE14A08A26402E90157830C19D36405F85608E651ED2C03D1883A5196B30BA142E181D49DF7F3E9C1C194030CA143022CFD496FF011310081C0E6A8DB971723220575F9090404E32841C0A408E131964E44A401A404E06E4029090800F4CC142DF523EBC24A7039F1E6C1F3840A206BFFF400279859B1815AB112B39FE283F9722E8BD55CA5D14CBE0EEC1484E4480145F911443EC00B901033F38B6869323BF1C70BFFFB0E44E241090C2FE55ACAAD7FF047C7FDF9A2733E3116CFF2051820824BF956C9F11DF26C08830447138BF58BF92CD352C7F505113E5E42126281FBC4888714EECC45CFFC19C1FE6146AA13F5F9F43F2D1B01FC145FF589664A2083FA89F4470218F0E418B9FB5DA9287DE483F48C88963BEBF400213F2E427BE1F00FC9000F04CECC92B14ADFEFF1801BF08993871719FE07FB880A9C00A7F64E02CF852B8086564F74C8D20B7ADE411B92D0F9F51F24A4E80BFAE0E88086962D8EE3A845F1F70382107993F26D00498070C2E071CDF64105E8B1DC80712A003CCBFAB05760C5F709F3F3B212F92200806F8065F0A2EDA44D03FC01F899D1886013F80037F4C472E92E8A0C00C1FD8C51632061F489F48B702BCF001FF3F05C571514CC87FC8BF9E085D31025FFDCE054E2EB62A5F5F04FBC8072B79705FF8045EC8854C782010087B30E1C41FA0055FA8037FE42AAE123F1FC0360AD62E605FFF1FC88303AFD003DF60089890174B1FA806805B059EE89F0DE9A33F1EED346049D97FD7BC5F7036C8E551A4D6B91F'
	$sHexData &= 'CEEC713F6F155F2655C705430AA125F0B5EB4509914E22E119C21497981964E5B5CC5FD5A3C3A315EFC500192EAACB6C3A2010326D243FECCF6BEFB42C49259FD31C7052481B213E9C7F6C29363546E4A2EBD72CD2CE6F7D16B0A2784A087A7221275832381F2902EDCF3B6D6606324F890531A3ED386D206F5E49CCE9C8B71A8B4E0C1F895DC405CBB27FA4260D53C1F9B63091389D0B7F8BA09E02CE15F4C112E7F27DB12BCC8C9076DCA238823E1593617F833DD49A03EAF3DC5D0DB39A3D0B2FF6FE24EE05B81C5705A914660C078BC9C4929A3F3EB70BE4219F3CA8A2FD0A43560EC9DCA1D43CC4A1487581B8C1767FB8CB866B501066D68A062B8198B82F0C6D052716E5F3169A120400E1C8EBACAC167E5F0F6161BE9033F686AFA0708CB3AD743E163DABCA2912C82332E3380AFB3B86D272755814473565A00D2A1067E46667DB760E36AC5F1225CB79F725F4D209D30511260C12B5B4351C13A1CD0174E2CB8FE5C3B84ABB059E8199B44510ED363400010F4E2E0F1050DB013A204E4E4E4E12707C606F230F667FE4D8F20F02D9272727230A22384827272727586A828E27272727A6B6CEDEC8912727EAC8D806DAE4E464E4AEEE988268E4E4E4E4543A2612727232F2F4EDD8C4B019797272A090B8D8A27272723B8E1F8072603B6D1979F8D9500136E8AFE4E46476DB0FA6CEFC727232F21EDC3854767972727298CCF42EDD3C39391978B8FA48DE469E9C8C86F666DF9E27234F4EE62EE072B093912727F63AE17EC9C9C893C206E24A8EE464E4C9EC28E36AA27232F2E4F234E484D0393919791CE55EA6EAE4E4B63D2CE6AF0FAEE6727232F228E76894C072A27872E604E86FC8EB7972323BDAEE0FD2C86CED3C39391936220CFAEC9C9C9C8CECDCD4C69C9C9C9CBAACA29A9C9C9C9C8C826A46469E9C9C3A284CEA5A4E4E4E4E6682A2C427234F4EE602EB264A4E4E4E6E1F545E6E784E4E4E4E828C98A24F4E4E4EAAB4BEE4EE4E6E2723D6E60FF0FC2D27234F06EC101A27B7BBA6011E3F2C0F3E52272727275E72828E27272727A0B0B8C6B1272727D4E0F0DAFF39B9DD31CA6FAE0FE07E9C8C3C39FE14E92C449C9C9C9C5064809E9A9C9C9CBCD8EEB793DB6600AF0F2E72DF94231F6D459F0F0158C057B661939360902FE04F4E4E6EC35F100F3050904438C14EA0CF38685F491EFC0522059319016E089A3816F6BC031E10209DAF817776622F0F37F8DFF4A00FF5404161D59BA36249007600615E00690CCFF59EC6927016741A126F56DD7B7EED0A2A6D2267006566271F74B5E5BD63A5461A697A652E6F7B476BE70A6C2A647B722E6D13758376D963008F6F74DE7BDEFB0E73006376651A6E640E76566309DEF3FBAB63526E007478576BBB77106'
	$sHexData &= 'C73B35336753A6F01C36B37702A62653A730F77DDF9DE7336615B68FB6732D60606E77D37701E639362F0142C188FDE6165ED7DB87B3B726A2A0776476FD3EE28584B286A1F29B6D4C37B22624E74AB7CEFED2D58A654FF7E741FDF7B036C7F523273C26C5F53BDF85E3B5A69A667976F0F4CB887A98D87DF6D27A7375B2E765F1A6401553A5E8787E76B006E7777137257DBF7BF0116067D005B005D003C577B676BE038AB7C5F8ACF5C830FFEBD620043004106480045005F0E4D00475ED6DDEDBD4526522B265600320A572F6F11DC7B3E4400454F0F362FF77DDDC15F6323000B53BB4C4A836EEBB6441FB7325B1F63EB71B87D87121F292F2C76E8BDC7EB575F3F5A163A2F9D8BEDAD6B235F026FF23A0CD6FB6D2FEF677E7483E3906E43702CA7DCBB7D6AB63D57665B00270070633F5EE369EB3D2F765BC160414BAE4B000F1587878E42B6F24D1A504C31A978EF4E5D47305D540B56672F3F3D04473FAE2F63CB747F1F0CEF9037593E4E70363DD70E6BDF6022072DAFE787F7B56D77AF3B2B16960A467BE2633FD73FDEC3B7252F476D5A735FB2A3AB1DA63F68B7375AEC0AF07F7F73AF87EF60AB775F629F6B3FEDE0BDDB6433282A7592668FCE73B650AC3D7A6FBB01CB719CAE63B65F706DE938772B7200797B5F1F6030F6DB755FC357641578B56D674F8F641FEA08A68BBA78DF2A149898AD4B5E0149F3E0691A30539344C24C78BFF75A2F337633125BDE3600341258EEBD8EFBDE5D0E0E3006353E3112E0DD79EF0A1620023A0E866180012E1E2B56FB4AC1D57772626F2D1F52DE4E5AC762C7DD2EA216EF5EF7B0E3BDEF6F1F433655A3FBAB7A2DF0F225477C277780D93B781E25CE780B3F4D9C6B8F41EB0E374CADE95B79830E4B43E34B052E99932F421F533E1ADD44509AEF53533C5CF4D24701E772A632FFFFEA5E2B6C02BF657450726F6365737344504941D40A33E1776172ED474B622B38A8F8BF5C5B5F2FB355EC8A5F5B00630169FE5FF0FF6E76616C6964206D61702F73363C543E206974657261746F7261FBF6C13F737472146720706F733C696FDDCD6E9B8A1F4C6F206C1CEE76656364D4CC5EDA7C250176522B6D61E6B7366261642063611FFF5B6318AB55BF80139D406EB7C00F102F588788C8D98CB87140EF1C2F86B8DBEC76E4C33036D40FCE2F9ACFB793DBB09D3FC81F90C20FBC2225466E3FB69E7DC8C9ED5D9D2EB00FAAA4983478C1824FC2D069989C5DD02D593F403FF00FAA5090139C9C70903FADE09B20789BAF81AF703FB33F9B1C1976B40FF0B5809F24CFC77881A8CFC420A86D240FE4409B489B12F0B61B42903FB30F7B975F178F025EC0C501FC7E058EC8A125E4249C4F6C9C423658C9942FD49C1BF95C6DDC9F054C'
	$sHexData &= '9D240E464E20DF0A4E749D1C9EF49113054F449E3FC09E24475EB4E84F3C9F649F27089E4CB8E09FDF1CA0E4443B2124A09FA4A027E40472CCA034A13CA183AD22219F0787A04F757F048EA2E5B5957CEFA80E087E18A3DF20CF9BE4FCA3075E9C58F9A6905704A4032AD0A4ACE45D242F5E20911C39147F90A5E0A5157B133BC8A8BFD01E385F27DA89E1ACA9BFB4A9BF78AABA1472625F80AA3FE445F25E772FBC0E065EFC223972E478AB50AB90AB911C3972A8AC80ACC0AC1A8E1C3944AD1CAD5CADFFE4330D2778AE3F0698AEB12FC9893CAFDFAF5FF35CF24C029C09AC54DA4CC8983F7F439F13051332B0B01F482B86E7625F50289F249FE6C8F4B0CCB0070CB14846CE4E98B15F70B1B024478EBC3CB214B254B20A9E9C4CD8B0F0B2DF25DF2427A4B3025EACB31D7915600F58B480B4003999805FD4FC270A8EBC5CB584B5DFD0B557EC4D5C9FE81E28BFCC0A7627AABEDF38B6BE5FD24EC4F1CCB67F10B75E28E44572054494B7901305279CB71F04C27985349C08B89E3044B8F28ABD095C1E38BFB0B8E45D2113B8065EECBB14F2B9081CB9FF80B9520C9569BF0AB93FBD89AB17FFBAFF4C1E2061B7E48A5F9CDFC4BA781372A29F18BB201E205EC4AEA05FCC5F44BC27E444015F80BC88BC9D9C5C24BCBCBDBC9113501F70BD985E30311D79952CBE54BEBF5D2F6213905FDCBE3F519D901378BF90BF7F9C48BA069EBF28C0D5F00E221F381E683F13C9A777AC4E045ED4C050AAE779B3C15F280E0D8038DFE144F20A0CC214C3130D2F5FBFECC22CC3FF88BE159B90C3985F1FC41D74E1C45F08C47F4CC10A79AE5F076CDF13B113B228C500C55F30552C172160BF73C5464E98C5D05F06917C6FE448C6200E0CBE78C621ED6238F8C69FC7BE40E079D35E5CC72B261E8CE83ED34E311FE4C85F170CC9B4EE0269B0363FCA5FF8249BCF7FBCCBC8036F12833AF9CD6F38BA41BE803F0AD7233CA040CDCCCC3D28382107E4CFECCFFFA2E2849C1CD02CD07FB968137264D06C5F9420B6920B9C01AD162416B7D258916E68D706DA065F703F80571FB72AD986770C4F794E8E76AEEFA840D0CD422BE4A8073FD36C157A18927E9406389510045DA0DDE81601C7042F430CCB4BEE001F900629F63D68CE4092B7DB2E25DFB5803F985E109797932979B501FF68929877813CCD6002E8C00310DE390D950A932F90961E805B35BC1837F0935701AEA4E01510027E08804ADE54F0F72F0936A0380C05C137E0AE825D04C6DF2F188F088E25EF04363087D88B6458CF00C0014F4BAE0826A81FC0A4BB0B908028CE8F089D0979B01F965067425EEC234FC095807134BA9002500795F7B0F7AE4D783768EE981EF05FC16A38580F2F0EB6B523A6AFD837B7ABE10D1A0FAF0'
	$sHexData &= 'FF6AE0D4DBF303740179FF6B048A6005F4FD52A34AC5F8709CD29E4D5EFE8921003E0494E249B96B896F8962B7913C86097C0FE00DADA14C338973F5037A783556110378F5E369B53049F6804B09788979A939C48C8973098E0E404F24AE80308981732C9292098E0684C21279004B09798C436031E060899CEE74F4C93E633C0A898808FFABC6B43C03FB0AEE0389939819C608F98030899436C6D0A2037B76853C809A6038F60997892A9BD6B3788179F006135392C478FF8ED40EC6F01110F8A065202309E4C8E6CBF9D6E760197105216384655469BA7BBCD9F921F01670632EE4DC1BDE683019F5F47C5061E6EC766DB6CFF1D0C001DC40B06740A5409163408A7F99AFF3219F017E015D01915152E1564150F9A4FF7155211C08F024F4B350E39526DD8F3660F491E3B69AF0C4A0CC1DF7ED701112E17060017340D067213C0117010600FF5EC6B0E2B4E440683520F111805CF30F3DFFE6214C01270116010304F87A7B46ABC3DC4AF0904F6423FA2CEBEE6B74FEA06F0520F010A0FEF0FDCCA560A32067001576E13BC232F370A5206988120537AEDAD5B77531F160E012A1F21DBE65974B6C4562BC5B621057E05340BDE72B00627010E2C6E2C6482838B45C22734C670EE4AD686AD92D64AE43ED40E3DC4B61806FFCD38640D4209F00770065005AEA60EB6C2531F5451019F191346E2E5834A671F600A56320650DACCD34CE03E0D621FB540672B3707109C479DE023DDA753877036CF8036D8FB6E9B67B51F3E1F3D0E01DFE449F3BC088212090882F2E442A68050B0359C8C1C39C235E035505D66C3069D117219643614347D663BC3067262CF30825770101240B08D9C6F3A12F31F4F76C7A2CA58252E2564BE21341096DC35ECFF7210F00EE00CD00AC008703F022F03309990176F389DA0B5E074F747160F90E371E4E0C1FFE053460E9B0EE03C2F35570E01DAD0BDC86326920F0E043F0FD6E09C4CFFA0AD17CA1F692A03C19F8028282597FFFF20340F0012720EF00CE00AD008C0068032C90979089E1054F0826F02790054502E400C9F8E1C3972C00CF10CFF0CB30D70912347DC0DF00DCE654A8E7C9F1D543A54A8CA7371551E061E740DD60C0A457075BCC037A7D49776E4ECC960C000E76F0187011F36251F5D3E876D54D0F784BC922BD0509F6EF6F2C990B0FC0079FD2F890E902B39E9F7909DF819699EE70B0A0852F83CB9902BCCC0C0F02723478E21F139F1C0CDAC54DE27111404C609702083DBCE2A333FF0DF678ADFB71F06503E603F06CF604F3ECD80C5964CA57406278A0D70FE013904003967190BE2F6E906F80B420750068EDF48191D369B6982831DD6180EA6522F77421E05D7B8A000554E54C291072E30B1B2B1DB1AF9E0B61F3ED7'
	$sHexData &= '0E5521EDA75D342B343EAD06AD1CA10126046981853404E702B3EF8603702F5096B0A9DFDD75FCC891A93AAA191F05000D5601735FA015CC0602701F2008EF062FE09E66105C59DCE76A7802CE66D10AF880F408E409BD85529142C45E740F700EBCF79A895F9A9A46912E316E2CD879DEF327196614055F3B33BC1D01073E07A20360DAF7205A06CFF3BA4F6A48A2F70CE604050699D8F33C0D0B0A4F7479DE7BAF74466F2E1E5E13560E051196D9DA4FD7620FB88723E582078F1EB72265A8E7B0E71F9136A9C22176824F0234D62AFF1FA28F984C1CA7D0A22FB011490E04B77055148702AC87B7B003CF4E7ADCEC1E04237A0E97707D9CDB044F85550F942FBEFBB51B1E1F0F4E0F640706340E320B701F577C85ED74320A54D719308E226418826FF80DA634170012011276C005700450DE091A3CCD8051E08A57BF3F39B23D18DB1E24C23DC23C3939198BA1BD1934607F6F573626641BBE341A0016B60BE009D0BF62F32A721084BF5590BA2367231F77ADBBBD1F2CBD48AD2627276886E7E06049369BB316B468A9272BF1B8C0E2D4AEF680AAB6E8D96C2E3AABACA40F6E0FE4366F34279E0A05263F9778DB716227014F364F546E084204C043BE2AF1CECE04560A811B39C54084470056300EEFE42A672F1F57465F0E014123E13C7C5FA9A7B4EBD34E6091068C34A52F4A71B4D606012747AEC63951BBBA0F01080260CF3008093914653FCF708416A2377C1F234E1A7216D0D32F9C9247D1CFCCA5B8A523A7E484A0566056F00C53E0456F6505DF0547DBECC9C9606D7556CF842FEFE9CB9DAEDF6F162A0694CED10287A61EE6AE058AEFB9C12FE7926F06C0A67FD33A25F6640627AFFE06BA3C0C2CB4972F0157023BED0FA750FB065FA7589E9ED627CE04C607A6B1A73D07F90683F4BFE6D65CAC9D052F4E0334365C85E2023601301654067DE34026BE53B7C152B2D99740F563F52F5B365BA707EF1E33F088A717A7F682EF490674A767C4082754061B86F6606F01361E3616A053C1A5DE096526659676F981E95F54C6153211C0EC066CAFDB9E7EF8DF178C06E4B77BB0533B9E2754076F0110B6B4DFCD661074106410320CAF80EA069C006B69F82CA8D727C1816190A716DF20E916055F97643EE9174C0670A8178736182D27166FB0E688B4846CF6CCE62701BE69D3162C6414663413000ED29B06791A2097A06A56CD641C79E01AE187E256988C9C1FA0E2BC172A0EF0B4D506B2304F2600135BB0762757270127E4C2488F266440C76B830117B6C70F2766FB994397076001148614641C35FFDD14540E26143210700112120E12705DF85FFE12320EC00C700B60EFD0E4046F08B75716B9A7F0B9165868723ABA390E34B53E30584227AEB260A705D91E9'
	$sHexData &= '0B2460027CD056BDB6F277F0EB2589AE78206570C0B529BE6792EA7121110D2111F0DFEEF351F1E176E099205C00370026097006EA19F918510F0320047B83300DB372457323400305E1911FE0852AB10F6C20470C2275F03155E8502FFAA01D740879DD9925727201FB0307B79F90117D130DF300F312F2058FE2E7EC74D570127F24AAE64606064AB5C722513907040469E9C9C616F9F3090AFE94E4E9D217F2BBE061C6F69BF8BACBF170E2C1E084AD407D88AB50927BF277408DFC6F86097010D068E063209C0076031B8B605EE01A03EA074070AB49056EEA126A18FE8A874F290850E579284BC1A1E8F905F94ACB3975CC9E0C020F6375F447ED291F674F6DFA7F64570255787EDC0379C905772C030AD30588E9CE4941058F0F12FF2CBCEA63607F28F8CF22F7E2FC0E48B973D580780EEDAC50E3441364CB39F1F6C5E6DC54F47A0DDBEDD6D8EB584274FD4068A021B033E0CAEC7279FF65D014770A7C806C914AF6895F67B7F1721C97E500E560EB7B5050C0EBE2FAF08F5F1F660771115560C5208708630F32E3869FFF060FF900E017186CFC9B0C040C6477BC6CBCA971F1F9AC6BBC600FEC6C982A9C426C76FB65E89B6082E8C2E17E112AF5FC0160C962F5F77CC387AC701471927A6B27B8A1F503D600350CEE62086EE7E52839352D057873FA787B63B465E678B1C9E1C64140654131BF0DF6C3412B218F016E014D012C036280B5F7F83FD0028342400184836F00AE008D006C09332B2831A46475086E062E1EC73F0904EAFBB4F8FE464E46C501F0E5042478ABC75E7547B603F0E5662BC5D54D780D70059068CBC7C81211FAA21B7212D9082C30A9634141E530837E1E917B05AFF5B6242E3A536184C19CF1A3C9B0DA73F9017EE05188CB0089306DB0526744D276F951982ED4E06014A36AF91E7E385D8190C7E3250506285D5E0866FFA1562523C3A70CFC7261FE0B0900BF98459010048592E37F4F2E03E093F870EAF2E7BEB136D1F813F3F8E6F4F1F3C0A96593F1087961B06004DD080E61B340D5276709A2F32218F824784B1A0723220578037388C1C3972384F385E38A00572819CAF4072425EC94028B2005A1CC02553E0C05F3434CCC8E9FA97377C700B366F878E470F5A83033881708787E442AE827037C46064E424AF405AF035076EC1EDE415561F65778F5D48F209CE6F5A2E91C6DA1A7006C727C2A8877C3F64011E66E150E817F61E321AF018E0D7500135DB23365654345E0B06540A52C8C59D7A1E4020540D1E0CAE66001EA087B75A4E106B5EF046A90E0027C00AE206B5D316E8E4B347FE052F1982FCA0475409BCCD8267B3667B0620B4620E627417A6077BBAD47709083F010CCE31001DC00C427A50371EC9143287876CB4009707'
	$sHexData &= '1377F05AD0037097530F9802A80E36218FE4E5F05AFD5A00881772B41B36F7E8209173CCA45B37FD4F51FEE0DD77D961FE1F3E1F2D0E8707866B385F4F07308879154C21300F70B5E4C893095040FAEEFA0E723272FEFA505D0F02A894D52D873019296FAEB2670E79140F6088800F91B3CF4990A060D8C7E2D837DBDDC860D9B00EB72EDA1F440EF01198BC021EC2C70BCEBE3B70B75F90D6B0D19F28D2A023474ED27ED2B6D29B18F8D2CF5625D1FF0017C46ED2374B0694B63F0927ED4B8FDA12E6128E0D54377FE008376AC77087C78D7CA627C010CE610E97230F9EDB1FC601A60DCF19A9FC1B94287E1534110008D20470F0918FD0E8621FC77F4AC823474EB1C867208990B50AF9A0C891B629B6270EF4E9F084B77E923109DC0D161A26154214010E0251A5B32FB35E9F50080733E0C8765F163092F392ED93874F3B0DA7B08C06DEE0B75E8E52009B1313C42E96243030852E370180A041EF0E097205D0F6308791B39F7480897F802CD73D2D340F80C81E2E4F1E1D0D7803D218B076B2D76524A6D05CA75C4F97910FF10E80253F7D262792A273CC8C279F28D7FA29074973D1ED2AE72BBE1C3416F247BE9337E0D67230B650235D246F106E2323D719861A343400F21E00E7090130DF8A76015CE08133C0274F70793703E80F2FA00E041C39C1E7B0C01C5F581D741D799EE78D951E03B804C60CDCC8E7051E1E4C0E1C241A618FC61AE226104C2783309A27409E8C3C79AA805DF0005D3CCFF346300E035001607282CFF30570A01A37FA1A478E1C391D1B391B5A1B6D1BF6E479238E1E06AC6E1C6F2B359770821C1F2026642D84155D0FEE2BC6013008708E6C30C8E74E47305EB05DF0DD4E46F0102F200E40169123474E278E16AD16CE168FDB0CC4E9164F17E722B6D92F6ACF6815311601000A7009600850EFE4C89393A0E0605EA05EEC8ACF6DC02FD030124F12AF3972E4EC8412FFA312C412DF12AAFD881C8A13CF64FE184DB2C78716D7CFD08A10457E005E06E0447F5F455C3054C20EAF4236234301864999D0BBF7A6D96E07F6962F01131E13540B06340A779A15BE320FE00DC007AE4106EDC16ED298BBF70C2701175E17FCFE87C2540EDF5213F011E00FD076601926CFFAF6280614D6D20670056007091C3AC0008B0F2057B39DE4C86141A941903FDEF13F151A026710BC170ADFD37C616D3756060B8A95D6A36B196829546049F7FFC325344ED214E012D010C00E700D60EF30666046E0903C573DCFEDF67A468F7676213419AED2F5748340C377606A1C397B439F5F1E3987393A863B4A4EC4986F908B904327DE2F37E0BCF29029995F5F6037F2F2F2F289379A37BB37CA37C58032325F5FAF0B0F1B0CC0472506660C4317B610572F2784674'
	$sHexData &= 'F2682BD47C0202DD7DB2D3B272367F7192EC0CE8754C2F4C4E70ABE529B1DDFE0221EA018BED418F8BDE284C526278E84BC421456309FF08B1EC82379F08B40BE0060B61B2A5F10FF00D9CBE91FB9E487E03FE60D600A3672F60E8C06D07793D0B61FA14D9EE7D401FA77DB8C3CC4508CE7B0D030CF97CF731B39A3CFBF1FDD01FC3EAD3526B78D068944BF625F270667E41970182FF0429E660B0B040119144C33D0F619D6197D3D0468DAD08F192A05B62F184C04B366012C17804E90438FC6B4EF609F979FF0DD1F500E1086674F865B97979797868986CC86DF86F99EE8A5938608CF182F1594EE03DBDFB0BEC5EDC8D962AF076313636F37CE8850717029680C761B2EF053C521AF30C6E08C607F5EFE5277700F5FD7765F6860CC5E465E7760615B611F9B38169C9CE9131FFF6E15C21C108D472F843C3A065CFFC0C0E407E1C980F0216FEC2206369960237F80E74015CC015633094E3E56EFE2087809E007D0535F3F429EBCD9A301DF04F6053CC13175C664F0DF60576BB74438B060670FD03FCBC897C2901E3F341F1F5E5E3EC23E1F874F1F8820BD20E9C9F3CC1FDF04EA0E213632A552576F35F0D7B043F8C6661AD60DF25304D1386F86D7618DEC443066674844A3839A23C60E8F08070EA8C0114E06874628DA288115F65CC2D727871C8CC057547042AD7B8F38A606A06F1636165A5B8AB08E11641E543FD88A3FD51604E004D002DA210C5E4D1750014E21F621219481E2FF321DF01BE019D017C01570A7A017F026BF3F08275F2999904300C361F2F2F290612031443152318665E4E46061616F6AA583670A0917CF1999755222BF5F8D7F70468E3C38800E20CC77CCB80D6FB7EE0E3BE31FEE3F017B0E7BEB1544FBC4100037E4BE2BDE0A8206D040D786778F11264E2674262225DA34952E1E1A0DB2C3DCF519D9EF008E90B0933F959A9CCC8E37951F45FF9C80CB0CFF500E5E60E7F644EF97A001A704DE6DB01FD00E80B7743502E8146737FA35170836EF0278F25E0E031E363B366AE0D3A6B79906A9DCC4570CB663ED0B27FF275B4B53093E17B20707B5D0970097606680039BDC6EC796E7AB4F906790C505B7F02F4F362C00A6D82E4B1FAF0A4E806F60AFC06E702AEFBE2AC4392547D62AF08E8F26BCD51F1FD7ACC501B13021628F135B17E070A6D7A73FA79F53016E3762F7208F2E07D214A11906694E68667484C26F3723031704567242DE6734C650629CE759E826BF0E0240D6D937104F701E60A1173BA2F3BCD944EFA2BF691E02BA70B327CF03D348A33F5C0E26CF1B79CFA39E1E05B6DEC0230C1F5FF626EC5001DE1B8E0EF21FB78D3A3850AE7A4F579019AC91A362FE2EDE653A39C5D9F331DF0B326FB6323EF87F132EE62D78276628'
	$sHexData &= '001D0153000FF00DE00BD0F27DC0C70F0530AF80C66A029CDC7032A0B027C0D0636423F10326E06262052E5776D6400015420042A767F632F204434355432F9A1D79BB7597D41FDE4F0F442D4453CC6D9C3FEB45C7468F6AC891B3B3461F74467F7E468846E4C96DE4BA46BF5FF701478E1C39720B47154747474C47D9DB14477347277F1FAD477F93939393B7C1CDFF71E4C8D904485F064E104E1A4E0227474E17264E564E362D42D23C8632280FB02EA7063E32013F630163F3AE8C5B0ED70E038D7C8CCF3030376FDC3737DD999D9DFF3B382F53381FAE67BE72BBDD6E2FC31FDB3FEA2FEF478E1C79CB39DA39DF39FC3970E4EC04DF083A4F3D3A4C3A63E42D012F2F754084FA7F72BB3F891F98196E1B005DD88A0055C8AAED57820AB88C0045A88D96988E2EC4EFC0FF888F00337890002F6891362E011C012401CCF085DD1B0B4FE02D3D19F99208F04063F3DC6EC8FF4FA02FB004C9F33CCFC005D006E0E464E4EC20641F30644050DBC9EDE460702F80901F93939393A0B0C0D0FC6EF2BCE00E14F0004F0065C9F3468E1065200E19303CCFC9C94050601D703CCFC9F31E80901FA0BD9E38F721EF0E8D661F2A4D77F20F1F25DF662666DBC94D69270F40503F49A5E99E602BDF662C66E4796EB70FA01FB030C0CEF33CEFD00E32E033F08E06B4842F678663FF634E9CE9643FE6641765C391539D6F29651FFE65176657F33C4F3B1D680E092D06AB70D63DCF05DD0A5F686F176993E7CDCEBF1C694F391E0749473ECDD9626A6F946A08B56ACE6A7CDA9123D36A3A6B1E0D516BECC9F38C8D0E9D1B6C8F91239FE64D6C0F6E6C876C3D79DEC88C6CD01E0BE05E6D72E4D39C6F906D0CB16DCA6D23DF333BCF6D4FF8106E086E86473ECD916EB86E11D96EF26E3ECD9123F76E256F12356F7C9A2347B36FE56F1306703C2F378E1F70CF1E06E6239FE6F3140C711552713EAD8370B3723FCA0E3D731E1AE479463E14738E1BA2E7693EEFE70E1D0E741EADCFF3349F1F707521761FA934DFF33C22D824EE177625CFF3BCA70E261E7727BD28F2699E3CCD1478292578BC91CF33F92A81798E0E26799ACFF3C02B0D7B2CB7F93C27EF2D1EDEEB2B197CE7CD8E1C267C367C7F802E259EE7799E8A1FBC2FD61EC8E73979F3FB20137D9EE6ECEC477D6F517D3F837D2E9D9FE6F34EFC1E30D27E311B7FE779B323337F3F7F1E329237F2799E33A5340082320E87E7799E32621E9C1DFE8E9CE2C8CC82D982EFE6821683CFF39ED2BE350E041E5F008027CFF33C199D1CAD2BC8D991B3847F38846A846F758479F29EDB7A3F97175EA72585971DC01B570E18AE7485A08C90FC918525090017011870AA8D73C6B8CF20902F9B8089DF676668016801AB12D82A771FC77C998'
	$sHexData &= '9B7506F2067970EF069E50FCC21F76A47226A936BDBDB3A1F486A9FFF804ACE9EBC407EB0BD695FD5699393E764B050101D0E5912933567AE421F6C9A191919347E3215C0E6266811E73F18CED41EC9224740044F165568E8846FD046D02EB5B7A97F105720D137BFE494BC9268201358D1166CC7092011BFBF4EED94EC3710DA86DB2740EAB553724A64E85CEC9F40A70033067F54551B50014888A024170650555BC95310000166E0086CFCFF2E3F4156747970655F696E666F7CC6FEAB4CF5CD5D20D266D4FF01FC9F90C47F3F2462617369635F6F667DFB0B255A65616D405F575526636861725F5E66EDBD1E6169747320403464BC0B93A3D87FD59F66696C656275669DA10846043F3D17EDF6688F5F49866240484F698260C16B485FE2653D3FC55605376E377F45B0A061FD1F250C82629FF02FD48E97A75C616C6C6F636A5B7796342932CBBFC12A8EB7B3635F8528B8419E596D1EFF8BAF476469706C757342351756FB14C1520F496D616753AB35C1D14F4222527051DE12FE624F6578636570AA4E74E30A47326D0700BA25A48A7FC65F0F2E54714F4F5B0880406F517598678A80602907E6040132101093F74AC26D103F7016B2B2D97C9EC0FF3CA040117B110381CF3390BA289BEF229BCDF6C413767CBAD013F413FBDE3BB6D87506CC46800E9D145F3B9BCD37A02E0D1564A2101506C06936DFBC8E40168417089ED7ADCB1F0F7D16787D799FE779C268D09C1AA6B0086CB4DE0EB8E85CB90177B6AF5F8C1E8ED0B80E69BEEF234804C1010FE516F4AFF08B40B7F5432366C0D39E4FFB8776255E9480252A1620004780BA0F1726C5F679DE6BDF78161880642E46FB26F8CEECB70EA22EDFB00EEE32BEBEB37D67D8C60E7E345E5CAA0E713601F8DED91638C40ECC06F0C44B00077FCFD240F6C8E7EFF7A581AE30C7010F4E56DEAF7C9AEF6C5E50561654A2D0B85724DC7D33FFC00E145ABE46EEB4DD9AFF0FF65B16200F4EF369BEFA16F8A1FA035CE8DA6E5D12370FEC5E16AC5F775E770FF0167C0FF9066CA16FEB4B01C73E6200FB26F816460E7262DF800E5A6306B37D0460C8BF070F86BEC4C905DFD3BE0E35872E5C400E928B4E1C8153F13DA00EAD8CD69C77B75B31370F5A8D76160F6B16705E6316B4B769BBD3760FD28E162C0F458F1604BCEEB4DD0F4E9016140FCD160409A7E0F3D05C917E54795EB70A670FA81620A8A77D4FF3299210300E9A93EE70ED3B1BBEB00EBB96CEDCC30EB79716C08053F1290E5B99A6489DB65B87BF0F679A16C89ED79DD70F7C16A40F802EB480DBF339798490FC9BCF16009C46364736549D609DD19EE0B4EF29F80E919F1E5CA00E5EA1EE34094EC7A70EFFA4C6006E147D4FB32E6AA628700EE0A73E88C737'
	$sHexData &= 'C5EE0F12A847200EBBA867EC106C6F0EF22F68F6AAA91A3E96F0A47F49AA56242609EF7B500E73AA47E7F379DEB70FAD1698ADF5AC09A7ED4E780F2AAD1660775EB766670FCE16080FB975A76015AE06F40F2317305D82D3F1F3AF1E8C089E2134DF539AB1840ED5168CA0E070F0EDFA3FB2FF0E6AB237E17D2B86270FED0614B6EEB4DD0E0F3CB316000FCF170A25DCEB0FDD06F05E2FCFD37CDD0F4E164CA44EF93CBA354338570F7E3EF7BAF316DC0F8906CCEF0E5FB6EB80702A46286F69B70E08AF0F77B9E779DEF7EEAE010FAD16D8ADC9BDA77D9EC8D049BAA69C500E6B3E274FF316289B708B90D9BD3EED3B0B7ED4A30EFEBE165800BFA57DF79D5E066CA05E0EF7C22E7866F3BE45C3460688A916C4E9C4DD3A299C74DF0F7638CFD37C16709B767E60F7BA5550570FAF0658BE64D3E2750FD106482FC536C6483805DF0E33C79664CFF3BA15D70FBE1654BEC9A7E0F33C44D09FC806F482B02E083FBAD376EB7F0FB7CB16380FED7B9ACFF31628ED09CC18200E11BEA7EA04CD3670100E2BCD1FB46F822F0E09CE37100E1DCFD6B8B4EFDEF7300E0CD016BE760E0AD1167C06D665E0AFEEBC6E5DFF0F8116800F3CCFF3BC941670949A60B029BEA7F9CBD220D00E23D32F3D7C9BBE300EB4D3EF0EF0D39F216CDFFB0F20D42F0F5717D37CDD1AFF0FF616F8ADF63A249CE604D5E8FF7CDD79DD0FC8161C0FE92EF8A8DB9DE6D3E91AD6080F33D62F7B4AC137400E26D736680EDA16EF153ECF58F054D817600EF1269BCD82DA36B4B500DB63DB8E6CDAFB0EE7DB475EDB88DC90DC2784D36C92DDACC7BA53B05B0F17DE66D40F27E3DE39FA06C4AD26DF0608A6B66F6481800689E0900EEEE2D6A8A8D91CD96C20E397E3A0E338E4561CD91C40E442E520E6D6A9E6BF754958370F10E7E779DD6916940F2B1684306DFA349FB8F8BDD086E8A758A184F70E19E9170FF3BE154A4F0F87165C799EE7BA0F95371695B13C8D12DEE7C076EA8F4FC1EEBC6F0FE616180F01EB365F467C4A080E99EB171656ECC22A252C2F9EF7AD526F0FC716D0C7799EE779D5C0D5F1B0EF6936D3308E4AED30500E7FD60DE1B4EE2E983F799EE6EB0F4D16B0AD4D90A093E779DD0FC02E8CC0D396B062092F75E7752B6F0F7116600F88E7799EE7165088B340C0767C67C17BF1069C9F0EE5F17FDC7D4AFB0EDAF2BE000E37F5165EB4DD9A25970F07F62E28CFF3BCEE0F11161820F56496B06CB6AC7600F757F9BAD37EABA70F27FA16DC0F319C8ECFF316CC404DFB7E4079DDBA256F0FA116ACF6799EE7A1A39CB0AAFC5EF029F89E24B00EE6FD9620F0FD020A3FA077B8B40157AF3BEDB70F0BFF167C0F0D166C0AAFF33D100E5400CECFFB2606060FB71658B736DFF33CB948C00EC'
	$sHexData &= '901A49EC289F069D011038ED69ED7AD81C70F7B16307B749EE7797D2080A33E87C5F72F0EEA04B6E70E4106AB82F06A78FEA7F38D6C760FCE0900B4E906F0B3B0BD5CBF0E550A01270EB8176C76EB82970F710BCCB3FEB0F08D7C06BCB307260E691F59D806D49DBF01101604E66B74EF100E77060F80165F11CFF3349F886011C94CD00A69EFBBC012016F0E1113A69C0E20857B06EF42064C7F0ED906EF53DAF74EE00E3816EE740E981817E6B72203BF0F0D19E479DEC8E4BD4216D042F5B97DCBE7F58B1A0FAF17B04FFBB4F70A1CB6AC0E10961D162CA009BEA77D0EAE1FD65CB00E8122378D6CCEBE900E9E242FA024712780C2FB9EF60EB428A6C0C00E622B2F2A25AC51C7079B239BDF0F1E2CF4AB452CD0ABCBE77923EC2EE0EC102D699FE77D0F1E16C0209B2ED658F7349BEFA00E38305CC340AA06DED96CBE3C5EB0301A31A8AA0E6EDF8A21FC06D8C201870F143ECF9BBD327EB30F27162830A632F846BE391FB0162633300EA3337C4FFB66E7B00EAA35A6ACB00EE8353BDBA7D95C9CF06D36D6A0B20E6C3ECDE6BD36EC9BC06037FCB1EDD36C8EDB37B4BCE06F382E58BB751338170F4E393BFB463680C2600670C20FD13BD6BA7513B876FF0F75F33CCFF31648758B38907CEF3DED553E5E20600ED8062446E03E1B7068F43FEEAE4636BB35270F6C40F4BB7C99B2CFF316E480FA4077D0551BB8A706D9B02E8FF34636BB0F824284BBE81674B35BB781470FA2437764736448BBE04338BBD644663ECDE6BBC1160E0246FCBA0437467DF7BD3997380EA306F899A60E0F478D6CBEB306289A0ED8472C9AEFA7D97CD72F9B4E0E614858A368BE77BED9C6488FC816214B5E240E5D4CE79B7DEF3E16600E9D4C5FA40EEE4DF3BCA77D2E084E0652AC1654B1FDAE3ECFD4C0F84E970F304F6936DF9B17B00EF106FC9A0C50BFDE049FF61C9B0EF0535107540E71F1F139E1069F0E0F521ED06DF6FD00BF390630C40F5E179C3C27CF698383C4C473E473F2F0F012533053F3799A4F47DC9B50674C9C4FFB3C4FA0D8F410540648C49EE6F3B49D166081949E90B138CFD37C109FC0E18C1D611AE090C6555EE7794EEF0EA206804716EF6C7D6F64C10056062E56600E920668A5D92EF4DEEE0EE106545E57463C57BC85DE1B400E610698BE2E8C9EE6F39C90B12CABC0DC33C07D4EE001588E5F0EF3BCB7E02C58DF0E512EF060DEE479CB8ED659590E7B3C274FFB06A4B02E809CA0DBD39EBCFB44B1BE2EFC005A063B794636DFE82E405A5C5A60B83E274FF38CB2C0E6F0115BCF7B230C26960E4116A85095A7F93C7130B5B0CCC4B279F234D0EC405C6E5CC8E6C933C0E6005D2E5D9E3C27CF80A6B0E4305E73F28C6C5F5E6094E0E7B9BDED0F5FBF0E5C1760B8'
	$sHexData &= 'D900EFDDA0BCD60EF10644A630CDF3DDA7062100BED60E9B60C0F0F23C1B3E0B619EF4C06161F21C7C6F0E6106C8C2AE6161FBB4276F16EC0062061B78C5166CF83C4F506BF040636E716364BBE29B0E196417658EC965C6694FDE16F96067068B27CFC933A716BBC0D9E08C6C9E3CF91068296830BBCF73F2495087D4CFD62EF7B6CFC9C0F00B69770E47066ECFEDDD84D05E0E8B2F90AB47B069BEE779E754F016B96A044145BCEFC00EF26A476B71220144AB086440040802ACA01325C21C021201F68D82EEFF546C734656616C756518FEFBF6FF4C6F61644C696272617279571A536C65657028656176654372A06685820E634A5663B7DBB6A11F014768466940417474326275748077FFEF6573572754656D70506174681AAC4C29E87D371A4572726F723723F9D67E10416464725673AA456E746572B3D6EE6FA46E64436C6F7365600C62324D9E7ADF7BF676795374A475734578414E6578F7C64465D8EE68660C8E8D522CF4654DBD013C382E78C541DC6DF7B59F12B54861846CC0496E6A68697A602078A97F62464C09577081598653790854696DD673EB29A8FD391331437572466E19ECC0DEBD49642954680A9405ADC0D02751AE7E5006668C6DFFC0E066F052436F75F346746C43617074154F70675E2422A425026FCF0E07F66B757046461348785583C305E656697242556E77007633B30D8273F2EA676790FCF8E0011FB487DD3A68B764458ABDC10AC360D933AD0D464191FA2E6DCA6167ED36663C23D8636F641C6F2A6786146B822C1DED7CADF9B7836BB33857616974466F725367DE4F826787C3626AA6F0C09E4488ED70F8781A6FB9BFD5D8524C1E0947C50672735D645BA2C71991B1E416D12822FCFB4890D81DF86CB2DB1E406A9B99140CC432444327B1ECE04959796DD35998E1B95B3A423E234112703E4D68066865B2827676C43547728868F873277634C1F6C9B5C0D653A86E30B19580CB35CE8E61B79FD88AE939486569676827445D64EF6B50772952F64927C653B67830351E6FBCB84D042BE08E1459DFC4C46B1637FA5BB417E595697370F09BC10E098251BA33DC16D87F484249544D415039253B368F23C84F394921D46C6120180A3CC3414C3D6358C1D5146E23056FF898E0576964BCA1506978CC4F666673EB50C066149DB96BABB6D3201EF15589F95C387D6D46E36A1F886125E024F83F5F4F380E5020B2F8F8405F015406720F05B41647301751EFB3DFFD45414158585A574241444F46462D335F4A42266967B71B6D143F24F5637674805744483B32560E6E6B8730D4A8651240414C5870300A308CD0E8C59BE0B5FD59413F4155745F53044A744A4020D0F4B93109CF586C74FD30816D645F7234705D5850454244293038F'
	$sHexData &= 'C3F3F315F716E41C13625DF4058313048A5146A076C30968A5F65F4A570D9E357B86175CE3E19F090E0B0475F4EF78E67F16D0B1CFDAF0D4B432030754DF2D456F769968E7D63DB4CE465468C70659144555F1AEE5980226640EE564851106809354E370B98A1C313364240A57048B80EA1A805C1297E180E0CCE01DD4F73667840601D8B08072BC6A62278680F498103141C2AC474989342B0631C1F8656CF050C431B501379690D8198C51540F9EB12C512B33104DBD9C1300A8A8240B9270A93A918BC5038BFD5B3418256288BFEC16F41C76747893030876E82A4D1E76347240C43212FC7315517019A1A7066CC6853413B5C8B41682D3F36813B545B7130944D40835F4B85C9546D54834A3255C35148114E31817B54503612A738AC3A4B221D32BDD5761AC5B1D35E22B082AA0BAE4067368A062D2548AECDEF8AE9690A699C65C1A340819B4DF5F8421907B4D7545D797299484DD02E0C0B5E8350C210E132E50CD1785B482668654D926765B02103254166462668686477474768210A36C27E8479631B8A3DE302CB5587A2765C98550F4C811203B4D164794062B809843FD4195F9C860153E64B80566661C2BA11B5634E404B25340C90601B720594696683B9FBAEBED448B8488C4431100F8F5013E36B52636C3B20DD6565107F33696E7DEDC3B651E10E6F7BBB2E48849B8C776179FC6E6F6907D86E846E76408F1B8F3088B4188362AC98B6C160A405495DB1622B713340A555DA626A5C5B42F435D44B45370A46532A70A51EF5C3838E5531F7002CF263191A306A5F09B9D77B93BE166D656D637010737172741B1A1A10C8BE425F63385E64B0825031F6613602A46BD79CEF146CFA376466A676CCB2355F4E7458FC3DACD240309D74C125B37B6B5425D2F082C13BA1CEA75F680A29437070582E86CBEE5274575FFA16412F35E86A693765096424D959E860756C106607D23679E305D6BB5F19146D957DB719CEC9184A8524CD644DEF6AD838277537F934703DD4A9418A66467972BFCD1EFE2B787846720A482533266973776469670ABF7171784E32F758EEB287EDF3307072206690F8746F772203277787F653134B330E5527335108B107296F3B5A9D181F1030C9776828AAA36F0DA9B9429FEB2D9636DA3BF5356C81F686BB51FD43FF5881877B6D6D6F76F266F477634F61EB7899C718B42D742EDD7B110E660C2E4E9E25EE9BBE656B69363426ED3777B036F945736E73E6781E622D6E8076566610CA3508A70CA4A3453389B6E70FD1415866DFB9C76BD616096677D2659B7A15F75A6F6D702063D95F224275F702D4060500393464016ED6581D6620369276BC4AD19C2AE2572EDC56DC6636D55A7C354D10AA7C15FC58694540756D4368EA6459D3C5'
	$sHexData &= '9A2173CD734250DEB3B3D46E3FD33049546B0780521A6B511D6B7B773A489F953FEDE0B297195D1080DE933C2A5B6A6067F06C3FB3D302664D6F12A27601F11C11F27FC866081858081008F0200908DF8B3EDA1823F0787E28504828300A6050FE47A4FE583028285828000A64860600DBD90769AC3F0430390022200B020A16D4D20A9A0124B6B09BDD15906D80121702046ECF695D0509000F006004229FF302520B1B7B40690D1F4FCA40DD15EF18C62F48B8A5D1283040029A81CD330E2070141BC85F857C500200B87001001006C1C159472EAA7F65EB3ED260F7042C57CEF50F203ADB9157F52E72645861A6900082676E7B077F004CB7CFB175042E4D694FBE750F51F7E24F47D0B3C02E27EFE9B670514F20169EE867C3B063C8D0390C7263594026F9E4794E04FE87D0CF65DE4536AC76560C02F40602EF7B27CF4F97D0D14237007B650F922449B8D10C00005049FF0000000000000048894C240848895424104C8944241880FA010F856C02000053565755488D354D38FFFF488DBE0050FEFF5731DB31C94883CDFFE85000000001DB7402F3C38B1E4883EEFC11DB8A16F3C3488D042F83F9058A1076214883FDFC771B83E9048B104883C00483E9048917488D7F0473EF83C1048A10741048FFC0881783E9018A10488D7F0175F0F3C3FC415BEB0848FFC6881748FFC78A1601DB750A8B1E4883EEFC11DB8A1672E68D4101EB07FFC841FFD311C041FFD311C001DB750A8B1E4883EEFC11DB8A1673E483E8037219C1E0080FB6D209D048FFC683F0FF7458D1F84863E87238EB0E01DB75088B1E4883EEFC11DB7228FFC101DB75088B1E4883EEFC11DB721841FFD311C901DB75088B1E4883EEFC11DB73ED83C102EB0541FFD311C94881FD00FBFFFF83D102E81AFFFFFFE960FFFFFF5E4889F7564889F748C7C6005C0100B2045357488D4C37FD5E565BEB2F4839CE7332565EAC3C80720A3C8F7706807EFE0F74062CE83C0177E44839CE731656AD28D075DF5F0FC829F801D8AB4839CE7303ACEBDF5B5E4883EC28488DBE005002008B0709C0744F8B5F04488D8C30E48302004801F34883C708FF154C0B000048958A0748FFC708C074D74889F94889FAFFC8F2AE4889E9FF15360B00004809C074094889034883C308EBD64883C4285D5F5E5B31C0C34883C4284883C704488D5EFC31C08A0748FFC709C074233CEF77114801C3488B03480FC84801F0488903EBE0240FC1E010668B074883C702EBE1488B2DE40A0000488DBE00F0FFFFBB00100000504989E141B8040000004889DA4889F94883EC20FFD5488D872702000080207F8060287F4C8D4C24204D8B014889DA4889F9FFD54883C4285D5F5E5B488D4424806A004839C475F94883EC804C8B44241'
	$sHexData &= '8488B542410488B4C2408E938C2FEFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001000000018000080000000000000000021B003A9000001000100000030000080000000000000000021B003A90000010009040000480000005C90020088030000000000000000000060400200880334000000560053005F00560045005200530049004F004E005F0049004E0046004F0000000000BD04EFFE000001000A00E90703000F0003000300000000003F000000000000000400040002000000000000000000000000000000E8020000010053007400720069006E006700460069006C00650049006E0066006F000000C4020000010030003400300039003000340042003000000082002D000100460069006C0065004400650073006300720069007000740069006F006E000000000049006D0061006700650053006500610072006300680044004C004C00200058005000200078003600340020002D00200049006D00610067006500200053006500610072006300680020004C00690062007200610072007900000000004C0016000100500072006F0064007500630074004E0061006D0065000000000049006D0061006700650053006500610072006300680044004C004C002000580050002000780036003400000054001A00010049006E007400650072006E0061006C004E0061006D006500000049006D006100670065005300650061007200630068004400'
	$sHexData &= '4C004C005F00580050005F007800360034002E0064006C006C0000005C001A0001004F0072006900670069006E0061006C00460069006C0065006E0061006D006500000049006D0061006700650053006500610072006300680044004C004C005F00580050005F007800360034002E0064006C006C00000034000A00010043006F006D00700061006E0079004E0061006D00650000000000540052004F004E0047002E00500052004F000000340008000100500072006F006400750063007400560065007200730069006F006E00000033002E0033002E0030002E00300000003A000D000100460069006C006500560065007200730069006F006E000000000032003000320035002E00310030002E00310035002E003300000000008800320001004C006500670061006C0043006F0070007900720069006700680074000000A9002000440061006F002000560061006E002000540072006F006E00670020002D002000540052004F004E0047002E00500052004F002E00200041006C006C0020007200690067006800740073002000720065007300650072007600650064002E000000440000000100560061007200460069006C00650049006E0066006F00000000002400040000005400720061006E0073006C006100740069006F006E00000000000904B004000000000000000000000000E094020070940200000000000000000000000000EA94020080940200000000000000000000000000F69402009094020000000000000000000000000003950200B094020000000000000000000000000010950200C09402000000000000000000000000001D950200D0940200000000000000000000000000000000000000000028950200000000000000000000000000309502000000000000000000000000004A950200000000003A9502000000000058950200000000000000000000000000689502000000000000000000000000007C9502000000000000000000000000008295020000000000000000000000000047444933322E646C6C00676469706C75732E646C6C004B45524E454C33322E444C4C004D535643503130302E646C6C004D535643523130302E646C6C005553455233322E646C6C000000426974426C7400004764697046726565000047657450726F634164647265737300004C6F61644C6962726172794100005669727475616C50726F7465637400003F5F4241444F4646407374644040335F4A420000737172740000476574444300000000000000D9D907690000000022960200010000000B0000000B000000B4950200E09502000C960200909A0000E09E000060A1000010A5000000A50000009C0000C096000060990000C0970000609D0000A09F000'
	$sHexData &= '03C96020048960200629602007996020090960200A7960200BB960200D2960200EC960200029702001697020000000100020003000400050006000700080009000A00496D616765536561726368444C4C5F58505F7836342E646C6C00496D61676553656172636800496D6167655365617263685F4361707475726553637265656E00496D6167655365617263685F436C656172436163686500496D6167655365617263685F476574537973496E666F00496D6167655365617263685F47657456657273696F6E00496D6167655365617263685F496E496D61676500496D6167655365617263685F4D6F757365436C69636B00496D6167655365617263685F4D6F757365436C69636B57696E00496D6167655365617263685F4D6F7573654D6F766500496D6167655365617263685F684269746D617000496D6167655365617263685F684269746D61704C6F616400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
	Return $sHexData
EndFunc   ;==>__ImgSearch_GetEmbeddedDLL_XP_x64
Func __ImgSearch_GetEmbeddedDLL_XP_x86()
	Local $sHexData = '0x4D5A90000300000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000F80000000E1FBA0E00B409CD21B8014CCD21546869732070726F6772616D2063616E6E6F742062652072756E20696E20444F53206D6F64652E0D0D0A2400000000000000AEB301DBEAD26F88EAD26F88EAD26F88799CF788EBD26F88F14FF188EED26F88F14FC588E6D26F88F14FF388EED26F88F14FC488EFD26F88E3AAFC88E3D26F88EAD26E8836D26F88F14FC088EBD26F88F14FF488EBD26F88F14FF588EBD26F88F14FF288EBD26F8852696368EAD26F880000000000000000504500004C010300D5D907690000000000000000E00002210B010A0000B000000010000000600100201002000070010000200200000000100010000000020000050001000000000005000100000000000030020000040000000000000200400100001000001000000000100000100000000000001000000054250200A4010000E42302007001000000200200E403000000000000000000000000000000000000F8260200100000000000000000000000000000000000000000000000000000000000000000000000081202004800000000000000000000000000000000000000000000000000000000000000000000000000000000000000555058300000000000600100001000000000000000040000000000008C57CE7500000000800000E0555058310000000000B000000070010000A4000000040000000000004CB7CF7500000000400000E02E7273726300000000100000002002000008000000A80000000000004C67D0F900000000400000C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000332E33300055505'
	$sHexData &= '8210D09080A7123C90FD81D545F1DF0010020A000000094010046010004FFFFE5FF8B0851FF15000132A8C3CC558BEC51568BF18B4E048D45FC50517CFFBFF3C745FC0045E485C074038946086A101DC8FEBFFDFF178B76088B4DFC897008C748013C008948045E8BE55DC333C04E06D8F60D9F99E88BC815BBCD2653005FB407B6CD5659064A3BF465D08B1BBCEDDF55FC628956048BC6675FBD4604EDFBCFBA50613C53CCF645080174075619B85A5E323B41F65DC20400BFAF8B405E53B0FD47DBF3FF6A00680A2026000C5152082CC15413AC710A137018D610DFA38BF0B70D0BDE703BF0742370088DAA51509589D6B0E4338DD4BF7C686FF05A50A0FFFA505DE02C3083F30791A69DD2F07E1E9F010CFF2546101F8F5C2E1F170C100A5083C447285873D77FFF7E2FF8B37B85C97414E731880A8B108B8C026A01FFBF403086D0DF646A481481E1FFF3A30D3EFEFFFF81C90002004C14783FB91C2197EF20F90813CD9A2B830423509D20B6BF60B3BA564E33C97E08663BC20F95C05DEF2DDEEE5F6AFF68421C5264A13F5081ECCC0C53DF5DF1DB56571C01801833C5509AF464A3358B750833FF0FED15ED897DFC04F01AA0C78540A4FF4CB0DC3F1869125060ED0C578D85582077B7FB5CE001BB02AB8D8D5B895DF0453FFB13D904106A238B5104345B8415DA48FB6E9F5C4500AA581CDE94271F9FD70498AA3053509004306B0D8282CC9E0C78848088509BFFAFF8AFF8773C8BD885DBDC8B0B8B410403C38B570C8B4F6E1F7EFB08528B175144D2F30F10450C088BCB12110424C10B3AFB5D24B2F5E85A7DDC56BF6777FF3B9BC4F00322A6FC8D480183C8397C8C83FF1D5FF17E140872FE0EEB028BCEC01066837C41FE2E8D4C5310A46D08750B4AFFB145B22558F2A08945ECD3B8FC0507A799219423C63413363C7D871CAE11482E4DEC890D53ACEA1DEF595F5E5B5F5F13F1018A93EC5153018D7160F27EBFC146CC75F0C74431A0F74EB8F00026C8DE1B1DF6FFF1A0EFEC3F17D8EBE9DE83E4F883EC4CC9506C6EFFC489442448568D080850C70C4011EADFFED148D6588B4C24148B2A100FACC81EC1E91EFDFFDFBF7A8BD10FA4C10203C002F013D185D27707721C83FE647217BE64DC05BFD37090624833CC22010766D9B77DA9DD36327E122D1C4C5E1EB832681B3E4563297F538B5D08088B3DBF45C1070CA033F692B885D3E06BC06450E0F6FBE053FFD730143D8022740D46BE037CDFFA7E36BBAE32C05B7E0CB001807804328B0018DBFEF23F553054B5BFBFF7373CF287AC021083F802744C6818B04F408B37B856B90D31DC752CA2F655F05200857B74373C76FFF25C4508704CF8530C0557380CD39C15812CBFEC1455A7D9AD835C9472EC5453F1D6'
	$sHexData &= '7EC30FA2D075EC660FEFC006D6AA8906895EC2BDFD5DA24E08B8BD560C394E7D175EC6B1D9185A870C404D74CD397A1BCDC29E7876C78E958558A16BBFBD808B3AC1E81A24015E70A2895B430E5CA1B73F1BD2AA9E3A96BCE9F133DBAEEC400E69BA349C3C4CDF5792E653542A3C1BEC5DEE729D023334193A3C5CC8C820543C54C5AEB7835D9004948D460A2F4ADCBDDD7E097746FF24851208C4B8403374EB3D0DB0EB36952B7FAEF0EB2F3470EB28B0EB21E8B972E5CFEB1A3528EB1368EB0C98EB05145DD75BC46808E074510FE420BD3EED0EA117F05090CF4C97C8B0D8B0072734210C113848D7196E4AC83C8B95AE741D3EB9420456D4EC894DE81BC921BB50053C5423B592E1BA885DFC4F9C9EF70DCE4D8BFFF47007FE0E0CF7F33CCFF306F0E9E2DBD4ABAA36C2CD5F51102E7E564114C7FFFF4D027E17560FAFC28B71042B31C1FE023BF05E7506D94DD821C47C25BFD11C1D8E90780C840E460674DDF18A10A20433D2A214A49CED9AEB4610523096076A0C100058F0E0062C66891188A4BC585DC2D911BA20205FA21002057F4C9305538E9DF0FDDC396DFFB6B71D2683487430FCC747A5895F10539807685844B3EF2C38AE8BCFADC7FB1760C5AD4A8DF47C6404013D34F4778AEF483D0216777A0A338D5002EB068D9B66FFAFF8378B38C002663BCB75F52BC2D1F85041BEC1EEF7E7C3B8B62C833D144C08A121730282525030575349A448D229E041410A213A17275E380804A32989865375AB7BF7B9F48BF7C95208649A1CA65403FF16F805150EE95A24F04CFBAF32533F450A897DD057397810751EE2ED7BCFC8467E06E1DDE9080CC30E6E1562C9264DD4506A8D0CFE67D89ED4300B507DE4A34DE43BCF76328D64246FF6BFC8A8308B5DD48BC383F9087305D412D80FB71446BCEDC77852FBFC82047B56472A0CEE67F63BF972D4FAE46E408B7D67BFEFFD7FFB8BD383FF72038D55D466833C422F751C8BCB21E8BAF6EF6EBB5C3E8414415E8A64403BC172CE8A50803383BB6994445C14D8E1844F793BF1745AFDDE165266C72C941546418386AA250E6EBA248C500902525050631C99C0DADE55B2BA585C10DDEDACDD14EB2646D427890E251379722C2A8CBD0D3051B5015303965498F03F45A428CC20FC45DFFE6913CCE645A87C884DB033F6344DB48BFA892B03EEC375ACEE0A8CEE35304000A502608A9145070CC810B848CE95D09C35AF182B64525E53B0AC5C7867188B037F1006B821BBB60D00678B7ECDEBE418B5BF0A589E8D55B43C28C467DF50320532D1AC1014FC03803977107449575ED0553B030ABE145151041021F8525AC1652BC006F56D85BC1D72A5BEE445D050567AD86A01515D898A4B8B1EB09151C04BF097950B538BF80F1'
	$sHexData &= 'B06191662DF21380CF3CA4E4C0E3BDE710403F3E4131FDB47560F5232D10E14C30AB42F8B75A8DE004B79C0702118C417B6C1681058515499C414B8A5C0074B1D014DD270818B8B5306C8C7208E83B6C7BF1A90430E1A9DE0EC2DA0C2E80508AA63FC95A334C8BC1ED3762183796FFFFF554D39F97A3C478BDEC1E3052BDE408D343B3BC272E150E1D26162DA7C1C6D2F6A4EC82C8D345139BF0210798D47431CA27DCC569A2B5CFA8B951C664234051C2B87634234DB9D709D74A50802285CD004D7F5D8E2096CD5FC5615C009A01E971C75E1360851522C1E510CB18B0D15FD3C0F304124B934BC6A04FCE4D03818D254DCC81C9FB7C20F5FE2851945CC2F45C4C71C7219E484151C3406345D2B1E9691E1831C8A954CECBF1ECB5E4F2187FC8965F085BF2A20C0F183E6320C90894D3AED5FC1AC0F400163874485C018080675752CF032C00CA032A4108D7B1E147C6405041EF4C1E2CD098450DF8B208BCE6FB1726563AA0E6A0222200205F8FF40FA6C83F8FF742F5033C98D754CD7D1BB0A06E3DEB4BF0872399EBA4CF8041E6A002142A0ADDE07FC2CEB053DD842E4DFD9B552CEE898F8FE3C962C58B0877EB20383BD61742A84A8518A559D6C64F8FE2CCF5282EC8A5E7952972C4B2DDB07D7F711ECB472189FEB09B8E811C0AE7121C1C38BEAF65395F206A52A039F16CCE4530D0A9DAC8D4EA4DF78063D8C0C978B56A02830951AF4A7EC08894C30A0ABC88B0A0B4FBF1E80287E453130F95D08837BF45816E85476B21486E4FF37AEB6C3BB9CE43B1CE074228B781C83809B62F5C00C8378F048A88B43105E858E4FD246DE2C42788CC8EB0BA1FFEEB2E65162CC185A303B356D168B46285B814F65DEA45287CC42CC51122CF831ED897CD12C5FCBF55E585C7C650ABEE1063975A2C07D2BE157601CE9B08B40451D7C130A0572C8631F1A0840184C078718331C090EB90099B8B8BCEF1A946FBC8B383B3DB6EEB74728F30FEFD335E87E40246C06112C4608CFD9E6628C9CE8CA8701394C74C47FA55EAF772833D25283C60856A1C01302673442D407FA853E47DCC98955C0B194461C14F01B2ADDDC1324E4998B7F2857BF8EEFD2F4BCA1BB309C04945152560F7EF77F28B8BCB95C74D1052BF1F083F901730BF63BBCE359EE0723DCFF052B0E5005F883ADEE027BD788AC8930F4D4AB18D210BBC0A3A2C9B5F6B001EB0D1D6E67C8202F421F19CB905C201453F149E5E48A7B5051856C2057258A9D41817655EB115DA6E27960856D0B69E9BACA874306BE402408132C718E3C28573C02DB538C16F842625B8D78A98C89C255EC555D885895215FB418EB90949C7657BD142F5418015D97638BC2E1118B8D296FDE027F146B8C080F828C98A915A01A2B797618F2'
	$sHexData &= '85780DC1C06F888281A430F918297CB8B4D6A463A982FC1545C0EAB901986105522531870223AC4A8D5A205D3BCF185C1E045B013D3D01F1FE6D1A5B48018327640F86C6A6EB0CF0B65844A424E1908B6087FFD00DA12A9A0886C6D07530D24C45D0E4E03DD88C74E292CA6802B99C86D66D21D2CF8B952B513AB5C3A00338F2AA1C7004183AADE37BFF688B0E89088B161089CE7E1C640916084FF11B5DCCD724C9C762CF70F009F55E185666D62BFFAB04EF54BA0E0109318B2A2EB23B8744D4CB270DB0A6E5EEB85F4DA451533C0EACAABBBF20A802A90198B585A8C1D295CC09F8AEB87807167C3BF874568B107708EC3BF374441443F0FFEE385E19740E8B063BF0AACE19B7C90EF21F8C28C3740A5EF652A7BD891ED45E0823A9636FD805003FAAD7978C74780BF107A0DE52B9109CCDECBFDA66AFA08940040F001D81CC891DC01424781AA4F55D50980A12044DFF7819F08A005F75080BE5B050F0807E1900C51AF32A608A6A4406C9563E4E99D901BA480D0832900F4233A51EC20400488603071988BF302A7F1C38CCBBBF2C8945C4A0A870194AC4A02805980926DEC5A002B654329970B2CC8658695AD5F47E5740CC8B45C556CBD57DE08AD05B76287FF3AAC5FF3B307457568D7DC87D1C85F8C46F85AEE8525228BC4CB906901E68460745FCFC14B4914BF8972A30CF795285D32C411ECC1CD092CB0F2C4BCC330E393524DF21503408C31093390CE5120DD17068EB0CB10CDD421CACB36F264E427C1F1BE44208855C194CD350EBAEC39756522B985E4D34AAA968685624D0533370E4A2EA1C1A06E424D475FC97CBC3C37F4E0451F8D0BA15A419422EFA48013A600624AB309FFCBFE19F69C345EB038D492858048D4B0C511504AEF78D55C0525CBDEAC4920A35075B502075C88EAF73E22E033C5D42CC35BF45EB052479163B56BCEFADEBE93F7B371BD53F43F201B53F204E0C51679BCB2FD2C746201C560C2A79E910DC80BFFC858747A5DC745C67A5E88F265481223D8FE93F8C6A1C72581423B19F0150486ED84889350B19DF8BCB4C503A6A24157839C08FD5F9EC38C6744BA3A6747FBC051874C50E085B74B05F018DF00188412075743E5888424235EE8321755CB81A7DA440A50A0CF06EE02E4093EEFB3F146445B0203EE05E440FDE6E9A124CFF1568979A80431C79EBFD94E88FD71E7FF3148D83FF01A6C022062500C2BA5CE0417028B2E85A70D2FCAADA9C3C4AE8A97497E9D255B15610EA14C08B14899522814A48AED8847C7CC3D3DFC75E14395E108843E6C93BC1740C30ED360E611E894BF004F45C8483A69E78F01FCF08FB9BFD7CDAD886DC8BA0508BD6890F894F0404EF1A9A7D083BFA74103C2A551607235708EB2DB536157AAC292D1'
	$sHexData &= 'D9380D9E6DD6A538BF7524747089FC79828B0887D5DCC0EF9E113FF8520222028060E1389C4501830D8E0819DDB71047401850B376CA3950E3CBBFFE1F4EA4C3F48E66C2BC1C1F80205FC62600CC5B2188B07C1FA041012E226F4C77452A15B81FF6FD22B4810C1F90403D138582175356E38590EA5FDE47B148BC18B112474F7EB193604D86CF77E0F3B4108750A2E491D74F1129E75B7BC3BFD2B083BF683340F83CB855C241C06209C54FFFD248D5417383BD6742134F5DAA0C9AE3A4C26F00826444C8EB76065581F581805BE33A81E9B6C8B72987F3BD0732A8B550D2FD8F0CA771EF22BF13BBC75FACFBFB6FF3EB13C4083E6F00337C69438020826567DBAC514263F35030B8D176E9BE3EA5163832C10C72EB8DD0FEEC139587418399FC08BE0B4C031468D554430192A242E1BFF488450541856FB5585749C8CA3F522702CAA4187375071C726E8182BCB82024629ECBE78F181F9E8DE7205BE0D3BCE50020B505AC1ACF7F6D6F02AC1CE3414781A8D3C85F0FF0FF8D373FE803EFF720E03D003F73BD172F309DF80377573320C7A317F22161FB8AFBC811195B28BF9E41B1003669E5D74030284B4A239B9015301B46CA5315AC340FD77B538DCC0B9B40A7478BDA402B053EB02965EB47C0614E28B10D03C1ED3DC571A0067E62442B4A24A8D212AC0529D1A5BA01CC8CF75C47E7F19E56AF880DC8B389C104217BEFF5FE650148953148A4818508BC3884B184085AC6E436296E2C6437EC954A65258206223EBA3C9A015AE02962C837F813F2C9C52B822A85057AB4DA82C38014B4D10A221700A7B5275A85A3430AA933DF546B5287A7CFA3DADF1606A02C5389B39EB615FA613FC6062FC473B95BA1306C778106A0110D21429150109D91BD48C18B4F4A4B85152B660500B45388B7D2EB5500DFC45AC5051897D80AC29A25AED4385FF7E83D0AC1A8E99B5D8DE4781FF007D420F8F8B3D15614C2C74D0FBA041F4B2AF050B21A3A0A9443A16DE258484884DB33D8875A0C05BAF4245B30189B72280D3A099A34AAC3A178884500E5EBC50B9B1841201BC081B85B59E08F58D75D03715A1E8FFA0E9308943140FAFC7897B1032BDF0FC324B2FE49C1E4CF36D788B0358A13C8DB540E3E04F83DF1D7C8B4B082B0B36903BC8733617B80626567F95FB85C42097BF05FBF7168B02D06394037650BE8FCE0B3552839E3C64BF58EBE2799F5F6094F20F103CF80E0DF07BF06DB300908B89555CFF8D148D00CB981CDA3F81418C62BF39759C8A06C3458E77A48BDAC6C1E9106EEDF5DB77B28BD012EA18180884D20F84B1B7FAFFFDB6FDA710A80FB6DA0F57C0C02AC3125DB2660F28DAD63CEDB7165ED8255AC332E4E3C9186664DBB6D81259DC0658D9302CDBE1B4A799'
	$sHexData &= '90C0CBDBD82AC0E30178F2D8C389F27979AA7FBFC0DBEB0B81FBFFEA7E0380CBFFB224C9C79FE6E4F9C9C0C0EB1581A29BE0F63F27040CFFEB088A7AEB038A38DAD2C101607FDFE208E60BD00FC90BD108C4A8AE6877948B0B1E28898C4683C7300805273E068CFCFCFAE1866F323A1A90037D8C0164FF4DA0A5A9B0FB580F85D9322E5C4F85AAFF736450513BC64708807DB300741290038CC2173021CC840C155F23FE9778C06A1C8843188916893060DF34ED8970040408101466C7401838344D57A5CC5328564346EBAFC8DF4B18538BC6884E9C56C646CCA3CFAB285233221B4C31074A72A400B836CF41DE0CEC519F21B9320307C984010C80F5E905D57E47084DC4895DEB4D6870DA2FCC571485D21442F4CC3534BADED02B0F77CA202F2562AA5359E9512455C4193B6F38B3EF0E1481FA1702AE83F96476B55A1DFF0FB81F85EB51F7E1AE059EEB07820EFC54F2C0ED75CC6A33A82EA89240685ED6FAC1E802F7FF442B3C06030420008D9402B979379E8B58E2FF7601A4C0030CC833F2394DCC72D4507426A01C702F7D3CCAC4A2FB18580EBC51FC364C520B50F75482576947147E52313C031D81EF000260495C49A08B81DD55008088236052FF586D3502133164A8AD1985210C23B040115E6F6BFC0E5CEAC67A014585C0745B210C7285E8D41F0091568BEE4D4564A14C69B68D20B82990E215005F16049C4E7C1006BE820D0A981E57100C941A013C80B79A66D4478D27137E119F49F1028310362CF0898502FA9852E8A4136ED889B56C7170E0299AA9E1A842F49823CC16D43AB0B66009FB538F022439F06B75C85300B3E3397714A43A01AE34A54789859F4655B41FA2EB71E2F6F9053C2E4817555329C003C6768218D3F0C0005D44D366D090792ACD2F82088845BB84DBA6FB9D8E02285F57C00FB6DB7BDB156002BC581DE049914C80D7C390B3E2BC0930C0D37287D92AC3002FC0F3C1C82F093DE70026F32B02449CD2E7649093FACA1008DC00C1006C60AED3C1E31ADADF036FD80FD20BDA08C166CC0AF0C3ED1A24891CB110463BF068FEC12495013564EC45BB00063064CC4189123BBE29C0E23430DB2E602C39690F2CBF459C05C48B8B6E7ECCA456D956AC5EB8C5DC855C528E1EEC52F149C9F464CC107069B707B460C8525038C8B0E19F0135F87A75A46A0756AF63E41BE4C3DCA878561F4830B990ECC00366C5442B6498EE6AC4523BBCB8C72F7B451542CC8B35A550FFD6631519FDBFD6F9F16F0356F4BA2C78FF082A01B91B0E9482C4F844C32E846A053BBE8101BB82888BF65147F4133552901F75809721CFC9055FE450034D51558E6FFECC9852B429F98B4575C4894310F065BAB0EAC68973404F18061C46AE0B6D48FCC00D051C53FFB'
	$sHexData &= 'F5C0453082B13C1FA023B55C0732FF19060814E49ED2AC8B85836837D56F9F7C0C2A2865D011AC48C8E6B30BDA8B4FB4C5457BC8506B810A6A500D8DA65170E1A000C85B0288CED06479D8E3F0C3975BC9209392EDC3B1FC60DD38608B900D3C49E4B2E42C4C4D3970BB940ACBC8B1F7E170C4209C0FF4DB4600F8561198AA7D4A15D510A672AD2A6D2064F6A1C4D7B878DD328163889780404081078235430D3A428215754DBD46A44E4C01C9623F10A757A310D0F7DE415428F0132637C3F0263A834A0F9783901B3E201F185F6B0EA027CB452E049CE7C6A18313008F086CF2AD684CD5D803A84895DD87D1D0A03C6326EB92685FFA4BB5CA10EB1E2FBA517FF0D9AA3679956F001F03A13E09278B640FC769C6BF8954E694446083BC8BE5B1AD44908D58D6C108AA369D6A84E9425D0C4C81CEC10562B4DB432542B0D2E20B6588BC714680DFC3F50DC3D00E1F505763AE99435B6C8DCE5C471A3440845181F0A4CBA2A009EAC7FA0AE8E5CA984800175AC7A009A0C8145CCFC3AF7552623350B2C0A59A319152B4D9C24A4FB40D348A7D4ED9DE0E6E88C220C0C34547CDB909326CBEB24DCB2EFE4889021EFE454066428E4E4EFF4C9AC9506E3D869BA34FDDF8B01E207F3E0FA38346F7EE08B4DD4D0014DE8DC54854EC0EB20D82F94CF862231A89449EAC7A01577DF884718B763B005B0A58A01B749482656475A0A5109A02486FC9F183CEE846035FE0057148A042B0FFD48F8060EE8A208B86766CB4DFCBF00F7E9C1FA038BC2C1E81F03C2EA7CCB9B70BE51BEBC10BD61487F195F309654EBD33A10BC65A16EFF578886FC729D08C4E86049CC3C40F5AA07273CEFA03C7E588B1D0A6E509AFAD02ACB2BCF05838E5F30BE7F333BFB742FE6B6460E0E0EF7448FEC8D06F8280169613CD4F7D31A4108C75FB030DE6689FF21B96138182B3FBF5160A0DA4410568207C4EC5534008EA633AE7A0C60301668A8E61E8BE85F8DADE8ECE20A26F42B72F82BC189130E1F20C38907A96D74C715AD68A5079EC702E1D6088903EEED56980A4712450CA6C73960CAE56B46010B0703937FE11F706A4C02086A4D89023C0C6A4E04CB9567F89E4F5E89077FB351B10C0C86F0B2DA0574B5CC1440F42210526C6130A8E0F89596CE1CB72245354883CA982A0A080075166C6A9A240C1E1E751AEC751F05302C8A0EF49ECC820C36FD45C603752E088D1C08EB65834A7404E97ED8F644031A028B989C83FE23F6FD262AF8343939447D560803D08D42FF39FE133C9364746E395C284D0C03CF8D41ABB6C1790CEE2E403B1A4CD8DEB4550F063BD04FDA1AF0F03BF17E2EB666DFACF12B5D082BEAF014D07E52044EDCF1FD03D17F4681FE0F3E4590162FB6026885F8305791005B9BDA'
	$sHexData &= 'ECC1741AD850532304CE10787519027CFB02A310576B8433C0FFE8C361163318A0B868205319D58654FC5710891C4C99D11341107C3C8496751AD85B9D1A13E134F63D98522D0CB98E35710B02BF5A28D2075F042885D278298BCCF67822116E6D3C2A7B10531003D7A4B7FE0D7F3BD17F0D8B53149AEC03D63B50147E09964EA18ABF9F807D184E09D9EB4CBB2B5DD3801C7F1FFF3C69F60FB88177A4C9B68000F7EE765607D0B82F5A633B762BC279751167657F7C193B2E2CFC04EC0007017EB846D8E60A2E8B338D1C7229F03F23AF4D14034D109C9E692BA068DE883EDCF4905C1083D63D412690BFF12EE043E3B7EF758B140EF4F2183BAE7C638B010FB6C06F22A35CD86C0EF28BCAC1EB089B6802ADE82BF72C04F905B7F69B664E102BFBC1EA101AD804C22BC3A479BFE3FCEC02F7DEAA0ADF85C052551C3BF20F8F9A4ADB80F54C3BFA0EEDC2E5C50FB6036DE48BEAE24083C1EBCC160BBD3BC70F8C8A6E6AEA540A1608506CDC428ABD03380903136A24704864019C66B64E3C41FBB418071F38767D10FAA2D54E0A3C417C235348F8CD9AA63A5572F97A74FE7F0E8B401458ACD8EC56E0033B423C0832F006A419A03B7DFFFFE222E449EF03D7E03561A7B008BF45BE6F2DDAE05C1A9FB60E6EC0066170F066C91BAB626F3B388F12C1BF0C8D304D33C514B57175755540CD4DF3C30EF88D14B21001AE2D583CDCF90362C94E9C6EB60F8218602B553C7703F4EB05B73530A13E0CA5F3E61402F0DEED09EEE17423EC1614DA0672D318F8E01E28B47D66E306D7D4D65A7468D9E6BDEF5A26DBC54AF80ED560F963DE7B36DB60D906F9DF68C1D116D02EC3DE2D9BF706F916FBEEC7561EFAEED3DE775665C606DE4E63DFE0CF3661B151FC858BF0A483C6C235E81472108C7660F04FA7984FBA3BF90F8D9FA1A5100C8B4034BAA8183F135D6BAAFF3730CAC1E968D4DC344D608B06C82C85333A84762E08213649E5D268902BCFF8C7E67920CFC9D9FEFDCA692AE5C8F6FDEEFDD2F08B0683C183AE474C4610541C1C0D36374CFF5C0361086E5226BB0156CE22C7E0C478A62A63FE8A58458828F96A6290ABFF5060B96D8A042306705D752840AD661466985245C09AA6B506389C1AB804A8ACB0C782D568FC423B57C88FB46C014FD3B4161414A8384AF9ED7FC04074096A04B8103670EB076A064F0B603EACB62CD82B4B06B846CD6EEE0F88DCDD8433F62B941ABC7F0E1FEE8606DF3D87B618541E186F84BA56535774F837CC5213FE39BA0C362C83C418A07AFC60B821E844CC2403CED6545D102698B86AC2D214AD0503E3C08B4B389A9C521546424160F30A45CA010E85CCFD62E063B3300A053C047DA82A608C139F9D9C9897A86385424310200D062AA0524'
	$sHexData &= 'E306E6A183C74B1BCB846928EB8B452EB8B38B04032C1E41A8A891ED1A0A6556408E18AA686420408C674628B8D0F06B3828B55C686500409956658463C94D04CC00602D9D75076D0F274157490B7E6898CAC62284E565EC6EB65006EF61528A83BD8741B36FA7DAC506B140E7697F25C2853814E8019DB3F39C2743ACC760C2283DC4C528BC6562AD844F0206417310817F4008C42E5837E28FCF0251FA44614C74628B14624E1E8268E4E14FF18420619661F28F0124C0ED211BE50A58CF8DEC1680451A18599AFCEF1CC8B7E046061C4E2553A98380E5E327310766CF0659846047C585358B1A335A5A516F8830475032530FE4D403BFE763D8BD72BD6060078139BF68BD3C33E959358EFFC80229EEC21352A31FB850234104AFE4E07BE3480D2F8013BF0729B6587C978C0FF24B3BF9805DD085A21CD853CFD1A38BB6F8E440B9D4C5A43A8D2839C801340463424FC8C7F83F902742B1C84FFD770A405680380D6750F446CA0E5A435678084A05369BFD7F86855B090EF06BEC924538D954CFBBCB43BF24CFB9D50120A5458FBDB3DD00D258D8DDC40787CFB9C9057413F8CFB94FB053578977C5DC308BC5FE451457CFB678415ABCF935365DD94FBD0FBD4DA371466B504412C3BC37D08261031C199E8B4E2560F3D23FD7A8EC2217C4E3829D58103E03D18EA5ACC2FDB8FF4EF582314760AF351C0EB082CCA769EE6D0F7030F28CA22463C5854E1E37BEF1EBFAE8DFC7854120CD92C77FB2E5FC21D950812850CD940B495DBD29E0510CAC1B6C4770D05CF82F636C2EBC0C1B0C822590D08DB269643EC572C2C57C96070B0346D2AC83AC95E5E664BB7C16E60BD90FCFD18FD0B1C69782E9720282C660230849158D96E584F4C67E34878A6E05CBEEFD25438F891B40BB0AC0DE772B9B8EC98B60F82CE8EC385B4CE6408FD6D344927A828281837EE27C84E328DBD040C774E6CBCEE8D378B21E40BA8728D78692EBDE9B418B8BDB3DDB003D01A373BFB75388C0C8B5ED519DAAD7485503B461072A29B5169CDF8068A0876047409AE45811B920887D7B5B737B7FFDAEB7F92087C1B395E0C75160810751114750CB6EAAF13888D93FAEB57947D041E3D5CF7F7EB098D5AD07F028BDFD4D04C486B20F843EB1B562349247EB40442204E11B810413716C00A3BFAE2FA021374CD8DF4DAB55D7E2C0F42CFF6EC8BCDC72BC362ECFCC656763883C4978DB08BBDACB5B8BD84BF5485DF0F8D52014E5D0603A00E4A553D8F513C3B25D65752F232348C100A54361CE22BCC18FDCEAE740FD7CF2F8C88854B390C80BD1700A8C8653626E1005F1A48F3B9EEC7DCF82BBD34A5B95776070C141B4AD550DC8CE40AC063C3AD8DB5599D06FF5E15864D5C44C57844007E458B4048FD'
	$sHexData &= '097C02068C4E3724574409EC9CB279171451A52A4694C028E97E3CB004BE56F78D41C1BC33951A3CFF09EB3A07A074A61823214CC1704EE549C5049CC05A8E1637745EE58B2A628504DF5E387BD937443A4B18FDD36073C02B457E9CFEF9FC2C57438A33050786B3DF17F983BDB062087210C87502FD305DBF8D217944DC582D3C98D823105048E80CA4683C18FFB59076BB9DAB4695D117A8560BBC5717D05138AD5456E053EC370C76008590639350E2A2D850173421B58B47ACC24F4B1EBB43941871041B35189C44252ED2B5DD8F7E7F8A083895315474198B6B3B851C1B0B983D0BCA8D8DF331C78033AC59FB6EE680CEE55296BDBDBD930FDCBDEBDC358D40FD18054A1F10186C4140D99213E194FB699BBA3E36617392014663029D1EE003461C8E843DF3C857432BE08D7902BE5E1183C16CA7DD34D3CFD1F93C1EC028FFEF6513BC7BEC7F5123CE0D2A22E9CE64A92CCB80270F94C353F50C8C81B2C71B954567E2922C5298155990A77285500E9E646482CA5F1B4851850239E49552C4EE1F72E77243258B9D4461431C86A05377D83B5CD926BB80A609E440FB0BD1D3E14E26948D79A339A6C9C8C15E44C8565251820544AB95C74682459493DB0146370C5E551FB1223A1A4521DEF5600A020C34450C4E243BCB408E023BDA0501236426860364FA0F4B78C7853C4F8564504E1571AA61554B45D063B8C0AAE1473B6083050C845D69D8A10C506BC69B0CC3A6457F66753E2F105C220C80105359799E57F8A0429CE7130E09E85D4B9566ACD108ECB5E884431899BF28BBDB70EBF98462325013C856E8C457C13BF82ABD85778BA5A3B5CD80BD2C31D37C0957882EDC8D5F0C60DA1E3B5C98AEF70AEA3BC120C88814DC039B2E2EC7C739050F8D2C16E9B42BA8D80E24249554F9B93407160A585CC6856D96F883F7012B5DAC118BF18A8D3E6010CC17766878DC7C61836C0CFB5E64888D6C384106C179FC9FF02ED22080124E8B64DDEC25059581956F5257E11A64091B5EB535DA9DE0E16435BA358D041E5685B5F6101D2F03CFD622814064132F80FD87D103C902D614975052C15F117EE64646143B897CBB8DABEC468FE152CD875C3C2276A7780FE13F8989B1E853270E075350509A00D315FE301AB9596A0774F1F5A5D754FA55CF0FCE6E585BF0CF7E24B477C81A8E163C60B02834C12B0564A4F81052D0BA0F10E7F71945F02BB534E90CFF214FA789E58DC15113A7A91B3920FF956952C17B442BB9A410F24356AA84544DC170D0E4840C4BAD9B3C947ED4F251D448D48B0BFA750545321A171E04EB08FCC043E1EB89A2206270B5740B7878861D9AA9142A7538A58DF0FEBEF7BE4573158D614815289FFC06E5073A3EF0C714DA204DA8C2EB4C205C1E7'
	$sHexData &= '161B27D73D7CED1F97441A2D8FDB6109EDB9E99163CB49EF3A360C9D8FDEC7025748125D5ACE085F44C984ADE5DA0FD1719D2090776A0B1837B0D4B4C3848106D1384268C0E9FBC3A2305E7BB34F044480B4C3030AF9E1AB5021204479DA1FEBDF484E223769B4590418CA4E0A1878EBA1E755FE81E7AA619F22D3CB80FBC5CC80F9041D8EE57D2F214425AD155223D6D01EC54D12CDBDA3DD31E7A7F000F2FD3762D189DBA72DBBD770884E15AC060C114C0CCEE8D229EC64B01770711004064FC5790B893244992F7E903D11CB07BF56A3BBD146308998451541DB06BECF4F0FC5C58CCBD5C2EED0AD0D4DCE0FCE310670FB3E4FC3F084586F9FC1A833858288033A8B4F4847AAE6281CED139BEEBEB12681B5128BB67A78D117B544F2AB3A7A9EC3E708E411B85E0C3333BC89355F4D0FCCCFC85196BF0FDA0C16B8A118885E80A398D5C54916D9B731ECB9EBC67BC5045161F3E1B838DB1BE1E1582141965A0847480D8C84C1C3F1E175E606CD675B4595DC40C7EF93C5FB44EA44C1DF685741283A5993936EB11FBCC9348350269700B06FD033578BC70B1C377C00BC4C5C03831AE469AD9048F03DEACA8F69837CC660F5E2139F434F901FF4E974EFB3941481CEA82053CA54319309851D3FE882AA034D03D50518A8D8387071D158D690CCA109F469A0E3AA3228BA4F421415448477DA8F09223BC3DE1A5D37A481E8284D5B934F3C089859C0AA0A48BF125702D16A8C34C149CB8EB4E4E9D137C4893BD2B3BBDB4B0ACECB6718C3623B5A0B5B065F7539C40E503CF3B8DAC278F10E7F78A0FB586333B95B829FB00874D7AE0CE2B8D6CC485385DD7B54F6088E592C90EDD3B958DB4762ADBD06228FDC980191C2C9FADC3BBBA454F520CE8FC515003488D452FA506E56DB0BB779001A085C766D201156853F4F8D18023159454091C4CBDD049076099762321BD7E38CD383C65FF85158D70AF1DC24D98A6852CBE305E67A7FB7F512134FA2DC71778002792E9151CDE30908A861700D264BD208EAC47C55B5139B8303890ABF9B4F8FC5009F9505152AF8D953C83E61C478C1F3A6C245C56C2778A24202AA440FBFD234339AC77BC093DC84085064456C0C33D764C1602EBCC2E74505B74D1F54EF84A8B3E8B1DEB7604FFD3826C6093070D61709F742E82F33368FA5E378578C3E9ACC01D5657320A106CD10570F02B8D1926AC536178853120B7569DA53AF4548E8BFFE540AD1CFCEE754B1F24D30B83F8037C118D0938CF2D14CA12BC154CF4EA52325D1C132D95AAD01603ED5C8085ADEC1C9784882585FC0F6A6AA965C5346804D276D77ADD20D1782524003182A090D93804B20CB540ADB59C9F8EC5AD95E472D1CABE67D0C065782DBD0BB11EBC3B45401BA0CCFC'
	$sHexData &= 'CB1C8D9017B867405AC0B0FDE9081664DF3B3383778A0323BBA9D4B52BC28B582CAAA9F028337EFFB5F0D829F286C8F053540D2C78EB07899A957C16DEDF2F04BA0F5BD2B8D277D3DA3B5DD3D1C245E03BDE9402274FF75B4BC0D0CADD05C6C4AA7ED6320F853897DD546F26178D2C1A2A951E68E624FB282C349D48B954383CB84D520798AA1B56CC21261627C96FAC3C08B3002024FCAEA5C022353C10234E861444A72A9FF6BD204FAC5016F8B951CB927CFAC205BA5CFB382B3F98AD278B855C8D60F9B2AB109624E840FD8B85C0A257A569ADD3743AFA98E062905C8B0B65518A5028CD4E251B65B595E878473BFEC26C7CEB217346D9D882456757A772D138F13BD3740AC7AF9D00DD784A012CC0A0355E1B357428260D48888514DC5F5753516444B0E00B88E602DB741FBD097C3B31338B35C953FFD6A6B771F6E2062133C02294C6A7D208FF8585720999E0A1DE47D6B5DDEFD41C6A0CC4B7B49828388DE5CA0B2F94FCBD3B13B4C5907B981B093885C05907A05E1899EB1014E0C1650D3919821430025FA885281C8478362887E43B9213F7569A810F38981B0551CD095223B5CB0926080505B65173A6EF2B000C94A32BFFE1C30CAD2BA589D1B8ABAAAA2A04FF80F8F7E98B43305EFAC1EF1F03FA9626B17087CEF87602721CCA382BCE84A2BC64FAD0B983CFA7BC29C787E143C0F7D79D131DA783C60CDF83BD3FFC8C62E97614A0FA39645085FF5598D134018B4EF48B5EF8D98FAC8B3246FC994E03C88B061198A9BB88D82856FC506FCA708F170B1EA3144C11A2D117405030C8AC14520F0A824E5D6360B596D4FE19CE1BE9D4D9684237680C6C1880160F35F0AF2A6744492D99309180DCA98616E8DDD491B6A6DE8BD915C4FA4627AB29AF290C64FA7C54CEAD7712DA2BC97CFA198E404F9EC4FAEB140B7448845A4377FB0D91D01C03CBBB48AC75050DF5E154A0B08C85ACB8FE2CE0FEC2F17E02EC8BF037B47CDFD41B54EA2C61435289D9228CF827432DD260F9AE0D4350078DCEFA73905F442E8B5118B12C0DAF8E80089861FFA5A538026DCB16B82E79EF340CAC2316B0B4DCB976438F9451420FB45156031E69BFCC51575146F437D051AFEE88EB0E494821D41E341765F7BBC6E85181163804520B2050CD122E6540519A855C287E075F5FC3D15947705198806E230F1B84A99A801DAB53CD0A98800130EF20145BC111238516A02E4B212B204F36BE58FF44FF40ADA90E50D26BBB93BE2CD7B39D4D23168D33A23A5539D970735AB71C93D3CB609D97974B74708D60CCFE346AC94A62B8FECF50415968972C90F02E6D575E1D49720CC87CD35F79810F1C58EA90778C8E66E063A7E61DDFD62858698BC3A39CF65EDA7B4E4C3D4074597B5A07DE88D'
	$sHexData &= '406BD98B5305B450C10B1062B07F505DE1C3BF775D80CD9D8D2413D4B67691F818903FB45A02F382B249591858D8DCA7A61230FBD1899182FC89C9541A157BB9A5BE849ADA4270A1C0424B25E20FD376C4D8269A585E1962360A6126B30CF960C85517B5E6C25A081BF1DE7E8A79041EC5D08817B10D43FE1637A0F821F1A45B850B9F79B7A1AE975B4297C8CB47BC6EB86F4964EBD397DEBB81317B8263E7A26D3A1B009FA3E8508FF5B41EB5A4A21FAF5886BAF47F1C39C510382C846D07308FFAAD3D8105974CF0277710A6DB52CFAE8B7955817B03616122C9DB63606920263602AD55C01506CB4080DB90C973D2003729765B023BF4568C4A858185F6343A7D5FF3774D46A4E9B847BB848996A4F8CF2107655FC25F577125A0D7C0485FF7507BDCADF558636D27F1220DB750CBBAE20B170FA75E099F6FFEC03D81452505A0C9A11115C8BF04D0CB669380C8BFA3DED0269DB5C51534338F97F22A83B22A2A1F0F1730E66B113BEEEAEE2F675F8EB162E7C127FE8FE717608BE0DAF98101102DA305AC1966622DA731D8A14346704F62D33F189018932954C7C117F073D7761EDDD64B85C685F485E528A805833E15F80274830E2D4FFA85CC211D350800150135F7B61E81E46C063827F5148C781A43851EEC6487044EC70C77634F931FCFFCD207F021E7DD48BC7F87088C7DB5674C6047762467025ED120A14D828F8041E0E63C1CED9B4B0C0D14D000FB94AB81FFC763B2620FF1AF819750B83C2020E4E75EFFD04DDFFEB081BC983E1FE41750D8115780C0F95C136BEC5468C840C9C1A7304ED99D8A610B3ADC41BA23A0272843439101960A7A3EA6BD0BF9F50264A44DC9507723778FD9C39E0BF05749F4CC8B77331ECBF045AF8BF09403E322141390CBF060BA913F4751450F0002088953A1969400CCACAA699442645020200042A2B9BE6268B4D5501080210120E42F9C2774F0143C94834ADC705DF44D3BF101447240F8B457F18DF328C49930AFD4E66017F972B7D082B5D0CCD8E8DDB7FB88BCB8BD70FAFCB04D703CAB929F85195A451D02FC87615381431F107BB1050519703C099F7FE76FCD30D3DA27D7EF483FE017C3802C32474DCF850885AD553199444031E5012F89A98015A7D8CB0D9478672292801527CF8FF07A1C8589475D1279FCC0216E90857338255F86847A0D18D8EB6EB9C600AB2AF057E7E42998A40996AF5436CCCF403CC4D88562E6A0A926423AF852733528A482E6A32BEB4B66D32473B7E7CCEE45FE7DF548142009CEE76C6683CF8E041F15980F433DB5105EC8C468213B004053E570B07000C5DBC0F85F2AB93804F350C72660C0E68ED5057514AF404F0BED98A8467C1F0AE6A98C819594702805183A132BFD209D0D8895DE06A'
	$sHexData &= '01AA03E1B2D3588920066961B00F9FFF9CC0740F88109BE14DC811F4FF016A057D38FCF1510734F8B5548C8EB76B80DBA5A838CAAC5351EF40F4D3AD344DECF80CAC51C9ACD7EE1650BC94DAF0C77534F37B874D60A95855C8523597DE79F8368D46FF7008431C80140E637C9782B40D33716168BAE47ABF5883BD0B63ECCE9665E82BF7EB20B7E7B80D44F853006F6C8D5686FA7D17C864B420404E2CE082C3232064BC9092147476E0C6C68503AAB6B010691AAE6C14B69A14EC2197192E08EC9B4550C001D20C4D550E9331D930F2A0E451C7395408589F04086D9C762CD0750CB6E0422F4076D7FC1E4F3B3C98F4D7CA2A048D5B89992A51F1883A8D95217F49859FD7319876685FC64641C089C00401921340CFAEAFC2A61E5F515E0672056B2D1F10A011F182502FC64E21C0210EFF85C90E900B5E74714BF8F820E8044B441B5647053AED7E75338885F4287CF0FE0004BC9FFB67405789B519677C8A3D11863738311B9820A711ABF9FF191B131F23E43008B8382E30EC5F4E4004538985C8EF70A24B065E181C40B842C32068E0D47551BBE4709ABF4AF05363883BC6199D36024B95C4CBACC4E3B311D53DFA21CCF7E0F7C07D095C4A5661B5D01AE0AEF19CEC0A075B216A0CCD9CADF656EC43002CDC2218899D8110265309587F1FCEB61F42F651A5F9CF25B52B6EC35F105811751E82D2741518507C4EA3FD745102750F8604762875DEDD60F17762EB051BC083D8FF3E7AFBEB020627B01828DD39959BBB6EBC261E403390C8DD8DCC7ED0E023A16C83BD8C67D0F78A031F4BDFB92A17C651031E1804CAC8E540181404C4B82A02BF20F63AADEF109E4A200F9CC09F4967E8BB1FCE0C0E1F1C290AF1580878DE4AABA1C3537418C3C19BBF29AEF0693ED86A02381CF529FE0F8F602054046A10EB130FB703F37F5D2FA5E8B94CD8564B31F08B332DC00144A474391D7887D5337B3A2E157023E67ED0868DD067CC8CF7D8FC23C7D9271885556C5D98924D2699E48C382D22561360402E8487935CEB9202538B24193D3AC9240E75BA0275DCF44A4300A8768D55EC52119AC47A048D4D8434904E20967E8A826B948BB40F5B2C08FA741C8D5A1142370A2DE5FAE8BFC91B87398EE33852D45E6A8003C2EC097D226816EDCC3280141B6B8B662BCE4F1A1F84EC4D30784003CA743DEAB099B0280CDCE7163C10135C7B434F5872832824743C772D716F17436E3BD972C9B0DE99261CE97450F1BCDCFF038214476745DC8D14DB8B3490CC9E0A0F301C1ECE517955972212A03B78053D56581FE87D13F4E3C8F0750B45C2180081B9A03F2739451440083C5039804C18FE180C75E7AD22F07E0A1A6436B13153856C102780AB640835E9835A0921D68D52B5D402D6F67'
	$sHexData &= '5097D7C8705320C011A110008485860ED043D7E2D181851B583A54838339254408B85026B61824A524E98585FF003C75203CBA8DE7630733477362706CB862712831578EF6A54143410CC5152DB0315745E14A065D29322258DAC1F1883A70A524AE434C0C3C179CD4910F8071A64BC294F73C818080C75790E3E34E2DD01148C2F20213164106F17DD4A80DD1106037C325E62F7BEC8080AB02403F3EB1648188FC4E0F93E2E8BF33275041C187658DF0D66C375789A14511A145257D8610930B9FF7DC174588C8B0361FB45A04024237F2C2452179EC252FCCC54400056D361350A2CE4303417DE0B15F83C0826440B563C331E2456398D4301ED74E86109F81E985142268643977D10711248477F9FAE538DC518340018F238E89586D240D1C28D70023E020D30553FC65FB433680118A3288CE82B3C2B0C026A9C08AC295AB89A9756051C881187A389A5143D68E478161EA6C51A30000C0517FC07FF1803F13BD07C613B867F5B3BF17C573BC8207F51936E5041D0D2017D05A7071E5283C2206292D067B1450AC705B8C3C094C13A54001CA8A07ACF9CC3413875F333B273F8880985C21C00FF2E398635B3268A2B1F7413F834267008C8D57CB01EAB506C30ACFFE0A0948A2A324911352F08749240C37808764F634966C9C8505262404F187C7320D5E23D5C2D5A152CB0E61CE90382CD330A1A282889F411F034AFDA20282424443034AFD935184863308D60403C381E2B5FF3403C394C3451E3CEF3BCA28952300634383C53EF7DD6265CC04F547658705CB7A394B2003DECEF395274720EF02B5D1F7A60EB2D5614FDEC16E65F0C7E1472EA06D5CA25339F70387C5F6A0C180633322B9FF170E86C87C80CA72407C3B9CEC6AF31C22A0332D210505475E894E22D219B0C051C049986435A45064C649289C124772028F30699642C2418061C833C0FCF202496282CC7853C789844A19E30911C20072828211A8D0648284F9A779EA238321C181A20247907581E9424E5284036EFADA83C553E44383C388D1ABE151D064F565852DF463A84E82C67BF02387385144D56584415493349504C5108158781BF1D7262659AFC90DA080DCC233C45C2348C0314804229A5007F40836E920B88168473012D32279D584CCB5934B5F1495530D41E495A19A8FFA8100F854101E3E2B93256C3642CCEB44E679FC23000BC0CB3190FDDF3BD425E08408501573B5CC72FC1ECD2008C1E8ED9EAEB0DD402FCFFC5006E071A0A29BABF427C0EBBC0E3E38053028BD818A930B0B73BD2EB0EBA31D0A281477E2DF633C9EB0D05B9FF5F991D699D180C3D2DB80FB6FBC1E7EDD31A535BFA14C90BF90ED0B60C862BFA578D80F0B534A5FED74E04A9D80AB574AAA59C1228E01C9A62FFD0F6'
	$sHexData &= 'A65BB11DE686BCA9EC228BC75F5E5F492010962D25230A39C8E91F2116CC02E020CFD2F6E4883C4083E0284754516F19E442ACDCE00E0042C05B6C1DE477B15E2DC0B1BD7DB40C4584150111B0013499872A116F16F6D732376944782400D41CCC0DE0DB8358263D85D602EB8D29518455C554A1B0AEBEE15DBAA1265A82AE7F9354C6CC4F02C37C9B229E4095E25832C048D375A303C7FC0490851590C6657CA286DB6A0AE034AC482D6025A17067B6832EF2FC9838F21F3A1A08A96153522057C2B715D16AAC814D98594C9FD2DAAA988526D51B96BAAD445768E1E054906229EB05B99B52A42ED9908097E094C254BA0EB7DBA9EDEB0F11B8627861C3EA180A5502D9570212A984629FDEB59781AD8528C37448034A7E2520ED0E3B4E42AE5C06A51542045071D5098C65B85B5D8A74BE585F9980E0B581C1D4DA472C2A7F861ACF2727D68B0DC9F5829A40D7B3D609B31007AB3FD7F7EB7E535FBFF8E875050DF0B3D02B0BA0BE1C54CCCF25FC3B8C83BA05E7238334347BFB875231F06A64510452506A4FE6084E788E6AF45761F8411288ACEE8707C931A6305FB81D5EE4A58054FFDFD0FA01562B6E9433FF2BC79CA0E3693AAB48FAF7E93AC44077033ED7246AF7741921DCCC5E267CED3C90C419A8771F2E09A20CABB847F05757B77D0283A38B600C874454750E2C9AEBDBCC3B3023555C57D651511B2601D6B77902B0861B7AC9B30EE0FFA753397D107548AAA1D174755D57A60DDD6E3D21390B3C9B7CCF4DA60FEB50B8FBB381ED184CE7C4007B74C34D3470352A95E5875021E4555E1024A442485106C7620F9830283EC606000554D2C05021A551A2486CE034CE0561349512C2D8B2630107B429D8C857E0CB39A0A1FEDF85D2B0AD60AC5107968FA9D512723E089DCA09B4417FB856FA301506B6DFBFCE0EC526602784C7AEBF041C1BA6C19F80552D1429AAC1184218F882135A7C56145383FA8E67D65CBC1EDE1516D6B6015BDB85036C043904430C0C4A1A9801F7751C98DA366F892D0D7CD0165B760E33D20BC6358434C35FC34A171FC2826718A65251AB0043FEE0E4A48B4508527935B066E53F14C2179C10060899DB67085701DA8D4E60D9F08AA443B05A0F7E18431AC28A1057C4DC10B676AEF301FC4816040E21CD217DE68BCFDB072015AAEDD35F3C0440734724FC813F515683C018500BA7FF488184FC0B1EF64640013AF0E107271C740F5C8B08EB85DB25755610FB2E20C70020ED92FA1D30D734140A3E32C82434836640FEBC3C02BF21FC27CE5ED6317035EB6C505FEB08576E565FB42E54F402A81A7A3CEA138B7E02693380344A047856B8D020BC0AA0D17C66B23C10AC219D6A0A5F10EEE00422C1F0E07F6BDEFB0A5666128BC18D14503'
	$sHexData &= 'BC2731688CD486009F038660450BD6C1C59DC0276880950E0E68F25530CFF07CD16F8EB10907E18D403DB2B1A03D9D1FB8B0230D4FFC3D1E883F8207307B820CF2FC25578C09FB90A7F2BC83B06DBADEDCB73044875F1700E5BAB1D1ED51000C866CF9C44152578A68B8A5CF803E805558C15AA1B50515771A8D25B0A5E9AAC524918547C8C897E883A98070DAC1D5C38481224ED0262044883290E2C2028D620D79DAD3D30D1FF1EE9B8804E6D203D83213B4D30012FF27817E06B30801A47A6895628102BD1C31FFCDAD1FAAE57D48B1A2BBE8D1C5F891AF0B77DF8B3C6E403D22BD00003D7468910E7E16E2ADE17B3E356E73AEB277CD606A7CC204E245EA71457893B194F44556020426630C3216181806F7EB54661A787834E1E2700083415065C3208C110DE958A595F41207BA581C63F4DAA3B02764656DF3E47475560BE01F25E740C0A50FE7406F6D99FF98A41A0752A8B4130608300FEB843E106B5A3C288498001EE0FB7C2A5F64624FF3DE15334ABA8C6201832F60789C3C7BBF186534E79308B1F2A1C583BC306053F2B5066C45B2CDC0475313424AFFDFF2F283BC6770539713C761F39413C730389088B0412CC59F61B748907FD4E6D0634104AD8ADBF51FE53874DE70879538A1AF6C3010F84EAF130A21201860470C85CA4CC50CEBEF51D0AD8171ECC2B027F4EB3DBDFD49903F813DAEB3436017519784018005DC0D03B164E0CC64423F01A30C45058F4D42CB4CE36429E8C187FD7DC4EC280D40E01E92E30BDFF5B605DC674A68FF9F27C083BF80F87EFEF1F7E081275FCD6D1FE03F7294A2060978415F43601521802A54141A542DB71A2065DCED5B48E55511CDE500E20891E0378581E49342FDE831D4A41A50D4E4A9202C21811548E92852F14B9829DC2037C3F7F427239A905570A2F7F2848F87722981899559E343449241198B7429A135D640BC4A923EA5D8FAA38E8C95E895828D23AB469040C105B9F702C38E45ED26A99B07BDC872C038C4D8BDA139A006B59A0CBA7E0408E1AAE924966C2143BFE75C0D84D0D0F19041298246C7C1C28800C677EB26FAEE4205B49BA00B0009355D1944389AE0C4B14AF28C024F27A4374713B430ABE43EB57514D022425CD978740923C368B5132E61AB2CB1D17E39504A407DE6A940CE9C88BFE387188615C8120007F3DE145F213C05D0C86C0B2DB5F48378B7B042B3B18C1FF021F047E6337A64281463F763600968615A853B85CFB2C2111FBB00CB885A16C45334E4BBA1B52E0A2B89A704DF90C2A9508D630865678970E316E4504D9006A203584069E0684D95EA041312F8B07D88B4FDE0414DAB25712041F895F045AC04A6C085B314A44C4AADD3F83F34BC60BCB0A8A568708FA038BD12BD000FC3E'
	$sHexData &= 'A55223847EB8336C814E5635548409C1A12B8005F39E8599530D3E520A9F0803DF5F4CD7D0094B509F56A2D7888780375A0C772E2BC878096D9D21DD505F92B6BB56CE2BCE0E6C9914817456D3BA294398D0F9744D94B20F7E458D3C908BD71D03D2020C050FDE2759832C2BC719B187077957511803C3FE5FA32C2E12C3C72FDDD88DE8025E0EA96C6A10280B40F6E2BB50A220D54C735F73C3C3C3E89FF81608C2710D052B9EF65754762C489A3E74067EA1865837A37331A4A43A2BF0C8C0F7ACF493DA3505E0F8CB6C287402D0F0E177F3AB8BFCC82B0E002BD932981D0442F0305F151F6A4D23E41670403B9026EB6805BFB011893189B070985146710422D3346D50041608080870824405819BF5DFCE448D15BC84AACBC08F045AEC7449043E11A983C1505E63E4C7DA0851FFD31C8D18033B2670E208323845182E039F5BB6C75E8AB41A51DFE2304632E9938DECAAA7BD71BBB9F085FF43D957BE97D080C8F94881EFDDE21CC9C94EE5F73B3D13874ED88175CB92DF184BE88C570E2A1EDF2C7036F08239F156F19D0D34432A1DE91D1F0CFCEB837B206E1C8D430C9946B89070E4108BCE79549A574564E098B65639A734918131ECCC1602FEB41CFCEF0C505320A87118F814D69C838845C4D77F8D4628E04328FA268D2A1F3280782D00742A009606E36446D877BB10D4088CB0400B80793E78BBA8820574082643085BDE3A046E3CF9EB0ED478C3D6DF7E53E6807F2E8B7304750389772F06D03EF739581805AEEB0B391E9F04DA8A75F43EEB327E3113E0E76E341A75205F8ECEEB144CA757A424B08BCF8CCE01BFF0FD6BC6F6FE0D535908757B55092D14381A3AD180086CD371976D8FB0CC95235A8941C60B3CB8226C3B43585C1A1770580602B7F0981A843D5EA05308FCAB35419E8307680E7E39193A0141FD2BAC0526FA8A532C8A482C88508460A0BE044B2C807B2C400A2078B0CAA73B9CACF60338CB741FCE3BCD7EC368D50EA075679E582C007512C641DB5C09C130D2462C00AB5C2F0ADAA6E62D78C8807A3275964182EFB41D8E107463C02312F00B3EDFD9C6400E6E63AC8A5600512C7CBFBB7B86015A983C99EB79C71130ECFB96630EC515A3221312B8E7950E1AA7ED2082672D7876043B7984854354311BD76C60E712F95C94F701558FEC69F5ACC647108D357FC0CB91E64B0CD64320431C64E02D3A9794530C3378F51A684DE448760691E408557800622A08829CA0D4B69F1539460A539199F926F08FD448036CA8FC395F54742040D72F16328D5748391175CC573745BB99CA4089112220AA18302BC0A7E4FE1B2E385F507434534CAD3E0AEDAD1C4254D5F4D5CFD0E151B3883A044AF9F855886EC2DA4D3C54894F4C0A4438A1154460BA7'
	$sHexData &= '0A1232F1D6818905470084C59432573B0C31F245F684D1C74297F752D86EB7F478BD9663BC675073A808F3D00B41F32FEEB2310340EFDFB0F0E513BCA7317FF082D8D510289EE0455BCAA31B8C65750546869605426D5746E615373BC624B483BC16A1640123C505FD2830266CBA3147875E04E21B4262C546F20B9EDBA8E37A675C10FB7C6569883C169A989F6A51ED66453C242FC55A3ECADAFC825E0A0D41FBAD183FF1001ED57135855D48BCA03C25ACC1930114E5C0C46103A5684D2515C441104AA31C3434CF97C02886CEC21357C0A8FE097DADADB9AE88703E07E2BF07429216428B0F04B546201A32D04D065F610F485E9C6B0FF8D73BCC6434A013955C82A7834582C124C85677630A5FEA59BA60F83BF40CAFF2BD0743FF06F750F86A691700883FEFE0F879A64FE73DDA7D8C045503ED4C60CA45882F3DD6EAA8A8424091E60A6A928C50416427E2002CCB25C5639C60430C155E8930A8DC1A2D3286DB01ACA4EC6003106753EA1861DECD6A88502CCA07DC3C100282488E7D276E9071B7B8C70EB2619B0E5139B56EB18A698312145818F3BBF8576583850DFA2771DBD0826163AB010390192FD2FD47333A57406663978FE752346508C5D3F947620830646C2669C093594134A347C8BE6F1B38D0EE39942B973CF7438837E1DC729F172154328BA6DC2306AFB065C4E208D4648D074131091B6C18677AF0CACA12B6A416AD2FF59C0ED903FAE138B56300578015EC352C1B94A22501C5738F895C00178E326B442D3AAF5CE1057C5FFDFC0C17505F9264CB6F2F599507428768B8B0AFC05F9D49E48173630CA47207936FD853A9C9324397754C25A0247914B33524F4757CFA66DB86E4A447525E33262B7C0C561934DE704BE1F029E7903B1936391225AC645D4004B38049A9054DD998D8533BA5EA380012A9B171D9EC98CC883F901790101A2BF045C6D4D3BD6D64C746589C1E110529B55A25101A18627A2FC73ABE84493881C87BB5A73B521BE4CBB10933BD3A075B8DACE44CEEA06D2528B554DD5850203F056A84F47A182D191CA80387E62D8BAEF4385B82A1A460285D0393D38EDCB5DE86A02500AD0BF580F6B5A3D12D09C07230D0C9656814C436CAE36E2359D919326394DD482832527BD755DFB920E0434127842BA348D3FC80132FB2BC65003D6526086A54AFDC924EEB0D3C1E11932134DC4046BEA6AFF85384D5B60AB3AEB6033E2B90E4F7C50592BF8D0D87E1DFBF8154F462CC84FF2BE4416FF4E51197C169EF4827FE9E9260A3750EB177E352D0C5525CDC3AAA3D155DF0CB4A04F08506A009F47751A10FD8D74B586837F5E0E951083C3FE83D6FF3D60674266142032540FC9092B9C3B22CBBD1785869D0BD675067970A083502CC64F46BA'
	$sHexData &= 'B598C1573456FC631450258CACFC10A5BD2666DF30314DF2100F6241851B1FADF512CD1014324F4CD869A5950EF04089504837D41013FF147674647525256E8A49045F409C10C052901A1DFF5A551D4E280B750C114DE0D2A8868250E48C1A9C012950A4D490815E3432118F406BE20BCB741520700B3F086A01EEF108C8A679508B4F445051E07B87D1989AC789574CB6AEDC0503C1A2CB72D0CBB8E0CCD420325CD53167060D3ECF305ED4F40451005283364DDFB8D4805D4A5457625ABEB77E6141A7C6C70B4510A837712938D1FE03A6139FE022DB487F2D8B7E549A0D42FC7850018846F12EF44E6061380A5446566BB8BD5B3A040C0ED8833E00742C031B4017120C7FFFD26EAA70E82188D8565B386F813626817905965EC376C3F8494F045F4D0857707C8BF8B06DD20C4584A60D5FE78104053FD9CE10442F900321F069DF164D255C85C0DD7D3D5101D37EF0246053B0E2471D02D3848D77045C2160137156FAE108F7A0A99C070FAC0C75EC3B013312E600C64E20320D0D0D596C6A5071158CE145817A54AD56776826C169ACBDAC05B87852C6D00FAE50E2034ACCC404E944C5E4A04997DB9FF8E5904BA6200C20810CC8C91C0CFC839C0C72F8F8FCF86C327221200CEFC8254D5A9E0CF8D5A415123E9FAE001939BF2CA0FC0C11C841D88CA032047284A0A0C955C845A0A0E400C905A0B01CE410F222B06CB01C2047C901B06CA024279007B01CB06C52C82417A4A41C9AF1818EB19CC31F1FC0C22A0286E3268150F176B4413EEC5BE86B08101A8B0ABF3948333D4CD10C7370402AE43252FB59F874ED3B774E023B46325907D013A6185036B05D3676D0B4D004D4D8051B0401666A9AE0E4E81E46B3907A2ECBF0EC50FA7DF003C22D60DA7CE0EF2A5B48B86ACA1118084DC6B63DE08103909FAEA88A40C50E1E4A0464215229F8B80C578B3B9F5E79498002B8BBD18B093974EC5F22755D84454C3BD15E333B72780F3A120CADCC08385E80754440DA192A22FCC4108313DF0E27E09013C74A16C2D580E9F17352E6284C2BF0FC8F85C7F9EEE0F2C1EE1F03F23B4FFCEDAB21FBB25C8BD404B68D0C818B4750257569BC494C01A03451E88C007A41765B0503DCD410833C145EC371C9C9F30D611806461C0D26CD4E483E2D86AD420B8BD01E3A8B0A370E0A9D4E565F709A6E258100BB8141704185BE6971C01483C11470DEE883481A3885B41F1C8E38806A7FF10816D4B93C02726C72BFE12E1803DC560476C1E0040307E054BD122255FC3BCAFC8CDA036872E47A70EE0A080CFEA669080C0CD94010D95910328018180DFC44837DA813D58951CA50EB4FB1857005A74767810AA67975423B454EFB0A08346F9A7616A0484658108D48C0C00307D2C601507'
	$sHexData &= '55378F0379A30872FE106617F066169A8800E425718E0345B68995C4B085FD3B0AD4687859F9A032E9826F95D7243EBF9E33BF9AC033BC7F84586A11181E704AD4BD7D01C54CB00B30BAAF577260377602BC6648D3C816F3F13BC70743F10C94616EB29DEA4E1606D7368C05812F0D6C4C055061B8343041C3F8111A5BD7F168563010E11158B4E60AA315F979CCB451CBF544E4D2D093C153904C75CDBB01CB3151081765D1C8F77CF744888832D8FB68E83714F835C19445A20471C3F1C92B061F4181094732BDD1588EF3CCE77252BF1B447C9C7EFB7A92ADC91243AD904B15ED91894040A953DB5C33F04D906379751C814C7FF9C72C430E418BAE164A03A40E75E1EA1908E3B9CB43CDDF68B77E61CA17DEAF8708B13D08DF64110AA4304B110C4A847D1C1FE2B394B20894E20EB45955F1B32FB6A5DD8E81689138D4B8D46E2C1CC054E92522441A9500931FFD35714C23CBF8D59A0802204AF25DE43608222042F15860278B8300E0E60158B131C8AF84008347D4823A6431E6553C3634211EF40FF9BD1405E7B83015F8C0C902D2984FF188C166EA0A78D79A0C58D77606482108DC71B5790390A9495042202219C30058D4F44E89B30730CE2AEB15E74506A08564DB935394E1465009A26B006C6D724D8E6D667083309C64018714DC25B88C6460D1F69C23B001747837FEE153008FF18B2441202505756F1BE0C98E8EB0AA23C95BCF300E13CF64786474FC29D8C470FF01FCC024EA40CA78B792A04E5E02275FB108A78A3881D8D0C1F67630EE1D9C39A11DF082FA1532A00A67F75D061B3C898E676732735578785C4ED33C77CC40677B80D69B840A614E80939464E2E42E302EA2C20E7897EA80D083305F410BCCAB077DA85B9CA205E1B18B46095D0445A3F532051517D0EA683E346697E7211B90587C4782603355F5F5A1C8B21DFE84294F041A5100E1157D002B52E5A352BC1FC2E837A753D1715E4F88E02C24C48B463607A3C868406B713AE203E333F39107412724975F590503838683CE30DC14A0FC0F0BE15D24AE25F36668B19663B1A75217083C29C401CCEC20EC7F5BFDD0EFE5FD45ED1F86B1BD283E2FE4274E0FB55C08FC0C82B4DFCCED1F92BD103FAC091B542E1EB837FAEA3F114C07164CE6ABE1471867076058396F8E7E0F1AA2C6007C78D34489005D7042E50168BCB6A345F005B20321661A78C078F5FFBDE2783EEBED5750E8B2A270ED22A0FD604CF1BC1125890A8671F5C26E4A03E56166E7B03111F81F3C3BFCF41838727AC70861035FF1FD8005FA41A5D1E8EFF04952118C34713C1969A42A0E03A1FC60313B5D31F1033C0E291D228EA42A8467711850AB7B1900950DFAC29EC6A0F125806F07B20FF2A294955F052C745F0148E98'
	$sHexData &= 'A4DF18E292709CFF40F93E19589C4840B6ECB4F668C5FA3B1875618B5024393AEC12303CCB4081190E6ECA28916281AA782BC8EC66E4BD293CB69DA869897DFAC11ED4D3897BA28BFEC743A00ED1BE9F8BF33603D77684E02E9C0F82AA2721A9339AD821DDCA04755D3A3939EC2404ACF409DC206A0E08C8D09AC402C9CEE20EB44489D17245C8B610CE284A334245CC7EFD99F29EC8B87402667B8D7DB85D94D4816FCC0867C3626DD424290178A1310281440332C0C32ADE88806751D6B87F6A85F856B001BFEE572BC2B0762CB8BF710AF994737F29E15A3803C11ECA4A8CDF7FFAC1762C8BD1D1EA552BFA9EC44A08261C7C42C8125B093C6CB7DC5403CA1FB14A8524BFDCF12FC0B3CB6C3B0875453BD0754150B3712420E1A3B18E84E57FE4C44307F18111DEC62D8295C6BABE647EC2425155F2D275467DD81E90463DBD61750FDF7FCCFF4C5A0AEB1F2239133B4808750EA15ADFE0281441ED4252FF54E0016054893B4D0C75A0AE9844D8890EE3BF75D68F54D3D87E57FAFE754C7C8B98659FDF475A50AA56671DADB73FA716DE5237323DF774C15BDF875A9407D010895108807AB6162A65447C4ABB50042BB57D14773B1C75098889082AA5AF5276C3323B0A6802B58A48CB1D2E081F62570408781E11089F951656390A48A12208085C04F626B648A7579BF0752A5159C3FF8C78101CD6FA5AA141109D668F18EF04AA98C05FC37F1398FE472126BD33DB395E540F85A41F8DA7A60B406A1267E80C893F4A87FB0F845880804C04F75E1F4011506008F452F65450151FC0895EFD46C8F01D4580AC5D0540EB0B8B8D48114D63F42C793189CB273BC3CE894145BD2F33C017B188D5291F1578100C9008EB5F44D07E1A28B45EF05F4A10558555C0370E074901BB8105F4EDF00E6153523C2A01DDA3ECA8296F60BC3768D419F80CBE058D8A6A6011B58A0003D1BC2D38D4C05250C1782BA21B48C01788BB0483E8027C110A0F85C67B323EAEB1C22B03338A970375D02BF129994A6848FA814FDF789099936F799002F3EA8170682C6B9ECC4DE44D59E06E000F869E35E1CF2BC198638FD67344514DF92602C7D4748630E509B94AB866630826D6F6E0881C306EAD846475CB2E63FBE0E11D88182B43B9EB0A17207043085F944A2C0E057F42D32ECD5F50D84839AA1805D05E2576F0703C89322420162D02987E40302BC9D1F9BEE34DE11CC65E1E641A4F375B6A15895C62308B362020EFBEDB162A347720405F7681D085D183C24AD0803B19708A5FA0084AC9A00122A974405FA0A41560250F98CC7F2417814CA0A0018A2507A0CADEEE821E2F12BFC12374F5F70436FB658B3D42B2011C8B0A5FDB4336C811D1217E10FC49042AA0156499FA3B5E751E6E6D686'
	$sHexData &= 'F2374EE14C33FFEA04237FE312BC6C1F8043D820F913BDEA8DB682BD6404A3BC2762D88F2D10AF87F85EE100F2BFE3BFA5F730F33D256859D765E42D06FBFDC10D61DC2454D0CDF3328B4D6C391388A7B9AF70CC5160AF0069F0E499B2E203E4EBEC6102478601724DF8B03395F5E897A438913AB924B08DFC80C6938727B3F2125437232212121CC801CC9212151212F800B66392BD72DEAAD8D86F681FECB3C0C5F513849680861464A29C433858AD09E0C8AF82CC42FA1C0A8C6508AC1AC48EC25F6C21FF7FF259FD80128FF545555056877B56D51FF5560FF62ED12F2C29C1EFFCDFA24B1781956C2F3699990174C57044892240979B98275ABFBD7092DE792077749640911C3E3C4B6825B0B215F91904AD12BC242023F89D1273E5040534258278CD65543572B544C9C555EBF957C621846BFC6711C0786BB1AB651BFC760BF0139218FC4ECC4EC54F2660BDF12988A14C4830BE0DA4E0EC1714BF817F4D10892D40B1DFA8B4402380A096142151A8C919CDB868239315F4010BE140C2EA9B2DD4EC34027B8D4D8666AA5B12E754C77A3A0BCBAF46684A7578D3C18E14E140E978A441027DB550C179714687932E12CA6F9D3342AE4F908720FD27BA74B0528C6620C1D19F1083A6862BA5351A8D025A5EEE1182CED665B580C785F7B1F0D255CDC1F576F472B76EA065AF649687235755B776B1DDED6982042820FAF292BF874D1FFBCDA000E33935FA1BB81FB5AFE038CF9C373198B4E105153FC05065D626567FBDB75F2895ECCDE72D2F85BA30C1D70090EB619EE57E9FA2CED2443EF46035B6F1F0489D118DF494F4BA756425362CBB18496FA1BC05EF7D8518024D205847F745483FB08734F5760DF150F376842FB65218B1E840E303F09801407BB217F662DBC71DAD5366983B4B6412D147EB05FB3FC5D0168930FA4366606D2631589F55F805ECD50F572F34606263C646884E84E40E16112703450BCF5B44CA5F5533C7E86D258C3827802E2D948942FA2BB4430B1B1D6935FE4A40430146A07C17F46A81C124E0B77156572D45855873FF51EE2362EDA83106A340C4120CAE78222F540E1D99A897D7433002A419836CE57A8D441A828082A642F205D2C4CA8B40B741631F9B00E5353431556A5FB461C132424616B94764A9D55105F0933D954014CDA4004691E08AA26E4D54DE451E478D2300C7F1C9362EA8B5CD616D8807B2D00DEDE7E00604C804DE889E40F851D014DD0916008717C143EF1018589DEF0EB0E1F50FE7AD6188B4E36BA8755F01F00815266562FFE0076FF4724F739532072058B530C62084090FF26A614668B02663B01752CF0B19DD9C8925A720BCCFE161476029B791E0CB01A0A25187054BAD012CE7E02E974D555EBDEBE6C238EF2C2'
	$sHexData &= '7466F3C54BF0B70453085B3BF70D0A5E5600FEF87204F0328085F57C4C13D3C81ADC11174D0B5E09F8330775460836AC0F422547E8E86F80118B035E480F84C424F78C9670BA8D023542149A910D628A0051495D6709054AE4ABF08CE1E1ABB40E8378EC581C8D480C57CF53504096D750FAFBF3720DCFE3837DF05B141253228C34384BBA5043FB14F86ED8142CF4EB103FDF40EBE83B78814A8215748D43A6502627E2E85FA780563211895F984B395808A1531AF87EF88F5FD0A589082051141CB1E0360F0A5504902642F4080C86F6608E797A3CF7CFDEB8E0012477189EC130900B7F20C31C950BFE128B5B08EB127BE1EAF240600D3AA81B1574DE182153B546C11FD570D543C814F96A281DF009BD2908DCDBEC70038B2EE2682C5E52F5927024E21C46052A9331C2E23CB04884E3064E862B524DBA01B3843257543D41057F4DEC510514BE34F2D2525255DC52E42B1221C4AD45E050C8558DA5011FA02A420E14BE60D0830819A01820142242CDBF4A43911C168A87470A8510E9082B07BAD057AB771A1B69C8FCEB770422C46B9C0E528830F93CAA151307640740C464F00BF61B4F5052C0AC245722BEA55D5CC1E30403D844F0EA8830430E9A0743499EA9650408D78AA134EFFF2298A12F6A573324C7F34E9DD41E3E897E087E0CA42DB538A1E1293E342F75061CBC3B363229755BE1AFCDDC3630258C85D70B0015846A902F75851C178BC766208754CA9F1E2121C9801CC8212121B252931C215620C95CC02D853D9F890FE7DF891683E41370A3F1900F4D6AF3CCCB56082B16BB8D1B94BEC17361A6CC0C0AC2A02048A4D02D1659DC45ECBBBC8B1E047251D77ACBB94E028B9D29D82E9D189884DBFD4526800A3B6F6F0AEC8D148810BF8956080AD2B0920F900645EC50000417313F00DF28D24ACD7DFF48C72B484C600E9BDF229634F8C773778BCFE36C7481C228840E50E5FC4B05D235D80E98D1F88614A729DAC18C3EDA440700C5A417CBC1C311090705DF08038ABEE0E740C1E104F65B03C8C1E2E8D0C12806A5380BFF2F85400E1D403E34405805FFC3D364E461027FCC2BFE62F481E216515732EBFACC8B3ECF0C8355CF7F0508FF1C7F0BDD74166306F9165207E1E82D4CC50BC81356833ABEDD1DCB1FF03000E912C42C8E2F3522B5D45B9FA142202F17E0281A01AC869F0D10F272C79F73CD2C818E97E4FB9C7D9F866138929CC08FDB830608F58A8B00D3E00DF2E2301F141018C260444DA3C481D1052C84CE0F1A764CC0FF77FA278B5F1455AAF7E68BCBD1E9D1EA3BCA761382FBFF9122FF2BC18D34193BD87605BE1BDF0E880DAC4E0156C83C83F9FF7713A604D2A15117B0B2EF9051C0EB4D9220DCC745EC6C483324DCDC5A2E0CC4326820D'
	$sHexData &= 'E53772202BDCD8C8450031037E4C6E1C327E8E9120EA0F6461ABA107163D43D5350701B32385E93F5A00FE30CC69E0219AB487C771484537F0604C224F8C6041F352D0F50738B7508076D300B87F4DB1EC6C83524A2069BDFE00CF55172140781FE16C9814C34E57F7FA8349770189114C470442130EF165056D2F00648ECE093A9613333ED0C64463ECDA79CECC8580CAB148EBAFA10B01CAF19EEC14BB3F138F7A2B7E1528A177329B42C3C4F871FF14F08FBD19562E8054FF51B185E13D7511D511EF5FF01A3B0BF0F7711C1E104517C807C2045FC504DF051E00C209479E12A34BC3B25109143E303B7B20C2A2119CA2F9517210A8B45101642687C6C2123BF5568B4ED04252F187549A6D0B8235A1F216CED4198219E524A084DF897F17768247C5B078BC6688D566761EB6FB7CF02F81C854677CC235D21210F217F814D088B49045304891BECFB9B50208A4820885020BC884B0AB2B3018DC198FA3858200F858E32EF20180C2BAE9428E7322A171A1D6920657C08EF26885920528220A7D0B0F3B8CE922221F299027093C4D60E74656476D32C622C8852C64163CC26326E6D8A808822885E2044A57D4BBE5F9DEB78CB14670E839BDD86C913AB1ED917AD96B3E7088D1D44323B159BF6067658F76C8FF509F3101C8148B488E4F10880C32640743638A88B50EE14DC228B06BDBC71090CD708A23541206EF95EA9696610D804141834D33984A921366E945B3C0358144848145758D57A7A088F5F80FCB59E765E8903C003C09630C316BF45566A22A3A9CABE491EBD479889ADBF4C16AAA017DA771BBECDF3C18BE185C4B03F36270C10D23FC93C32D25854800E130B560FC93FF25F1D0BAF1FDEDF757156BAC934EA8E03E077081B33D2F03D0302392D6E1E0F969372CA548E500B231301214D16AACBF8E3E256E9F1759010634DFB35A95789571004141829A451F8D7807B44FB74915EA940AE43181EA5210437797E55088B52040C6B10C6BA3EABF6022321C161EDB17F840B960EC5BF0D49E56D3BC5C1280808C26A0F21D0C73019921EBF21210532C8AB9F134A1C0884698046FCCBD141C0871FCFAE78F05184068B744C3228443220FB76853B2C7C1F7F5619427C157F053B3E1185C676760E2B081BCF66D8891D063602EB0FF725FE9B290A04208B5432388975D885D2D88BB1AD083E96FFD2419A41DCA106F6837C306E10749781DBB8303CAC8B205502B295A237EA88C54EC4120CA184C936F097D5053404D9D0CBDF43FAADF0741425C0E540743A85FF2A9271606842DBDA0EBD1AC045DA0FB754B24C303852305EB3F0AF180785ACEF2508FB964D9A6E752EE5431F9C51EC5B31576FB0067F1730F0CA50D70F848E2AE06033FD7940B39DD06B5820062473'
	$sHexData &= '9A8C51013501B21603D660E38351447F81B4061E20D8FDCFEDB42D8C18EC3938EA1411BA055C03F51D50838B9F83C3FF83D75EE4F74DC0236E171F180F8C709C08385470D7BA6612EF75099FFAAE33E785B5A155E4FFEBB9E0107348C107686A016A70C8018E8773C7B858D1A8C3E1BF30480E390A144F810A761A58B2781E2420B0D89112B11E7C1C4CF19BB54ADEA84DE0DE3BCB760C2BCB5AB23FCB88F47DE8EB0A4C1B1F8AB300D21BBC80E03898748C5B80D0D3EED811E281B981E4D0913C40D30E3839E8F8E8A62A1575B4896BA82D1AB6D97C7C759B797CE64C3138865354C91C83C38584C3C315C9E04FBAE9B23384B5CE8EDE4AAF3A0EDC747FE369D2F86172A2E34FEBCA5DD3D7FD598784BCDF4CF08D4707C90DFC0CD9DCFCB49838E3305D8BF832C3D869E3B85FABE72279159F17B9F005A40E08C1056029629C2FB698C62924D98D783008CD8B1F85C9C746D0655543C2C2B0288A806091CC7423BC226197F4D3B748741561E88D1CC29B2378403080B0EAB380D23218A7A67C8ADFA3C0C950578BDBCC21F149182CD91F1B2CEA067057A7367D5B013803C7F87F56C3E2D2C777C1F861FD9E2BC156A434851AE3B09E69565150AB24876A71679F12C9120488A023C6BD053F4C20E5D853488836946A0DFB305822FC839FD19092073B700C73232AF7DDF4E08B0CB1841D802800741773E4354B806273128B5034B20012FA41A24EE38C75522630D09EE20C4BDAF0F174073A0061C21C5ED0093D370243047807A3BEF025C44D44982A7CBF060BF96D8C573006B5F4357C9B065631F1D4F30D388C60FF45C601A01B9118136A1780CDB55F1E8447628588130A10F400058D9838A56A1C471C503C1D3BD45E10E03CB4C32F325798613401923B83674F91B4490F896310ABA8B463A246835F85DA23373A9642302C83C1827E3856055C36C4567F232FA5C012D12A1564C1680E08E68B01945AE315795C00B8746711CF0422EB9ED21C11F77CE7AC0C3D2053F0563B58844E50BDFC515670AB607E7D2A75EA56139B6DA9FB6824759D5858F42C0853601FFC2F103B8F7414D40EC04FD23748CE3F508B4751C5C61AB819E10ED8DF04A61184925413EB361202D5F851F19CCCBAC61A01B01337DBC82113C5DFA4A024472543E4E451C82453A0E455C91132E4E447C815C8A0E4E40B805C20E2FF2A0E84A278B4A0C410A70D615C1592B4572815B686E76AC77960B70E123FA23B30FC430C460C0FD8817BC083EDCB57815A54528354A0C7F0EC48EC204F3BA45453C20057510E973A5B9973491E755F1268BEC1EB6CEC2A3941330196DAEFB975741279F365A9C97375A053C1CE88931E2FEC4CE068E7A4F9B5567A1491D870A1DDB8B556BA75F860ACA179B8E608B60F3'
	$sHexData &= '520AAB1663F0456057185A647029ED872483FFF30DD47C376332917762BD851D1F70139E1FB535693D1283122AE66542D46FACB0FE411C1CAD20F849AE840869010196C22E226E85B87F2A5621334641087612A9722A85E08120C45C411A253A5118B6D8292872111821558DF2AE15F6B10A439F8363C7738818878A35D2FA3746100B9B9231086C7AC83594836E98C3C6C26868DC13BD737FFB8005207B1C3241C389788881D02A21C50D54DC5545227467CF8282A884A400426E2F0060D9A77F80D5B9D089BEE7D414FACC6DBF2CE5CBE09C00A67FA03FF5103C744E01A17FF33CDC4D013053C795E0EC7DABD27585BBDBA1BBF5B53AFC7B8A8AB8BD699C9C6C73BF7BCD7E50195E8D0A8C1CEDA27BF6E9E5FC21871C04A0E0FB7BD004231A00144E0FE4075894DD062BC73090F100410CC7C1C3808E851A9671F800DC452E40C0A5704E01416E03E1CB0014C984263017A88457EA05DC22F48DFFC837A5E7A78E397F01C8D420C887DF42386146C30B8383BCE62F118A3A096E803690E163A60239E5E3938800597E6C1C00853F8480D4C829458A2EB0706CEC62D51DA330407D652036A0446265171D4608BD140D88A6D22B1A0B11FF8734201F5EBB8F44E313B0F96C3804E682A028D0252578BB08032E0044C6A04011F502297E1F8493978136568D14E0C6443855D054C08B1277A14ECAA9C46D34A6051DCA5036AC9C81010D31ECBB8483D843FD3C5414029C2D752E0D42165062436570861F2CE0C840096618954FF39C9B735F51AE1723ACB350C49076A9FC94B26F996B170DCE4BE6102C8309B32CACA7516895AFA150AD81D680D0F5908D6A9EC6F1E38450C74108919333E153AC02AB5DDEB1132219E037013E8F80FDA8BCB38422C409CA979FB58043E512072043B16C77B50EDDFC1760838462C751CC64201343A9D02D6A942881A50049651DD0684E278953D7071ED592A60322E32622DB6232500235644E6FC3902BE35DF4EDA5671043B0E7B0D40D11648DE0A89A4B6BDB5B304C0B911908B7E3E9AA6E9BE3A083847A1577A7E3DB013D05C570BB4868354DA350B7536240808898654C1B13739368B42826B82833F8811F87E31088901A59D830F180881412DA3C8EE048D7503B01496E87A1ECE10C1088D052E7A7707E76917378616EA80C08BC4163584685AAAE8B19A8FE866185479132F12F9FF21471472A0A02453811CE4E43205C845A4A4C9C9840CA0A0A004C8901CA0A005720072E6A04CC9840CA0E6E6804C2587E6E62153810CA0A0201C2013A0518682BA9F5F0C57843AB53299BE12B10188BA865E5C7D6F7A803B4844F80F92C12484C90800AFEA83F0407DE1FC0C2634E4867D03A2385E4645BF71D34208CF8BC2AD10B816C631350D6204C6E7'
	$sHexData &= '0C999309BBF9E469B86A7A33B0BE73079E5350EBC4E810D32AE3599753DA0243DE273F0E8400E8A770141F50C281FAB7571903DCF275108D468F568A9598220788421ED8F8B4E64F7432DB9D69189E020DBC9339B8781B7E20EB1D3812740D17A612F3C8DDE080B48979081BE57A149DE64D57CF385A208FDF204FE5C9C15E20202003A93CE45A20E95F3AA58A0EC85E217004D9017914ADB3D95F213C9213D17804D3E959E95951AAA09B39367FD2D12A18483C7DCD8CA2B551B5CDC582681581C794C744F3A2CD5A2071FA40D107021693255EC8149AA44820DF10C0B771D6F8CD06036FA83C829205BA31DC46B1CFB70D97B01C26019E71E3A0D4BDF4C30ED91C32F4302E85118D446936A5ABA56E6C9BA91DD3466E5C40A25103C3D5C2A949CFD5FC408C20B4BD9FB403F852F8DD81CA40E5A75733F706A00E7945EB391BA41F887A601C295B501422EAE61A08C839563110D240397E875EF00B24A28B4E107212831448D058370885215B23340E2B1571BF1072AA25BF060C6EC85E96849C1A7642EF3FA14A6D0C908BD1170935937440F51111423343D73FEF5F021CC8C0360FBF212172C92583212121602527432121D451F24E3F1D20F1E421E128122BD6B7E9F1D3D9F103DA349601643E2BCF3842432371B90BC4441C0C0229B4DA18C6031E616EA7099188A68312A703CD47E8C8D1E98BF90C01986F13178B0CEB0503C189983960BCCE647050F7A7564933D00E5250BC504938081EFE0B86E092397A1B189FE30B002D0C0A3099481A5CFC2876AE1EA2246E21143697E30A4810412ED8A324EE4C12729B710586022A6FEC6B02A425A1E4104D54027BCB75E4CA505815110AEF2B5881E036894604F08883502DBDD0EC3C5BC1E7FA0F6A834D67857FDC140184D5096D68D69F144A14840E940EC208E4D38018076BE7E5388425F04A1A8EA87BF8719A9A9A14B93C575020041B9A2DF32C6CA584DF0EE18BF00D03F032126983C8F80A974E941256A245F06503CA865160085C7EF0C1F5A5A10A94F45256F2B1EAFA29415D101254F13A0195AE9252274071EC99B0B8CBB7FC35E897B4C1104F8F5B98F8011F198A278674DE11FF7C826D8570C633487EDFD3AF0F76036B0E57A7FE2C47D8BA59C304A4C7811C18251707B4959FB55233214F086A300879F6C091264B0F155421BA19D8754F08FC472C188D770CCB019D03C52150C2D607142E43BFC33E365C4897431C380A35194E303D746C8403A99D3403B1F14808A3E4E44A8E2081DF9590414E2EA0A0A018653C281F95BF900603640CDD248660005CEA5444B47189875C4B0438539E9D06BEFE66C747468D4738A2563DB6E28D5E687004B22CF1A9CBF3742056D93A1371B7267E2C58402041F0FD7603891E430'
	$sHexData &= '8E541901098B9E8E5C1C84A20CFE8E8C0C077E15F7C3B75087472967424FE2EFE745D837F3F079D7055843B0F6A1CF25261185656570605B5701FA80F891E34BE853008567C896C0BC0F707C358CB83C71CDC7594C12108440E7C81AE042A8D38347228833E18905E142DEC06DE467E512BFCEC94308D56D8985BD506CAD1D27FA5B900391824E8184783A15FF9BA06427772FB7430422C1AF9819B9A2E00CC2BF319EE6488880F8D044018916D2061BA95C38B0DB670C8D17F686857D318E2390C5E89458C1B4D14364D9C77D85861EC80B58D14B29C5034DD3FDA42C3DC8D349788B090A097027E66FC4C1C5E248817E13B28288D46DC56CCA4FF559CBB06B48787751646561DC1012D1A2A75A41CD645E19B788A73218B7D9C4CD733FF6BC36C139E1508C0244072DF8BFB8975A01F7B2CE03B7D9445578D0F85A5A60C927C1E5657C9CB3A9720C45EF8F85220A89851C39A8955E02A11C28B93A082CBC034BC902782E9AB7F07890146E87199929835E404494FF84E6B3ADB4CEE4A20329CB251AF801DC2AD4F3D55833A12F2371E895720E624F8218C0D81823FBD3945908341C12998D946DC520205EF4CC156518BAAD852D1DCE08D71ADFBDC83EE24B5CC8D468060418B1498BBAF760ACD6056A9DAA455996960066AAA06DCEC19ACE06BF9AF5A013A1756B0A28EED922074203842B54120BE11C6A2512E6DA42483E88C141C18BCB1C82D3B857783FB8548F2F3842B0310DF31783085B7068B518CE562517041852E02784E9E7C0389068D438D4E4BCC0EB06C386E45184E20E0134806820BB7EC734B0E0F96E1C62496982E1C8BC60004627DA457318CC56A3A68E9C3338C047E41BA8E91CA49450310116B78B89DB74EA4E8988942C760362460C1820FFD64D8A1415556F3F7C585C769389AAC2E18188CA485D03A8F47041B16899971A025570E226A04168D461E06873B46204EAC16B33280341FAD4E164E8A0F2846BB83EB24C16211908105248862518AC77BC75401644378D2FBAA66AA340D2BA847AC6DAC79261969C0BC57C8EAE092A7A0060F2B808C94ADE542B4D262F00E1C60082AB7AC7248739373C8A0C0134B176E4233FD66364EF068C2ACE65D458C890610959C5841000E3D4A5FB21A424143001E89C1C23A2D317092680652849F3CCA75EBC7AC64E495BF178557D44CDC4CBECE7438A62CD45B4027A250A492C061557A20178B398E696CAD42791278D279080611957030A10C044A982888407010EBC46341043C48B05F582D56292910607FAA182607EDB571D4709814A41480DA8C926B801F65751054699EF9F8620388815E32747002088558A8C03BCBF406082F8B47960CD94710001D6F3448D95E105342145D003E2E798959107F3E405421E4'
	$sHexData &= '88100C1902B52B4C30EBAAC4EC628A0CE515E20C383CBCF4A3A00FDAE6535359C6FD1C358045BF05C1837D85F18BFAA85F8FC765E8A07F86707B5E29A4033AC85DFC170178498747108D540002524DC30E970625891F2810106234D434141421143C7A446D32FAFCADA990A3083F455CAC94935E29F40E04F15221841A127B200F521A2424EBBC6A4C388147A98A1B1F1014E2422F6508A7E3FE13A0FF5603C2575383F82811409983E2074904ADD822C1F8103CC0BE68B4BF6EE6FF02C98D341F08565825100CC88816DC5514F15559566790FBF0029C7BC482B7B6EE03C320F83BCB7E4118D875F84168DD036638464C735D0CBE5D6B82AE1E2BB7F01AC6F84DF38ED901BB7FF079F85C5707366B6A4DC694F4620A7508DE21AD3902A408A0F405450C04431C20184F10B4694D8B5A8B57D5082D563215DCFCD62F08C78AC9C4575221285230C8B46307552052CDA0801C0D185D7000080B955F9E4206391CD830FA2BC7B58EC532E88BC80FF092C43FC78BC399C4D1FEAF266000EA48768D14F6A806D1F48D7C972096BC5EEF840A75535A57ACCC7015E172DA524ED7077D10F8BD60BE45C8517C5378901346D6E570036C2C6307CC7C5D8586B6D181EA7F911FDF301456DF7CDED281FCD22BDFBBEB2AA9F0B530386E0104BC26F1B960A947D6B0527FD64AC510B8959F4E14DCA8BEF11CE2AC9BDC8240BC0F84224205B1F4A60BA2C8AB108A11536C57280EED0AED4AEC52FABF462A364DD6C44F4E2D8D129A30F873448B469858F04E3FC3B5CD08E0510CE4A6D956DC8D46BC5105C7E689163B75D95016CC4785D71DF7890E52B649ECCDC8CC6E6E20EB66945A40EDC138189FC2351FB4F8820A858C50E6E417D78D7008891AFEF2A1C46107396975D1C4C16E64BB376337001B89C2854ABB800F03AD3DD24285DE0C58519CE8CBBF00C25432251030365CC8DBA8758A7B0733A040B87E3B0C72CF3A0D3D08B58B300EDE98B61054EA4838160CF9279C05860F83C01453044B0CB8897914F7A02AFF134CD23A1310894508EBA810871A8C429EA30027D300D4F6F00BCB055C1BA4336A3D0B6B2BCF372B5BB17461BC8BC146FE0A533592740F99F7E878FC5046810190F14AB503841EA67E6C402E2501B0461C40EC7E5D9D8197340AEB06FE3D5FF7BF0E8D3C138BCB3B7D0C7503E6BE050C3B80D0648F0ECF3B00ED0AFBF07D05037D7054D62BD06C52DE230C13C21C60C9DC48C186129A7630E97FABA190178A58FF1CA8D58C35053B4651A84195DA65085303044126D233068A7284E483014FF44666782C53D3405A462A1635451D1650A082111F0E371C0A9B70743F02D4A580133A727D588AEB50E03704838D48DC515003014E5A607FC0B6341C938B133A103C816F912'
	$sHexData &= '1797C434B9E36023B75BD66C3EE0C7CB2BEA8A04576DBC4F40AB42A90DC280C7888F799A886689AC01400F100D133FC7471980DF842C786042CBFC514F8607547FF7F39F0E1069D717D4F536710851C81524814DC1119352E713D8003271E917DD67E653CF89A7CB35B71FF9A0F8D3490787D21BFCA570447205FCCC85500C48C3F1F8AB801722CA84D4733E0D6DC5A32C84ACCE0117550A153B54684A325380E530F0F8052013381AE55475C964EF20203ECFD2BF780FDEE4558841F505733C01B0D4A11014897408EE020FF78BF389338A4B15743D08386A0267218B8D0383CC03052126A6E2DD414CB83310D851C02F086345D1960083CE480026008DD175A476B9C4B5394464F57A4F0CAC0008E821456A953E1D60BCA08A710AC3B5DE966072E4FA6D147FA9D01B000C956E261C5229E7C616D92C440AA0DE6F30034DCBF0821A0DCBD1C5A122AFF35DF089859321A0FED615383906EB947034F7EE6A321E3DB9A867EFD1269520C36C08297478AF08365D0EB173B3CC1998A3A53159F56B4117277A14659A121E0E08382A21BD61EFF65D485692C97CBD790A34C0B50545872B95C2E5C606468FDDEB7F86C3B0D6D7502F3C3E98C7D8B32000BE0E5F20B080C186ACA61A57083441B0D9CFF2E902030DBE84DAD94F41FB6A5A14C284E750821D49719FCE159EB64030D90599B5B4F602555BE151CE06E75CD7727266A919850678A9AD36A024E3CDC8A20A3D38491E67112E01CACFE9CED6C0715268B445BE1C3D3845910D1E232F39A418EDE03C336D8065948CC7B5039B1110504360262742560A8FA96D61170778644E9A7D1F20C380E78B793D8F0D5CDA4EB142C96D6C9C8114E57C701A7816676A331EC8A8043C1E0A076D036F0CC8C6715C5C6C15D7605DA40DE39AEFB5EC3832600C7E7EAD6952FC704247B8276D9160EDF59465E79515153165E6D43008C9A75323905E5BAA62FD4987E23BC18C90D1BEF070725B09F5D8CBFC4146DA3B317640A12660DEFCED188CDD0BC85B3F464E669FA7D4AEF8B590455E8505DEB117122B4425E1768E8882564165DD43C0AFA30B8A0E78E0C9EA045F7A15098025EB06AF7E04722BC1094EB39723338092DDC397730C7053F51358E5959775F672E647A3B2C0832FC318859892BB81016D53259395D9C08CC3EB9BFBBE190391D2A18741C680D480FCC683B56540D6C10567D2CFF1C143438F5A7EC5DFC05871686940D5951188ADE5971430C2884C85CA48303BE507A3C00CECC0883EB043BF7BFF80B46724E833B0074F39DC8390374E9FF3371D10E4059F8212455F89142E92E0B87368C4A760520C54D10CE2C74B789128AA5A361048E60AA1F99E09D2075C08325D0045F1F39036864FC28C263D22E504E9CC9C6D2E9C9'
	$sHexData &= 'B010CFB0C0E954A8BAF2043876AAD541656CE8AB80ACFC661F2690D4822B882EF8C5C083E4E80BE8900583FE02752EBB424A7D28336494F253FFD0764B054181C08D22C33A5C8FEBEC282580250030FBE1DD7A3C4FFE017524BE20575027575B197AEFE45FA56E22177627BAA6B6D50375439F68386CD8D90321D1742E5925FFEB1B90C9C000FC98F46A8B95AA50514F9A596265E873AA8C4C9E5EA7B50C0133068F48E4D6D8923A8351A63FC3D47BA0FC9E403C58A71A0AF659D175652C5B2FA064C0FE0D623CE10C2B6406D136E3436C288BE87370FC058408A93B4367BF109853A951E181EC73BB178F28F65A84A83E0AA48915F7F3F3F3A0891D9C893598893D94668C31699D795AC00C0DB441902805F9699EE68C25882D849C8FAFB44F50B8C6ADAC0E04B08D45080617322ABC95F103778A44A6BC0138455FD7EF0CAC27A009FCC013A4F9A3E9EE82A88985D864151CDC03DCDD0DE77869F06A018BFE5ACD743C596A817C49681580833D9F1B66E841008E4768B737849B031F433788C9A7E00BE1FBC4E5DCD85F900DF9A7FDA2B4D3D6896C068D3C182ED02BE04B31CADC89B4C26C50C4E2F88BC10239A4E168EEF0F0BF0FBC5A641422A5D2076A68A8283470A34D422280D208267417D8A726ECF0C314783AC02BFA6B642B610ACCEBEDE4C58B048AFA6FDA000EE0E0813863736DE0740B30EA76C444EDDCC3A14808B750F85837E96E6A0CBBE858A249F83E80C6A610C02D40EA48DB0AF1191D0B2901D5F04C013B859D668B0EC3951D75110CA80B049D3D1AFB1EA1EB53C4FD546E56B8DE50BE09E1F40F8242C6730F8B077A7C20C86DCCB8FE72F108A90C33384B58587C3914C0038BFFB84D5A5E140E09380120E068782164413C03C11050F8DDF8BB5F2AEF33D2B90B013948180F94C28BC225B713816D7FB262C80FB702A2A98541580A7176D158C4A657AE0818DF7DF566A2210FF996580803D9C97E45A1980A38C0283BD672E8D4103E2274A12DFE1845FAF8501877AD169346EA60F8B3F02F20120B7013504E1DFCA23E563C1F542E2D508239D62750337C8A0DC5F8874024B8F722E0011D809D5AC7C7F510995060139081C2DE6A82743CF3C30774612E97EF51EFC40BC0BCB88003B70EA7A47B69D8FF5290F85357BF4EE640BBBB7C6C55F0AD670D85C374091EA33BEB65AD993A2582F8B76893EFCFD4163330176C33F00F70756BA4999C4EF074A233E8EF26991822CC07BE4FB2EB1085F3BB07BEDD210D1147C6C1E0100BF02718F7D60F375462E91CAA6FB40B282E97CBB0ACA8A41EFEC1C20A3033FF1C0BC07D144767F8CF22FCF7D8F7DA83D8EC264C32C8BB891C361C181C9C7510F6182E344C0E7F970955866CF19604BF7B77BF0ED3EB411632681'
	$sHexData &= '427D1EBD1D9D1EAAA24FBFDD1D80BDB75F43EF0F764825644B0DFBFFFA4E603D1720E3B4E770872073B5676014E98046F2628AE4FCED8E083DA005B949070E1168B64EBF4FD76650BC80A0C75091E04F7C3530AE03EFB3EFD08B4140313E103D35B3414F5C4F7D7A00B9C0B441F8C83F38C762552083A59E3AB248B4AEC33C8B5CB681207D13314307F45E424C75ED0C5EC5DF845C8D72EE48DBEECE061F4C63363241ABF853D34702AE6BCC3230BC9498E81DC46647E1372C849D8D8D8D41C0BC925D44BE8FB609293472C8DFF023C4F4805971CF458FF9F921C60AD47B0CA83E9B9E4D88B48371C57F0DC92934C6D9FD848684062AF2DF748949F9363A78268E957C41A412E696AFCC0EA09FD1290A60F84087E9033B4CCF0FE439B48C3359C62FB1918F9F13170A3AF8A216D9EFCAB4988804C102C3FD02EA4053949B4ECF0F07C4E1DD74DE0DF75D8857C912A0E30AF4A0C9FB61C206AF92C974A6C3F4EBB9229CCDC7F4B2CD5B09C484B8CFF0497E43208402990031C3F228C0C214BD0203A4035AF4BFCFF1D48C367CC9CAC6EAC8A26A7BD01E8654C30AFA6058F1F5825674C5C398A03441F7C2CDFCC47C572004C881FE879C4966B45E83F4D484BAEE422A8F8C1410E8AE41F0C75087F6B7280E3C3FF4E10A6D872A2DF4E683FC0989CE44AEC4F182686696B9F0FB8BFB0A0981C404F547FC4B45C9BF053803F0DD7268669F45BB401900929081ED0C49589410EE08DC1B03BE487F46A4CC0226B1362550D507FE8DE225C3BE49B5CE45F387F39F660A775CCD94AC0D3F883530A2E643F11D5BB43C172A4C58A60428B2A06D801A0FFC05F5D418EB673CC3ECC918C833402CCFDDBF04969D73F3BAF074B293FEF45E4C133A57758049CC93345378EAFCCC8A46071E04DC4C1A2106E53C50B5128DFB4BFAC1990E70A4FAC60184CC9242FFCFE00AC25833C97ACA8B0349CE038F4FE5351907F86CDE5C1EC2F0DEC4D9C79904B2E3954383C83C9755D7819EC194C974BC9E8859F51873CC796FFF0A0584872C9252C4053D2160419FEEC249C6379205238DF3CBC45030C87BC5F52DF72C0AEA63FD05F900207C811C0BCC272ED80BFF045F80F1AF06A9553507F53A8452102285F7FC06A217953DC5F1B1092A9C154DF15CB24457408D428B4558133250423B0A309CB543FC85B62A7341C80DF1F9EAC06A826A4AEBC905F54440142053FEF797534E3550CFFA03E05ECF565B034511411EC1A70B1550B9B7CFF240738A6C8BF55A813D1142C0FA81F889B400E205604E4450F0CB45C405ABE2E3964670E55A3DCC47499E45D153FDCA4A1D488010E2C1FE04BDA50E4EF0FD472D0B4C45790E4054ED546D155BB575B5FC80072C9F03CF08041974CEC681F6307863C57C03F89'
	$sHexData &= 'BC0D8D7FA7E58F3543120FDB94789313C824FD58388F41016EB9DE8B72AF9055A1E0586C636E70FE80F453B1B494011C8D24143EB3C51545A4E952948D5030803845901CB033E2D7C019CB0382FF8568FAC0489AE4B84087CAC664AA3159078A85A7064CE018132A406619DDA51DF7FD3CE421EFB194FB60FA7CFBF151028A0F214CC305E996533548FE159C340E6986E10112FE14ED080FCF1958188F18E04C63730BC9ED415023B92C69431B32805F6449C117A0B110157F5939ED26DFD80CFB14BB70FC1C3B497B9FBC86F0D8FD15A08B0E7893445788196408927CC9CCE702ECADB6B1875B438634037204FB84058FD928F16ADD759819438137C9F45415920B5E7068F72F80FCC999362005F8245C45CC344C5604AE64FAB4D42439909394FCB814496E4B3415448B04F288423958FA8C28A5E85AB8F3A1E0DAEB35234593B1FC436437821C5AECB4B0BC01F229AF5B183EABFC094313CB441DE6D5C6A13B6D305C111307C227E0075F3221976E5F8480F0801F8004136A34F14158856F0A87EC20F0A51003762800C001B827847D3EB03916820B6BBF30CB17A5013C96E0829E9391E0E0E02C5890BC3BD5F72088422DB960056F1F2880F5DF2820959123F8F8C0C8C9C855A0A0A028A94C32A0A0E084FCF894901D7C3E2940CF8F252D34C041582A80755B83004BC835210D83618FD9443D50C31F85D1C4928487A016DB00B37F0523E41D5F2535D76B4A2FA8830856400DA1A5F08BE0C66905181B0121EA1CA2DF720F700383E1E3D305335E0BDF5A2E1348350D2A0F56E04D457E978CF83900B94815A0B0287827AF4C217F0A246FB61F24F2CDF01253DFCFFBBE7B1102E322700276F3D2DEE7A5747DECC0EC21F366EB0BEA7B48898BE216D12D53CC85433EA5579BCC13D030522785D401D92C3C452964C3B90C94E91C822AB6DF0001DA714FF3790EDE06B20072101CE7B5CF3DF01F00846F0E9206A29FE7799EAAC2D8E8F80A703CCFF334222E46566EE67BDEF37E683E98A606AC849EE7799E9680665234183C4FF37904F083D2BCAC799EE6F39C586F422E2023079FE712008A703E6E52799E77B67EF63072066E9CBCF3349FE7D6F010733266E7693ECF8CC60E744E90349F779FDE1C75A606F8307676799EE6F3BC00773C80C2DDE779F70478CE0688CA0C79AEF3349FE706A2E41C7A6AAA9ACFBBCFF8427BE606CE147C583CCDE7799AD8187D4A84C882CFF3BCE8127EAE367EDE7DDAE6C081D08406C6788396062E3C4FF37914FE82ECDED0E73DCFF3C4B4AC9E36949EE7799E8C7E74504434F3CEE779261C66800680DEF33CCF9AB8D8F814F634E7799EF706560E606A7A849FE7799E8E98A4AEB6DA84799EF734CAD406E2F2FCFDE84EF308821201809EBE7'
	$sHexData &= '0F3799EA706CCDEF2FE1271CFF33C4F222E405058666B5EF43C74900FE47EC806BCFB3CCFFA988C187F6E0646F33CCFF35E6A7E9AB8E7693ECFD6F208801A2E367F1B9E48AEC7070127C725503DCFE67980B0261090A0715AF7DC363F2E2717B06708A266EF01183F013DBC56501783BF43F4FC8683F8304952C60061006C00694CAFCBC60064127016745AE7D74EF5126F040A2A6D22670065F2DED7BD66271F748D4612697265A3B5F3DA266F0A6C2A64733762EFBD722E6D13637F5FBDE7BD5F740E73006366651A6E640E76E03DBFEF56639B63526E007478577B07C19653739B5336753A0ADE7BB36F702A78126CBA00F7AE3BDFBB7336615B68FB6732C0E0BCEFD637701E63839E8205C36277CE6165BD07770F3B726A2AF77647DA1D05AB6F4B286A1F5A7B786F2922624E749B9600EFB5B760B954FF7E741F7CEF0DB07F523273C26C5F53F6E27BED5A69A667976F0F4C87E31EA636DF6D27A6F93D0F8E476EB77855326B006EA2D7E1E1776F0B724F347772F99F3E7D005B005D003C7B7C06F7A6E1B82E82AF5C720043004106BD77F0FB480045005FFE4D00474E4526522B7BFEBABB265600320A572F674400454F0FEB0E1EDC2E175F431B000B7BB7BDEF53AB4C42441FA68E001771DFE0E063C3EA1F2906C7FBE1060C275F372AEEADE8BD163A2F3B2326C358771ECA6FE36D27AF63EB26AF676E743B7017EFF6E9AD5F9E3D0F665300278DFD7871009B69A33D2F058305C176338E33541C1E6E0056427EAA4DC5A4E21DF250EF0E5D072EA65B31302736EF3D088E7EDC27637374270F31BC636F59064E3F70363D9F7658EBCE3A072DA7B677DEC0AD3A2CDB23FED263B6B60AD637B737273BBC876F683F6D3273577E3F756D4757684737F71C5BD3DA739FF78762DEBB7DB86B076457282A75826615DBD30E67B6737A6773D2E2E98A3F611FFF705D3ACEDD237200791B4EBB0083F7BB754F82A7645762033E1D6DD764576B3A82E94A78372A9B025C81AB5C7F1353C3BD0E78BA44124C5F335E33F73EDEEF125BC63800361258565D0E32EEF3DEDD6B06353E31120A1620023AEBE2D7BB0E86615B568B57DFC9D77A926F2D1F52264E8B1D7707422EA21677068EF7BE1F7F6F1F433655A383E975C0C3AA25777C2766EFE0ADD71E25B6780B3F4DAE2D06011BB6374CA6EFE47123864B435B0DB864B6932F424F6874132D53509A7F530F174DFB0B470077729E32FFBFBA170B6C022F657450726F636573734450A74EB8F84941776172AC475B62375CC141C55C4B5F1F5FBFAD62574B006300696E76616C69D8FF0BFE64206D61702F73263C543E206974657261746F7237CDB07DFB737472146720706F7334696F6A1FEDEE66B7446F206C1CDE7665635C742537'
	$sHexData &= '256636006E4A233062616471DADAF220636173DF4501427392F70E04F00610161C419C9ECD735F023E0786771E1CA2F0645E25D4F8065E00A28A901658DF79AFD24E8152064C1E463683407AB6A73B073A347E3EA860D93E7DCE279F3E2CA320068CD0ED9D7DE7E0EE8F609F901006609FEF79BE37936494069540B0F07E044DFDDE3B95A901F03FCD06D9AAA83D22803FFF017F9FDDD6AE0F00074BE05FE06F406FA7F92DEC12833A77EE24400AD7233CA05AD1546F089999B93FB6012AB6DADC08064310020162EC1396D6DED01DD630F67EFFE006E83F4761DA17E9474067608F28B6CA37ECD6181D05273E40063F8CC861F76C40200416AF2804E4DDD206874F682670867D371B02478006A6414C4701EF4430C197704781D026BC7437F22A03460ACC8E0FF89282811C4EA86E4C863D409E818C083F14AF09799E82CD1F24A780A40310F61082296875577E2B19429E788C002E76816C368150C4B7D41A432B79A8B9085B1ECED6577F40B0EEFC37918B7D5378EE180237507923EF13A11E034C06E409E48AE75C949FFC16F2D671AE0F6E8883E8680B576FB0BF4A06E46966C0C8003D26D8C187373C9709382113447FBC826845EF842C6E4130414006807F2078803C82240041686F16444BDA6678E716F2BCF6D7FF8370B00B76EB0EFE420FCC4718FF825DBB90E8F86770FF8BBD8BE0B0FFDCD68027E79D389EF8440F425406EC2DC1C29E649C77C79FE342DE829F6E90B86D104CEDE76FB89F66C858C9803CD0005390E0305F0F87F99ACFD3B61DA269220698C90A234A7C9EE7797098C0EC1024F93CCFD33C68C2E00825E7799EA7396895B5D5799E779FF54D268606A0CCF8F33C4FF32527456585B9E7799ACFE0002820588C79DEF99EBAE8261B290688CB7C9A4FF3082A9D452BD2522CEF3ECFD378A8D8052D8E06409ACFF33C6A9AE7182E503CCDE77980CB082F6895799ACFF3C0E8223048789F779FE7A8D016316E06B916324EF36936B334F21535358A7F86D501CF01126022059319575704887044607D2FFE1EB56D27CC0F1FE62ACE1EC9C03FD00C050F0BD160EF03F606E58F010E41066A8F06A48564D43EC7D8634DEFC17F105B066ED795DC5E8E8F0C078C375491B3EFE580024550063400277A00067924B76C6F7000D688B9E1E4430001F0A4BF90720B212745C057C0F176915CECF00FF8013ED8B3454F2F13024073D3B602D63DAAAB9703374640DF05176E27D86D182750DF13300F38921372C1DF42D187404E2EB9B088C06B27B6360FAFC28257DC462A6FAF470802F82718C9AB58108F1F475095BC2A58078525023939C98C477C9C1002B9E4E0D40C2782D0EF27C747FFB1774A4EC6C348203527782F6B30301704175F0E4092939C206F14304'
	$sHexData &= '88C22B9A40D5660B85269EFEC902114AD5F76B903B113C030E43FC8C21FA7E4D4703A3F494049508260F6244920020F60E736484E72150049AC56928BE49230D860E8B141724A04211590DBC1768277F0A75FF7A745BB9D8648DF4A302758BFB99213C8B0EFB7A8B9484E2E90B8D092537202BCE54B08402EDAEDF02718BFF039C9959CB962684B506DF90039780116100E2D9C8E93910139428F4BB0C9A9085587DF4BF4D375D206DE9098FF4CBA1D58B42067CF5754382EB948F080F7F201C3091720B7010198ED7692534CC44CAC27D4BF251F20174000FC1CD16E27394D244D0C2734BFAEE4047260FA8E842E92934B6C9480898A6B4177CC0F01C923C217A06F4E08ED218FE4C5D44E444E34275CC989D854AFC3889C132127978CACC0472EB99298F4E44F0427B7130C6718400F4850DA20390DDF4F3C568076918C540178B0BF17C948E5B502A4E02427DA25D8571910E4928BE4500450308BE4928B805C914A7BB7B00FBB5FCEC303DA252792881A00C4573BC23D2CD70E0F1E193972644D0259006504701168A43B91B707F07F3939395BBF1B20D0D8CC1EF93DF5032F1B011B0D051F1824954F9C396E0851EF64641B76AD00708AC748773B692E96A20FC6A706919313C9B41C2DF0ED64E4EC1C0A020F16002246A791EE22395208705701924B2E925CA08812054B2ED0AFEA480E03271D00527222AE706F6FED59EC769253532C531C273CAF4BAEE444C49284C180029374FFC65081B55B600F6567EFE424276D6690955400E4B9938BC0C82786D344D748E5DB0434E7B048BEC91E5778A8B882F74D0E4847A4775D3B2527137954E8AFD801B020B827F8170F14A4BD131EB86F2EC0A4693E884F11BA01030400B7871C55585530276891BC6482B71F55A07272723B1F300F38404848E576725058B76007293901D3CC8F1F90BADB45C156282FB077B867028AB04846647F4EEC4172569820103120184532D2DD0F1D8704C4928B76DA40DF57085770E8928BE434A0608E429CA0677B68FF57849091495757D8E5C80BB72020F821EF9227A2961E0B77785400EA36D23D5814EF06E42724BCE464826F2121585C04276D9066808B5791EDE3E421939BD7A6A6045C242395AE0690F01D5CB09DF81FFF22B7279291EE0E0B9705E422B1ED36B22D0E400163976F2F193972E47B0486059306A65E9E8C3CD300DE9B0623034E6E2747230EED3FF81D9D8CBCDD0F281F3311404B9C9C8CBC0F5614616C779123479E82188D19981A7272E4C8A51BC71CE91B1ABC1C39721FF120FC21240423479E9C0F1A20252530ECC9C891263D194853291FE4C8DBC95E690F782C832D9F1839728E049900A4FE319336482A5966E083229C8EEAFF5ADC2F928B7692255B105730726021'
	$sHexData &= 'E43C23B070C929D9422626725A8053724A4E7E7E6682A64242D4C47101E78092ACA0020BA822A5F92082A2CF013360C9C0FFFF2E3F4156747970655F696E666F404000FF90DBFEB6B119BF44FF014E3F24626173696F7F01F5635F6F664A65616D405F57552663686172CBACBDB75F1E61697473204034648C0B6F54FB07987F66696C656275667D446C0BB0F7F5775EBBDAED5F496E6240483769305FB26528B801DB35E746578C0D480E69E72D185230C7CF7FA1F641978F5C616C6C6FD8D68DA8632C2932B3A78255C58D9A7B2F0B5070A386299F6CB3F85F476469706C7573427D17EFD706FBB547496D61673B3742B1351365E2543977705B517F65786365702AF73256C10487C307D756C3A9A21E5F97454276F037BB396FC506111401209054010145309319F9FF3F07DA2030010001546C7353657456616C7565FFBEFDBF4C6F61644C696272617279571A536C656570286561766543AB590188723E634A566355566B07222A4768468E41FFF72BAC74986275746573572754656D70506174F70DD6BB681AAC4C024572726F72375BFB058828416464725673AA456EBBBF8DE4746572A46E64436C6F7365600CD9DBCD5A62324D9E7A795374A47573457841A3997DEF4E6578F7C644650C8E8DE0A0C3BA522C2A4D2E78EDB683F5C541DC12496E504E69F0B62CB57A6593AD624602B3C0404C0986537908FB73AEE054696DD6733D13314375724681BD03446ED549642981A133D854680A942751AE7E06B70B5A5006668C6D616E52436F75F333DB60071673E470676716827E6B6B7F386663556E684A64CA644552ECDD0EF9E65F330D6D300A17802E6D5261D8833B663C2349EB086B80B33BAB100446615C8EA2FE37B60BD206293A636F647E6F694DB166E1395F1DD569A8B2DA81609B1A5778467681CA2AC053AC404F626A741FEF7678284304564469721A6FA1C98F1D0EA7BDF14723145B8AAD067273AF34C576F00748DF9199573DD8CE5372C4002D997457566A9BA850444327C5368E04075D2D671D3DEF7B5B1B7756426C225363CB3A9FB65DDCCEA832CB0ADAD94C594772A468F87327E5DBD104DBD1C0F253AA6E303530F6B22EEAFE613F31D1412E7876394865696768BEE6766C27E9D364773D526AFAC80E0A49273C531A6FB26CF160B8CC4D182BF368C159383A7F162B04EFF0B7E1956973709A9B65FF821D12E833484249544D4190B92DB05039253B4F30DA3E46398DD46C613917836028414C3DBE6E828F61052319576964BC9BBDE163A1506978E04F666673149D757D5D5A551C721E703A3A7D89755946CB7448E735125C79C03F5F4F24A29AC8E2A3E0405F0154F272FF68B5B6E730FF51414558F63EFBDD585A554241444F46462B335F4A422'
	$sHexData &= '66914B1F5135B42F863767410B1F5DC5644873256303AC1155B866C32414C42705A86D170CED25B60B5D8FA59413F41B85F53EAD0F4B99B48744A403109CF586A7487396D008A5F72D35D58500283C3DF42443D3F315F59563D6C47F23D40582F30489F76C006130E906E5F65D49FF628508D425075C43C24382C5C71455F4EEFDB02073C8467DBA70D60EA567C4B43D44156F169A608B6994084DA63468A7065D3ECDAB2E6505F20A040E80068091A48482D4A37A1C313516B364240977008C56D993AB4E13F0CCE701EBEFDCB4F73667840908E450403176153113C5409497FAB080E15AE748A8BC538DCD6424542B7F18616A0600F7769628B29180540E4E5144BCC063104D7D5C328280A6840B11D4CA62204AC501C96A6032AAF505C5775093AAED66733853007241775EA5AC96347180A797122B33155C5D480610B66866835DAE1525C4156033F367D89DA8A03307E4D407F8B928B924B4A8B928B924948C04ED446FE8150360E56CF520CF1201A328585E2581CADAB41D5053B2E204040318A060F58DE48A2A1E9E90836EB696C6531E09B8A914DF04142D117A06BAA297937940E68178648015C8150C210C19EB30A7B787E4B26680B4D8F67656043A64841628D1CD0D0547737476816146C847C12796315153BC6057BCB85446DA83055AD4C7F23AE62A3467740CD9C100808A09FF60AC303534149D86C566661634894B037A2402B22340A8BBFB0DA868469667B6948E29D6D5588488244310C0A61738F4173C659465B0C4BB493BC6E33696E6DC712E179D80A376B1DB6DBAE0B60776179A46E6F746E76407F6827C6BEC37FDD83C06070B2766ED75B89376547113340075153E38A141F42403366373E174900F4009831D5F2DBE2776373540E6D656D6370794E05B861B70E5F5F63662E12584108F974613680D2B56B46BF146CB8376433513B2682355F4E749CD83DD8A42B182174F1A599F1CE2E25ED5FD65EBA7D7B7234EE6F6D6DE210722A6F70CBA564073C6F6F6B2B437070582AC155B2635CB75F288233673778846964D60CC11E1916B4925BC3376482756C0D81870E6E668948EF363B679DC918DE8524CDFE3D0DBB64382775ABF978784672FDA63DC9E2F3B63369737764696727B4C6C34CD632D55801A9F786435FAE2675693634E0632ED3C376635470724666366012F064E7746F778467216FD36019213030426CA0335168374EE744055E30D5776890EA1C13819F55C27A8BA585B64D37E733D856EC66B151EC3DEF287070F1787476D4663A630163300277A4BDF714762A18922D110E66B04867D20CF64E86656BE47B8EC85BFB374573CAE094C3F96C68BBD7B350BF263676C438CBCF162A584833BD415866AC1D126DE5BFF5667781D87154B6'
	$sHexData &= '65F32E6D705433543B34066885545753DC4B66D0C4A8647EC013EBA90E7876F61C35C53A4A3156E270F5536966364D10A09645C59A15FC18756D43681A642173077A9641D3734A5097FF9650D38EAAE754F2DBBB5BFB2B513A489F9597BDEC5317195D100CAE436507DA49966CCEFF3FB3D14D6FF884580109230F132B30260D240614FEF6FF0D130A290D2717092B1E0610182D8C2215240A06F6FFFDCD780A1C080E2F6822501F1F081F1A8744150D0642C33EDBFF160609060F3B451F142048222105070105FFFF20FF080C114A210919049214172E340B060C12342C0F364E7DDF6E7FFB273435124B6A1F1B0C0A442A102E060E11002F321F0C10FFFFFFEC311259E5200605052608081D35210C3012327B4405151E0A0F2C0E7DB3ED05000F250F27EE290E4694240C0F1A08070B6CC116345E1B6C641B08262A7AE6EFDB121CCE2C1422611E2413204B1BC017CCFEED2F86190C2306301011B03E120514090A08075A166FDD9DDD5C0F324F8AA33C131A8910680C06340F375BF0FD1D090F2A0E55230F9C6B3D8A2A36101505FF6D70968E74090B05090520050B16700DBFFDBBFD1D0E4117063A5241121F380676487B0BB41D0D379C1217FFF08383120422283151121BAE1E32223BC3BB86B3FF4B08F05C012C7312E9349A52080200BFE17F7B4F7F0E4030570126091D1610101E0B7A520E096C0A07C3DBB7B739285D01145A1C1D122BB8761854016A6F3CFFF6B76D050ADC3B0BD85B4AF017010D125211210D07090EF06C172FF8FF02F0FF010F59090932909F2754B6A34E123156082A1A98990F64CC15105C251FFC867F46120A510B7A16F0100213530A116D0BFBDD07F64E18140C58271A1101354B351E0C803B6F7FBBFB574A100D34471D1156F0050244174D99FFF6FFBB4D0F951A13F04701C27AEA8698F03901B48AF08E01416511C0C50DEFF01333823A8CA02E92153123CE8AA678430D50076C0D0C4E0406C8CB537415FA0CEF184AF22C97FDFFD911590D1F393125F0F40040220C37125E2B3A046FBF6047251EF00DC4614D57391D19006F3D212B2BFEFF824398075680100C480D0E14350F1C5B1326504A4CF68EFFFF0E190D3C122A321625E33A4A1240071511D02F0D0B2E041729FEFF2A0C3E853D6DDFC80D46401B14A10BE080AD510CF8213AFB14102207A60DB24FBF571EEB5E12FF77F4E8380A5B0A8C1D2D1D4025101D0F1026241FEC499A08482910073EC8070C3610880CCAF8B6DA803D59C7DB071764091B10282607E838097B749C9D9E0A3642EC0F5086B7ED8ADB0C642BA060946A121D301713224F0E4DFFFFBFE072F085BEF07C01DD5554F01A0110400674396D30421B1E71540DE1FF7FF06B1C2E19180938170F226B3B06461B2'
	$sHexData &= 'A213539BE4FDFB0689330281743B2182C080F7B116B40FFA637FDEE06989E0F6DD4A63A7B25501B379B165A6E1B16E10D86ED4C5E1964301C12FA1E130B0ED35521B6E632349F3EF0CA01509BB6E322B6F019018ACF320E390EE2FF2AFB0D3820090D3630225A0E0D9D2C4B063506F09B2E68FA8F018D871B1021642501500C0658EDFF05871426D4A3745036072E0E251C061514004ADAFF9BFD0F794FD4068135A7328B06681D287D067A060669A87D54DD14065D0D684A02199E06E856DD299E065561BC1845ACCAFB51BBEA1A761C0C14ACAF12196A1421E777FBA210824B362CEC120C5E3B1E0A703F18F55545F772472A34193BF06236223742BAB7F7DB9E6A1F103C414A962BB839021F16153432FEDCF3063C2F2D06502115F0EDBFEA9DBCAC58353DDC6A330C13128D523E3C145CAE70BDE02D0C54B033011E117A981F290D0E7EFFABE81408192906160A96C88806F0440266AC6FBAFEEFF80C6315B1BA8C51152A640912117051B0158FF674532F2423AE48CAF02E6CB0B5FF6F306F38106306D2125606DC50F0A6F81AB209560BBEBD76C01D1319890A36285B4083086D01ED2BFEFFDBBAABAC91987F0DB312BE0F422857447E020FAE93323C7F8F4D8B015CD40F8C71A52C0FCC272411F16EA3D309107A8C011006072FFA05D8E4131560180A3B143E0E0805160C21262ABAEB0E0D05DE1118151E1814460234E0456206141818681180FC0214D92807426E118C18532D482F1C4566A473380107087005C260454F2C0BDE100E1ADFFF7FD1A8CA1D4D05115E610F052105BE05121E140667600D23BF75F654CA5829047DEC0413162F1B1641B6376CFE402628281616243624A2161E32112A2D20BE7DFED6002118212333131636233427064214162E386EBAB73BDE3A463A4E0C382334092130191EF6DFFE572D3030231B202A30372348304E3A60232B283A26266ABFABFD2853376C5D294072505B013B230F239A0AA0A1E07BE81B06240CAA23A2158287F65D8112101923151B11F033FF6F8A0C98640F07190E1811071E08070B0A1936DDEC3022A83A0E081B0B6C0A186CFBD8AB66F0F20804010C28041AF084231F2D6C6D354323B00468ADBD77DB04105218100A6713214B6B8B8D2B170C0411153636762F3308251D15B7E1A32D59F06001B420086AB327EDDA201C2014020A080C20024EFBCCCDEC140C080D30155C0B48203504D63D0F47081B161860D64DEC142009189D2C5241DE16F63D1420A730C3F357ECB2DFF60321010C240F240DC11B3B4BB514388B858D63CE26086B10040D97E0BD6D665CCD107F4B381016B1B796E9C50B01F6FF7F0887F0B42428403C3C1C1C383C44544450241C2016A5FF91A000D84C010500D5D9076904C0FEABC5E0'
	$sHexData &= '0002210B010A10EFF3CEBEC47A27101C161040011DF3D8B27D17021E05000F00E0B4F7B5CD04727338025910050F1DA389B20D4A34A2B26B29F96FA9088CF8B00100E80349FE28F9C001002413204D0100403530C576F5FC025F2E958307078217212C6FE76FCBBFA72C57CEF518602E726461746196BFED8250F74867D44C87CF81EDA4DDF6042E4D689690784FF29D7FF2D7CFC9C02E72737263E7B01B0FF9767C9FF7CF4D7265C9F33C9B684EEE1BC01480FE9D7DF207D0534200D027CCE40F4AEE01009224491200000054FF807C2408010F85D701000060BE007001108DBE00A0FEFF5783CDFFEB0D9090908A064688074701DB75078B1E83EEFC11DB72EDB80100000001DB75078B1E83EEFC11DB11C001DB730B75288B1E83EEFC11DB721F4801DB75078B1E83EEFC11DB11C0EBD401DB75078B1E83EEFC11DB11C9EB5231C983E8037211C1E0088A064683F0FF7475D1F889C5EB0B01DB75078B1E83EEFC11DB72CC4101DB75078B1E83EEFC11DB72BE01DB75078B1E83EEFC11DB11C901DB73EF75098B1E83EEFC11DB73E483C10281FD00FBFFFF83D1028D142F83FDFC760E8A02428807474975F7E942FFFFFF8B0283C204890783C70483E90477F101CFE92CFFFFFF5E89F7B9002C0100EB238A07472CE83C01771A83F904721A8B072C01750F86C4C1C01086C429F801F083E904AB83E90173D88DBE00D001008B0709C0743C8B5F048D8430E413020001F35083C708FF9680140200958A074708C074DC89F95748F2AE55FF968414020009C07407890383C304EBE16131C0C20C0083C7048D5EFC31C08A074709C074223CEF771101C38B0386C4C1C01086C401F08903EBE2240FC1E010668B0783C702EBE28BAE881402008DBE00F0FFFFBB0010000050546A045357FFD58D871702000080207F8060287F585054505357FFD558618D4424806A0039C475FA83EC80E9090AFFFF0048000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000018900110105301104F000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
	$sHexData &= '000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001000000018000080000000000000000021B003A9000001000100000030000080000000000000000021B003A90000010009040000480000005C20020088030000000000000000000060B00100880334000000560053005F00560045005200530049004F004E005F0049004E0046004F0000000000BD04EFFE000001000A00E90703000F0003000300000000003F000000000000000400040002000000000000000000000000000000E8020000010053007400720069006E006700460069006C00650049006E0066006F000000C4020000010030003400300039003000340042003000000082002D000100460069006C0065004400650073006300720069007000740069006F006E000000000049006D0061006700650053006500610072006300680044004C004C00200058005000200078003800360020002D00200049006D00610067006500200053006500610072006300680020004C00690062007200610072007900000000004C0016000100500072006F0064007500630074004E0061006D0065000000000049006D0061006700650053006500610072006300680044004C004C002000580050002000780038003600000054001A00010049006E007400650072006E0061006C004E0061006D006500000049006D0061006700650053006500610072006300680044004C004C005F00580050005F007800380036002E0064006C006C0000005C001A0001004F0072006900670069006E0061006C00460069006C0065006E0061006D006500000049006D0061006700650053006500610072006300680044004C004C005F00580050005F007800380036002E0064006C006C00000034000A00010043006F006D00700061006E0079004E0061006D00650000000000540052004F004E0047002E00500052004F000000340008000100500072006F006400750063007400560065007200730069006F006E00000033002E0033002E0030002E00300000003A000D000100460069006C006500560065007200730069006F006E000000000032003000320035002E00310030002E00310035002E0033000000000088'
	$sHexData &= '00320001004C006500670061006C0043006F0070007900720069006700680074000000A9002000440061006F002000560061006E002000540072006F006E00670020002D002000540052004F004E0047002E00500052004F002E00200041006C006C0020007200690067006800740073002000720065007300650072007600650064002E000000440000000100560061007200460069006C00650049006E0066006F00000000002400040000005400720061006E0073006C006100740069006F006E00000000000904B004000000000000000000000000A824020070240200000000000000000000000000B224020078240200000000000000000000000000BE24020080240200000000000000000000000000CB24020090240200000000000000000000000000D824020098240200000000000000000000000000E5240200A02402000000000000000000000000000000000000000000F024020000000000F82402000000000012250200022502002025020000000000302502000000000044250200000000004A2502000000000047444933322E646C6C00676469706C75732E646C6C004B45524E454C33322E444C4C004D535643503130302E646C6C004D535643523130302E646C6C005553455233322E646C6C000000426974426C7400004764697046726565000047657450726F634164647265737300004C6F61644C6962726172794100005669727475616C50726F7465637400003F5F4241444F4646407374644040335F4A420000667265650000476574444300000000000000D3D9076900000000EA250200010000000B0000000B0000007C250200A8250200D425020070800000C08100001083000070840000F0840000207D0000207E0000607F000080860000408900005089000004260200102602002A26020041260200582602006F260200832602009A260200B4260200CA260200DE2602000000030008000A000900010005000700060002000400496D616765536561726368444C4C5F58505F7838362E646C6C00496D61676553656172636800496D6167655365617263685F4361707475726553637265656E00496D6167655365617263685F436C656172436163686500496D6167655365617263685F476574537973496E666F00496D6167655365617263685F47657456657273696F6E00496D6167655365617263685F496E496D61676500496D6167655365617263685F4D6F757365436C69636B00496D6167655365617263685F4D6F757365436C69636B57696E00496D6167655365617263685F4D6F7573654D6F766500496D6167655365617263685F684269746D617000496D6167655365617263685F684269746D61704C6F6164000000001002001'
	$sHexData &= '00000002D304432483200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'
	Return $sHexData
EndFunc   ;==>__ImgSearch_GetEmbeddedDLL_XP_x86

Func _WinAPI_CreateFile($sFileName, $iCreation, $iAccess = 4, $iShare = 0, $iAttributes = 0, $tSecurity = 0)
	Local $iDA = 0, $iSM = 0, $iCD = 0, $iFA = 0
	If BitAND($iAccess, 1) <> 0 Then $iDA = BitOR($iDA, $GENERIC_EXECUTE)
	If BitAND($iAccess, 2) <> 0 Then $iDA = BitOR($iDA, $GENERIC_READ)
	If BitAND($iAccess, 4) <> 0 Then $iDA = BitOR($iDA, $GENERIC_WRITE)
	If BitAND($iShare, 1) <> 0 Then $iSM = BitOR($iSM, $FILE_SHARE_DELETE)
	If BitAND($iShare, 2) <> 0 Then $iSM = BitOR($iSM, $FILE_SHARE_READ)
	If BitAND($iShare, 4) <> 0 Then $iSM = BitOR($iSM, $FILE_SHARE_WRITE)
	Switch $iCreation
		Case 0
			$iCD = $CREATE_NEW
		Case 1
			$iCD = $CREATE_ALWAYS
		Case 2
			$iCD = $OPEN_EXISTING
		Case 3
			$iCD = $OPEN_ALWAYS
		Case 4
			$iCD = $TRUNCATE_EXISTING
	EndSwitch
	If BitAND($iAttributes, 1) <> 0 Then $iFA = BitOR($iFA, $FILE_ATTRIBUTE_ARCHIVE)
	If BitAND($iAttributes, 2) <> 0 Then $iFA = BitOR($iFA, $FILE_ATTRIBUTE_HIDDEN)
	If BitAND($iAttributes, 4) <> 0 Then $iFA = BitOR($iFA, $FILE_ATTRIBUTE_READONLY)
	If BitAND($iAttributes, 8) <> 0 Then $iFA = BitOR($iFA, $FILE_ATTRIBUTE_SYSTEM)
	Local $aCall = DllCall("kernel32.dll", "handle", "CreateFileW", "wstr", $sFileName, "dword", $iDA, "dword", $iSM, "struct*", $tSecurity, "dword", $iCD, "dword", $iFA, "ptr", 0)
	If @error Or ($aCall[0] = Ptr(-1)) Then Return SetError(@error, @extended, 0)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_CreateFile
Func _WinAPI_GetCursorInfo()
	Local $tCursor = DllStructCreate($__tagCURSORINFO)
	Local $iCursor = DllStructGetSize($tCursor)
	DllStructSetData($tCursor, "Size", $iCursor)
	Local $aCall = DllCall("user32.dll", "bool", "GetCursorInfo", "struct*", $tCursor)
	If @error Or Not $aCall[0] Then Return SetError(@error + 10, @extended, 0)
	Local $aCursor[5]
	$aCursor[0] = True
	$aCursor[1] = DllStructGetData($tCursor, "Flags") <> 0
	$aCursor[2] = DllStructGetData($tCursor, "hCursor")
	$aCursor[3] = DllStructGetData($tCursor, "X")
	$aCursor[4] = DllStructGetData($tCursor, "Y")
	Return $aCursor
EndFunc   ;==>_WinAPI_GetCursorInfo
Func _WinAPI_GetModuleHandle($sModuleName)
	If $sModuleName = "" Then $sModuleName = Null
	Local $aCall = DllCall("kernel32.dll", "handle", "GetModuleHandleW", "wstr", $sModuleName)
	If @error Then Return SetError(@error, @extended, 0)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_GetModuleHandle
Func _WinAPI_GetString($pString, $bUnicode = True)
	Local $iLength = _WinAPI_StrLen($pString, $bUnicode)
	If @error Or Not $iLength Then Return SetError(@error + 10, @extended, '')
	Local $tString = DllStructCreate(($bUnicode ? 'wchar' : 'char') & '[' & ($iLength + 1) & ']', $pString)
	If @error Then Return SetError(@error, @extended, '')
	Return SetExtended($iLength, DllStructGetData($tString, 1))
EndFunc   ;==>_WinAPI_GetString
Func _WinAPI_ReadFile($hFile, $pBuffer, $iToRead, ByRef $iRead, $tOverlapped = 0)
	Local $aCall = DllCall("kernel32.dll", "bool", "ReadFile", "handle", $hFile, "struct*", $pBuffer, "dword", $iToRead, "dword*", 0, "struct*", $tOverlapped)
	If @error Then Return SetError(@error, @extended, False)
	$iRead = $aCall[4]
	Return $aCall[0]
EndFunc   ;==>_WinAPI_ReadFile
Func _WinAPI_StrLen($pString, $bUnicode = True)
	Local $W = ''
	If $bUnicode Then $W = 'W'
	Local $aCall = DllCall('kernel32.dll', 'int', 'lstrlen' & $W, 'struct*', $pString)
	If @error Then Return SetError(@error, @extended, 0)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_StrLen
Func __Inc(ByRef $aData, $iIncrement = 100)
	Select
		Case UBound($aData, $UBOUND_COLUMNS)
			If $iIncrement < 0 Then
				ReDim $aData[$aData[0][0] + 1][UBound($aData, $UBOUND_COLUMNS)]
			Else
				$aData[0][0] += 1
				If $aData[0][0] > UBound($aData) - 1 Then
					ReDim $aData[$aData[0][0] + $iIncrement][UBound($aData, $UBOUND_COLUMNS)]
				EndIf
			EndIf
		Case UBound($aData, $UBOUND_ROWS)
			If $iIncrement < 0 Then
				ReDim $aData[$aData[0] + 1]
			Else
				$aData[0] += 1
				If $aData[0] > UBound($aData) - 1 Then
					ReDim $aData[$aData[0] + $iIncrement]
				EndIf
			EndIf
		Case Else
			Return 0
	EndSelect
	Return 1
EndFunc   ;==>__Inc
Func _WinAPI_GUIDFromString($sGUID)
	Local $tGUID = DllStructCreate($tagGUID)
	If Not _WinAPI_GUIDFromStringEx($sGUID, $tGUID) Then Return SetError(@error, @extended, 0)
	Return $tGUID
EndFunc   ;==>_WinAPI_GUIDFromString
Func _WinAPI_GUIDFromStringEx($sGUID, $tGUID)
	Local $aCall = DllCall("ole32.dll", "long", "CLSIDFromString", "wstr", $sGUID, "struct*", $tGUID)
	If @error Then Return SetError(@error, @extended, False)
	If $aCall[0] Then Return SetError(10, $aCall[0], False)
	Return True
EndFunc   ;==>_WinAPI_GUIDFromStringEx
Func _WinAPI_StringFromGUID($tGUID)
	Local $aCall = DllCall("ole32.dll", "int", "StringFromGUID2", "struct*", $tGUID, "wstr", "", "int", 40)
	If @error Or Not $aCall[0] Then Return SetError(@error, @extended, "")
	Return SetExtended($aCall[0], $aCall[2])
EndFunc   ;==>_WinAPI_StringFromGUID
Func _WinAPI_CloseHandle($hObject)
	Local $aCall = DllCall("kernel32.dll", "bool", "CloseHandle", "handle", $hObject)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_CloseHandle
Func _WinAPI_DeleteObject($hObject)
	Local $aCall = DllCall("gdi32.dll", "bool", "DeleteObject", "handle", $hObject)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_DeleteObject
Func _WinAPI_SelectObject($hDC, $hGDIObj)
	Local $aCall = DllCall("gdi32.dll", "handle", "SelectObject", "handle", $hDC, "handle", $hGDIObj)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_SelectObject
Func _WinAPI_IsBadReadPtr($pAddress, $iLength)
	Local $aCall = DllCall('kernel32.dll', 'bool', 'IsBadReadPtr', 'struct*', $pAddress, 'uint_ptr', $iLength)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_IsBadReadPtr
Func _WinAPI_IsBadWritePtr($pAddress, $iLength)
	Local $aCall = DllCall('kernel32.dll', 'bool', 'IsBadWritePtr', 'struct*', $pAddress, 'uint_ptr', $iLength)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_IsBadWritePtr
Func _WinAPI_MoveMemory($pDestination, $pSource, $iLength)
	If _WinAPI_IsBadReadPtr($pSource, $iLength) Then Return SetError(10, @extended, 0)
	If _WinAPI_IsBadWritePtr($pDestination, $iLength) Then Return SetError(11, @extended, 0)
	DllCall('ntdll.dll', 'none', 'RtlMoveMemory', 'struct*', $pDestination, 'struct*', $pSource, 'ulong_ptr', $iLength)
	If @error Then Return SetError(@error, @extended, 0)
	Return 1
EndFunc   ;==>_WinAPI_MoveMemory
Func _WinAPI_BitBlt($hDestDC, $iXDest, $iYDest, $iWidth, $iHeight, $hSrcDC, $iXSrc, $iYSrc, $iROP)
	Local $aCall = DllCall("gdi32.dll", "bool", "BitBlt", "handle", $hDestDC, "int", $iXDest, "int", $iYDest, "int", $iWidth, "int", $iHeight, "handle", $hSrcDC, "int", $iXSrc, "int", $iYSrc, "dword", $iROP)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_BitBlt
Func _WinAPI_CreateCompatibleBitmap($hDC, $iWidth, $iHeight)
	Local $aCall = DllCall("gdi32.dll", "handle", "CreateCompatibleBitmap", "handle", $hDC, "int", $iWidth, "int", $iHeight)
	If @error Then Return SetError(@error, @extended, 0)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_CreateCompatibleBitmap
Func _WinAPI_CreateCompatibleDC($hDC)
	Local $aCall = DllCall("gdi32.dll", "handle", "CreateCompatibleDC", "handle", $hDC)
	If @error Then Return SetError(@error, @extended, 0)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_CreateCompatibleDC
Func _WinAPI_DeleteDC($hDC)
	Local $aCall = DllCall("gdi32.dll", "bool", "DeleteDC", "handle", $hDC)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_DeleteDC
Func _WinAPI_DrawIcon($hDC, $iX, $iY, $hIcon)
	Local $aCall = DllCall("user32.dll", "bool", "DrawIcon", "handle", $hDC, "int", $iX, "int", $iY, "handle", $hIcon)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_DrawIcon
Func _WinAPI_GetDC($hWnd)
	Local $aCall = DllCall("user32.dll", "handle", "GetDC", "hwnd", $hWnd)
	If @error Then Return SetError(@error, @extended, 0)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_GetDC
Func _WinAPI_ReleaseDC($hWnd, $hDC)
	Local $aCall = DllCall("user32.dll", "int", "ReleaseDC", "hwnd", $hWnd, "handle", $hDC)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_ReleaseDC
Func _WinAPI_CopyIcon($hIcon)
	Local $aCall = DllCall("user32.dll", "handle", "CopyIcon", "handle", $hIcon)
	If @error Then Return SetError(@error, @extended, 0)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_CopyIcon
Func _WinAPI_DestroyIcon($hIcon)
	Local $aCall = DllCall("user32.dll", "bool", "DestroyIcon", "handle", $hIcon)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_DestroyIcon
Func _WinAPI_GetIconInfo($hIcon)
	Local $tInfo = DllStructCreate($tagICONINFO)
	Local $aCall = DllCall("user32.dll", "bool", "GetIconInfo", "handle", $hIcon, "struct*", $tInfo)
	If @error Or Not $aCall[0] Then Return SetError(@error + 10, @extended, 0)
	Local $aIcon[6]
	$aIcon[0] = True
	$aIcon[1] = DllStructGetData($tInfo, "Icon") <> 0
	$aIcon[2] = DllStructGetData($tInfo, "XHotSpot")
	$aIcon[3] = DllStructGetData($tInfo, "YHotSpot")
	$aIcon[4] = DllStructGetData($tInfo, "hMask")
	$aIcon[5] = DllStructGetData($tInfo, "hColor")
	Return $aIcon
EndFunc   ;==>_WinAPI_GetIconInfo
Func _GDIPlus_BitmapCloneArea($hBitmap, $nLeft, $nTop, $nWidth, $nHeight, $iFormat = $GDIP_PXF24RGB)
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdipCloneBitmapArea", "float", $nLeft, "float", $nTop, "float", $nWidth, "float", $nHeight, "int", $iFormat, "handle", $hBitmap, "handle*", 0)
	If @error Then Return SetError(@error, @extended, 0)
	If $aCall[0] Then Return SetError(10, $aCall[0], 0)
	Return $aCall[7]
EndFunc   ;==>_GDIPlus_BitmapCloneArea
Func _GDIPlus_BitmapCreateFromHBITMAP($hBitmap, $hPal = 0)
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdipCreateBitmapFromHBITMAP", "handle", $hBitmap, "handle", $hPal, "handle*", 0)
	If @error Then Return SetError(@error, @extended, 0)
	If $aCall[0] Then Return SetError(10, $aCall[0], 0)
	Return $aCall[3]
EndFunc   ;==>_GDIPlus_BitmapCreateFromHBITMAP
Func _GDIPlus_BitmapDispose($hBitmap)
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdipDisposeImage", "handle", $hBitmap)
	If @error Then Return SetError(@error, @extended, False)
	If $aCall[0] Then Return SetError(10, $aCall[0], False)
	Return True
EndFunc   ;==>_GDIPlus_BitmapDispose
Func _GDIPlus_Encoders()
	Local $iCount = _GDIPlus_EncodersGetCount()
	Local $iSize = _GDIPlus_EncodersGetSize()
	Local $tBuffer = DllStructCreate("byte[" & $iSize & "]")
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdipGetImageEncoders", "uint", $iCount, "uint", $iSize, "struct*", $tBuffer)
	If @error Then Return SetError(@error, @extended, 0)
	If $aCall[0] Then Return SetError(10, $aCall[0], 0)
	Local $pBuffer = DllStructGetPtr($tBuffer)
	Local $tCodec, $aInfo[$iCount + 1][14]
	$aInfo[0][0] = $iCount
	For $iI = 1 To $iCount
		$tCodec = DllStructCreate($tagGDIPIMAGECODECINFO, $pBuffer)
		$aInfo[$iI][1] = _WinAPI_StringFromGUID(DllStructGetPtr($tCodec, "CLSID"))
		$aInfo[$iI][2] = _WinAPI_StringFromGUID(DllStructGetPtr($tCodec, "FormatID"))
		$aInfo[$iI][3] = _WinAPI_GetString(DllStructGetData($tCodec, "CodecName"))
		$aInfo[$iI][4] = _WinAPI_GetString(DllStructGetData($tCodec, "DllName"))
		$aInfo[$iI][5] = _WinAPI_GetString(DllStructGetData($tCodec, "FormatDesc"))
		$aInfo[$iI][6] = _WinAPI_GetString(DllStructGetData($tCodec, "FileExt"))
		$aInfo[$iI][7] = _WinAPI_GetString(DllStructGetData($tCodec, "MimeType"))
		$aInfo[$iI][8] = DllStructGetData($tCodec, "Flags")
		$aInfo[$iI][9] = DllStructGetData($tCodec, "Version")
		$aInfo[$iI][10] = DllStructGetData($tCodec, "SigCount")
		$aInfo[$iI][11] = DllStructGetData($tCodec, "SigSize")
		$aInfo[$iI][12] = DllStructGetData($tCodec, "SigPattern")
		$aInfo[$iI][13] = DllStructGetData($tCodec, "SigMask")
		$pBuffer += DllStructGetSize($tCodec)
	Next
	Return $aInfo
EndFunc   ;==>_GDIPlus_Encoders
Func _GDIPlus_EncodersGetCLSID($sFileExtension)
	Local $aEncoders = _GDIPlus_Encoders()
	If @error Then Return SetError(@error, 0, "")
	For $iI = 1 To $aEncoders[0][0]
		If StringInStr($aEncoders[$iI][6], "*." & $sFileExtension) > 0 Then Return $aEncoders[$iI][1]
	Next
	Return SetError(-1, -1, "")
EndFunc   ;==>_GDIPlus_EncodersGetCLSID
Func _GDIPlus_EncodersGetCount()
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdipGetImageEncodersSize", "uint*", 0, "uint*", 0)
	If @error Then Return SetError(@error, @extended, -1)
	If $aCall[0] Then Return SetError(10, $aCall[0], -1)
	Return $aCall[1]
EndFunc   ;==>_GDIPlus_EncodersGetCount
Func _GDIPlus_EncodersGetSize()
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdipGetImageEncodersSize", "uint*", 0, "uint*", 0)
	If @error Then Return SetError(@error, @extended, -1)
	If $aCall[0] Then Return SetError(10, $aCall[0], -1)
	Return $aCall[2]
EndFunc   ;==>_GDIPlus_EncodersGetSize
Func _GDIPlus_ImageDispose($hImage)
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdipDisposeImage", "handle", $hImage)
	If @error Then Return SetError(@error, @extended, False)
	If $aCall[0] Then Return SetError(10, $aCall[0], False)
	Return True
EndFunc   ;==>_GDIPlus_ImageDispose
Func _GDIPlus_ImageGetHeight($hImage)
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdipGetImageHeight", "handle", $hImage, "uint*", 0)
	If @error Then Return SetError(@error, @extended, -1)
	If $aCall[0] Then Return SetError(10, $aCall[0], -1)
	Return $aCall[2]
EndFunc   ;==>_GDIPlus_ImageGetHeight
Func _GDIPlus_ImageGetWidth($hImage)
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdipGetImageWidth", "handle", $hImage, "uint*", -1)
	If @error Then Return SetError(@error, @extended, -1)
	If $aCall[0] Then Return SetError(10, $aCall[0], -1)
	Return $aCall[2]
EndFunc   ;==>_GDIPlus_ImageGetWidth
Func _GDIPlus_ImageLoadFromFile($sFileName)
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdipLoadImageFromFile", "wstr", $sFileName, "handle*", 0)
	If @error Then Return SetError(@error, @extended, 0)
	If $aCall[0] Then Return SetError(10, $aCall[0], 0)
	Return $aCall[2]
EndFunc   ;==>_GDIPlus_ImageLoadFromFile
Func _GDIPlus_ImageSaveToFile($hImage, $sFileName)
	Local $sExt = __GDIPlus_ExtractFileExt($sFileName)
	Local $sCLSID = _GDIPlus_EncodersGetCLSID($sExt)
	If $sCLSID = "" Then Return SetError(-1, 0, False)
	Local $bRet = _GDIPlus_ImageSaveToFileEx($hImage, $sFileName, $sCLSID, 0)
	Return SetError(@error, @extended, $bRet)
EndFunc   ;==>_GDIPlus_ImageSaveToFile
Func _GDIPlus_ImageSaveToFileEx($hImage, $sFileName, $sEncoder, $tParams = 0)
	Local $tGUID = _WinAPI_GUIDFromString($sEncoder)
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdipSaveImageToFile", "handle", $hImage, "wstr", $sFileName, "struct*", $tGUID, "struct*", $tParams)
	If @error Then Return SetError(@error, @extended, False)
	If $aCall[0] Then Return SetError(10, $aCall[0], False)
	Return True
EndFunc   ;==>_GDIPlus_ImageSaveToFileEx
Func _GDIPlus_ParamAdd(ByRef $tParams, $sGUID, $iNbOfValues, $iType, $pValues)
	Local $iCount = DllStructGetData($tParams, "Count")
	Local $pGUID = DllStructGetPtr($tParams, "GUID") + ($iCount * _GDIPlus_ParamSize())
	Local $tParam = DllStructCreate($tagGDIPENCODERPARAM, $pGUID)
	_WinAPI_GUIDFromStringEx($sGUID, $pGUID)
	DllStructSetData($tParam, "Type", $iType)
	DllStructSetData($tParam, "NumberOfValues", $iNbOfValues)
	DllStructSetData($tParam, "Values", $pValues)
	DllStructSetData($tParams, "Count", $iCount + 1)
EndFunc   ;==>_GDIPlus_ParamAdd
Func _GDIPlus_ParamInit($iCount)
	Local $sStruct = $tagGDIPENCODERPARAMS
	For $i = 2 To $iCount
		$sStruct &= ";struct;byte[16];ulong;ulong;ptr;endstruct"
	Next
	Return DllStructCreate($sStruct)
EndFunc   ;==>_GDIPlus_ParamInit
Func _GDIPlus_ParamSize()
	Local $tParam = DllStructCreate($tagGDIPENCODERPARAM)
	Return DllStructGetSize($tParam)
EndFunc   ;==>_GDIPlus_ParamSize
Func _GDIPlus_Shutdown()
	If $__g_hGDIPDll = 0 Then Return SetError(-1, -1, False)
	$__g_iGDIPRef -= 1
	If $__g_iGDIPRef = 0 Then
		DllCall($__g_hGDIPDll, "none", "GdiplusShutdown", "ulong_ptr", $__g_iGDIPToken)
		DllClose($__g_hGDIPDll)
		$__g_hGDIPDll = 0
	EndIf
	Return True
EndFunc   ;==>_GDIPlus_Shutdown
Func _GDIPlus_Startup($sGDIPDLL = Default, $bRetDllHandle = False)
	$__g_iGDIPRef += 1
	If $__g_iGDIPRef > 1 Then Return True
	If $sGDIPDLL = Default Then $sGDIPDLL = "gdiplus.dll"
	$__g_hGDIPDll = DllOpen($sGDIPDLL)
	If $__g_hGDIPDll = -1 Then
		$__g_iGDIPRef = 0
		Return SetError(1, 2, False)
	EndIf
	Local $sVer = FileGetVersion($sGDIPDLL)
	$sVer = StringSplit($sVer, ".")
	If $sVer[1] > 5 Then $__g_bGDIP_V1_0 = False
	Local $tInput = DllStructCreate($tagGDIPSTARTUPINPUT)
	Local $tToken = DllStructCreate("ulong_ptr Data")
	DllStructSetData($tInput, "Version", 1)
	Local $aCall = DllCall($__g_hGDIPDll, "int", "GdiplusStartup", "struct*", $tToken, "struct*", $tInput, "ptr", 0)
	If @error Then Return SetError(@error, @extended, False)
	If $aCall[0] Then Return SetError(10, $aCall[0], False)
	$__g_iGDIPToken = DllStructGetData($tToken, "Data")
	If $bRetDllHandle Then Return $__g_hGDIPDll
	Return SetExtended($sVer[1], True)
EndFunc   ;==>_GDIPlus_Startup
Func __GDIPlus_ExtractFileExt($sFileName, $bNoDot = True)
	Local $iIndex = __GDIPlus_LastDelimiter(".\:", $sFileName)
	If ($iIndex > 0) And (StringMid($sFileName, $iIndex, 1) = '.') Then
		If $bNoDot Then
			Return StringMid($sFileName, $iIndex + 1)
		Else
			Return StringMid($sFileName, $iIndex)
		EndIf
	Else
		Return ""
	EndIf
EndFunc   ;==>__GDIPlus_ExtractFileExt
Func __GDIPlus_LastDelimiter($sDelimiters, $sString)
	Local $sDelimiter, $iN
	For $iI = 1 To StringLen($sDelimiters)
		$sDelimiter = StringMid($sDelimiters, $iI, 1)
		$iN = StringInStr($sString, $sDelimiter, $STR_NOCASESENSEBASIC, -1)
		If $iN > 0 Then Return $iN
	Next
EndFunc   ;==>__GDIPlus_LastDelimiter
Func _WinAPI_GetLastError(Const $_iCallerError = @error, Const $_iCallerExtended = @extended)
	Local $aCall = DllCall("kernel32.dll", "dword", "GetLastError")
	Return SetError($_iCallerError, $_iCallerExtended, $aCall[0])
EndFunc   ;==>_WinAPI_GetLastError
Func _WinAPI_GetDateFormat($iLCID = 0, $tSYSTEMTIME = 0, $iFlags = $DATE_SHORTDATE, $sFormat = '')
	If Not $iLCID Then $iLCID = $LOCALE_USER_DEFAULT
	If Not StringStripWS($sFormat, $STR_STRIPLEADING + $STR_STRIPTRAILING) Then $sFormat = Null
	Local $aCall = DllCall('kernel32.dll', 'int', 'GetDateFormatW', 'dword', $iLCID, 'dword', $iFlags, 'struct*', $tSYSTEMTIME, 'wstr', $sFormat, 'wstr', '', 'int', 2048)
	If @error Or Not $aCall[0] Then Return SetError(@error, @extended, '')
	Return $aCall[5]
EndFunc   ;==>_WinAPI_GetDateFormat
Func _WinAPI_GetLocaleInfo($iLCID, $iType)
	Local $aCall = DllCall('kernel32.dll', 'int', 'GetLocaleInfoW', 'dword', $iLCID, 'dword', $iType, 'wstr', '', 'int', 2048)
	If @error Or Not $aCall[0] Then Return SetError(@error + 10, @extended, '')
	Return $aCall[3]
EndFunc   ;==>_WinAPI_GetLocaleInfo
Func _SendMessage($hWnd, $iMsg, $wParam = 0, $lParam = 0, $iReturn = 0, $wParamType = "wparam", $lParamType = "lparam", $sReturnType = "lresult")
	Local $aCall = DllCall("user32.dll", $sReturnType, "SendMessageW", "hwnd", $hWnd, "uint", $iMsg, $wParamType, $wParam, $lParamType, $lParam)
	If @error Then Return SetError(@error, @extended, "")
	If $iReturn >= 0 And $iReturn <= 4 Then Return $aCall[$iReturn]
	Return $aCall
EndFunc   ;==>_SendMessage
Func _WinAPI_CreateWindowEx($iExStyle, $sClass, $sName, $iStyle, $iX, $iY, $iWidth, $iHeight, $hParent, $hMenu = 0, $hInstance = 0, $pParam = 0)
	If $hInstance = 0 Then $hInstance = _WinAPI_GetModuleHandle("")
	Local $aCall = DllCall("user32.dll", "hwnd", "CreateWindowExW", "dword", $iExStyle, "wstr", $sClass, "wstr", $sName, "dword", $iStyle, "int", $iX, "int", $iY, "int", $iWidth, "int", $iHeight, "hwnd", $hParent, "handle", $hMenu, "handle", $hInstance, "struct*", $pParam)
	If @error Then Return SetError(@error, @extended, 0)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_CreateWindowEx
Func _WinAPI_GetDesktopWindow()
	Local $aCall = DllCall("user32.dll", "hwnd", "GetDesktopWindow")
	If @error Then Return SetError(@error, @extended, 0)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_GetDesktopWindow
Func _WinAPI_GetClassName($hWnd)
	If Not IsHWnd($hWnd) Then $hWnd = GUICtrlGetHandle($hWnd)
	Local $aCall = DllCall("user32.dll", "int", "GetClassNameW", "hwnd", $hWnd, "wstr", "", "int", 4096)
	If @error Or Not $aCall[0] Then Return SetError(@error, @extended, '')
	Return SetExtended($aCall[0], $aCall[2])
EndFunc   ;==>_WinAPI_GetClassName
Func _WinAPI_GetSystemMetrics($iIndex)
	Local $aCall = DllCall("user32.dll", "int", "GetSystemMetrics", "int", $iIndex)
	If @error Then Return SetError(@error, @extended, 0)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_GetSystemMetrics
Func _WinAPI_IsClassName($hWnd, $sClassName)
	Local $sSeparator = Opt("GUIDataSeparatorChar")
	Local $aClassName = StringSplit($sClassName, $sSeparator)
	If Not IsHWnd($hWnd) Then $hWnd = GUICtrlGetHandle($hWnd)
	Local $sClassCheck = _WinAPI_GetClassName($hWnd)
	For $x = 1 To UBound($aClassName) - 1
		If StringUpper(StringMid($sClassCheck, 1, StringLen($aClassName[$x]))) = StringUpper($aClassName[$x]) Then Return True
	Next
	Return False
EndFunc   ;==>_WinAPI_IsClassName
Func _ScreenCapture_Capture($sFileName = "", $iLeft = 0, $iTop = 0, $iRight = -1, $iBottom = -1, $bCursor = True)
	Local $bRet = False
	If $iRight = -1 Then $iRight = _WinAPI_GetSystemMetrics($__SCREENCAPTURECONSTANT_SM_CXSCREEN) - 1
	If $iBottom = -1 Then $iBottom = _WinAPI_GetSystemMetrics($__SCREENCAPTURECONSTANT_SM_CYSCREEN) - 1
	If $iRight < $iLeft Then Return SetError(-1, 0, $bRet)
	If $iBottom < $iTop Then Return SetError(-2, 0, $bRet)
	Local $iW = ($iRight - $iLeft) + 1
	Local $iH = ($iBottom - $iTop) + 1
	Local $hWnd = _WinAPI_GetDesktopWindow()
	Local $hDDC = _WinAPI_GetDC($hWnd)
	Local $hCDC = _WinAPI_CreateCompatibleDC($hDDC)
	Local $hBMP = _WinAPI_CreateCompatibleBitmap($hDDC, $iW, $iH)
	_WinAPI_SelectObject($hCDC, $hBMP)
	_WinAPI_BitBlt($hCDC, 0, 0, $iW, $iH, $hDDC, $iLeft, $iTop, $__SCREENCAPTURECONSTANT_SRCCOPY)
	If $bCursor Then
		Local $aCursor = _WinAPI_GetCursorInfo()
		If Not @error And $aCursor[1] Then
			$bCursor = True
			Local $hIcon = _WinAPI_CopyIcon($aCursor[2])
			Local $aIcon = _WinAPI_GetIconInfo($hIcon)
			If Not @error Then
				_WinAPI_DeleteObject($aIcon[4])
				If $aIcon[5] <> 0 Then _WinAPI_DeleteObject($aIcon[5])
				_WinAPI_DrawIcon($hCDC, $aCursor[3] - $aIcon[2] - $iLeft, $aCursor[4] - $aIcon[3] - $iTop, $hIcon)
			EndIf
			_WinAPI_DestroyIcon($hIcon)
		EndIf
	EndIf
	_WinAPI_ReleaseDC($hWnd, $hDDC)
	_WinAPI_DeleteDC($hCDC)
	If $sFileName = "" Then Return $hBMP
	$bRet = _ScreenCapture_SaveImage($sFileName, $hBMP, True)
	Return SetError(@error, @extended, $bRet)
EndFunc   ;==>_ScreenCapture_Capture
Func _ScreenCapture_SaveImage($sFileName, $hBitmap, $bFreeBmp = True)
	_GDIPlus_Startup()
	If @error Then Return SetError(-1, -1, False)
	Local $sExt = StringUpper(__GDIPlus_ExtractFileExt($sFileName))
	Local $sCLSID = _GDIPlus_EncodersGetCLSID($sExt)
	If $sCLSID = "" Then Return SetError(-2, -2, False)
	Local $hImage = _GDIPlus_BitmapCreateFromHBITMAP($hBitmap)
	If @error Then Return SetError(-3, -3, False)
	Local $tData, $tParams
	Switch $sExt
		Case "BMP"
			Local $iX = _GDIPlus_ImageGetWidth($hImage)
			Local $iY = _GDIPlus_ImageGetHeight($hImage)
			Local $hClone = _GDIPlus_BitmapCloneArea($hImage, 0, 0, $iX, $iY, $__g_iBMPFormat)
			_GDIPlus_ImageDispose($hImage)
			$hImage = $hClone
		Case "JPG", "JPEG"
			$tParams = _GDIPlus_ParamInit(1)
			$tData = DllStructCreate("int Quality")
			DllStructSetData($tData, "Quality", $__g_iJPGQuality)
			_GDIPlus_ParamAdd($tParams, $GDIP_EPGQUALITY, 1, $GDIP_EPTLONG, DllStructGetPtr($tData))
		Case "TIF", "TIFF"
			$tParams = _GDIPlus_ParamInit(2)
			$tData = DllStructCreate("int ColorDepth;int Compression")
			DllStructSetData($tData, "ColorDepth", $__g_iTIFColorDepth)
			DllStructSetData($tData, "Compression", $__g_iTIFCompression)
			_GDIPlus_ParamAdd($tParams, $GDIP_EPGCOLORDEPTH, 1, $GDIP_EPTLONG, DllStructGetPtr($tData, "ColorDepth"))
			_GDIPlus_ParamAdd($tParams, $GDIP_EPGCOMPRESSION, 1, $GDIP_EPTLONG, DllStructGetPtr($tData, "Compression"))
	EndSwitch
	Local $pParams = 0
	If IsDllStruct($tParams) Then $pParams = $tParams
	Local $bRet = _GDIPlus_ImageSaveToFileEx($hImage, $sFileName, $sCLSID, $pParams)
	_GDIPlus_ImageDispose($hImage)
	If $bFreeBmp Then _WinAPI_DeleteObject($hBitmap)
	_GDIPlus_Shutdown()
	Return SetError($bRet = False, 0, $bRet)
EndFunc   ;==>_ScreenCapture_SaveImage
Func _Security__AdjustTokenPrivileges($hToken, $bDisableAll, $tNewState, $iBufferLen, $tPrevState = 0, $pRequired = 0)
	Local $aCall = DllCall("advapi32.dll", "bool", "AdjustTokenPrivileges", "handle", $hToken, "bool", $bDisableAll, "struct*", $tNewState, "dword", $iBufferLen, "struct*", $tPrevState, "struct*", $pRequired)
	If @error Then Return SetError(@error, @extended, False)
	Return Not ($aCall[0] = 0)
EndFunc   ;==>_Security__AdjustTokenPrivileges
Func _Security__ImpersonateSelf($iLevel = $SECURITYIMPERSONATION)
	Local $aCall = DllCall("advapi32.dll", "bool", "ImpersonateSelf", "int", $iLevel)
	If @error Then Return SetError(@error, @extended, False)
	Return Not ($aCall[0] = 0)
EndFunc   ;==>_Security__ImpersonateSelf
Func _Security__LookupPrivilegeValue($sSystem, $sName)
	Local $aCall = DllCall("advapi32.dll", "bool", "LookupPrivilegeValueW", "wstr", $sSystem, "wstr", $sName, "int64*", 0)
	If @error Or Not $aCall[0] Then Return SetError(@error + 10, @extended, 0)
	Return $aCall[3]
EndFunc   ;==>_Security__LookupPrivilegeValue
Func _Security__OpenThreadToken($iAccess, $hThread = 0, $bOpenAsSelf = False)
	Local $aCall
	If $hThread = 0 Then
		$aCall = DllCall("kernel32.dll", "handle", "GetCurrentThread")
		If @error Then Return SetError(@error + 20, @extended, 0)
		$hThread = $aCall[0]
	EndIf
	$aCall = DllCall("advapi32.dll", "bool", "OpenThreadToken", "handle", $hThread, "dword", $iAccess, "bool", $bOpenAsSelf, "handle*", 0)
	If @error Or Not $aCall[0] Then Return SetError(@error + 10, @extended, 0)
	Return $aCall[4]
EndFunc   ;==>_Security__OpenThreadToken
Func _Security__OpenThreadTokenEx($iAccess, $hThread = 0, $bOpenAsSelf = False)
	Local $hToken = _Security__OpenThreadToken($iAccess, $hThread, $bOpenAsSelf)
	If $hToken = 0 Then
		Local Const $ERROR_NO_TOKEN = 1008
		If _WinAPI_GetLastError() <> $ERROR_NO_TOKEN Then Return SetError(20, _WinAPI_GetLastError(), 0)
		If Not _Security__ImpersonateSelf() Then Return SetError(@error + 10, _WinAPI_GetLastError(), 0)
		$hToken = _Security__OpenThreadToken($iAccess, $hThread, $bOpenAsSelf)
		If $hToken = 0 Then Return SetError(@error, _WinAPI_GetLastError(), 0)
	EndIf
	Return $hToken
EndFunc   ;==>_Security__OpenThreadTokenEx
Func _Security__SetPrivilege($hToken, $sPrivilege, $bEnable)
	Local $iLUID = _Security__LookupPrivilegeValue("", $sPrivilege)
	If $iLUID = 0 Then Return SetError(@error + 10, @extended, False)
	Local Const $tagTOKEN_PRIVILEGES = "dword Count;align 4;int64 LUID;dword Attributes"
	Local $tCurrState = DllStructCreate($tagTOKEN_PRIVILEGES)
	Local $iCurrState = DllStructGetSize($tCurrState)
	Local $tPrevState = DllStructCreate($tagTOKEN_PRIVILEGES)
	Local $iPrevState = DllStructGetSize($tPrevState)
	Local $tRequired = DllStructCreate("int Data")
	DllStructSetData($tCurrState, "Count", 1)
	DllStructSetData($tCurrState, "LUID", $iLUID)
	If Not _Security__AdjustTokenPrivileges($hToken, False, $tCurrState, $iCurrState, $tPrevState, $tRequired) Then Return SetError(2, @error, False)
	DllStructSetData($tPrevState, "Count", 1)
	DllStructSetData($tPrevState, "LUID", $iLUID)
	Local $iAttributes = DllStructGetData($tPrevState, "Attributes")
	If $bEnable Then
		$iAttributes = BitOR($iAttributes, $SE_PRIVILEGE_ENABLED)
	Else
		$iAttributes = BitAND($iAttributes, BitNOT($SE_PRIVILEGE_ENABLED))
	EndIf
	DllStructSetData($tPrevState, "Attributes", $iAttributes)
	If Not _Security__AdjustTokenPrivileges($hToken, False, $tPrevState, $iPrevState, $tCurrState, $tRequired) Then Return SetError(3, @error, False)
	Return True
EndFunc   ;==>_Security__SetPrivilege
Func _WinAPI_SetFilePointer($hFile, $iPos, $iMethod = 0)
	Local $aCall = DllCall("kernel32.dll", "INT", "SetFilePointer", "handle", $hFile, "long", $iPos, "ptr", 0, "long", $iMethod)
	If @error Then Return SetError(@error, @extended, -1)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_SetFilePointer
Func _WinAPI_EnumDisplayMonitors($hDC = 0, $tRECT = 0)
	Local $hEnumProc = DllCallbackRegister('__EnumDisplayMonitorsProc', 'bool', 'handle;handle;ptr;lparam')
	Dim $__g_vEnum[101][2] = [[0]]
	Local $aCall = DllCall('user32.dll', 'bool', 'EnumDisplayMonitors', 'handle', $hDC, 'struct*', $tRECT, 'ptr', DllCallbackGetPtr($hEnumProc), 'lparam', 0)
	If @error Or Not $aCall[0] Or Not $__g_vEnum[0][0] Then
		$__g_vEnum = @error + 10
	EndIf
	DllCallbackFree($hEnumProc)
	If $__g_vEnum Then Return SetError($__g_vEnum, 0, 0)
	__Inc($__g_vEnum, -1)
	Return $__g_vEnum
EndFunc   ;==>_WinAPI_EnumDisplayMonitors
Func _WinAPI_GetMonitorInfo($hMonitor)
	Local $tMIEX = DllStructCreate('dword;long[4];long[4];dword;wchar[32]')
	DllStructSetData($tMIEX, 1, DllStructGetSize($tMIEX))
	Local $aCall = DllCall('user32.dll', 'bool', 'GetMonitorInfoW', 'handle', $hMonitor, 'struct*', $tMIEX)
	If @error Or Not $aCall[0] Then Return SetError(@error + 10, @extended, 0)
	Local $aRet[4]
	For $i = 0 To 1
		$aRet[$i] = DllStructCreate($tagRECT)
		_WinAPI_MoveMemory($aRet[$i], DllStructGetPtr($tMIEX, $i + 2), 16)
	Next
	$aRet[3] = DllStructGetData($tMIEX, 5)
	Switch DllStructGetData($tMIEX, 4)
		Case 1
			$aRet[2] = 1
		Case Else
			$aRet[2] = 0
	EndSwitch
	Return $aRet
EndFunc   ;==>_WinAPI_GetMonitorInfo
Func __EnumDisplayMonitorsProc($hMonitor, $hDC, $pRECT, $lParam)
	#forceref $hDC, $lParam
	__Inc($__g_vEnum)
	$__g_vEnum[$__g_vEnum[0][0]][0] = $hMonitor
	If Not $pRECT Then
		$__g_vEnum[$__g_vEnum[0][0]][1] = 0
	Else
		$__g_vEnum[$__g_vEnum[0][0]][1] = DllStructCreate($tagRECT)
		If Not _WinAPI_MoveMemory(DllStructGetPtr($__g_vEnum[$__g_vEnum[0][0]][1]), $pRECT, 16) Then Return 0
	EndIf
	Return 1
EndFunc   ;==>__EnumDisplayMonitorsProc
Func _WinAPI_SetLayeredWindowAttributes($hWnd, $iTransColor, $iTransGUI = 255, $iFlags = 0x03, $bColorRef = False)
	If $iFlags = Default Or $iFlags = "" Or $iFlags < 0 Then $iFlags = BitOR($LWA_ALPHA, $LWA_COLORKEY)
	If Not $bColorRef Then
		$iTransColor = Int(BinaryMid($iTransColor, 3, 1) & BinaryMid($iTransColor, 2, 1) & BinaryMid($iTransColor, 1, 1))
	EndIf
	Local $aCall = DllCall("user32.dll", "bool", "SetLayeredWindowAttributes", "hwnd", $hWnd, "INT", $iTransColor, "byte", $iTransGUI, "dword", $iFlags)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_WinAPI_SetLayeredWindowAttributes
Func _MemFree(ByRef $tMemMap)
	Local $pMemory = DllStructGetData($tMemMap, "Mem")
	Local $hProcess = DllStructGetData($tMemMap, "hProc")
	Local $bResult = _MemVirtualFreeEx($hProcess, $pMemory, 0, $MEM_RELEASE)
	DllCall("kernel32.dll", "bool", "CloseHandle", "handle", $hProcess)
	If @error Then Return SetError(@error, @extended, False)
	Return $bResult
EndFunc   ;==>_MemFree
Func _MemInit($hWnd, $iSize, ByRef $tMemMap)
	Local $aCall = DllCall("user32.dll", "dword", "GetWindowThreadProcessId", "hwnd", $hWnd, "dword*", 0)
	If @error Then Return SetError(@error + 10, @extended, 0)
	Local $iProcessID = $aCall[2]
	If $iProcessID = 0 Then Return SetError(1, 0, 0)
	Local $iAccess = BitOR($PROCESS_VM_OPERATION, $PROCESS_VM_READ, $PROCESS_VM_WRITE)
	Local $hProcess = __Mem_OpenProcess($iAccess, False, $iProcessID, True)
	Local $iAlloc = BitOR($MEM_RESERVE, $MEM_COMMIT)
	Local $pMemory = _MemVirtualAllocEx($hProcess, 0, $iSize, $iAlloc, $PAGE_READWRITE)
	If $pMemory = 0 Then Return SetError(2, 0, 0)
	$tMemMap = DllStructCreate($tagMEMMAP)
	DllStructSetData($tMemMap, "hProc", $hProcess)
	DllStructSetData($tMemMap, "Size", $iSize)
	DllStructSetData($tMemMap, "Mem", $pMemory)
	Return $pMemory
EndFunc   ;==>_MemInit
Func _MemRead(ByRef $tMemMap, $pSrce, $pDest, $iSize)
	Local $aCall = DllCall("kernel32.dll", "bool", "ReadProcessMemory", "handle", DllStructGetData($tMemMap, "hProc"), "ptr", $pSrce, "struct*", $pDest, "ulong_ptr", $iSize, "ulong_ptr*", 0)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_MemRead
Func _MemWrite(ByRef $tMemMap, $pSrce, $pDest = 0, $iSize = 0, $sSrce = "struct*")
	If $pDest = 0 Then $pDest = DllStructGetData($tMemMap, "Mem")
	If $iSize = 0 Then $iSize = DllStructGetData($tMemMap, "Size")
	Local $aCall = DllCall("kernel32.dll", "bool", "WriteProcessMemory", "handle", DllStructGetData($tMemMap, "hProc"), "ptr", $pDest, $sSrce, $pSrce, "ulong_ptr", $iSize, "ulong_ptr*", 0)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_MemWrite
Func _MemVirtualAllocEx($hProcess, $pAddress, $iSize, $iAllocation, $iProtect)
	Local $aCall = DllCall("kernel32.dll", "ptr", "VirtualAllocEx", "handle", $hProcess, "ptr", $pAddress, "ulong_ptr", $iSize, "dword", $iAllocation, "dword", $iProtect)
	If @error Then Return SetError(@error, @extended, 0)
	Return $aCall[0]
EndFunc   ;==>_MemVirtualAllocEx
Func _MemVirtualFreeEx($hProcess, $pAddress, $iSize, $iFreeType)
	Local $aCall = DllCall("kernel32.dll", "bool", "VirtualFreeEx", "handle", $hProcess, "ptr", $pAddress, "ulong_ptr", $iSize, "dword", $iFreeType)
	If @error Then Return SetError(@error, @extended, False)
	Return $aCall[0]
EndFunc   ;==>_MemVirtualFreeEx
Func __Mem_OpenProcess($iAccess, $bInherit, $iPID, $bDebugPriv = False)
	Local $aCall = DllCall("kernel32.dll", "handle", "OpenProcess", "dword", $iAccess, "bool", $bInherit, "dword", $iPID)
	If @error Then Return SetError(@error, @extended, 0)
	If $aCall[0] Then Return $aCall[0]
	If Not $bDebugPriv Then Return SetError(100, 0, 0)
	Local $hToken = _Security__OpenThreadTokenEx(BitOR($TOKEN_ADJUST_PRIVILEGES, $TOKEN_QUERY))
	If @error Then Return SetError(@error + 10, @extended, 0)
	_Security__SetPrivilege($hToken, $SE_DEBUG_NAME, True)
	Local $iError = @error
	Local $iExtended = @extended
	Local $iRet = 0
	If Not @error Then
		$aCall = DllCall("kernel32.dll", "handle", "OpenProcess", "dword", $iAccess, "bool", $bInherit, "dword", $iPID)
		$iError = @error
		$iExtended = @extended
		If $aCall[0] Then $iRet = $aCall[0]
		_Security__SetPrivilege($hToken, $SE_DEBUG_NAME, False)
		If @error Then
			$iError = @error + 20
			$iExtended = @extended
		EndIf
	Else
		$iError = @error + 30
	EndIf
	DllCall("kernel32.dll", "bool", "CloseHandle", "handle", $hToken)
	Return SetError($iError, $iExtended, $iRet)
EndFunc   ;==>__Mem_OpenProcess
Func _DateDayOfWeek($iDayNum, $iFormat = Default)
	Local Const $MONDAY_IS_NO1 = 128
	If $iFormat = Default Then $iFormat = 0
	$iDayNum = Int($iDayNum)
	If $iDayNum < 1 Or $iDayNum > 7 Then Return SetError(1, 0, "")
	Local $tSYSTEMTIME = DllStructCreate($tagSYSTEMTIME)
	DllStructSetData($tSYSTEMTIME, "Year", BitAND($iFormat, $MONDAY_IS_NO1) ? 2007 : 2006)
	DllStructSetData($tSYSTEMTIME, "Month", 1)
	DllStructSetData($tSYSTEMTIME, "Day", $iDayNum)
	Return _WinAPI_GetDateFormat(BitAND($iFormat, $DMW_LOCALE_LONGNAME) ? $LOCALE_USER_DEFAULT : $LOCALE_INVARIANT, $tSYSTEMTIME, 0, BitAND($iFormat, $DMW_SHORTNAME) ? "ddd" : "dddd")
EndFunc   ;==>_DateDayOfWeek
Func _DateIsLeapYear($iYear)
	If StringIsInt($iYear) Then
		Select
			Case Mod($iYear, 4) = 0 And Mod($iYear, 100) <> 0
				Return 1
			Case Mod($iYear, 400) = 0
				Return 1
			Case Else
				Return 0
		EndSelect
	EndIf
	Return SetError(1, 0, 0)
EndFunc   ;==>_DateIsLeapYear
Func __DateIsMonth($iNumber)
	$iNumber = Int($iNumber)
	Return $iNumber >= 1 And $iNumber <= 12
EndFunc   ;==>__DateIsMonth
Func _DateIsValid($sDate)
	Local $asDatePart[4], $asTimePart[4]
	_DateTimeSplit($sDate, $asDatePart, $asTimePart)
	If @error Then Return 0
	If Not StringIsInt($asDatePart[1]) Then Return 0
	If Not StringIsInt($asDatePart[2]) Then Return 0
	If Not StringIsInt($asDatePart[3]) Then Return 0
	$asDatePart[1] = Int($asDatePart[1])
	$asDatePart[2] = Int($asDatePart[2])
	$asDatePart[3] = Int($asDatePart[3])
	Local $iNumDays = _DaysInMonth($asDatePart[1])
	If $asDatePart[1] < 1000 Or $asDatePart[1] > 2999 Then Return 0
	If $asDatePart[2] < 1 Or $asDatePart[2] > 12 Then Return 0
	If $asDatePart[3] < 1 Or $asDatePart[3] > $iNumDays[$asDatePart[2]] Then Return 0
	If $asTimePart[0] < 1 Then Return 1
	If $asTimePart[0] < 2 Then Return 0
	If $asTimePart[0] = 2 Then $asTimePart[3] = "00"
	If Not StringIsInt($asTimePart[1]) Then Return 0
	If Not StringIsInt($asTimePart[2]) Then Return 0
	If Not StringIsInt($asTimePart[3]) Then Return 0
	$asTimePart[1] = Int($asTimePart[1])
	$asTimePart[2] = Int($asTimePart[2])
	$asTimePart[3] = Int($asTimePart[3])
	If $asTimePart[1] < 0 Or $asTimePart[1] > 23 Then Return 0
	If $asTimePart[2] < 0 Or $asTimePart[2] > 59 Then Return 0
	If $asTimePart[3] < 0 Or $asTimePart[3] > 59 Then Return 0
	Return 1
EndFunc   ;==>_DateIsValid
Func _DateTimeFormat($sDate, $sType)
	Local $asDatePart[4], $asTimePart[4]
	Local $sTempDate = "", $sTempTime = ""
	Local $sAM, $sPM, $sTempString = ""
	If Not _DateIsValid($sDate) Then
		Return SetError(1, 0, "")
	EndIf
	If $sType < 0 Or $sType > 5 Or Not IsInt($sType) Then
		Return SetError(2, 0, "")
	EndIf
	_DateTimeSplit($sDate, $asDatePart, $asTimePart)
	Switch $sType
		Case 0
			$sTempString = _WinAPI_GetLocaleInfo($LOCALE_USER_DEFAULT, $LOCALE_SSHORTDATE)
			If Not @error And Not ($sTempString = '') Then
				$sTempDate = $sTempString
			Else
				$sTempDate = "M/d/yyyy"
			EndIf
			If $asTimePart[0] > 1 Then
				$sTempString = _WinAPI_GetLocaleInfo($LOCALE_USER_DEFAULT, $LOCALE_STIMEFORMAT)
				If Not @error And Not ($sTempString = '') Then
					$sTempTime = $sTempString
				Else
					$sTempTime = "h:mm:ss tt"
				EndIf
			EndIf
		Case 1
			$sTempString = _WinAPI_GetLocaleInfo($LOCALE_USER_DEFAULT, $LOCALE_SLONGDATE)
			If Not @error And Not ($sTempString = '') Then
				$sTempDate = $sTempString
			Else
				$sTempDate = "dddd, MMMM dd, yyyy"
			EndIf
		Case 2
			$sTempString = _WinAPI_GetLocaleInfo($LOCALE_USER_DEFAULT, $LOCALE_SSHORTDATE)
			If Not @error And Not ($sTempString = '') Then
				$sTempDate = $sTempString
			Else
				$sTempDate = "M/d/yyyy"
			EndIf
		Case 3
			If $asTimePart[0] > 1 Then
				$sTempString = _WinAPI_GetLocaleInfo($LOCALE_USER_DEFAULT, $LOCALE_STIMEFORMAT)
				If Not @error And Not ($sTempString = '') Then
					$sTempTime = $sTempString
				Else
					$sTempTime = "h:mm:ss tt"
				EndIf
			EndIf
		Case 4
			If $asTimePart[0] > 1 Then
				$sTempTime = "hh:mm"
			EndIf
		Case 5
			If $asTimePart[0] > 1 Then
				$sTempTime = "hh:mm:ss"
			EndIf
		Case 6
			If $asTimePart[0] > 1 Then
				$sTempTime = "hh:mm tt"
			EndIf
		Case 7
			If $asTimePart[0] > 1 Then
				$sTempTime = "hh:mm:ss tt"
			EndIf
	EndSwitch
	If $sTempDate <> "" Then
		$sTempString = _WinAPI_GetLocaleInfo($LOCALE_USER_DEFAULT, $LOCALE_SDATE)
		If Not @error And Not ($sTempString = '') Then
			$sTempDate = StringReplace($sTempDate, "/", $sTempString)
		EndIf
		Local $iWday = _DateToDayOfWeek($asDatePart[1], $asDatePart[2], $asDatePart[3])
		$asDatePart[3] = StringRight("0" & $asDatePart[3], 2)
		$asDatePart[2] = StringRight("0" & $asDatePart[2], 2)
		$sTempDate = StringReplace($sTempDate, "d", "@")
		$sTempDate = StringReplace($sTempDate, "m", "#")
		$sTempDate = StringReplace($sTempDate, "y", "&")
		$sTempDate = StringReplace($sTempDate, "@@@@", _DateDayOfWeek($iWday, 0))
		$sTempDate = StringReplace($sTempDate, "@@@", _DateDayOfWeek($iWday, 1))
		$sTempDate = StringReplace($sTempDate, "@@", $asDatePart[3])
		$sTempDate = StringReplace($sTempDate, "@", StringReplace(StringLeft($asDatePart[3], 1), "0", "") & StringRight($asDatePart[3], 1))
		$sTempDate = StringReplace($sTempDate, "####", _DateToMonth($asDatePart[2], 0))
		$sTempDate = StringReplace($sTempDate, "###", _DateToMonth($asDatePart[2], 1))
		$sTempDate = StringReplace($sTempDate, "##", $asDatePart[2])
		$sTempDate = StringReplace($sTempDate, "#", StringReplace(StringLeft($asDatePart[2], 1), "0", "") & StringRight($asDatePart[2], 1))
		$sTempDate = StringReplace($sTempDate, "&&&&", $asDatePart[1])
		$sTempDate = StringReplace($sTempDate, "&&", StringRight($asDatePart[1], 2))
	EndIf
	If $sTempTime <> "" Then
		$sTempString = _WinAPI_GetLocaleInfo($LOCALE_USER_DEFAULT, $LOCALE_S1159)
		If Not @error And Not ($sTempString = '') Then
			$sAM = $sTempString
		Else
			$sAM = "AM"
		EndIf
		$sTempString = _WinAPI_GetLocaleInfo($LOCALE_USER_DEFAULT, $LOCALE_S2359)
		If Not @error And Not ($sTempString = '') Then
			$sPM = $sTempString
		Else
			$sPM = "PM"
		EndIf
		$sTempString = _WinAPI_GetLocaleInfo($LOCALE_USER_DEFAULT, $LOCALE_STIME)
		If Not @error And Not ($sTempString = '') Then
			$sTempTime = StringReplace($sTempTime, ":", $sTempString)
		EndIf
		If StringInStr($sTempTime, "tt") Then
			If $asTimePart[1] < 12 Then
				$sTempTime = StringReplace($sTempTime, "tt", $sAM)
				If $asTimePart[1] = 0 Then $asTimePart[1] = 12
			Else
				$sTempTime = StringReplace($sTempTime, "tt", $sPM)
				If $asTimePart[1] > 12 Then $asTimePart[1] = $asTimePart[1] - 12
			EndIf
		EndIf
		$asTimePart[1] = StringRight("0" & $asTimePart[1], 2)
		$asTimePart[2] = StringRight("0" & $asTimePart[2], 2)
		$asTimePart[3] = StringRight("0" & $asTimePart[3], 2)
		$sTempTime = StringReplace($sTempTime, "hh", StringFormat("%02d", $asTimePart[1]))
		$sTempTime = StringReplace($sTempTime, "h", StringReplace(StringLeft($asTimePart[1], 1), "0", "") & StringRight($asTimePart[1], 1))
		$sTempTime = StringReplace($sTempTime, "mm", StringFormat("%02d", $asTimePart[2]))
		$sTempTime = StringReplace($sTempTime, "ss", StringFormat("%02d", $asTimePart[3]))
		$sTempDate = StringStripWS($sTempDate & " " & $sTempTime, $STR_STRIPLEADING + $STR_STRIPTRAILING)
	EndIf
	Return $sTempDate
EndFunc   ;==>_DateTimeFormat
Func _DateTimeSplit($sDate, ByRef $aDatePart, ByRef $aTimePart)
	Local $sDateTime = StringSplit($sDate, " T")
	If $sDateTime[0] > 0 Then $aDatePart = StringSplit($sDateTime[1], "/-.")
	Local $nFields = UBound($aDatePart)
	If $nFields <> 4 Then Return SetError(1, 0, 0)
	If $sDateTime[0] > 1 Then
		$aTimePart = StringSplit($sDateTime[2], ":")
		$nFields = UBound($aTimePart)
		If ($nFields < 3) Or ($nFields > 4) Then Return SetError(2, 0, 0)
		If $nFields < 4 Then
			ReDim $aTimePart[4]
			$aTimePart[3] = 0
		EndIf
	Else
		Dim $aTimePart[4]
		$aTimePart[0] = 0
	EndIf
	For $x = 1 To 3
		$aDatePart[$x] = Int($aDatePart[$x])
		$aTimePart[$x] = Int($aTimePart[$x])
	Next
	Return 1
EndFunc   ;==>_DateTimeSplit
Func _DateToDayOfWeek($iYear, $iMonth, $iDay)
	If Not _DateIsValid($iYear & "/" & $iMonth & "/" & $iDay) Then
		Return SetError(1, 0, "")
	EndIf
	Local $i_FactorA = Int((14 - $iMonth) / 12)
	Local $i_FactorY = $iYear - $i_FactorA
	Local $i_FactorM = $iMonth + (12 * $i_FactorA) - 2
	Local $i_FactorD = Mod($iDay + $i_FactorY + Int($i_FactorY / 4) - Int($i_FactorY / 100) + Int($i_FactorY / 400) + Int((31 * $i_FactorM) / 12), 7)
	Return $i_FactorD + 1
EndFunc   ;==>_DateToDayOfWeek
Func _DateToMonth($iMonNum, $iFormat = Default)
	If $iFormat = Default Then $iFormat = 0
	$iMonNum = Int($iMonNum)
	If Not __DateIsMonth($iMonNum) Then Return SetError(1, 0, "")
	Local $tSYSTEMTIME = DllStructCreate($tagSYSTEMTIME)
	DllStructSetData($tSYSTEMTIME, "Year", @YEAR)
	DllStructSetData($tSYSTEMTIME, "Month", $iMonNum)
	DllStructSetData($tSYSTEMTIME, "Day", 1)
	Return _WinAPI_GetDateFormat(BitAND($iFormat, $DMW_LOCALE_LONGNAME) ? $LOCALE_USER_DEFAULT : $LOCALE_INVARIANT, $tSYSTEMTIME, 0, BitAND($iFormat, $DMW_SHORTNAME) ? "MMM" : "MMMM")
EndFunc   ;==>_DateToMonth
Func _NowTime($sType = 3)
	If $sType < 3 Or $sType > 5 Then $sType = 3
	Local $tLocalTime = _Date_Time_GetLocalTime()
	If @error Then Return SetError(@error, @extended, "")
	Return _DateTimeFormat($tLocalTime.Year & "/" & $tLocalTime.Month & "/" & $tLocalTime.Day & " " & $tLocalTime.Hour & ":" & $tLocalTime.Minute & ":" & $tLocalTime.Second, $sType)
EndFunc   ;==>_NowTime
Func _DaysInMonth($iYear)
	Local $aDays = [12, 31, (_DateIsLeapYear($iYear) ? 29 : 28), 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]
	Return $aDays
EndFunc   ;==>_DaysInMonth
Func _Date_Time_GetLocalTime()
	Local $tLocalTime = DllStructCreate($tagSYSTEMTIME)
	DllCall("kernel32.dll", "none", "GetLocalTime", "struct*", $tLocalTime)
	If @error Then Return SetError(@error, @extended, 0)
	Return $tLocalTime
EndFunc   ;==>_Date_Time_GetLocalTime
Func _IsPressed($vKey = Default, $vDLL = Default, $bCheckModifierKey = False)
	Local Static $hDLL = Null
	If $vKey = Default Then
		If $hDLL = Null Then
			Return 0
		Else
			DllClose($hDLL)
			$hDLL = Null
			Return 1
		EndIf
	EndIf
	Local $bDefaultDll = ($vDLL = Default Or $vDLL = "user32.dll" Or $vDLL = "")
	If ($hDLL = Null) And $bDefaultDll Then $hDLL = DllOpen("user32.dll")
	If $bDefaultDll Then $vDLL = $hDLL
	Local Static $iKeyDown = 0x8000
	Local Static $aModifierKeys[6] = [0, $VK_SHIFT, $VK_CONTROL, $VK_MENU, $VK_LWIN, $VK_RWIN]
	If $bCheckModifierKey = Default Then $bCheckModifierKey = False
	If IsString($vKey) Then $vKey = "0x" & $vKey
	Local $aCall, $aKeys[1]
	If IsArray($vKey) Then
		$aKeys = $vKey
	Else
		$aKeys[0] = $vKey
	EndIf
	If $bCheckModifierKey Then
		For $i = 1 To 5
			If BitAND(DllCall($vDLL, "short", "GetAsyncKeyState", "int", $aModifierKeys[$i])[0], $iKeyDown) Then
				If $bCheckModifierKey == True Then
					Do
						Sleep(250)
					Until BitAND(DllCall($vDLL, "short", "GetAsyncKeyState", "int", $aModifierKeys[$i])[0], $iKeyDown) = 0
				EndIf
				Return SetExtended($i, 0)
			EndIf
		Next
	EndIf
	For $i = 0 To UBound($aKeys) - 1
		$aCall = DllCall($vDLL, "short", "GetAsyncKeyState", "int", $aKeys[$i])
		If BitAND($aCall[0], $iKeyDown) Then Return SetExtended(BitAND($aCall[0], 0x01), $i + 1)
	Next
	Return 0
EndFunc   ;==>_IsPressed
Func __GUICtrl_SendMsg($hWnd, $iMsg, $iIndex, ByRef $tItem, $tBuffer = 0, $bRetItem = False, $iElement = -1, $bRetBuffer = False, $iElementMax = $iElement)
	If $iElement > 0 Then
		DllStructSetData($tItem, $iElement, DllStructGetPtr($tBuffer))
		If $iElement = $iElementMax Then DllStructSetData($tItem, $iElement + 1, DllStructGetSize($tBuffer))
	EndIf
	Local $iRet
	If IsHWnd($hWnd) Then
		If ($hWnd = $__g_hGUICtrl_LastWnd) Or (DllCall("user32.dll", "dword", "GetWindowThreadProcessId", "hwnd", $hWnd, "dword*", 0)[2] = @AutoItPID) Then
			$__g_hGUICtrl_LastWnd = $hWnd
			$iRet = DllCall("user32.dll", "lresult", "SendMessageW", "hwnd", $hWnd, "uint", $iMsg, "wparam", $iIndex, "struct*", $tItem)[0]
		Else
			Local $iItem = Ceiling(DllStructGetSize($tItem) / 16) * 16
			Local $tMemMap, $pText
			Local $iBuffer = 0
			If ($iElement > 0) Or ($iElementMax = 0) Then $iBuffer = DllStructGetSize($tBuffer)
			Local $pMemory = _MemInit($hWnd, $iItem + $iBuffer, $tMemMap)
			If $iBuffer Then
				$pText = $pMemory + $iItem
				If $iElementMax Then
					DllStructSetData($tItem, $iElement, $pText)
				Else
					$iIndex = $pText
				EndIf
				_MemWrite($tMemMap, $tBuffer, $pText, $iBuffer)
			EndIf
			_MemWrite($tMemMap, $tItem, $pMemory, $iItem)
			$iRet = DllCall("user32.dll", "lresult", "SendMessageW", "hwnd", $hWnd, "uint", $iMsg, "wparam", $iIndex, "ptr", $pMemory)[0]
			If $iBuffer And $bRetBuffer Then
				_MemRead($tMemMap, $pText, $tBuffer, $iBuffer)
			EndIf
			If $bRetItem Then _MemRead($tMemMap, $pMemory, $tItem, $iItem)
			_MemFree($tMemMap)
		EndIf
	Else
		$iRet = GUICtrlSendMsg($hWnd, $iMsg, $iIndex, DllStructGetPtr($tItem))
	EndIf
	Return $iRet
EndFunc   ;==>__GUICtrl_SendMsg
Func __GUICtrl_GetNextGlobalID($hWnd)
	If DllCall("user32.dll", "dword", "GetWindowThreadProcessId", "hwnd", $hWnd, "dword*", 0)[2] <> @AutoItPID Then
		Return SetError(4, 0, 0)
	EndIf
	Local $nCtrlID, $iUsedIndex = -1, $bAllUsed = True
	If Not WinExists($hWnd) Then Return SetError(2, -1, 0)
	For $iIndex = 0 To $__GUICTRL_ID_MAX_WIN - 1
		If $__g_aGUICtrl_IDs_Used[$iIndex][0] <> 0 Then
			If Not WinExists($__g_aGUICtrl_IDs_Used[$iIndex][0]) Then
				For $x = 0 To UBound($__g_aGUICtrl_IDs_Used, 2) - 1
					$__g_aGUICtrl_IDs_Used[$iIndex][$x] = 0
				Next
				$__g_aGUICtrl_IDs_Used[$iIndex][1] = $__GUICTRL_STARTID
				$bAllUsed = False
			EndIf
		EndIf
	Next
	For $iIndex = 0 To $__GUICTRL_ID_MAX_WIN - 1
		If $__g_aGUICtrl_IDs_Used[$iIndex][0] = $hWnd Then
			$iUsedIndex = $iIndex
			ExitLoop
		EndIf
	Next
	If $iUsedIndex = -1 Then
		For $iIndex = 0 To $__GUICTRL_ID_MAX_WIN - 1
			If $__g_aGUICtrl_IDs_Used[$iIndex][0] = 0 Then
				$__g_aGUICtrl_IDs_Used[$iIndex][0] = $hWnd
				$__g_aGUICtrl_IDs_Used[$iIndex][1] = $__GUICTRL_STARTID
				$bAllUsed = False
				$iUsedIndex = $iIndex
				ExitLoop
			EndIf
		Next
	EndIf
	If $iUsedIndex = -1 And $bAllUsed Then Return SetError(16, 0, 0)
	If $__g_aGUICtrl_IDs_Used[$iUsedIndex][1] = ($__GUICTRL_STARTID + $__GUICTRL_ID_MAX_IDS) Then
		For $iIDIndex = $__GUICTRL_IDS_OFFSET To UBound($__g_aGUICtrl_IDs_Used, 2) - 1
			If $__g_aGUICtrl_IDs_Used[$iUsedIndex][$iIDIndex] = 0 Then
				$nCtrlID = ($iIDIndex - $__GUICTRL_IDS_OFFSET) + $__GUICTRL_STARTID
				$__g_aGUICtrl_IDs_Used[$iUsedIndex][$iIDIndex] = $nCtrlID
				Return $nCtrlID
			EndIf
		Next
		Return SetError(8, $__GUICTRL_ID_MAX_IDS, 0)
	EndIf
	$nCtrlID = $__g_aGUICtrl_IDs_Used[$iUsedIndex][1]
	$__g_aGUICtrl_IDs_Used[$iUsedIndex][1] += 1
	$__g_aGUICtrl_IDs_Used[$iUsedIndex][($nCtrlID - $__GUICTRL_STARTID) + $__GUICTRL_IDS_OFFSET] = $nCtrlID
	Return $nCtrlID
EndFunc   ;==>__GUICtrl_GetNextGlobalID
Func _GUICtrlStatusBar_Create($hWnd, $vPartEdge = -1, $vPartText = "", $iStyles = -1, $iExStyles = 0x00000000)
	If Not IsHWnd($hWnd) Then Return SetError(1, 0, 0)
	Local $iStyle = BitOR($__GUICTRLCONSTANT_WS_CHILD, $__GUICTRLCONSTANT_WS_VISIBLE)
	If $iStyles = -1 Then $iStyles = 0x00000000
	If $iExStyles = -1 Then $iExStyles = 0x00000000
	Local $aPartWidth[1], $aPartText[1]
	If @NumParams > 1 Then
		If IsArray($vPartEdge) Then
			$aPartWidth = $vPartEdge
		Else
			$aPartWidth[0] = $vPartEdge
		EndIf
		If @NumParams = 2 Then
			ReDim $aPartText[UBound($aPartWidth)]
		Else
			If IsArray($vPartText) Then
				$aPartText = $vPartText
			Else
				$aPartText[0] = $vPartText
			EndIf
			If UBound($aPartWidth) <> UBound($aPartText) Then
				Local $iLast
				If UBound($aPartWidth) > UBound($aPartText) Then
					$iLast = UBound($aPartText)
					ReDim $aPartText[UBound($aPartWidth)]
				Else
					$iLast = UBound($aPartWidth)
					ReDim $aPartWidth[UBound($aPartText)]
					For $x = $iLast To UBound($aPartWidth) - 1
						$aPartWidth[$x] = $aPartWidth[$x - 1] + 75
					Next
					$aPartWidth[UBound($aPartText) - 1] = -1
				EndIf
			EndIf
		EndIf
		If Not IsHWnd($hWnd) Then $hWnd = HWnd($hWnd)
		If @NumParams > 3 Then $iStyle = BitOR($iStyle, $iStyles)
	EndIf
	Local $nCtrlID = __GUICtrl_GetNextGlobalID($hWnd)
	If @error Then Return SetError(@error, @extended, 0)
	Local $hWndSBar = _WinAPI_CreateWindowEx($iExStyles, $__STATUSBARCONSTANT_ClassName, "", $iStyle, 0, 0, 0, 0, $hWnd, $nCtrlID)
	If @error Then Return SetError(@error + 10, @extended, 0)
	If @NumParams > 1 Then
		_GUICtrlStatusBar_SetParts($hWndSBar, UBound($aPartWidth), $aPartWidth)
		For $x = 0 To UBound($aPartText) - 1
			_GUICtrlStatusBar_SetText($hWndSBar, $aPartText[$x], $x)
		Next
	EndIf
	Return $hWndSBar
EndFunc   ;==>_GUICtrlStatusBar_Create
Func _GUICtrlStatusBar_GetUnicodeFormat($hWnd)
	If Not _WinAPI_IsClassName($hWnd, $__STATUSBARCONSTANT_ClassName) Then Return SetError(2, 0, False)
	If Not IsDllStruct($__g_tSBBuffer) Then
		$__g_tSBBuffer = DllStructCreate("wchar Text[4096]")
		$__g_tSBBufferANSI = DllStructCreate("char Text[4096]", DllStructGetPtr($__g_tSBBuffer))
	EndIf
	Return _SendMessage($hWnd, $SB_GETUNICODEFORMAT) <> 0
EndFunc   ;==>_GUICtrlStatusBar_GetUnicodeFormat
Func _GUICtrlStatusBar_IsSimple($hWnd)
	If Not _WinAPI_IsClassName($hWnd, $__STATUSBARCONSTANT_ClassName) Then Return SetError(2, 0, False)
	Return _SendMessage($hWnd, $SB_ISSIMPLE) <> 0
EndFunc   ;==>_GUICtrlStatusBar_IsSimple
Func _GUICtrlStatusBar_Resize($hWnd)
	If Not _WinAPI_IsClassName($hWnd, $__STATUSBARCONSTANT_ClassName) Then Return SetError(2, 0, False)
	_SendMessage($hWnd, $__STATUSBARCONSTANT_WM_SIZE)
EndFunc   ;==>_GUICtrlStatusBar_Resize
Func _GUICtrlStatusBar_SetParts($hWnd, $vPartEdge = -1, $vPartWidth = 25)
	If Not _WinAPI_IsClassName($hWnd, $__STATUSBARCONSTANT_ClassName) Then Return SetError(2, 0, False)
	If IsArray($vPartEdge) And IsArray($vPartWidth) Then Return False
	Local $tParts, $iParts
	If IsArray($vPartEdge) Then
		$vPartEdge[UBound($vPartEdge) - 1] = -1
		$iParts = UBound($vPartEdge)
		$tParts = DllStructCreate("int[" & $iParts & "]")
		For $x = 0 To $iParts - 2
			DllStructSetData($tParts, 1, $vPartEdge[$x], $x + 1)
		Next
		DllStructSetData($tParts, 1, -1, $iParts)
	Else
		If $vPartEdge < -1 Then Return False
		If IsArray($vPartWidth) Then
			$iParts = UBound($vPartWidth)
			$tParts = DllStructCreate("int[" & $iParts & "]")
			Local $iPartRightEdge = 0
			For $x = 0 To $iParts - 2
				$iPartRightEdge += $vPartWidth[$x]
				If $vPartWidth[$x] <= 0 Then Return False
				DllStructSetData($tParts, 1, $iPartRightEdge, $x + 1)
			Next
			DllStructSetData($tParts, 1, -1, $iParts)
		ElseIf $vPartEdge > 1 Then
			$iParts = $vPartEdge
			$tParts = DllStructCreate("int[" & $iParts & "]")
			For $x = 1 To $iParts - 1
				DllStructSetData($tParts, 1, $vPartWidth * $x, $x)
			Next
			DllStructSetData($tParts, 1, -1, $iParts)
		Else
			$iParts = 1
			$tParts = DllStructCreate("int")
			DllStructSetData($tParts, 1, -1)
		EndIf
	EndIf
	__GUICtrl_SendMsg($hWnd, $SB_SETPARTS, $iParts, $tParts)
	_GUICtrlStatusBar_Resize($hWnd)
	Return True
EndFunc   ;==>_GUICtrlStatusBar_SetParts
Func _GUICtrlStatusBar_SetText($hWnd, $sText = "", $iPart = 0, $iUFlag = 0)
	If Not _WinAPI_IsClassName($hWnd, $__STATUSBARCONSTANT_ClassName) Then Return SetError(2, 0, False)
	Local $iBuffer = StringLen($sText) + 1
	Local $tText, $iMsg
	If _GUICtrlStatusBar_GetUnicodeFormat($hWnd) Then
		$tText = DllStructCreate("wchar Text[" & $iBuffer & "]")
		$iMsg = $SB_SETTEXTW
	Else
		$tText = DllStructCreate("char Text[" & $iBuffer & "]")
		$iMsg = $SB_SETTEXT
	EndIf
	DllStructSetData($tText, "Text", $sText)
	If _GUICtrlStatusBar_IsSimple($hWnd) Then $iPart = $SB_SIMPLEID
	Local $iRet = __GUICtrl_SendMsg($hWnd, $iMsg, BitOR($iPart, $iUFlag), $tText)
	Return $iRet <> 0
EndFunc   ;==>_GUICtrlStatusBar_SetText
Func _GUICtrlEdit_SetSel($hWnd, $iStart, $iEnd)
	If Not IsHWnd($hWnd) Then $hWnd = GUICtrlGetHandle($hWnd)
	_SendMessage($hWnd, $EM_SETSEL, $iStart, $iEnd)
EndFunc   ;==>_GUICtrlEdit_SetSel
Func _GUICtrlComboBox_SetCurSel($hWnd, $iIndex = -1)
	If Not IsHWnd($hWnd) Then $hWnd = GUICtrlGetHandle($hWnd)
	Return _SendMessage($hWnd, $CB_SETCURSEL, $iIndex)
EndFunc   ;==>_GUICtrlComboBox_SetCurSel
